# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .chat_completion_message_function_tool_call import ChatCompletionMessageFunctionToolCall
from .message_content_item import MessageContentItem
from .message_role import MessageRole
from .tool_return import ToolReturn


class Message(UncheckedBaseModel):
    """
        Letta's internal representation of a message. Includes methods to convert to/from LLM provider formats.

        Attributes:
            id (str): The unique identifier of the message.
            role (MessageRole): The role of the participant.
            text (str): The text of the message.
            user_id (str): The unique identifier of the user.
            agent_id (str): The unique identifier of the agent.
            model (str): The model used to make the function call.
            name (str): The name of the participant.
            created_at (datetime): The time the message was created.
            tool_calls (List[OpenAIToolCall,]): The list of tool calls requested.
            tool_call_id (str): The id of the tool call.
            step_id (str): The id of the step that this message was created in.
            otid (str): The offline threading id associated with this message.
            tool_returns (List[ToolReturn]): The list of tool returns requested.
            group_id (str): The multi-agent group that the message was sent in.
            sender_id (str): The id of the sender of the message, can be an identity id or agent id.
    t
    """

    created_by_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the user that made this object.
    """

    last_updated_by_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the user that made this object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the object was created.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the object was last updated.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The human-friendly ID of the Message
    """

    agent_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the agent.
    """

    model: typing.Optional[str] = pydantic.Field(default=None)
    """
    The model used to make the function call.
    """

    role: MessageRole = pydantic.Field()
    """
    The role of the participant.
    """

    content: typing.Optional[typing.List[MessageContentItem]] = pydantic.Field(default=None)
    """
    The content of the message.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    For role user/assistant: the (optional) name of the participant. For role tool/function: the name of the function called.
    """

    tool_calls: typing.Optional[typing.List[ChatCompletionMessageFunctionToolCall]] = pydantic.Field(default=None)
    """
    The list of tool calls requested. Only applicable for role assistant.
    """

    tool_call_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID of the tool call. Only applicable for role tool.
    """

    step_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the step that this message was created in.
    """

    otid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The offline threading id associated with this message
    """

    tool_returns: typing.Optional[typing.List[ToolReturn]] = pydantic.Field(default=None)
    """
    Tool execution return information for prior tool calls
    """

    group_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The multi-agent group that the message was sent in
    """

    sender_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the sender of the message, can be an identity id or agent id
    """

    batch_item_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the LLMBatchItem that this message is associated with
    """

    is_err: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this message is part of an error step. Used only for debugging purposes.
    """

    approval_request_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the approval request if this message is associated with a tool call request.
    """

    approve: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether tool call is approved.
    """

    denial_reason: typing.Optional[str] = pydantic.Field(default=None)
    """
    The reason the tool call request was denied.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
