# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .summarized_reasoning_content_part import SummarizedReasoningContentPart


class SummarizedReasoningContent(UncheckedBaseModel):
    """
    The style of reasoning content returned by the OpenAI Responses API
    """

    type: typing.Literal["summarized_reasoning"] = "summarized_reasoning"
    id: str = pydantic.Field()
    """
    The unique identifier for this reasoning step.
    """

    summary: typing.List[SummarizedReasoningContentPart] = pydantic.Field()
    """
    Summaries of the reasoning content.
    """

    encrypted_content: typing.Optional[str] = pydantic.Field(default=None)
    """
    The encrypted reasoning content.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
