# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class UpdateStreamableHttpmcpServer(UncheckedBaseModel):
    """
    Update a Streamable HTTP MCP server
    """

    server_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL path for the streamable HTTP server (e.g., 'example/mcp')
    """

    auth_header: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the authentication header (e.g., 'Authorization')
    """

    auth_token: typing.Optional[str] = pydantic.Field(default=None)
    """
    The authentication token or API key value
    """

    custom_headers: typing.Optional[typing.Dict[str, typing.Optional[str]]] = pydantic.Field(default=None)
    """
    Custom authentication headers as key-value pairs
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
