# The pygsfit Package

pygsfit is a widget-based tool to visualize and analyze high-dimensional radio spectral imaging data. It also performs spectral fitting based on the gyrosynchrotron and thermal emission model. 

[![Build Status](https://img.shields.io/travis/com/jacebrowning/template-python.svg)](https://travis-ci.com/jacebrowning/template-python)

## Required Packages
* Python >=3.6
* Matplotlib >=3.3.4
* Numpy >=1.19.5
* PyQT5 >=5.15.4 (https://pypi.org/project/PyQt5/)
* PyQTGraph >=0.11.0 (https://www.pyqtgraph.org)
* SciPy >=1.5.4 (https://www.scipy.org/)
* AstroPy >=4.1 (https://www.astropy.org/)
* SunPy >=3.0.1 (https://sunpy.org/)
* lmfit >=1.0.2 (https://lmfit.github.io/lmfit-py/)
* Regions >=0.5 (https://astropy-regions.readthedocs.io/en/stable/; better to install it using `pip install regions --no-deps`)
* Compiled library for computing microwave gyrosynchrotron and thermal emission using the fast codes (two copied compiled under MacOS and Windows are included in the "binaries" folder. See https://github.com/kuznetsov-radio/gyrosynchrotron for the source codes written in C++.)

## Installation

Install `pygsfit` (to be implemented):

```
$ pip install pygsfit
```

## Upgrade
Upgrade `pygsfit` (to be implemented):

```
$ pip install pygsfit --upgrade
```

## Examples

To be added.