/* Computation of the thermally averaged Gaunt factor and the corresponding Coulomb logarithm (for a hydrogen-like atom),
   according to the method and data presented in the paper of van Hoof et al. (MNRAS, 444, 420, 2014). */

#include <math.h>
#include "Plasma.h"
#include "ExtMath.h"

#define N_u 146     //number of grid points in u direction
#define N_g2 81     //number of grid points in gam2 direction
#define s_u (-16.0) //start value for lg(u)
#define s_g2 (-6.0) //start value for lg(gam2)
#define d 0.2       //step size in both directions

#define k_u (hPl/kB)
#define k_g2 (em_alpha*em_alpha*me*c*c/2/kB)

const double g_arr[N_u][N_g2]=
{{ 2.07575626e+01, 2.07575534e+01, 2.07575461e+01, 2.07575356e+01, 2.07574693e+01, 2.07574982e+01, 2.07574554e+01, 2.07573579e+01, 2.07572489e+01, 2.07571156e+01, 2.07569788e+01, 2.07566758e+01, 2.07561962e+01, 2.07555273e+01, 2.07545494e+01, 2.07531552e+01, 2.07510518e+01, 2.07479516e+01, 2.07435402e+01, 2.07372375e+01, 2.07283663e+01, 2.07159124e+01, 2.06988104e+01, 2.06756021e+01, 2.06447166e+01, 2.06044827e+01, 2.05534511e+01, 2.04904301e+01, 2.04148842e+01, 2.03271606e+01, 2.02284817e+01, 2.01207789e+01, 2.00063060e+01, 1.98870884e+01, 1.97648252e+01, 1.96407584e+01, 1.95155983e+01, 1.93897576e+01, 1.92634294e+01, 1.91369622e+01, 1.90103062e+01, 1.88834698e+01, 1.87566653e+01, 1.86298129e+01, 1.85028672e+01, 1.83759509e+01, 1.82490543e+01, 1.81220546e+01, 1.79951553e+01, 1.78682402e+01, 1.77412558e+01, 1.76142953e+01, 1.74873668e+01, 1.73604310e+01, 1.72334985e+01, 1.71065390e+01, 1.69795854e+01, 1.68526640e+01, 1.67256651e+01, 1.65987622e+01, 1.64717838e+01, 1.63448470e+01, 1.62179146e+01, 1.60909597e+01, 1.59640118e+01, 1.58370491e+01, 1.57101233e+01, 1.55831781e+01, 1.54562387e+01, 1.53292472e+01, 1.52023396e+01, 1.50753750e+01, 1.49484420e+01, 1.48215063e+01, 1.46945692e+01, 1.45675678e+01, 1.44406608e+01, 1.43136944e+01, 1.41867447e+01, 1.40598075e+01, 1.39328683e+01},
 { 2.05036528e+01, 2.05036480e+01, 2.05036407e+01, 2.05036175e+01, 2.05036006e+01, 2.05035695e+01, 2.05035357e+01, 2.05034704e+01, 2.05033818e+01, 2.05032577e+01, 2.05030551e+01, 2.05027511e+01, 2.05023037e+01, 2.05016501e+01, 2.05006727e+01, 2.04992342e+01, 2.04971230e+01, 2.04940744e+01, 2.04896581e+01, 2.04833921e+01, 2.04744959e+01, 2.04620643e+01, 2.04449380e+01, 2.04216979e+01, 2.03908457e+01, 2.03506592e+01, 2.02996050e+01, 2.02365724e+01, 2.01610259e+01, 2.00733019e+01, 1.99745887e+01, 1.98668770e+01, 1.97524146e+01, 1.96331597e+01, 1.95109656e+01, 1.93868639e+01, 1.92617155e+01, 1.91357986e+01, 1.90095905e+01, 1.88830500e+01, 1.87563534e+01, 1.86296009e+01, 1.85027941e+01, 1.83758782e+01, 1.82489837e+01, 1.81220629e+01, 1.79951194e+01, 1.78681683e+01, 1.77412926e+01, 1.76143067e+01, 1.74873471e+01, 1.73604193e+01, 1.72334839e+01, 1.71065513e+01, 1.69795577e+01, 1.68526265e+01, 1.67257171e+01, 1.65987277e+01, 1.64717993e+01, 1.63448373e+01, 1.62178955e+01, 1.60909679e+01, 1.59640167e+01, 1.58370652e+01, 1.57101026e+01, 1.55831719e+01, 1.54562360e+01, 1.53292920e+01, 1.52023353e+01, 1.50753994e+01, 1.49484285e+01, 1.48214777e+01, 1.46945196e+01, 1.45676224e+01, 1.44406307e+01, 1.43137164e+01, 1.41867480e+01, 1.40597984e+01, 1.39328612e+01, 1.38059217e+01, 1.36789688e+01},
 { 2.02497421e+01, 2.02497373e+01, 2.02497300e+01, 2.02497077e+01, 2.02497207e+01, 2.02496842e+01, 2.02496314e+01, 2.02495855e+01, 2.02494970e+01, 2.02493757e+01, 2.02491649e+01, 2.02488663e+01, 2.02484310e+01, 2.02477677e+01, 2.02467907e+01, 2.02453521e+01, 2.02432487e+01, 2.02401935e+01, 2.02357552e+01, 2.02295111e+01, 2.02205687e+01, 2.02081258e+01, 2.01910156e+01, 2.01677847e+01, 2.01369167e+01, 2.00967264e+01, 2.00457370e+01, 1.99827049e+01, 1.99071585e+01, 1.98194347e+01, 1.97207627e+01, 1.96130191e+01, 1.94985008e+01, 1.93792802e+01, 1.92570523e+01, 1.91329782e+01, 1.90077670e+01, 1.88819592e+01, 1.87556740e+01, 1.86291446e+01, 1.85024946e+01, 1.83757402e+01, 1.82488556e+01, 1.81219649e+01, 1.79950895e+01, 1.78681727e+01, 1.77412583e+01, 1.76143392e+01, 1.74873626e+01, 1.73604314e+01, 1.72334712e+01, 1.71065364e+01, 1.69796038e+01, 1.68526110e+01, 1.67256797e+01, 1.65987308e+01, 1.64717883e+01, 1.63448526e+01, 1.62179019e+01, 1.60909544e+01, 1.59640212e+01, 1.58370665e+01, 1.57101188e+01, 1.55831860e+01, 1.54562254e+01, 1.53292895e+01, 1.52023521e+01, 1.50753546e+01, 1.49484529e+01, 1.48215163e+01, 1.46945241e+01, 1.45675732e+01, 1.44406551e+01, 1.43137014e+01, 1.41867700e+01, 1.40598110e+01, 1.39328576e+01, 1.38059150e+01, 1.36789752e+01, 1.35520224e+01, 1.34250670e+01},
 { 1.99958725e+01, 1.99958677e+01, 1.99958658e+01, 1.99958563e+01, 1.99958020e+01, 1.99957635e+01, 1.99957396e+01, 1.99956808e+01, 1.99955990e+01, 1.99954441e+01, 1.99952571e+01, 1.99949599e+01, 1.99945208e+01, 1.99938590e+01, 1.99928807e+01, 1.99914334e+01, 1.99893384e+01, 1.99862605e+01, 1.99818688e+01, 1.99755771e+01, 1.99666698e+01, 1.99542245e+01, 1.99371405e+01, 1.99138810e+01, 1.98830446e+01, 1.98428609e+01, 1.97918281e+01, 1.97287615e+01, 1.96532154e+01, 1.95655013e+01, 1.94668245e+01, 1.93591447e+01, 1.92446232e+01, 1.91254008e+01, 1.90031692e+01, 1.88790674e+01, 1.87538988e+01, 1.86280796e+01, 1.85017688e+01, 1.83752777e+01, 1.82486278e+01, 1.81218106e+01, 1.79949508e+01, 1.78681357e+01, 1.77411946e+01, 1.76142946e+01, 1.74873159e+01, 1.73603974e+01, 1.72334804e+01, 1.71065324e+01, 1.69795814e+01, 1.68526560e+01, 1.67256641e+01, 1.65987327e+01, 1.64717840e+01, 1.63448418e+01, 1.62179149e+01, 1.60909599e+01, 1.59640080e+01, 1.58370448e+01, 1.57101235e+01, 1.55831725e+01, 1.54562096e+01, 1.53292788e+01, 1.52023460e+01, 1.50754053e+01, 1.49484083e+01, 1.48215004e+01, 1.46945355e+01, 1.45675777e+01, 1.44406379e+01, 1.43137044e+01, 1.41867550e+01, 1.40598005e+01, 1.39328676e+01, 1.38059113e+01, 1.36789223e+01, 1.35520319e+01, 1.34250760e+01, 1.32981207e+01, 1.31711882e+01},
 { 1.97419688e+01, 1.97419640e+01, 1.97419637e+01, 1.97419460e+01, 1.97419228e+01, 1.97418972e+01, 1.97418636e+01, 1.97418049e+01, 1.97417226e+01, 1.97415841e+01, 1.97413842e+01, 1.97410901e+01, 1.97406433e+01, 1.97399825e+01, 1.97390043e+01, 1.97375654e+01, 1.97354619e+01, 1.97323708e+01, 1.97280135e+01, 1.97216767e+01, 1.97128027e+01, 1.97003502e+01, 1.96832449e+01, 1.96600072e+01, 1.96291279e+01, 1.95889543e+01, 1.95378932e+01, 1.94748607e+01, 1.93993142e+01, 1.93116040e+01, 1.92129755e+01, 1.91052637e+01, 1.89907406e+01, 1.88715278e+01, 1.87492962e+01, 1.86251834e+01, 1.85000012e+01, 1.83741412e+01, 1.82478676e+01, 1.81214110e+01, 1.79946940e+01, 1.78679262e+01, 1.77410863e+01, 1.76142056e+01, 1.74873133e+01, 1.73603416e+01, 1.72334401e+01, 1.71065008e+01, 1.69795632e+01, 1.68526323e+01, 1.67257131e+01, 1.65987256e+01, 1.64717854e+01, 1.63448370e+01, 1.62178952e+01, 1.60909680e+01, 1.59640132e+01, 1.58370658e+01, 1.57101032e+01, 1.55831768e+01, 1.54562320e+01, 1.53292925e+01, 1.52023322e+01, 1.50753966e+01, 1.49484585e+01, 1.48214710e+01, 1.46945540e+01, 1.45675890e+01, 1.44406385e+01, 1.43136804e+01, 1.41867579e+01, 1.40598044e+01, 1.39328163e+01, 1.38059211e+01, 1.36789636e+01, 1.35520458e+01, 1.34250854e+01, 1.32981326e+01, 1.31711996e+01, 1.30442417e+01, 1.29172852e+01},
 { 1.94880544e+01, 1.94880646e+01, 1.94880574e+01, 1.94880643e+01, 1.94880401e+01, 1.94880219e+01, 1.94879830e+01, 1.94879286e+01, 1.94878362e+01, 1.94877083e+01, 1.94875025e+01, 1.94871523e+01, 1.94867618e+01, 1.94861000e+01, 1.94851232e+01, 1.94836276e+01, 1.94815301e+01, 1.94785210e+01, 1.94741175e+01, 1.94678321e+01, 1.94589360e+01, 1.94464521e+01, 1.94293416e+01, 1.94061089e+01, 1.93752425e+01, 1.93350524e+01, 1.92840208e+01, 1.92209890e+01, 1.91454487e+01, 1.90577251e+01, 1.89590228e+01, 1.88513017e+01, 1.87367932e+01, 1.86175761e+01, 1.84953523e+01, 1.83712710e+01, 1.82460963e+01, 1.81202702e+01, 1.79940380e+01, 1.78674838e+01, 1.77408095e+01, 1.76140327e+01, 1.74871962e+01, 1.73603315e+01, 1.72333686e+01, 1.71064867e+01, 1.69795306e+01, 1.68526101e+01, 1.67256505e+01, 1.65987398e+01, 1.64717777e+01, 1.63448507e+01, 1.62179006e+01, 1.60909485e+01, 1.59640210e+01, 1.58370664e+01, 1.57101188e+01, 1.55831566e+01, 1.54562255e+01, 1.53292897e+01, 1.52023458e+01, 1.50753890e+01, 1.49484531e+01, 1.48215118e+01, 1.46945157e+01, 1.45676075e+01, 1.44406513e+01, 1.43136921e+01, 1.41867548e+01, 1.40598154e+01, 1.39328621e+01, 1.38058701e+01, 1.36789786e+01, 1.35520256e+01, 1.34250991e+01, 1.32981090e+01, 1.31712100e+01, 1.30442530e+01, 1.29172983e+01, 1.27903560e+01, 1.26634187e+01},
 { 1.92342031e+01, 1.92342011e+01, 1.92341266e+01, 1.92341474e+01, 1.92341305e+01, 1.92341093e+01, 1.92340929e+01, 1.92339746e+01, 1.92339457e+01, 1.92337536e+01, 1.92335725e+01, 1.92332505e+01, 1.92328078e+01, 1.92321460e+01, 1.92311874e+01, 1.92297257e+01, 1.92276590e+01, 1.92246177e+01, 1.92202060e+01, 1.92139138e+01, 1.92050123e+01, 1.91925940e+01, 1.91754732e+01, 1.91522576e+01, 1.91213785e+01, 1.90811797e+01, 1.90301471e+01, 1.89670988e+01, 1.88915632e+01, 1.88038317e+01, 1.87051547e+01, 1.85974284e+01, 1.84829244e+01, 1.83637069e+01, 1.82414402e+01, 1.81174010e+01, 1.79921947e+01, 1.78664034e+01, 1.77401015e+01, 1.76136030e+01, 1.74868744e+01, 1.73601425e+01, 1.72333172e+01, 1.71063907e+01, 1.69795031e+01, 1.68525672e+01, 1.67256464e+01, 1.65987294e+01, 1.64717889e+01, 1.63448454e+01, 1.62179080e+01, 1.60909529e+01, 1.59640066e+01, 1.58370057e+01, 1.57101195e+01, 1.55831723e+01, 1.54562100e+01, 1.53292789e+01, 1.52023432e+01, 1.50754057e+01, 1.49484090e+01, 1.48215066e+01, 1.46945698e+01, 1.45675783e+01, 1.44406612e+01, 1.43136959e+01, 1.41867457e+01, 1.40597641e+01, 1.39328688e+01, 1.38059157e+01, 1.36789611e+01, 1.35520281e+01, 1.34250792e+01, 1.32981467e+01, 1.31711914e+01, 1.30442633e+01, 1.29172874e+01, 1.27903377e+01, 1.26634096e+01, 1.25364764e+01, 1.24094926e+01},
 { 1.89803014e+01, 1.89802776e+01, 1.89802579e+01, 1.89802697e+01, 1.89802285e+01, 1.89802038e+01, 1.89801989e+01, 1.89801064e+01, 1.89800517e+01, 1.89798849e+01, 1.89796973e+01, 1.89794180e+01, 1.89789722e+01, 1.89783117e+01, 1.89772890e+01, 1.89758797e+01, 1.89737627e+01, 1.89707076e+01, 1.89663174e+01, 1.89600261e+01, 1.89511284e+01, 1.89386861e+01, 1.89215708e+01, 1.88983650e+01, 1.88674858e+01, 1.88272952e+01, 1.87762364e+01, 1.87132375e+01, 1.86376232e+01, 1.85499699e+01, 1.84512567e+01, 1.83435811e+01, 1.82290626e+01, 1.81098494e+01, 1.79876135e+01, 1.78635435e+01, 1.77383646e+01, 1.76124768e+01, 1.74862164e+01, 1.73596994e+01, 1.72330190e+01, 1.71062170e+01, 1.69793769e+01, 1.68525139e+01, 1.67256066e+01, 1.65986898e+01, 1.64717721e+01, 1.63448311e+01, 1.62178899e+01, 1.60909586e+01, 1.59640079e+01, 1.58370733e+01, 1.57100588e+01, 1.55831760e+01, 1.54562317e+01, 1.53292634e+01, 1.52023322e+01, 1.50753967e+01, 1.49484589e+01, 1.48214627e+01, 1.46945541e+01, 1.45675897e+01, 1.44406319e+01, 1.43136925e+01, 1.41867582e+01, 1.40597993e+01, 1.39328624e+01, 1.38059223e+01, 1.36789721e+01, 1.35520147e+01, 1.34250816e+01, 1.32981246e+01, 1.31712058e+01, 1.30442449e+01, 1.29173026e+01, 1.27903698e+01, 1.26633915e+01, 1.25364645e+01, 1.24095124e+01, 1.22825466e+01, 1.21556235e+01},
 { 1.87264075e+01, 1.87263683e+01, 1.87263447e+01, 1.87263880e+01, 1.87263274e+01, 1.87263018e+01, 1.87263052e+01, 1.87262054e+01, 1.87261580e+01, 1.87259934e+01, 1.87257936e+01, 1.87255240e+01, 1.87250782e+01, 1.87244226e+01, 1.87234444e+01, 1.87219715e+01, 1.87198643e+01, 1.87168109e+01, 1.87123996e+01, 1.87061201e+01, 1.86972165e+01, 1.86847900e+01, 1.86676639e+01, 1.86444505e+01, 1.86135719e+01, 1.85733820e+01, 1.85223506e+01, 1.84592811e+01, 1.83837557e+01, 1.82960321e+01, 1.81973518e+01, 1.80896438e+01, 1.79751255e+01, 1.78559164e+01, 1.77336770e+01, 1.76096110e+01, 1.74844350e+01, 1.73585954e+01, 1.72322823e+01, 1.71058093e+01, 1.69791463e+01, 1.68523320e+01, 1.67255121e+01, 1.65986175e+01, 1.64717166e+01, 1.63447768e+01, 1.62178783e+01, 1.60909368e+01, 1.59639434e+01, 1.58370633e+01, 1.57101251e+01, 1.55831908e+01, 1.54561941e+01, 1.53292848e+01, 1.52023457e+01, 1.50753888e+01, 1.49484502e+01, 1.48215120e+01, 1.46945163e+01, 1.45676077e+01, 1.44406431e+01, 1.43136926e+01, 1.41867554e+01, 1.40598117e+01, 1.39328584e+01, 1.38058717e+01, 1.36789758e+01, 1.35520229e+01, 1.34250682e+01, 1.32981381e+01, 1.31711783e+01, 1.30442592e+01, 1.29172704e+01, 1.27903698e+01, 1.26634232e+01, 1.25364392e+01, 1.24095169e+01, 1.22825661e+01, 1.21556150e+01, 1.20286612e+01, 1.19017241e+01},
 { 1.84724885e+01, 1.84724921e+01, 1.84724432e+01, 1.84724737e+01, 1.84724494e+01, 1.84724228e+01, 1.84723664e+01, 1.84723248e+01, 1.84722450e+01, 1.84721193e+01, 1.84719194e+01, 1.84716042e+01, 1.84711585e+01, 1.84705052e+01, 1.84695343e+01, 1.84680892e+01, 1.84659858e+01, 1.84629489e+01, 1.84585277e+01, 1.84522409e+01, 1.84433388e+01, 1.84309131e+01, 1.84137945e+01, 1.83905790e+01, 1.83596988e+01, 1.83194998e+01, 1.82684715e+01, 1.82054390e+01, 1.81298079e+01, 1.80421164e+01, 1.79434071e+01, 1.78356955e+01, 1.77212497e+01, 1.76019599e+01, 1.74798006e+01, 1.73557262e+01, 1.72305607e+01, 1.71046515e+01, 1.69784265e+01, 1.68518838e+01, 1.67252071e+01, 1.65984459e+01, 1.64716133e+01, 1.63447326e+01, 1.62178035e+01, 1.60909147e+01, 1.59639844e+01, 1.58370542e+01, 1.57101124e+01, 1.55831719e+01, 1.54562359e+01, 1.53292467e+01, 1.52023383e+01, 1.50753761e+01, 1.49484419e+01, 1.48215064e+01, 1.46945699e+01, 1.45675699e+01, 1.44406612e+01, 1.43136966e+01, 1.41867461e+01, 1.40598091e+01, 1.39328691e+01, 1.38059160e+01, 1.36789255e+01, 1.35520323e+01, 1.34250794e+01, 1.32981218e+01, 1.31711887e+01, 1.30442320e+01, 1.29173166e+01, 1.27903243e+01, 1.26634231e+01, 1.25364485e+01, 1.24094992e+01, 1.22825705e+01, 1.21556164e+01, 1.20286655e+01, 1.19017151e+01, 1.17747811e+01, 1.16478356e+01},
 { 1.82185777e+01, 1.82185960e+01, 1.82186097e+01, 1.82185547e+01, 1.82185522e+01, 1.82185302e+01, 1.82184972e+01, 1.82184162e+01, 1.82183427e+01, 1.82182094e+01, 1.82180096e+01, 1.82177114e+01, 1.82172783e+01, 1.82166165e+01, 1.82156522e+01, 1.82142076e+01, 1.82121096e+01, 1.82090557e+01, 1.82046565e+01, 1.81983528e+01, 1.81894621e+01, 1.81770310e+01, 1.81599094e+01, 1.81366948e+01, 1.81058158e+01, 1.80656254e+01, 1.80145563e+01, 1.79515278e+01, 1.78760205e+01, 1.77882936e+01, 1.76896197e+01, 1.75819080e+01, 1.74673551e+01, 1.73481720e+01, 1.72259065e+01, 1.71017926e+01, 1.69766207e+01, 1.68507859e+01, 1.67245078e+01, 1.65979992e+01, 1.64713415e+01, 1.63445496e+01, 1.62177138e+01, 1.60907876e+01, 1.59639446e+01, 1.58370210e+01, 1.57100968e+01, 1.55831545e+01, 1.54562253e+01, 1.53292865e+01, 1.52023314e+01, 1.50753881e+01, 1.49484289e+01, 1.48214780e+01, 1.46945212e+01, 1.45676229e+01, 1.44406323e+01, 1.43136932e+01, 1.41867501e+01, 1.40597997e+01, 1.39328629e+01, 1.38059225e+01, 1.36789696e+01, 1.35520153e+01, 1.34250819e+01, 1.32981330e+01, 1.31712006e+01, 1.30442452e+01, 1.29172857e+01, 1.27903660e+01, 1.26633781e+01, 1.25364362e+01, 1.24095022e+01, 1.22825531e+01, 1.21555971e+01, 1.20286739e+01, 1.19017196e+01, 1.17747653e+01, 1.16478386e+01, 1.15208901e+01, 1.13939436e+01},
 { 1.79647335e+01, 1.79647241e+01, 1.79647214e+01, 1.79647103e+01, 1.79646973e+01, 1.79646683e+01, 1.79645785e+01, 1.79645198e+01, 1.79644454e+01, 1.79643502e+01, 1.79641502e+01, 1.79638527e+01, 1.79633617e+01, 1.79626886e+01, 1.79616862e+01, 1.79602476e+01, 1.79581712e+01, 1.79550969e+01, 1.79507089e+01, 1.79444031e+01, 1.79355028e+01, 1.79230842e+01, 1.79059575e+01, 1.78827644e+01, 1.78518646e+01, 1.78116887e+01, 1.77606508e+01, 1.76976366e+01, 1.76220847e+01, 1.75343672e+01, 1.74356904e+01, 1.73279833e+01, 1.72134606e+01, 1.70942478e+01, 1.69720165e+01, 1.68479356e+01, 1.67227439e+01, 1.65968892e+01, 1.64706298e+01, 1.63441247e+01, 1.62174428e+01, 1.60906651e+01, 1.59638004e+01, 1.58369520e+01, 1.57100532e+01, 1.55831418e+01, 1.54561972e+01, 1.53292720e+01, 1.52023418e+01, 1.50753496e+01, 1.49484489e+01, 1.48214705e+01, 1.46945240e+01, 1.45675743e+01, 1.44406552e+01, 1.43137017e+01, 1.41867469e+01, 1.40598119e+01, 1.39328586e+01, 1.38059166e+01, 1.36789760e+01, 1.35520231e+01, 1.34250688e+01, 1.32981354e+01, 1.31711785e+01, 1.30442595e+01, 1.29172987e+01, 1.27903564e+01, 1.26634235e+01, 1.25364321e+01, 1.24095299e+01, 1.22825560e+01, 1.21556118e+01, 1.20286511e+01, 1.19017279e+01, 1.17747774e+01, 1.16478234e+01, 1.15208929e+01, 1.13939430e+01, 1.12669930e+01, 1.11400559e+01},
 { 1.77107883e+01, 1.77107835e+01, 1.77108038e+01, 1.77107927e+01, 1.77107716e+01, 1.77107504e+01, 1.77107072e+01, 1.77106668e+01, 1.77105782e+01, 1.77104379e+01, 1.77102379e+01, 1.77099340e+01, 1.77094882e+01, 1.77088178e+01, 1.77078579e+01, 1.77063999e+01, 1.77043234e+01, 1.77012423e+01, 1.76968562e+01, 1.76905462e+01, 1.76816483e+01, 1.76692080e+01, 1.76520820e+01, 1.76288853e+01, 1.75979968e+01, 1.75577721e+01, 1.75067890e+01, 1.74437566e+01, 1.73682002e+01, 1.72804861e+01, 1.71818090e+01, 1.70741043e+01, 1.69595785e+01, 1.68403681e+01, 1.67180922e+01, 1.65940181e+01, 1.64688568e+01, 1.63429990e+01, 1.62167171e+01, 1.60902304e+01, 1.59635487e+01, 1.58367203e+01, 1.57099412e+01, 1.55830586e+01, 1.54561596e+01, 1.53292369e+01, 1.52023087e+01, 1.50753883e+01, 1.49483990e+01, 1.48214936e+01, 1.46945331e+01, 1.45675766e+01, 1.44406386e+01, 1.43137043e+01, 1.41867550e+01, 1.40598209e+01, 1.39328681e+01, 1.38059122e+01, 1.36789270e+01, 1.35520324e+01, 1.34250767e+01, 1.32981224e+01, 1.31711889e+01, 1.30442322e+01, 1.29173129e+01, 1.27903249e+01, 1.26634016e+01, 1.25364769e+01, 1.24094936e+01, 1.22825438e+01, 1.21556099e+01, 1.20286612e+01, 1.19017050e+01, 1.17747846e+01, 1.16478318e+01, 1.15208777e+01, 1.13939442e+01, 1.12669995e+01, 1.11400478e+01, 1.10131112e+01, 1.08861586e+01},
 { 1.74568870e+01, 1.74569102e+01, 1.74569029e+01, 1.74569035e+01, 1.74568752e+01, 1.74568613e+01, 1.74568225e+01, 1.74567718e+01, 1.74566832e+01, 1.74565513e+01, 1.74563513e+01, 1.74560510e+01, 1.74555801e+01, 1.74549062e+01, 1.74539280e+01, 1.74525001e+01, 1.74503967e+01, 1.74473771e+01, 1.74429684e+01, 1.74366469e+01, 1.74277549e+01, 1.74153545e+01, 1.73982287e+01, 1.73750119e+01, 1.73440921e+01, 1.73039467e+01, 1.72528441e+01, 1.71898524e+01, 1.71142665e+01, 1.70265429e+01, 1.69278766e+01, 1.68201548e+01, 1.67056470e+01, 1.65864299e+01, 1.64642070e+01, 1.63401330e+01, 1.62149573e+01, 1.60890910e+01, 1.59628543e+01, 1.58363369e+01, 1.57096662e+01, 1.55828873e+01, 1.54560501e+01, 1.53291788e+01, 1.52022602e+01, 1.50753515e+01, 1.49483918e+01, 1.48214546e+01, 1.46945429e+01, 1.45675838e+01, 1.44406353e+01, 1.43136797e+01, 1.41867571e+01, 1.40598043e+01, 1.39328204e+01, 1.38059214e+01, 1.36789670e+01, 1.35520467e+01, 1.34250859e+01, 1.32981331e+01, 1.31712011e+01, 1.30442425e+01, 1.29172859e+01, 1.27903663e+01, 1.26633788e+01, 1.25364767e+01, 1.24095029e+01, 1.22825535e+01, 1.21555977e+01, 1.20286707e+01, 1.19017200e+01, 1.17747592e+01, 1.16478361e+01, 1.15208861e+01, 1.13939389e+01, 1.12669989e+01, 1.11400545e+01, 1.10131079e+01, 1.08861439e+01, 1.07592076e+01, 1.06322781e+01},
 { 1.72030232e+01, 1.72030127e+01, 1.72030054e+01, 1.72029984e+01, 1.72029778e+01, 1.72029559e+01, 1.72029198e+01, 1.72028599e+01, 1.72027713e+01, 1.72026376e+01, 1.72024023e+01, 1.72021398e+01, 1.72017029e+01, 1.72010038e+01, 1.72000628e+01, 1.71986006e+01, 1.71965132e+01, 1.71934301e+01, 1.71890365e+01, 1.71827693e+01, 1.71738787e+01, 1.71614481e+01, 1.71442899e+01, 1.71210755e+01, 1.70902044e+01, 1.70500342e+01, 1.69990016e+01, 1.69359617e+01, 1.68604225e+01, 1.67726857e+01, 1.66740001e+01, 1.65662975e+01, 1.64517698e+01, 1.63325639e+01, 1.62103324e+01, 1.60862580e+01, 1.59610444e+01, 1.58352231e+01, 1.57089663e+01, 1.55824494e+01, 1.54557661e+01, 1.53290003e+01, 1.52021645e+01, 1.50752742e+01, 1.49483720e+01, 1.48214671e+01, 1.46944889e+01, 1.45675692e+01, 1.44406408e+01, 1.43136862e+01, 1.41867316e+01, 1.40598133e+01, 1.39328611e+01, 1.38058737e+01, 1.36789785e+01, 1.35520256e+01, 1.34250999e+01, 1.32981108e+01, 1.31711894e+01, 1.30442544e+01, 1.29172989e+01, 1.27903566e+01, 1.26634198e+01, 1.25364327e+01, 1.24095301e+01, 1.22825566e+01, 1.21556075e+01, 1.20286795e+01, 1.19017281e+01, 1.17747742e+01, 1.16478201e+01, 1.15208932e+01, 1.13939408e+01, 1.12669867e+01, 1.11400535e+01, 1.10131033e+01, 1.08861632e+01, 1.07592000e+01, 1.06322845e+01, 1.05053373e+01, 1.03783763e+01},
 { 1.69491489e+01, 1.69491441e+01, 1.69491419e+01, 1.69491258e+01, 1.69491139e+01, 1.69490883e+01, 1.69490428e+01, 1.69489801e+01, 1.69488915e+01, 1.69487579e+01, 1.69485621e+01, 1.69482371e+01, 1.69478273e+01, 1.69471654e+01, 1.69461502e+01, 1.69447116e+01, 1.69425950e+01, 1.69395708e+01, 1.69351497e+01, 1.69288715e+01, 1.69199737e+01, 1.69075437e+01, 1.68904177e+01, 1.68672131e+01, 1.68363220e+01, 1.67961031e+01, 1.67451149e+01, 1.66820385e+01, 1.66064921e+01, 1.65187837e+01, 1.64200913e+01, 1.63123915e+01, 1.61978731e+01, 1.60786647e+01, 1.59564333e+01, 1.58323591e+01, 1.57071812e+01, 1.55813299e+01, 1.54550731e+01, 1.53285525e+01, 1.52018838e+01, 1.50751167e+01, 1.49482283e+01, 1.48213830e+01, 1.46944551e+01, 1.45675341e+01, 1.44406327e+01, 1.43136798e+01, 1.41867407e+01, 1.40597871e+01, 1.39328650e+01, 1.38059136e+01, 1.36789796e+01, 1.35520277e+01, 1.34250790e+01, 1.32981478e+01, 1.31711917e+01, 1.30442427e+01, 1.29172910e+01, 1.27903388e+01, 1.26634102e+01, 1.25364772e+01, 1.24094941e+01, 1.22825836e+01, 1.21556105e+01, 1.20286616e+01, 1.19017060e+01, 1.17747822e+01, 1.16478320e+01, 1.15208783e+01, 1.13939476e+01, 1.12669981e+01, 1.11400483e+01, 1.10131088e+01, 1.08861652e+01, 1.07592187e+01, 1.06322628e+01, 1.05053411e+01, 1.03783943e+01, 1.02514395e+01, 1.01245045e+01},
 { 1.66952545e+01, 1.66952497e+01, 1.66952486e+01, 1.66952313e+01, 1.66952206e+01, 1.66951993e+01, 1.66951620e+01, 1.66951033e+01, 1.66950147e+01, 1.66948332e+01, 1.66946332e+01, 1.66943393e+01, 1.66939055e+01, 1.66932319e+01, 1.66922961e+01, 1.66908603e+01, 1.66887556e+01, 1.66857034e+01, 1.66812518e+01, 1.66749702e+01, 1.66660736e+01, 1.66536419e+01, 1.66365162e+01, 1.66133051e+01, 1.65824048e+01, 1.65422151e+01, 1.64911761e+01, 1.64281526e+01, 1.63526067e+01, 1.62648895e+01, 1.61662066e+01, 1.60585014e+01, 1.59439878e+01, 1.58247707e+01, 1.57025395e+01, 1.55784656e+01, 1.54532935e+01, 1.53274419e+01, 1.52011733e+01, 1.50746672e+01, 1.49479614e+01, 1.48211747e+01, 1.46943716e+01, 1.45674790e+01, 1.44405609e+01, 1.43136491e+01, 1.41867303e+01, 1.40597824e+01, 1.39328524e+01, 1.38059187e+01, 1.36789565e+01, 1.35520319e+01, 1.34250805e+01, 1.32981241e+01, 1.31712062e+01, 1.30442451e+01, 1.29173141e+01, 1.27903337e+01, 1.26633926e+01, 1.25364360e+01, 1.24095130e+01, 1.22825481e+01, 1.21555984e+01, 1.20286710e+01, 1.19017158e+01, 1.17747601e+01, 1.16478363e+01, 1.15208863e+01, 1.13939327e+01, 1.12669991e+01, 1.11400546e+01, 1.10131034e+01, 1.08861669e+01, 1.07592148e+01, 1.06322748e+01, 1.05053130e+01, 1.03783979e+01, 1.02514515e+01, 1.01244925e+01, 9.99756392e+00, 9.87062841e+00},
 { 1.64413430e+01, 1.64413044e+01, 1.64413310e+01, 1.64412861e+01, 1.64412692e+01, 1.64412711e+01, 1.64412323e+01, 1.64411736e+01, 1.64410850e+01, 1.64409311e+01, 1.64407781e+01, 1.64404741e+01, 1.64400285e+01, 1.64393669e+01, 1.64383820e+01, 1.64369393e+01, 1.64348396e+01, 1.64317801e+01, 1.64273923e+01, 1.64211005e+01, 1.64122036e+01, 1.63997730e+01, 1.63826358e+01, 1.63594203e+01, 1.63285346e+01, 1.62883319e+01, 1.62373109e+01, 1.61742784e+01, 1.60987013e+01, 1.60110080e+01, 1.59123005e+01, 1.58045888e+01, 1.56900752e+01, 1.55708579e+01, 1.54486265e+01, 1.53245524e+01, 1.51994082e+01, 1.50735452e+01, 1.49472911e+01, 1.48207829e+01, 1.46940583e+01, 1.45672980e+01, 1.44404648e+01, 1.43135785e+01, 1.41866641e+01, 1.40597667e+01, 1.39328304e+01, 1.38058832e+01, 1.36789650e+01, 1.35520164e+01, 1.34250908e+01, 1.32981358e+01, 1.31711771e+01, 1.30442591e+01, 1.29172716e+01, 1.27903493e+01, 1.26633874e+01, 1.25364405e+01, 1.24095043e+01, 1.22825668e+01, 1.21556156e+01, 1.20286629e+01, 1.19017250e+01, 1.17747745e+01, 1.16478157e+01, 1.15208907e+01, 1.13939410e+01, 1.12669873e+01, 1.11400538e+01, 1.10131099e+01, 1.08861636e+01, 1.07592005e+01, 1.06322647e+01, 1.05053349e+01, 1.03783769e+01, 1.02514557e+01, 1.01245100e+01, 9.99755725e+00, 9.87062352e+00, 9.74368577e+00, 9.61674501e+00},
 { 1.61874624e+01, 1.61874617e+01, 1.61874504e+01, 1.61874434e+01, 1.61874084e+01, 1.61873828e+01, 1.61873440e+01, 1.61872853e+01, 1.61872064e+01, 1.61870725e+01, 1.61868781e+01, 1.61865691e+01, 1.61861338e+01, 1.61854719e+01, 1.61844936e+01, 1.61830455e+01, 1.61809510e+01, 1.61778958e+01, 1.61734990e+01, 1.61672068e+01, 1.61583103e+01, 1.61458802e+01, 1.61287593e+01, 1.61055466e+01, 1.60746677e+01, 1.60344386e+01, 1.59834115e+01, 1.59203794e+01, 1.58448372e+01, 1.57571093e+01, 1.56584365e+01, 1.55507280e+01, 1.54362096e+01, 1.53169922e+01, 1.51947607e+01, 1.50706822e+01, 1.49455033e+01, 1.48196540e+01, 1.46933687e+01, 1.45668418e+01, 1.44402015e+01, 1.43134111e+01, 1.41865695e+01, 1.40596751e+01, 1.39327971e+01, 1.38058708e+01, 1.36789261e+01, 1.35520146e+01, 1.34250683e+01, 1.32981343e+01, 1.31711848e+01, 1.30442585e+01, 1.29172792e+01, 1.27903251e+01, 1.26634026e+01, 1.25364516e+01, 1.24095001e+01, 1.22825579e+01, 1.21556172e+01, 1.20286663e+01, 1.19017169e+01, 1.17747817e+01, 1.16478155e+01, 1.15208700e+01, 1.13939478e+01, 1.12669982e+01, 1.11400422e+01, 1.10131090e+01, 1.08861653e+01, 1.07592190e+01, 1.06322785e+01, 1.05053412e+01, 1.03783945e+01, 1.02514349e+01, 1.01244984e+01, 9.99756516e+00, 9.87061772e+00, 9.74368539e+00, 9.61675186e+00, 9.48981278e+00, 9.36285552e+00},
 { 1.59335387e+01, 1.59335747e+01, 1.59335266e+01, 1.59335155e+01, 1.59335110e+01, 1.59334854e+01, 1.59334465e+01, 1.59333878e+01, 1.59333293e+01, 1.59331709e+01, 1.59329672e+01, 1.59326681e+01, 1.59322268e+01, 1.59315649e+01, 1.59305490e+01, 1.59291436e+01, 1.59270071e+01, 1.59239523e+01, 1.59195486e+01, 1.59132570e+01, 1.59043578e+01, 1.58919374e+01, 1.58748117e+01, 1.58516149e+01, 1.58207387e+01, 1.57805463e+01, 1.57295149e+01, 1.56664899e+01, 1.55909391e+01, 1.55032205e+01, 1.54045437e+01, 1.52968373e+01, 1.51823191e+01, 1.50631018e+01, 1.49408705e+01, 1.48168002e+01, 1.46916123e+01, 1.45657377e+01, 1.44394742e+01, 1.43129653e+01, 1.41862945e+01, 1.40595109e+01, 1.39326814e+01, 1.38058107e+01, 1.36788975e+01, 1.35519895e+01, 1.34250536e+01, 1.32981152e+01, 1.31711905e+01, 1.30442385e+01, 1.29172818e+01, 1.27903641e+01, 1.26633782e+01, 1.25364247e+01, 1.24095051e+01, 1.22825539e+01, 1.21555972e+01, 1.20286744e+01, 1.19017204e+01, 1.17747621e+01, 1.16478391e+01, 1.15208702e+01, 1.13939445e+01, 1.12669794e+01, 1.11400532e+01, 1.10131038e+01, 1.08861671e+01, 1.07592213e+01, 1.06322751e+01, 1.05053135e+01, 1.03783981e+01, 1.02514492e+01, 1.01244929e+01, 9.99756430e+00, 9.87062534e+00, 9.74368354e+00, 9.61672573e+00, 9.48981599e+00, 9.36287898e+00, 9.23593722e+00, 9.10902441e+00},
 { 1.56796380e+01, 1.56796247e+01, 1.56796259e+01, 1.56796276e+01, 1.56796108e+01, 1.56795851e+01, 1.56795463e+01, 1.56795143e+01, 1.56794257e+01, 1.56793024e+01, 1.56790982e+01, 1.56787890e+01, 1.56783432e+01, 1.56776858e+01, 1.56767028e+01, 1.56752686e+01, 1.56731652e+01, 1.56700869e+01, 1.56657122e+01, 1.56594204e+01, 1.56505235e+01, 1.56380726e+01, 1.56209331e+01, 1.55977086e+01, 1.55668244e+01, 1.55266375e+01, 1.54756052e+01, 1.54126032e+01, 1.53370264e+01, 1.52493328e+01, 1.51506637e+01, 1.50429519e+01, 1.49284333e+01, 1.48092157e+01, 1.46869899e+01, 1.45629156e+01, 1.44377083e+01, 1.43118433e+01, 1.41855895e+01, 1.40590825e+01, 1.39323994e+01, 1.38056280e+01, 1.36787937e+01, 1.35519084e+01, 1.34250230e+01, 1.32980902e+01, 1.31711502e+01, 1.30442423e+01, 1.29172878e+01, 1.27903607e+01, 1.26633839e+01, 1.25364311e+01, 1.24095086e+01, 1.22825584e+01, 1.21556120e+01, 1.20286510e+01, 1.19017283e+01, 1.17747779e+01, 1.16478250e+01, 1.15208934e+01, 1.13939434e+01, 1.12669942e+01, 1.11400564e+01, 1.10131175e+01, 1.08861602e+01, 1.07592229e+01, 1.06322713e+01, 1.05053352e+01, 1.03783711e+01, 1.02514558e+01, 1.01245101e+01, 9.99755758e+00, 9.87061792e+00, 9.74368605e+00, 9.61674526e+00, 9.48981184e+00, 9.36288144e+00, 9.23594605e+00, 9.10900774e+00, 8.98209758e+00, 8.85517081e+00},
 { 1.54257922e+01, 1.54257709e+01, 1.54257636e+01, 1.54257245e+01, 1.54257076e+01, 1.54256820e+01, 1.54256431e+01, 1.54256102e+01, 1.54255436e+01, 1.54254053e+01, 1.54251978e+01, 1.54249055e+01, 1.54244597e+01, 1.54237554e+01, 1.54228193e+01, 1.54213854e+01, 1.54192456e+01, 1.54161904e+01, 1.54117852e+01, 1.54054937e+01, 1.53966066e+01, 1.53841766e+01, 1.53670530e+01, 1.53438692e+01, 1.53129600e+01, 1.52727707e+01, 1.52217344e+01, 1.51587066e+01, 1.50831562e+01, 1.49954325e+01, 1.48967585e+01, 1.47890469e+01, 1.46745285e+01, 1.45553111e+01, 1.44330498e+01, 1.43089758e+01, 1.41838016e+01, 1.40579466e+01, 1.39317064e+01, 1.38051828e+01, 1.36784955e+01, 1.35517428e+01, 1.34248945e+01, 1.32980267e+01, 1.31711168e+01, 1.30442157e+01, 1.29172850e+01, 1.27903085e+01, 1.26633926e+01, 1.25364349e+01, 1.24094905e+01, 1.22825307e+01, 1.21556117e+01, 1.20286612e+01, 1.19017047e+01, 1.17747847e+01, 1.16478321e+01, 1.15208792e+01, 1.13939447e+01, 1.12669799e+01, 1.11400490e+01, 1.10131117e+01, 1.08861589e+01, 1.07592227e+01, 1.06322686e+01, 1.05053139e+01, 1.03783922e+01, 1.02514353e+01, 1.01244990e+01, 9.99756952e+00, 9.87061805e+00, 9.74368577e+00, 9.61675208e+00, 9.48981011e+00, 9.36285614e+00, 9.23595195e+00, 9.10901672e+00, 8.98208086e+00, 8.85514796e+00, 8.72825132e+00, 8.60133096e+00},
 { 1.51718596e+01, 1.51718670e+01, 1.51718947e+01, 1.51718836e+01, 1.51718667e+01, 1.51718411e+01, 1.51718051e+01, 1.51717464e+01, 1.51715991e+01, 1.51714967e+01, 1.51712659e+01, 1.51709668e+01, 1.51705285e+01, 1.51698592e+01, 1.51688884e+01, 1.51674417e+01, 1.51653431e+01, 1.51622878e+01, 1.51578839e+01, 1.51515735e+01, 1.51427087e+01, 1.51303010e+01, 1.51131743e+01, 1.50899422e+01, 1.50590682e+01, 1.50188784e+01, 1.49678507e+01, 1.49048159e+01, 1.48292736e+01, 1.47415442e+01, 1.46428675e+01, 1.45351561e+01, 1.44206379e+01, 1.43014231e+01, 1.41791919e+01, 1.40550996e+01, 1.39299172e+01, 1.38040753e+01, 1.36778105e+01, 1.35512789e+01, 1.34246262e+01, 1.32978434e+01, 1.31710195e+01, 1.30441277e+01, 1.29172138e+01, 1.27903214e+01, 1.26633589e+01, 1.25364394e+01, 1.24094947e+01, 1.22825474e+01, 1.21555830e+01, 1.20286687e+01, 1.19017190e+01, 1.17747585e+01, 1.16478360e+01, 1.15208862e+01, 1.13939399e+01, 1.12669993e+01, 1.11400351e+01, 1.10131088e+01, 1.08861455e+01, 1.07592149e+01, 1.06322788e+01, 1.05053202e+01, 1.03783826e+01, 1.02514478e+01, 1.01245055e+01, 9.99755854e+00, 9.87062562e+00, 9.74368379e+00, 9.61674907e+00, 9.48981621e+00, 9.36287917e+00, 9.23593769e+00, 9.10902254e+00, 8.98209284e+00, 8.85516251e+00, 8.72825379e+00, 8.60131975e+00, 8.47442045e+00, 8.34751000e+00},
 { 1.49179710e+01, 1.49179662e+01, 1.49179663e+01, 1.49179478e+01, 1.49179383e+01, 1.49179127e+01, 1.49178794e+01, 1.49178119e+01, 1.49177450e+01, 1.49176118e+01, 1.49173901e+01, 1.49170910e+01, 1.49166565e+01, 1.49159833e+01, 1.49150163e+01, 1.49135485e+01, 1.49114649e+01, 1.49084097e+01, 1.49040217e+01, 1.48977171e+01, 1.48888063e+01, 1.48764155e+01, 1.48592738e+01, 1.48360661e+01, 1.48051862e+01, 1.47650006e+01, 1.47139626e+01, 1.46509360e+01, 1.45753895e+01, 1.44876290e+01, 1.43889521e+01, 1.42812404e+01, 1.41667220e+01, 1.40475165e+01, 1.39252851e+01, 1.38012109e+01, 1.36760334e+01, 1.35501759e+01, 1.34239030e+01, 1.32974058e+01, 1.31707269e+01, 1.30439657e+01, 1.29171164e+01, 1.27902527e+01, 1.26633480e+01, 1.25363886e+01, 1.24094822e+01, 1.22825416e+01, 1.21555972e+01, 1.20286449e+01, 1.19017242e+01, 1.17747722e+01, 1.16478154e+01, 1.15208925e+01, 1.13939407e+01, 1.12669880e+01, 1.11400539e+01, 1.10131157e+01, 1.08861641e+01, 1.07592015e+01, 1.06322848e+01, 1.05053298e+01, 1.03783775e+01, 1.02514407e+01, 1.01245063e+01, 9.99756165e+00, 9.87060920e+00, 9.74369037e+00, 9.61674181e+00, 9.48981221e+00, 9.36288165e+00, 9.23594346e+00, 9.10900820e+00, 8.98209772e+00, 8.85515543e+00, 8.72824280e+00, 8.60131949e+00, 8.47441593e+00, 8.34751607e+00, 8.22060600e+00, 8.09372781e+00},
 { 1.46640685e+01, 1.46640877e+01, 1.46640804e+01, 1.46640693e+01, 1.46640525e+01, 1.46640361e+01, 1.46639973e+01, 1.46639150e+01, 1.46638615e+01, 1.46636932e+01, 1.46634933e+01, 1.46632033e+01, 1.46627483e+01, 1.46620956e+01, 1.46611173e+01, 1.46596825e+01, 1.46575790e+01, 1.46545474e+01, 1.46501437e+01, 1.46438553e+01, 1.46348999e+01, 1.46224700e+01, 1.46053767e+01, 1.45821301e+01, 1.45512516e+01, 1.45110596e+01, 1.44600575e+01, 1.43969959e+01, 1.43214577e+01, 1.42337341e+01, 1.41350573e+01, 1.40273458e+01, 1.39128338e+01, 1.37936166e+01, 1.36713901e+01, 1.35473114e+01, 1.34221342e+01, 1.32962721e+01, 1.31700335e+01, 1.30435104e+01, 1.29168539e+01, 1.27900629e+01, 1.26632385e+01, 1.25363275e+01, 1.24094228e+01, 1.22825189e+01, 1.21555848e+01, 1.20286444e+01, 1.19016946e+01, 1.17747756e+01, 1.16478280e+01, 1.15208771e+01, 1.13939463e+01, 1.12669973e+01, 1.11400488e+01, 1.10131090e+01, 1.08861459e+01, 1.07592194e+01, 1.06322640e+01, 1.05053414e+01, 1.03783868e+01, 1.02514405e+01, 1.01244824e+01, 9.99756550e+00, 9.87062209e+00, 9.74367077e+00, 9.61675484e+00, 9.48981511e+00, 9.36287505e+00, 9.23594963e+00, 9.10901690e+00, 8.98208131e+00, 8.85517025e+00, 8.72823612e+00, 8.60133121e+00, 8.47440846e+00, 8.34751195e+00, 8.22062127e+00, 8.09372170e+00, 7.96684780e+00, 7.83998346e+00},
 { 1.44101843e+01, 1.44101900e+01, 1.44101722e+01, 1.44101716e+01, 1.44101547e+01, 1.44101321e+01, 1.44100744e+01, 1.44100088e+01, 1.44099202e+01, 1.44097939e+01, 1.44095939e+01, 1.44093222e+01, 1.44088490e+01, 1.44082145e+01, 1.44072413e+01, 1.44058026e+01, 1.44036991e+01, 1.44006438e+01, 1.43962404e+01, 1.43899431e+01, 1.43810510e+01, 1.43686166e+01, 1.43514937e+01, 1.43282781e+01, 1.42973818e+01, 1.42571971e+01, 1.42061682e+01, 1.41431370e+01, 1.40675728e+01, 1.39798495e+01, 1.38811730e+01, 1.37734617e+01, 1.36589510e+01, 1.35397340e+01, 1.34175029e+01, 1.32934291e+01, 1.31682563e+01, 1.30424025e+01, 1.29161345e+01, 1.27896322e+01, 1.26629463e+01, 1.25361682e+01, 1.24093137e+01, 1.22824341e+01, 1.21555159e+01, 1.20286259e+01, 1.19016879e+01, 1.17747420e+01, 1.16478254e+01, 1.15208796e+01, 1.13939298e+01, 1.12669968e+01, 1.11400341e+01, 1.10131035e+01, 1.08861667e+01, 1.07592147e+01, 1.06322754e+01, 1.05053144e+01, 1.03783982e+01, 1.02514519e+01, 1.01244937e+01, 9.99754213e+00, 9.87062906e+00, 9.74368681e+00, 9.61673354e+00, 9.48981895e+00, 9.36288131e+00, 9.23594324e+00, 9.10899759e+00, 8.98208497e+00, 8.85515781e+00, 8.72825392e+00, 8.60132032e+00, 8.47441702e+00, 8.34751036e+00, 8.22061848e+00, 8.09373364e+00, 7.96684164e+00, 7.83994282e+00, 7.71310387e+00, 7.58627523e+00},
 { 1.41563204e+01, 1.41563157e+01, 1.41563084e+01, 1.41562973e+01, 1.41562845e+01, 1.41562589e+01, 1.41562077e+01, 1.41561385e+01, 1.41560605e+01, 1.41559272e+01, 1.41557144e+01, 1.41554281e+01, 1.41549695e+01, 1.41543077e+01, 1.41533403e+01, 1.41519017e+01, 1.41497982e+01, 1.41467431e+01, 1.41423473e+01, 1.41360333e+01, 1.41271369e+01, 1.41147391e+01, 1.40975703e+01, 1.40743549e+01, 1.40434866e+01, 1.40032841e+01, 1.39522634e+01, 1.38892357e+01, 1.38136894e+01, 1.37259657e+01, 1.36272888e+01, 1.35195807e+01, 1.34050624e+01, 1.32858478e+01, 1.31636138e+01, 1.30395424e+01, 1.29143570e+01, 1.27884960e+01, 1.26622562e+01, 1.25357299e+01, 1.24090578e+01, 1.22822604e+01, 1.21554260e+01, 1.20285273e+01, 1.19016530e+01, 1.17747294e+01, 1.16477890e+01, 1.15208731e+01, 1.13939301e+01, 1.12669817e+01, 1.11400498e+01, 1.10130885e+01, 1.08861626e+01, 1.07592009e+01, 1.06322708e+01, 1.05053351e+01, 1.03783779e+01, 1.02514559e+01, 1.01245103e+01, 9.99755816e+00, 9.87060204e+00, 9.74368657e+00, 9.61674574e+00, 9.48979755e+00, 9.36288278e+00, 9.23594958e+00, 9.10901369e+00, 8.98209478e+00, 8.85516183e+00, 8.72824953e+00, 8.60132383e+00, 8.47441046e+00, 8.34751632e+00, 8.22060642e+00, 8.09372446e+00, 7.96685326e+00, 7.83997616e+00, 7.71310686e+00, 7.58626115e+00, 7.45945205e+00, 7.33263822e+00},
 { 1.39024276e+01, 1.39024160e+01, 1.39024155e+01, 1.39024044e+01, 1.39023924e+01, 1.39023685e+01, 1.39023026e+01, 1.39022439e+01, 1.39021824e+01, 1.39020491e+01, 1.39018522e+01, 1.39015501e+01, 1.39011073e+01, 1.39004177e+01, 1.38994394e+01, 1.38980008e+01, 1.38958974e+01, 1.38928449e+01, 1.38884413e+01, 1.38821325e+01, 1.38732300e+01, 1.38608062e+01, 1.38436806e+01, 1.38204711e+01, 1.37895792e+01, 1.37493944e+01, 1.36983627e+01, 1.36353355e+01, 1.35597897e+01, 1.34720663e+01, 1.33733896e+01, 1.32656816e+01, 1.31511634e+01, 1.30319463e+01, 1.29097152e+01, 1.27856436e+01, 1.26604544e+01, 1.25346300e+01, 1.24083291e+01, 1.22818414e+01, 1.21551442e+01, 1.20283674e+01, 1.19015138e+01, 1.17746676e+01, 1.16477569e+01, 1.15208264e+01, 1.13939193e+01, 1.12669803e+01, 1.11400324e+01, 1.10131024e+01, 1.08861423e+01, 1.07592170e+01, 1.06322771e+01, 1.05053404e+01, 1.03783864e+01, 1.02514357e+01, 1.01244999e+01, 9.99756581e+00, 9.87061858e+00, 9.74366409e+00, 9.61675247e+00, 9.48981330e+00, 9.36285731e+00, 9.23595090e+00, 9.10901897e+00, 8.98208667e+00, 8.85515545e+00, 8.72824246e+00, 8.60133414e+00, 8.47441386e+00, 8.34751477e+00, 8.22062019e+00, 8.09371719e+00, 7.96684801e+00, 7.83998359e+00, 7.71312358e+00, 7.58628250e+00, 7.45945575e+00, 7.33264794e+00, 7.20584658e+00, 7.07910833e+00},
 { 1.36485201e+01, 1.36485153e+01, 1.36485080e+01, 1.36484704e+01, 1.36484536e+01, 1.36484648e+01, 1.36483842e+01, 1.36483673e+01, 1.36482787e+01, 1.36481459e+01, 1.36479455e+01, 1.36476468e+01, 1.36472010e+01, 1.36465436e+01, 1.36455653e+01, 1.36441266e+01, 1.36420231e+01, 1.36389714e+01, 1.36345578e+01, 1.36282598e+01, 1.36193542e+01, 1.36069323e+01, 1.35898056e+01, 1.35665646e+01, 1.35357103e+01, 1.34954935e+01, 1.34444653e+01, 1.33814331e+01, 1.33058868e+01, 1.32181631e+01, 1.31195120e+01, 1.30118003e+01, 1.28972883e+01, 1.27780645e+01, 1.26558396e+01, 1.25317655e+01, 1.24065576e+01, 1.22806986e+01, 1.21544593e+01, 1.20279376e+01, 1.19012515e+01, 1.17744609e+01, 1.16476510e+01, 1.15207687e+01, 1.13938621e+01, 1.12669570e+01, 1.11400247e+01, 1.10130867e+01, 1.08861276e+01, 1.07591958e+01, 1.06322714e+01, 1.05053122e+01, 1.03783965e+01, 1.02514487e+01, 1.01244934e+01, 9.99754215e+00, 9.87062587e+00, 9.74368411e+00, 9.61673427e+00, 9.48981657e+00, 9.36287948e+00, 9.23593856e+00, 9.10902480e+00, 8.98209307e+00, 8.85516316e+00, 8.72825096e+00, 8.60132654e+00, 8.47442385e+00, 8.34750980e+00, 8.22061753e+00, 8.09373061e+00, 7.96684882e+00, 7.83996434e+00, 7.71312624e+00, 7.58627549e+00, 7.45944016e+00, 7.33264899e+00, 7.20586391e+00, 7.07909265e+00, 6.95235877e+00, 6.82567282e+00},
 { 1.33946464e+01, 1.33946416e+01, 1.33946344e+01, 1.33945978e+01, 1.33945706e+01, 1.33945413e+01, 1.33945025e+01, 1.33944474e+01, 1.33943589e+01, 1.33942528e+01, 1.33940257e+01, 1.33937537e+01, 1.33933136e+01, 1.33926517e+01, 1.33916734e+01, 1.33902348e+01, 1.33881354e+01, 1.33850802e+01, 1.33806781e+01, 1.33743609e+01, 1.33654903e+01, 1.33530603e+01, 1.33359094e+01, 1.33126910e+01, 1.32818145e+01, 1.32416237e+01, 1.31905941e+01, 1.31275622e+01, 1.30520161e+01, 1.29642926e+01, 1.28656123e+01, 1.27579009e+01, 1.26433827e+01, 1.25241656e+01, 1.24019044e+01, 1.22778632e+01, 1.21526641e+01, 1.20267993e+01, 1.19005621e+01, 1.17740410e+01, 1.16473548e+01, 1.15205983e+01, 1.13937557e+01, 1.12668660e+01, 1.11399849e+01, 1.10130461e+01, 1.08861314e+01, 1.07591769e+01, 1.06322601e+01, 1.05053285e+01, 1.03783681e+01, 1.02514532e+01, 1.01245011e+01, 9.99755740e+00, 9.87061891e+00, 9.74368640e+00, 9.61674571e+00, 9.48979103e+00, 9.36288196e+00, 9.23594651e+00, 9.10900905e+00, 8.98209795e+00, 8.85515652e+00, 8.72824705e+00, 8.60132037e+00, 8.47441663e+00, 8.34751916e+00, 8.22061163e+00, 8.09369369e+00, 7.96685024e+00, 7.83997940e+00, 7.71310752e+00, 7.58628351e+00, 7.45945441e+00, 7.33263354e+00, 7.20586609e+00, 7.07910738e+00, 6.95236468e+00, 6.82568266e+00, 6.69902208e+00, 6.57240771e+00},
 { 1.31407279e+01, 1.31407504e+01, 1.31407158e+01, 1.31407047e+01, 1.31406904e+01, 1.31406911e+01, 1.31406259e+01, 1.31405672e+01, 1.31404813e+01, 1.31403454e+01, 1.31401481e+01, 1.31398491e+01, 1.31393731e+01, 1.31387112e+01, 1.31377330e+01, 1.31362944e+01, 1.31341986e+01, 1.31311578e+01, 1.31267542e+01, 1.31204561e+01, 1.31115663e+01, 1.30991363e+01, 1.30820156e+01, 1.30587962e+01, 1.30279229e+01, 1.29877189e+01, 1.29366834e+01, 1.28736519e+01, 1.27981062e+01, 1.27103765e+01, 1.26117096e+01, 1.25040253e+01, 1.23894805e+01, 1.22702797e+01, 1.21480487e+01, 1.20239693e+01, 1.18987869e+01, 1.17729356e+01, 1.16466699e+01, 1.15201391e+01, 1.13934857e+01, 1.12667064e+01, 1.11398534e+01, 1.10129974e+01, 1.08860915e+01, 1.07591699e+01, 1.06322223e+01, 1.05053101e+01, 1.03783813e+01, 1.02514293e+01, 1.01244961e+01, 9.99755949e+00, 9.87061719e+00, 9.74366345e+00, 9.61675200e+00, 9.48981039e+00, 9.36285761e+00, 9.23595087e+00, 9.10901713e+00, 8.98208211e+00, 8.85516805e+00, 8.72823718e+00, 8.60133167e+00, 8.47440929e+00, 8.34749516e+00, 8.22062161e+00, 8.09372235e+00, 7.96681344e+00, 7.83996740e+00, 7.71312313e+00, 7.58626552e+00, 7.45945794e+00, 7.33264969e+00, 7.20585524e+00, 7.07909378e+00, 6.95237716e+00, 6.82566824e+00, 6.69901277e+00, 6.57240603e+00, 6.44584720e+00, 6.31935188e+00},
 { 1.28868261e+01, 1.28868160e+01, 1.28868140e+01, 1.28868157e+01, 1.28867944e+01, 1.28867688e+01, 1.28867344e+01, 1.28866757e+01, 1.28865871e+01, 1.28864538e+01, 1.28862612e+01, 1.28859709e+01, 1.28855199e+01, 1.28848580e+01, 1.28838797e+01, 1.28824252e+01, 1.28803217e+01, 1.28772615e+01, 1.28728467e+01, 1.28665588e+01, 1.28576620e+01, 1.28452564e+01, 1.28281048e+01, 1.28049145e+01, 1.27740347e+01, 1.27338499e+01, 1.26828177e+01, 1.26197855e+01, 1.25442393e+01, 1.24565202e+01, 1.23578435e+01, 1.22501320e+01, 1.21356138e+01, 1.20163674e+01, 1.18941365e+01, 1.17700629e+01, 1.16448905e+01, 1.15190357e+01, 1.13927639e+01, 1.12662726e+01, 1.11395914e+01, 1.10128093e+01, 1.08859824e+01, 1.07591049e+01, 1.06321991e+01, 1.05052900e+01, 1.03783565e+01, 1.02514317e+01, 1.01244772e+01, 9.99755294e+00, 9.87062183e+00, 9.74368163e+00, 9.61672627e+00, 9.48981570e+00, 9.36287898e+00, 9.23593857e+00, 9.10902275e+00, 8.98209302e+00, 8.85516337e+00, 8.72825411e+00, 8.60132135e+00, 8.47442113e+00, 8.34750526e+00, 8.22059826e+00, 8.09373388e+00, 7.96684607e+00, 7.83994456e+00, 7.71310486e+00, 7.58627858e+00, 7.45942366e+00, 7.33265073e+00, 7.20586498e+00, 7.07909136e+00, 6.95236854e+00, 6.82566329e+00, 6.69901748e+00, 6.57240275e+00, 6.44585324e+00, 6.31935231e+00, 6.19292457e+00, 6.06656794e+00},
 { 1.26329274e+01, 1.26329226e+01, 1.26329153e+01, 1.26329218e+01, 1.26328990e+01, 1.26328793e+01, 1.26328405e+01, 1.26328037e+01, 1.26326932e+01, 1.26325819e+01, 1.26323819e+01, 1.26320532e+01, 1.26316074e+01, 1.26309456e+01, 1.26299673e+01, 1.26285356e+01, 1.26264341e+01, 1.26233790e+01, 1.26190005e+01, 1.26126841e+01, 1.26037813e+01, 1.25913602e+01, 1.25742324e+01, 1.25510138e+01, 1.25201044e+01, 1.24799138e+01, 1.24288821e+01, 1.23658504e+01, 1.22903128e+01, 1.22025896e+01, 1.21039198e+01, 1.19962021e+01, 1.18816910e+01, 1.17624745e+01, 1.16402491e+01, 1.15161708e+01, 1.13909950e+01, 1.12651342e+01, 1.11388954e+01, 1.10123762e+01, 1.08857004e+01, 1.07589310e+01, 1.06320772e+01, 1.05052174e+01, 1.03783205e+01, 1.02513925e+01, 1.01244795e+01, 9.99753601e+00, 9.87060863e+00, 9.74368350e+00, 9.61673815e+00, 9.48978875e+00, 9.36288045e+00, 9.23594302e+00, 9.10900880e+00, 8.98207286e+00, 8.85515678e+00, 8.72824358e+00, 8.60132069e+00, 8.47441690e+00, 8.34751674e+00, 8.22060721e+00, 8.09370837e+00, 7.96685349e+00, 7.83997667e+00, 7.71310757e+00, 7.58628281e+00, 7.45945243e+00, 7.33263883e+00, 7.20584801e+00, 7.07909774e+00, 6.95236333e+00, 6.82566897e+00, 6.69900813e+00, 6.57241467e+00, 6.44585488e+00, 6.31933234e+00, 6.19292535e+00, 6.06658042e+00, 5.94030297e+00, 5.81418030e+00},
 { 1.23790732e+01, 1.23790714e+01, 1.23790130e+01, 1.23790019e+01, 1.23790141e+01, 1.23789594e+01, 1.23789206e+01, 1.23788694e+01, 1.23787734e+01, 1.23786476e+01, 1.23784536e+01, 1.23781545e+01, 1.23777087e+01, 1.23770469e+01, 1.23760732e+01, 1.23746346e+01, 1.23725430e+01, 1.23694842e+01, 1.23650843e+01, 1.23587929e+01, 1.23498916e+01, 1.23374666e+01, 1.23203361e+01, 1.22971295e+01, 1.22662463e+01, 1.22260687e+01, 1.21750362e+01, 1.21120040e+01, 1.20364428e+01, 1.19487193e+01, 1.18500428e+01, 1.17423316e+01, 1.16277859e+01, 1.15085694e+01, 1.13863390e+01, 1.12622661e+01, 1.11370972e+01, 1.10112660e+01, 1.08850023e+01, 1.07584800e+01, 1.06318166e+01, 1.05050383e+01, 1.03782069e+01, 1.02513157e+01, 1.01244421e+01, 9.99752194e+00, 9.87058581e+00, 9.74366347e+00, 9.61673838e+00, 9.48980380e+00, 9.36285385e+00, 9.23594736e+00, 9.10901559e+00, 8.98208145e+00, 8.85516994e+00, 8.72823728e+00, 8.60133163e+00, 8.47440954e+00, 8.34751286e+00, 8.22062172e+00, 8.09372264e+00, 7.96682860e+00, 7.83998381e+00, 7.71312622e+00, 7.58626554e+00, 7.45945609e+00, 7.33264823e+00, 7.20585265e+00, 7.07910855e+00, 6.95236857e+00, 6.82567124e+00, 6.69901711e+00, 6.57241073e+00, 6.44584901e+00, 6.31935787e+00, 6.19292110e+00, 6.06658424e+00, 5.94032936e+00, 5.81415419e+00, 5.68814037e+00, 5.56226248e+00},
 { 1.21251556e+01, 1.21251508e+01, 1.21251569e+01, 1.21251459e+01, 1.21251290e+01, 1.21251034e+01, 1.21250490e+01, 1.21250059e+01, 1.21249018e+01, 1.21247685e+01, 1.21245770e+01, 1.21242695e+01, 1.21238322e+01, 1.21231703e+01, 1.21221690e+01, 1.21207636e+01, 1.21186542e+01, 1.21155990e+01, 1.21112012e+01, 1.21049096e+01, 1.20960171e+01, 1.20835824e+01, 1.20664603e+01, 1.20432160e+01, 1.20123366e+01, 1.19721458e+01, 1.19211140e+01, 1.18580910e+01, 1.17825453e+01, 1.16948259e+01, 1.15961460e+01, 1.14884390e+01, 1.13739217e+01, 1.12547086e+01, 1.11324756e+01, 1.10084031e+01, 1.08832286e+01, 1.07573758e+01, 1.06311066e+01, 1.05046033e+01, 1.03779140e+01, 1.02511569e+01, 1.01243062e+01, 9.99744080e+00, 9.87055007e+00, 9.74363532e+00, 9.61671608e+00, 9.48979578e+00, 9.36286575e+00, 9.23591970e+00, 9.10901861e+00, 8.98208860e+00, 8.85515728e+00, 8.72822908e+00, 8.60132118e+00, 8.47441751e+00, 8.34750541e+00, 8.22059844e+00, 8.09373390e+00, 7.96684255e+00, 7.83994536e+00, 7.71311045e+00, 7.58627596e+00, 7.45944106e+00, 7.33265133e+00, 7.20586353e+00, 7.07909323e+00, 6.95235962e+00, 6.82567801e+00, 6.69901593e+00, 6.57240704e+00, 6.44583998e+00, 6.31935954e+00, 6.19292782e+00, 6.06656962e+00, 5.94032917e+00, 5.81418013e+00, 5.68814557e+00, 5.56226361e+00, 5.43653137e+00, 5.31097515e+00},
 { 1.18712683e+01, 1.18712512e+01, 1.18712440e+01, 1.18712329e+01, 1.18712160e+01, 1.18711904e+01, 1.18711605e+01, 1.18710930e+01, 1.18710133e+01, 1.18709032e+01, 1.18707033e+01, 1.18704042e+01, 1.18699585e+01, 1.18692993e+01, 1.18683211e+01, 1.18668361e+01, 1.18647580e+01, 1.18616778e+01, 1.18572743e+01, 1.18509896e+01, 1.18420868e+01, 1.18296480e+01, 1.18125294e+01, 1.17893207e+01, 1.17584416e+01, 1.17182513e+01, 1.16672202e+01, 1.16041940e+01, 1.15286489e+01, 1.14409262e+01, 1.13422505e+01, 1.12345442e+01, 1.11200274e+01, 1.10008116e+01, 1.08785825e+01, 1.07545138e+01, 1.06293368e+01, 1.05034844e+01, 1.03772065e+01, 1.02507019e+01, 1.01240453e+01, 9.99725880e+00, 9.87045104e+00, 9.74357547e+00, 9.61666580e+00, 9.48976235e+00, 9.36285056e+00, 9.23592274e+00, 9.10898638e+00, 8.98208910e+00, 8.85516545e+00, 8.72824118e+00, 8.60131325e+00, 8.47441089e+00, 8.34751628e+00, 8.22060718e+00, 8.09372517e+00, 7.96685344e+00, 7.83997681e+00, 7.71310160e+00, 7.58626765e+00, 7.45945259e+00, 7.33261807e+00, 7.20586636e+00, 7.07910757e+00, 6.95236359e+00, 6.82566446e+00, 6.69902261e+00, 6.57240790e+00, 6.44585264e+00, 6.31934350e+00, 6.19293210e+00, 6.06658293e+00, 5.94031796e+00, 5.81416866e+00, 5.68815190e+00, 5.56225678e+00, 5.43651917e+00, 5.31097839e+00, 5.18563718e+00, 5.06052963e+00},
 { 1.16173751e+01, 1.16173556e+01, 1.16173483e+01, 1.16173373e+01, 1.16173204e+01, 1.16172992e+01, 1.16172604e+01, 1.16171974e+01, 1.16171132e+01, 1.16169826e+01, 1.16167801e+01, 1.16164836e+01, 1.16160379e+01, 1.16153810e+01, 1.16144141e+01, 1.16129705e+01, 1.16108672e+01, 1.16078171e+01, 1.16034134e+01, 1.15971099e+01, 1.15882167e+01, 1.15757831e+01, 1.15586636e+01, 1.15354486e+01, 1.15045578e+01, 1.14643771e+01, 1.14133252e+01, 1.13502936e+01, 1.12747480e+01, 1.11870253e+01, 1.10883532e+01, 1.09806431e+01, 1.08661341e+01, 1.07469114e+01, 1.06246827e+01, 1.05006191e+01, 1.03754461e+01, 1.02495800e+01, 1.01233378e+01, 9.99683758e+00, 9.87014922e+00, 9.74340528e+00, 9.61656344e+00, 9.48969244e+00, 9.36278603e+00, 9.23590178e+00, 9.10898609e+00, 8.98205237e+00, 8.85515854e+00, 8.72824327e+00, 8.60132415e+00, 8.47440822e+00, 8.34751147e+00, 8.22061833e+00, 8.09371767e+00, 7.96682852e+00, 7.83998366e+00, 7.71312401e+00, 7.58626579e+00, 7.45945620e+00, 7.33264833e+00, 7.20584786e+00, 7.07908940e+00, 6.95236897e+00, 6.82566874e+00, 6.69901344e+00, 6.57241099e+00, 6.44584752e+00, 6.31935565e+00, 6.19290641e+00, 6.06656843e+00, 5.94032776e+00, 5.81416898e+00, 5.68814233e+00, 5.56226418e+00, 5.43652696e+00, 5.31097066e+00, 5.18564416e+00, 5.06053447e+00, 4.93569759e+00, 4.81116238e+00},
 { 1.13634595e+01, 1.13634766e+01, 1.13634693e+01, 1.13634583e+01, 1.13634414e+01, 1.13633940e+01, 1.13633553e+01, 1.13632966e+01, 1.13632115e+01, 1.13630783e+01, 1.13628784e+01, 1.13625795e+01, 1.13621561e+01, 1.13614943e+01, 1.13604983e+01, 1.13590877e+01, 1.13569565e+01, 1.13539015e+01, 1.13495063e+01, 1.13432065e+01, 1.13343101e+01, 1.13218884e+01, 1.13047657e+01, 1.12815511e+01, 1.12506721e+01, 1.12104822e+01, 1.11594539e+01, 1.10964231e+01, 1.10208782e+01, 1.09331562e+01, 1.08344782e+01, 1.07267744e+01, 1.06122585e+01, 1.04930444e+01, 1.03708141e+01, 1.02467443e+01, 1.01215429e+01, 9.99570568e+00, 9.86946818e+00, 9.74294665e+00, 9.61628523e+00, 9.48952759e+00, 9.36269109e+00, 9.23581192e+00, 9.10894821e+00, 8.98204572e+00, 8.85511909e+00, 8.72823433e+00, 8.60132295e+00, 8.47440648e+00, 8.34750232e+00, 8.22061326e+00, 8.09373053e+00, 7.96684179e+00, 7.83995918e+00, 7.71312614e+00, 7.58627594e+00, 7.45944133e+00, 7.33264940e+00, 7.20586503e+00, 7.07909347e+00, 6.95236002e+00, 6.82567406e+00, 6.69901609e+00, 6.57240731e+00, 6.44585374e+00, 6.31935248e+00, 6.19292803e+00, 6.06656848e+00, 5.94032649e+00, 5.81418025e+00, 5.68814458e+00, 5.56225305e+00, 5.43653381e+00, 5.31097586e+00, 5.18563353e+00, 5.06053966e+00, 4.93569985e+00, 4.81116917e+00, 4.68698346e+00, 4.56320678e+00},
 { 1.11095870e+01, 1.11095794e+01, 1.11095750e+01, 1.11095611e+01, 1.11095471e+01, 1.11095216e+01, 1.11094828e+01, 1.11094242e+01, 1.11093300e+01, 1.11091969e+01, 1.11089970e+01, 1.11086981e+01, 1.11082615e+01, 1.11075870e+01, 1.11066040e+01, 1.11051657e+01, 1.11030675e+01, 1.11000128e+01, 1.10956132e+01, 1.10893185e+01, 1.10804265e+01, 1.10679937e+01, 1.10508680e+01, 1.10276537e+01, 1.09967753e+01, 1.09565886e+01, 1.09055585e+01, 1.08425284e+01, 1.07669848e+01, 1.06792657e+01, 1.05805918e+01, 1.04728831e+01, 1.03583688e+01, 1.02391559e+01, 1.01169151e+01, 9.99284629e+00, 9.86767757e+00, 9.74184450e+00, 9.61557349e+00, 9.48909118e+00, 9.36242291e+00, 9.23565108e+00, 9.10881526e+00, 8.98197878e+00, 8.85509557e+00, 8.72819390e+00, 8.60128663e+00, 8.47440618e+00, 8.34750239e+00, 8.22059511e+00, 8.09371616e+00, 7.96684923e+00, 7.83997175e+00, 7.71310354e+00, 7.58626717e+00, 7.45944965e+00, 7.33263459e+00, 7.20586633e+00, 7.07910759e+00, 6.95236549e+00, 6.82566450e+00, 6.69902285e+00, 6.57240799e+00, 6.44584980e+00, 6.31934379e+00, 6.19293221e+00, 6.06658081e+00, 5.94031526e+00, 5.81416883e+00, 5.68815203e+00, 5.56225579e+00, 5.43653247e+00, 5.31097474e+00, 5.18563564e+00, 5.06052628e+00, 4.93569964e+00, 4.81117098e+00, 4.68698880e+00, 4.56319802e+00, 4.43986808e+00, 4.31703392e+00},
 { 1.08556934e+01, 1.08556852e+01, 1.08556814e+01, 1.08556669e+01, 1.08556536e+01, 1.08556280e+01, 1.08555893e+01, 1.08555343e+01, 1.08554458e+01, 1.08553152e+01, 1.08551129e+01, 1.08548165e+01, 1.08543710e+01, 1.08537076e+01, 1.08527230e+01, 1.08512913e+01, 1.08491882e+01, 1.08461130e+01, 1.08417301e+01, 1.08354390e+01, 1.08265225e+01, 1.08140962e+01, 1.07969671e+01, 1.07737565e+01, 1.07428782e+01, 1.07026948e+01, 1.06516641e+01, 1.05886338e+01, 1.05130901e+01, 1.04253749e+01, 1.03267016e+01, 1.02189939e+01, 1.01044804e+01, 9.98527302e+00, 9.86304388e+00, 9.73898164e+00, 9.61381178e+00, 9.48795926e+00, 9.36171539e+00, 9.23522094e+00, 9.10855222e+00, 8.98178080e+00, 8.85498724e+00, 8.72813347e+00, 8.60122167e+00, 8.47435961e+00, 8.34747960e+00, 8.22060143e+00, 8.09370167e+00, 7.96683850e+00, 7.83997776e+00, 7.71310848e+00, 7.58624620e+00, 7.45945292e+00, 7.33264572e+00, 7.20584786e+00, 7.07910694e+00, 6.95237820e+00, 6.82566891e+00, 6.69901373e+00, 6.57240720e+00, 6.44584767e+00, 6.31935266e+00, 6.19291549e+00, 6.06658490e+00, 5.94032793e+00, 5.81416918e+00, 5.68814067e+00, 5.56226274e+00, 5.43652706e+00, 5.31098374e+00, 5.18564316e+00, 5.06053326e+00, 4.93569497e+00, 4.81117133e+00, 4.68699101e+00, 4.56320450e+00, 4.43986220e+00, 4.31703396e+00, 4.19476836e+00, 4.07313929e+00},
 { 1.06018048e+01, 1.06018000e+01, 1.06017928e+01, 1.06017874e+01, 1.06017650e+01, 1.06017395e+01, 1.06017008e+01, 1.06016479e+01, 1.06015595e+01, 1.06014305e+01, 1.06012267e+01, 1.06009319e+01, 1.06004714e+01, 1.05998067e+01, 1.05988288e+01, 1.05973939e+01, 1.05952910e+01, 1.05922363e+01, 1.05878332e+01, 1.05815450e+01, 1.05726460e+01, 1.05602167e+01, 1.05430915e+01, 1.05198780e+01, 1.04890028e+01, 1.04488144e+01, 1.03977848e+01, 1.03347562e+01, 1.02591905e+01, 1.01714713e+01, 1.00727989e+01, 9.96509350e+00, 9.85058212e+00, 9.73137995e+00, 9.60915701e+00, 9.48509423e+00, 9.35993020e+00, 9.23409915e+00, 9.10785835e+00, 8.98135889e+00, 8.85468809e+00, 8.72796031e+00, 8.60114986e+00, 8.47429873e+00, 8.34742858e+00, 8.22056555e+00, 8.09370117e+00, 7.96682050e+00, 7.83994872e+00, 7.71311775e+00, 7.58626846e+00, 7.45943844e+00, 7.33264549e+00, 7.20586344e+00, 7.07908880e+00, 6.95237645e+00, 6.82567421e+00, 6.69901355e+00, 6.57240366e+00, 6.44585395e+00, 6.31935256e+00, 6.19292533e+00, 6.06656875e+00, 5.94032651e+00, 5.81417864e+00, 5.68814283e+00, 5.56226152e+00, 5.43653283e+00, 5.31097898e+00, 5.18563003e+00, 5.06053083e+00, 4.93569769e+00, 4.81116657e+00, 4.68698267e+00, 4.56320651e+00, 4.43986540e+00, 4.31701780e+00, 4.19475633e+00, 4.07314423e+00, 3.95223351e+00, 3.83212682e+00},
 { 1.03479067e+01, 1.03479020e+01, 1.03478948e+01, 1.03478859e+01, 1.03478671e+01, 1.03478437e+01, 1.03478050e+01, 1.03477465e+01, 1.03476369e+01, 1.03475040e+01, 1.03473043e+01, 1.03470056e+01, 1.03465787e+01, 1.03459147e+01, 1.03449397e+01, 1.03435018e+01, 1.03414028e+01, 1.03383449e+01, 1.03339423e+01, 1.03276558e+01, 1.03187638e+01, 1.03063147e+01, 1.02891934e+01, 1.02659807e+01, 1.02351176e+01, 1.01949244e+01, 1.01438906e+01, 1.00808549e+01, 1.00053357e+01, 9.91759642e+00, 9.81893297e+00, 9.71122963e+00, 9.59673707e+00, 9.47751369e+00, 9.35531104e+00, 9.23125158e+00, 9.10607343e+00, 8.98024702e+00, 8.85400609e+00, 8.72749889e+00, 8.60087705e+00, 8.47413265e+00, 8.34731550e+00, 8.22048858e+00, 8.09364843e+00, 7.96680398e+00, 7.83994591e+00, 7.71308530e+00, 7.58627220e+00, 7.45944310e+00, 7.33263102e+00, 7.20586187e+00, 7.07910360e+00, 6.95236036e+00, 6.82568090e+00, 6.69901868e+00, 6.57240631e+00, 6.44584993e+00, 6.31935720e+00, 6.19292559e+00, 6.06658101e+00, 5.94031554e+00, 5.81418059e+00, 5.68815217e+00, 5.56225593e+00, 5.43653107e+00, 5.31098417e+00, 5.18563574e+00, 5.06052662e+00, 4.93570500e+00, 4.81117276e+00, 4.68698904e+00, 4.56319723e+00, 4.43986779e+00, 4.31703269e+00, 4.19476279e+00, 4.07313178e+00, 3.95223802e+00, 3.83213445e+00, 3.71292776e+00, 3.59473600e+00},
 { 1.00940168e+01, 1.00940163e+01, 1.00940050e+01, 1.00939941e+01, 1.00939815e+01, 1.00939519e+01, 1.00939134e+01, 1.00938549e+01, 1.00937683e+01, 1.00936338e+01, 1.00934359e+01, 1.00931205e+01, 1.00926753e+01, 1.00920108e+01, 1.00910366e+01, 1.00895989e+01, 1.00875160e+01, 1.00844424e+01, 1.00800596e+01, 1.00737742e+01, 1.00648793e+01, 1.00524509e+01, 1.00353270e+01, 1.00121184e+01, 9.98124230e+00, 9.94104161e+00, 9.89001406e+00, 9.82699047e+00, 9.75145092e+00, 9.66373468e+00, 9.56506702e+00, 9.45736612e+00, 9.34285979e+00, 9.22365250e+00, 9.10144477e+00, 8.97739035e+00, 8.85222783e+00, 8.72640057e+00, 8.60015451e+00, 8.47369660e+00, 8.34706017e+00, 8.22032655e+00, 8.09353166e+00, 7.96672587e+00, 7.83990743e+00, 7.71306586e+00, 7.58623291e+00, 7.45943883e+00, 7.33263245e+00, 7.20583526e+00, 7.07910283e+00, 6.95237303e+00, 6.82566921e+00, 6.69900828e+00, 6.57241541e+00, 6.44584500e+00, 6.31934906e+00, 6.19292819e+00, 6.06658494e+00, 5.94032585e+00, 5.81416658e+00, 5.68814085e+00, 5.56226292e+00, 5.43652611e+00, 5.31098389e+00, 5.18564331e+00, 5.06053177e+00, 4.93569176e+00, 4.81117163e+00, 4.68699117e+00, 4.56320243e+00, 4.43985955e+00, 4.31703409e+00, 4.19476715e+00, 4.07313798e+00, 3.95222409e+00, 3.83213773e+00, 3.71293343e+00, 3.59473222e+00, 3.47765806e+00, 3.36180912e+00},
 { 9.84010902e+00, 9.84012947e+00, 9.84009729e+00, 9.84008640e+00, 9.84006976e+00, 9.84005255e+00, 9.84000591e+00, 9.83995571e+00, 9.83986759e+00, 9.83973483e+00, 9.83953546e+00, 9.83924446e+00, 9.83879946e+00, 9.83813851e+00, 9.83716132e+00, 9.83572130e+00, 9.83362181e+00, 9.83056828e+00, 9.82616390e+00, 9.81985191e+00, 9.81098023e+00, 9.79853030e+00, 9.78140768e+00, 9.75820298e+00, 9.72732174e+00, 9.68714331e+00, 9.63611837e+00, 9.57310001e+00, 9.49755719e+00, 9.40985001e+00, 9.31118590e+00, 9.20348804e+00, 9.08898739e+00, 8.96979420e+00, 8.84758609e+00, 8.72353757e+00, 8.59839082e+00, 8.47255949e+00, 8.34636233e+00, 8.21989280e+00, 8.09326694e+00, 7.96655003e+00, 7.83979383e+00, 7.71300753e+00, 7.58619636e+00, 7.45937837e+00, 7.33261862e+00, 7.20584448e+00, 7.07907847e+00, 6.95236804e+00, 6.82567790e+00, 6.69901117e+00, 6.57239767e+00, 6.44584934e+00, 6.31935059e+00, 6.19292164e+00, 6.06658115e+00, 5.94032883e+00, 5.81417877e+00, 5.68814304e+00, 5.56225872e+00, 5.43653176e+00, 5.31097553e+00, 5.18564295e+00, 5.06053883e+00, 4.93569778e+00, 4.81116687e+00, 4.68699141e+00, 4.56320583e+00, 4.43986563e+00, 4.31702588e+00, 4.19476898e+00, 4.07314330e+00, 3.95223374e+00, 3.83212411e+00, 3.71293763e+00, 3.59473835e+00, 3.47764983e+00, 3.36181629e+00, 3.24733750e+00, 3.13437776e+00},
 { 9.58620979e+00, 9.58621065e+00, 9.58620361e+00, 9.58619705e+00, 9.58617623e+00, 9.58615525e+00, 9.58611687e+00, 9.58605867e+00, 9.58597071e+00, 9.58583813e+00, 9.58565414e+00, 9.58535600e+00, 9.58491130e+00, 9.58425071e+00, 9.58327394e+00, 9.58183913e+00, 9.57973547e+00, 9.57668489e+00, 9.57227997e+00, 9.56599508e+00, 9.55710793e+00, 9.54468141e+00, 9.52754883e+00, 9.50434924e+00, 9.47346511e+00, 9.43328709e+00, 9.38225294e+00, 9.31924312e+00, 9.24369839e+00, 9.15598976e+00, 9.05733024e+00, 8.94963807e+00, 8.83512771e+00, 8.71593761e+00, 8.59373784e+00, 8.46969965e+00, 8.34456037e+00, 8.21878027e+00, 8.09257276e+00, 7.96611669e+00, 7.83951049e+00, 7.71283058e+00, 7.58609931e+00, 7.45933195e+00, 7.33255547e+00, 7.20581679e+00, 7.07907670e+00, 6.95234377e+00, 6.82566852e+00, 6.69901608e+00, 6.57239984e+00, 6.44584388e+00, 6.31935587e+00, 6.19292326e+00, 6.06657783e+00, 5.94031406e+00, 5.81417920e+00, 5.68815054e+00, 5.56225424e+00, 5.43653125e+00, 5.31098432e+00, 5.18563491e+00, 5.06053837e+00, 4.93569647e+00, 4.81117111e+00, 4.68698657e+00, 4.56319757e+00, 4.43986796e+00, 4.31703114e+00, 4.19475941e+00, 4.07313214e+00, 3.95223821e+00, 3.83213226e+00, 3.71292749e+00, 3.59474152e+00, 3.47765882e+00, 3.36180853e+00, 3.24734517e+00, 3.13437248e+00, 3.02306533e+00, 2.91356932e+00},
 { 9.33234104e+00, 9.33232407e+00, 9.33231711e+00, 9.33229821e+00, 9.33228178e+00, 9.33225667e+00, 9.33222151e+00, 9.33216044e+00, 9.33207575e+00, 9.33194036e+00, 9.33176721e+00, 9.33146940e+00, 9.33102507e+00, 9.33036494e+00, 9.32939194e+00, 9.32795564e+00, 9.32585149e+00, 9.32280280e+00, 9.31838074e+00, 9.31211500e+00, 9.30320130e+00, 9.29077684e+00, 9.27365643e+00, 9.25044932e+00, 9.21958493e+00, 9.17940565e+00, 9.12838527e+00, 9.06536767e+00, 8.98984163e+00, 8.90213766e+00, 8.80348342e+00, 8.69579859e+00, 8.58131404e+00, 8.46213296e+00, 8.33994340e+00, 8.21591822e+00, 8.09077552e+00, 7.96500821e+00, 7.83881758e+00, 7.71237671e+00, 7.58580314e+00, 7.45916557e+00, 7.33246186e+00, 7.20573025e+00, 7.07903307e+00, 6.95233032e+00, 6.82563835e+00, 6.69900788e+00, 6.57240491e+00, 6.44584022e+00, 6.31934081e+00, 6.19292228e+00, 6.06657733e+00, 5.94032516e+00, 5.81416491e+00, 5.68815209e+00, 5.56226290e+00, 5.43652442e+00, 5.31098256e+00, 5.18564322e+00, 5.06053196e+00, 4.93569219e+00, 4.81116825e+00, 4.68698909e+00, 4.56320278e+00, 4.43986756e+00, 4.31703387e+00, 4.19476741e+00, 4.07313828e+00, 3.95223548e+00, 3.83213766e+00, 3.71293366e+00, 3.59473243e+00, 3.47766177e+00, 3.36180943e+00, 3.24734452e+00, 3.13437366e+00, 3.02306453e+00, 2.91356901e+00, 2.80605024e+00, 2.70068168e+00},
 { 9.07844222e+00, 9.07843782e+00, 9.07843335e+00, 9.07842277e+00, 9.07840649e+00, 9.07838157e+00, 9.07834537e+00, 9.07828580e+00, 9.07820015e+00, 9.07805017e+00, 9.07784584e+00, 9.07754850e+00, 9.07710471e+00, 9.07644521e+00, 9.07547554e+00, 9.07404010e+00, 9.07194030e+00, 9.06889407e+00, 9.06449531e+00, 9.05820918e+00, 9.04931924e+00, 9.03690063e+00, 9.01977901e+00, 8.99657859e+00, 8.96571174e+00, 8.92553481e+00, 8.87452070e+00, 8.81151188e+00, 8.73598923e+00, 8.64829274e+00, 8.54964649e+00, 8.44197369e+00, 8.32749777e+00, 8.20832975e+00, 8.08615440e+00, 7.96214667e+00, 7.83703301e+00, 7.71127895e+00, 7.58510473e+00, 7.45870746e+00, 7.33219055e+00, 7.20557308e+00, 7.07889060e+00, 6.95224640e+00, 6.82560837e+00, 6.69897042e+00, 6.57238711e+00, 6.44584095e+00, 6.31933789e+00, 6.19291544e+00, 6.06657380e+00, 5.94031880e+00, 5.81417530e+00, 5.68812919e+00, 5.56225834e+00, 5.43653012e+00, 5.31097396e+00, 5.18563322e+00, 5.06053880e+00, 4.93569759e+00, 4.81116392e+00, 4.68699187e+00, 4.56320617e+00, 4.43986379e+00, 4.31702145e+00, 4.19476930e+00, 4.07314225e+00, 3.95223115e+00, 3.83212451e+00, 3.71293792e+00, 3.59473780e+00, 3.47765330e+00, 3.36181671e+00, 3.24733641e+00, 3.13437271e+00, 3.02306292e+00, 2.91356880e+00, 2.80605206e+00, 2.70068050e+00, 2.59762871e+00, 2.49708660e+00},
 { 8.82454607e+00, 8.82454181e+00, 8.82453743e+00, 8.82452702e+00, 8.82451097e+00, 8.82448055e+00, 8.82444284e+00, 8.82438542e+00, 8.82429836e+00, 8.82417812e+00, 8.82399063e+00, 8.82368347e+00, 8.82325084e+00, 8.82258173e+00, 8.82160719e+00, 8.82017288e+00, 8.81807439e+00, 8.81501951e+00, 8.81060752e+00, 8.80432346e+00, 8.79543593e+00, 8.78302201e+00, 8.76590132e+00, 8.74270621e+00, 8.71184297e+00, 8.67167117e+00, 8.62066151e+00, 8.55765871e+00, 8.48213561e+00, 8.39445085e+00, 8.29581669e+00, 8.18815333e+00, 8.07369237e+00, 7.95455182e+00, 7.83239275e+00, 7.70841633e+00, 7.58334063e+00, 7.45759955e+00, 7.33146914e+00, 7.20513572e+00, 7.07864404e+00, 6.95207302e+00, 6.82549773e+00, 6.69890949e+00, 6.57233407e+00, 6.44579710e+00, 6.31932575e+00, 6.19290860e+00, 6.06656426e+00, 5.94032003e+00, 5.81417548e+00, 5.68814624e+00, 5.56224008e+00, 5.43652817e+00, 5.31098298e+00, 5.18563332e+00, 5.06052888e+00, 4.93570441e+00, 4.81117146e+00, 4.68698376e+00, 4.56320431e+00, 4.43986757e+00, 4.31703162e+00, 4.19475631e+00, 4.07314130e+00, 3.95223756e+00, 3.83213272e+00, 3.71292510e+00, 3.59474189e+00, 3.47765915e+00, 3.36180900e+00, 3.24733683e+00, 3.13437282e+00, 3.02306577e+00, 2.91356704e+00, 2.80604838e+00, 2.70068063e+00, 2.59763171e+00, 2.49708201e+00, 2.39922233e+00, 2.30422204e+00},
 { 8.57064036e+00, 8.57063627e+00, 8.57062979e+00, 8.57064346e+00, 8.57062770e+00, 8.57060769e+00, 8.57057353e+00, 8.57051341e+00, 8.57041538e+00, 8.57028450e+00, 8.57008137e+00, 8.56979144e+00, 8.56934343e+00, 8.56869185e+00, 8.56771866e+00, 8.56628587e+00, 8.56419187e+00, 8.56114465e+00, 8.55675218e+00, 8.55046885e+00, 8.54158705e+00, 8.52916844e+00, 8.51206100e+00, 8.48886563e+00, 8.45800799e+00, 8.41784445e+00, 8.36684127e+00, 8.30385054e+00, 8.22834647e+00, 8.14067146e+00, 8.04203237e+00, 7.93438701e+00, 7.81994556e+00, 7.70081803e+00, 7.57869048e+00, 7.45474111e+00, 7.32970275e+00, 7.20400083e+00, 7.07794462e+00, 6.95164677e+00, 6.82520861e+00, 6.69873511e+00, 6.57223219e+00, 6.44573312e+00, 6.31928871e+00, 6.19288791e+00, 6.06654960e+00, 5.94030622e+00, 5.81416692e+00, 5.68813933e+00, 5.56225775e+00, 5.43652259e+00, 5.31097960e+00, 5.18564170e+00, 5.06053103e+00, 4.93570361e+00, 4.81117615e+00, 4.68699185e+00, 4.56320068e+00, 4.43986664e+00, 4.31703233e+00, 4.19476630e+00, 4.07313517e+00, 3.95223600e+00, 3.83213716e+00, 3.71293300e+00, 3.59473252e+00, 3.47765617e+00, 3.36181758e+00, 3.24733624e+00, 3.13437417e+00, 3.02306427e+00, 2.91357022e+00, 2.80605075e+00, 2.70067902e+00, 2.59763291e+00, 2.49708501e+00, 2.39921837e+00, 2.30422248e+00, 2.21226182e+00, 2.12350868e+00},
 { 8.31676883e+00, 8.31676500e+00, 8.31675880e+00, 8.31674898e+00, 8.31671353e+00, 8.31668966e+00, 8.31665284e+00, 8.31659654e+00, 8.31652432e+00, 8.31639429e+00, 8.31619808e+00, 8.31590337e+00, 8.31546531e+00, 8.31480668e+00, 8.31383531e+00, 8.31240463e+00, 8.31031314e+00, 8.30726879e+00, 8.30287952e+00, 8.29660054e+00, 8.28772278e+00, 8.27530947e+00, 8.25820802e+00, 8.23501984e+00, 8.20417095e+00, 8.16401678e+00, 8.11302881e+00, 8.05004654e+00, 7.97455674e+00, 7.88689975e+00, 7.78829006e+00, 7.68066882e+00, 7.56625997e+00, 7.44716321e+00, 7.32506827e+00, 7.20115657e+00, 7.07614750e+00, 6.95053310e+00, 6.82452259e+00, 6.69828343e+00, 6.57195718e+00, 6.44556802e+00, 6.31916948e+00, 6.19280447e+00, 6.06650711e+00, 5.94027869e+00, 5.81414670e+00, 5.68812235e+00, 5.56224842e+00, 5.43652244e+00, 5.31096827e+00, 5.18562998e+00, 5.06053719e+00, 4.93569657e+00, 4.81117519e+00, 4.68698895e+00, 4.56320473e+00, 4.43986195e+00, 4.31703247e+00, 4.19476967e+00, 4.07314313e+00, 3.95222951e+00, 3.83213604e+00, 3.71293840e+00, 3.59473856e+00, 3.47765357e+00, 3.36181460e+00, 3.24733720e+00, 3.13437158e+00, 3.02306548e+00, 2.91356937e+00, 2.80605270e+00, 2.70067916e+00, 2.59762978e+00, 2.49708601e+00, 2.39922250e+00, 2.30422066e+00, 2.21226155e+00, 2.12351196e+00, 2.03813312e+00, 1.95628284e+00},
 { 8.06287241e+00, 8.06286889e+00, 8.06286309e+00, 8.06285374e+00, 8.06284940e+00, 8.06282249e+00, 8.06279006e+00, 8.06273462e+00, 8.06263291e+00, 8.06250403e+00, 8.06230916e+00, 8.06201601e+00, 8.06157962e+00, 8.06092325e+00, 8.05995686e+00, 8.05852900e+00, 8.05643816e+00, 8.05341362e+00, 8.04901607e+00, 8.04274408e+00, 8.03387028e+00, 8.02146599e+00, 8.00437038e+00, 7.98119523e+00, 7.95035290e+00, 7.91021429e+00, 7.85923879e+00, 7.79626903e+00, 7.72080338e+00, 7.63317174e+00, 7.53459817e+00, 7.42700673e+00, 7.31263028e+00, 7.19357455e+00, 7.07152980e+00, 6.94767250e+00, 6.82274092e+00, 6.69718066e+00, 6.57124787e+00, 6.44513032e+00, 6.31890348e+00, 6.19263464e+00, 6.06639067e+00, 5.94021049e+00, 5.81410191e+00, 5.68810516e+00, 5.56222234e+00, 5.43651249e+00, 5.31097235e+00, 5.18562826e+00, 5.06052460e+00, 4.93570187e+00, 4.81117081e+00, 4.68698333e+00, 4.56321011e+00, 4.43986665e+00, 4.31703063e+00, 4.19475771e+00, 4.07313212e+00, 3.95223741e+00, 3.83213217e+00, 3.71292643e+00, 3.59473401e+00, 3.47765941e+00, 3.36181307e+00, 3.24733794e+00, 3.13437251e+00, 3.02306536e+00, 2.91356807e+00, 2.80605077e+00, 2.70068148e+00, 2.59763249e+00, 2.49708350e+00, 2.39922363e+00, 2.30422271e+00, 2.21225738e+00, 2.12350900e+00, 2.03813576e+00, 1.95628105e+00, 1.87809171e+00, 1.80367628e+00},
 { 7.80899970e+00, 7.80899659e+00, 7.80899132e+00, 7.80896344e+00, 7.80894931e+00, 7.80892686e+00, 7.80889179e+00, 7.80884776e+00, 7.80876430e+00, 7.80863462e+00, 7.80844393e+00, 7.80815053e+00, 7.80771412e+00, 7.80706544e+00, 7.80609757e+00, 7.80467353e+00, 7.80258723e+00, 7.79955385e+00, 7.79517121e+00, 7.78890838e+00, 7.78004298e+00, 7.76764779e+00, 7.75056359e+00, 7.72738155e+00, 7.69657416e+00, 7.65643304e+00, 7.60548417e+00, 7.54253505e+00, 7.46709270e+00, 7.37949424e+00, 7.28096172e+00, 7.17341539e+00, 7.05908434e+00, 6.94008651e+00, 6.81809918e+00, 6.69431979e+00, 6.56947862e+00, 6.44400356e+00, 6.31820302e+00, 6.19220515e+00, 6.06611935e+00, 5.94003403e+00, 5.81399849e+00, 5.68803268e+00, 5.56219024e+00, 5.43647765e+00, 5.31095506e+00, 5.18562562e+00, 5.06052113e+00, 4.93568975e+00, 4.81117424e+00, 4.68699093e+00, 4.56319801e+00, 4.43986450e+00, 4.31703380e+00, 4.19476582e+00, 4.07313347e+00, 3.95223731e+00, 3.83213890e+00, 3.71293299e+00, 3.59473155e+00, 3.47765654e+00, 3.36181920e+00, 3.24734071e+00, 3.13437326e+00, 3.02306564e+00, 2.91357018e+00, 2.80604948e+00, 2.70067894e+00, 2.59763328e+00, 2.49708606e+00, 2.39921935e+00, 2.30422298e+00, 2.21226187e+00, 2.12350955e+00, 2.03813299e+00, 1.95628429e+00, 1.87808836e+00, 1.80367617e+00, 1.73312996e+00, 1.66653692e+00},
 { 7.55509267e+00, 7.55509019e+00, 7.55508561e+00, 7.55507769e+00, 7.55506791e+00, 7.55504321e+00, 7.55500946e+00, 7.55496453e+00, 7.55488291e+00, 7.55475894e+00, 7.55456709e+00, 7.55428017e+00, 7.55384708e+00, 7.55319996e+00, 7.55223437e+00, 7.55082007e+00, 7.54873533e+00, 7.54570716e+00, 7.54133456e+00, 7.53507940e+00, 7.52623467e+00, 7.51383700e+00, 7.49678377e+00, 7.47363503e+00, 7.44282231e+00, 7.40271930e+00, 7.35177760e+00, 7.28886687e+00, 7.21345851e+00, 7.12589738e+00, 7.02740838e+00, 6.91990444e+00, 6.80563783e+00, 6.68672747e+00, 6.56481595e+00, 6.44114638e+00, 6.31641642e+00, 6.19109497e+00, 6.06543211e+00, 5.93959654e+00, 5.81371664e+00, 5.68786407e+00, 5.56208051e+00, 5.43641861e+00, 5.31090290e+00, 5.18559682e+00, 5.06051392e+00, 4.93568163e+00, 4.81115880e+00, 4.68699106e+00, 4.56320610e+00, 4.43986273e+00, 4.31703083e+00, 4.19476982e+00, 4.07314383e+00, 3.95223217e+00, 3.83213055e+00, 3.71293990e+00, 3.59473988e+00, 3.47765603e+00, 3.36181573e+00, 3.24734684e+00, 3.13437399e+00, 3.02306524e+00, 2.91357064e+00, 2.80605360e+00, 2.70068167e+00, 2.59763103e+00, 2.49708835e+00, 2.39922254e+00, 2.30421904e+00, 2.21226295e+00, 2.12351315e+00, 2.03813367e+00, 1.95628394e+00, 1.87808840e+00, 1.80367428e+00, 1.73312596e+00, 1.66653446e+00, 1.60393272e+00, 1.54534028e+00},
 { 7.30120401e+00, 7.30120231e+00, 7.30119307e+00, 7.30119183e+00, 7.30117997e+00, 7.30116022e+00, 7.30113547e+00, 7.30108478e+00, 7.30100924e+00, 7.30088313e+00, 7.30069960e+00, 7.30041530e+00, 7.29998939e+00, 7.29934483e+00, 7.29839253e+00, 7.29697803e+00, 7.29490876e+00, 7.29189017e+00, 7.28752850e+00, 7.28128606e+00, 7.27244834e+00, 7.26008413e+00, 7.24303417e+00, 7.21990806e+00, 7.18912298e+00, 7.14905997e+00, 7.09816422e+00, 7.03529366e+00, 6.95993729e+00, 6.87243216e+00, 6.77400428e+00, 6.66658330e+00, 6.55240324e+00, 6.43357467e+00, 6.31177581e+00, 6.18823691e+00, 6.06365579e+00, 5.93849597e+00, 5.81302354e+00, 5.68742503e+00, 5.56180789e+00, 5.43624642e+00, 5.31080539e+00, 5.18552399e+00, 5.06046255e+00, 4.93566476e+00, 4.81114843e+00, 4.68697844e+00, 4.56320360e+00, 4.43986721e+00, 4.31702886e+00, 4.19476977e+00, 4.07313528e+00, 3.95223923e+00, 3.83213348e+00, 3.71294053e+00, 3.59474408e+00, 3.47766192e+00, 3.36181619e+00, 3.24734504e+00, 3.13438299e+00, 3.02307499e+00, 2.91357290e+00, 2.80605273e+00, 2.70068320e+00, 2.59763322e+00, 2.49708596e+00, 2.39922536e+00, 2.30422378e+00, 2.21225955e+00, 2.12351372e+00, 2.03813742e+00, 1.95628264e+00, 1.87809178e+00, 1.80367333e+00, 1.73313339e+00, 1.66653287e+00, 1.60393167e+00, 1.54534427e+00, 1.49075081e+00, 1.44012297e+00},
 { 7.04733443e+00, 7.04733564e+00, 7.04733321e+00, 7.04732785e+00, 7.04731773e+00, 7.04730003e+00, 7.04727010e+00, 7.04720635e+00, 7.04714618e+00, 7.04702766e+00, 7.04682914e+00, 7.04655007e+00, 7.04613214e+00, 7.04549731e+00, 7.04455056e+00, 7.04315223e+00, 7.04108754e+00, 7.03808543e+00, 7.03373493e+00, 7.02751355e+00, 7.01869414e+00, 7.00635287e+00, 6.98933049e+00, 6.96623887e+00, 6.93549446e+00, 6.89546964e+00, 6.84462758e+00, 6.78181258e+00, 6.70651786e+00, 6.61908456e+00, 6.52074589e+00, 6.41342317e+00, 6.29935422e+00, 6.18065344e+00, 6.05902302e+00, 5.93564010e+00, 5.81124970e+00, 5.68631619e+00, 5.56110861e+00, 5.43580266e+00, 5.31053360e+00, 5.18536167e+00, 5.06035688e+00, 4.93558938e+00, 4.81111181e+00, 4.68695670e+00, 4.56318637e+00, 4.43985414e+00, 4.31703058e+00, 4.19476417e+00, 4.07314622e+00, 3.95223173e+00, 3.83214273e+00, 3.71293856e+00, 3.59474723e+00, 3.47766066e+00, 3.36182388e+00, 3.24734499e+00, 3.13438193e+00, 3.02307676e+00, 2.91357504e+00, 2.80605569e+00, 2.70068139e+00, 2.59763529e+00, 2.49708799e+00, 2.39922361e+00, 2.30422647e+00, 2.21226389e+00, 2.12351091e+00, 2.03813855e+00, 1.95628635e+00, 1.87809053e+00, 1.80367820e+00, 1.73313582e+00, 1.66653747e+00, 1.60392987e+00, 1.54534250e+00, 1.49075432e+00, 1.44012420e+00, 1.39339095e+00, 1.35045875e+00},
 { 6.79345579e+00, 6.79345631e+00, 6.79345867e+00, 6.79345523e+00, 6.79344614e+00, 6.79343101e+00, 6.79339633e+00, 6.79335884e+00, 6.79328076e+00, 6.79317385e+00, 6.79299722e+00, 6.79273374e+00, 6.79231062e+00, 6.79169413e+00, 6.79075846e+00, 6.78936877e+00, 6.78732321e+00, 6.78432660e+00, 6.78000788e+00, 6.77379796e+00, 6.76501300e+00, 6.75269526e+00, 6.73570888e+00, 6.71263954e+00, 6.68196250e+00, 6.64197412e+00, 6.59119429e+00, 6.52845926e+00, 6.45325040e+00, 6.36591488e+00, 6.26768789e+00, 6.16049920e+00, 6.04657542e+00, 5.92805127e+00, 5.80661836e+00, 5.68346231e+00, 5.55933911e+00, 5.43470347e+00, 5.30984273e+00, 5.18492715e+00, 5.06009623e+00, 4.93542388e+00, 4.81100696e+00, 4.68689530e+00, 4.56314898e+00, 4.43982954e+00, 4.31701478e+00, 4.19476283e+00, 4.07314262e+00, 3.95223554e+00, 3.83214256e+00, 3.71294468e+00, 3.59474638e+00, 3.47766190e+00, 3.36182260e+00, 3.24735419e+00, 3.13438473e+00, 3.02307297e+00, 2.91358391e+00, 2.80605918e+00, 2.70068510e+00, 2.59763767e+00, 2.49709341e+00, 2.39922813e+00, 2.30422553e+00, 2.21226732e+00, 2.12351676e+00, 2.03813781e+00, 1.95628761e+00, 1.87809546e+00, 1.80367268e+00, 1.73313694e+00, 1.66653635e+00, 1.60393531e+00, 1.54534021e+00, 1.49075338e+00, 1.44012569e+00, 1.39339473e+00, 1.35046086e+00, 1.31120189e+00, 1.27548048e+00},
 { 6.53958405e+00, 6.53957522e+00, 6.53959178e+00, 6.53958498e+00, 6.53958019e+00, 6.53957472e+00, 6.53955269e+00, 6.53951368e+00, 6.53944827e+00, 6.53934396e+00, 6.53917537e+00, 6.53891261e+00, 6.53850625e+00, 6.53789407e+00, 6.53697567e+00, 6.53560112e+00, 6.53357784e+00, 6.53061266e+00, 6.52631285e+00, 6.52014221e+00, 6.51138533e+00, 6.49911721e+00, 6.48218056e+00, 6.45918288e+00, 6.42855440e+00, 6.38865458e+00, 6.33796070e+00, 6.27531788e+00, 6.20021941e+00, 6.11301642e+00, 6.01493862e+00, 5.90790431e+00, 5.79418254e+00, 5.67588701e+00, 5.55470942e+00, 5.43185299e+00, 5.30807126e+00, 5.18381812e+00, 5.05940527e+00, 4.93499735e+00, 4.81073604e+00, 4.68671694e+00, 4.56305361e+00, 4.43977688e+00, 4.31698518e+00, 4.19474270e+00, 4.07313583e+00, 3.95223773e+00, 3.83213861e+00, 3.71294221e+00, 3.59475536e+00, 3.47767242e+00, 3.36182617e+00, 3.24735626e+00, 3.13439519e+00, 3.02308133e+00, 2.91358194e+00, 2.80606917e+00, 2.70069207e+00, 2.59764181e+00, 2.49709457e+00, 2.39923208e+00, 2.30423037e+00, 2.21226652e+00, 2.12351957e+00, 2.03814300e+00, 1.95628796e+00, 1.87809718e+00, 1.80368175e+00, 1.73313684e+00, 1.66653432e+00, 1.60393866e+00, 1.54534791e+00, 1.49075373e+00, 1.44012566e+00, 1.39339700e+00, 1.35045987e+00, 1.31120213e+00, 1.27548015e+00, 1.24312395e+00, 1.21394967e+00},
 { 6.28573031e+00, 6.28573581e+00, 6.28574099e+00, 6.28573049e+00, 6.28573344e+00, 6.28572687e+00, 6.28571056e+00, 6.28567832e+00, 6.28562076e+00, 6.28552375e+00, 6.28536571e+00, 6.28511592e+00, 6.28473026e+00, 6.28413554e+00, 6.28323376e+00, 6.28188770e+00, 6.27988945e+00, 6.27695563e+00, 6.27269173e+00, 6.26656359e+00, 6.25785398e+00, 6.24564247e+00, 6.22877035e+00, 6.20584485e+00, 6.17530459e+00, 6.13550420e+00, 6.08492421e+00, 6.02240968e+00, 5.94746478e+00, 5.86043294e+00, 5.76254668e+00, 5.65575092e+00, 5.54228899e+00, 5.42429099e+00, 5.30345424e+00, 5.18098754e+00, 5.05763624e+00, 4.93390305e+00, 4.81005827e+00, 4.68630378e+00, 4.56277718e+00, 4.43962212e+00, 4.31689017e+00, 4.19468620e+00, 4.07310390e+00, 3.95222582e+00, 3.83214068e+00, 3.71294475e+00, 3.59475897e+00, 3.47768341e+00, 3.36184079e+00, 3.24736383e+00, 3.13439927e+00, 3.02309435e+00, 2.91359874e+00, 2.80607016e+00, 2.70070441e+00, 2.59765168e+00, 2.49710111e+00, 2.39923624e+00, 2.30423839e+00, 2.21227549e+00, 2.12352227e+00, 2.03814883e+00, 1.95629537e+00, 1.87809632e+00, 1.80368460e+00, 1.73314264e+00, 1.66654275e+00, 1.60393319e+00, 1.54534551e+00, 1.49075835e+00, 1.44012794e+00, 1.39339769e+00, 1.35046123e+00, 1.31120640e+00, 1.27548260e+00, 1.24312393e+00, 1.21394822e+00, 1.18776425e+00, 1.16436034e+00},
 { 6.03188242e+00, 6.03188857e+00, 6.03189965e+00, 6.03190162e+00, 6.03191547e+00, 6.03190758e+00, 6.03189875e+00, 6.03187547e+00, 6.03182931e+00, 6.03174402e+00, 6.03160100e+00, 6.03135397e+00, 6.03098570e+00, 6.03041301e+00, 6.02953956e+00, 6.02823119e+00, 6.02626299e+00, 6.02337659e+00, 6.01916193e+00, 6.01309324e+00, 6.00444615e+00, 5.99231187e+00, 5.97552386e+00, 5.95269952e+00, 5.92227099e+00, 5.88260337e+00, 5.83216701e+00, 5.76982720e+00, 5.69508132e+00, 5.60827662e+00, 5.51065642e+00, 5.40416046e+00, 5.29104036e+00, 5.17342677e+00, 5.05303435e+00, 4.93107011e+00, 4.80830545e+00, 4.68521851e+00, 4.56211297e+00, 4.43920299e+00, 4.31663257e+00, 4.19453780e+00, 4.07302004e+00, 3.95217837e+00, 3.83211660e+00, 3.71294027e+00, 3.59475569e+00, 3.47769147e+00, 3.36184713e+00, 3.24737985e+00, 3.13441141e+00, 3.02310391e+00, 2.91360933e+00, 2.80609121e+00, 2.70071164e+00, 2.59766032e+00, 2.49711466e+00, 2.39924726e+00, 2.30424466e+00, 2.21228500e+00, 2.12353266e+00, 2.03815214e+00, 1.95630237e+00, 1.87810814e+00, 1.80368875e+00, 1.73314803e+00, 1.66654600e+00, 1.60394352e+00, 1.54534691e+00, 1.49075914e+00, 1.44013494e+00, 1.39340013e+00, 1.35046607e+00, 1.31120922e+00, 1.27548468e+00, 1.24312625e+00, 1.21395099e+00, 1.18776327e+00, 1.16436212e+00, 1.14353335e+00, 1.12506608e+00},
 { 5.77806725e+00, 5.77807798e+00, 5.77808493e+00, 5.77809522e+00, 5.77810303e+00, 5.77811379e+00, 5.77811687e+00, 5.77810532e+00, 5.77806988e+00, 5.77800199e+00, 5.77788072e+00, 5.77767127e+00, 5.77733115e+00, 5.77678834e+00, 5.77595238e+00, 5.77467723e+00, 5.77276284e+00, 5.76992713e+00, 5.76577505e+00, 5.75977740e+00, 5.75122373e+00, 5.73918212e+00, 5.72251079e+00, 5.69981941e+00, 5.66954034e+00, 5.63004347e+00, 5.57981238e+00, 5.51769525e+00, 5.44320166e+00, 5.35670390e+00, 5.25942405e+00, 5.15331766e+00, 5.04062964e+00, 4.92353081e+00, 4.80371444e+00, 4.68239169e+00, 4.56037059e+00, 4.43812838e+00, 4.31597726e+00, 4.19413501e+00, 4.07277039e+00, 3.95203772e+00, 3.83204349e+00, 3.71290220e+00, 3.59474071e+00, 3.47768745e+00, 3.36185487e+00, 3.24738816e+00, 3.13442937e+00, 3.02312092e+00, 2.91362469e+00, 2.80610432e+00, 2.70072523e+00, 2.59768380e+00, 2.49713243e+00, 2.39926364e+00, 2.30426017e+00, 2.21229940e+00, 2.12354409e+00, 2.03816885e+00, 1.95630834e+00, 1.87811762e+00, 1.80369821e+00, 1.73315412e+00, 1.66655718e+00, 1.60395139e+00, 1.54535640e+00, 1.49076526e+00, 1.44013986e+00, 1.39340218e+00, 1.35046325e+00, 1.31121285e+00, 1.27548666e+00, 1.24312865e+00, 1.21395391e+00, 1.18776458e+00, 1.16436345e+00, 1.14353606e+00, 1.12506949e+00, 1.10876316e+00, 1.09441155e+00},
 { 5.52427979e+00, 5.52429469e+00, 5.52430503e+00, 5.52429979e+00, 5.52433213e+00, 5.52435023e+00, 5.52437289e+00, 5.52438016e+00, 5.52436407e+00, 5.52431812e+00, 5.52422062e+00, 5.52404287e+00, 5.52373677e+00, 5.52323788e+00, 5.52244595e+00, 5.52122899e+00, 5.51938100e+00, 5.51661691e+00, 5.51255598e+00, 5.50665943e+00, 5.49821604e+00, 5.48631046e+00, 5.46978867e+00, 5.44727026e+00, 5.41719446e+00, 5.37792639e+00, 5.32795462e+00, 5.26614130e+00, 5.19199435e+00, 5.10587746e+00, 5.00903190e+00, 4.90343884e+00, 4.79133501e+00, 4.67486825e+00, 4.55579305e+00, 4.43532462e+00, 4.31425213e+00, 4.19306904e+00, 4.07213280e+00, 3.95165166e+00, 3.83181090e+00, 3.71276958e+00, 3.59468741e+00, 3.47766604e+00, 3.36185669e+00, 3.24740285e+00, 3.13445016e+00, 3.02314691e+00, 2.91365102e+00, 2.80613247e+00, 2.70076081e+00, 2.59770851e+00, 2.49715481e+00, 2.39929320e+00, 2.30428637e+00, 2.21231846e+00, 2.12356178e+00, 2.03818234e+00, 1.95632920e+00, 1.87812670e+00, 1.80371166e+00, 1.73316925e+00, 1.66656862e+00, 1.60396341e+00, 1.54537113e+00, 1.49077534e+00, 1.44014514e+00, 1.39341242e+00, 1.35047695e+00, 1.31121734e+00, 1.27549173e+00, 1.24313440e+00, 1.21395476e+00, 1.18776938e+00, 1.16436743e+00, 1.14353592e+00, 1.12507319e+00, 1.10876460e+00, 1.09441066e+00, 1.08181815e+00, 1.07080343e+00},
 { 5.27054418e+00, 5.27056487e+00, 5.27058589e+00, 5.27060729e+00, 5.27062538e+00, 5.27065492e+00, 5.27069469e+00, 5.27071752e+00, 5.27072919e+00, 5.27071080e+00, 5.27064750e+00, 5.27050862e+00, 5.27024995e+00, 5.26980608e+00, 5.26908237e+00, 5.26793789e+00, 5.26617523e+00, 5.26351465e+00, 5.25956518e+00, 5.25380061e+00, 5.24551323e+00, 5.23378109e+00, 5.21746242e+00, 5.19517448e+00, 5.16535998e+00, 5.12639253e+00, 5.07676427e+00, 5.01533390e+00, 4.94163198e+00, 4.85602924e+00, 4.75976830e+00, 4.65480767e+00, 4.54344466e+00, 4.42783147e+00, 4.30970476e+00, 4.19030373e+00, 4.07043960e+00, 3.95061461e+00, 3.83118881e+00, 3.71241894e+00, 3.59448026e+00, 3.47755772e+00, 3.36181586e+00, 3.24740583e+00, 3.13446693e+00, 3.02317648e+00, 2.91369047e+00, 2.80617577e+00, 2.70080181e+00, 2.59774911e+00, 2.49720021e+00, 2.39933011e+00, 2.30431686e+00, 2.21235602e+00, 2.12359989e+00, 2.03821458e+00, 1.95635810e+00, 1.87815644e+00, 1.80373781e+00, 1.73318871e+00, 1.66658691e+00, 1.60398028e+00, 1.54538352e+00, 1.49078943e+00, 1.44015696e+00, 1.39342396e+00, 1.35048490e+00, 1.31122693e+00, 1.27550082e+00, 1.24313917e+00, 1.21396335e+00, 1.18777610e+00, 1.16437030e+00, 1.14354170e+00, 1.12507770e+00, 1.10876812e+00, 1.09441515e+00, 1.08182084e+00, 1.07080357e+00, 1.06119217e+00, 1.05282705e+00},
 { 5.01688460e+00, 5.01690816e+00, 5.01693892e+00, 5.01696956e+00, 5.01699925e+00, 5.01704368e+00, 5.01709338e+00, 5.01714773e+00, 5.01718959e+00, 5.01720733e+00, 5.01718999e+00, 5.01710424e+00, 5.01690829e+00, 5.01653788e+00, 5.01589722e+00, 5.01485215e+00, 5.01320441e+00, 5.01067681e+00, 5.00688430e+00, 5.00129586e+00, 4.99320885e+00, 4.98171074e+00, 4.96565719e+00, 4.94367081e+00, 4.91420239e+00, 4.87562991e+00, 4.82644533e+00, 4.76553591e+00, 4.69241123e+00, 4.60744282e+00, 4.51192342e+00, 4.40781614e+00, 4.29740119e+00, 4.18285714e+00, 4.06593551e+00, 3.94788931e+00, 3.82954417e+00, 3.71142168e+00, 3.59390125e+00, 3.47723060e+00, 3.36165035e+00, 3.24732801e+00, 3.13445872e+00, 3.02320782e+00, 2.91373552e+00, 2.80623011e+00, 2.70086000e+00, 2.59781441e+00, 2.49725930e+00, 2.39938731e+00, 2.30438122e+00, 2.21241024e+00, 2.12364640e+00, 2.03826417e+00, 1.95640299e+00, 1.87819752e+00, 1.80377620e+00, 1.73322131e+00, 1.66662000e+00, 1.60400726e+00, 1.54540812e+00, 1.49081248e+00, 1.44018070e+00, 1.39344164e+00, 1.35050225e+00, 1.31124244e+00, 1.27551054e+00, 1.24315013e+00, 1.21397481e+00, 1.18778239e+00, 1.16437789e+00, 1.14354906e+00, 1.12508174e+00, 1.10877346e+00, 1.09441980e+00, 1.08182478e+00, 1.07080852e+00, 1.06119521e+00, 1.05282771e+00, 1.04556070e+00, 1.03926095e+00},
 { 4.76333195e+00, 4.76336219e+00, 4.76340220e+00, 4.76344256e+00, 4.76348961e+00, 4.76355204e+00, 4.76362433e+00, 4.76370967e+00, 4.76378699e+00, 4.76385119e+00, 4.76389094e+00, 4.76387417e+00, 4.76376039e+00, 4.76348684e+00, 4.76296087e+00, 4.76204750e+00, 4.76055224e+00, 4.75820081e+00, 4.75460932e+00, 4.74925395e+00, 4.74143580e+00, 4.73024336e+00, 4.71453593e+00, 4.69294976e+00, 4.66393339e+00, 4.62586252e+00, 4.57727420e+00, 4.51700840e+00, 4.44462850e+00, 4.36051529e+00, 4.26594518e+00, 4.16290723e+00, 4.05369666e+00, 3.94050348e+00, 3.82510199e+00, 3.70875317e+00, 3.59230485e+00, 3.47629568e+00, 3.36111267e+00, 3.24705128e+00, 3.13433949e+00, 3.02317508e+00, 2.91376248e+00, 2.80629718e+00, 2.70094289e+00, 2.59790013e+00, 2.49735085e+00, 2.39948257e+00, 2.30446756e+00, 2.21249153e+00, 2.12373092e+00, 2.03833824e+00, 1.95646866e+00, 1.87826366e+00, 1.80383096e+00, 1.73327647e+00, 1.66666140e+00, 1.60405366e+00, 1.54545162e+00, 1.49084746e+00, 1.44020970e+00, 1.39346897e+00, 1.35052814e+00, 1.31126242e+00, 1.27553373e+00, 1.24316661e+00, 1.21398785e+00, 1.18779695e+00, 1.16439151e+00, 1.14355774e+00, 1.12509089e+00, 1.10878302e+00, 1.09442515e+00, 1.08183054e+00, 1.07081198e+00, 1.06119984e+00, 1.05283320e+00, 1.04556416e+00, 1.03926215e+00, 1.03380813e+00, 1.02909152e+00},
 { 4.50994095e+00, 4.50998133e+00, 4.51003268e+00, 4.51008729e+00, 4.51015146e+00, 4.51023562e+00, 4.51033444e+00, 4.51044896e+00, 4.51057693e+00, 4.51069869e+00, 4.51080867e+00, 4.51088249e+00, 4.51087506e+00, 4.51072687e+00, 4.51034963e+00, 4.50960993e+00, 4.50831756e+00, 4.50619730e+00, 4.50287468e+00, 4.49782648e+00, 4.49034852e+00, 4.47956700e+00, 4.46431784e+00, 4.44323942e+00, 4.41481129e+00, 4.37741715e+00, 4.32956867e+00, 4.27016382e+00, 4.19873828e+00, 4.11569800e+00, 4.02233416e+00, 3.92064744e+00, 3.81295588e+00, 3.70145797e+00, 3.58795057e+00, 3.47371296e+00, 3.35959982e+00, 3.24619364e+00, 3.13387664e+00, 3.02296642e+00, 2.91371031e+00, 2.80633121e+00, 2.70102832e+00, 2.59801355e+00, 2.49748237e+00, 2.39961334e+00, 2.30459993e+00, 2.21262401e+00, 2.12385244e+00, 2.03845108e+00, 1.95658008e+00, 1.87836441e+00, 1.80392415e+00, 1.73336333e+00, 1.66674232e+00, 1.60412131e+00, 1.54550777e+00, 1.49090394e+00, 1.44026492e+00, 1.39351629e+00, 1.35056987e+00, 1.31130191e+00, 1.27556599e+00, 1.24319881e+00, 1.21401612e+00, 1.18781749e+00, 1.16440788e+00, 1.14357633e+00, 1.12510686e+00, 1.10879304e+00, 1.09443638e+00, 1.08183900e+00, 1.07081997e+00, 1.06120709e+00, 1.05283770e+00, 1.04556961e+00, 1.03926829e+00, 1.03381210e+00, 1.02909608e+00, 1.02502548e+00, 1.02151327e+00},
 { 4.25679254e+00, 4.25684220e+00, 4.25690309e+00, 4.25697838e+00, 4.25705728e+00, 4.25716714e+00, 4.25730375e+00, 4.25745832e+00, 4.25763483e+00, 4.25783174e+00, 4.25803148e+00, 4.25821274e+00, 4.25834156e+00, 4.25835756e+00, 4.25817405e+00, 4.25766148e+00, 4.25663222e+00, 4.25481878e+00, 4.25183698e+00, 4.24719171e+00, 4.24018422e+00, 4.22991710e+00, 4.21526329e+00, 4.19487175e+00, 4.16720305e+00, 4.13066756e+00, 4.08378517e+00, 4.02546291e+00, 3.95525158e+00, 3.87356821e+00, 3.78172629e+00, 3.68173535e+00, 3.57593621e+00, 3.46654623e+00, 3.35537701e+00, 3.24372910e+00, 3.13248093e+00, 3.02221513e+00, 2.91335154e+00, 2.80620882e+00, 2.70106384e+00, 2.59813207e+00, 2.49764271e+00, 2.39979734e+00, 2.30479746e+00, 2.21281682e+00, 2.12403939e+00, 2.03863484e+00, 1.95674822e+00, 1.87851826e+00, 1.80407101e+00, 1.73349632e+00, 1.66686577e+00, 1.60422597e+00, 1.54560962e+00, 1.49099382e+00, 1.44034457e+00, 1.39358880e+00, 1.35063433e+00, 1.31135801e+00, 1.27561613e+00, 1.24324239e+00, 1.21405249e+00, 1.18785574e+00, 1.16444146e+00, 1.14360249e+00, 1.12512739e+00, 1.10881263e+00, 1.09445479e+00, 1.08185470e+00, 1.07083403e+00, 1.06121937e+00, 1.05284634e+00, 1.04557820e+00, 1.03927424e+00, 1.03381849e+00, 1.02910061e+00, 1.02503006e+00, 1.02151761e+00, 1.01849186e+00, 1.01588501e+00},
 { 4.00398548e+00, 4.00404714e+00, 4.00412312e+00, 4.00421667e+00, 4.00432949e+00, 4.00447000e+00, 4.00463893e+00, 4.00484405e+00, 4.00508551e+00, 4.00535580e+00, 4.00566097e+00, 4.00598888e+00, 4.00628492e+00, 4.00649817e+00, 4.00656301e+00, 4.00634472e+00, 4.00565975e+00, 4.00424520e+00, 4.00173251e+00, 3.99761622e+00, 3.99120601e+00, 3.98162363e+00, 3.96774185e+00, 3.94821930e+00, 3.92153186e+00, 3.88609643e+00, 3.84044459e+00, 3.78349436e+00, 3.71481720e+00, 3.63483844e+00, 3.54489366e+00, 3.44701140e+00, 3.34354798e+00, 3.23674271e+00, 3.12842470e+00, 3.01991716e+00, 2.91211203e+00, 2.80561035e+00, 2.70084936e+00, 2.59814518e+00, 2.49780011e+00, 2.40002954e+00, 2.30506164e+00, 2.21309614e+00, 2.12432433e+00, 2.03890591e+00, 1.95700598e+00, 1.87876636e+00, 1.80429880e+00, 1.73370007e+00, 1.66705851e+00, 1.60440804e+00, 1.54576918e+00, 1.49113277e+00, 1.44047028e+00, 1.39370393e+00, 1.35073505e+00, 1.31144738e+00, 1.27569770e+00, 1.24330979e+00, 1.21411721e+00, 1.18791110e+00, 1.16448829e+00, 1.14364473e+00, 1.12516639e+00, 1.10884631e+00, 1.09448038e+00, 1.08187817e+00, 1.07085651e+00, 1.06123549e+00, 1.05286361e+00, 1.04559237e+00, 1.03928437e+00, 1.03382862e+00, 1.02911022e+00, 1.02503707e+00, 1.02152311e+00, 1.01849718e+00, 1.01588938e+00, 1.01364737e+00, 1.01171753e+00},
 { 3.75168312e+00, 3.75175864e+00, 3.75185202e+00, 3.75196799e+00, 3.75211045e+00, 3.75228712e+00, 3.75249934e+00, 3.75276388e+00, 3.75308424e+00, 3.75346290e+00, 3.75389476e+00, 3.75436683e+00, 3.75487233e+00, 3.75534332e+00, 3.75572542e+00, 3.75588013e+00, 3.75563866e+00, 3.75473967e+00, 3.75282505e+00, 3.74938940e+00, 3.74376049e+00, 3.73505986e+00, 3.72217237e+00, 3.70377007e+00, 3.67833712e+00, 3.64430066e+00, 3.60020645e+00, 3.54498571e+00, 3.47822345e+00, 3.40036703e+00, 3.31276546e+00, 3.21746939e+00, 3.11685474e+00, 3.01318119e+00, 2.90829638e+00, 2.80354036e+00, 2.69981509e+00, 2.59775007e+00, 2.49776894e+00, 2.40022266e+00, 2.30537372e+00, 2.21347512e+00, 2.12472342e+00, 2.03931097e+00, 1.95740475e+00, 1.87914066e+00, 1.80464761e+00, 1.73403194e+00, 1.66736006e+00, 1.60468015e+00, 1.54602082e+00, 1.49135995e+00, 1.44067386e+00, 1.39388359e+00, 1.35089504e+00, 1.31159146e+00, 1.27582349e+00, 1.24342547e+00, 1.21421485e+00, 1.18799307e+00, 1.16456496e+00, 1.14371140e+00, 1.12522383e+00, 1.10889694e+00, 1.09452609e+00, 1.08191780e+00, 1.07088656e+00, 1.06126605e+00, 1.05288648e+00, 1.04561183e+00, 1.03930434e+00, 1.03384230e+00, 1.02912241e+00, 1.02504944e+00, 1.02153411e+00, 1.01850548e+00, 1.01589584e+00, 1.01365356e+00, 1.01172222e+00, 1.01006389e+00, 1.00863723e+00},
 { 3.50010285e+00, 3.50019502e+00, 3.50030952e+00, 3.50045355e+00, 3.50062783e+00, 3.50084680e+00, 3.50111637e+00, 3.50145007e+00, 3.50185877e+00, 3.50234817e+00, 3.50292787e+00, 3.50359802e+00, 3.50434334e+00, 3.50512073e+00, 3.50588405e+00, 3.50651200e+00, 3.50683254e+00, 3.50659691e+00, 3.50544858e+00, 3.50289423e+00, 3.49826869e+00, 3.49069900e+00, 3.47908998e+00, 3.46211872e+00, 3.43827862e+00, 3.40600848e+00, 3.36387121e+00, 3.31079835e+00, 3.24641141e+00, 3.17116984e+00, 3.08642903e+00, 2.99426736e+00, 2.89707961e+00, 2.79714779e+00, 2.69633331e+00, 2.59598988e+00, 2.49702955e+00, 2.40009381e+00, 2.30560188e+00, 2.21389830e+00, 2.12525249e+00, 2.03988670e+00, 1.95798297e+00, 1.87970629e+00, 1.80519146e+00, 1.73453743e+00, 1.66782300e+00, 1.60511133e+00, 1.54641138e+00, 1.49171840e+00, 1.44099392e+00, 1.39417000e+00, 1.35115363e+00, 1.31181439e+00, 1.27602414e+00, 1.24360300e+00, 1.21436698e+00, 1.18813477e+00, 1.16468550e+00, 1.14381522e+00, 1.12531611e+00, 1.10897636e+00, 1.09459494e+00, 1.08197522e+00, 1.07094035e+00, 1.06130993e+00, 1.05292594e+00, 1.04564740e+00, 1.03933163e+00, 1.03386828e+00, 1.02914554e+00, 1.02506663e+00, 1.02154869e+00, 1.01851984e+00, 1.01590924e+00, 1.01366333e+00, 1.01172997e+00, 1.01007111e+00, 1.00864284e+00, 1.00741783e+00, 1.00636413e+00},
 { 3.24956960e+00, 3.24967194e+00, 3.24980726e+00, 3.24998600e+00, 3.25019651e+00, 3.25046443e+00, 3.25079748e+00, 3.25121087e+00, 3.25172130e+00, 3.25234367e+00, 3.25309318e+00, 3.25398158e+00, 3.25501157e+00, 3.25615224e+00, 3.25737389e+00, 3.25857064e+00, 3.25958733e+00, 3.26018394e+00, 3.26001116e+00, 3.25858260e+00, 3.25524254e+00, 3.24912554e+00, 3.23914252e+00, 3.22398183e+00, 3.20215060e+00, 3.17209620e+00, 3.13238435e+00, 3.08198401e+00, 3.02050458e+00, 2.94843052e+00, 2.86713593e+00, 2.77872099e+00, 2.68559667e+00, 2.59006166e+00, 2.49399359e+00, 2.39875196e+00, 2.30525834e+00, 2.21413655e+00, 2.12581420e+00, 2.04061494e+00, 1.95878898e+00, 1.88053456e+00, 1.80599896e+00, 1.73530634e+00, 1.66855032e+00, 1.60578013e+00, 1.54702408e+00, 1.49227391e+00, 1.44149467e+00, 1.39462029e+00, 1.35155474e+00, 1.31218021e+00, 1.27634453e+00, 1.24388416e+00, 1.21462135e+00, 1.18835115e+00, 1.16487158e+00, 1.14398287e+00, 1.12546151e+00, 1.10910211e+00, 1.09470518e+00, 1.08207293e+00, 1.07102229e+00, 1.06138199e+00, 1.05298906e+00, 1.04570027e+00, 1.03937793e+00, 1.03390967e+00, 1.02917790e+00, 1.02509609e+00, 1.02157547e+00, 1.01854064e+00, 1.01592654e+00, 1.01368001e+00, 1.01174526e+00, 1.01008193e+00, 1.00865208e+00, 1.00742625e+00, 1.00637082e+00, 1.00546654e+00, 1.00468864e+00},
 { 3.00049729e+00, 3.00062418e+00, 3.00079045e+00, 3.00100004e+00, 3.00125698e+00, 3.00158406e+00, 3.00198370e+00, 3.00248880e+00, 3.00311555e+00, 3.00388617e+00, 3.00482763e+00, 3.00596441e+00, 3.00731159e+00, 3.00887493e+00, 3.01062459e+00, 3.01249782e+00, 3.01435542e+00, 3.01597460e+00, 3.01701804e+00, 3.01700736e+00, 3.01528880e+00, 3.01100912e+00, 3.00308168e+00, 2.99020091e+00, 2.97088448e+00, 2.94358340e+00, 2.90687221e+00, 2.85972676e+00, 2.80176624e+00, 2.73348666e+00, 2.65629214e+00, 2.57227841e+00, 2.48389268e+00, 2.39344171e+00, 2.30279869e+00, 2.21334003e+00, 2.12598082e+00, 2.04131867e+00, 1.95978419e+00, 1.88165725e+00, 1.80716092e+00, 1.73645552e+00, 1.66964554e+00, 1.60680287e+00, 1.54797149e+00, 1.49314134e+00, 1.44227814e+00, 1.39532483e+00, 1.35219239e+00, 1.31274560e+00, 1.27684868e+00, 1.24433235e+00, 1.21501093e+00, 1.18869712e+00, 1.16517599e+00, 1.14424724e+00, 1.12568712e+00, 1.10930316e+00, 1.09487914e+00, 1.08222303e+00, 1.07115317e+00, 1.06149387e+00, 1.05308607e+00, 1.04578139e+00, 1.03945122e+00, 1.03396831e+00, 1.02923213e+00, 1.02514423e+00, 1.02161369e+00, 1.01857401e+00, 1.01595758e+00, 1.01370445e+00, 1.01176572e+00, 1.01010196e+00, 1.00866960e+00, 1.00743906e+00, 1.00638177e+00, 1.00547639e+00, 1.00469657e+00, 1.00402918e+00, 1.00345481e+00},
 { 2.75349462e+00, 2.75365001e+00, 2.75384236e+00, 2.75409041e+00, 2.75439599e+00, 2.75478161e+00, 2.75526521e+00, 2.75587156e+00, 2.75662757e+00, 2.75756501e+00, 2.75871951e+00, 2.76013181e+00, 2.76183683e+00, 2.76386426e+00, 2.76621393e+00, 2.76886059e+00, 2.77169521e+00, 2.77453065e+00, 2.77705154e+00, 2.77879043e+00, 2.77909929e+00, 2.77712010e+00, 2.77176801e+00, 2.76173531e+00, 2.74553874e+00, 2.72162242e+00, 2.68857899e+00, 2.64536802e+00, 2.59161629e+00, 2.52782881e+00, 2.45541675e+00, 2.37650498e+00, 2.29353975e+00, 2.20883772e+00, 2.12428959e+00, 2.04124550e+00, 1.96061171e+00, 1.88296638e+00, 1.80870627e+00, 1.73807513e+00, 1.67125370e+00, 1.60834997e+00, 1.54942072e+00, 1.49448045e+00, 1.44350464e+00, 1.39643836e+00, 1.35318717e+00, 1.31363568e+00, 1.27764020e+00, 1.24503208e+00, 1.21563228e+00, 1.18924237e+00, 1.16565451e+00, 1.14466489e+00, 1.12605537e+00, 1.10962047e+00, 1.09515280e+00, 1.08246246e+00, 1.07135934e+00, 1.06167194e+00, 1.05324069e+00, 1.04591645e+00, 1.03956622e+00, 1.03406792e+00, 1.02931937e+00, 1.02521384e+00, 1.02167712e+00, 1.01863058e+00, 1.01600258e+00, 1.01374363e+00, 1.01180171e+00, 1.01013062e+00, 1.00869372e+00, 1.00746221e+00, 1.00640192e+00, 1.00549151e+00, 1.00470950e+00, 1.00403952e+00, 1.00346419e+00, 1.00297144e+00, 1.00254706e+00},
 { 2.50934666e+00, 2.50953038e+00, 2.50975924e+00, 2.51005289e+00, 2.51041284e+00, 2.51087215e+00, 2.51143698e+00, 2.51215398e+00, 2.51305059e+00, 2.51416712e+00, 2.51555294e+00, 2.51725832e+00, 2.51935230e+00, 2.52188429e+00, 2.52490167e+00, 2.52839835e+00, 2.53233482e+00, 2.53656594e+00, 2.54081989e+00, 2.54465662e+00, 2.54743669e+00, 2.54829529e+00, 2.54613237e+00, 2.53962226e+00, 2.52726391e+00, 2.50748863e+00, 2.47887079e+00, 2.44035454e+00, 2.39157384e+00, 2.33301944e+00, 2.26611203e+00, 2.19298487e+00, 2.11610348e+00, 2.03777816e+00, 1.95989667e+00, 1.88380217e+00, 1.81036109e+00, 1.74014653e+00, 1.67348625e+00, 1.61058923e+00, 1.55157951e+00, 1.49650917e+00, 1.44538538e+00, 1.39815376e+00, 1.35473964e+00, 1.31502951e+00, 1.27888164e+00, 1.24613661e+00, 1.21660879e+00, 1.19009841e+00, 1.16640967e+00, 1.14532516e+00, 1.12663144e+00, 1.11012253e+00, 1.09558961e+00, 1.08284019e+00, 1.07168558e+00, 1.06195547e+00, 1.05348461e+00, 1.04612670e+00, 1.03974887e+00, 1.03422628e+00, 1.02945298e+00, 1.02533049e+00, 1.02177891e+00, 1.01871284e+00, 1.01607669e+00, 1.01380751e+00, 1.01185458e+00, 1.01017655e+00, 1.00873546e+00, 1.00749580e+00, 1.00643029e+00, 1.00551829e+00, 1.00473272e+00, 1.00405848e+00, 1.00347943e+00, 1.00298375e+00, 1.00255813e+00, 1.00219393e+00, 1.00187990e+00},
 { 2.26911442e+00, 2.26932679e+00, 2.26959226e+00, 2.26992891e+00, 2.27035210e+00, 2.27087936e+00, 2.27153744e+00, 2.27237159e+00, 2.27341658e+00, 2.27472488e+00, 2.27635497e+00, 2.27837956e+00, 2.28087698e+00, 2.28394103e+00, 2.28764908e+00, 2.29206192e+00, 2.29718891e+00, 2.30295835e+00, 2.30916153e+00, 2.31542249e+00, 2.32112445e+00, 2.32539444e+00, 2.32711361e+00, 2.32491608e+00, 2.31722807e+00, 2.30246596e+00, 2.27915017e+00, 2.24618889e+00, 2.20318798e+00, 2.15063418e+00, 2.08995022e+00, 2.02326706e+00, 1.95305090e+00, 1.88163060e+00, 1.81087762e+00, 1.74210669e+00, 1.67618324e+00, 1.61360032e+00, 1.55465558e+00, 1.49950061e+00, 1.44820671e+00, 1.40076963e+00, 1.35713010e+00, 1.31718891e+00, 1.28081955e+00, 1.24786153e+00, 1.21813749e+00, 1.19145135e+00, 1.16759814e+00, 1.14636288e+00, 1.12754033e+00, 1.11091272e+00, 1.09627841e+00, 1.08343615e+00, 1.07220422e+00, 1.06240248e+00, 1.05387052e+00, 1.04646100e+00, 1.04003561e+00, 1.03447362e+00, 1.02966727e+00, 1.02551581e+00, 1.02193652e+00, 1.01884926e+00, 1.01619539e+00, 1.01390618e+00, 1.01194110e+00, 1.01025111e+00, 1.00879747e+00, 1.00754955e+00, 1.00647873e+00, 1.00555761e+00, 1.00476769e+00, 1.00408949e+00, 1.00350624e+00, 1.00300581e+00, 1.00257603e+00, 1.00220851e+00, 1.00189293e+00, 1.00162318e+00, 1.00139021e+00},
 { 2.03412381e+00, 2.03436523e+00, 2.03466810e+00, 2.03504781e+00, 2.03552816e+00, 2.03612990e+00, 2.03688722e+00, 2.03784142e+00, 2.03903868e+00, 2.04053581e+00, 2.04241469e+00, 2.04476108e+00, 2.04767788e+00, 2.05128269e+00, 2.05570016e+00, 2.06104415e+00, 2.06740668e+00, 2.07479524e+00, 2.08310074e+00, 2.09203490e+00, 2.10104944e+00, 2.10929613e+00, 2.11562147e+00, 2.11858241e+00, 2.11653941e+00, 2.10777741e+00, 2.09074345e+00, 2.06428215e+00, 2.02794291e+00, 1.98217302e+00, 1.92838038e+00, 1.86871787e+00, 1.80565301e+00, 1.74151566e+00, 1.67817884e+00, 1.61694061e+00, 1.55860963e+00, 1.50364455e+00, 1.45229260e+00, 1.40465623e+00, 1.36074063e+00, 1.32049578e+00, 1.28381222e+00, 1.25054380e+00, 1.22052430e+00, 1.19356653e+00, 1.16945931e+00, 1.14799981e+00, 1.12897237e+00, 1.11216166e+00, 1.09736549e+00, 1.08438084e+00, 1.07302235e+00, 1.06310955e+00, 1.05448319e+00, 1.04698845e+00, 1.04049020e+00, 1.03486649e+00, 1.03000416e+00, 1.02580604e+00, 1.02218660e+00, 1.01906587e+00, 1.01637987e+00, 1.01406556e+00, 1.01207945e+00, 1.01036666e+00, 1.00889843e+00, 1.00763653e+00, 1.00655171e+00, 1.00561972e+00, 1.00482228e+00, 1.00413549e+00, 1.00354694e+00, 1.00304173e+00, 1.00260705e+00, 1.00223419e+00, 1.00191394e+00, 1.00164043e+00, 1.00140553e+00, 1.00120503e+00, 1.00103148e+00},
 { 1.80602155e+00, 1.80628875e+00, 1.80662775e+00, 1.80705302e+00, 1.80758995e+00, 1.80826508e+00, 1.80911481e+00, 1.81018310e+00, 1.81152898e+00, 1.81321589e+00, 1.81533622e+00, 1.81799321e+00, 1.82131229e+00, 1.82544140e+00, 1.83054803e+00, 1.83680562e+00, 1.84437864e+00, 1.85338626e+00, 1.86383727e+00, 1.87556477e+00, 1.88814576e+00, 1.90081484e+00, 1.91240627e+00, 1.92140397e+00, 1.92602081e+00, 1.92437732e+00, 1.91474263e+00, 1.89582495e+00, 1.86706447e+00, 1.82886498e+00, 1.78260728e+00, 1.73044054e+00, 1.67486150e+00, 1.61822174e+00, 1.56238186e+00, 1.50862840e+00, 1.45774309e+00, 1.41014021e+00, 1.36601794e+00, 1.32543497e+00, 1.28834684e+00, 1.25465268e+00, 1.22421166e+00, 1.19684731e+00, 1.17236622e+00, 1.15056060e+00, 1.13121419e+00, 1.11412372e+00, 1.09907597e+00, 1.08586800e+00, 1.07431305e+00, 1.06422797e+00, 1.05544934e+00, 1.04782187e+00, 1.04121113e+00, 1.03548662e+00, 1.03053799e+00, 1.02626661e+00, 1.02258150e+00, 1.01940574e+00, 1.01667242e+00, 1.01431786e+00, 1.01229131e+00, 1.01055272e+00, 1.00905965e+00, 1.00777170e+00, 1.00666914e+00, 1.00572188e+00, 1.00490761e+00, 1.00420822e+00, 1.00361063e+00, 1.00309553e+00, 1.00265443e+00, 1.00227356e+00, 1.00194986e+00, 1.00167032e+00, 1.00143016e+00, 1.00122538e+00, 1.00104946e+00, 1.00089957e+00, 1.00076944e+00},
 { 1.58674101e+00, 1.58703399e+00, 1.58740770e+00, 1.58787514e+00, 1.58846671e+00, 1.58920773e+00, 1.59013640e+00, 1.59131168e+00, 1.59279147e+00, 1.59465396e+00, 1.59699337e+00, 1.59993177e+00, 1.60361021e+00, 1.60821613e+00, 1.61395346e+00, 1.62104821e+00, 1.62974520e+00, 1.64026647e+00, 1.65276630e+00, 1.66724084e+00, 1.68343174e+00, 1.70073146e+00, 1.71804594e+00, 1.73381681e+00, 1.74609644e+00, 1.75274014e+00, 1.75173538e+00, 1.74152771e+00, 1.72137358e+00, 1.69155072e+00, 1.65340575e+00, 1.60911053e+00, 1.56119061e+00, 1.51204322e+00, 1.46355813e+00, 1.41702205e+00, 1.37319600e+00, 1.33247014e+00, 1.29499998e+00, 1.26080307e+00, 1.22980962e+00, 1.20188165e+00, 1.17685260e+00, 1.15452972e+00, 1.13471312e+00, 1.11719257e+00, 1.10175489e+00, 1.08820302e+00, 1.07634072e+00, 1.06598805e+00, 1.05697390e+00, 1.04914030e+00, 1.04234737e+00, 1.03646617e+00, 1.03138382e+00, 1.02699375e+00, 1.02320696e+00, 1.01994470e+00, 1.01713452e+00, 1.01471596e+00, 1.01263412e+00, 1.01084726e+00, 1.00930784e+00, 1.00798882e+00, 1.00685697e+00, 1.00587990e+00, 1.00504463e+00, 1.00432718e+00, 1.00371035e+00, 1.00318062e+00, 1.00272872e+00, 1.00233872e+00, 1.00200503e+00, 1.00171637e+00, 1.00147180e+00, 1.00126018e+00, 1.00107831e+00, 1.00092389e+00, 1.00079052e+00, 1.00067744e+00, 1.00057890e+00},
 { 1.37846377e+00, 1.37877974e+00, 1.37917698e+00, 1.37967914e+00, 1.38031182e+00, 1.38110663e+00, 1.38210810e+00, 1.38336626e+00, 1.38495588e+00, 1.38695435e+00, 1.38947345e+00, 1.39264786e+00, 1.39662972e+00, 1.40163002e+00, 1.40788583e+00, 1.41568438e+00, 1.42533472e+00, 1.43716440e+00, 1.45146804e+00, 1.46843208e+00, 1.48801387e+00, 1.50983205e+00, 1.53296694e+00, 1.55593755e+00, 1.57666094e+00, 1.59270070e+00, 1.60161376e+00, 1.60141139e+00, 1.59099587e+00, 1.57042637e+00, 1.54097480e+00, 1.50483005e+00, 1.46459758e+00, 1.42276060e+00, 1.38128284e+00, 1.34148375e+00, 1.30412891e+00, 1.26959671e+00, 1.23802309e+00, 1.20940422e+00, 1.18364990e+00, 1.16060984e+00, 1.14010616e+00, 1.12194593e+00, 1.10592585e+00, 1.09185042e+00, 1.07951831e+00, 1.06874942e+00, 1.05936673e+00, 1.05121319e+00, 1.04413809e+00, 1.03801405e+00, 1.03271681e+00, 1.02814189e+00, 1.02419713e+00, 1.02079565e+00, 1.01786609e+00, 1.01534644e+00, 1.01317706e+00, 1.01131222e+00, 1.00970794e+00, 1.00833247e+00, 1.00714738e+00, 1.00613315e+00, 1.00526344e+00, 1.00451179e+00, 1.00387018e+00, 1.00331913e+00, 1.00284521e+00, 1.00243820e+00, 1.00209166e+00, 1.00179210e+00, 1.00153605e+00, 1.00131401e+00, 1.00112661e+00, 1.00096406e+00, 1.00082429e+00, 1.00070598e+00, 1.00060360e+00, 1.00051710e+00, 1.00044137e+00},
 { 1.18345801e+00, 1.18378822e+00, 1.18420118e+00, 1.18472796e+00, 1.18538973e+00, 1.18622094e+00, 1.18726784e+00, 1.18858545e+00, 1.19024936e+00, 1.19234746e+00, 1.19498991e+00, 1.19831713e+00, 1.20251231e+00, 1.20779012e+00, 1.21442026e+00, 1.22272626e+00, 1.23308397e+00, 1.24591020e+00, 1.26163347e+00, 1.28062524e+00, 1.30309525e+00, 1.32893410e+00, 1.35752957e+00, 1.38759425e+00, 1.41707567e+00, 1.44328747e+00, 1.46329348e+00, 1.47446421e+00, 1.47509506e+00, 1.46482980e+00, 1.44474180e+00, 1.41703225e+00, 1.38444063e+00, 1.34960876e+00, 1.31463507e+00, 1.28092363e+00, 1.24929623e+00, 1.22014547e+00, 1.19360541e+00, 1.16967249e+00, 1.14825367e+00, 1.12920081e+00, 1.11234117e+00, 1.09748701e+00, 1.08445302e+00, 1.07305202e+00, 1.06311045e+00, 1.05446132e+00, 1.04695180e+00, 1.04044596e+00, 1.03481576e+00, 1.02995416e+00, 1.02575714e+00, 1.02213860e+00, 1.01902333e+00, 1.01634019e+00, 1.01403168e+00, 1.01204822e+00, 1.01034137e+00, 1.00887512e+00, 1.00761410e+00, 1.00653532e+00, 1.00560295e+00, 1.00480710e+00, 1.00412508e+00, 1.00353471e+00, 1.00303160e+00, 1.00259950e+00, 1.00222769e+00, 1.00190835e+00, 1.00163706e+00, 1.00140208e+00, 1.00120145e+00, 1.00102697e+00, 1.00088037e+00, 1.00075283e+00, 1.00064309e+00, 1.00055055e+00, 1.00047027e+00, 1.00040274e+00, 1.00034327e+00},
 { 1.00388715e+00, 1.00422327e+00, 1.00464634e+00, 1.00517721e+00, 1.00585194e+00, 1.00669782e+00, 1.00776212e+00, 1.00910609e+00, 1.01080092e+00, 1.01293939e+00, 1.01563503e+00, 1.01903602e+00, 1.02332453e+00, 1.02873492e+00, 1.03555197e+00, 1.04412470e+00, 1.05488349e+00, 1.06830981e+00, 1.08494680e+00, 1.10533575e+00, 1.12992786e+00, 1.15893586e+00, 1.19211095e+00, 1.22853320e+00, 1.26637538e+00, 1.30290145e+00, 1.33475017e+00, 1.35853547e+00, 1.37165612e+00, 1.37299701e+00, 1.36319764e+00, 1.34437551e+00, 1.31943369e+00, 1.29126948e+00, 1.26223037e+00, 1.23389238e+00, 1.20717439e+00, 1.18252410e+00, 1.16011691e+00, 1.13996472e+00, 1.12198738e+00, 1.10606035e+00, 1.09201701e+00, 1.07968949e+00, 1.06891281e+00, 1.05951197e+00, 1.05134089e+00, 1.04425076e+00, 1.03810880e+00, 1.03279824e+00, 1.02821031e+00, 1.02425596e+00, 1.02084567e+00, 1.01790855e+00, 1.01538246e+00, 1.01320826e+00, 1.01133878e+00, 1.00973369e+00, 1.00835272e+00, 1.00716693e+00, 1.00614717e+00, 1.00527577e+00, 1.00452171e+00, 1.00387899e+00, 1.00332851e+00, 1.00285114e+00, 1.00244502e+00, 1.00209620e+00, 1.00179586e+00, 1.00153786e+00, 1.00131921e+00, 1.00112940e+00, 1.00096753e+00, 1.00082631e+00, 1.00070824e+00, 1.00060518e+00, 1.00051645e+00, 1.00044191e+00, 1.00037709e+00, 1.00032281e+00, 1.00027471e+00},
 { 8.41558983e-01, 8.41891150e-01, 8.42309439e-01, 8.42834637e-01, 8.43500977e-01, 8.44337483e-01, 8.45392479e-01, 8.46720880e-01, 8.48397725e-01, 8.50515026e-01, 8.53186132e-01, 8.56559243e-01, 8.60818211e-01, 8.66200205e-01, 8.72998094e-01, 8.81575068e-01, 8.92385522e-01, 9.05966939e-01, 9.22938915e-01, 9.43980258e-01, 9.69755215e-01, 1.00078349e+00, 1.03722810e+00, 1.07864457e+00, 1.12363249e+00, 1.16971266e+00, 1.21334108e+00, 1.25046148e+00, 1.27740835e+00, 1.29190325e+00, 1.29372031e+00, 1.28461853e+00, 1.26760477e+00, 1.24593330e+00, 1.22232656e+00, 1.19866181e+00, 1.17604895e+00, 1.15504955e+00, 1.13590703e+00, 1.11867986e+00, 1.10332128e+00, 1.08972661e+00, 1.07776016e+00, 1.06727351e+00, 1.05812212e+00, 1.05015153e+00, 1.04323441e+00, 1.03724056e+00, 1.03205421e+00, 1.02757473e+00, 1.02370803e+00, 1.02037822e+00, 1.01750814e+00, 1.01503759e+00, 1.01291393e+00, 1.01108663e+00, 1.00951590e+00, 1.00816789e+00, 1.00700808e+00, 1.00601243e+00, 1.00515609e+00, 1.00442507e+00, 1.00379162e+00, 1.00325245e+00, 1.00279087e+00, 1.00238984e+00, 1.00204922e+00, 1.00175663e+00, 1.00150454e+00, 1.00128795e+00, 1.00110483e+00, 1.00094549e+00, 1.00080977e+00, 1.00069099e+00, 1.00059216e+00, 1.00050561e+00, 1.00043104e+00, 1.00036865e+00, 1.00031350e+00, 1.00026892e+00, 1.00022849e+00},
 { 6.97671513e-01, 6.97990388e-01, 6.98391985e-01, 6.98896496e-01, 6.99535891e-01, 7.00339281e-01, 7.01352940e-01, 7.02629421e-01, 7.04239398e-01, 7.06276176e-01, 7.08846440e-01, 7.12094137e-01, 7.16199218e-01, 7.21393890e-01, 7.27967879e-01, 7.36285221e-01, 7.46806528e-01, 7.60089104e-01, 7.76808808e-01, 7.97728900e-01, 8.23678410e-01, 8.55439705e-01, 8.93567585e-01, 9.38131693e-01, 9.88331313e-01, 1.04220443e+00, 1.09643806e+00, 1.14663926e+00, 1.18816907e+00, 1.21732694e+00, 1.23249094e+00, 1.23453510e+00, 1.22627174e+00, 1.21129789e+00, 1.19287220e+00, 1.17334649e+00, 1.15415178e+00, 1.13605120e+00, 1.11940354e+00, 1.10434216e+00, 1.09087037e+00, 1.07892765e+00, 1.06840037e+00, 1.05917554e+00, 1.05112175e+00, 1.04410676e+00, 1.03801978e+00, 1.03274607e+00, 1.02818332e+00, 1.02424315e+00, 1.02084228e+00, 1.01791420e+00, 1.01539046e+00, 1.01321818e+00, 1.01135117e+00, 1.00974465e+00, 1.00836374e+00, 1.00717884e+00, 1.00615917e+00, 1.00528389e+00, 1.00453092e+00, 1.00388862e+00, 1.00333136e+00, 1.00285755e+00, 1.00245208e+00, 1.00209920e+00, 1.00179989e+00, 1.00154275e+00, 1.00132106e+00, 1.00113057e+00, 1.00096982e+00, 1.00082969e+00, 1.00071044e+00, 1.00060579e+00, 1.00051908e+00, 1.00044293e+00, 1.00037728e+00, 1.00032254e+00, 1.00027395e+00, 1.00023499e+00, 1.00019939e+00},
 { 5.72635793e-01, 5.72933202e-01, 5.73307850e-01, 5.73778602e-01, 5.74373783e-01, 5.75123485e-01, 5.76070881e-01, 5.77262606e-01, 5.78766590e-01, 5.80668504e-01, 5.83070662e-01, 5.86107977e-01, 5.89950662e-01, 5.94818932e-01, 6.00989861e-01, 6.08814756e-01, 6.18742766e-01, 6.31329045e-01, 6.47259986e-01, 6.67346621e-01, 6.92518381e-01, 7.23749851e-01, 7.61918187e-01, 8.07580051e-01, 8.60585492e-01, 9.19699030e-01, 9.82208007e-01, 1.04391504e+00, 1.09963060e+00, 1.14432920e+00, 1.17462306e+00, 1.18981422e+00, 1.19190438e+00, 1.18453263e+00, 1.17153700e+00, 1.15594862e+00, 1.13972091e+00, 1.12394443e+00, 1.10917072e+00, 1.09565032e+00, 1.08346318e+00, 1.07260196e+00, 1.06298949e+00, 1.05454328e+00, 1.04715186e+00, 1.04070671e+00, 1.03510564e+00, 1.03024811e+00, 1.02604190e+00, 1.02240664e+00, 1.01926837e+00, 1.01656473e+00, 1.01423345e+00, 1.01222615e+00, 1.01050053e+00, 1.00901527e+00, 1.00773831e+00, 1.00664252e+00, 1.00569926e+00, 1.00488950e+00, 1.00419271e+00, 1.00359857e+00, 1.00308263e+00, 1.00264423e+00, 1.00226913e+00, 1.00194230e+00, 1.00166533e+00, 1.00142734e+00, 1.00122208e+00, 1.00104568e+00, 1.00089702e+00, 1.00076725e+00, 1.00065689e+00, 1.00055986e+00, 1.00047969e+00, 1.00040914e+00, 1.00034830e+00, 1.00029768e+00, 1.00025263e+00, 1.00021671e+00, 1.00018371e+00},
 { 4.66022275e-01, 4.66292278e-01, 4.66632404e-01, 4.67059889e-01, 4.67600203e-01, 4.68281019e-01, 4.69141482e-01, 4.70224133e-01, 4.71592021e-01, 4.73319435e-01, 4.75503816e-01, 4.78267373e-01, 4.81766461e-01, 4.86203823e-01, 4.91836247e-01, 4.98992287e-01, 5.08092918e-01, 5.19670426e-01, 5.34392365e-01, 5.53071083e-01, 5.76675561e-01, 6.06291247e-01, 6.43022818e-01, 6.87819868e-01, 7.41135000e-01, 8.02528224e-01, 8.70155335e-01, 9.40502475e-01, 1.00847675e+00, 1.06826390e+00, 1.11478680e+00, 1.14527470e+00, 1.16007168e+00, 1.16214825e+00, 1.15563848e+00, 1.14435323e+00, 1.13101478e+00, 1.11725063e+00, 1.10392873e+00, 1.09148665e+00, 1.08011740e+00, 1.06988711e+00, 1.06076887e+00, 1.05271431e+00, 1.04563686e+00, 1.03944595e+00, 1.03405142e+00, 1.02936376e+00, 1.02529773e+00, 1.02177883e+00, 1.01873754e+00, 1.01611496e+00, 1.01385176e+00, 1.01190176e+00, 1.01022447e+00, 1.00878010e+00, 1.00753779e+00, 1.00647138e+00, 1.00555312e+00, 1.00476462e+00, 1.00408595e+00, 1.00350725e+00, 1.00300450e+00, 1.00257735e+00, 1.00221186e+00, 1.00189326e+00, 1.00162332e+00, 1.00139135e+00, 1.00119124e+00, 1.00101925e+00, 1.00087436e+00, 1.00074783e+00, 1.00064024e+00, 1.00054559e+00, 1.00046745e+00, 1.00039865e+00, 1.00033931e+00, 1.00028997e+00, 1.00024601e+00, 1.00021104e+00, 1.00017884e+00},
 { 3.76655676e-01, 3.76893936e-01, 3.77195184e-01, 3.77573879e-01, 3.78052531e-01, 3.78655682e-01, 3.79417110e-01, 3.80377439e-01, 3.81589940e-01, 3.83121525e-01, 3.85059033e-01, 3.87511496e-01, 3.90618792e-01, 3.94562657e-01, 3.99574490e-01, 4.05952037e-01, 4.14079618e-01, 4.24448503e-01, 4.37683805e-01, 4.54562993e-01, 4.76040744e-01, 5.03236320e-01, 5.37378097e-01, 5.79683413e-01, 6.31084280e-01, 6.91869453e-01, 7.61149915e-01, 8.36420612e-01, 9.13314739e-01, 9.86006738e-01, 1.04834355e+00, 1.09552394e+00, 1.12558518e+00, 1.13983349e+00, 1.14191810e+00, 1.13617039e+00, 1.12623522e+00, 1.11455352e+00, 1.10252447e+00, 1.09089114e+00, 1.08002349e+00, 1.07009580e+00, 1.06115077e+00, 1.05318512e+00, 1.04614257e+00, 1.03995246e+00, 1.03453809e+00, 1.02981882e+00, 1.02571521e+00, 1.02215661e+00, 1.01907587e+00, 1.01641552e+00, 1.01411713e+00, 1.01213490e+00, 1.01042846e+00, 1.00895802e+00, 1.00769255e+00, 1.00660570e+00, 1.00566948e+00, 1.00486528e+00, 1.00417291e+00, 1.00358229e+00, 1.00306921e+00, 1.00263309e+00, 1.00225985e+00, 1.00193455e+00, 1.00165883e+00, 1.00142189e+00, 1.00121748e+00, 1.00104180e+00, 1.00089373e+00, 1.00076446e+00, 1.00065452e+00, 1.00055785e+00, 1.00047797e+00, 1.00040768e+00, 1.00034706e+00, 1.00029662e+00, 1.00025172e+00, 1.00021593e+00, 1.00018304e+00},
 { 3.02818962e-01, 3.03025512e-01, 3.03286628e-01, 3.03614926e-01, 3.04029879e-01, 3.04552801e-01, 3.05212947e-01, 3.06045777e-01, 3.07097494e-01, 3.08426306e-01, 3.10107855e-01, 3.12237258e-01, 3.14936797e-01, 3.18365620e-01, 3.22727231e-01, 3.28284673e-01, 3.35379504e-01, 3.44452096e-01, 3.56069183e-01, 3.70947471e-01, 3.89986407e-01, 4.14275471e-01, 4.45073720e-01, 4.83736905e-01, 5.31518951e-01, 5.89281750e-01, 6.57007599e-01, 7.33301020e-01, 8.14926410e-01, 8.96792460e-01, 9.72585243e-01, 1.03614676e+00, 1.08319287e+00, 1.11257089e+00, 1.12631623e+00, 1.12845490e+00, 1.12332612e+00, 1.11438319e+00, 1.10385510e+00, 1.09300125e+00, 1.08249513e+00, 1.07267070e+00, 1.06367720e+00, 1.05557596e+00, 1.04835202e+00, 1.04196066e+00, 1.03634154e+00, 1.03142151e+00, 1.02713379e+00, 1.02340365e+00, 1.02016743e+00, 1.01736766e+00, 1.01494538e+00, 1.01285374e+00, 1.01105115e+00, 1.00949659e+00, 1.00815777e+00, 1.00700712e+00, 1.00601554e+00, 1.00516338e+00, 1.00442954e+00, 1.00380309e+00, 1.00325910e+00, 1.00279633e+00, 1.00240013e+00, 1.00205508e+00, 1.00176235e+00, 1.00151079e+00, 1.00129381e+00, 1.00110732e+00, 1.00094997e+00, 1.00081273e+00, 1.00069594e+00, 1.00059340e+00, 1.00050847e+00, 1.00043385e+00, 1.00036951e+00, 1.00031588e+00, 1.00026825e+00, 1.00023011e+00, 1.00019520e+00},
 { 2.42513447e-01, 2.42689275e-01, 2.42911527e-01, 2.43191639e-01, 2.43544237e-01, 2.43989420e-01, 2.44551439e-01, 2.45260629e-01, 2.46156365e-01, 2.47288342e-01, 2.48721209e-01, 2.50536372e-01, 2.52838668e-01, 2.55764742e-01, 2.59489916e-01, 2.64241651e-01, 2.70316719e-01, 2.78100361e-01, 2.88092808e-01, 3.00934850e-01, 3.17444149e-01, 3.38635571e-01, 3.65724947e-01, 4.00096386e-01, 4.43170068e-01, 4.96189749e-01, 5.59820160e-01, 6.33675819e-01, 7.15775155e-01, 8.02241179e-01, 8.87461012e-01, 9.64945418e-01, 1.02880125e+00, 1.07533606e+00, 1.10404704e+00, 1.11742195e+00, 1.11964356e+00, 1.11497777e+00, 1.10672704e+00, 1.09697398e+00, 1.08690313e+00, 1.07713318e+00, 1.06797703e+00, 1.05959465e+00, 1.05203229e+00, 1.04528290e+00, 1.03930925e+00, 1.03405159e+00, 1.02945046e+00, 1.02543453e+00, 1.02194104e+00, 1.01891184e+00, 1.01628649e+00, 1.01401613e+00, 1.01205695e+00, 1.01036571e+00, 1.00890791e+00, 1.00765395e+00, 1.00657283e+00, 1.00564320e+00, 1.00484244e+00, 1.00415822e+00, 1.00356441e+00, 1.00305873e+00, 1.00262558e+00, 1.00224873e+00, 1.00192865e+00, 1.00165358e+00, 1.00141639e+00, 1.00121255e+00, 1.00104028e+00, 1.00089024e+00, 1.00076245e+00, 1.00065047e+00, 1.00055744e+00, 1.00047586e+00, 1.00040555e+00, 1.00034680e+00, 1.00029477e+00, 1.00025286e+00, 1.00021472e+00},
 { 1.93686712e-01, 1.93834208e-01, 1.94020556e-01, 1.94255470e-01, 1.94551205e-01, 1.94924604e-01, 1.95396014e-01, 1.95990970e-01, 1.96742534e-01, 1.97692496e-01, 1.98894752e-01, 2.00419379e-01, 2.02353341e-01, 2.04812562e-01, 2.07945549e-01, 2.11945558e-01, 2.17065699e-01, 2.23636323e-01, 2.32089339e-01, 2.42983904e-01, 2.57042210e-01, 2.75177647e-01, 2.98513669e-01, 3.28380019e-01, 3.66233990e-01, 4.13519000e-01, 4.71357446e-01, 5.40155170e-01, 6.19074086e-01, 7.05601060e-01, 7.95375899e-01, 8.82539764e-01, 9.60699778e-01, 1.02435373e+00, 1.07031507e+00, 1.09850441e+00, 1.11164105e+00, 1.11394495e+00, 1.10961321e+00, 1.10182141e+00, 1.09258419e+00, 1.08301947e+00, 1.07371802e+00, 1.06499902e+00, 1.05700436e+00, 1.04978524e+00, 1.04333983e+00, 1.03762918e+00, 1.03260532e+00, 1.02820255e+00, 1.02435994e+00, 1.02101888e+00, 1.01811714e+00, 1.01560330e+00, 1.01343064e+00, 1.01155293e+00, 1.00993276e+00, 1.00853775e+00, 1.00733437e+00, 1.00629894e+00, 1.00540674e+00, 1.00464359e+00, 1.00398173e+00, 1.00341740e+00, 1.00293375e+00, 1.00251344e+00, 1.00215599e+00, 1.00184878e+00, 1.00158397e+00, 1.00135639e+00, 1.00116375e+00, 1.00099619e+00, 1.00085338e+00, 1.00072848e+00, 1.00062438e+00, 1.00053329e+00, 1.00045483e+00, 1.00038908e+00, 1.00033104e+00, 1.00028397e+00, 1.00024141e+00},
 { 1.54401457e-01, 1.54523694e-01, 1.54678123e-01, 1.54872804e-01, 1.55117912e-01, 1.55427394e-01, 1.55818125e-01, 1.56311324e-01, 1.56934424e-01, 1.57722137e-01, 1.58719262e-01, 1.59984055e-01, 1.61588993e-01, 1.63630707e-01, 1.66233288e-01, 1.69558604e-01, 1.73819318e-01, 1.79294181e-01, 1.86349680e-01, 1.95463988e-01, 2.07260898e-01, 2.22540517e-01, 2.42307876e-01, 2.67781423e-01, 3.00365985e-01, 3.41556073e-01, 3.92722826e-01, 4.54808643e-01, 5.27875928e-01, 6.10661503e-01, 7.00237057e-01, 7.91989010e-01, 8.80064048e-01, 9.58316469e-01, 1.02160941e+00, 1.06709609e+00, 1.09492627e+00, 1.10791724e+00, 1.11029513e+00, 1.10618270e+00, 1.09870072e+00, 1.08979513e+00, 1.08054927e+00, 1.07155550e+00, 1.06311209e+00, 1.05536345e+00, 1.04836421e+00, 1.04210909e+00, 1.03656944e+00, 1.03168979e+00, 1.02741366e+00, 1.02368326e+00, 1.02043507e+00, 1.01761506e+00, 1.01517331e+00, 1.01306011e+00, 1.01123458e+00, 1.00966096e+00, 1.00830259e+00, 1.00713292e+00, 1.00612463e+00, 1.00526122e+00, 1.00451286e+00, 1.00387396e+00, 1.00332609e+00, 1.00285050e+00, 1.00244549e+00, 1.00209738e+00, 1.00179741e+00, 1.00153962e+00, 1.00132101e+00, 1.00113117e+00, 1.00096921e+00, 1.00082788e+00, 1.00070966e+00, 1.00060647e+00, 1.00051760e+00, 1.00044293e+00, 1.00037724e+00, 1.00032361e+00, 1.00027541e+00},
 { 1.22930752e-01, 1.23031112e-01, 1.23157899e-01, 1.23317736e-01, 1.23518989e-01, 1.23773104e-01, 1.24093943e-01, 1.24498965e-01, 1.25010716e-01, 1.25657751e-01, 1.26476940e-01, 1.27516236e-01, 1.28835420e-01, 1.30514208e-01, 1.32655169e-01, 1.35392353e-01, 1.38902318e-01, 1.43417275e-01, 1.49243875e-01, 1.56784673e-01, 1.66568921e-01, 1.79282862e-01, 1.95801476e-01, 2.17208458e-01, 2.44794139e-01, 2.79999249e-01, 3.24279815e-01, 3.78880981e-01, 4.44485598e-01, 5.20821596e-01, 6.06282653e-01, 6.97709560e-01, 7.90454266e-01, 8.78821696e-01, 9.56926290e-01, 1.01988410e+00, 1.06503351e+00, 1.09262950e+00, 1.10554071e+00, 1.10796557e+00, 1.10400527e+00, 1.09672158e+00, 1.08802226e+00, 1.07898780e+00, 1.07018664e+00, 1.06191747e+00, 1.05432670e+00, 1.04746417e+00, 1.04133380e+00, 1.03589849e+00, 1.03111110e+00, 1.02691758e+00, 1.02325459e+00, 1.02006622e+00, 1.01729947e+00, 1.01490100e+00, 1.01282607e+00, 1.01103513e+00, 1.00948789e+00, 1.00815442e+00, 1.00700433e+00, 1.00601835e+00, 1.00516415e+00, 1.00443397e+00, 1.00380743e+00, 1.00326410e+00, 1.00280078e+00, 1.00240251e+00, 1.00205942e+00, 1.00176456e+00, 1.00151411e+00, 1.00129690e+00, 1.00111144e+00, 1.00094993e+00, 1.00081440e+00, 1.00069633e+00, 1.00059471e+00, 1.00050908e+00, 1.00043399e+00, 1.00037229e+00, 1.00031717e+00},
 { 9.77942733e-02, 9.78760723e-02, 9.79794092e-02, 9.81096856e-02, 9.82737281e-02, 9.84808630e-02, 9.87423941e-02, 9.90725734e-02, 9.94897969e-02, 1.00017374e-01, 1.00685414e-01, 1.01533088e-01, 1.02609251e-01, 1.03979281e-01, 1.05727084e-01, 1.07962739e-01, 1.10831446e-01, 1.14524699e-01, 1.19296256e-01, 1.25480847e-01, 1.33521239e-01, 1.43996014e-01, 1.57652982e-01, 1.75430889e-01, 1.98475478e-01, 2.28112124e-01, 2.65762900e-01, 3.12793096e-01, 3.70251800e-01, 4.38560057e-01, 5.17167410e-01, 6.04268764e-01, 6.96657090e-01, 7.89790485e-01, 8.78164266e-01, 9.56079589e-01, 1.01878893e+00, 1.06371390e+00, 1.09116858e+00, 1.10402270e+00, 1.10648947e+00, 1.10262636e+00, 1.09546338e+00, 1.08690341e+00, 1.07800009e+00, 1.06932024e+00, 1.06116331e+00, 1.05366984e+00, 1.04689806e+00, 1.04084270e+00, 1.03547438e+00, 1.03074785e+00, 1.02660301e+00, 1.02298374e+00, 1.01983477e+00, 1.01709940e+00, 1.01472897e+00, 1.01267985e+00, 1.01090774e+00, 1.00937892e+00, 1.00805947e+00, 1.00692691e+00, 1.00594603e+00, 1.00510650e+00, 1.00438566e+00, 1.00376107e+00, 1.00322778e+00, 1.00276930e+00, 1.00237442e+00, 1.00203503e+00, 1.00174631e+00, 1.00149622e+00, 1.00128252e+00, 1.00109675e+00, 1.00094039e+00, 1.00080444e+00, 1.00068746e+00, 1.00058866e+00, 1.00050226e+00, 1.00043087e+00, 1.00036742e+00},
 { 7.77561650e-02, 7.78224601e-02, 7.79062092e-02, 7.80117931e-02, 7.81447494e-02, 7.83126347e-02, 7.85246147e-02, 7.87922539e-02, 7.91304738e-02, 7.95581899e-02, 8.00998437e-02, 8.07872380e-02, 8.16600870e-02, 8.27715438e-02, 8.41899132e-02, 8.60049128e-02, 8.83350742e-02, 9.13370561e-02, 9.52190305e-02, 1.00256632e-01, 1.06816211e-01, 1.15379648e-01, 1.26575260e-01, 1.41201687e-01, 1.60250730e-01, 1.84899926e-01, 2.16465868e-01, 2.56305805e-01, 3.05635514e-01, 3.65299157e-01, 4.35493806e-01, 5.15502511e-01, 6.03470965e-01, 6.96266905e-01, 7.89493167e-01, 8.77787136e-01, 9.55549668e-01, 1.01809037e+00, 1.06287795e+00, 1.09023461e+00, 1.10306376e+00, 1.10555595e+00, 1.10174890e+00, 1.09467072e+00, 1.08619605e+00, 1.07737494e+00, 1.06877375e+00, 1.06068514e+00, 1.05325745e+00, 1.04653914e+00, 1.04053222e+00, 1.03520877e+00, 1.03051717e+00, 1.02640421e+00, 1.02281416e+00, 1.01968782e+00, 1.01697297e+00, 1.01462189e+00, 1.01258605e+00, 1.01082759e+00, 1.00930870e+00, 1.00800327e+00, 1.00687279e+00, 1.00590400e+00, 1.00507159e+00, 1.00435079e+00, 1.00373462e+00, 1.00320477e+00, 1.00274847e+00, 1.00235626e+00, 1.00202213e+00, 1.00173300e+00, 1.00148577e+00, 1.00127120e+00, 1.00109009e+00, 1.00093290e+00, 1.00079770e+00, 1.00068324e+00, 1.00058341e+00, 1.00050048e+00, 1.00042715e+00},
 { 6.18026117e-02, 6.18561063e-02, 6.19236837e-02, 6.20088807e-02, 6.21161691e-02, 6.22516451e-02, 6.24227077e-02, 6.26386970e-02, 6.29116615e-02, 6.32568807e-02, 6.36941017e-02, 6.42490235e-02, 6.49537694e-02, 6.58513394e-02, 6.69970449e-02, 6.84636091e-02, 7.03472310e-02, 7.27752715e-02, 7.59173410e-02, 7.99986864e-02, 8.53198142e-02, 9.22780365e-02, 1.01394954e-01, 1.13339962e-01, 1.28955405e-01, 1.49260942e-01, 1.75430847e-01, 2.08734766e-01, 2.50415177e-01, 3.01527152e-01, 3.62735337e-01, 4.34099303e-01, 5.14856279e-01, 6.03206349e-01, 6.96130304e-01, 7.89342882e-01, 8.77557259e-01, 9.55212575e-01, 1.01765044e+00, 1.06234198e+00, 1.08964660e+00, 1.10245825e+00, 1.10496067e+00, 1.10119727e+00, 1.09416976e+00, 1.08574819e+00, 1.07698097e+00, 1.06842681e+00, 1.06038566e+00, 1.05299563e+00, 1.04631213e+00, 1.04033836e+00, 1.03503974e+00, 1.03037132e+00, 1.02628011e+00, 1.02270626e+00, 1.01959492e+00, 1.01689467e+00, 1.01455278e+00, 1.01252710e+00, 1.01077556e+00, 1.00926811e+00, 1.00796255e+00, 1.00684226e+00, 1.00587896e+00, 1.00504519e+00, 1.00433160e+00, 1.00371783e+00, 1.00318928e+00, 1.00273489e+00, 1.00234728e+00, 1.00201219e+00, 1.00172544e+00, 1.00147693e+00, 1.00126667e+00, 1.00108444e+00, 1.00092773e+00, 1.00079482e+00, 1.00067914e+00, 1.00058262e+00, 1.00049761e+00},
 { 4.91114445e-02, 4.91544634e-02, 4.92088067e-02, 4.92773198e-02, 4.93636009e-02, 4.94725516e-02, 4.96101239e-02, 4.97838344e-02, 5.00033777e-02, 5.02810513e-02, 5.06327516e-02, 5.10791692e-02, 5.16461866e-02, 5.23684543e-02, 5.32905790e-02, 5.44712547e-02, 5.59882007e-02, 5.79444514e-02, 6.04774587e-02, 6.37701921e-02, 6.80674795e-02, 7.36943278e-02, 8.10796959e-02, 9.07782070e-02, 1.03494898e-01, 1.20095826e-01, 1.41600346e-01, 1.69148287e-01, 2.03920665e-01, 2.47033658e-01, 2.99398741e-01, 3.61567947e-01, 4.33560101e-01, 5.14652628e-01, 6.03135030e-01, 6.96078099e-01, 7.89256767e-01, 8.77411406e-01, 9.55002415e-01, 1.01736635e+00, 1.06200637e+00, 1.08927613e+00, 1.10207064e+00, 1.10458753e+00, 1.10084872e+00, 1.09385234e+00, 1.08546626e+00, 1.07673038e+00, 1.06821023e+00, 1.06019514e+00, 1.05282993e+00, 1.04617099e+00, 1.04021462e+00, 1.03493280e+00, 1.03028065e+00, 1.02620092e+00, 1.02263800e+00, 1.01953778e+00, 1.01684373e+00, 1.01450943e+00, 1.01248845e+00, 1.01074646e+00, 1.00923724e+00, 1.00794047e+00, 1.00682447e+00, 1.00585877e+00, 1.00503133e+00, 1.00431939e+00, 1.00370626e+00, 1.00317907e+00, 1.00272881e+00, 1.00233983e+00, 1.00200675e+00, 1.00171842e+00, 1.00147396e+00, 1.00126235e+00, 1.00108041e+00, 1.00092584e+00, 1.00079157e+00, 1.00067908e+00, 1.00058037e+00},
 { 3.90208590e-02, 3.90553623e-02, 3.90989478e-02, 3.91538986e-02, 3.92231018e-02, 3.93104883e-02, 3.94208334e-02, 3.95601690e-02, 3.97362741e-02, 3.99590188e-02, 4.02411630e-02, 4.05993171e-02, 4.10542724e-02, 4.16338658e-02, 4.23739554e-02, 4.33217534e-02, 4.45398244e-02, 4.61112020e-02, 4.81468079e-02, 5.07945707e-02, 5.42528944e-02, 5.87859962e-02, 6.47440633e-02, 7.25825115e-02, 8.28848321e-02, 9.63758666e-02, 1.13922850e-01, 1.36519567e-01, 1.65237055e-01, 2.01156874e-01, 2.45280492e-01, 2.98427701e-01, 3.61115250e-01, 4.33391866e-01, 5.14605918e-01, 6.03119787e-01, 6.96053298e-01, 7.89202300e-01, 8.77322387e-01, 9.54864429e-01, 1.01719020e+00, 1.06179567e+00, 1.08903728e+00, 1.10182879e+00, 1.10435179e+00, 1.10062758e+00, 1.09365282e+00, 1.08528640e+00, 1.07657465e+00, 1.06807204e+00, 1.06007445e+00, 1.05272750e+00, 1.04608052e+00, 1.04013627e+00, 1.03486670e+00, 1.03022255e+00, 1.02615077e+00, 1.02259642e+00, 1.01950019e+00, 1.01681183e+00, 1.01448061e+00, 1.01246779e+00, 1.01072283e+00, 1.00922137e+00, 1.00792801e+00, 1.00680886e+00, 1.00584884e+00, 1.00502249e+00, 1.00431071e+00, 1.00369853e+00, 1.00317511e+00, 1.00272317e+00, 1.00233596e+00, 1.00200108e+00, 1.00171661e+00, 1.00147063e+00, 1.00125917e+00, 1.00107925e+00, 1.00092321e+00, 1.00079203e+00, 1.00067729e+00},
 { 3.10006807e-02, 3.10282970e-02, 3.10631823e-02, 3.11071646e-02, 3.11625556e-02, 3.12325011e-02, 3.13208243e-02, 3.14323550e-02, 3.15733220e-02, 3.17516296e-02, 3.19774972e-02, 3.22642298e-02, 3.26284891e-02, 3.30925850e-02, 3.36852703e-02, 3.44444207e-02, 3.54202603e-02, 3.66795012e-02, 3.83113595e-02, 4.04349910e-02, 4.32105052e-02, 4.68516561e-02, 5.16426812e-02, 5.79549153e-02, 6.62670436e-02, 7.71788872e-02, 9.14171116e-02, 1.09829765e-01, 1.33357014e-01, 1.62991454e-01, 1.99723113e-01, 2.44479164e-01, 2.98049403e-01, 3.60972903e-01, 4.33354635e-01, 5.14601917e-01, 6.03117354e-01, 6.96037723e-01, 7.89170878e-01, 8.77261557e-01, 9.54780555e-01, 1.01708034e+00, 1.06165798e+00, 1.08888941e+00, 1.10167599e+00, 1.10420190e+00, 1.10048886e+00, 1.09352498e+00, 1.08517535e+00, 1.07647486e+00, 1.06798438e+00, 1.06000044e+00, 1.05266145e+00, 1.04602316e+00, 1.04008821e+00, 1.03482410e+00, 1.03018572e+00, 1.02612063e+00, 1.02256864e+00, 1.01947672e+00, 1.01679024e+00, 1.01446616e+00, 1.01244948e+00, 1.01071154e+00, 1.00921284e+00, 1.00791576e+00, 1.00680181e+00, 1.00584248e+00, 1.00501594e+00, 1.00430480e+00, 1.00369614e+00, 1.00317081e+00, 1.00272045e+00, 1.00233127e+00, 1.00200011e+00, 1.00171401e+00, 1.00146808e+00, 1.00125854e+00, 1.00107708e+00, 1.00092407e+00, 1.00079058e+00},
 { 2.46274839e-02, 2.46495522e-02, 2.46774290e-02, 2.47125754e-02, 2.47568393e-02, 2.48127343e-02, 2.48833161e-02, 2.49724455e-02, 2.50851015e-02, 2.52276031e-02, 2.54081211e-02, 2.56372939e-02, 2.59284491e-02, 2.62994333e-02, 2.67732562e-02, 2.73802405e-02, 2.81606144e-02, 2.91678494e-02, 3.04735157e-02, 3.21733133e-02, 3.43960220e-02, 3.73139091e-02, 4.11566393e-02, 4.62253273e-02, 5.29099994e-02, 6.17026837e-02, 7.32052067e-02, 8.81297047e-02, 1.07282288e-01, 1.31541176e-01, 1.61825997e-01, 1.99066805e-01, 2.44165633e-01, 2.97929001e-01, 3.60940506e-01, 4.33352614e-01, 5.14605558e-01, 6.03115938e-01, 6.96030568e-01, 7.89146956e-01, 8.77226212e-01, 9.54728949e-01, 1.01700658e+00, 1.06157395e+00, 1.08879598e+00, 1.10157847e+00, 1.10410817e+00, 1.10039940e+00, 1.09344679e+00, 1.08510376e+00, 1.07641143e+00, 1.06793123e+00, 1.05995231e+00, 1.05261951e+00, 1.04598836e+00, 1.04005700e+00, 1.03479704e+00, 1.03016398e+00, 1.02610006e+00, 1.02255136e+00, 1.01946044e+00, 1.01678036e+00, 1.01445176e+00, 1.01244155e+00, 1.01070589e+00, 1.00920306e+00, 1.00791084e+00, 1.00679727e+00, 1.00583749e+00, 1.00501137e+00, 1.00430356e+00, 1.00369283e+00, 1.00316894e+00, 1.00271649e+00, 1.00233092e+00, 1.00199804e+00, 1.00171191e+00, 1.00146784e+00, 1.00125671e+00, 1.00107823e+00, 1.00092286e+00},
 { 1.95637592e-02, 1.95813719e-02, 1.96036201e-02, 1.96316703e-02, 1.96669975e-02, 1.97116078e-02, 1.97679402e-02, 1.98390770e-02, 1.99289926e-02, 2.00427322e-02, 2.01868194e-02, 2.03697488e-02, 2.06021653e-02, 2.08983244e-02, 2.12766110e-02, 2.17612611e-02, 2.23844406e-02, 2.31889274e-02, 2.42320182e-02, 2.55903974e-02, 2.73673758e-02, 2.97013676e-02, 3.27772817e-02, 3.68382365e-02, 4.22003222e-02, 4.92643964e-02, 5.85244301e-02, 7.05711588e-02, 8.60838223e-02, 1.05819562e-01, 1.30598471e-01, 1.61291923e-01, 1.98809136e-01, 2.44064729e-01, 2.97900430e-01, 3.60937952e-01, 4.33356538e-01, 5.14607970e-01, 6.03117381e-01, 6.96022473e-01, 7.89134631e-01, 8.77205165e-01, 9.54692270e-01, 1.01696280e+00, 1.06152084e+00, 1.08873595e+00, 1.10151781e+00, 1.10404710e+00, 1.10034544e+00, 1.09339591e+00, 1.08505812e+00, 1.07637360e+00, 1.06789626e+00, 1.05992168e+00, 1.05259444e+00, 1.04596550e+00, 1.04003712e+00, 1.03478148e+00, 1.03014871e+00, 1.02608733e+00, 1.02253899e+00, 1.01945392e+00, 1.01676883e+00, 1.01444630e+00, 1.01243803e+00, 1.01069793e+00, 1.00919970e+00, 1.00790764e+00, 1.00679343e+00, 1.00583390e+00, 1.00501097e+00, 1.00430098e+00, 1.00369158e+00, 1.00316551e+00, 1.00271660e+00, 1.00232925e+00, 1.00199628e+00, 1.00171197e+00, 1.00146625e+00, 1.00125807e+00, 1.00107720e+00},
 { 1.55408163e-02, 1.55548589e-02, 1.55725974e-02, 1.55949619e-02, 1.56231287e-02, 1.56586971e-02, 1.57036120e-02, 1.57603315e-02, 1.58320249e-02, 1.59227160e-02, 1.60376078e-02, 1.61834756e-02, 1.63688119e-02, 1.66049902e-02, 1.69066825e-02, 1.72932346e-02, 1.77903307e-02, 1.84321429e-02, 1.92644664e-02, 2.03486368e-02, 2.17673627e-02, 2.36315928e-02, 2.60897836e-02, 2.93375602e-02, 3.36300164e-02, 3.92919916e-02, 4.67261071e-02, 5.64178092e-02, 6.89319689e-02, 8.49090817e-02, 1.05060016e-01, 1.30166142e-01, 1.61081715e-01, 1.98725484e-01, 2.44039894e-01, 2.97897167e-01, 3.60940673e-01, 4.33359115e-01, 5.14611492e-01, 6.03115198e-01, 6.96019818e-01, 7.89127998e-01, 8.77188120e-01, 9.54671739e-01, 1.01693512e+00, 1.06148629e+00, 1.08869895e+00, 1.10147761e+00, 1.10401106e+00, 1.10030985e+00, 1.09336335e+00, 1.08503152e+00, 1.07634828e+00, 1.06787392e+00, 1.05990376e+00, 1.05257772e+00, 1.04595090e+00, 1.04002610e+00, 1.03477010e+00, 1.03013933e+00, 1.02607782e+00, 1.02253495e+00, 1.01944450e+00, 1.01676520e+00, 1.01444435e+00, 1.01243140e+00, 1.01069572e+00, 1.00919749e+00, 1.00790464e+00, 1.00679057e+00, 1.00583413e+00, 1.00500892e+00, 1.00430019e+00, 1.00368854e+00, 1.00316596e+00, 1.00271522e+00, 1.00232773e+00, 1.00199655e+00, 1.00171056e+00, 1.00146777e+00, 1.00125718e+00},
 { 1.23449212e-02, 1.23561086e-02, 1.23702405e-02, 1.23880578e-02, 1.24104979e-02, 1.24388349e-02, 1.24746183e-02, 1.25198068e-02, 1.25769257e-02, 1.26491815e-02, 1.27407202e-02, 1.28569413e-02, 1.30046141e-02, 1.31928043e-02, 1.34332093e-02, 1.37412560e-02, 1.41374305e-02, 1.46489987e-02, 1.53125155e-02, 1.61769699e-02, 1.73084691e-02, 1.87957785e-02, 2.07578244e-02, 2.33515933e-02, 2.67822726e-02, 3.13119974e-02, 3.72671471e-02, 4.50437524e-02, 5.51068843e-02, 6.79907375e-02, 8.42989895e-02, 1.04711501e-01, 1.29995680e-01, 1.61013039e-01, 1.98704323e-01, 2.44036320e-01, 2.97898684e-01, 3.60942475e-01, 4.33362426e-01, 5.14611077e-01, 6.03115949e-01, 6.96019156e-01, 7.89120432e-01, 8.77179772e-01, 9.54658729e-01, 1.01691666e+00, 1.06146535e+00, 1.08867370e+00, 1.10145474e+00, 1.10398678e+00, 1.10028693e+00, 1.09334502e+00, 1.08501329e+00, 1.07633203e+00, 1.06786125e+00, 1.05989154e+00, 1.05256699e+00, 1.04594321e+00, 1.04001758e+00, 1.03476317e+00, 1.03013192e+00, 1.02607560e+00, 1.02252707e+00, 1.01944220e+00, 1.01676439e+00, 1.01443869e+00, 1.01243003e+00, 1.01069423e+00, 1.00919511e+00, 1.00790231e+00, 1.00679126e+00, 1.00583247e+00, 1.00500847e+00, 1.00429744e+00, 1.00368924e+00, 1.00316479e+00, 1.00271388e+00, 1.00232816e+00, 1.00199528e+00, 1.00171220e+00, 1.00146698e+00},
 { 9.80614235e-03, 9.81504969e-03, 9.82630131e-03, 9.84048728e-03, 9.85835394e-03, 9.88091572e-03, 9.90940651e-03, 9.94538583e-03, 9.99086475e-03, 1.00483965e-02, 1.01212829e-02, 1.02138240e-02, 1.03314116e-02, 1.04812666e-02, 1.06727080e-02, 1.09180275e-02, 1.12335512e-02, 1.16410142e-02, 1.21695663e-02, 1.28582904e-02, 1.37599566e-02, 1.49454769e-02, 1.65099538e-02, 1.85791002e-02, 2.13175297e-02, 2.49360802e-02, 2.96981979e-02, 3.59251415e-02, 4.39968655e-02, 5.43541379e-02, 6.75018704e-02, 8.40189525e-02, 1.04573920e-01, 1.29939743e-01, 1.60995329e-01, 1.98700822e-01, 2.44036995e-01, 2.97899712e-01, 3.60945015e-01, 4.33362295e-01, 5.14612632e-01, 6.03117303e-01, 6.96015760e-01, 7.89117825e-01, 8.77174456e-01, 9.54649597e-01, 1.01690583e+00, 1.06145029e+00, 1.08866024e+00, 1.10143878e+00, 1.10397100e+00, 1.10027470e+00, 1.09333199e+00, 1.08500151e+00, 1.07632320e+00, 1.06785234e+00, 1.05988365e+00, 1.05256175e+00, 1.04593679e+00, 1.04001245e+00, 1.03475731e+00, 1.03013104e+00, 1.02606885e+00, 1.02252576e+00, 1.01944225e+00, 1.01675946e+00, 1.01443796e+00, 1.01242908e+00, 1.01069231e+00, 1.00919318e+00, 1.00790334e+00, 1.00678989e+00, 1.00583227e+00, 1.00500593e+00, 1.00429832e+00, 1.00368822e+00, 1.00316359e+00, 1.00271442e+00, 1.00232698e+00, 1.00199700e+00, 1.00171148e+00},
 { 7.78941783e-03, 7.79650631e-03, 7.80546036e-03, 7.81674957e-03, 7.83096798e-03, 7.84892281e-03, 7.87159608e-03, 7.90022899e-03, 7.93642209e-03, 7.98220754e-03, 8.04021343e-03, 8.11386230e-03, 8.20744636e-03, 8.32671403e-03, 8.47908472e-03, 8.67434593e-03, 8.92549977e-03, 9.24985960e-03, 9.67065158e-03, 1.02190276e-02, 1.09370684e-02, 1.18813568e-02, 1.31278384e-02, 1.47770136e-02, 1.69606730e-02, 1.98479550e-02, 2.36507943e-02, 2.86286423e-02, 3.50900568e-02, 4.33957290e-02, 5.39631441e-02, 6.72774244e-02, 8.39083155e-02, 1.04528638e-01, 1.29925126e-01, 1.60992135e-01, 1.98700998e-01, 2.44037478e-01, 2.97901519e-01, 3.60944769e-01, 4.33363743e-01, 5.14614364e-01, 6.03115576e-01, 6.96015528e-01, 7.89116139e-01, 8.77170254e-01, 9.54644604e-01, 1.01689724e+00, 1.06144319e+00, 1.08865023e+00, 1.10142824e+00, 1.10396327e+00, 1.10026551e+00, 1.09332349e+00, 1.08499551e+00, 1.07631672e+00, 1.06784653e+00, 1.05988022e+00, 1.05255687e+00, 1.04593299e+00, 1.04000772e+00, 1.03475742e+00, 1.03012512e+00, 1.02606827e+00, 1.02252643e+00, 1.01943783e+00, 1.01675918e+00, 1.01443739e+00, 1.01242749e+00, 1.01069066e+00, 1.00919445e+00, 1.00790218e+00, 1.00678987e+00, 1.00582988e+00, 1.00500694e+00, 1.00429742e+00, 1.00368712e+00, 1.00316421e+00, 1.00271332e+00, 1.00232877e+00, 1.00199633e+00},
 { 6.18742224e-03, 6.19306110e-03, 6.20018400e-03, 6.20916452e-03, 6.22047525e-03, 6.23475833e-03, 6.25279498e-03, 6.27557266e-03, 6.30436469e-03, 6.34078784e-03, 6.38693301e-03, 6.44552324e-03, 6.51997383e-03, 6.61485883e-03, 6.73608255e-03, 6.89143452e-03, 7.09126401e-03, 7.34935425e-03, 7.68419963e-03, 8.12061278e-03, 8.69212346e-03, 9.44383837e-03, 1.04363385e-02, 1.17498616e-02, 1.34897479e-02, 1.57914053e-02, 1.88248783e-02, 2.27989744e-02, 2.79630999e-02, 3.46105382e-02, 4.30834724e-02, 5.37836058e-02, 6.71887031e-02, 8.38718283e-02, 1.04516701e-01, 1.29922345e-01, 1.60992052e-01, 1.98701156e-01, 2.44038732e-01, 2.97901133e-01, 3.60945889e-01, 4.33365289e-01, 5.14613255e-01, 6.03116143e-01, 6.96015345e-01, 7.89114312e-01, 8.77168311e-01, 9.54639797e-01, 1.01689412e+00, 1.06143723e+00, 1.08864345e+00, 1.10142382e+00, 1.10395692e+00, 1.10025944e+00, 1.09331958e+00, 1.08499080e+00, 1.07631244e+00, 1.06784442e+00, 1.05987646e+00, 1.05255404e+00, 1.04592908e+00, 1.04000857e+00, 1.03475210e+00, 1.03012507e+00, 1.02606941e+00, 1.02252240e+00, 1.01943789e+00, 1.01675890e+00, 1.01443605e+00, 1.01242606e+00, 1.01069212e+00, 1.00919345e+00, 1.00790229e+00, 1.00678759e+00, 1.00583100e+00, 1.00500613e+00, 1.00429639e+00, 1.00368781e+00, 1.00316317e+00, 1.00271515e+00, 1.00232814e+00},
 { 4.91488225e-03, 4.91936658e-03, 4.92503108e-03, 4.93217288e-03, 4.94116782e-03, 4.95252654e-03, 4.96687036e-03, 4.98498459e-03, 5.00788193e-03, 5.03684822e-03, 5.07354644e-03, 5.12014237e-03, 5.17935256e-03, 5.25481533e-03, 5.35122748e-03, 5.47478596e-03, 5.63372495e-03, 5.83901228e-03, 6.10536711e-03, 6.45254167e-03, 6.90723518e-03, 7.50537927e-03, 8.29525662e-03, 9.34086013e-03, 1.07262798e-02, 1.25597437e-02, 1.49774014e-02, 1.81468424e-02, 2.22689232e-02, 2.75809343e-02, 3.43614489e-02, 4.29400748e-02, 5.37126115e-02, 6.71594050e-02, 8.38621541e-02, 1.04514351e-01, 1.29922150e-01, 1.60992038e-01, 1.98702028e-01, 2.44038274e-01, 2.97901942e-01, 3.60947122e-01, 4.33364410e-01, 5.14613969e-01, 6.03116469e-01, 6.96014558e-01, 7.89113796e-01, 8.77165563e-01, 9.54638926e-01, 1.01689073e+00, 1.06143302e+00, 1.08864138e+00, 1.10141956e+00, 1.10395264e+00, 1.10025706e+00, 1.09331618e+00, 1.08498765e+00, 1.07631131e+00, 1.06784149e+00, 1.05987434e+00, 1.05255073e+00, 1.04593047e+00, 1.04000368e+00, 1.03475245e+00, 1.03012655e+00, 1.02606565e+00, 1.02252270e+00, 1.01943783e+00, 1.01675774e+00, 1.01443477e+00, 1.01242765e+00, 1.01069123e+00, 1.00919366e+00, 1.00790010e+00, 1.00678879e+00, 1.00583024e+00, 1.00500515e+00, 1.00429712e+00, 1.00368680e+00, 1.00316503e+00, 1.00271455e+00},
 { 3.90405142e-03, 3.90761674e-03, 3.91212037e-03, 3.91779855e-03, 3.92495010e-03, 3.93398103e-03, 3.94538533e-03, 3.95978740e-03, 3.97799244e-03, 4.00102285e-03, 4.03020092e-03, 4.06724873e-03, 4.11432646e-03, 4.17432730e-03, 4.25098635e-03, 4.34923205e-03, 4.47561351e-03, 4.63885506e-03, 4.85066658e-03, 5.12676489e-03, 5.48839937e-03, 5.96417608e-03, 6.59254940e-03, 7.42451382e-03, 8.52712720e-03, 9.98678234e-03, 1.19123105e-02, 1.44379297e-02, 1.77249313e-02, 2.19645585e-02, 2.73824123e-02, 3.42470523e-02, 4.28833587e-02, 5.36891472e-02, 6.71516073e-02, 8.38602074e-02, 1.04514123e-01, 1.29922057e-01, 1.60992656e-01, 1.98701561e-01, 2.44038846e-01, 2.97902887e-01, 3.60946356e-01, 4.33365046e-01, 5.14614393e-01, 6.03116092e-01, 6.96014622e-01, 7.89112101e-01, 8.77165815e-01, 9.54637046e-01, 1.01688817e+00, 1.06143252e+00, 1.08863862e+00, 1.10141659e+00, 1.10395139e+00, 1.10025462e+00, 1.09331384e+00, 1.08498724e+00, 1.07630898e+00, 1.06783989e+00, 1.05987148e+00, 1.05255253e+00, 1.04592590e+00, 1.04000432e+00, 1.03475419e+00, 1.03012299e+00, 1.02606614e+00, 1.02252280e+00, 1.01943680e+00, 1.01675657e+00, 1.01443647e+00, 1.01242685e+00, 1.01069152e+00, 1.00919153e+00, 1.00790135e+00, 1.00678807e+00, 1.00582930e+00, 1.00500592e+00, 1.00429614e+00, 1.00368869e+00, 1.00316445e+00},
 { 3.10111078e-03, 3.10394489e-03, 3.10752487e-03, 3.11203852e-03, 3.11772337e-03, 3.12490218e-03, 3.13396761e-03, 3.14541605e-03, 3.15988758e-03, 3.17819496e-03, 3.20138935e-03, 3.23083977e-03, 3.26826359e-03, 3.31596094e-03, 3.37690144e-03, 3.45500367e-03, 3.55547516e-03, 3.68525360e-03, 3.85365189e-03, 4.07317142e-03, 4.36071737e-03, 4.73905311e-03, 5.23878855e-03, 5.90053322e-03, 6.77771927e-03, 7.93923944e-03, 9.47197456e-03, 1.14832331e-02, 1.41022415e-02, 1.74826622e-02, 2.18064498e-02, 2.72912356e-02, 3.42018000e-02, 4.28646031e-02, 5.36828866e-02, 6.71500162e-02, 8.38599860e-02, 1.04514004e-01, 1.29922504e-01, 1.60992220e-01, 1.98701968e-01, 2.44039563e-01, 2.97902208e-01, 3.60946864e-01, 4.33365425e-01, 5.14614163e-01, 6.03116341e-01, 6.96013456e-01, 7.89112819e-01, 8.77164752e-01, 9.54635458e-01, 1.01688861e+00, 1.06143078e+00, 1.08863660e+00, 1.10141618e+00, 1.10394967e+00, 1.10025289e+00, 1.09331396e+00, 1.08498534e+00, 1.07630777e+00, 1.06783735e+00, 1.05987358e+00, 1.05254818e+00, 1.04592676e+00, 1.04000625e+00, 1.03475077e+00, 1.03012362e+00, 1.02606636e+00, 1.02252187e+00, 1.01943572e+00, 1.01675835e+00, 1.01443573e+00, 1.01242719e+00, 1.01068943e+00, 1.00919282e+00, 1.00790067e+00, 1.00678716e+00, 1.00583010e+00, 1.00500496e+00, 1.00429805e+00, 1.00368813e+00},
 { 2.46330715e-03, 2.46555968e-03, 2.46840501e-03, 2.47199241e-03, 2.47651069e-03, 2.48221635e-03, 2.48942150e-03, 2.49852066e-03, 2.51002258e-03, 2.52457327e-03, 2.54300823e-03, 2.56641560e-03, 2.59616047e-03, 2.63407115e-03, 2.68250822e-03, 2.74458671e-03, 2.82444650e-03, 2.92760327e-03, 3.06146170e-03, 3.23596281e-03, 3.46455138e-03, 3.76533476e-03, 4.16266802e-03, 4.68887365e-03, 5.38649940e-03, 6.31043856e-03, 7.52997707e-03, 9.13079355e-03, 1.12162386e-02, 1.39094831e-02, 1.73568095e-02, 2.17338321e-02, 2.72551651e-02, 3.41868300e-02, 4.28595909e-02, 5.36815978e-02, 6.71498186e-02, 8.38598660e-02, 1.04514335e-01, 1.29922121e-01, 1.60992514e-01, 1.98702514e-01, 2.44038972e-01, 2.97902599e-01, 3.60947165e-01, 4.33365245e-01, 5.14614433e-01, 6.03115452e-01, 6.96014296e-01, 7.89112172e-01, 8.77163712e-01, 9.54636390e-01, 1.01688752e+00, 1.06142941e+00, 1.08863677e+00, 1.10141498e+00, 1.10394839e+00, 1.10025341e+00, 1.09331239e+00, 1.08498441e+00, 1.07630545e+00, 1.06783968e+00, 1.05986938e+00, 1.05254920e+00, 1.04592883e+00, 1.04000294e+00, 1.03475150e+00, 1.03012392e+00, 1.02606550e+00, 1.02252084e+00, 1.01943755e+00, 1.01675765e+00, 1.01443610e+00, 1.01242513e+00, 1.01069075e+00, 1.00919216e+00, 1.00789978e+00, 1.00678798e+00, 1.00582915e+00, 1.00500688e+00, 1.00429750e+00},
 { 1.95667874e-03, 1.95846881e-03, 1.96072998e-03, 1.96358087e-03, 1.96717153e-03, 1.97170579e-03, 1.97743171e-03, 1.98466280e-03, 1.99380337e-03, 2.00536684e-03, 2.02001718e-03, 2.03861919e-03, 2.06225778e-03, 2.09238603e-03, 2.13088009e-03, 2.18021583e-03, 2.24368380e-03, 2.32566836e-03, 2.43205579e-03, 2.57074933e-03, 2.75243898e-03, 2.99152421e-03, 3.30737668e-03, 3.72571222e-03, 4.28039413e-03, 5.01513306e-03, 5.98513815e-03, 7.25874505e-03, 8.91849297e-03, 1.10629253e-02, 1.38093496e-02, 1.72990057e-02, 2.17051020e-02, 2.72432298e-02, 3.41828254e-02, 4.28585532e-02, 5.36814292e-02, 6.71497097e-02, 8.38601165e-02, 1.04514008e-01, 1.29922337e-01, 1.60992935e-01, 1.98702009e-01, 2.44039269e-01, 2.97902829e-01, 3.60947007e-01, 4.33365481e-01, 5.14613711e-01, 6.03116257e-01, 6.96013855e-01, 7.89111432e-01, 8.77164833e-01, 9.54635698e-01, 1.01688659e+00, 1.06142996e+00, 1.08863595e+00, 1.10141403e+00, 1.10394919e+00, 1.10025207e+00, 1.09331167e+00, 1.08498226e+00, 1.07630795e+00, 1.06783558e+00, 1.05987052e+00, 1.05255139e+00, 1.04592558e+00, 1.04000374e+00, 1.03475187e+00, 1.03012311e+00, 1.02606451e+00, 1.02252272e+00, 1.01943688e+00, 1.01675806e+00, 1.01443407e+00, 1.01242647e+00, 1.01069011e+00, 1.00919129e+00, 1.00790061e+00, 1.00678704e+00, 1.00583109e+00, 1.00500634e+00},
 { 1.55424774e-03, 1.55567017e-03, 1.55746694e-03, 1.55973231e-03, 1.56258552e-03, 1.56618854e-03, 1.57073847e-03, 1.57648446e-03, 1.58374777e-03, 1.59293639e-03, 1.60457795e-03, 1.61935965e-03, 1.63814364e-03, 1.66208465e-03, 1.69267363e-03, 1.73187820e-03, 1.78231348e-03, 1.84746403e-03, 1.93200837e-03, 2.04222855e-03, 2.18662254e-03, 2.37663851e-03, 2.62768017e-03, 2.96020036e-03, 3.40113959e-03, 3.98528631e-03, 4.75660429e-03, 5.76955075e-03, 7.08997046e-03, 8.79658595e-03, 1.09832824e-02, 1.37633581e-02, 1.72761357e-02, 2.16955942e-02, 2.72400349e-02, 3.41819932e-02, 4.28584130e-02, 5.36813354e-02, 6.71499022e-02, 8.38598449e-02, 1.04514172e-01, 1.29922664e-01, 1.60992511e-01, 1.98702236e-01, 2.44039444e-01, 2.97902687e-01, 3.60947198e-01, 4.33364879e-01, 5.14614420e-01, 6.03115924e-01, 6.96013285e-01, 7.89112564e-01, 8.77164364e-01, 9.54635024e-01, 1.01688734e+00, 1.06142940e+00, 1.08863524e+00, 1.10141504e+00, 1.10394804e+00, 1.10025150e+00, 1.09330963e+00, 1.08498490e+00, 1.07630392e+00, 1.06783682e+00, 1.05987280e+00, 1.05254818e+00, 1.04592645e+00, 1.04000416e+00, 1.03475109e+00, 1.03012215e+00, 1.02606642e+00, 1.02252208e+00, 1.01943731e+00, 1.01675603e+00, 1.01443543e+00, 1.01242585e+00, 1.01068925e+00, 1.00919213e+00, 1.00789968e+00, 1.00678899e+00, 1.00583055e+00},
 { 1.23458441e-03, 1.23571462e-03, 1.23714226e-03, 1.23894223e-03, 1.24120928e-03, 1.24407210e-03, 1.24768729e-03, 1.25225283e-03, 1.25802399e-03, 1.26532493e-03, 1.27457491e-03, 1.28631997e-03, 1.30124516e-03, 1.32026804e-03, 1.34457335e-03, 1.37572461e-03, 1.41579995e-03, 1.46756848e-03, 1.53474828e-03, 1.62233208e-03, 1.73707423e-03, 1.88807480e-03, 2.08757967e-03, 2.35185152e-03, 2.70231646e-03, 3.16665080e-03, 3.77984546e-03, 4.58526877e-03, 5.63540117e-03, 6.99305688e-03, 8.73325779e-03, 1.09467020e-02, 1.37451611e-02, 1.72685664e-02, 2.16930480e-02, 2.72393694e-02, 3.41818786e-02, 4.28583347e-02, 5.36814850e-02, 6.71496796e-02, 8.38599697e-02, 1.04514427e-01, 1.29922314e-01, 1.60992686e-01, 1.98702369e-01, 2.44039318e-01, 2.97902838e-01, 3.60946693e-01, 4.33365480e-01, 5.14614150e-01, 6.03115460e-01, 6.96014335e-01, 7.89112220e-01, 8.77163850e-01, 9.54635861e-01, 1.01688695e+00, 1.06142886e+00, 1.08863638e+00, 1.10141402e+00, 1.10394758e+00, 1.10024955e+00, 1.09331238e+00, 1.08498091e+00, 1.07630524e+00, 1.06783917e+00, 1.05986962e+00, 1.05254909e+00, 1.04592690e+00, 1.04000340e+00, 1.03475015e+00, 1.03012410e+00, 1.02606580e+00, 1.02252252e+00, 1.01943530e+00, 1.01675741e+00, 1.01443481e+00, 1.01242499e+00, 1.01069009e+00, 1.00919121e+00, 1.00790164e+00, 1.00678846e+00},
 { 9.80666199e-04, 9.81564158e-04, 9.82698435e-04, 9.84128536e-04, 9.85929732e-04, 9.88204277e-04, 9.91076598e-04, 9.94703981e-04, 9.99289250e-04, 1.00508996e-03, 1.01243922e-03, 1.02177088e-03, 1.03362925e-03, 1.04874335e-03, 1.06805455e-03, 1.09280516e-03, 1.12464645e-03, 1.16577876e-03, 1.21915662e-03, 1.28874761e-03, 1.37991952e-03, 1.49990488e-03, 1.65843743e-03, 1.86844544e-03, 2.14696501e-03, 2.51600729e-03, 3.00341027e-03, 3.64369309e-03, 4.47865501e-03, 5.55836992e-03, 6.94271224e-03, 8.70417069e-03, 1.09322284e-02, 1.37391381e-02, 1.72665389e-02, 2.16925169e-02, 2.72392766e-02, 3.41818143e-02, 4.28584519e-02, 5.36813044e-02, 6.71497763e-02, 8.38601709e-02, 1.04514141e-01, 1.29922450e-01, 1.60992788e-01, 1.98702261e-01, 2.44039436e-01, 2.97902416e-01, 3.60947191e-01, 4.33365255e-01, 5.14613764e-01, 6.03116389e-01, 6.96014065e-01, 7.89111806e-01, 8.77164685e-01, 9.54635575e-01, 1.01688652e+00, 1.06143007e+00, 1.08863546e+00, 1.10141364e+00, 1.10394569e+00, 1.10025238e+00, 1.09330841e+00, 1.08498228e+00, 1.07630764e+00, 1.06783599e+00, 1.05987056e+00, 1.05254957e+00, 1.04592616e+00, 1.04000248e+00, 1.03475212e+00, 1.03012348e+00, 1.02606626e+00, 1.02252051e+00, 1.01943669e+00, 1.01675680e+00, 1.01443396e+00, 1.01242584e+00, 1.01068917e+00, 1.00919317e+00, 1.00790111e+00},
 { 7.78971426e-04, 7.79684831e-04, 7.80585984e-04, 7.81722162e-04, 7.83153167e-04, 7.84960235e-04, 7.87242222e-04, 7.90124088e-04, 7.93766975e-04, 7.98375505e-04, 8.04214330e-04, 8.11628136e-04, 8.21049378e-04, 8.33057270e-04, 8.48399727e-04, 8.68063810e-04, 8.93361486e-04, 9.26041054e-04, 9.68450090e-04, 1.02374124e-03, 1.09617994e-03, 1.19151380e-03, 1.31747867e-03, 1.48435039e-03, 1.70567180e-03, 1.99894404e-03, 2.38630726e-03, 2.89522546e-03, 3.55897211e-03, 4.41743535e-03, 5.51835372e-03, 6.91958850e-03, 8.69266183e-03, 1.09274376e-02, 1.37375245e-02, 1.72661155e-02, 2.16924422e-02, 2.72392245e-02, 3.41819067e-02, 4.28583063e-02, 5.36813800e-02, 6.71499354e-02, 8.38599390e-02, 1.04514248e-01, 1.29922529e-01, 1.60992697e-01, 1.98702353e-01, 2.44039087e-01, 2.97902824e-01, 3.60947002e-01, 4.33364931e-01, 5.14614563e-01, 6.03116167e-01, 6.96013721e-01, 7.89112589e-01, 8.77164465e-01, 9.54635231e-01, 1.01688774e+00, 1.06142923e+00, 1.08863515e+00, 1.10141181e+00, 1.10394858e+00, 1.10024842e+00, 1.09330983e+00, 1.08498473e+00, 1.07630447e+00, 1.06783697e+00, 1.05987106e+00, 1.05254884e+00, 1.04592525e+00, 1.04000447e+00, 1.03475151e+00, 1.03012395e+00, 1.02606424e+00, 1.02252191e+00, 1.01943608e+00, 1.01675595e+00, 1.01443482e+00, 1.01242493e+00, 1.01069114e+00, 1.00919264e+00},
 { 6.18759351e-04, 6.19326112e-04, 6.20042027e-04, 6.20944657e-04, 6.22081511e-04, 6.23517126e-04, 6.25330038e-04, 6.27619523e-04, 6.30513598e-04, 6.34174828e-04, 6.38813465e-04, 6.44703347e-04, 6.52188045e-04, 6.61727724e-04, 6.73916584e-04, 6.89538823e-04, 7.09636791e-04, 7.35599517e-04, 7.69292202e-04, 8.13219766e-04, 8.70771412e-04, 9.46514250e-04, 1.04659568e-03, 1.17918221e-03, 1.35503798e-03, 1.58807542e-03, 1.89589854e-03, 2.30035084e-03, 2.82790734e-03, 3.51032371e-03, 4.38563294e-03, 5.49997390e-03, 6.91043910e-03, 8.68885231e-03, 1.09261540e-02, 1.37371873e-02, 1.72660557e-02, 2.16924002e-02, 2.72392975e-02, 3.41817899e-02, 4.28583658e-02, 5.36815061e-02, 6.71497484e-02, 8.38600231e-02, 1.04514309e-01, 1.29922453e-01, 1.60992769e-01, 1.98702066e-01, 2.44039419e-01, 2.97902667e-01, 3.60946732e-01, 4.33365604e-01, 5.14614377e-01, 6.03115877e-01, 6.96014424e-01, 7.89112410e-01, 8.77164174e-01, 9.54636405e-01, 1.01688698e+00, 1.06142896e+00, 1.08863338e+00, 1.10141472e+00, 1.10394464e+00, 1.10024987e+00, 1.09331232e+00, 1.08498155e+00, 1.07630547e+00, 1.06783749e+00, 1.05987035e+00, 1.05254793e+00, 1.04592726e+00, 1.04000387e+00, 1.03475199e+00, 1.03012194e+00, 1.02606565e+00, 1.02252131e+00, 1.01943523e+00, 1.01675681e+00, 1.01443390e+00, 1.01242690e+00, 1.01069061e+00},
 { 4.91498241e-04, 4.91948488e-04, 4.92517225e-04, 4.93234293e-04, 4.94137432e-04, 4.95277915e-04, 4.96718130e-04, 4.98536945e-04, 5.00836060e-04, 5.03744621e-04, 5.07429659e-04, 5.12108719e-04, 5.18054745e-04, 5.25633310e-04, 5.35316471e-04, 5.47727237e-04, 5.63693708e-04, 5.84319425e-04, 6.11086256e-04, 6.45984361e-04, 6.91706539e-04, 7.51881603e-04, 8.31394234e-04, 9.36733940e-04, 1.07645517e-03, 1.26161579e-03, 1.50621016e-03, 1.82760695e-03, 2.24686437e-03, 2.78925198e-03, 3.48505181e-03, 4.37102578e-03, 5.49270150e-03, 6.90741054e-03, 8.68783150e-03, 1.09258857e-02, 1.37371396e-02, 1.72660221e-02, 2.16924581e-02, 2.72392040e-02, 3.41818369e-02, 4.28584659e-02, 5.36813560e-02, 6.71498149e-02, 8.38600717e-02, 1.04514247e-01, 1.29922511e-01, 1.60992536e-01, 1.98702336e-01, 2.44039288e-01, 2.97902442e-01, 3.60947292e-01, 4.33365448e-01, 5.14614131e-01, 6.03116491e-01, 6.96014274e-01, 7.89112161e-01, 8.77165270e-01, 9.54635710e-01, 1.01688674e+00, 1.06142726e+00, 1.08863628e+00, 1.10141081e+00, 1.10394611e+00, 1.10025240e+00, 1.09330913e+00, 1.08498257e+00, 1.07630600e+00, 1.06783677e+00, 1.05986944e+00, 1.05254996e+00, 1.04592666e+00, 1.04000435e+00, 1.03474997e+00, 1.03012336e+00, 1.02606505e+00, 1.02252046e+00, 1.01943610e+00, 1.01675590e+00, 1.01443588e+00, 1.01242637e+00},
 { 3.90411066e-04, 3.90768742e-04, 3.91220548e-04, 3.91790187e-04, 3.92507643e-04, 3.93413644e-04, 3.94557753e-04, 3.96002623e-04, 3.97829045e-04, 4.00139614e-04, 4.03067020e-04, 4.06784082e-04, 4.11507632e-04, 4.17528086e-04, 4.25220456e-04, 4.35079674e-04, 4.47763610e-04, 4.64148960e-04, 4.85412995e-04, 5.13136826e-04, 5.49459837e-04, 5.97265146e-04, 6.60433820e-04, 7.44122305e-04, 8.55128297e-04, 1.00223967e-03, 1.19657950e-03, 1.45195540e-03, 1.78511243e-03, 2.21615141e-03, 2.76917127e-03, 3.47344416e-03, 4.36524610e-03, 5.49029422e-03, 6.90659895e-03, 8.68761810e-03, 1.09258476e-02, 1.37371127e-02, 1.72660680e-02, 2.16923835e-02, 2.72392413e-02, 3.41819164e-02, 4.28583457e-02, 5.36814087e-02, 6.71498533e-02, 8.38600213e-02, 1.04514293e-01, 1.29922321e-01, 1.60992753e-01, 1.98702228e-01, 2.44039104e-01, 2.97902904e-01, 3.60947162e-01, 4.33365242e-01, 5.14614657e-01, 6.03116364e-01, 6.96014060e-01, 7.89113155e-01, 8.77164642e-01, 9.54635502e-01, 1.01688513e+00, 1.06143010e+00, 1.08863243e+00, 1.10141229e+00, 1.10394865e+00, 1.10024919e+00, 1.09331016e+00, 1.08498311e+00, 1.07630528e+00, 1.06783586e+00, 1.05987149e+00, 1.05254936e+00, 1.04592715e+00, 1.04000233e+00, 1.03475140e+00, 1.03012275e+00, 1.02606420e+00, 1.02252133e+00, 1.01943518e+00, 1.01675788e+00, 1.01443535e+00},
 { 3.10114617e-04, 3.10398750e-04, 3.10757658e-04, 3.11210172e-04, 3.11780109e-04, 3.12499824e-04, 3.13408689e-04, 3.14556475e-04, 3.16007361e-04, 3.17842847e-04, 3.20168342e-04, 3.23121133e-04, 3.26873468e-04, 3.31656055e-04, 3.37766801e-04, 3.45598886e-04, 3.55674925e-04, 3.68691383e-04, 3.85583511e-04, 4.07607403e-04, 4.36462695e-04, 4.74439938e-04, 5.24622623e-04, 5.91107699e-04, 6.79296444e-04, 7.96172033e-04, 9.50574220e-04, 1.15347786e-03, 1.41819532e-03, 1.76071127e-03, 2.20019662e-03, 2.75994799e-03, 3.46885131e-03, 4.36333293e-03, 5.48964911e-03, 6.90642927e-03, 8.68758777e-03, 1.09258261e-02, 1.37371491e-02, 1.72660085e-02, 2.16924130e-02, 2.72393045e-02, 3.41818204e-02, 4.28583876e-02, 5.36814391e-02, 6.71498127e-02, 8.38600572e-02, 1.04514140e-01, 1.29922496e-01, 1.60992666e-01, 1.98702077e-01, 2.44039481e-01, 2.97902796e-01, 3.60946990e-01, 4.33365685e-01, 5.14614550e-01, 6.03116181e-01, 6.96014940e-01, 7.89112594e-01, 8.77164458e-01, 9.54633994e-01, 1.01688786e+00, 1.06142636e+00, 1.08863390e+00, 1.10141484e+00, 1.10394545e+00, 1.10025024e+00, 1.09331072e+00, 1.08498240e+00, 1.07630437e+00, 1.06783793e+00, 1.05987088e+00, 1.05254986e+00, 1.04592511e+00, 1.04000376e+00, 1.03475079e+00, 1.03012190e+00, 1.02606508e+00, 1.02252041e+00, 1.01943717e+00, 1.01675735e+00},
 { 2.46332849e-04, 2.46558557e-04, 2.46843665e-04, 2.47203130e-04, 2.47655873e-04, 2.48227596e-04, 2.48949575e-04, 2.49861347e-04, 2.51013895e-04, 2.52471960e-04, 2.54319276e-04, 2.56664902e-04, 2.59645668e-04, 2.63444845e-04, 2.68299087e-04, 2.74520729e-04, 2.82524936e-04, 2.92864977e-04, 3.06283821e-04, 3.23779327e-04, 3.46701729e-04, 3.76870735e-04, 4.16736060e-04, 4.69552680e-04, 5.39612042e-04, 6.32462790e-04, 7.55129362e-04, 9.16333853e-04, 1.12665781e-03, 1.39880964e-03, 1.74803533e-03, 2.19286841e-03, 2.75629857e-03, 3.46733099e-03, 4.36282022e-03, 5.48951422e-03, 6.90640513e-03, 8.68757068e-03, 1.09258551e-02, 1.37371017e-02, 1.72660319e-02, 2.16924633e-02, 2.72392279e-02, 3.41818537e-02, 4.28584118e-02, 5.36814065e-02, 6.71498412e-02, 8.38599345e-02, 1.04514280e-01, 1.29922425e-01, 1.60992543e-01, 1.98702384e-01, 2.44039392e-01, 2.97902654e-01, 3.60947358e-01, 4.33365594e-01, 5.14614394e-01, 6.03116944e-01, 6.96014448e-01, 7.89112432e-01, 8.77163076e-01, 9.54636562e-01, 1.01688428e+00, 1.06142780e+00, 1.08863642e+00, 1.10141165e+00, 1.10394650e+00, 1.10025080e+00, 1.09331000e+00, 1.08498148e+00, 1.07630646e+00, 1.06783732e+00, 1.05987138e+00, 1.05254781e+00, 1.04592656e+00, 1.04000315e+00, 1.03474994e+00, 1.03012278e+00, 1.02606415e+00, 1.02252241e+00, 1.01943664e+00},
 { 1.95669170e-04, 1.95848464e-04, 1.96074944e-04, 1.96360490e-04, 1.96720134e-04, 1.97174291e-04, 1.97747806e-04, 1.98472086e-04, 1.99387629e-04, 2.00545866e-04, 2.02013311e-04, 2.03876596e-04, 2.06244417e-04, 2.09262357e-04, 2.13118410e-04, 2.18060686e-04, 2.24418985e-04, 2.32632813e-04, 2.43292379e-04, 2.57190378e-04, 2.75399443e-04, 2.99365184e-04, 3.31033735e-04, 3.72991031e-04, 4.28646556e-04, 5.02408837e-04, 5.99859330e-04, 7.27929058e-04, 8.95027748e-04, 1.11125722e-03, 1.38873915e-03, 1.74221314e-03, 2.18996883e-03, 2.75509054e-03, 3.46692356e-03, 4.36271300e-03, 5.48949502e-03, 6.90639153e-03, 8.68759368e-03, 1.09258174e-02, 1.37371204e-02, 1.72660719e-02, 2.16924022e-02, 2.72392544e-02, 3.41818729e-02, 4.28583856e-02, 5.36814292e-02, 6.71497428e-02, 8.38600469e-02, 1.04514223e-01, 1.29922326e-01, 1.60992791e-01, 1.98702312e-01, 2.44039276e-01, 2.97902958e-01, 3.60947283e-01, 4.33365463e-01, 5.14615045e-01, 6.03116518e-01, 6.96014305e-01, 7.89111191e-01, 8.77165438e-01, 9.54633205e-01, 1.01688566e+00, 1.06143027e+00, 1.08863327e+00, 1.10141270e+00, 1.10394707e+00, 1.10025008e+00, 1.09330908e+00, 1.08498359e+00, 1.07630585e+00, 1.06783783e+00, 1.05986932e+00, 1.05254927e+00, 1.04592595e+00, 1.04000230e+00, 1.03475082e+00, 1.03012186e+00, 1.02606616e+00, 1.02252188e+00},
 { 1.55425567e-04, 1.55567991e-04, 1.55747896e-04, 1.55974722e-04, 1.56260408e-04, 1.56621171e-04, 1.57076747e-04, 1.57652084e-04, 1.58379353e-04, 1.59299407e-04, 1.60465084e-04, 1.61945200e-04, 1.63826099e-04, 1.66223427e-04, 1.69286519e-04, 1.73212467e-04, 1.78263252e-04, 1.84788007e-04, 1.93255579e-04, 2.04295672e-04, 2.18760374e-04, 2.37798078e-04, 2.62954816e-04, 2.96284929e-04, 3.40497089e-04, 3.99093795e-04, 4.76509658e-04, 5.78251963e-04, 7.11003640e-04, 8.82793374e-04, 1.10325691e-03, 1.38411366e-03, 1.73990944e-03, 2.18900900e-03, 2.75476679e-03, 3.46683836e-03, 4.36269774e-03, 5.48948420e-03, 6.90640980e-03, 8.68756369e-03, 1.09258322e-02, 1.37371522e-02, 1.72660233e-02, 2.16924233e-02, 2.72392696e-02, 3.41818520e-02, 4.28584037e-02, 5.36813504e-02, 6.71498327e-02, 8.38600009e-02, 1.04514143e-01, 1.29922526e-01, 1.60992733e-01, 1.98702217e-01, 2.44039525e-01, 2.97902896e-01, 3.60947174e-01, 4.33366012e-01, 5.14614682e-01, 6.03116396e-01, 6.96013212e-01, 7.89113317e-01, 8.77162355e-01, 9.54634506e-01, 1.01688803e+00, 1.06142719e+00, 1.08863432e+00, 1.10141327e+00, 1.10394635e+00, 1.10024915e+00, 1.09331120e+00, 1.08498297e+00, 1.07630636e+00, 1.06783575e+00, 1.05987079e+00, 1.05254865e+00, 1.04592509e+00, 1.04000319e+00, 1.03474990e+00, 1.03012387e+00, 1.02606563e+00},
 { 1.23458929e-04, 1.23572064e-04, 1.23714972e-04, 1.23895151e-04, 1.24122086e-04, 1.24408659e-04, 1.24770546e-04, 1.25227566e-04, 1.25805274e-04, 1.26536120e-04, 1.27462078e-04, 1.28637811e-04, 1.30131908e-04, 1.32036231e-04, 1.34469408e-04, 1.37587999e-04, 1.41600112e-04, 1.46783085e-04, 1.53509355e-04, 1.62279141e-04, 1.73769322e-04, 1.88892163e-04, 2.08875825e-04, 2.35352294e-04, 2.70473409e-04, 3.17021736e-04, 3.78520507e-04, 4.59345435e-04, 5.64806756e-04, 7.01284740e-04, 8.76437852e-04, 1.09958229e-03, 1.38228347e-03, 1.73914687e-03, 2.18875178e-03, 2.75469909e-03, 3.46682623e-03, 4.36268914e-03, 5.48949872e-03, 6.90638596e-03, 8.68757545e-03, 1.09258575e-02, 1.37371135e-02, 1.72660400e-02, 2.16924354e-02, 2.72392529e-02, 3.41818664e-02, 4.28583408e-02, 5.36814223e-02, 6.71497959e-02, 8.38599367e-02, 1.04514304e-01, 1.29922479e-01, 1.60992655e-01, 1.98702419e-01, 2.44039474e-01, 2.97902805e-01, 3.60947631e-01, 4.33365706e-01, 5.14614578e-01, 6.03115448e-01, 6.96015088e-01, 7.89110544e-01, 8.77163552e-01, 9.54636726e-01, 1.01688509e+00, 1.06142822e+00, 1.08863488e+00, 1.10141255e+00, 1.10394542e+00, 1.10025129e+00, 1.09331058e+00, 1.08498349e+00, 1.07630427e+00, 1.06783723e+00, 1.05987017e+00, 1.05254779e+00, 1.04592598e+00, 1.04000225e+00, 1.03475192e+00, 1.03012333e+00},
 { 9.80669214e-05, 9.81567895e-05, 9.82703081e-05, 9.84134330e-05, 9.85936978e-05, 9.88213357e-05, 9.91087998e-05, 9.94718321e-05, 9.99307323e-05, 1.00511278e-04, 1.01246810e-04, 1.02180750e-04, 1.03367582e-04, 1.04880277e-04, 1.06813066e-04, 1.09290314e-04, 1.12477331e-04, 1.16594424e-04, 1.21937441e-04, 1.28903736e-04, 1.38031002e-04, 1.50043915e-04, 1.65918105e-04, 1.86950007e-04, 2.14849056e-04, 2.51825794e-04, 3.00679263e-04, 3.64885924e-04, 4.48664979e-04, 5.57086261e-04, 6.96235958e-04, 8.73518693e-04, 1.09812833e-03, 1.38167764e-03, 1.73894250e-03, 2.18869798e-03, 2.75468945e-03, 3.46681939e-03, 4.36270068e-03, 5.48947976e-03, 6.90639530e-03, 8.68759555e-03, 1.09258267e-02, 1.37371268e-02, 1.72660497e-02, 2.16924221e-02, 2.72392644e-02, 3.41818162e-02, 4.28583981e-02, 5.36813928e-02, 6.71497444e-02, 8.38600660e-02, 1.04514266e-01, 1.29922416e-01, 1.60992819e-01, 1.98702378e-01, 2.44039399e-01, 2.97903183e-01, 3.60947376e-01, 4.33365618e-01, 5.14613770e-01, 6.03117074e-01, 6.96012642e-01, 7.89111622e-01, 8.77165593e-01, 9.54633966e-01, 1.01688607e+00, 1.06142876e+00, 1.08863417e+00, 1.10141162e+00, 1.10394756e+00, 1.10025067e+00, 1.09331110e+00, 1.08498138e+00, 1.07630576e+00, 1.06783661e+00, 1.05986930e+00, 1.05254869e+00, 1.04592504e+00, 1.04000428e+00, 1.03475138e+00},
 { 7.78973297e-05, 7.79687157e-05, 7.80588884e-05, 7.81725787e-05, 7.83157707e-05, 7.84965932e-05, 7.87249383e-05, 7.90133105e-05, 7.93778346e-05, 7.98389872e-05, 8.04232517e-05, 8.11651210e-05, 8.21078730e-05, 8.33094728e-05, 8.48447719e-05, 8.68125593e-05, 8.93441498e-05, 9.26145431e-05, 9.68587472e-05, 1.02392403e-04, 1.09642630e-04, 1.19185088e-04, 1.31794785e-04, 1.48501583e-04, 1.70663441e-04, 2.00036425e-04, 2.38844172e-04, 2.89848578e-04, 3.56401790e-04, 4.42532057e-04, 5.53075612e-04, 6.93916998e-04, 8.72363653e-04, 1.09764704e-03, 1.38151528e-03, 1.73889976e-03, 2.18869032e-03, 2.75468402e-03, 3.46682856e-03, 4.36268561e-03, 5.48948719e-03, 6.90641128e-03, 8.68757106e-03, 1.09258373e-02, 1.37371345e-02, 1.72660391e-02, 2.16924313e-02, 2.72392244e-02, 3.41818619e-02, 4.28583745e-02, 5.36813516e-02, 6.71498479e-02, 8.38600352e-02, 1.04514216e-01, 1.29922549e-01, 1.60992786e-01, 1.98702317e-01, 2.44039708e-01, 2.97902972e-01, 3.60947303e-01, 4.33364938e-01, 5.14615157e-01, 6.03114955e-01, 6.96013593e-01, 7.89113458e-01, 8.77163057e-01, 9.54634887e-01, 1.01688659e+00, 1.06142807e+00, 1.08863325e+00, 1.10141376e+00, 1.10394694e+00, 1.10025120e+00, 1.09330898e+00, 1.08498289e+00, 1.07630513e+00, 1.06783573e+00, 1.05987021e+00, 1.05254774e+00, 1.04592709e+00, 1.04000375e+00},
 { 6.18760516e-05, 6.19327564e-05, 6.20043841e-05, 6.20946928e-05, 6.22084359e-05, 6.23520705e-05, 6.25334541e-05, 6.27625196e-05, 6.30520757e-05, 6.34183876e-05, 6.38824923e-05, 6.44717889e-05, 6.52206549e-05, 6.61751343e-05, 6.73946848e-05, 6.89577789e-05, 7.09687258e-05, 7.35665358e-05, 7.69378869e-05, 8.13335083e-05, 8.70926841e-05, 9.46726923e-05, 1.04689170e-04, 1.17960209e-04, 1.35564538e-04, 1.58897160e-04, 1.89724546e-04, 2.30240831e-04, 2.83109172e-04, 3.51530038e-04, 4.39346121e-04, 5.51233477e-04, 6.92999443e-04, 8.71981310e-04, 1.09751805e-03, 1.38148133e-03, 1.73889368e-03, 2.18868600e-03, 2.75469130e-03, 3.46681658e-03, 4.36269151e-03, 5.48949989e-03, 6.90639181e-03, 8.68757947e-03, 1.09258434e-02, 1.37371260e-02, 1.72660463e-02, 2.16923994e-02, 2.72392608e-02, 3.41818431e-02, 4.28583417e-02, 5.36814344e-02, 6.71498232e-02, 8.38599948e-02, 1.04514322e-01, 1.29922521e-01, 1.60992737e-01, 1.98702569e-01, 2.44039536e-01, 2.97902912e-01, 3.60946736e-01, 4.33366106e-01, 5.14613349e-01, 6.03115779e-01, 6.96015212e-01, 7.89111177e-01, 8.77163903e-01, 9.54635379e-01, 1.01688593e+00, 1.06142718e+00, 1.08863537e+00, 1.10141314e+00, 1.10394747e+00, 1.10024906e+00, 1.09331049e+00, 1.08498225e+00, 1.07630425e+00, 1.06783665e+00, 1.05986926e+00, 1.05254980e+00, 1.04592654e+00},
 { 4.91498968e-05, 4.91949396e-05, 4.92518362e-05, 4.93235718e-05, 4.94139222e-05, 4.95280165e-05, 4.96720963e-05, 4.98540516e-05, 5.00840569e-05, 5.03750322e-05, 5.07436881e-05, 5.12117886e-05, 5.18066411e-05, 5.25648204e-05, 5.35335559e-05, 5.47751815e-05, 5.63725542e-05, 5.84360959e-05, 6.11140931e-05, 6.46057113e-05, 6.91804601e-05, 7.52015786e-05, 8.31581013e-05, 9.36998865e-05, 1.07683843e-04, 1.26218127e-04, 1.50706009e-04, 1.82890530e-04, 2.24887394e-04, 2.79239277e-04, 3.48999256e-04, 4.37882787e-04, 5.50504590e-04, 6.92695712e-04, 8.71878844e-04, 1.09749108e-03, 1.38147649e-03, 1.73889025e-03, 2.18869179e-03, 2.75468178e-03, 3.46682127e-03, 4.36270160e-03, 5.48948441e-03, 6.90639850e-03, 8.68758432e-03, 1.09258367e-02, 1.37371318e-02, 1.72660210e-02, 2.16924284e-02, 2.72392458e-02, 3.41818169e-02, 4.28584077e-02, 5.36814146e-02, 6.71497909e-02, 8.38600803e-02, 1.04514300e-01, 1.29922482e-01, 1.60992940e-01, 1.98702429e-01, 2.44039487e-01, 2.97902444e-01, 3.60947709e-01, 4.33364583e-01, 5.14614052e-01, 6.03117182e-01, 6.96013201e-01, 7.89111938e-01, 8.77164356e-01, 9.54634761e-01, 1.01688507e+00, 1.06142925e+00, 1.08863476e+00, 1.10141367e+00, 1.10394532e+00, 1.10025058e+00, 1.09330986e+00, 1.08498136e+00, 1.07630517e+00, 1.06783569e+00, 1.05987133e+00, 1.05254925e+00},
 { 3.90411521e-05, 3.90769311e-05, 3.91221261e-05, 3.91791082e-05, 3.92508768e-05, 3.93415059e-05, 3.94559536e-05, 3.96004872e-05, 3.97831886e-05, 4.00143207e-05, 4.03071572e-05, 4.06789862e-05, 4.11514989e-05, 4.17537479e-05, 4.25232495e-05, 4.35095178e-05, 4.47783692e-05, 4.64175163e-05, 4.85447489e-05, 5.13182726e-05, 5.49521707e-05, 5.97349807e-05, 6.60551669e-05, 7.44289463e-05, 8.55370125e-05, 1.00259649e-04, 1.19711582e-04, 1.45277470e-04, 1.78638056e-04, 2.21813347e-04, 2.77228940e-04, 3.47836841e-04, 4.37303781e-04, 5.50263312e-04, 6.92614314e-04, 8.71857415e-04, 1.09748723e-03, 1.38147376e-03, 1.73889484e-03, 2.18868423e-03, 2.75468551e-03, 3.46682929e-03, 4.36268930e-03, 5.48948972e-03, 6.90640235e-03, 8.68757899e-03, 1.09258412e-02, 1.37371116e-02, 1.72660441e-02, 2.16924165e-02, 2.72392249e-02, 3.41818695e-02, 4.28583920e-02, 5.36813888e-02, 6.71498593e-02, 8.38600627e-02, 1.04514268e-01, 1.29922646e-01, 1.60992827e-01, 1.98702388e-01, 2.44039103e-01, 2.97903247e-01, 3.60946441e-01, 4.33365175e-01, 5.14615249e-01, 6.03115439e-01, 6.96013872e-01, 7.89112345e-01, 8.77163787e-01, 9.54633958e-01, 1.01688705e+00, 1.06142865e+00, 1.08863528e+00, 1.10141153e+00, 1.10394685e+00, 1.10024994e+00, 1.09330896e+00, 1.08498229e+00, 1.07630420e+00, 1.06783777e+00, 1.05987078e+00},
 { 3.10114902e-05, 3.10399107e-05, 3.10758107e-05, 3.11210735e-05, 3.11780817e-05, 3.12500715e-05, 3.13409812e-05, 3.14557892e-05, 3.16009151e-05, 3.17845112e-05, 3.20171213e-05, 3.23124778e-05, 3.26878108e-05, 3.31661979e-05, 3.37774396e-05, 3.45608666e-05, 3.55687594e-05, 3.68707913e-05, 3.85605273e-05, 4.07636362e-05, 4.36501730e-05, 4.74493354e-05, 5.24696980e-05, 5.91213170e-05, 6.79449031e-05, 7.96397179e-05, 9.50912632e-05, 1.15399484e-04, 1.41899555e-04, 1.76196204e-04, 2.20216439e-04, 2.76305571e-04, 3.47376901e-04, 4.37112118e-04, 5.50198651e-04, 6.92597291e-04, 8.71854363e-04, 1.09748507e-03, 1.38147742e-03, 1.73888884e-03, 2.18868719e-03, 2.75469188e-03, 3.46681951e-03, 4.36269352e-03, 5.48949279e-03, 6.90639811e-03, 8.68758263e-03, 1.09258252e-02, 1.37371300e-02, 1.72660346e-02, 2.16923998e-02, 2.72392669e-02, 3.41818570e-02, 4.28583714e-02, 5.36814435e-02, 6.71498452e-02, 8.38600372e-02, 1.04514401e-01, 1.29922555e-01, 1.60992794e-01, 1.98702076e-01, 2.44039761e-01, 2.97902200e-01, 3.60946934e-01, 4.33366184e-01, 5.14613762e-01, 6.03116021e-01, 6.96014231e-01, 7.89111834e-01, 8.77163050e-01, 9.54635815e-01, 1.01688648e+00, 1.06142915e+00, 1.08863316e+00, 1.10141306e+00, 1.10394621e+00, 1.10024904e+00, 1.09330990e+00, 1.08498132e+00, 1.07630631e+00, 1.06783722e+00},
 { 2.46333028e-05, 2.46558781e-05, 2.46843946e-05, 2.47203484e-05, 2.47656319e-05, 2.48228157e-05, 2.48950283e-05, 2.49862241e-05, 2.51015024e-05, 2.52473388e-05, 2.54321086e-05, 2.56667200e-05, 2.59648595e-05, 2.63448582e-05, 2.68303877e-05, 2.74526899e-05, 2.82532929e-05, 2.92875406e-05, 3.06297550e-05, 3.23797597e-05, 3.46726357e-05, 3.76904438e-05, 4.16782976e-05, 4.69619228e-05, 5.39708320e-05, 6.32604853e-05, 7.55342896e-05, 9.16660069e-05, 1.12716276e-04, 1.39959892e-04, 1.74927709e-04, 2.19482962e-04, 2.75940216e-04, 3.47224652e-04, 4.37060753e-04, 5.50185128e-04, 6.92594866e-04, 8.71852642e-04, 1.09748797e-03, 1.38147264e-03, 1.73889119e-03, 2.18869225e-03, 2.75468411e-03, 3.46682287e-03, 4.36269596e-03, 5.48948942e-03, 6.90640101e-03, 8.68756987e-03, 1.09258398e-02, 1.37371224e-02, 1.72660213e-02, 2.16924332e-02, 2.72392569e-02, 3.41818405e-02, 4.28584150e-02, 5.36814322e-02, 6.71498248e-02, 8.38601433e-02, 1.04514327e-01, 1.29922528e-01, 1.60992541e-01, 1.98702612e-01, 2.44038904e-01, 2.97902607e-01, 3.60947774e-01, 4.33364931e-01, 5.14614258e-01, 6.03116332e-01, 6.96013780e-01, 7.89111171e-01, 8.77164756e-01, 9.54635276e-01, 1.01688697e+00, 1.06142709e+00, 1.08863467e+00, 1.10141242e+00, 1.10394530e+00, 1.10024998e+00, 1.09330891e+00, 1.08498344e+00, 1.07630575e+00},
 { 1.95669282e-05, 1.95848605e-05, 1.96075121e-05, 1.96360713e-05, 1.96720414e-05, 1.97174644e-05, 1.97748252e-05, 1.98472649e-05, 1.99388341e-05, 2.00546767e-05, 2.02014452e-05, 2.03878046e-05, 2.06246263e-05, 2.09264715e-05, 2.13121432e-05, 2.18064579e-05, 2.24424027e-05, 2.32639393e-05, 2.43301042e-05, 2.57201906e-05, 2.75414982e-05, 2.99386449e-05, 3.31063337e-05, 3.73033021e-05, 4.28707305e-05, 5.02498475e-05, 5.99994066e-05, 7.28134897e-05, 8.95346375e-05, 1.11175527e-04, 1.38952274e-04, 1.74345076e-04, 2.19192743e-04, 2.75819276e-04, 3.47183849e-04, 4.37050011e-04, 5.50183202e-04, 6.92593499e-04, 8.71854947e-04, 1.09748418e-03, 1.38147451e-03, 1.73889521e-03, 2.18868608e-03, 2.75468678e-03, 3.46682480e-03, 4.36269328e-03, 5.48949172e-03, 6.90639086e-03, 8.68758148e-03, 1.09258338e-02, 1.37371119e-02, 1.72660479e-02, 2.16924253e-02, 2.72392438e-02, 3.41818753e-02, 4.28584060e-02, 5.36814159e-02, 6.71499098e-02, 8.38600842e-02, 1.04514306e-01, 1.29922324e-01, 1.60992975e-01, 1.98701914e-01, 2.44039237e-01, 2.97903300e-01, 3.60946731e-01, 4.33365349e-01, 5.14614524e-01, 6.03115942e-01, 6.96013195e-01, 7.89112705e-01, 8.77164262e-01, 9.54635733e-01, 1.01688499e+00, 1.06142856e+00, 1.08863404e+00, 1.10141151e+00, 1.10394625e+00, 1.10024899e+00, 1.09331105e+00, 1.08498288e+00},
 { 1.55425638e-05, 1.55568080e-05, 1.55748008e-05, 1.55974863e-05, 1.56260585e-05, 1.56621393e-05, 1.57077028e-05, 1.57652439e-05, 1.58379802e-05, 1.59299975e-05, 1.60465804e-05, 1.61946115e-05, 1.63827264e-05, 1.66224914e-05, 1.69288426e-05, 1.73214922e-05, 1.78266433e-05, 1.84792158e-05, 1.93261044e-05, 2.04302945e-05, 2.18770179e-05, 2.37811495e-05, 2.62973493e-05, 2.96311423e-05, 3.40535419e-05, 3.99150354e-05, 4.76594674e-05, 5.78381845e-05, 7.11204691e-05, 8.83107643e-05, 1.10375137e-04, 1.38489464e-04, 1.74114542e-04, 2.19096674e-04, 2.75786865e-04, 3.47175316e-04, 4.37048481e-04, 5.50182116e-04, 6.92595330e-04, 8.71851935e-04, 1.09748566e-03, 1.38147771e-03, 1.73889031e-03, 2.18868820e-03, 2.75468832e-03, 3.46682268e-03, 4.36269511e-03, 5.48948365e-03, 6.90640009e-03, 8.68757670e-03, 1.09258254e-02, 1.37371330e-02, 1.72660416e-02, 2.16924148e-02, 2.72392715e-02, 3.41818682e-02, 4.28583930e-02, 5.36814838e-02, 6.71498624e-02, 8.38600671e-02, 1.04514142e-01, 1.29922674e-01, 1.60992410e-01, 1.98702185e-01, 2.44039805e-01, 2.97902439e-01, 3.60947079e-01, 4.33365573e-01, 5.14614191e-01, 6.03115435e-01, 6.96014549e-01, 7.89112261e-01, 8.77164681e-01, 9.54633880e-01, 1.01688640e+00, 1.06142795e+00, 1.08863314e+00, 1.10141245e+00, 1.10394526e+00, 1.10025114e+00, 1.09331048e+00},
 { 1.23458974e-05, 1.23572120e-05, 1.23715042e-05, 1.23895240e-05, 1.24122198e-05, 1.24408799e-05, 1.24770723e-05, 1.25227790e-05, 1.25805557e-05, 1.26536478e-05, 1.27462532e-05, 1.28638388e-05, 1.30132642e-05, 1.32037170e-05, 1.34470611e-05, 1.37589548e-05, 1.41602119e-05, 1.46785704e-05, 1.53512803e-05, 1.62283730e-05, 1.73775508e-05, 1.88900629e-05, 2.08887610e-05, 2.35369010e-05, 2.70497594e-05, 3.17057423e-05, 3.78574149e-05, 4.59427388e-05, 5.64933617e-05, 7.01483041e-05, 8.76749858e-05, 1.10007510e-04, 1.38306341e-04, 1.74038230e-04, 2.19070928e-04, 2.75780086e-04, 3.47174101e-04, 4.37047618e-04, 5.50183571e-04, 6.92592938e-04, 8.71853114e-04, 1.09748820e-03, 1.38147381e-03, 1.73889199e-03, 2.18868942e-03, 2.75468663e-03, 3.46682413e-03, 4.36268870e-03, 5.48949099e-03, 6.90639629e-03, 8.68757004e-03, 1.09258422e-02, 1.37371280e-02, 1.72660333e-02, 2.16924369e-02, 2.72392658e-02, 3.41818578e-02, 4.28584472e-02, 5.36814460e-02, 6.71498488e-02, 8.38599354e-02, 1.04514423e-01, 1.29922218e-01, 1.60992630e-01, 1.98702647e-01, 2.44039100e-01, 2.97902727e-01, 3.60947265e-01, 4.33365292e-01, 5.14613758e-01, 6.03116608e-01, 6.96014157e-01, 7.89112638e-01, 8.77162979e-01, 9.54635202e-01, 1.01688581e+00, 1.06142707e+00, 1.08863408e+00, 1.10141147e+00, 1.10394742e+00, 1.10025058e+00},
 { 9.80669494e-06, 9.81568246e-06, 9.82703524e-06, 9.84134888e-06, 9.85937680e-06, 9.88214243e-06, 9.91089116e-06, 9.94719733e-06, 9.99309108e-06, 1.00511504e-05, 1.01247096e-05, 1.02181114e-05, 1.03368045e-05, 1.04880869e-05, 1.06813825e-05, 1.09291291e-05, 1.12478597e-05, 1.16596077e-05, 1.21939617e-05, 1.28906632e-05, 1.38034905e-05, 1.50049257e-05, 1.65925540e-05, 1.86960554e-05, 2.14864316e-05, 2.51848311e-05, 3.00713109e-05, 3.64937634e-05, 4.48745026e-05, 5.57211386e-05, 6.96432832e-05, 8.73829658e-05, 1.09862048e-04, 1.38245724e-04, 1.74017779e-04, 2.19065544e-04, 2.75779121e-04, 3.47173416e-04, 4.37048774e-04, 5.50181670e-04, 6.92593874e-04, 8.71855130e-04, 1.09748511e-03, 1.38147515e-03, 1.73889296e-03, 2.18868808e-03, 2.75468778e-03, 3.46681903e-03, 4.36269453e-03, 5.48948797e-03, 6.90639099e-03, 8.68758343e-03, 1.09258382e-02, 1.37371214e-02, 1.72660508e-02, 2.16924324e-02, 2.72392575e-02, 3.41819010e-02, 4.28584170e-02, 5.36814350e-02, 6.71497433e-02, 8.38601614e-02, 1.04514056e-01, 1.29922395e-01, 1.60993004e-01, 1.98702073e-01, 2.44039335e-01, 2.97902881e-01, 3.60947031e-01, 4.33364928e-01, 5.14614759e-01, 6.03116268e-01, 6.96014490e-01, 7.89111107e-01, 8.77164194e-01, 9.54634647e-01, 1.01688497e+00, 1.06142798e+00, 1.08863310e+00, 1.10141362e+00, 1.10394684e+00},
 { 7.78973473e-06, 7.79687379e-06, 7.80589164e-06, 7.81726138e-06, 7.83158150e-06, 7.84966491e-06, 7.87250088e-06, 7.90133995e-06, 7.93779472e-06, 7.98391297e-06, 8.04234324e-06, 8.11653506e-06, 8.21081654e-06, 8.33098462e-06, 8.48452507e-06, 8.68131760e-06, 8.93449488e-06, 9.26155857e-06, 9.68601199e-06, 1.02394230e-05, 1.09645093e-05, 1.19188458e-05, 1.31799476e-05, 1.48508238e-05, 1.70673069e-05, 2.00050633e-05, 2.38865528e-05, 2.89881205e-05, 3.56452297e-05, 4.42611008e-05, 5.53199836e-05, 6.94113216e-05, 8.72674206e-05, 1.09813898e-04, 1.38229479e-04, 1.74013502e-04, 2.19064777e-04, 2.75778577e-04, 3.47174333e-04, 4.37047264e-04, 5.50182414e-04, 6.92595476e-04, 8.71852672e-04, 1.09748617e-03, 1.38147592e-03, 1.73889189e-03, 2.18868899e-03, 2.75468373e-03, 3.46682367e-03, 4.36269213e-03, 5.48948376e-03, 6.90640164e-03, 8.68758023e-03, 1.09258330e-02, 1.37371354e-02, 1.72660472e-02, 2.16924258e-02, 2.72392920e-02, 3.41818769e-02, 4.28584083e-02, 5.36813507e-02, 6.71499243e-02, 8.38598668e-02, 1.04514199e-01, 1.29922698e-01, 1.60992539e-01, 1.98702265e-01, 2.44039461e-01, 2.97902688e-01, 3.60946728e-01, 4.33365771e-01, 5.14614469e-01, 6.03116556e-01, 6.96013139e-01, 7.89112199e-01, 8.77163683e-01, 9.54633862e-01, 1.01688584e+00, 1.06142703e+00, 1.08863523e+00, 1.10141305e+00},
 { 6.18760627e-06, 6.19327703e-06, 6.20044017e-06, 6.20947150e-06, 6.22084639e-06, 6.23521057e-06, 6.25334985e-06, 6.27625758e-06, 6.30521468e-06, 6.34184775e-06, 6.38826064e-06, 6.44719338e-06, 6.52208393e-06, 6.61753699e-06, 6.73949869e-06, 6.89581680e-06, 7.09692299e-06, 7.35671936e-06, 7.69387530e-06, 8.13346609e-06, 8.70942379e-06, 9.46748187e-06, 1.04692131e-05, 1.17964408e-05, 1.35570613e-05, 1.58906124e-05, 1.89738021e-05, 2.30261418e-05, 2.83141041e-05, 3.51579854e-05, 4.39424505e-05, 5.51357288e-05, 6.93195400e-05, 8.72291727e-05, 1.09800993e-04, 1.38226081e-04, 1.74012893e-04, 2.19064345e-04, 2.75779306e-04, 3.47173134e-04, 4.37047855e-04, 5.50183687e-04, 6.92593523e-04, 8.71853516e-04, 1.09748678e-03, 1.38147507e-03, 1.73889262e-03, 2.18868578e-03, 2.75468742e-03, 3.46682176e-03, 4.36268878e-03, 5.48949222e-03, 6.90639909e-03, 8.68757605e-03, 1.09258441e-02, 1.37371325e-02, 1.72660420e-02, 2.16924532e-02, 2.72392728e-02, 3.41818699e-02, 4.28583409e-02, 5.36814954e-02, 6.71496884e-02, 8.38599813e-02, 1.04514442e-01, 1.29922322e-01, 1.60992694e-01, 1.98702367e-01, 2.44039303e-01, 2.97902437e-01, 3.60947430e-01, 4.33365527e-01, 5.14614715e-01, 6.03115386e-01, 6.96014103e-01, 7.89111740e-01, 8.77162962e-01, 9.54634680e-01, 1.01688493e+00, 1.06142911e+00, 1.08863466e+00},
 { 4.91499038e-06, 4.91949484e-06, 4.92518473e-06, 4.93235858e-06, 4.94139398e-06, 4.95280387e-06, 4.96721243e-06, 4.98540871e-06, 5.00841017e-06, 5.03750890e-06, 5.07437600e-06, 5.12118800e-06, 5.18067575e-06, 5.25649690e-06, 5.35337464e-06, 5.47754269e-06, 5.63728723e-06, 5.84365110e-06, 6.11146396e-06, 6.46064385e-06, 6.91814405e-06, 7.52029202e-06, 8.31599690e-06, 9.37025358e-06, 1.07687676e-05, 1.26223784e-05, 1.50714512e-05, 1.82903520e-05, 2.24907502e-05, 2.79270709e-05, 3.49048714e-05, 4.37960909e-05, 5.50628236e-05, 6.92891584e-05, 8.72189224e-05, 1.09798295e-04, 1.38225597e-04, 1.74012550e-04, 2.19064924e-04, 2.75778353e-04, 3.47173604e-04, 4.37048866e-04, 5.50182135e-04, 6.92594194e-04, 8.71854003e-04, 1.09748611e-03, 1.38147565e-03, 1.73889007e-03, 2.18868870e-03, 2.75468590e-03, 3.46681910e-03, 4.36269551e-03, 5.48949020e-03, 6.90639577e-03, 8.68758490e-03, 1.09258418e-02, 1.37371283e-02, 1.72660638e-02, 2.16924379e-02, 2.72392672e-02, 3.41818163e-02, 4.28584565e-02, 5.36813068e-02, 6.71497801e-02, 8.38601764e-02, 1.04514140e-01, 1.29922448e-01, 1.60992777e-01, 1.98702239e-01, 2.44039098e-01, 2.97903017e-01, 3.60947226e-01, 4.33365734e-01, 5.14613716e-01, 6.03116221e-01, 6.96013698e-01, 7.89111092e-01, 8.77163714e-01, 9.54633824e-01, 1.01688692e+00, 1.06142856e+00},
 { 3.90411565e-06, 3.90769367e-06, 3.91221331e-06, 3.91791171e-06, 3.92508879e-06, 3.93415200e-06, 3.94559713e-06, 3.96005096e-06, 3.97832169e-06, 4.00143565e-06, 4.03072026e-06, 4.06790439e-06, 4.11515724e-06, 4.17538417e-06, 4.25233698e-06, 4.35096726e-06, 4.47785699e-06, 4.64177782e-06, 4.85450937e-06, 5.13187315e-06, 5.49527893e-06, 5.97358272e-06, 6.60563453e-06, 7.44306180e-06, 8.55394310e-06, 1.00263218e-05, 1.19716946e-05, 1.45285666e-05, 1.78650744e-05, 2.21833180e-05, 2.77260147e-05, 3.47886134e-05, 4.37381800e-05, 5.50386905e-05, 6.92810162e-05, 8.72167787e-05, 1.09797910e-04, 1.38225325e-04, 1.74013010e-04, 2.19064167e-04, 2.75778726e-04, 3.47174407e-04, 4.37047633e-04, 5.50182668e-04, 6.92594580e-04, 8.71853467e-04, 1.09748657e-03, 1.38147362e-03, 1.73889239e-03, 2.18868750e-03, 2.75468379e-03, 3.46682444e-03, 4.36269390e-03, 5.48948756e-03, 6.90640281e-03, 8.68758307e-03, 1.09258385e-02, 1.37371457e-02, 1.72660516e-02, 2.16924335e-02, 2.72392244e-02, 3.41819084e-02, 4.28583059e-02, 5.36813801e-02, 6.71499363e-02, 8.38599341e-02, 1.04514241e-01, 1.29922515e-01, 1.60992673e-01, 1.98702072e-01, 2.44039573e-01, 2.97902849e-01, 3.60947399e-01, 4.33364893e-01, 5.14614429e-01, 6.03115870e-01, 6.96013126e-01, 7.89111768e-01, 8.77162927e-01, 9.54635689e-01, 1.01688639e+00},
 { 3.10114930e-06, 3.10399142e-06, 3.10758151e-06, 3.11210790e-06, 3.11780887e-06, 3.12500804e-06, 3.13409924e-06, 3.14558033e-06, 3.16009330e-06, 3.17845338e-06, 3.20171499e-06, 3.23125142e-06, 3.26878572e-06, 3.31662571e-06, 3.37775154e-06, 3.45609643e-06, 3.55688860e-06, 3.68709565e-06, 3.85607448e-06, 4.07639257e-06, 4.36505633e-06, 4.74498695e-06, 5.24704415e-06, 5.91223717e-06, 6.79464291e-06, 7.96419697e-06, 9.50946480e-06, 1.15404655e-05, 1.41907560e-05, 1.76208719e-05, 2.20236129e-05, 2.76336674e-05, 3.47426129e-05, 4.37190102e-05, 5.50322229e-05, 6.92793134e-05, 8.72164734e-05, 1.09797694e-04, 1.38225690e-04, 1.74012408e-04, 2.19064463e-04, 2.75779364e-04, 3.47173428e-04, 4.37048056e-04, 5.50182975e-04, 6.92594155e-04, 8.71853833e-04, 1.09748496e-03, 1.38147547e-03, 1.73889143e-03, 2.18868582e-03, 2.75468803e-03, 3.46682317e-03, 4.36269180e-03, 5.48949315e-03, 6.90640136e-03, 8.68758043e-03, 1.09258523e-02, 1.37371360e-02, 1.72660481e-02, 2.16923994e-02, 2.72392979e-02, 3.41817883e-02, 4.28583644e-02, 5.36815050e-02, 6.71497423e-02, 8.38600150e-02, 1.04514295e-01, 1.29922431e-01, 1.60992538e-01, 1.98702458e-01, 2.44039435e-01, 2.97902991e-01, 3.60946699e-01, 4.33365493e-01, 5.14614130e-01, 6.03115374e-01, 6.96013722e-01, 7.89111060e-01, 8.77164641e-01, 9.54635195e-01},
 { 2.46333045e-06, 2.46558803e-06, 2.46843974e-06, 2.47203519e-06, 2.47656363e-06, 2.48228213e-06, 2.48950354e-06, 2.49862330e-06, 2.51015136e-06, 2.52473531e-06, 2.54321267e-06, 2.56667430e-06, 2.59648887e-06, 2.63448955e-06, 2.68304356e-06, 2.74527515e-06, 2.82533727e-06, 2.92876448e-06, 3.06298923e-06, 3.23799424e-06, 3.46728820e-06, 3.76907808e-06, 4.16787667e-06, 4.69625883e-06, 5.39717948e-06, 6.32619060e-06, 7.55364254e-06, 9.16692698e-06, 1.12721327e-05, 1.39967788e-05, 1.74940133e-05, 2.19502587e-05, 2.75971278e-05, 3.47273858e-05, 4.37138728e-05, 5.50308703e-05, 6.92790709e-05, 8.72163013e-05, 1.09797984e-04, 1.38225213e-04, 1.74012644e-04, 2.19064970e-04, 2.75778586e-04, 3.47173764e-04, 4.37048300e-04, 5.50182637e-04, 6.92594445e-04, 8.71852552e-04, 1.09748642e-03, 1.38147471e-03, 1.73889010e-03, 2.18868919e-03, 2.75468702e-03, 3.46682150e-03, 4.36269625e-03, 5.48949200e-03, 6.90639925e-03, 8.68759142e-03, 1.09258446e-02, 1.37371332e-02, 1.72660210e-02, 2.16924579e-02, 2.72392022e-02, 3.41818350e-02, 4.28584641e-02, 5.36813499e-02, 6.71498070e-02, 8.38600583e-02, 1.04514227e-01, 1.29922321e-01, 1.60992851e-01, 1.98702346e-01, 2.44039552e-01, 2.97902413e-01, 3.60947198e-01, 4.33365241e-01, 5.14613706e-01, 6.03115891e-01, 6.96013098e-01, 7.89112601e-01, 8.77164187e-01},
 { 1.95669293e-06, 1.95848619e-06, 1.96075139e-06, 1.96360735e-06, 1.96720442e-06, 1.97174679e-06, 1.97748296e-06, 1.98472705e-06, 1.99388412e-06, 2.00546856e-06, 2.02014566e-06, 2.03878191e-06, 2.06246448e-06, 2.09264950e-06, 2.13121734e-06, 2.18064968e-06, 2.24424531e-06, 2.32640051e-06, 2.43301908e-06, 2.57203058e-06, 2.75416536e-06, 2.99388575e-06, 3.31066297e-06, 3.73037219e-06, 4.28713380e-06, 5.02507439e-06, 6.00007542e-06, 7.28155485e-06, 8.95378246e-06, 1.11180509e-05, 1.38960113e-05, 1.74357458e-05, 2.19212342e-05, 2.75850324e-05, 3.47233050e-05, 4.37127984e-05, 5.50306777e-05, 6.92789342e-05, 8.72165318e-05, 1.09797605e-04, 1.38225399e-04, 1.74013046e-04, 2.19064352e-04, 2.75778853e-04, 3.47173957e-04, 4.37048032e-04, 5.50182868e-04, 6.92593428e-04, 8.71853718e-04, 1.09748582e-03, 1.38147365e-03, 1.73889278e-03, 2.18868839e-03, 2.75468569e-03, 3.46682503e-03, 4.36269533e-03, 5.48949033e-03, 6.90640800e-03, 8.68758529e-03, 1.09258424e-02, 1.37371116e-02, 1.72660676e-02, 2.16923817e-02, 2.72392394e-02, 3.41819145e-02, 4.28583403e-02, 5.36814017e-02, 6.71498417e-02, 8.38600039e-02, 1.04514139e-01, 1.29922574e-01, 1.60992760e-01, 1.98702441e-01, 2.44039078e-01, 2.97902826e-01, 3.60946988e-01, 4.33364885e-01, 5.14614147e-01, 6.03115350e-01, 6.96014457e-01, 7.89112193e-01},
 { 1.55425645e-06, 1.55568088e-06, 1.55748019e-06, 1.55974877e-06, 1.56260602e-06, 1.56621416e-06, 1.57077056e-06, 1.57652474e-06, 1.58379847e-06, 1.59300032e-06, 1.60465876e-06, 1.61946206e-06, 1.63827380e-06, 1.66225063e-06, 1.69288616e-06, 1.73215168e-06, 1.78266751e-06, 1.84792573e-06, 1.93261591e-06, 2.04303672e-06, 2.18771159e-06, 2.37812837e-06, 2.62975361e-06, 2.96314072e-06, 3.40539252e-06, 3.99156010e-06, 4.76603176e-06, 5.78394835e-06, 7.11224800e-06, 8.83139078e-06, 1.10380083e-05, 1.38497277e-05, 1.74126908e-05, 2.19116264e-05, 2.75817909e-05, 3.47224515e-05, 4.37126454e-05, 5.50305690e-05, 6.92791173e-05, 8.72162305e-05, 1.09797753e-04, 1.38225719e-04, 1.74012556e-04, 2.19064564e-04, 2.75779007e-04, 3.47173744e-04, 4.37048215e-04, 5.50182059e-04, 6.92594354e-04, 8.71853238e-04, 1.09748498e-03, 1.38147578e-03, 1.73889214e-03, 2.18868733e-03, 2.75468850e-03, 3.46682430e-03, 4.36269400e-03, 5.48949728e-03, 6.90640312e-03, 8.68758353e-03, 1.09258252e-02, 1.37371487e-02, 1.72660069e-02, 2.16924113e-02, 2.72393028e-02, 3.41818157e-02, 4.28583816e-02, 5.36814294e-02, 6.71497982e-02, 8.38599335e-02, 1.04514343e-01, 1.29922501e-01, 1.60992837e-01, 1.98702055e-01, 2.44039416e-01, 2.97902652e-01, 3.60946692e-01, 4.33365256e-01, 5.14613686e-01, 6.03116528e-01, 6.96014097e-01},
 { 1.23458978e-06, 1.23572125e-06, 1.23715049e-06, 1.23895249e-06, 1.24122209e-06, 1.24408813e-06, 1.24770741e-06, 1.25227812e-06, 1.25805585e-06, 1.26536514e-06, 1.27462577e-06, 1.28638446e-06, 1.30132716e-06, 1.32037263e-06, 1.34470731e-06, 1.37589703e-06, 1.41602319e-06, 1.46785966e-06, 1.53513148e-06, 1.62284188e-06, 1.73776127e-06, 1.88901475e-06, 2.08888788e-06, 2.35370682e-06, 2.70500013e-06, 3.17060992e-06, 3.78579514e-06, 4.59435584e-06, 5.64946305e-06, 7.01502876e-06, 8.76781066e-06, 1.10012439e-05, 1.38314144e-05, 1.74050591e-05, 2.19090516e-05, 2.75811130e-05, 3.47223300e-05, 4.37125591e-05, 5.50307145e-05, 6.92788780e-05, 8.72163485e-05, 1.09798007e-04, 1.38225329e-04, 1.74012724e-04, 2.19064686e-04, 2.75778838e-04, 3.47173890e-04, 4.37047573e-04, 5.50182795e-04, 6.92593972e-04, 8.71852569e-04, 1.09748667e-03, 1.38147527e-03, 1.73889130e-03, 2.18868956e-03, 2.75468792e-03, 3.46682325e-03, 4.36269952e-03, 5.48949340e-03, 6.90640172e-03, 8.68756988e-03, 1.09258546e-02, 1.37371004e-02, 1.72660305e-02, 2.16924618e-02, 2.72392240e-02, 3.41818487e-02, 4.28584038e-02, 5.36813946e-02, 6.71497418e-02, 8.38600966e-02, 1.04514284e-01, 1.29922563e-01, 1.60992525e-01, 1.98702331e-01, 2.44039274e-01, 2.97902407e-01, 3.60947001e-01, 4.33364867e-01, 5.14614691e-01, 6.03116216e-01},
 { 9.80669522e-07, 9.81568281e-07, 9.82703568e-07, 9.84134944e-07, 9.85937751e-07, 9.88214331e-07, 9.91089227e-07, 9.94719874e-07, 9.99309287e-07, 1.00511527e-06, 1.01247125e-06, 1.02181150e-06, 1.03368092e-06, 1.04880928e-06, 1.06813901e-06, 1.09291389e-06, 1.12478724e-06, 1.16596242e-06, 1.21939834e-06, 1.28906921e-06, 1.38035295e-06, 1.50049791e-06, 1.65926284e-06, 1.86961609e-06, 2.14865842e-06, 2.51850562e-06, 3.00716494e-06, 3.64942805e-06, 4.48753031e-06, 5.57223901e-06, 6.96452523e-06, 8.73860762e-06, 1.09866972e-05, 1.38253523e-05, 1.74030138e-05, 2.19085131e-05, 2.75810164e-05, 3.47222615e-05, 4.37126747e-05, 5.50305244e-05, 6.92789717e-05, 8.72165502e-05, 1.09797697e-04, 1.38225463e-04, 1.74012821e-04, 2.19064552e-04, 2.75778953e-04, 3.47173380e-04, 4.37048157e-04, 5.50182492e-04, 6.92593441e-04, 8.71853912e-04, 1.09748626e-03, 1.38147460e-03, 1.73889307e-03, 2.18868910e-03, 2.75468708e-03, 3.46682764e-03, 4.36269645e-03, 5.48949228e-03, 6.90639087e-03, 8.68759330e-03, 1.09258163e-02, 1.37371192e-02, 1.72660706e-02, 2.16923991e-02, 2.72392503e-02, 3.41818664e-02, 4.28583760e-02, 5.36813495e-02, 6.71498724e-02, 8.38600493e-02, 1.04514334e-01, 1.29922311e-01, 1.60992748e-01, 1.98702215e-01, 2.44039073e-01, 2.97902663e-01, 3.60946677e-01, 4.33365714e-01, 5.14614425e-01},
 { 7.78973490e-07, 7.79687401e-07, 7.80589191e-07, 7.81726174e-07, 7.83158194e-07, 7.84966547e-07, 7.87250158e-07, 7.90134084e-07, 7.93779585e-07, 7.98391440e-07, 8.04234505e-07, 8.11653735e-07, 8.21081946e-07, 8.33098836e-07, 8.48452985e-07, 8.68132377e-07, 8.93450286e-07, 9.26156900e-07, 9.68602572e-07, 1.02394412e-06, 1.09645339e-06, 1.19188795e-06, 1.31799946e-06, 1.48508904e-06, 1.70674032e-06, 2.00052054e-06, 2.38867664e-06, 2.89884468e-06, 3.56457348e-06, 4.42618905e-06, 5.53212261e-06, 6.94132841e-06, 8.72705269e-06, 1.09818819e-05, 1.38237277e-05, 1.74025861e-05, 2.19084364e-05, 2.75809620e-05, 3.47223533e-05, 4.37125237e-05, 5.50305988e-05, 6.92791319e-05, 8.72163043e-05, 1.09797804e-04, 1.38225540e-04, 1.74012714e-04, 2.19064644e-04, 2.75778548e-04, 3.47173844e-04, 4.37047917e-04, 5.50182070e-04, 6.92594508e-04, 8.71853591e-04, 1.09748574e-03, 1.38147601e-03, 1.73889271e-03, 2.18868844e-03, 2.75469057e-03, 3.46682519e-03, 4.36269556e-03, 5.48948366e-03, 6.90640949e-03, 8.68756278e-03, 1.09258312e-02, 1.37371511e-02, 1.72660207e-02, 2.16924200e-02, 2.72392644e-02, 3.41818442e-02, 4.28583400e-02, 5.36814539e-02, 6.71498345e-02, 8.38600894e-02, 1.04514131e-01, 1.29922491e-01, 1.60992654e-01, 1.98702052e-01, 2.44039283e-01, 2.97902395e-01, 3.60947382e-01, 4.33365490e-01},
 { 6.18760638e-07, 6.19327717e-07, 6.20044035e-07, 6.20947172e-07, 6.22084667e-07, 6.23521092e-07, 6.25335030e-07, 6.27625814e-07, 6.30521538e-07, 6.34184865e-07, 6.38826178e-07, 6.44719483e-07, 6.52208578e-07, 6.61753934e-07, 6.73950171e-07, 6.89582069e-07, 7.09692803e-07, 7.35672594e-07, 7.69388396e-07, 8.13347762e-07, 8.70943933e-07, 9.46750313e-07, 1.04692427e-06, 1.17964827e-06, 1.35571220e-06, 1.58907020e-06, 1.89739368e-06, 2.30263477e-06, 2.83144228e-06, 3.51584837e-06, 4.39432344e-06, 5.51369671e-06, 6.93215000e-06, 8.72322777e-06, 1.09805914e-05, 1.38233879e-05, 1.74025252e-05, 2.19083932e-05, 2.75810349e-05, 3.47222333e-05, 4.37125828e-05, 5.50307261e-05, 6.92789365e-05, 8.72163887e-05, 1.09797865e-04, 1.38225455e-04, 1.74012787e-04, 2.19064322e-04, 2.75778917e-04, 3.47173653e-04, 4.37047581e-04, 5.50182918e-04, 6.92594253e-04, 8.71853172e-04, 1.09748685e-03, 1.38147572e-03, 1.73889218e-03, 2.18869121e-03, 2.75468862e-03, 3.46682449e-03, 4.36268871e-03, 5.48949846e-03, 6.90638522e-03, 8.68757464e-03, 1.09258566e-02, 1.37371114e-02, 1.72660374e-02, 2.16924312e-02, 2.72392467e-02, 3.41818155e-02, 4.28584233e-02, 5.36814236e-02, 6.71498666e-02, 8.38599267e-02, 1.04514275e-01, 1.29922415e-01, 1.60992522e-01, 1.98702222e-01, 2.44039064e-01, 2.97902977e-01, 3.60947196e-01},
 { 4.91499045e-07, 4.91949493e-07, 4.92518484e-07, 4.93235871e-07, 4.94139416e-07, 4.95280409e-07, 4.96721271e-07, 4.98540906e-07, 5.00841062e-07, 5.03750946e-07, 5.07437672e-07, 5.12118891e-07, 5.18067692e-07, 5.25649839e-07, 5.35337655e-07, 5.47754515e-07, 5.63729041e-07, 5.84365525e-07, 6.11146942e-07, 6.46065113e-07, 6.91815385e-07, 7.52030544e-07, 8.31601558e-07, 9.37028008e-07, 1.07688059e-06, 1.26224349e-06, 1.50715362e-06, 1.82904819e-06, 2.24909513e-06, 2.79273853e-06, 3.49053660e-06, 4.37968722e-06, 5.50640603e-06, 6.92911175e-06, 8.72220270e-06, 1.09803215e-05, 1.38233396e-05, 1.74024908e-05, 2.19084511e-05, 2.75809396e-05, 3.47222803e-05, 4.37126839e-05, 5.50305709e-05, 6.92790036e-05, 8.72164374e-05, 1.09797798e-04, 1.38225513e-04, 1.74012532e-04, 2.19064615e-04, 2.75778765e-04, 3.47173386e-04, 4.37048255e-04, 5.50182715e-04, 6.92593920e-04, 8.71854060e-04, 1.09748662e-03, 1.38147530e-03, 1.73889438e-03, 2.18868966e-03, 2.75468806e-03, 3.46681904e-03, 4.36270047e-03, 5.48947917e-03, 6.90639465e-03, 8.68759486e-03, 1.09258250e-02, 1.37371247e-02, 1.72660463e-02, 2.16924172e-02, 2.72392238e-02, 3.41818820e-02, 4.28583992e-02, 5.36814493e-02, 6.71497363e-02, 8.38600428e-02, 1.04514215e-01, 1.29922308e-01, 1.60992659e-01, 1.98702044e-01, 2.44039540e-01, 2.97902823e-01},
 { 3.90411569e-07, 3.90769372e-07, 3.91221338e-07, 3.91791179e-07, 3.92508890e-07, 3.93415214e-07, 3.94559731e-07, 3.96005118e-07, 3.97832197e-07, 4.00143601e-07, 4.03072072e-07, 4.06790497e-07, 4.11515797e-07, 4.17538511e-07, 4.25233818e-07, 4.35096881e-07, 4.47785900e-07, 4.64178044e-07, 4.85451281e-07, 5.13187774e-07, 5.49528511e-07, 5.97359118e-07, 6.60564631e-07, 7.44307851e-07, 8.55396729e-07, 1.00263575e-06, 1.19717483e-06, 1.45286485e-06, 1.78652013e-06, 2.21835164e-06, 2.77263268e-06, 3.47891064e-06, 4.37389603e-06, 5.50399266e-06, 6.92829751e-06, 8.72198832e-06, 1.09802831e-05, 1.38233123e-05, 1.74025369e-05, 2.19083754e-05, 2.75809769e-05, 3.47223606e-05, 4.37125606e-05, 5.50306242e-05, 6.92790423e-05, 8.72163838e-05, 1.09797844e-04, 1.38225310e-04, 1.74012764e-04, 2.19064494e-04, 2.75778553e-04, 3.47173921e-04, 4.37048094e-04, 5.50182451e-04, 6.92594626e-04, 8.71853877e-04, 1.09748629e-03, 1.38147705e-03, 1.73889315e-03, 2.18868922e-03, 2.75468374e-03, 3.46682839e-03, 4.36268514e-03, 5.48948667e-03, 6.90641072e-03, 8.68756975e-03, 1.09258356e-02, 1.37371318e-02, 1.72660351e-02, 2.16923989e-02, 2.72392768e-02, 3.41818627e-02, 4.28584197e-02, 5.36813451e-02, 6.71498293e-02, 8.38599940e-02, 1.04514129e-01, 1.29922420e-01, 1.60992515e-01, 1.98702432e-01, 2.44039414e-01},
 { 3.10114933e-07, 3.10399146e-07, 3.10758155e-07, 3.11210796e-07, 3.11780894e-07, 3.12500812e-07, 3.13409935e-07, 3.14558047e-07, 3.16009348e-07, 3.17845361e-07, 3.20171528e-07, 3.23125178e-07, 3.26878618e-07, 3.31662630e-07, 3.37775230e-07, 3.45609740e-07, 3.55688987e-07, 3.68709731e-07, 3.85607666e-07, 4.07639547e-07, 4.36506024e-07, 4.74499229e-07, 5.24705159e-07, 5.91224772e-07, 6.79465817e-07, 7.96421948e-07, 9.50949865e-07, 1.15405172e-06, 1.41908361e-06, 1.76209970e-06, 2.20238099e-06, 2.76339784e-06, 3.47431053e-06, 4.37197902e-06, 5.50334589e-06, 6.92812722e-06, 8.72195779e-06, 1.09802614e-05, 1.38233488e-05, 1.74024767e-05, 2.19084051e-05, 2.75810407e-05, 3.47222627e-05, 4.37126029e-05, 5.50306549e-05, 6.92789997e-05, 8.72164204e-05, 1.09797682e-04, 1.38225495e-04, 1.74012668e-04, 2.19064326e-04, 2.75778978e-04, 3.47173794e-04, 4.37047884e-04, 5.50183011e-04, 6.92594480e-04, 8.71853612e-04, 1.09748768e-03, 1.38147607e-03, 1.73889280e-03, 2.18868578e-03, 2.75469116e-03, 3.46681620e-03, 4.36269110e-03, 5.48949944e-03, 6.90639076e-03, 8.68757813e-03, 1.09258412e-02, 1.37371229e-02, 1.72660206e-02, 2.16924411e-02, 2.72392614e-02, 3.41818790e-02, 4.28583365e-02, 5.36814195e-02, 6.71497902e-02, 8.38599251e-02, 1.04514218e-01, 1.29922303e-01, 1.60992830e-01, 1.98702329e-01}};

double lnC1(double T, double nu)
{
 double log_u=log10(k_u*nu/T);
 double log_g2=log10(k_g2/T);

 double idx_u=(log_u-s_u)/d;
 double idx_g2=(log_g2-s_g2)/d;

 double G=InterpolateBilinear((double*)g_arr, idx_u, idx_g2, N_u, N_g2, dNaN);

 return G*M_PI/sqrt(3.0);
}