from __future__ import annotations

from typing import Any, ClassVar, Collection, Iterator, Self, overload

from pyrx import Ax as PyAx
from pyrx import Db as PyDb
from pyrx import Ge as PyGe
from pyrx.doc_utils.boost_meta import _BoostPythonEnum

ac0degrees: AcPlotRotation  # 0
ac100_1: AcPlotScale  # 32
ac10_1: AcPlotScale  # 31
ac180degrees: AcPlotRotation  # 2
ac1_1: AcPlotScale  # 16
ac1_10: AcPlotScale  # 21
ac1_100: AcPlotScale  # 27
ac1_128in_1f: AcPlotScale  # 1
ac1_16: AcPlotScale  # 22
ac1_16in_1ft: AcPlotScale  # 4
ac1_2: AcPlotScale  # 17
ac1_20: AcPlotScale  # 23
ac1_2in_1ft: AcPlotScale  # 10
ac1_30: AcPlotScale  # 24
ac1_32in_1ft: AcPlotScale  # 3
ac1_4: AcPlotScale  # 18
ac1_40: AcPlotScale  # 25
ac1_4in_1ft: AcPlotScale  # 8
ac1_5: AcPlotScale  # 19
ac1_50: AcPlotScale  # 26
ac1_64in_1ft: AcPlotScale  # 2
ac1_8: AcPlotScale  # 20
ac1_8in_1ft: AcPlotScale  # 6
ac1ft_1ft: AcPlotScale  # 15
ac1in_1ft: AcPlotScale  # 12
ac2000_Template: AcSaveAsType  # 14
ac2000_dwg: AcSaveAsType  # 12
ac2000_dxf: AcSaveAsType  # 13
ac2004_Template: AcSaveAsType  # 26
ac2004_dwg: AcSaveAsType  # 24
ac2004_dxf: AcSaveAsType  # 25
ac2007_Template: AcSaveAsType  # 38
ac2007_dwg: AcSaveAsType  # 36
ac2007_dxf: AcSaveAsType  # 37
ac2010_Template: AcSaveAsType  # 50
ac2010_dwg: AcSaveAsType  # 48
ac2010_dxf: AcSaveAsType  # 49
ac2013_Template: AcSaveAsType  # 62
ac2013_dwg: AcSaveAsType  # 60
ac2013_dxf: AcSaveAsType  # 61
ac2018_Template: AcSaveAsType  # 66
ac2018_dwg: AcSaveAsType  # 64
ac2018_dxf: AcSaveAsType  # 65
ac270degrees: AcPlotRotation  # 3
ac2_1: AcPlotScale  # 28
ac3_16in_1ft: AcPlotScale  # 7
ac3_32in_1ft: AcPlotScale  # 5
ac3_4in_1ft: AcPlotScale  # 11
ac3_8in_1ft: AcPlotScale  # 9
ac3in_1ft: AcPlotScale  # 13
ac4_1: AcPlotScale  # 29
ac6in_1ft: AcPlotScale  # 14
ac8_1: AcPlotScale  # 30
ac90degrees: AcPlotRotation  # 1
acAbove: AcDimVerticalJustification  # 1
acActiveViewport: AcRegenType  # 0
acAlignPntAcquisitionAutomatic: AcAlignmentPointAcquisition  # 0
acAlignPntAcquisitionShiftToAcquire: AcAlignmentPointAcquisition  # 1
acAlignmentAligned: AcAlignment  # 3
acAlignmentBottomCenter: AcAlignment  # 13
acAlignmentBottomLeft: AcAlignment  # 12
acAlignmentBottomRight: AcAlignment  # 14
acAlignmentCenter: AcAlignment  # 1
acAlignmentFit: AcAlignment  # 5
acAlignmentLeft: AcAlignment  # 0
acAlignmentMiddle: AcAlignment  # 4
acAlignmentMiddleCenter: AcAlignment  # 10
acAlignmentMiddleLeft: AcAlignment  # 9
acAlignmentMiddleRight: AcAlignment  # 11
acAlignmentProperty: AcCellProperty  # 32
acAlignmentRight: AcAlignment  # 2
acAlignmentTopCenter: AcAlignment  # 7
acAlignmentTopLeft: AcAlignment  # 6
acAlignmentTopRight: AcAlignment  # 8
acAllCellProperties: AcCellProperty  # 524287
acAllViewports: AcRegenType  # 1
acAlwaysRightReadingAngle: AcTextAngleType  # 2
acAngular: AcDynamicBlockReferencePropertyUnitsType  # 1
acAny: AcBlockScaling  # 0
acArchitectural: AcUnits  # 4
acArea: AcDynamicBlockReferencePropertyUnitsType  # 3
acArrowArchTick: AcDimArrowheadType  # 4
acArrowBoxBlank: AcDimArrowheadType  # 14
acArrowBoxFilled: AcDimArrowheadType  # 15
acArrowClosed: AcDimArrowheadType  # 2
acArrowClosedBlank: AcDimArrowheadType  # 1
acArrowDatumBlank: AcDimArrowheadType  # 16
acArrowDatumFilled: AcDimArrowheadType  # 17
acArrowDefault: AcDimArrowheadType  # 0
acArrowDot: AcDimArrowheadType  # 3
acArrowDotBlank: AcDimArrowheadType  # 12
acArrowDotSmall: AcDimArrowheadType  # 11
acArrowIntegral: AcDimArrowheadType  # 18
acArrowNone: AcDimArrowheadType  # 19
acArrowOblique: AcDimArrowheadType  # 5
acArrowOpen: AcDimArrowheadType  # 6
acArrowOpen30: AcDimArrowheadType  # 10
acArrowOpen90: AcDimArrowheadType  # 9
acArrowOrigin: AcDimArrowheadType  # 7
acArrowOrigin2: AcDimArrowheadType  # 8
acArrowSmall: AcDimArrowheadType  # 13
acArrowUserDefined: AcDimArrowheadType  # 20
acArrowsOnly: AcDimFit  # 1
acAttachmentAllLine: AcTextAttachmentType  # 8
acAttachmentBottomLine: AcTextAttachmentType  # 7
acAttachmentBottomOfBottom: AcTextAttachmentType  # 6
acAttachmentBottomOfTop: AcTextAttachmentType  # 2
acAttachmentBottomOfTopLine: AcTextAttachmentType  # 3
acAttachmentCenter: AcVerticalTextAttachmentType  # 0
acAttachmentHorizontal: AcTextAttachmentDirection  # 0
acAttachmentLinedCenter: AcVerticalTextAttachmentType  # 1
acAttachmentMiddle: AcTextAttachmentType  # 4
acAttachmentMiddleOfBottom: AcTextAttachmentType  # 5
acAttachmentMiddleOfTop: AcTextAttachmentType  # 1
acAttachmentPointBottomCenter: AcAttachmentPoint  # 8
acAttachmentPointBottomLeft: AcAttachmentPoint  # 7
acAttachmentPointBottomRight: AcAttachmentPoint  # 9
acAttachmentPointMiddleCenter: AcAttachmentPoint  # 5
acAttachmentPointMiddleLeft: AcAttachmentPoint  # 4
acAttachmentPointMiddleRight: AcAttachmentPoint  # 6
acAttachmentPointTopCenter: AcAttachmentPoint  # 2
acAttachmentPointTopLeft: AcAttachmentPoint  # 1
acAttachmentPointTopRight: AcAttachmentPoint  # 3
acAttachmentTopOfTop: AcTextAttachmentType  # 0
acAttachmentVertical: AcTextAttachmentDirection  # 1
acAttributeModeConstant: AcAttributeMode  # 2
acAttributeModeInvisible: AcAttributeMode  # 1
acAttributeModeLockPosition: AcAttributeMode  # 16
acAttributeModeMultipleLine: AcAttributeMode  # 32
acAttributeModeNormal: AcAttributeMode  # 0
acAttributeModePreset: AcAttributeMode  # 8
acAttributeModeVerify: AcAttributeMode  # 4
acAutoScale: AcCellProperty  # 32768
acBackgroundColor: AcCellProperty  # 128
acBaseMenuGroup: AcMenuGroupType  # 0
acBestFit: AcDimFit  # 3
acBezierSurfaceMesh: AcPolymeshType  # 8
acBitProperties: AcCellProperty  # 245760
acBlockBox: AcPredefBlockType  # 3
acBlockCell: AcCellType  # 2
acBlockCircle: AcPredefBlockType  # 2
acBlockContent: AcMLeaderContentType  # 1
acBlockHexagon: AcPredefBlockType  # 4
acBlockImperial: AcPredefBlockType  # 0
acBlockSlot: AcPredefBlockType  # 1
acBlockTriangle: AcPredefBlockType  # 5
acBlockUserDefined: AcPredefBlockType  # 6
acBlue: AcColor  # 5
acBottom: AcMLineJustification  # 2
acBottomCenter: AcCellAlignment  # 8
acBottomLeft: AcCellAlignment  # 7
acBottomMask: AcCellEdgeMask  # 4
acBottomRight: AcCellAlignment  # 9
acBottomToTop: AcDrawingDirection  # 4
acBuffer: AcValueDataType  # 128
acByBlock: AcColor  # 0
acByLayer: AcColor  # 256
acByStyle: AcDrawingDirection  # 5
acCellContentLayoutFlow: AcCellContentLayout  # 1
acCellContentLayoutStackedHorizontal: AcCellContentLayout  # 2
acCellContentLayoutStackedVertical: AcCellContentLayout  # 4
acCellContentTypeBlock: AcCellContentType  # 4
acCellContentTypeField: AcCellContentType  # 2
acCellContentTypeUnknown: AcCellContentType  # 0
acCellContentTypeValue: AcCellContentType  # 1
acCellMarginBottom: AcCellMargin  # 4
acCellMarginHorzSpacing: AcCellMargin  # 16
acCellMarginLeft: AcCellMargin  # 2
acCellMarginRight: AcCellMargin  # 8
acCellMarginTop: AcCellMargin  # 1
acCellMarginVertSpacing: AcCellMargin  # 32
acCellStateContentLocked: AcCellState  # 1
acCellStateContentModified: AcCellState  # 32
acCellStateContentReadOnly: AcCellState  # 2
acCellStateFormatLocked: AcCellState  # 4
acCellStateFormatModified: AcCellState  # 64
acCellStateFormatReadOnly: AcCellState  # 8
acCellStateLinked: AcCellState  # 16
acCellStateNone: AcCellState  # 0
acCenterAlignment: AcTextAlignmentType  # 1
acCenterLine: AcDimCenterType  # 1
acCenterMark: AcDimCenterType  # 0
acCenterNone: AcDimCenterType  # 2
acChord: AcSplineKnotParameterizationType  # 0
acColorMethodByACI: AcColorMethod  # 195
acColorMethodByBlock: AcColorMethod  # 193
acColorMethodByLayer: AcColorMethod  # 192
acColorMethodByRGB: AcColorMethod  # 194
acColorMethodForeground: AcColorMethod  # 197
acConnectBase: AcBlockConnectionType  # 1
acConnectExtents: AcBlockConnectionType  # 0
acContentColor: AcCellProperty  # 64
acContentLayout: AcCellProperty  # 262144
acContentProperties: AcCellProperty  # 33662
acControlVertices: AcSplineMethodType  # 1
acCubicSpline3DPoly: Ac3DPolylineType  # 2
acCubicSplinePoly: AcPolylineType  # 3
acCubicSurfaceMesh: AcPolymeshType  # 6
acCustomParameterization: AcSplineKnotParameterizationType  # 15
acCyan: AcColor  # 4
acDataFormat: AcCellProperty  # 4
acDataRow: AcRowType  # 1
acDataType: AcCellProperty  # 2
acDataTypeAndFormat: AcCellProperty  # 6
acDate: AcValueDataType  # 8
acDecimal: AcUnits  # 2
acDefaultUnits: AcUnits  # -1
acDegreeMinuteSeconds: AcAngleUnits  # 1
acDegrees: AcAngleUnits  # 0
acDegrees000: AcRotationAngle  # 0
acDegrees15: AcSegmentAngleType  # 1
acDegrees180: AcRotationAngle  # 2
acDegrees270: AcRotationAngle  # 3
acDegrees30: AcSegmentAngleType  # 2
acDegrees45: AcSegmentAngleType  # 3
acDegrees60: AcSegmentAngleType  # 4
acDegrees90: AcSegmentAngleType  # 6
acDegreesAny: AcSegmentAngleType  # 0
acDegreesHorz: AcSegmentAngleType  # 12
acDegreesUnknown: AcRotationAngle  # -1
acDemandLoadDisabled: AcXRefDemandLoad  # 0
acDemandLoadEnabled: AcXRefDemandLoad  # 1
acDemandLoadEnabledWithCopy: AcXRefDemandLoad  # 2
acDiagonal: AcDimFractionType  # 1
acDimArchitectural: AcDimUnits  # 6
acDimArchitecturalStacked: AcDimUnits  # 4
acDimDecimal: AcDimUnits  # 2
acDimEngineering: AcDimUnits  # 3
acDimFractional: AcDimUnits  # 7
acDimFractionalStacked: AcDimUnits  # 5
acDimLArchitectural: AcDimLUnits  # 4
acDimLDecimal: AcDimLUnits  # 2
acDimLEngineering: AcDimLUnits  # 3
acDimLFractional: AcDimLUnits  # 5
acDimLScientific: AcDimLUnits  # 1
acDimLWindowsDesktop: AcDimLUnits  # 6
acDimLineWithText: AcDimTextMovement  # 0
acDimPrecisionEight: AcDimPrecision  # 8
acDimPrecisionFive: AcDimPrecision  # 5
acDimPrecisionFour: AcDimPrecision  # 4
acDimPrecisionOne: AcDimPrecision  # 1
acDimPrecisionSeven: AcDimPrecision  # 7
acDimPrecisionSix: AcDimPrecision  # 6
acDimPrecisionThree: AcDimPrecision  # 3
acDimPrecisionTwo: AcDimPrecision  # 2
acDimPrecisionZero: AcDimPrecision  # 0
acDimScientific: AcDimUnits  # 1
acDimWindowsDesktop: AcDimUnits  # 8
acDisplay: AcPlotType  # 0
acDisplayDCS: AcCoordinateSystem  # 2
acDistance: AcDynamicBlockReferencePropertyUnitsType  # 2
acDouble: AcValueDataType  # 2
acDrawContentFirst: AcDrawMLeaderOrderType  # 0
acDrawLeaderFirst: AcDrawMLeaderOrderType  # 1
acDrawLeaderHeadFirst: AcDrawLeaderOrderType  # 0
acDrawLeaderTailFirst: AcDrawLeaderOrderType  # 1
acEdRepeatLastCommand: AcDrawingAreaSCMEdit  # 0
acEdSCM: AcDrawingAreaSCMEdit  # 1
acEnableBackgroundColor: AcCellProperty  # 16384
acEnableSCM: AcDrawingAreaSCMCommand  # 2
acEnableSCMOptions: AcDrawingAreaSCMCommand  # 1
acEngineering: AcUnits  # 3
acEnter: AcDrawingAreaSCMCommand  # 0
acExtendBoth: AcExtendOption  # 3
acExtendNone: AcExtendOption  # 0
acExtendOtherEntity: AcExtendOption  # 2
acExtendThisEntity: AcExtendOption  # 1
acExtents: AcPlotType  # 1
acFirstExtensionLine: AcDimHorizontalJustification  # 1
acFit: AcSplineMethodType  # 0
acFitCurvePoly: AcPolylineType  # 1
acFlowDirBtoT: AcCellProperty  # 131072
acFontBold: AcTextFontStyle  # 2
acFontBoldItalic: AcTextFontStyle  # 3
acFontItalic: AcTextFontStyle  # 1
acFontRegular: AcTextFontStyle  # 0
acForEditing: AcFormatOption  # 1
acForExpression: AcFormatOption  # 2
acFractional: AcUnits  # 5
acFullPreview: AcPreviewMode  # 1
acGeneral: AcValueDataType  # 512
acGradientObject: AcHatchObjectType  # 1
acGrads: AcAngleUnits  # 2
acGreen: AcColor  # 3
acGridLineStyleDouble: AcGridLineStyle  # 2
acGridLineStyleSingle: AcGridLineStyle  # 1
acHatchLoopTypeDefault: AcLoopType  # 0
acHatchLoopTypeDerived: AcLoopType  # 4
acHatchLoopTypeExternal: AcLoopType  # 1
acHatchLoopTypePolyline: AcLoopType  # 2
acHatchLoopTypeTextbox: AcLoopType  # 8
acHatchObject: AcHatchObjectType  # 0
acHatchPatternTypeCustomDefined: AcPatternType  # 2
acHatchPatternTypePreDefined: AcPatternType  # 1
acHatchPatternTypeUserDefined: AcPatternType  # 0
acHatchStyleIgnore: AcHatchStyle  # 2
acHatchStyleNormal: AcHatchStyle  # 0
acHatchStyleOuter: AcHatchStyle  # 1
acHeaderRow: AcRowType  # 4
acHide: AcSplineFrameType  # 1
acHorizontal: AcDimFractionType  # 0
acHorizontalAlignmentAligned: AcHorizontalAlignment  # 3
acHorizontalAlignmentCenter: AcHorizontalAlignment  # 1
acHorizontalAlignmentFit: AcHorizontalAlignment  # 5
acHorizontalAlignmentLeft: AcHorizontalAlignment  # 0
acHorizontalAlignmentMiddle: AcHorizontalAlignment  # 4
acHorizontalAlignmentRight: AcHorizontalAlignment  # 2
acHorizontalAngle: AcTextAngleType  # 1
acHorzBottom: AcGridLineType  # 4
acHorzCentered: AcDimHorizontalJustification  # 0
acHorzInside: AcGridLineType  # 2
acHorzTop: AcGridLineType  # 1
acIgnoreMtextFormat: AcFormatOption  # 8
acInVisibleLeader: AcMLeaderType  # 0
acInches: AcPlotPaperUnits  # 0
acInsertAngle: AcTextAngleType  # 0
acInsertUnitsAngstroms: AcInsertUnits  # 11
acInsertUnitsAstronomicalUnits: AcInsertUnits  # 18
acInsertUnitsCentimeters: AcInsertUnits  # 5
acInsertUnitsDecameters: AcInsertUnits  # 15
acInsertUnitsDecimeters: AcInsertUnits  # 14
acInsertUnitsFeet: AcInsertUnits  # 2
acInsertUnitsGigameters: AcInsertUnits  # 17
acInsertUnitsHectometers: AcInsertUnits  # 16
acInsertUnitsInches: AcInsertUnits  # 1
acInsertUnitsKilometers: AcInsertUnits  # 7
acInsertUnitsLightYears: AcInsertUnits  # 19
acInsertUnitsMeters: AcInsertUnits  # 6
acInsertUnitsMicroinches: AcInsertUnits  # 8
acInsertUnitsMicrons: AcInsertUnits  # 13
acInsertUnitsMiles: AcInsertUnits  # 3
acInsertUnitsMillimeters: AcInsertUnits  # 4
acInsertUnitsMils: AcInsertUnits  # 9
acInsertUnitsNanometers: AcInsertUnits  # 12
acInsertUnitsParsecs: AcInsertUnits  # 20
acInsertUnitsUSSurveyFeet: AcInsertUnits  # 21
acInsertUnitsUSSurveyInch: AcInsertUnits  # 22
acInsertUnitsUSSurveyMile: AcInsertUnits  # 24
acInsertUnitsUSSurveyYard: AcInsertUnits  # 23
acInsertUnitsUnitless: AcInsertUnits  # 0
acInsertUnitsYards: AcInsertUnits  # 10
acIntersection: AcBooleanType  # 1
acInvalidCellProperty: AcCellProperty  # 0
acInvalidGridLine: AcGridLineType  # 0
acJIS: AcDimVerticalJustification  # 3
acKeyboardEntry: AcKeyboardPriority  # 1
acKeyboardEntryExceptScripts: AcKeyboardPriority  # 2
acKeyboardRunningObjSnap: AcKeyboardPriority  # 0
acLayout: AcPlotType  # 5
acLeftAlignment: AcTextAlignmentType  # 0
acLeftMask: AcCellEdgeMask  # 8
acLeftToRight: AcDrawingDirection  # 1
acLimits: AcPlotType  # 2
acLineNoArrow: AcLeaderType  # 0
acLineSpacingStyleAtLeast: AcLineSpacingStyle  # 1
acLineSpacingStyleExactly: AcLineSpacingStyle  # 2
acLineWithArrow: AcLeaderType  # 2
acLnWt000: AcLineWeight  # 0
acLnWt005: AcLineWeight  # 5
acLnWt009: AcLineWeight  # 9
acLnWt013: AcLineWeight  # 13
acLnWt015: AcLineWeight  # 15
acLnWt018: AcLineWeight  # 18
acLnWt020: AcLineWeight  # 20
acLnWt025: AcLineWeight  # 25
acLnWt030: AcLineWeight  # 30
acLnWt035: AcLineWeight  # 35
acLnWt040: AcLineWeight  # 40
acLnWt050: AcLineWeight  # 50
acLnWt053: AcLineWeight  # 53
acLnWt060: AcLineWeight  # 60
acLnWt070: AcLineWeight  # 70
acLnWt080: AcLineWeight  # 80
acLnWt090: AcLineWeight  # 90
acLnWt100: AcLineWeight  # 100
acLnWt106: AcLineWeight  # 106
acLnWt120: AcLineWeight  # 120
acLnWt140: AcLineWeight  # 140
acLnWt158: AcLineWeight  # 158
acLnWt200: AcLineWeight  # 200
acLnWt211: AcLineWeight  # 211
acLnWtByBlock: AcLineWeight  # -2
acLnWtByLayer: AcLineWeight  # -1
acLnWtByLwDefault: AcLineWeight  # -3
acLock: AcCellProperty  # 1
acLong: AcValueDataType  # 1
acMTextContent: AcMLeaderContentType  # 2
acMagenta: AcColor  # 6
acMarginBottom: AcCellProperty  # 8192
acMarginLeft: AcCellProperty  # 1024
acMarginRight: AcCellProperty  # 4096
acMarginTop: AcCellProperty  # 2048
acMax: AcWindowState  # 3
acMenuFileCompiled: AcMenuFileType  # 0
acMenuFileSource: AcMenuFileType  # 1
acMenuItem: AcMenuItemType  # 0
acMenuSeparator: AcMenuItemType  # 1
acMenuSubMenu: AcMenuItemType  # 2
acMergeAll: AcCellProperty  # 65536
acMergeCellStyleConvertDuplicatesToOverrides: AcMergeCellStyleOption  # 4
acMergeCellStyleCopyDuplicates: AcMergeCellStyleOption  # 1
acMergeCellStyleIgnoreNewStyles: AcMergeCellStyleOption  # 8
acMergeCellStyleNone: AcMergeCellStyleOption  # 0
acMergeCellStyleOverwriteDuplicates: AcMergeCellStyleOption  # 2
acMiddleCenter: AcCellAlignment  # 5
acMiddleLeft: AcCellAlignment  # 4
acMiddleRight: AcCellAlignment  # 6
acMillimeters: AcPlotPaperUnits  # 1
acMin: AcWindowState  # 2
acModelSpace: AcActiveSpace  # 1
acMoveTextAddLeader: AcDimTextMovement  # 1
acMoveTextNoLeader: AcDimTextMovement  # 2
acNative: AcSaveAsType  # 64
acNoUnits: AcDynamicBlockReferencePropertyUnitsType  # 0
acNoneContent: AcMLeaderContentType  # 0
acNorm: AcWindowState  # 1
acNotStacked: AcDimFractionType  # 2
acOCS: AcCoordinateSystem  # 4
acOQGraphics: AcOleQuality  # 2
acOQHighPhoto: AcOleQuality  # 4
acOQLineArt: AcOleQuality  # 0
acOQPhoto: AcOleQuality  # 3
acOQText: AcOleQuality  # 1
acObjectId: AcValueDataType  # 64
acOutside: AcDimVerticalJustification  # 2
acOverFirstExtension: AcDimHorizontalJustification  # 3
acOverSecondExtension: AcDimHorizontalJustification  # 4
acPaperSpace: AcActiveSpace  # 0
acPaperSpaceDCS: AcCoordinateSystem  # 3
acParseOptionNone: AcParseOption  # 0
acPartialMenuGroup: AcMenuGroupType  # 1
acPartialPreview: AcPreviewMode  # 0
acPenWidth013: AcISOPenWidth  # 13
acPenWidth018: AcISOPenWidth  # 18
acPenWidth025: AcISOPenWidth  # 25
acPenWidth035: AcISOPenWidth  # 35
acPenWidth050: AcISOPenWidth  # 50
acPenWidth070: AcISOPenWidth  # 70
acPenWidth100: AcISOPenWidth  # 100
acPenWidth140: AcISOPenWidth  # 140
acPenWidth200: AcISOPenWidth  # 200
acPenWidthUnk: AcISOPenWidth  # -1
acPixels: AcPlotPaperUnits  # 2
acPoint2d: AcValueDataType  # 16
acPoint3d: AcValueDataType  # 32
acPreferenceClassic: AcKeyboardAccelerator  # 1
acPreserveMtextFormat: AcParseOption  # 2
acPrinterAlertOnce: AcPrinterSpoolAlert  # 1
acPrinterAlwaysAlert: AcPrinterSpoolAlert  # 0
acPrinterNeverAlert: AcPrinterSpoolAlert  # 3
acPrinterNeverAlertLogOnce: AcPrinterSpoolAlert  # 2
acProxyBoundingBox: AcProxyImage  # 2
acProxyNotShow: AcProxyImage  # 0
acProxyShow: AcProxyImage  # 1
acQuadSpline3DPoly: Ac3DPolylineType  # 1
acQuadSplinePoly: AcPolylineType  # 2
acQuadSurfaceMesh: AcPolymeshType  # 5
acR12_dxf: AcSaveAsType  # 1
acR13_dwg: AcSaveAsType  # 4
acR13_dxf: AcSaveAsType  # 5
acR14_dwg: AcSaveAsType  # 8
acR14_dxf: AcSaveAsType  # 9
acR15_Template: AcSaveAsType  # 14
acR15_dwg: AcSaveAsType  # 12
acR15_dxf: AcSaveAsType  # 13
acR18_Template: AcSaveAsType  # 26
acR18_dwg: AcSaveAsType  # 24
acR18_dxf: AcSaveAsType  # 25
acRadians: AcAngleUnits  # 3
acRed: AcColor  # 1
acRepeatLastCommand: AcDrawingAreaSCMDefault  # 0
acResbuf: AcValueDataType  # 256
acRightAlignment: AcTextAlignmentType  # 2
acRightMask: AcCellEdgeMask  # 2
acRightToLeft: AcDrawingDirection  # 2
acRotation: AcCellProperty  # 8
acSCM: AcDrawingAreaSCMDefault  # 1
acScale: AcCellProperty  # 16
acScaleToFit: AcPlotScale  # 0
acScientific: AcUnits  # 1
acSecondExtensionLine: AcDimHorizontalJustification  # 2
acSectionGenerationDestinationFile: AcSectionGeneration  # 64
acSectionGenerationDestinationNewBlock: AcSectionGeneration  # 16
acSectionGenerationDestinationReplaceBlock: AcSectionGeneration  # 32
acSectionGenerationSourceAllObjects: AcSectionGeneration  # 1
acSectionGenerationSourceSelectedObjects: AcSectionGeneration  # 2
acSectionStateBoundary: AcSectionState  # 2
acSectionStatePlane: AcSectionState  # 1
acSectionStateVolume: AcSectionState  # 4
acSectionSubItemBackLine: AcSectionSubItem  # 8
acSectionSubItemBackLineBottom: AcSectionSubItem  # 32
acSectionSubItemBackLineTop: AcSectionSubItem  # 16
acSectionSubItemSectionLine: AcSectionSubItem  # 1
acSectionSubItemSectionLineBottom: AcSectionSubItem  # 4
acSectionSubItemSectionLineTop: AcSectionSubItem  # 2
acSectionSubItemVerticalLineBottom: AcSectionSubItem  # 128
acSectionSubItemVerticalLineTop: AcSectionSubItem  # 64
acSectionSubItemkNone: AcSectionSubItem  # 0
acSectionType2dSection: AcSectionType  # 2
acSectionType3dSection: AcSectionType  # 4
acSectionTypeLiveSection: AcSectionType  # 1
acSelectionSetAll: AcSelect  # 5
acSelectionSetCrossing: AcSelect  # 1
acSelectionSetCrossingPolygon: AcSelect  # 7
acSelectionSetFence: AcSelect  # 2
acSelectionSetLast: AcSelect  # 4
acSelectionSetWindow: AcSelect  # 0
acSelectionSetWindowPolygon: AcSelect  # 6
acSetDefaultFormat: AcParseOption  # 1
acShow: AcSplineFrameType  # 0
acSimple3DPoly: Ac3DPolylineType  # 0
acSimpleMesh: AcPolymeshType  # 0
acSimplePoly: AcPolylineType  # 0
acSplineLeader: AcMLeaderType  # 2
acSplineNoArrow: AcLeaderType  # 1
acSplineWithArrow: AcLeaderType  # 3
acSqrtChord: AcSplineKnotParameterizationType  # 1
acStraightLeader: AcMLeaderType  # 1
acString: AcValueDataType  # 4
acSubtraction: AcBooleanType  # 2
acSymAbove: AcDimArcLengthSymbol  # 1
acSymInFront: AcDimArcLengthSymbol  # 0
acSymNone: AcDimArcLengthSymbol  # 2
acTableBottomToTop: AcTableDirection  # 1
acTableFlowDownOrUp: AcTableFlowDirection  # 2
acTableFlowLeft: AcTableFlowDirection  # 4
acTableFlowRight: AcTableFlowDirection  # 1
acTableSelectCrossing: AcSelectType  # 2
acTableSelectWindow: AcSelectType  # 1
acTableTopToBottom: AcTableDirection  # 0
acTextAndArrows: AcDimFit  # 0
acTextCell: AcCellType  # 1
acTextHeight: AcCellProperty  # 512
acTextOnly: AcDimFit  # 2
acTextStyle: AcCellProperty  # 256
acTitleRow: AcRowType  # 2
acTolBasic: AcDimToleranceMethod  # 4
acTolBottom: AcDimToleranceJustify  # 0
acTolDeviation: AcDimToleranceMethod  # 2
acTolLimits: AcDimToleranceMethod  # 3
acTolMiddle: AcDimToleranceJustify  # 1
acTolNone: AcDimToleranceMethod  # 0
acTolSymmetrical: AcDimToleranceMethod  # 1
acTolTop: AcDimToleranceJustify  # 2
acToolbarButton: AcToolbarItemType  # 0
acToolbarControl: AcToolbarItemType  # 2
acToolbarDockBottom: AcToolbarDockStatus  # 1
acToolbarDockLeft: AcToolbarDockStatus  # 2
acToolbarDockRight: AcToolbarDockStatus  # 3
acToolbarDockTop: AcToolbarDockStatus  # 0
acToolbarFloating: AcToolbarDockStatus  # 4
acToolbarFlyout: AcToolbarItemType  # 3
acToolbarSeparator: AcToolbarItemType  # 1
acTop: AcMLineJustification  # 0
acTopCenter: AcCellAlignment  # 2
acTopLeft: AcCellAlignment  # 1
acTopMask: AcCellEdgeMask  # 1
acTopRight: AcCellAlignment  # 3
acTopToBottom: AcDrawingDirection  # 3
acUCS: AcCoordinateSystem  # 1
acUnder: AcDimVerticalJustification  # 4
acUniform: AcBlockScaling  # 1
acUniformParam: AcSplineKnotParameterizationType  # 2
acUnion: AcBooleanType  # 0
acUnitAngle: AcValueUnitType  # 2
acUnitArea: AcValueUnitType  # 4
acUnitDistance: AcValueUnitType  # 1
acUnitVolume: AcValueUnitType  # 8
acUnitless: AcValueUnitType  # 0
acUnknown: AcSaveAsType  # -1
acUnknownCell: AcCellType  # 0
acUnknownDataType: AcValueDataType  # 0
acUnknownRow: AcRowType  # 0
acUpdateDataFromSource: AcDataLinkUpdateDirection  # 1
acUpdateOptionIncludeXrefs: AcDataLinkUpdateOption  # 1048576
acUpdateOptionNone: AcDataLinkUpdateOption  # 0
acUpdateOptionOverwriteContentModifiedAfterUpdate: AcDataLinkUpdateOption  # 131072
acUpdateOptionOverwriteFormatModifiedAfterUpdate: AcDataLinkUpdateOption  # 262144
acUpdateOptionUpdateFullSourceRange: AcDataLinkUpdateOption  # 524288
acUpdateSourceFromData: AcDataLinkUpdateDirection  # 2
acUseMaximumPrecision: AcFormatOption  # 4
acVertCentered: AcDimVerticalJustification  # 0
acVertInside: AcGridLineType  # 16
acVertLeft: AcGridLineType  # 8
acVertRight: AcGridLineType  # 32
acVerticalAlignmentBaseline: AcVerticalAlignment  # 0
acVerticalAlignmentBottom: AcVerticalAlignment  # 1
acVerticalAlignmentMiddle: AcVerticalAlignment  # 2
acVerticalAlignmentTop: AcVerticalAlignment  # 3
acView: AcPlotType  # 3
acViewport2Horizontal: AcViewportSplitType  # 0
acViewport2Vertical: AcViewportSplitType  # 1
acViewport3Above: AcViewportSplitType  # 6
acViewport3Below: AcViewportSplitType  # 7
acViewport3Horizontal: AcViewportSplitType  # 4
acViewport3Left: AcViewportSplitType  # 2
acViewport3Right: AcViewportSplitType  # 3
acViewport3Vertical: AcViewportSplitType  # 5
acViewport4: AcViewportSplitType  # 8
acVp100_1: AcViewportScale  # 18
acVp10_1: AcViewportScale  # 17
acVp1_1: AcViewportScale  # 2
acVp1_10: AcViewportScale  # 7
acVp1_100: AcViewportScale  # 13
acVp1_128in_1ft: AcViewportScale  # 19
acVp1_16: AcViewportScale  # 8
acVp1_16in_1ft: AcViewportScale  # 22
acVp1_2: AcViewportScale  # 3
acVp1_20: AcViewportScale  # 9
acVp1_2in_1ft: AcViewportScale  # 28
acVp1_30: AcViewportScale  # 10
acVp1_32in_1ft: AcViewportScale  # 21
acVp1_4: AcViewportScale  # 4
acVp1_40: AcViewportScale  # 11
acVp1_4in_1ft: AcViewportScale  # 26
acVp1_5: AcViewportScale  # 5
acVp1_50: AcViewportScale  # 12
acVp1_64in_1ft: AcViewportScale  # 20
acVp1_8: AcViewportScale  # 6
acVp1_8in_1ft: AcViewportScale  # 24
acVp1and1_2in_1ft: AcViewportScale  # 31
acVp1ft_1ft: AcViewportScale  # 34
acVp1in_1ft: AcViewportScale  # 30
acVp2_1: AcViewportScale  # 14
acVp3_16in_1ft: AcViewportScale  # 25
acVp3_32in_1ft: AcViewportScale  # 23
acVp3_4in_1ft: AcViewportScale  # 29
acVp3_8in_1ft: AcViewportScale  # 27
acVp3in_1ft: AcViewportScale  # 32
acVp4_1: AcViewportScale  # 15
acVp6in_1ft: AcViewportScale  # 33
acVp8_1: AcViewportScale  # 16
acVpCustomScale: AcViewportScale  # 1
acVpScaleToFit: AcViewportScale  # 0
acWhite: AcColor  # 7
acWindow: AcPlotType  # 4
acWorld: AcCoordinateSystem  # 0
acYellow: AcColor  # 2
acZero: AcMLineJustification  # 1
acZoomScaledAbsolute: AcZoomScaleType  # 0
acZoomScaledRelative: AcZoomScaleType  # 1
acZoomScaledRelativePSpace: AcZoomScaleType  # 2
kFormatOptionNone: AcFormatOption  # 0

class Ac3DPolylineType(_BoostPythonEnum):
    acSimple3DPoly: ClassVar[Self]  # 0
    acQuadSpline3DPoly: ClassVar[Self]  # 1
    acCubicSpline3DPoly: ClassVar[Self]  # 2

class AcActiveSpace(_BoostPythonEnum):
    acPaperSpace: ClassVar[Self]  # 0
    acModelSpace: ClassVar[Self]  # 1

class AcAlignment(_BoostPythonEnum):
    acAlignmentLeft: ClassVar[Self]  # 0
    acAlignmentCenter: ClassVar[Self]  # 1
    acAlignmentRight: ClassVar[Self]  # 2
    acAlignmentAligned: ClassVar[Self]  # 3
    acAlignmentMiddle: ClassVar[Self]  # 4
    acAlignmentFit: ClassVar[Self]  # 5
    acAlignmentTopLeft: ClassVar[Self]  # 6
    acAlignmentTopCenter: ClassVar[Self]  # 7
    acAlignmentTopRight: ClassVar[Self]  # 8
    acAlignmentMiddleLeft: ClassVar[Self]  # 9
    acAlignmentMiddleCenter: ClassVar[Self]  # 10
    acAlignmentMiddleRight: ClassVar[Self]  # 11
    acAlignmentBottomLeft: ClassVar[Self]  # 12
    acAlignmentBottomCenter: ClassVar[Self]  # 13
    acAlignmentBottomRight: ClassVar[Self]  # 14

class AcAlignmentPointAcquisition(_BoostPythonEnum):
    acAlignPntAcquisitionAutomatic: ClassVar[Self]  # 0
    acAlignPntAcquisitionShiftToAcquire: ClassVar[Self]  # 1

class AcAngleUnits(_BoostPythonEnum):
    acDegrees: ClassVar[Self]  # 0
    acDegreeMinuteSeconds: ClassVar[Self]  # 1
    acGrads: ClassVar[Self]  # 2
    acRadians: ClassVar[Self]  # 3

class AcAttachmentPoint(_BoostPythonEnum):
    acAttachmentPointTopLeft: ClassVar[Self]  # 1
    acAttachmentPointTopCenter: ClassVar[Self]  # 2
    acAttachmentPointTopRight: ClassVar[Self]  # 3
    acAttachmentPointMiddleLeft: ClassVar[Self]  # 4
    acAttachmentPointMiddleCenter: ClassVar[Self]  # 5
    acAttachmentPointMiddleRight: ClassVar[Self]  # 6
    acAttachmentPointBottomLeft: ClassVar[Self]  # 7
    acAttachmentPointBottomCenter: ClassVar[Self]  # 8
    acAttachmentPointBottomRight: ClassVar[Self]  # 9

class AcAttributeMode(_BoostPythonEnum):
    acAttributeModeNormal: ClassVar[Self]  # 0
    acAttributeModeInvisible: ClassVar[Self]  # 1
    acAttributeModeConstant: ClassVar[Self]  # 2
    acAttributeModeVerify: ClassVar[Self]  # 4
    acAttributeModePreset: ClassVar[Self]  # 8
    acAttributeModeLockPosition: ClassVar[Self]  # 16
    acAttributeModeMultipleLine: ClassVar[Self]  # 32

class AcBlockConnectionType(_BoostPythonEnum):
    acConnectExtents: ClassVar[Self]  # 0
    acConnectBase: ClassVar[Self]  # 1

class AcBlockScaling(_BoostPythonEnum):
    acAny: ClassVar[Self]  # 0
    acUniform: ClassVar[Self]  # 1

class AcBooleanType(_BoostPythonEnum):
    acUnion: ClassVar[Self]  # 0
    acIntersection: ClassVar[Self]  # 1
    acSubtraction: ClassVar[Self]  # 2

class AcCellAlignment(_BoostPythonEnum):
    acTopLeft: ClassVar[Self]  # 1
    acTopCenter: ClassVar[Self]  # 2
    acTopRight: ClassVar[Self]  # 3
    acMiddleLeft: ClassVar[Self]  # 4
    acMiddleCenter: ClassVar[Self]  # 5
    acMiddleRight: ClassVar[Self]  # 6
    acBottomLeft: ClassVar[Self]  # 7
    acBottomCenter: ClassVar[Self]  # 8
    acBottomRight: ClassVar[Self]  # 9

class AcCellContentLayout(_BoostPythonEnum):
    acCellContentLayoutFlow: ClassVar[Self]  # 1
    acCellContentLayoutStackedHorizontal: ClassVar[Self]  # 2
    acCellContentLayoutStackedVertical: ClassVar[Self]  # 4

class AcCellContentType(_BoostPythonEnum):
    acCellContentTypeUnknown: ClassVar[Self]  # 0
    acCellContentTypeValue: ClassVar[Self]  # 1
    acCellContentTypeField: ClassVar[Self]  # 2
    acCellContentTypeBlock: ClassVar[Self]  # 4

class AcCellEdgeMask(_BoostPythonEnum):
    acTopMask: ClassVar[Self]  # 1
    acRightMask: ClassVar[Self]  # 2
    acBottomMask: ClassVar[Self]  # 4
    acLeftMask: ClassVar[Self]  # 8

class AcCellMargin(_BoostPythonEnum):
    acCellMarginTop: ClassVar[Self]  # 1
    acCellMarginLeft: ClassVar[Self]  # 2
    acCellMarginBottom: ClassVar[Self]  # 4
    acCellMarginRight: ClassVar[Self]  # 8
    acCellMarginHorzSpacing: ClassVar[Self]  # 16
    acCellMarginVertSpacing: ClassVar[Self]  # 32

class AcCellProperty(_BoostPythonEnum):
    acInvalidCellProperty: ClassVar[Self]  # 0
    acLock: ClassVar[Self]  # 1
    acDataType: ClassVar[Self]  # 2
    acDataFormat: ClassVar[Self]  # 4
    acRotation: ClassVar[Self]  # 8
    acScale: ClassVar[Self]  # 16
    acAlignmentProperty: ClassVar[Self]  # 32
    acContentColor: ClassVar[Self]  # 64
    acBackgroundColor: ClassVar[Self]  # 128
    acTextStyle: ClassVar[Self]  # 256
    acTextHeight: ClassVar[Self]  # 512
    acMarginLeft: ClassVar[Self]  # 1024
    acMarginTop: ClassVar[Self]  # 2048
    acMarginRight: ClassVar[Self]  # 4096
    acMarginBottom: ClassVar[Self]  # 8192
    acEnableBackgroundColor: ClassVar[Self]  # 16384
    acAutoScale: ClassVar[Self]  # 32768
    acMergeAll: ClassVar[Self]  # 65536
    acFlowDirBtoT: ClassVar[Self]  # 131072
    acContentLayout: ClassVar[Self]  # 262144
    acDataTypeAndFormat: ClassVar[Self]  # 6
    acContentProperties: ClassVar[Self]  # 33662
    acBitProperties: ClassVar[Self]  # 245760
    acAllCellProperties: ClassVar[Self]  # 524287

class AcCellState(_BoostPythonEnum):
    acCellStateNone: ClassVar[Self]  # 0
    acCellStateContentLocked: ClassVar[Self]  # 1
    acCellStateContentReadOnly: ClassVar[Self]  # 2
    acCellStateFormatLocked: ClassVar[Self]  # 4
    acCellStateFormatReadOnly: ClassVar[Self]  # 8
    acCellStateLinked: ClassVar[Self]  # 16
    acCellStateContentModified: ClassVar[Self]  # 32
    acCellStateFormatModified: ClassVar[Self]  # 64

class AcCellType(_BoostPythonEnum):
    acUnknownCell: ClassVar[Self]  # 0
    acTextCell: ClassVar[Self]  # 1
    acBlockCell: ClassVar[Self]  # 2

class AcColor(_BoostPythonEnum):
    acByBlock: ClassVar[Self]  # 0
    acRed: ClassVar[Self]  # 1
    acYellow: ClassVar[Self]  # 2
    acGreen: ClassVar[Self]  # 3
    acCyan: ClassVar[Self]  # 4
    acBlue: ClassVar[Self]  # 5
    acMagenta: ClassVar[Self]  # 6
    acWhite: ClassVar[Self]  # 7
    acByLayer: ClassVar[Self]  # 256

class AcColorMethod(_BoostPythonEnum):
    acColorMethodByLayer: ClassVar[Self]  # 192
    acColorMethodByBlock: ClassVar[Self]  # 193
    acColorMethodByRGB: ClassVar[Self]  # 194
    acColorMethodByACI: ClassVar[Self]  # 195
    acColorMethodForeground: ClassVar[Self]  # 197

class AcCoordinateSystem(_BoostPythonEnum):
    acWorld: ClassVar[Self]  # 0
    acUCS: ClassVar[Self]  # 1
    acDisplayDCS: ClassVar[Self]  # 2
    acPaperSpaceDCS: ClassVar[Self]  # 3
    acOCS: ClassVar[Self]  # 4

class AcDataLinkUpdateDirection(_BoostPythonEnum):
    acUpdateDataFromSource: ClassVar[Self]  # 1
    acUpdateSourceFromData: ClassVar[Self]  # 2

class AcDataLinkUpdateOption(_BoostPythonEnum):
    acUpdateOptionNone: ClassVar[Self]  # 0
    acUpdateOptionOverwriteContentModifiedAfterUpdate: ClassVar[Self]  # 131072
    acUpdateOptionOverwriteFormatModifiedAfterUpdate: ClassVar[Self]  # 262144
    acUpdateOptionUpdateFullSourceRange: ClassVar[Self]  # 524288
    acUpdateOptionIncludeXrefs: ClassVar[Self]  # 1048576

class AcDimArcLengthSymbol(_BoostPythonEnum):
    acSymInFront: ClassVar[Self]  # 0
    acSymAbove: ClassVar[Self]  # 1
    acSymNone: ClassVar[Self]  # 2

class AcDimArrowheadType(_BoostPythonEnum):
    acArrowDefault: ClassVar[Self]  # 0
    acArrowClosedBlank: ClassVar[Self]  # 1
    acArrowClosed: ClassVar[Self]  # 2
    acArrowDot: ClassVar[Self]  # 3
    acArrowArchTick: ClassVar[Self]  # 4
    acArrowOblique: ClassVar[Self]  # 5
    acArrowOpen: ClassVar[Self]  # 6
    acArrowOrigin: ClassVar[Self]  # 7
    acArrowOrigin2: ClassVar[Self]  # 8
    acArrowOpen90: ClassVar[Self]  # 9
    acArrowOpen30: ClassVar[Self]  # 10
    acArrowDotSmall: ClassVar[Self]  # 11
    acArrowDotBlank: ClassVar[Self]  # 12
    acArrowSmall: ClassVar[Self]  # 13
    acArrowBoxBlank: ClassVar[Self]  # 14
    acArrowBoxFilled: ClassVar[Self]  # 15
    acArrowDatumBlank: ClassVar[Self]  # 16
    acArrowDatumFilled: ClassVar[Self]  # 17
    acArrowIntegral: ClassVar[Self]  # 18
    acArrowNone: ClassVar[Self]  # 19
    acArrowUserDefined: ClassVar[Self]  # 20

class AcDimCenterType(_BoostPythonEnum):
    acCenterMark: ClassVar[Self]  # 0
    acCenterLine: ClassVar[Self]  # 1
    acCenterNone: ClassVar[Self]  # 2

class AcDimFit(_BoostPythonEnum):
    acTextAndArrows: ClassVar[Self]  # 0
    acArrowsOnly: ClassVar[Self]  # 1
    acTextOnly: ClassVar[Self]  # 2
    acBestFit: ClassVar[Self]  # 3

class AcDimFractionType(_BoostPythonEnum):
    acHorizontal: ClassVar[Self]  # 0
    acDiagonal: ClassVar[Self]  # 1
    acNotStacked: ClassVar[Self]  # 2

class AcDimHorizontalJustification(_BoostPythonEnum):
    acHorzCentered: ClassVar[Self]  # 0
    acFirstExtensionLine: ClassVar[Self]  # 1
    acSecondExtensionLine: ClassVar[Self]  # 2
    acOverFirstExtension: ClassVar[Self]  # 3
    acOverSecondExtension: ClassVar[Self]  # 4

class AcDimLUnits(_BoostPythonEnum):
    acDimLScientific: ClassVar[Self]  # 1
    acDimLDecimal: ClassVar[Self]  # 2
    acDimLEngineering: ClassVar[Self]  # 3
    acDimLArchitectural: ClassVar[Self]  # 4
    acDimLFractional: ClassVar[Self]  # 5
    acDimLWindowsDesktop: ClassVar[Self]  # 6

class AcDimPrecision(_BoostPythonEnum):
    acDimPrecisionZero: ClassVar[Self]  # 0
    acDimPrecisionOne: ClassVar[Self]  # 1
    acDimPrecisionTwo: ClassVar[Self]  # 2
    acDimPrecisionThree: ClassVar[Self]  # 3
    acDimPrecisionFour: ClassVar[Self]  # 4
    acDimPrecisionFive: ClassVar[Self]  # 5
    acDimPrecisionSix: ClassVar[Self]  # 6
    acDimPrecisionSeven: ClassVar[Self]  # 7
    acDimPrecisionEight: ClassVar[Self]  # 8

class AcDimTextMovement(_BoostPythonEnum):
    acDimLineWithText: ClassVar[Self]  # 0
    acMoveTextAddLeader: ClassVar[Self]  # 1
    acMoveTextNoLeader: ClassVar[Self]  # 2

class AcDimToleranceJustify(_BoostPythonEnum):
    acTolBottom: ClassVar[Self]  # 0
    acTolMiddle: ClassVar[Self]  # 1
    acTolTop: ClassVar[Self]  # 2

class AcDimToleranceMethod(_BoostPythonEnum):
    acTolNone: ClassVar[Self]  # 0
    acTolSymmetrical: ClassVar[Self]  # 1
    acTolDeviation: ClassVar[Self]  # 2
    acTolLimits: ClassVar[Self]  # 3
    acTolBasic: ClassVar[Self]  # 4

class AcDimUnits(_BoostPythonEnum):
    acDimScientific: ClassVar[Self]  # 1
    acDimDecimal: ClassVar[Self]  # 2
    acDimEngineering: ClassVar[Self]  # 3
    acDimArchitecturalStacked: ClassVar[Self]  # 4
    acDimFractionalStacked: ClassVar[Self]  # 5
    acDimArchitectural: ClassVar[Self]  # 6
    acDimFractional: ClassVar[Self]  # 7
    acDimWindowsDesktop: ClassVar[Self]  # 8

class AcDimVerticalJustification(_BoostPythonEnum):
    acVertCentered: ClassVar[Self]  # 0
    acAbove: ClassVar[Self]  # 1
    acOutside: ClassVar[Self]  # 2
    acJIS: ClassVar[Self]  # 3
    acUnder: ClassVar[Self]  # 4

class AcDrawLeaderOrderType(_BoostPythonEnum):
    acDrawLeaderHeadFirst: ClassVar[Self]  # 0
    acDrawLeaderTailFirst: ClassVar[Self]  # 1

class AcDrawMLeaderOrderType(_BoostPythonEnum):
    acDrawContentFirst: ClassVar[Self]  # 0
    acDrawLeaderFirst: ClassVar[Self]  # 1

class AcDrawingAreaSCMCommand(_BoostPythonEnum):
    acEnter: ClassVar[Self]  # 0
    acEnableSCMOptions: ClassVar[Self]  # 1
    acEnableSCM: ClassVar[Self]  # 2

class AcDrawingAreaSCMDefault(_BoostPythonEnum):
    acRepeatLastCommand: ClassVar[Self]  # 0
    acSCM: ClassVar[Self]  # 1

class AcDrawingAreaSCMEdit(_BoostPythonEnum):
    acEdRepeatLastCommand: ClassVar[Self]  # 0
    acEdSCM: ClassVar[Self]  # 1

class AcDrawingDirection(_BoostPythonEnum):
    acLeftToRight: ClassVar[Self]  # 1
    acRightToLeft: ClassVar[Self]  # 2
    acTopToBottom: ClassVar[Self]  # 3
    acBottomToTop: ClassVar[Self]  # 4
    acByStyle: ClassVar[Self]  # 5

class AcDynamicBlockReferencePropertyUnitsType(_BoostPythonEnum):
    acNoUnits: ClassVar[Self]  # 0
    acAngular: ClassVar[Self]  # 1
    acDistance: ClassVar[Self]  # 2
    acArea: ClassVar[Self]  # 3

class AcExtendOption(_BoostPythonEnum):
    acExtendNone: ClassVar[Self]  # 0
    acExtendThisEntity: ClassVar[Self]  # 1
    acExtendOtherEntity: ClassVar[Self]  # 2
    acExtendBoth: ClassVar[Self]  # 3

class AcFormatOption(_BoostPythonEnum):
    kFormatOptionNone: ClassVar[Self]  # 0
    acForEditing: ClassVar[Self]  # 1
    acForExpression: ClassVar[Self]  # 2
    acUseMaximumPrecision: ClassVar[Self]  # 4
    acIgnoreMtextFormat: ClassVar[Self]  # 8

class AcGridLineStyle(_BoostPythonEnum):
    acGridLineStyleSingle: ClassVar[Self]  # 1
    acGridLineStyleDouble: ClassVar[Self]  # 2

class AcGridLineType(_BoostPythonEnum):
    acInvalidGridLine: ClassVar[Self]  # 0
    acHorzTop: ClassVar[Self]  # 1
    acHorzInside: ClassVar[Self]  # 2
    acHorzBottom: ClassVar[Self]  # 4
    acVertLeft: ClassVar[Self]  # 8
    acVertInside: ClassVar[Self]  # 16
    acVertRight: ClassVar[Self]  # 32

class AcHatchObjectType(_BoostPythonEnum):
    acHatchObject: ClassVar[Self]  # 0
    acGradientObject: ClassVar[Self]  # 1

class AcHatchStyle(_BoostPythonEnum):
    acHatchStyleNormal: ClassVar[Self]  # 0
    acHatchStyleOuter: ClassVar[Self]  # 1
    acHatchStyleIgnore: ClassVar[Self]  # 2

class AcHorizontalAlignment(_BoostPythonEnum):
    acHorizontalAlignmentLeft: ClassVar[Self]  # 0
    acHorizontalAlignmentCenter: ClassVar[Self]  # 1
    acHorizontalAlignmentRight: ClassVar[Self]  # 2
    acHorizontalAlignmentAligned: ClassVar[Self]  # 3
    acHorizontalAlignmentMiddle: ClassVar[Self]  # 4
    acHorizontalAlignmentFit: ClassVar[Self]  # 5

class AcISOPenWidth(_BoostPythonEnum):
    acPenWidth013: ClassVar[Self]  # 13
    acPenWidth018: ClassVar[Self]  # 18
    acPenWidth025: ClassVar[Self]  # 25
    acPenWidth035: ClassVar[Self]  # 35
    acPenWidth050: ClassVar[Self]  # 50
    acPenWidth070: ClassVar[Self]  # 70
    acPenWidth100: ClassVar[Self]  # 100
    acPenWidth140: ClassVar[Self]  # 140
    acPenWidth200: ClassVar[Self]  # 200
    acPenWidthUnk: ClassVar[Self]  # -1

class AcInsertUnits(_BoostPythonEnum):
    acInsertUnitsUnitless: ClassVar[Self]  # 0
    acInsertUnitsInches: ClassVar[Self]  # 1
    acInsertUnitsFeet: ClassVar[Self]  # 2
    acInsertUnitsMiles: ClassVar[Self]  # 3
    acInsertUnitsMillimeters: ClassVar[Self]  # 4
    acInsertUnitsCentimeters: ClassVar[Self]  # 5
    acInsertUnitsMeters: ClassVar[Self]  # 6
    acInsertUnitsKilometers: ClassVar[Self]  # 7
    acInsertUnitsMicroinches: ClassVar[Self]  # 8
    acInsertUnitsMils: ClassVar[Self]  # 9
    acInsertUnitsYards: ClassVar[Self]  # 10
    acInsertUnitsAngstroms: ClassVar[Self]  # 11
    acInsertUnitsNanometers: ClassVar[Self]  # 12
    acInsertUnitsMicrons: ClassVar[Self]  # 13
    acInsertUnitsDecimeters: ClassVar[Self]  # 14
    acInsertUnitsDecameters: ClassVar[Self]  # 15
    acInsertUnitsHectometers: ClassVar[Self]  # 16
    acInsertUnitsGigameters: ClassVar[Self]  # 17
    acInsertUnitsAstronomicalUnits: ClassVar[Self]  # 18
    acInsertUnitsLightYears: ClassVar[Self]  # 19
    acInsertUnitsParsecs: ClassVar[Self]  # 20
    acInsertUnitsUSSurveyFeet: ClassVar[Self]  # 21
    acInsertUnitsUSSurveyInch: ClassVar[Self]  # 22
    acInsertUnitsUSSurveyYard: ClassVar[Self]  # 23
    acInsertUnitsUSSurveyMile: ClassVar[Self]  # 24

class AcKeyboardAccelerator(_BoostPythonEnum):
    acPreferenceClassic: ClassVar[Self]  # 1

class AcKeyboardPriority(_BoostPythonEnum):
    acKeyboardRunningObjSnap: ClassVar[Self]  # 0
    acKeyboardEntry: ClassVar[Self]  # 1
    acKeyboardEntryExceptScripts: ClassVar[Self]  # 2

class AcLeaderType(_BoostPythonEnum):
    acLineNoArrow: ClassVar[Self]  # 0
    acSplineNoArrow: ClassVar[Self]  # 1
    acLineWithArrow: ClassVar[Self]  # 2
    acSplineWithArrow: ClassVar[Self]  # 3

class AcLineSpacingStyle(_BoostPythonEnum):
    acLineSpacingStyleAtLeast: ClassVar[Self]  # 1
    acLineSpacingStyleExactly: ClassVar[Self]  # 2

class AcLineWeight(_BoostPythonEnum):
    acLnWt000: ClassVar[Self]  # 0
    acLnWt005: ClassVar[Self]  # 5
    acLnWt009: ClassVar[Self]  # 9
    acLnWt013: ClassVar[Self]  # 13
    acLnWt015: ClassVar[Self]  # 15
    acLnWt018: ClassVar[Self]  # 18
    acLnWt020: ClassVar[Self]  # 20
    acLnWt025: ClassVar[Self]  # 25
    acLnWt030: ClassVar[Self]  # 30
    acLnWt035: ClassVar[Self]  # 35
    acLnWt040: ClassVar[Self]  # 40
    acLnWt050: ClassVar[Self]  # 50
    acLnWt053: ClassVar[Self]  # 53
    acLnWt060: ClassVar[Self]  # 60
    acLnWt070: ClassVar[Self]  # 70
    acLnWt080: ClassVar[Self]  # 80
    acLnWt090: ClassVar[Self]  # 90
    acLnWt100: ClassVar[Self]  # 100
    acLnWt106: ClassVar[Self]  # 106
    acLnWt120: ClassVar[Self]  # 120
    acLnWt140: ClassVar[Self]  # 140
    acLnWt158: ClassVar[Self]  # 158
    acLnWt200: ClassVar[Self]  # 200
    acLnWt211: ClassVar[Self]  # 211
    acLnWtByLayer: ClassVar[Self]  # -1
    acLnWtByBlock: ClassVar[Self]  # -2
    acLnWtByLwDefault: ClassVar[Self]  # -3

class AcLoopType(_BoostPythonEnum):
    acHatchLoopTypeDefault: ClassVar[Self]  # 0
    acHatchLoopTypeExternal: ClassVar[Self]  # 1
    acHatchLoopTypePolyline: ClassVar[Self]  # 2
    acHatchLoopTypeDerived: ClassVar[Self]  # 4
    acHatchLoopTypeTextbox: ClassVar[Self]  # 8

class AcMLeaderContentType(_BoostPythonEnum):
    acNoneContent: ClassVar[Self]  # 0
    acBlockContent: ClassVar[Self]  # 1
    acMTextContent: ClassVar[Self]  # 2

class AcMLeaderType(_BoostPythonEnum):
    acStraightLeader: ClassVar[Self]  # 1
    acSplineLeader: ClassVar[Self]  # 2
    acInVisibleLeader: ClassVar[Self]  # 0

class AcMLineJustification(_BoostPythonEnum):
    acTop: ClassVar[Self]  # 0
    acZero: ClassVar[Self]  # 1
    acBottom: ClassVar[Self]  # 2

class AcMenuFileType(_BoostPythonEnum):
    acMenuFileCompiled: ClassVar[Self]  # 0
    acMenuFileSource: ClassVar[Self]  # 1

class AcMenuGroupType(_BoostPythonEnum):
    acBaseMenuGroup: ClassVar[Self]  # 0
    acPartialMenuGroup: ClassVar[Self]  # 1

class AcMenuItemType(_BoostPythonEnum):
    acMenuItem: ClassVar[Self]  # 0
    acMenuSeparator: ClassVar[Self]  # 1
    acMenuSubMenu: ClassVar[Self]  # 2

class AcMergeCellStyleOption(_BoostPythonEnum):
    acMergeCellStyleNone: ClassVar[Self]  # 0
    acMergeCellStyleCopyDuplicates: ClassVar[Self]  # 1
    acMergeCellStyleOverwriteDuplicates: ClassVar[Self]  # 2
    acMergeCellStyleConvertDuplicatesToOverrides: ClassVar[Self]  # 4
    acMergeCellStyleIgnoreNewStyles: ClassVar[Self]  # 8

class AcOleQuality(_BoostPythonEnum):
    acOQLineArt: ClassVar[Self]  # 0
    acOQText: ClassVar[Self]  # 1
    acOQGraphics: ClassVar[Self]  # 2
    acOQPhoto: ClassVar[Self]  # 3
    acOQHighPhoto: ClassVar[Self]  # 4

class AcParseOption(_BoostPythonEnum):
    acParseOptionNone: ClassVar[Self]  # 0
    acSetDefaultFormat: ClassVar[Self]  # 1
    acPreserveMtextFormat: ClassVar[Self]  # 2

class AcPatternType(_BoostPythonEnum):
    acHatchPatternTypeUserDefined: ClassVar[Self]  # 0
    acHatchPatternTypePreDefined: ClassVar[Self]  # 1
    acHatchPatternTypeCustomDefined: ClassVar[Self]  # 2

class AcPlotPaperUnits(_BoostPythonEnum):
    acInches: ClassVar[Self]  # 0
    acMillimeters: ClassVar[Self]  # 1
    acPixels: ClassVar[Self]  # 2

class AcPlotRotation(_BoostPythonEnum):
    ac0degrees: ClassVar[Self]  # 0
    ac90degrees: ClassVar[Self]  # 1
    ac180degrees: ClassVar[Self]  # 2
    ac270degrees: ClassVar[Self]  # 3

class AcPlotScale(_BoostPythonEnum):
    acScaleToFit: ClassVar[Self]  # 0
    ac1_128in_1f: ClassVar[Self]  # 1
    ac1_64in_1ft: ClassVar[Self]  # 2
    ac1_32in_1ft: ClassVar[Self]  # 3
    ac1_16in_1ft: ClassVar[Self]  # 4
    ac3_32in_1ft: ClassVar[Self]  # 5
    ac1_8in_1ft: ClassVar[Self]  # 6
    ac3_16in_1ft: ClassVar[Self]  # 7
    ac1_4in_1ft: ClassVar[Self]  # 8
    ac3_8in_1ft: ClassVar[Self]  # 9
    ac1_2in_1ft: ClassVar[Self]  # 10
    ac3_4in_1ft: ClassVar[Self]  # 11
    ac1in_1ft: ClassVar[Self]  # 12
    ac3in_1ft: ClassVar[Self]  # 13
    ac6in_1ft: ClassVar[Self]  # 14
    ac1ft_1ft: ClassVar[Self]  # 15
    ac1_1: ClassVar[Self]  # 16
    ac1_2: ClassVar[Self]  # 17
    ac1_4: ClassVar[Self]  # 18
    ac1_5: ClassVar[Self]  # 19
    ac1_8: ClassVar[Self]  # 20
    ac1_10: ClassVar[Self]  # 21
    ac1_16: ClassVar[Self]  # 22
    ac1_20: ClassVar[Self]  # 23
    ac1_30: ClassVar[Self]  # 24
    ac1_40: ClassVar[Self]  # 25
    ac1_50: ClassVar[Self]  # 26
    ac1_100: ClassVar[Self]  # 27
    ac2_1: ClassVar[Self]  # 28
    ac4_1: ClassVar[Self]  # 29
    ac8_1: ClassVar[Self]  # 30
    ac10_1: ClassVar[Self]  # 31
    ac100_1: ClassVar[Self]  # 32

class AcPlotType(_BoostPythonEnum):
    acDisplay: ClassVar[Self]  # 0
    acExtents: ClassVar[Self]  # 1
    acLimits: ClassVar[Self]  # 2
    acView: ClassVar[Self]  # 3
    acWindow: ClassVar[Self]  # 4
    acLayout: ClassVar[Self]  # 5

class AcPolylineType(_BoostPythonEnum):
    acSimplePoly: ClassVar[Self]  # 0
    acFitCurvePoly: ClassVar[Self]  # 1
    acQuadSplinePoly: ClassVar[Self]  # 2
    acCubicSplinePoly: ClassVar[Self]  # 3

class AcPolymeshType(_BoostPythonEnum):
    acSimpleMesh: ClassVar[Self]  # 0
    acQuadSurfaceMesh: ClassVar[Self]  # 5
    acCubicSurfaceMesh: ClassVar[Self]  # 6
    acBezierSurfaceMesh: ClassVar[Self]  # 8

class AcPredefBlockType(_BoostPythonEnum):
    acBlockImperial: ClassVar[Self]  # 0
    acBlockSlot: ClassVar[Self]  # 1
    acBlockCircle: ClassVar[Self]  # 2
    acBlockBox: ClassVar[Self]  # 3
    acBlockHexagon: ClassVar[Self]  # 4
    acBlockTriangle: ClassVar[Self]  # 5
    acBlockUserDefined: ClassVar[Self]  # 6

class AcPreviewMode(_BoostPythonEnum):
    acPartialPreview: ClassVar[Self]  # 0
    acFullPreview: ClassVar[Self]  # 1

class AcPrinterSpoolAlert(_BoostPythonEnum):
    acPrinterAlwaysAlert: ClassVar[Self]  # 0
    acPrinterAlertOnce: ClassVar[Self]  # 1
    acPrinterNeverAlertLogOnce: ClassVar[Self]  # 2
    acPrinterNeverAlert: ClassVar[Self]  # 3

class AcProxyImage(_BoostPythonEnum):
    acProxyNotShow: ClassVar[Self]  # 0
    acProxyShow: ClassVar[Self]  # 1
    acProxyBoundingBox: ClassVar[Self]  # 2

class AcRegenType(_BoostPythonEnum):
    acActiveViewport: ClassVar[Self]  # 0
    acAllViewports: ClassVar[Self]  # 1

class AcRotationAngle(_BoostPythonEnum):
    acDegreesUnknown: ClassVar[Self]  # -1
    acDegrees000: ClassVar[Self]  # 0
    acDegrees180: ClassVar[Self]  # 2
    acDegrees270: ClassVar[Self]  # 3

class AcRowType(_BoostPythonEnum):
    acUnknownRow: ClassVar[Self]  # 0
    acDataRow: ClassVar[Self]  # 1
    acTitleRow: ClassVar[Self]  # 2
    acHeaderRow: ClassVar[Self]  # 4

class AcSaveAsType(_BoostPythonEnum):
    acUnknown: ClassVar[Self]  # -1
    acR12_dxf: ClassVar[Self]  # 1
    acR13_dwg: ClassVar[Self]  # 4
    acR13_dxf: ClassVar[Self]  # 5
    acR14_dwg: ClassVar[Self]  # 8
    acR14_dxf: ClassVar[Self]  # 9
    ac2000_dwg: ClassVar[Self]  # 12
    ac2000_dxf: ClassVar[Self]  # 13
    ac2000_Template: ClassVar[Self]  # 14
    ac2004_dwg: ClassVar[Self]  # 24
    ac2004_dxf: ClassVar[Self]  # 25
    ac2004_Template: ClassVar[Self]  # 26
    ac2007_dwg: ClassVar[Self]  # 36
    ac2007_dxf: ClassVar[Self]  # 37
    ac2007_Template: ClassVar[Self]  # 38
    ac2010_dwg: ClassVar[Self]  # 48
    ac2010_dxf: ClassVar[Self]  # 49
    ac2010_Template: ClassVar[Self]  # 50
    ac2013_dwg: ClassVar[Self]  # 60
    ac2013_dxf: ClassVar[Self]  # 61
    ac2013_Template: ClassVar[Self]  # 62
    ac2018_dwg: ClassVar[Self]  # 64
    ac2018_dxf: ClassVar[Self]  # 65
    ac2018_Template: ClassVar[Self]  # 66
    acNative: ClassVar[Self]  # 64
    acR15_dwg: ClassVar[Self]  # 12
    acR15_dxf: ClassVar[Self]  # 13
    acR15_Template: ClassVar[Self]  # 14
    acR18_dwg: ClassVar[Self]  # 24
    acR18_dxf: ClassVar[Self]  # 25
    acR18_Template: ClassVar[Self]  # 26

class AcSectionGeneration(_BoostPythonEnum):
    acSectionGenerationSourceAllObjects: ClassVar[Self]  # 1
    acSectionGenerationSourceSelectedObjects: ClassVar[Self]  # 2
    acSectionGenerationDestinationNewBlock: ClassVar[Self]  # 16
    acSectionGenerationDestinationReplaceBlock: ClassVar[Self]  # 32
    acSectionGenerationDestinationFile: ClassVar[Self]  # 64

class AcSectionState(_BoostPythonEnum):
    acSectionStatePlane: ClassVar[Self]  # 1
    acSectionStateBoundary: ClassVar[Self]  # 2
    acSectionStateVolume: ClassVar[Self]  # 4

class AcSectionSubItem(_BoostPythonEnum):
    acSectionSubItemkNone: ClassVar[Self]  # 0
    acSectionSubItemSectionLine: ClassVar[Self]  # 1
    acSectionSubItemSectionLineTop: ClassVar[Self]  # 2
    acSectionSubItemSectionLineBottom: ClassVar[Self]  # 4
    acSectionSubItemBackLine: ClassVar[Self]  # 8
    acSectionSubItemBackLineTop: ClassVar[Self]  # 16
    acSectionSubItemBackLineBottom: ClassVar[Self]  # 32
    acSectionSubItemVerticalLineTop: ClassVar[Self]  # 64
    acSectionSubItemVerticalLineBottom: ClassVar[Self]  # 128

class AcSectionType(_BoostPythonEnum):
    acSectionTypeLiveSection: ClassVar[Self]  # 1
    acSectionType2dSection: ClassVar[Self]  # 2
    acSectionType3dSection: ClassVar[Self]  # 4

class AcSegmentAngleType(_BoostPythonEnum):
    acDegreesAny: ClassVar[Self]  # 0
    acDegrees15: ClassVar[Self]  # 1
    acDegrees30: ClassVar[Self]  # 2
    acDegrees45: ClassVar[Self]  # 3
    acDegrees60: ClassVar[Self]  # 4
    acDegrees90: ClassVar[Self]  # 6
    acDegreesHorz: ClassVar[Self]  # 12

class AcSelect(_BoostPythonEnum):
    acSelectionSetWindow: ClassVar[Self]  # 0
    acSelectionSetCrossing: ClassVar[Self]  # 1
    acSelectionSetFence: ClassVar[Self]  # 2
    acSelectionSetLast: ClassVar[Self]  # 4
    acSelectionSetAll: ClassVar[Self]  # 5
    acSelectionSetWindowPolygon: ClassVar[Self]  # 6
    acSelectionSetCrossingPolygon: ClassVar[Self]  # 7

class AcSelectType(_BoostPythonEnum):
    acTableSelectWindow: ClassVar[Self]  # 1
    acTableSelectCrossing: ClassVar[Self]  # 2

class AcSplineFrameType(_BoostPythonEnum):
    acShow: ClassVar[Self]  # 0
    acHide: ClassVar[Self]  # 1

class AcSplineKnotParameterizationType(_BoostPythonEnum):
    acChord: ClassVar[Self]  # 0
    acSqrtChord: ClassVar[Self]  # 1
    acUniformParam: ClassVar[Self]  # 2
    acCustomParameterization: ClassVar[Self]  # 15

class AcSplineMethodType(_BoostPythonEnum):
    acFit: ClassVar[Self]  # 0
    acControlVertices: ClassVar[Self]  # 1

class AcTableDirection(_BoostPythonEnum):
    acTableTopToBottom: ClassVar[Self]  # 0
    acTableBottomToTop: ClassVar[Self]  # 1

class AcTableFlowDirection(_BoostPythonEnum):
    acTableFlowRight: ClassVar[Self]  # 1
    acTableFlowDownOrUp: ClassVar[Self]  # 2
    acTableFlowLeft: ClassVar[Self]  # 4

class AcTextAlignmentType(_BoostPythonEnum):
    acLeftAlignment: ClassVar[Self]  # 0
    acCenterAlignment: ClassVar[Self]  # 1
    acRightAlignment: ClassVar[Self]  # 2

class AcTextAngleType(_BoostPythonEnum):
    acInsertAngle: ClassVar[Self]  # 0
    acHorizontalAngle: ClassVar[Self]  # 1
    acAlwaysRightReadingAngle: ClassVar[Self]  # 2

class AcTextAttachmentDirection(_BoostPythonEnum):
    acAttachmentHorizontal: ClassVar[Self]  # 0
    acAttachmentVertical: ClassVar[Self]  # 1

class AcTextAttachmentType(_BoostPythonEnum):
    acAttachmentTopOfTop: ClassVar[Self]  # 0
    acAttachmentMiddleOfTop: ClassVar[Self]  # 1
    acAttachmentBottomOfTop: ClassVar[Self]  # 2
    acAttachmentBottomOfTopLine: ClassVar[Self]  # 3
    acAttachmentMiddle: ClassVar[Self]  # 4
    acAttachmentMiddleOfBottom: ClassVar[Self]  # 5
    acAttachmentBottomOfBottom: ClassVar[Self]  # 6
    acAttachmentBottomLine: ClassVar[Self]  # 7
    acAttachmentAllLine: ClassVar[Self]  # 8

class AcTextFontStyle(_BoostPythonEnum):
    acFontRegular: ClassVar[Self]  # 0
    acFontItalic: ClassVar[Self]  # 1
    acFontBold: ClassVar[Self]  # 2
    acFontBoldItalic: ClassVar[Self]  # 3

class AcToolbarDockStatus(_BoostPythonEnum):
    acToolbarDockTop: ClassVar[Self]  # 0
    acToolbarDockBottom: ClassVar[Self]  # 1
    acToolbarDockLeft: ClassVar[Self]  # 2
    acToolbarDockRight: ClassVar[Self]  # 3
    acToolbarFloating: ClassVar[Self]  # 4

class AcToolbarItemType(_BoostPythonEnum):
    acToolbarButton: ClassVar[Self]  # 0
    acToolbarSeparator: ClassVar[Self]  # 1
    acToolbarControl: ClassVar[Self]  # 2
    acToolbarFlyout: ClassVar[Self]  # 3

class AcUnits(_BoostPythonEnum):
    acDefaultUnits: ClassVar[Self]  # -1
    acScientific: ClassVar[Self]  # 1
    acDecimal: ClassVar[Self]  # 2
    acEngineering: ClassVar[Self]  # 3
    acArchitectural: ClassVar[Self]  # 4
    acFractional: ClassVar[Self]  # 5

class AcValueDataType(_BoostPythonEnum):
    acUnknownDataType: ClassVar[Self]  # 0
    acLong: ClassVar[Self]  # 1
    acDouble: ClassVar[Self]  # 2
    acString: ClassVar[Self]  # 4
    acDate: ClassVar[Self]  # 8
    acPoint2d: ClassVar[Self]  # 16
    acPoint3d: ClassVar[Self]  # 32
    acObjectId: ClassVar[Self]  # 64
    acBuffer: ClassVar[Self]  # 128
    acResbuf: ClassVar[Self]  # 256
    acGeneral: ClassVar[Self]  # 512

class AcValueUnitType(_BoostPythonEnum):
    acUnitless: ClassVar[Self]  # 0
    acUnitDistance: ClassVar[Self]  # 1
    acUnitAngle: ClassVar[Self]  # 2
    acUnitArea: ClassVar[Self]  # 4
    acUnitVolume: ClassVar[Self]  # 8

class AcVerticalAlignment(_BoostPythonEnum):
    acVerticalAlignmentBaseline: ClassVar[Self]  # 0
    acVerticalAlignmentBottom: ClassVar[Self]  # 1
    acVerticalAlignmentMiddle: ClassVar[Self]  # 2
    acVerticalAlignmentTop: ClassVar[Self]  # 3

class AcVerticalTextAttachmentType(_BoostPythonEnum):
    acAttachmentCenter: ClassVar[Self]  # 0
    acAttachmentLinedCenter: ClassVar[Self]  # 1

class AcViewportScale(_BoostPythonEnum):
    acVpScaleToFit: ClassVar[Self]  # 0
    acVpCustomScale: ClassVar[Self]  # 1
    acVp1_1: ClassVar[Self]  # 2
    acVp1_2: ClassVar[Self]  # 3
    acVp1_4: ClassVar[Self]  # 4
    acVp1_5: ClassVar[Self]  # 5
    acVp1_8: ClassVar[Self]  # 6
    acVp1_10: ClassVar[Self]  # 7
    acVp1_16: ClassVar[Self]  # 8
    acVp1_20: ClassVar[Self]  # 9
    acVp1_30: ClassVar[Self]  # 10
    acVp1_40: ClassVar[Self]  # 11
    acVp1_50: ClassVar[Self]  # 12
    acVp1_100: ClassVar[Self]  # 13
    acVp2_1: ClassVar[Self]  # 14
    acVp4_1: ClassVar[Self]  # 15
    acVp8_1: ClassVar[Self]  # 16
    acVp10_1: ClassVar[Self]  # 17
    acVp100_1: ClassVar[Self]  # 18
    acVp1_128in_1ft: ClassVar[Self]  # 19
    acVp1_64in_1ft: ClassVar[Self]  # 20
    acVp1_32in_1ft: ClassVar[Self]  # 21
    acVp1_16in_1ft: ClassVar[Self]  # 22
    acVp3_32in_1ft: ClassVar[Self]  # 23
    acVp1_8in_1ft: ClassVar[Self]  # 24
    acVp3_16in_1ft: ClassVar[Self]  # 25
    acVp1_4in_1ft: ClassVar[Self]  # 26
    acVp3_8in_1ft: ClassVar[Self]  # 27
    acVp1_2in_1ft: ClassVar[Self]  # 28
    acVp3_4in_1ft: ClassVar[Self]  # 29
    acVp1in_1ft: ClassVar[Self]  # 30
    acVp1and1_2in_1ft: ClassVar[Self]  # 31
    acVp3in_1ft: ClassVar[Self]  # 32
    acVp6in_1ft: ClassVar[Self]  # 33
    acVp1ft_1ft: ClassVar[Self]  # 34

class AcViewportSplitType(_BoostPythonEnum):
    acViewport2Horizontal: ClassVar[Self]  # 0
    acViewport2Vertical: ClassVar[Self]  # 1
    acViewport3Left: ClassVar[Self]  # 2
    acViewport3Right: ClassVar[Self]  # 3
    acViewport3Horizontal: ClassVar[Self]  # 4
    acViewport3Vertical: ClassVar[Self]  # 5
    acViewport3Above: ClassVar[Self]  # 6
    acViewport3Below: ClassVar[Self]  # 7
    acViewport4: ClassVar[Self]  # 8

class AcWindowState(_BoostPythonEnum):
    acNorm: ClassVar[Self]  # 1
    acMin: ClassVar[Self]  # 2
    acMax: ClassVar[Self]  # 3

class AcXRefDemandLoad(_BoostPythonEnum):
    acDemandLoadDisabled: ClassVar[Self]  # 0
    acDemandLoadEnabled: ClassVar[Self]  # 1
    acDemandLoadEnabledWithCopy: ClassVar[Self]  # 2

class AcZoomScaleType(_BoostPythonEnum):
    acZoomScaledAbsolute: ClassVar[Self]  # 0
    acZoomScaledRelative: ClassVar[Self]  # 1
    acZoomScaledRelativePSpace: ClassVar[Self]  # 2

class Acad3DFace(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> Acad3DFace: ...
    @staticmethod
    def className() -> str: ...
    def coordinate(self, index: int, /) -> PyGe.Point3d: ...
    def coordinates(self, /) -> list[PyGe.point3d]: ...
    def invisibleEdge(self, index: int, /) -> bool: ...
    def setCoordinate(self, index: int, point: PyGe.Point3d, /) -> None: ...
    def setCoordinates(
        self, p1: PyGe.Point3d, p2: PyGe.Point3d, p3: PyGe.Point3d, p4: PyGe.Point3d, /
    ) -> None: ...
    def setInvisibleEdge(self, index: int, flag: bool, /) -> None: ...

class Acad3DPolyline(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def appendVertex(self, vertex: PyGe.Point3d, /) -> None: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> Acad3DPolyline: ...
    @staticmethod
    def className() -> str: ...
    def coordinate(self, index: int, /) -> PyGe.Point3d: ...
    def coordinates(self, /) -> list[PyGe.Point3d]: ...
    def explode(self, /) -> list[PyAx.AcadEntity]: ...
    def getType(self, /) -> Ac3DPolylineType: ...
    def isClosed(self, /) -> bool: ...
    def length(self, /) -> float: ...
    def setClosed(self, val: bool, /) -> None: ...
    def setCoordinate(self, index: int, point: PyGe.Point3d, /) -> None: ...
    def setCoordinates(self, coords: Collection[PyGe.Point3d], /) -> None: ...
    def setType(self, val: PyAx.Ac3DPolylineType, /) -> None: ...

class Acad3DSolid(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def boolean(self, val: PyAx.AcBooleanType, solid: PyAx.Acad3DSolid, /) -> None: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> Acad3DSolid: ...
    def centroid(self, /) -> PyGe.Point3d: ...
    def checkInterference(
        self, solid: PyAx.Acad3DSolid, createInterferenceSolid: bool, /
    ) -> tuple[bool, PyAx.Acad3DSolid]: ...
    @staticmethod
    def className() -> str: ...
    def history(self, /) -> bool: ...
    def momentOfInertia(self, /) -> PyGe.Point3d: ...
    def position(self, /) -> PyGe.Point3d: ...
    def principalDirections(self, /) -> tuple[PyGe.Vector3d, PyGe.Vector3d, PyGe.Vector3d]: ...
    def principalMoments(self, /) -> PyGe.Point3d: ...
    def productOfInertia(self, /) -> PyGe.Point3d: ...
    def radiiOfGyration(self, /) -> PyGe.Point3d: ...
    def sectionSolid(
        self, p1: PyGe.GePoint3d, p2: PyGe.GePoint3d, p3: PyGe.GePoint3d, /
    ) -> AcadRegion: ...
    def setHistory(self, val: bool, /) -> None: ...
    def setPosition(self, val: PyGe.GePoint3d, /) -> None: ...
    def setShowHistory(self, val: bool, /) -> None: ...
    def showHistory(self, /) -> bool: ...
    def sliceSolid(
        self, p1: PyGe.GePoint3d, p2: PyGe.GePoint3d, p3: PyGe.GePoint3d, negative: bool, /
    ) -> Acad3DSolid: ...
    def solidType(self, /) -> str: ...
    def volume(self, /) -> float: ...

class AcadAcCmColor:
    @overload
    def __init__(self, /) -> None: ...
    @overload
    def __init__(self, r: int, g: int, b: int, /) -> None: ...
    @overload
    def __init__(self, *args) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def blue(self, /) -> int: ...
    def bookName(self, /) -> str: ...
    @staticmethod
    def className() -> str: ...
    def clear(self, /) -> None: ...
    def colorIndex(self, /) -> AcColor: ...
    def colorMethod(self, /) -> AcColorMethod: ...
    def colorName(self, /) -> str: ...
    def entityColor(self, /) -> int: ...
    def green(self, /) -> int: ...
    def red(self, /) -> int: ...
    def setColorBookColor(self, colorName: str, bookName: str, /) -> None: ...
    def setColorIndex(self, flags: PyAx.AcColor, /) -> None: ...
    def setColorMethod(self, flags: PyAx.AcColorMethod, /) -> None: ...
    def setEntityColor(self, val: int, /) -> None: ...
    def setNames(self, colorName: str, bookName: str, /) -> None: ...
    def setRGB(self, red: int, green: int, blue: int, /) -> None: ...

class AcadApplication:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def acadState(self, /) -> AcadState: ...
    def activeDocument(self, /) -> AcadDocument: ...
    def caption(self, /) -> str: ...
    @staticmethod
    def className() -> str: ...
    def documents(self, /) -> AcadDocuments: ...
    def eval(self, sval: str, /) -> None: ...
    def fullName(self, /) -> str: ...
    def getHWND(self, /) -> int: ...
    def getHeight(self, /) -> int: ...
    def getName(self, /) -> str: ...
    def getPath(self, /) -> str: ...
    def getWidth(self, /) -> int: ...
    def getWindowLeft(self, /) -> int: ...
    def getWindowState(self, /) -> AcWindowState: ...
    def getWindowTop(self, /) -> int: ...
    def isVisible(self, /) -> bool: ...
    def listArx(self, /) -> list[str]: ...
    def loadArx(self, arx: str, /) -> None: ...
    def loadDVB(self, dvb: str, /) -> None: ...
    def localeId(self, /) -> int: ...
    def menuBar(self, /) -> AcadMenuBar: ...
    def menuGroups(self, /) -> AcadMenuGroups: ...
    def preferences(self, /) -> AcadPreferences: ...
    def quit(self, /) -> None: ...
    def runMacro(self, macro: str, /) -> None: ...
    def setActiveDocument(self, doc: PyAx.AcadDocument, /) -> None: ...
    def setCaption(self, caption: str, /) -> None: ...
    def setHeight(self, height: int, /) -> None: ...
    def setVisible(self, visible: bool, /) -> None: ...
    def setWidth(self, width: int, /) -> None: ...
    def setWindowLeft(self, left: int, /) -> None: ...
    def setWindowState(self, state: PyAx.AcWindowState, /) -> None: ...
    def setWindowTop(self, top: int, /) -> None: ...
    def unloadArx(self, arx: str, /) -> None: ...
    def unloadDVB(self, dvb: str, /) -> None: ...
    def update(self, /) -> None: ...
    def version(self, /) -> str: ...
    def zoomAll(self, /) -> None: ...
    def zoomCenter(self, pt: PyGe.Point3d, magnify: float, /) -> None: ...
    def zoomExtents(self, /) -> None: ...
    def zoomPickWindow(self, /) -> None: ...
    def zoomPrevious(self, /) -> None: ...
    def zoomScaled(self, magnify: float, scaletype: PyAx.AcZoomScaleType, /) -> None: ...

class AcadArc(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def arcLength(self, /) -> float: ...
    def area(self, /) -> float: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadArc: ...
    def center(self, /) -> PyGe.Point3d: ...
    @staticmethod
    def className() -> str: ...
    def endAngle(self, /) -> float: ...
    def endPoint(self, /) -> PyGe.Point3d: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def offset(self, val: float, /) -> list[PyAx.AcadEntity]: ...
    def radius(self, /) -> float: ...
    def setCenter(self, val: PyGe.Point3d, /) -> None: ...
    def setNormal(self, val: PyGe.Vector3d, /) -> None: ...
    def setRadius(self, val: float, /) -> None: ...
    def setStartAngle(self, val: float, /) -> None: ...
    def setThickness(self, val: float, /) -> None: ...
    def startAngle(self, /) -> float: ...
    def startPoint(self, /) -> PyGe.Point3d: ...
    def thickness(self, /) -> float: ...
    def totalAngle(self, /) -> float: ...

class AcadAttribute(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def alignment(self, /) -> AcAlignment: ...
    def backward(self, /) -> bool: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadAttribute: ...
    @staticmethod
    def className() -> str: ...
    def constant(self, /) -> bool: ...
    def fieldLength(self, /) -> int: ...
    def height(self, /) -> float: ...
    def horizontalAlignment(self, /) -> AcHorizontalAlignment: ...
    def insertionPoint(self, /) -> PyGe.Point3d: ...
    def invisible(self, /) -> bool: ...
    def isMTextAttribute(self, /) -> bool: ...
    def lockPosition(self, /) -> bool: ...
    def mode(self, /) -> int: ...
    def mtextAttributeContent(self, /) -> str: ...
    def mtextBoundaryWidth(self, /) -> float: ...
    def mtextDrawingDirection(self, /) -> AcDrawingDirection: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def obliqueAngle(self, /) -> float: ...
    def preset(self, /) -> bool: ...
    def promptString(self, /) -> str: ...
    def rotation(self, /) -> float: ...
    def scaleFactor(self, /) -> float: ...
    def setAlignment(self, val: PyAx.AcAlignment, /) -> None: ...
    def setBackward(self, val: bool, /) -> None: ...
    def setConstant(self, val: bool, /) -> None: ...
    def setFieldLength(self, val: int, /) -> None: ...
    def setHeight(self, val: float, /) -> None: ...
    def setHorizontalAlignment(self, val: PyAx.AcHorizontalAlignment, /) -> None: ...
    def setInsertionPoint(self, val: PyGe.Point3d, /) -> None: ...
    def setInvisible(self, val: bool, /) -> None: ...
    def setIsMTextAttribute(self, val: bool, /) -> None: ...
    def setLockPosition(self, val: bool, /) -> None: ...
    def setMTextAttributeContent(self, val: str, /) -> None: ...
    def setMTextBoundaryWidth(self, val: float, /) -> None: ...
    def setMTextDrawingDirection(self, val: PyAx.AcDrawingDirection, /) -> None: ...
    def setMode(self, val: int, /) -> None: ...
    def setNormal(self, val: PyGe.Vector3d, /) -> None: ...
    def setPreset(self, val: bool, /) -> None: ...
    def setPromptString(self, val: str, /) -> None: ...
    def setRotation(self, val: float, /) -> None: ...
    def setScaleFactor(self, val: float, /) -> None: ...
    def setStyleName(self, val: str, /) -> None: ...
    def setTagString(self, val: str, /) -> None: ...
    def setTextAlignmentPoint(self, val: PyGe.Point3d, /) -> None: ...
    def setTextGenerationFlag(self, val: int, /) -> None: ...
    def setTextString(self, val: str, /) -> None: ...
    def setThickness(self, val: float, /) -> None: ...
    def setUpsideDown(self, val: bool, /) -> None: ...
    def setVerify(self, val: bool, /) -> None: ...
    def setVerticalAlignment(self, val: PyAx.AcVerticalAlignment, /) -> None: ...
    def styleName(self, /) -> str: ...
    def tagString(self, /) -> str: ...
    def textAlignmentPoint(self, val: float, /) -> PyGe.Point3d: ...
    def textGenerationFlag(self, /) -> int: ...
    def textString(self, /) -> str: ...
    def thickness(self, /) -> float: ...
    def updateMTextAttribute(self, /) -> None: ...
    def upsideDown(self, /) -> bool: ...
    def verify(self, /) -> bool: ...
    def verticalAlignment(self, /) -> AcVerticalAlignment: ...

class AcadAttributeReference(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def alignment(self, /) -> AcAlignment: ...
    def backward(self, /) -> bool: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadAttributeReference: ...
    @staticmethod
    def className() -> str: ...
    def constant(self, /) -> bool: ...
    def fieldLength(self, /) -> int: ...
    def height(self, /) -> float: ...
    def horizontalAlignment(self, /) -> AcHorizontalAlignment: ...
    def insertionPoint(self, /) -> PyGe.Point3d: ...
    def invisible(self, /) -> bool: ...
    def isMTextAttribute(self, /) -> bool: ...
    def lockPosition(self, /) -> bool: ...
    def mtextAttributeContent(self, /) -> str: ...
    def mtextBoundaryWidth(self, /) -> float: ...
    def mtextDrawingDirection(self, /) -> AcDrawingDirection: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def obliqueAngle(self, /) -> float: ...
    def rotation(self, /) -> float: ...
    def scaleFactor(self, /) -> float: ...
    def setAlignment(self, val: PyAx.AcAlignment, /) -> None: ...
    def setBackward(self, val: bool, /) -> None: ...
    def setFieldLength(self, val: int, /) -> None: ...
    def setHeight(self, val: float, /) -> None: ...
    def setHorizontalAlignment(self, val: PyAx.AcHorizontalAlignment, /) -> None: ...
    def setInsertionPoint(self, val: PyGe.Point3d, /) -> None: ...
    def setInvisible(self, val: bool, /) -> None: ...
    def setIsMTextAttribute(self, val: bool, /) -> None: ...
    def setMTextAttributeContent(self, val: str, /) -> None: ...
    def setMTextBoundaryWidth(self, val: float, /) -> None: ...
    def setMTextDrawingDirection(self, val: PyAx.AcDrawingDirection, /) -> None: ...
    def setNormal(self, val: PyGe.Vector3d, /) -> None: ...
    def setRotation(self, val: float, /) -> None: ...
    def setScaleFactor(self, val: float, /) -> None: ...
    def setStyleName(self, val: str, /) -> None: ...
    def setTagString(self, val: str, /) -> None: ...
    def setTextAlignmentPoint(self, val: PyGe.Point3d, /) -> None: ...
    def setTextGenerationFlag(self, val: int, /) -> None: ...
    def setTextString(self, val: str, /) -> None: ...
    def setThickness(self, val: float, /) -> None: ...
    def setUpsideDown(self, val: bool, /) -> None: ...
    def setVerticalAlignment(self, val: PyAx.AcVerticalAlignment, /) -> None: ...
    def styleName(self, /) -> str: ...
    def tagString(self, /) -> str: ...
    def textAlignmentPoint(self, val: float, /) -> PyGe.Point3d: ...
    def textGenerationFlag(self, /) -> int: ...
    def textString(self, /) -> str: ...
    def thickness(self, /) -> float: ...
    def updateMTextAttribute(self, /) -> None: ...
    def upsideDown(self, /) -> bool: ...
    def verticalAlignment(self, /) -> AcVerticalAlignment: ...

class AcadBlock(PyAx.AcadObject):
    def __getitem__(self, index: int, /) -> AcadEntity: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __iter__(self, /) -> Iterator[PyAx.AcadEntity]: ...
    def __reduce__(self, /) -> Any: ...
    def add3DFace(
        self, p1: PyGe.Point3d, p2: PyGe.Point3d, p3: PyGe.Point3d, p4: PyGe.Point3d, /
    ) -> Acad3DFace: ...
    def add3DMesh(
        self, M: int, N: int, points: Collection[PyGe.Point3d], /
    ) -> AcadPolygonMesh: ...
    def add3DPoly(self, points: Collection[PyGe.Point3d], /) -> Acad3DPolyline: ...
    def addArc(
        self, canter: PyGe.Point3d, radius: float, startAngle: float, endAngle: float, /
    ) -> AcadArc: ...
    def addAttribute(
        self,
        height: float,
        mode: PyAx.AcAttributeMode,
        prompt: str,
        insertionPoint: PyGe.Point3d,
        tag: str,
        value: str,
        /,
    ) -> AcadAttribute: ...
    def addBox(
        self, origin: PyGe.Point3d, length: float, width: float, height: float, /
    ) -> Acad3DSolid: ...
    def addCircle(self, canter: PyGe.Point3d, radius: float, /) -> AcadCircle: ...
    def addCone(
        self, canter: PyGe.Point3d, baseRadius: float, height: float, /
    ) -> Acad3DSolid: ...
    def addCustomObject(self, name: str, /) -> AcadObject: ...
    def addCylinder(
        self, canter: PyGe.Point3d, radius: float, height: float, /
    ) -> Acad3DSolid: ...
    def addDim3PointAngular(
        self,
        angleVertex: PyGe.Point3d,
        firstEndPoint: PyGe.Point3d,
        secondEndPoint: PyGe.Point3d,
        textPosition: PyGe.Point3d,
        /,
    ) -> AcadDim3PointAngular: ...
    def addDimAligned(
        self,
        extLine1Point: PyGe.Point3d,
        extLine2Point: PyGe.Point3d,
        textPosition: PyGe.Point3d,
        /,
    ) -> AcadDimAligned: ...
    def addDimAngular(
        self,
        angleVertex: PyGe.Point3d,
        firstEndPoint: PyGe.Point3d,
        secondEndPoint: PyGe.Point3d,
        textPosition: PyGe.Point3d,
        /,
    ) -> AcadDimAngular: ...
    def addDimArc(
        self,
        arcCenter: PyGe.Point3d,
        firstEndPoint: PyGe.Point3d,
        secondEndPoint: PyGe.Point3d,
        arcPoint: PyGe.Point3d,
        /,
    ) -> AcadDimArcLength: ...
    def addDimDiametric(
        self, chordPoint: PyGe.Point3d, farChordPoint: PyGe.Point3d, leaderLength: float, /
    ) -> AcadDimDiametric: ...
    def addDimOrdinate(
        self, definitionPoint: PyGe.Point3d, leaderEndPoint: PyGe.Point3d, UseXAxis: int, /
    ) -> AcadDimOrdinate: ...
    def addDimRadial(
        self, center: PyGe.Point3d, chordPoint: PyGe.Point3d, leaderLength: float, /
    ) -> AcadDimRadial: ...
    def addDimRadialLarge(
        self,
        center: PyGe.Point3d,
        chordPoint: PyGe.Point3d,
        overrideCenter: PyGe.Point3d,
        jogPoint: PyGe.Point3d,
        jogAngle: float,
        /,
    ) -> AcadDimRadialLarge: ...
    def addDimRotated(
        self,
        extLine1Point: PyGe.Point3d,
        extLine2Point: PyGe.Point3d,
        dimLineLocation: PyGe.Point3d,
        rotationAngle: float,
        /,
    ) -> AcadDimRotated: ...
    def addEllipse(
        self, center: PyGe.Point3d, majorAxis: PyGe.Vector3d, radiusRatio: float, /
    ) -> AcadEllipse: ...
    def addEllipticalCone(
        self, center: PyGe.Point3d, majorRadius: float, minorRadius: float, height: float, /
    ) -> Acad3DSolid: ...
    def addEllipticalCylinder(
        self, center: PyGe.Point3d, majorRadius: float, minorRadius: float, height: float, /
    ) -> Acad3DSolid: ...
    def addExtrudedSolid(
        self, region: PyAx.AcadRegion, height: float, taperAngle: float, /
    ) -> Acad3DSolid: ...
    def addExtrudedSolidAlongPath(
        self, region: PyAx.AcadRegion, path: PyAx.AcadEntity, /
    ) -> Acad3DSolid: ...
    def addHatch(
        self,
        patternType: int,
        patternName: str,
        associativity: bool,
        ht: PyAx.AcHatchObjectType,
        /,
    ) -> AcadHatch: ...
    def addLeader(
        self,
        points: Collection[PyGe.Point3d],
        annotation: PyAx.AcadEntity,
        leaderType: PyAx.AcLeaderType,
        /,
    ) -> AcadLeader: ...
    def addLightWeightPolyline(self, points: Collection[PyGe.Point2d], /) -> AcadLWPolyline: ...
    def addLine(self, startPoint: PyGe.Point3d, endPoint: PyGe.Point3d, /) -> AcadLine: ...
    def addMInsertBlock(
        self,
        point: PyGe.Point3d,
        name: str,
        rotation: float,
        numRows: int,
        numCols: int,
        rowSpacing: int,
        rolumnSpacing: int,
        /,
    ) -> AcadMInsertBlock: ...
    def addMLeader(self, points: Collection[PyGe.Point3d], /) -> AcadMLeader: ...
    def addMLine(self, points: Collection[PyGe.Point3d], /) -> AcadMLine: ...
    def addMText(
        self, insertionPoint: PyGe.Point3d, width: float, textVal: str, /
    ) -> AcadMText: ...
    def addPoint(self, point: PyGe.Point3d, /) -> AcadPoint: ...
    def addPolyfaceMesh(
        self, points: Collection[PyGe.Point3d], faces: Collection[int], /
    ) -> AcadPolyfaceMesh: ...
    def addPolyline(self, points: Collection[PyGe.Point3d], /) -> AcadPolyline: ...
    def addRaster(
        self,
        imageFileName: str,
        insertionPoint: PyGe.Point3d,
        scaleFactor: float,
        rotationAngle: float,
        /,
    ) -> AcadRasterImage: ...
    def addRay(self, p1: PyGe.Point3d, p2: PyGe.Point3d, /) -> AcadRay: ...
    def addRegion(self, curves: PyAx.AcadEntity, /) -> list[PyAx.AcadRegion]: ...
    def addRevolvedSolid(
        self,
        region: PyAx.AcadRegion,
        axisPoint: PyGe.Point3d,
        axisDir: PyGe.Vector3d,
        angle: float,
        /,
    ) -> Acad3DSolid: ...
    def addSection(
        self, fromPoint: PyGe.Point3d, toPoint: PyGe.Point3d, planeVector: PyGe.Vector3d, /
    ) -> AcadSection: ...
    def addShape(
        self, name: str, insertionPoint: PyGe.Point3d, scaleFactor: float, rotationAngle: float, /
    ) -> AcadShape: ...
    def addSolid(
        self, p1: PyGe.Point3d, p2: PyGe.Point3d, p3: PyGe.Point3d, p4: PyGe.Point3d, /
    ) -> AcadSolid: ...
    def addSphere(self, center: PyGe.Point3d, radius: float, /) -> Acad3DSolid: ...
    def addSpline(
        self,
        points: Collection[PyGe.Point3d],
        startTangent: PyGe.Vector3d,
        endTangent: PyGe.Vector3d,
        /,
    ) -> AcadSpline: ...
    def addTable(
        self,
        insertionPoint: PyGe.Point3d,
        numRows: int,
        numColumns: int,
        rowHeight: float,
        colWidth: float,
        /,
    ) -> AcadTable: ...
    def addText(
        self, textValue: str, insertionPoint: PyGe.Point3d, height: float, /
    ) -> AcadText: ...
    def addTolerance(
        self, textValue: str, insertionPoint: PyGe.Point3d, direction: PyGe.Vector3d, /
    ) -> AcadTolerance: ...
    def addTorus(
        self, center: PyGe.Point3d, torusRadius: float, tubeRadius: float, /
    ) -> Acad3DSolid: ...
    def addWedge(
        self, center: PyGe.Point3d, length: float, width: float, height: float, /
    ) -> Acad3DSolid: ...
    def addXline(self, p1: PyGe.Point3d, p2: PyGe.Point3d, /) -> AcadXline: ...
    def attachExternalReference(
        self,
        path: str,
        name: str,
        insertionPoint: PyGe.Point3d,
        scale: PyGe.Scale3d,
        rotation: float,
        bOverlay: bool,
        /,
    ) -> AcadExternalReference: ...
    def bind(self, bPrefixName: bool, /) -> None: ...
    def blockScaling(self, /) -> AcBlockScaling: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadBlock: ...
    @staticmethod
    def className() -> str: ...
    def comments(self, /) -> str: ...
    def count(self, /) -> int: ...
    def detach(self, /) -> None: ...
    def entities(self, /) -> list[PyAx.AcadEntity]: ...
    def insertBlock(
        self, insertionPoint: PyGe.Point3d, name: str, scale: PyGe.Scale3d, rotation: float, /
    ) -> AcadBlockReference: ...
    def isDynamicBlock(self, /) -> bool: ...
    def isExplodable(self, /) -> bool: ...
    def isLayout(self, /) -> bool: ...
    def isXRef(self, /) -> bool: ...
    def item(index: int, /) -> AcadEntity: ...
    def items(self, /) -> list[PyAx.AcadEntity]: ...
    def layout(self, /) -> AcadLayout: ...
    def name(self, /) -> str: ...
    def origin(self, /) -> PyGe.Point3d: ...
    def path(self, /) -> str: ...
    def reload(self, /) -> None: ...
    def setBlockScaling(self, blockScaling: PyAx.AcBlockScaling, /) -> None: ...
    def setComments(self, comments: str, /) -> None: ...
    def setExplodable(self, explodable: bool, /) -> None: ...
    def setName(self, name: str, /) -> None: ...
    def setOrigin(self, origin: PyGe.Point3d, /) -> None: ...
    def setPath(self, path: str, /) -> None: ...
    def setUnits(self, units: PyAx.AcInsertUnits, /) -> None: ...
    def units(self, /) -> AcInsertUnits: ...
    def unload(self, /) -> None: ...
    def xrefDatabase(self, /) -> AcadDatabase: ...

class AcadBlockReference(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def attributes(self, /) -> list[PyAx.AcadAttributeReference]: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadBlockReference: ...
    @staticmethod
    def className() -> str: ...
    def constantAttributes(self, /) -> list[PyAx.AcadAttributeReference]: ...
    def convertToAnonymousBlock(self, /) -> None: ...
    def convertToStaticBlock(self, newBlockName: str, /) -> None: ...
    def dynamicBlockProperties(self, /) -> list[PyAx.AcadDynamicBlockReferenceProperty]: ...
    def effectiveName(self, /) -> str: ...
    def explode(self, /) -> list[PyAx.AcadEntity]: ...
    def hasAttributes(self, /) -> bool: ...
    def insUnits(self, /) -> str: ...
    def insUnitsFactor(self, /) -> float: ...
    def insertionPoint(self, /) -> PyGe.Point3d: ...
    def isDynamicBlock(self, /) -> bool: ...
    def name(self, /) -> str: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def resetBlock(self, /) -> None: ...
    def rotation(self, /) -> float: ...
    def setInsertionPoint(self, val: PyGe.Point3d, /) -> None: ...
    def setName(self, val: str, /) -> None: ...
    def setNormal(self, val: PyGe.Vector3d, /) -> None: ...
    def setRotation(self, val: float, /) -> None: ...
    def setXEffectiveScaleFactor(self, val: float, /) -> None: ...
    def setXScaleFactor(self, val: float, /) -> None: ...
    def setYEffectiveScaleFactor(self, val: float, /) -> None: ...
    def setYScaleFactor(self, val: float, /) -> None: ...
    def setZEffectiveScaleFactor(self, val: float, /) -> None: ...
    def setZScaleFactor(self, val: float, /) -> None: ...
    def xEffectiveScaleFactor(self, /) -> float: ...
    def xScaleFactor(self, /) -> float: ...
    def yEffectiveScaleFactor(self, /) -> float: ...
    def yScaleFactor(self, /) -> float: ...
    def zEffectiveScaleFactor(self, /) -> float: ...
    def zScaleFactor(self, /) -> float: ...

class AcadBlocks(PyAx.AcadObject):
    def __getitem__(self, index: int, /) -> AcadBlock: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __iter__(self, /) -> Iterator[PyAx.AcadBlock]: ...
    def __reduce__(self, /) -> Any: ...
    def add(self, insertionPoint: PyGe.Point3d, name: str, /) -> AcadBlock: ...
    def blocks(self, /) -> list[PyAx.AcadBlock]: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadBlocks: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def has(self, blockName: str, /) -> bool: ...
    def item(index: int, /) -> AcadBlock: ...
    def items(self, /) -> list[PyAx.AcadBlock]: ...

class AcadCircle(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def area(self, /) -> float: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadCircle: ...
    def center(self, /) -> PyGe.Point3d: ...
    def circumference(self, /) -> float: ...
    @staticmethod
    def className() -> str: ...
    def diameter(self, /) -> float: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def offset(self, /) -> list[PyAx.AcadEntity]: ...
    def radius(self, /) -> float: ...
    def setArea(self, val: float, /) -> None: ...
    def setCenter(self, val: PyGe.GePoint3d, /) -> None: ...
    def setCircumference(self, val: float, /) -> None: ...
    def setDiameter(self, val: float, /) -> None: ...
    def setNormal(self, val: PyGe.Vector3d, /) -> None: ...
    def setRadius(self, val: float, /) -> None: ...
    def setThickness(self, val: float, /) -> None: ...
    def thickness(self, /) -> float: ...

class AcadDatabase:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def blocks(self, /) -> AcadBlocks: ...
    @staticmethod
    def className() -> str: ...
    def copyObjects(
        self, objs: list[PyAx.AcadObject], owner: PyAx.AcadObject, /
    ) -> list[PyAx.AcadEntity]: ...
    def dictionaries(self, /) -> AcadDictionaries: ...
    def dimStyles(self, /) -> AcadDimStyles: ...
    def elevationModelSpace(self, /) -> float: ...
    def elevationPaperSpace(self, /) -> float: ...
    def groups(self, /) -> AcadGroups: ...
    def handleToObject(self, val: str, /) -> AcadObject: ...
    def layers(self, /) -> AcadLayers: ...
    def layouts(self, /) -> AcadLayouts: ...
    def limits(self, /) -> tuple[PyGe.Point2d, PyGe.Point2d]: ...
    def lineTypes(self, /) -> AcadLineTypes: ...
    def materials(self, /) -> AcadMaterials: ...
    def modelSpace(self, /) -> ModelSpace: ...
    def objectIdToObject(self, val: PyDb.ObjectId, /) -> AcadObject: ...
    def paperSpace(self, /) -> PaperSpace: ...
    def plotConfigurations(self, /) -> AcadPlotConfigurations: ...
    def preferences(self, /) -> AcadDatabasePreferences: ...
    def registeredApplications(self, /) -> AcadRegisteredApplications: ...
    def sectionManager(self, /) -> AcadSectionManager: ...
    def setElevationModelSpace(self, elev: float, /) -> None: ...
    def setElevationPaperSpace(self, elev: float, /) -> None: ...
    def setLimits(self, minmax: tuple[PyGe.Point2d, PyGe.Point2d], /) -> None: ...
    def summaryInfo(self, /) -> AcadSummaryInfo: ...
    def textStyles(self, /) -> AcadTextStyles: ...
    def userCoordinateSystems(self, /) -> AcadUCSs: ...
    def viewports(self, /) -> AcadViewports: ...
    def views(self, /) -> AcadViews: ...

class AcadDatabasePreferences:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def allowLongSymbolNames(self, /) -> bool: ...
    @staticmethod
    def className() -> str: ...
    def contourLinesPerSurface(self, /) -> int: ...
    def displaySilhouette(self, /) -> bool: ...
    def lineWeightDisplay(self, /) -> bool: ...
    def lineweight(self, /) -> AcLineWeight: ...
    def maxActiveViewports(self, /) -> int: ...
    def objectSortByPSOutput(self, /) -> bool: ...
    def objectSortByPlotting(self, /) -> bool: ...
    def objectSortByRedraws(self, /) -> bool: ...
    def objectSortByRegens(self, /) -> bool: ...
    def objectSortBySelection(self, /) -> bool: ...
    def objectSortBySnap(self, /) -> bool: ...
    def oleLaunch(self, /) -> bool: ...
    def renderSmoothness(self, /) -> float: ...
    def segmentPerPolyline(self, /) -> int: ...
    def setAllowLongSymbolNames(self, val: bool, /) -> None: ...
    def setContourLinesPerSurface(self, val: int, /) -> None: ...
    def setDisplaySilhouette(self, val: bool, /) -> None: ...
    def setLineWeightDisplay(self, val: bool, /) -> None: ...
    def setLineweight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setMaxActiveViewports(self, val: int, /) -> None: ...
    def setOLELaunch(self, val: bool, /) -> None: ...
    def setObjectSortByPSOutput(self, val: bool, /) -> None: ...
    def setObjectSortByPlotting(self, val: bool, /) -> None: ...
    def setObjectSortByRedraws(self, val: bool, /) -> None: ...
    def setObjectSortByRegens(self, val: bool, /) -> None: ...
    def setObjectSortBySelection(self, val: bool, /) -> None: ...
    def setObjectSortBySnap(self, val: bool, /) -> None: ...
    def setRenderSmoothness(self, val: float, /) -> None: ...
    def setSegmentPerPolyline(self, val: int, /) -> None: ...
    def setSolidFill(self, val: bool, /) -> None: ...
    def setTextFrameDisplay(self, val: bool, /) -> None: ...
    def setXRefEdit(self, val: bool, /) -> None: ...
    def setXRefLayerVisibility(self, val: bool, /) -> None: ...
    def solidFill(self, /) -> bool: ...
    def textFrameDisplay(self, /) -> bool: ...
    def xrefEdit(self, /) -> bool: ...
    def xrefLayerVisibility(self, /) -> bool: ...

class AcadDictionaries(PyAx.AcadObject):
    def __getitem__(self, index: int, /) -> AcadDictionary: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __iter__(self, /) -> Iterator[PyAx.AcadDictionary]: ...
    def __reduce__(self, /) -> Any: ...
    def add(self, name: str, /) -> AcadDictionary: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadDictionaries: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, index: int, /) -> AcadDictionary: ...
    def items(self, /) -> list[PyAx.AcadDictionary]: ...

class AcadDictionary(PyAx.AcadObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def addObject(self, keyword: str, objectName: str, /) -> AcadObject: ...
    def addXRecord(self, keyword: str, /) -> AcadXRecord: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadDictionary: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, idx: int, /) -> AcadObject: ...
    def items(self, /) -> list[PyAx.AcadObject]: ...
    def name(self, /) -> str: ...
    def objName(self, val: PyAx.AcadObject, /) -> str: ...
    def object(self, objectName: str, /) -> AcadObject: ...
    def remove(self, objectName: str, /) -> AcadObject: ...
    def rename(self, oldName: str, newName: str, /) -> AcadObject: ...
    def replace(self, oldName: str, obj: PyAx.AcadObject, /) -> None: ...
    def setName(self, val: str, /) -> None: ...

class AcadDim3PointAngular(PyAx.AcadDimension):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def angleFormat(self, /) -> AcAngleUnits: ...
    def angleVertex(self, /) -> PyGe.Point3d: ...
    def arrowhead1Block(self, /) -> str: ...
    def arrowhead1Type(self, /) -> AcDimArrowheadType: ...
    def arrowhead2Block(self, /) -> str: ...
    def arrowhead2Type(self, /) -> AcDimArrowheadType: ...
    def arrowheadSize(self, /) -> float: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadDim3PointAngular: ...
    @staticmethod
    def className() -> str: ...
    def dimConstrDesc(self, /) -> str: ...
    def dimConstrExpression(self, /) -> str: ...
    def dimConstrForm(self, /) -> bool: ...
    def dimConstrName(self, /) -> str: ...
    def dimConstrReference(self, /) -> bool: ...
    def dimConstrValue(self, /) -> str: ...
    def dimLine1Suppress(self, /) -> bool: ...
    def dimLine2Suppress(self, /) -> bool: ...
    def dimLineInside(self, /) -> bool: ...
    def dimensionLineColor(self, /) -> AcColor: ...
    def dimensionLineWeight(self, /) -> AcLineWeight: ...
    def dimensionLinetype(self, /) -> str: ...
    def extLine1EndPoint(self, /) -> PyGe.Point3d: ...
    def extLine1Linetype(self, /) -> str: ...
    def extLine1Suppress(self, /) -> bool: ...
    def extLine2EndPoint(self, /) -> PyGe.Point3d: ...
    def extLine2Linetype(self, /) -> str: ...
    def extLine2Suppress(self, /) -> bool: ...
    def extLineFixedLen(self, /) -> float: ...
    def extLineFixedLenSuppress(self, /) -> bool: ...
    def extensionLineColor(self, /) -> AcColor: ...
    def extensionLineExtend(self, /) -> float: ...
    def extensionLineOffset(self, /) -> float: ...
    def extensionLineWeight(self, /) -> AcLineWeight: ...
    def fit(self, /) -> AcDimFit: ...
    def forceLineInside(self, /) -> bool: ...
    def horizontalTextPosition(self, /) -> AcDimHorizontalJustification: ...
    def measurement(self, /) -> float: ...
    def setAngleFormat(self, val: PyAx.AngleUnits, /) -> None: ...
    def setAngleVertex(self, val: PyGe.Point3d, /) -> None: ...
    def setArrowhead1Block(self, val: str, /) -> None: ...
    def setArrowhead1Type(self, val: PyAx.AcDimArrowheadType, /) -> None: ...
    def setArrowhead2Block(self, val: str, /) -> None: ...
    def setArrowhead2Type(self, val: PyAx.AcDimArrowheadType, /) -> None: ...
    def setArrowheadSize(self, val: float, /) -> None: ...
    def setDimConstrDesc(self, val: str, /) -> None: ...
    def setDimConstrExpression(self, val: str, /) -> None: ...
    def setDimConstrForm(self, val: bool, /) -> None: ...
    def setDimConstrName(self, val: str, /) -> None: ...
    def setDimConstrReference(self, val: bool, /) -> None: ...
    def setDimConstrValue(self, val: str, /) -> None: ...
    def setDimLine1Suppress(self, val: bool, /) -> None: ...
    def setDimLine2Suppress(self, val: bool, /) -> None: ...
    def setDimLineInside(self, val: bool, /) -> None: ...
    def setDimensionLineColor(self, val: PyAx.AcColor, /) -> None: ...
    def setDimensionLineWeight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setDimensionLinetype(self, val: str, /) -> None: ...
    def setExtLine1EndPoint(self, val: PyGe.Point3d, /) -> None: ...
    def setExtLine1Linetype(self, val: str, /) -> None: ...
    def setExtLine1Suppress(self, val: bool, /) -> None: ...
    def setExtLine2EndPoint(self, val: PyGe.Point3d, /) -> None: ...
    def setExtLine2Linetype(self, val: str, /) -> None: ...
    def setExtLine2Suppress(self, val: bool, /) -> None: ...
    def setExtLineFixedLen(self, val: float, /) -> None: ...
    def setExtLineFixedLenSuppress(self, val: bool, /) -> None: ...
    def setExtensionLineColor(self, val: PyAx.AcColor, /) -> None: ...
    def setExtensionLineExtend(self, val: PyAx.AcColor, /) -> None: ...
    def setExtensionLineOffset(self, val: float, /) -> None: ...
    def setExtensionLineWeight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setFit(self, val: PyAx.AcDimFit, /) -> None: ...
    def setForceLineInside(self, val: bool, /) -> None: ...
    def setHorizontalTextPosition(self, val: PyAx.AcDimHorizontalJustification, /) -> None: ...
    def setTextInside(self, val: bool, /) -> None: ...
    def setTextInsideAlign(self, val: bool, /) -> None: ...
    def setTextOutsideAlign(self, val: bool, /) -> None: ...
    def setTextPrecision(self, val: PyAx.AcDimPrecisionint3d, /) -> None: ...
    def textInside(self, /) -> bool: ...
    def textInsideAlign(self, /) -> bool: ...
    def textOutsideAlign(self, /) -> bool: ...
    def textPrecision(self, /) -> AcDimPrecision: ...

class AcadDimAligned(PyAx.AcadDimension):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def altSubUnitsFactor(self, /) -> float: ...
    def altSubUnitsSuffix(self, /) -> str: ...
    def altSuppressLeadingZeros(self, /) -> bool: ...
    def altSuppressTrailingZeros(self, /) -> bool: ...
    def altSuppressZeroFeet(self, /) -> bool: ...
    def altSuppressZeroInches(self, /) -> bool: ...
    def altTextPrefix(self, /) -> str: ...
    def altTextSuffix(self, /) -> str: ...
    def altToleranceSuppressLeadingZeros(self, /) -> bool: ...
    def altToleranceSuppressTrailingZeros(self, /) -> bool: ...
    def altToleranceSuppressZeroFeet(self, /) -> bool: ...
    def altToleranceSuppressZeroInches(self, /) -> bool: ...
    def altUnits(self, /) -> bool: ...
    def altUnitsFormat(self, /) -> AcDimUnits: ...
    def altUnitsPrecision(self, /) -> AcDimPrecision: ...
    def arrowhead1Block(self, /) -> str: ...
    def arrowhead1Type(self, /) -> AcDimArrowheadType: ...
    def arrowhead2Block(self, /) -> str: ...
    def arrowhead2Type(self, /) -> AcDimArrowheadType: ...
    def arrowheadSize(self, /) -> float: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadDimAligned: ...
    @staticmethod
    def className() -> str: ...
    def dimConstrDesc(self, /) -> str: ...
    def dimConstrExpression(self, /) -> str: ...
    def dimConstrForm(self, /) -> bool: ...
    def dimConstrName(self, /) -> str: ...
    def dimConstrReference(self, /) -> bool: ...
    def dimConstrValue(self, /) -> str: ...
    def dimLine1Suppress(self, /) -> bool: ...
    def dimLine2Suppress(self, /) -> bool: ...
    def dimLineInside(self, /) -> bool: ...
    def dimensionLineColor(self, /) -> AcColor: ...
    def dimensionLineExtend(self, /) -> float: ...
    def dimensionLineWeight(self, /) -> AcLineWeight: ...
    def dimensionLinetype(self, /) -> str: ...
    def extLine1Linetype(self, /) -> str: ...
    def extLine1Point(self, /) -> PyGe.Point3d: ...
    def extLine1Suppress(self, /) -> bool: ...
    def extLine2Linetype(self, /) -> str: ...
    def extLine2Point(self, /) -> PyGe.Point3d: ...
    def extLine2Suppress(self, /) -> bool: ...
    def extLineFixedLen(self, /) -> float: ...
    def extLineFixedLenSuppress(self, /) -> bool: ...
    def extensionLineColor(self, /) -> AcColor: ...
    def extensionLineExtend(self, /) -> float: ...
    def extensionLineOffset(self, /) -> float: ...
    def extensionLineWeight(self, /) -> AcLineWeight: ...
    def fit(self, /) -> AcDimFit: ...
    def forceLineInside(self, /) -> bool: ...
    def fractionFormat(self, /) -> AcDimFractionType: ...
    def horizontalTextPosition(self, /) -> AcDimHorizontalJustification: ...
    def linearScaleFactor(self, /) -> float: ...
    def measurement(self, /) -> float: ...
    def primaryUnitsPrecision(self, /) -> AcDimPrecision: ...
    def roundDistance(self, /) -> float: ...
    def setAltSubUnitsFactor(self, val: float, /) -> None: ...
    def setAltSubUnitsSuffix(self, val: str, /) -> None: ...
    def setAltSuppressLeadingZeros(self, val: bool, /) -> None: ...
    def setAltSuppressTrailingZeros(self, val: bool, /) -> None: ...
    def setAltSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setAltSuppressZeroInches(self, val: bool, /) -> None: ...
    def setAltTextPrefix(self, val: str, /) -> None: ...
    def setAltTextSuffix(self, val: str, /) -> None: ...
    def setAltToleranceSuppressLeadingZeros(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressTrailingZeros(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressZeroInches(self, val: bool, /) -> None: ...
    def setAltUnits(self, val: bool, /) -> None: ...
    def setAltUnitsFormat(self, val: PyAx.AcDimUnits, /) -> None: ...
    def setAltUnitsPrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setArrowhead1Block(self, val: str, /) -> None: ...
    def setArrowhead1Type(self, val: PyAx.AcDimArrowheadType, /) -> None: ...
    def setArrowhead2Block(self, val: str, /) -> None: ...
    def setArrowhead2Type(self, val: PyAx.AcDimArrowheadType, /) -> None: ...
    def setArrowheadSize(self, val: float, /) -> None: ...
    def setDimConstrDesc(self, val: str, /) -> None: ...
    def setDimConstrExpression(self, val: str, /) -> None: ...
    def setDimConstrForm(self, val: bool, /) -> None: ...
    def setDimConstrName(self, val: str, /) -> None: ...
    def setDimConstrReference(self, val: bool, /) -> None: ...
    def setDimConstrValue(self, val: str, /) -> None: ...
    def setDimLine1Suppress(self, val: bool, /) -> None: ...
    def setDimLine2Suppress(self, val: bool, /) -> None: ...
    def setDimLineInside(self, val: bool, /) -> None: ...
    def setDimensionLineColor(self, val: PyAx.AcColor, /) -> None: ...
    def setDimensionLineExtend(self, val: float, /) -> None: ...
    def setDimensionLineWeight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setDimensionLinetype(self, val: str, /) -> None: ...
    def setExtLine1Linetype(self, val: str, /) -> None: ...
    def setExtLine1Point(self, val: PyGe.Point3d, /) -> None: ...
    def setExtLine1Suppress(self, val: bool, /) -> None: ...
    def setExtLine2Linetype(self, val: str, /) -> None: ...
    def setExtLine2Point(self, val: PyGe.Point3d, /) -> None: ...
    def setExtLine2Suppress(self, val: bool, /) -> None: ...
    def setExtLineFixedLen(self, val: bool, /) -> None: ...
    def setExtLineFixedLenSuppress(self, val: bool, /) -> None: ...
    def setExtensionLineColor(self, val: PyAx.AcColor, /) -> None: ...
    def setExtensionLineExtend(self, val: float, /) -> None: ...
    def setExtensionLineOffset(self, val: float, /) -> None: ...
    def setExtensionLineWeight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setFit(self, val: PyAx.AcDimFit, /) -> None: ...
    def setForceLineInside(self, val: bool, /) -> None: ...
    def setFractionFormat(self, val: PyAx.AcDimFractionType, /) -> None: ...
    def setHorizontalTextPosition(self, val: PyAx.AcDimHorizontalJustification, /) -> None: ...
    def setLinearScaleFactor(self, val: float, /) -> None: ...
    def setPrimaryUnitsPrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setRoundDistance(self, val: float, /) -> None: ...
    def setSubUnitsFactor(self, val: float, /) -> None: ...
    def setSubUnitsSuffix(self, val: str, /) -> None: ...
    def setSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setSuppressZeroInches(self, val: bool, /) -> None: ...
    def setTextInside(self, val: bool, /) -> None: ...
    def setTextInsideAlign(self, val: bool, /) -> None: ...
    def setTextOutsideAlign(self, val: bool, /) -> None: ...
    def setToleranceSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setToleranceSuppressZeroInches(self, val: bool, /) -> None: ...
    def setUnitsFormat(self, val: PyAx.AcDimLUnits, /) -> None: ...
    def subUnitsFactor(self, /) -> float: ...
    def subUnitsSuffix(self, /) -> str: ...
    def suppressZeroFeet(self, /) -> bool: ...
    def suppressZeroInches(self, /) -> bool: ...
    def textInside(self, /) -> bool: ...
    def textInsideAlign(self, /) -> bool: ...
    def textOutsideAlign(self, /) -> bool: ...
    def toleranceSuppressZeroFeet(self, /) -> bool: ...
    def toleranceSuppressZeroInches(self, /) -> bool: ...
    def unitsFormat(self, /) -> AcDimLUnits: ...

class AcadDimAngular(PyAx.AcadDimension):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def angleFormat(self, /) -> AcAngleUnits: ...
    def arrowhead1Block(self, /) -> str: ...
    def arrowhead1Type(self, /) -> AcDimArrowheadType: ...
    def arrowhead2Block(self, /) -> str: ...
    def arrowhead2Type(self, /) -> AcDimArrowheadType: ...
    def arrowheadSize(self, /) -> float: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadDimAngular: ...
    @staticmethod
    def className() -> str: ...
    def dimConstrDesc(self, /) -> str: ...
    def dimConstrExpression(self, /) -> str: ...
    def dimConstrForm(self, /) -> bool: ...
    def dimConstrName(self, /) -> str: ...
    def dimConstrReference(self, /) -> bool: ...
    def dimConstrValue(self, /) -> str: ...
    def dimLine1Suppress(self, /) -> bool: ...
    def dimLine2Suppress(self, /) -> bool: ...
    def dimLineInside(self, /) -> bool: ...
    def dimensionLineColor(self, /) -> AcColor: ...
    def dimensionLineWeight(self, /) -> AcLineWeight: ...
    def dimensionLinetype(self, /) -> str: ...
    def extLine1EndPoint(self, /) -> PyGe.Point3d: ...
    def extLine1Linetype(self, /) -> str: ...
    def extLine1StartPoint(self, /) -> None: ...
    def extLine1Suppress(self, /) -> bool: ...
    def extLine2EndPoint(self, /) -> PyGe.Point3d: ...
    def extLine2Linetype(self, /) -> str: ...
    def extLine2StartPoint(self, /) -> PyGe.Point3d: ...
    def extLine2Suppress(self, /) -> bool: ...
    def extLineFixedLen(self, /) -> float: ...
    def extLineFixedLenSuppress(self, /) -> bool: ...
    def extensionLineColor(self, /) -> AcColor: ...
    def extensionLineExtend(self, /) -> float: ...
    def extensionLineOffset(self, /) -> float: ...
    def extensionLineWeight(self, /) -> AcLineWeight: ...
    def fit(self, /) -> AcDimFit: ...
    def forceLineInside(self, /) -> bool: ...
    def horizontalTextPosition(self, /) -> AcDimHorizontalJustification: ...
    def measurement(self, /) -> float: ...
    def setAngleFormat(self, val: PyAx.AcAngleUnits, /) -> None: ...
    def setArrowhead1Block(self, val: str, /) -> None: ...
    def setArrowhead1Type(self, val: PyAx.AcDimArrowheadType, /) -> None: ...
    def setArrowhead2Block(self, val: str, /) -> None: ...
    def setArrowhead2Type(self, val: PyAx.AcDimArrowheadType, /) -> None: ...
    def setArrowheadSize(self, val: float, /) -> None: ...
    def setDimConstrDesc(self, val: str, /) -> None: ...
    def setDimConstrExpression(self, val: str, /) -> None: ...
    def setDimConstrForm(self, val: bool, /) -> None: ...
    def setDimConstrName(self, val: str, /) -> None: ...
    def setDimConstrReference(self, val: bool, /) -> None: ...
    def setDimConstrValue(self, val: str, /) -> None: ...
    def setDimLine1Suppress(self, val: bool, /) -> None: ...
    def setDimLine2Suppress(self, val: bool, /) -> None: ...
    def setDimLineInside(self, val: bool, /) -> None: ...
    def setDimensionLineColor(self, val: PyAx.AcColor, /) -> None: ...
    def setDimensionLineWeight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setDimensionLinetype(self, val: str, /) -> None: ...
    def setExtLine1EndPoint(self, val: PyGe.GePoint3d, /) -> None: ...
    def setExtLine1Linetype(self, val: str, /) -> None: ...
    def setExtLine1StartPoint(self, val: PyGe.GePoint3d, /) -> None: ...
    def setExtLine1Suppress(self, val: bool, /) -> None: ...
    def setExtLine2EndPoint(self, val: PyGe.GePoint3d, /) -> None: ...
    def setExtLine2Linetype(self, val: str, /) -> None: ...
    def setExtLine2StartPoint(self, val: PyGe.GePoint3d, /) -> None: ...
    def setExtLine2Suppress(self, val: bool, /) -> None: ...
    def setExtLineFixedLen(self, val: float, /) -> None: ...
    def setExtLineFixedLenSuppress(self, val: bool, /) -> None: ...
    def setExtensionLineColor(self, val: PyAx.AcColor, /) -> None: ...
    def setExtensionLineExtend(self, val: float, /) -> None: ...
    def setExtensionLineOffset(self, val: float, /) -> None: ...
    def setExtensionLineWeight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setFit(self, val: PyAx.AcDimFit, /) -> None: ...
    def setForceLineInside(self, val: bool, /) -> None: ...
    def setHorizontalTextPosition(self, val: PyAx.AcDimHorizontalJustification, /) -> None: ...
    def setTextInside(self, val: bool, /) -> None: ...
    def setTextInsideAlign(self, val: bool, /) -> None: ...
    def setTextOutsideAlign(self, val: bool, /) -> None: ...
    def setTextPrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def textInside(self, /) -> bool: ...
    def textInsideAlign(self, /) -> bool: ...
    def textOutsideAlign(self, /) -> bool: ...
    def textPrecision(self, /) -> AcDimPrecision: ...

class AcadDimArcLength(PyAx.AcadDimension):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def altRoundDistance(self, /) -> float: ...
    def altSubUnitsFactor(self, /) -> float: ...
    def altSubUnitsSuffix(self, /) -> str: ...
    def altSuppressLeadingZeros(self, /) -> bool: ...
    def altSuppressTrailingZeros(self, /) -> bool: ...
    def altSuppressZeroFeet(self, /) -> bool: ...
    def altSuppressZeroInches(self, /) -> bool: ...
    def altTextPrefix(self, /) -> str: ...
    def altTextSuffix(self, /) -> str: ...
    def altTolerancePrecision(self, /) -> AcDimPrecision: ...
    def altToleranceSuppressLeadingZeros(self, /) -> bool: ...
    def altToleranceSuppressTrailingZeros(self, /) -> bool: ...
    def altToleranceSuppressZeroFeet(self, /) -> bool: ...
    def altToleranceSuppressZeroInches(self, /) -> bool: ...
    def altUnits(self, /) -> bool: ...
    def altUnitsFormat(self, /) -> AcDimUnits: ...
    def altUnitsPrecision(self, /) -> AcDimPrecision: ...
    def altUnitsScale(self, /) -> float: ...
    def arcEndParam(self, /) -> float: ...
    def arcPoint(self, /) -> PyGe.Point3d: ...
    def arcStartParam(self, /) -> float: ...
    def arrowhead1Block(self, /) -> str: ...
    def arrowhead1Type(self, /) -> AcDimArrowheadType: ...
    def arrowhead2Block(self, /) -> str: ...
    def arrowhead2Type(self, /) -> AcDimArrowheadType: ...
    def arrowheadSize(self, /) -> float: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadDimArcLength: ...
    def centerPoint(self, /) -> PyGe.Point3d: ...
    @staticmethod
    def className() -> str: ...
    def dimLine1Suppress(self, /) -> bool: ...
    def dimLine2Suppress(self, /) -> bool: ...
    def dimLineInside(self, /) -> bool: ...
    def dimensionLineColor(self, /) -> AcColor: ...
    def dimensionLineExtend(self, /) -> float: ...
    def dimensionLineWeight(self, /) -> AcLineWeight: ...
    def dimensionLinetype(self, /) -> str: ...
    def extLine1Linetype(self, /) -> str: ...
    def extLine1Point(self, /) -> PyGe.Point3d: ...
    def extLine1Suppress(self, /) -> bool: ...
    def extLine2Linetype(self, /) -> str: ...
    def extLine2Point(self, /) -> PyGe.Point3d: ...
    def extLine2Suppress(self, /) -> bool: ...
    def extLineFixedLen(self, /) -> float: ...
    def extLineFixedLenSuppress(self, /) -> bool: ...
    def extensionLineColor(self, /) -> AcColor: ...
    def extensionLineExtend(self, /) -> float: ...
    def extensionLineOffset(self, /) -> float: ...
    def extensionLineWeight(self, /) -> AcLineWeight: ...
    def fit(self, /) -> AcDimFit: ...
    def forceLineInside(self, /) -> bool: ...
    def fractionFormat(self, /) -> AcDimFractionType: ...
    def hasLeader(self, /) -> bool: ...
    def horizontalTextPosition(self, /) -> AcDimHorizontalJustification: ...
    def isPartial(self, /) -> bool: ...
    def leader1Point(self, /) -> PyGe.Point3d: ...
    def leader2Point(self, /) -> PyGe.Point3d: ...
    def linearScaleFactor(self, /) -> float: ...
    def measurement(self, /) -> float: ...
    def primaryUnitsPrecision(self, /) -> AcDimPrecision: ...
    def roundDistance(self, /) -> float: ...
    def setAltRoundDistance(self, val: float, /) -> None: ...
    def setAltSubUnitsFactor(self, val: float, /) -> None: ...
    def setAltSubUnitsSuffix(self, val: str, /) -> None: ...
    def setAltSuppressLeadingZeros(self, val: bool, /) -> None: ...
    def setAltSuppressTrailingZeros(self, val: bool, /) -> None: ...
    def setAltSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setAltSuppressZeroInches(self, val: bool, /) -> None: ...
    def setAltTextPrefix(self, val: str, /) -> None: ...
    def setAltTextSuffix(self, val: str, /) -> None: ...
    def setAltTolerancePrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setAltToleranceSuppressLeadingZeros(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressTrailingZeros(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressZeroInches(self, val: bool, /) -> None: ...
    def setAltUnits(self, val: bool, /) -> None: ...
    def setAltUnitsFormat(self, val: PyAx.AcDimUnits, /) -> None: ...
    def setAltUnitsPrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setAltUnitsScale(self, val: float, /) -> None: ...
    def setArcEndParam(self, val: float, /) -> None: ...
    def setArcPoint(self, val: PyGe.Point3d, /) -> None: ...
    def setArcStartParam(self, val: float, /) -> None: ...
    def setArrowhead1Block(self, val: str, /) -> None: ...
    def setArrowhead1Type(self, val: PyAx.AcDimArrowheadType, /) -> None: ...
    def setArrowhead2Block(self, val: str, /) -> None: ...
    def setArrowhead2Type(self, val: PyAx.AcDimArrowheadType, /) -> None: ...
    def setArrowheadSize(self, val: float, /) -> None: ...
    def setCenterPoint(self, val: PyGe.Point3d, /) -> None: ...
    def setDimLine1Suppress(self, val: bool, /) -> None: ...
    def setDimLine2Suppress(self, val: bool, /) -> None: ...
    def setDimLineInside(self, val: bool, /) -> None: ...
    def setDimensionLineColor(self, val: PyAx.AcColor, /) -> None: ...
    def setDimensionLineExtend(self, val: float, /) -> None: ...
    def setDimensionLineWeight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setDimensionLinetype(self, val: str, /) -> None: ...
    def setExtLine1Linetype(self, val: str, /) -> None: ...
    def setExtLine1Point(self, val: PyGe.Point3d, /) -> None: ...
    def setExtLine1Suppress(self, val: bool, /) -> None: ...
    def setExtLine2Linetype(self, val: str, /) -> None: ...
    def setExtLine2Point(self, val: PyGe.Point3d, /) -> None: ...
    def setExtLine2Suppress(self, val: bool, /) -> None: ...
    def setExtLineFixedLen(self, val: float, /) -> None: ...
    def setExtLineFixedLenSuppress(self, val: bool, /) -> None: ...
    def setExtensionLineColor(self, val: PyAx.AcColor, /) -> None: ...
    def setExtensionLineExtend(self, val: float, /) -> None: ...
    def setExtensionLineOffset(self, val: float, /) -> None: ...
    def setExtensionLineWeight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setFit(self, val: PyAx.AcDimFit, /) -> None: ...
    def setForceLineInside(self, val: bool, /) -> None: ...
    def setFractionFormat(self, val: PyAx.AcDimFractionType, /) -> None: ...
    def setHasLeader(self, val: bool, /) -> None: ...
    def setHorizontalTextPosition(self, val: PyAx.AcDimHorizontalJustification, /) -> None: ...
    def setIsPartial(self, val: bool, /) -> None: ...
    def setLeader1Point(self, val: PyGe.Point3d, /) -> None: ...
    def setLeader2Point(self, val: PyGe.Point3d, /) -> None: ...
    def setLinearScaleFactor(self, val: float, /) -> None: ...
    def setPrimaryUnitsPrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setRoundDistance(self, val: float, /) -> None: ...
    def setSubUnitsFactor(self, val: float, /) -> None: ...
    def setSubUnitsSuffix(self, val: str, /) -> None: ...
    def setSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setSuppressZeroInches(self, val: bool, /) -> None: ...
    def setSymbolPosition(self, val: PyAx.AcDimArcLengthSymbol, /) -> None: ...
    def setTextInside(self, val: bool, /) -> None: ...
    def setTextInsideAlign(self, val: bool, /) -> None: ...
    def setTextOutsideAlign(self, val: bool, /) -> None: ...
    def setToleranceSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setToleranceSuppressZeroInches(self, val: bool, /) -> None: ...
    def setUnitsFormat(self, val: PyAx.AcDimLUnits, /) -> None: ...
    def subUnitsFactor(self, /) -> float: ...
    def subUnitsSuffix(self, /) -> str: ...
    def suppressZeroFeet(self, /) -> bool: ...
    def suppressZeroInches(self, /) -> bool: ...
    def symbolPosition(self, /) -> AcDimArcLengthSymbol: ...
    def textInside(self, /) -> bool: ...
    def textInsideAlign(self, /) -> bool: ...
    def textOutsideAlign(self, /) -> bool: ...
    def toleranceSuppressZeroFeet(self, /) -> bool: ...
    def toleranceSuppressZeroInches(self, /) -> bool: ...
    def unitsFormat(self, /) -> AcDimLUnits: ...

class AcadDimDiametric(PyAx.AcadDimension):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def altSuppressLeadingZeros(self, /) -> bool: ...
    def altSuppressTrailingZeros(self, /) -> bool: ...
    def altSuppressZeroFeet(self, /) -> bool: ...
    def altSuppressZeroInches(self, /) -> bool: ...
    def altTextPrefix(self, /) -> str: ...
    def altTextSuffix(self, /) -> str: ...
    def altTolerancePrecision(self, /) -> AcDimPrecision: ...
    def altToleranceSuppressLeadingZeros(self, /) -> bool: ...
    def altToleranceSuppressTrailingZeros(self, /) -> bool: ...
    def altToleranceSuppressZeroFeet(self, /) -> bool: ...
    def altToleranceSuppressZeroInches(self, /) -> bool: ...
    def altUnits(self, /) -> bool: ...
    def altUnitsFormat(self, /) -> AcDimUnits: ...
    def altUnitsPrecision(self, /) -> AcDimPrecision: ...
    def altUnitsScale(self, /) -> float: ...
    def arrowhead1Block(self, /) -> str: ...
    def arrowhead1Type(self, /) -> AcDimArrowheadType: ...
    def arrowhead2Block(self, /) -> str: ...
    def arrowhead2Type(self, /) -> AcDimArrowheadType: ...
    def arrowheadSize(self, /) -> float: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadDimDiametric: ...
    def centerMarkSize(self, /) -> float: ...
    def centerType(self, /) -> AcDimCenterType: ...
    @staticmethod
    def className() -> str: ...
    def dimConstrDesc(self, /) -> str: ...
    def dimConstrExpression(self, /) -> str: ...
    def dimConstrForm(self, /) -> bool: ...
    def dimConstrName(self, /) -> str: ...
    def dimConstrReference(self, /) -> bool: ...
    def dimConstrValue(self, /) -> str: ...
    def dimLine1Suppress(self, /) -> bool: ...
    def dimLine2Suppress(self, /) -> bool: ...
    def dimensionLineColor(self, /) -> AcColor: ...
    def dimensionLineWeight(self, /) -> AcLineWeight: ...
    def dimensionLinetype(self, /) -> str: ...
    def fit(self, /) -> AcDimFit: ...
    def forceLineInside(self, /) -> bool: ...
    def fractionFormat(self, /) -> AcDimFractionType: ...
    def linearScaleFactor(self, /) -> float: ...
    def measurement(self, /) -> float: ...
    def primaryUnitsPrecision(self, /) -> AcDimPrecision: ...
    def roundDistance(self, /) -> float: ...
    def setAltSuppressLeadingZeros(self, val: bool, /) -> None: ...
    def setAltSuppressTrailingZeros(self, val: bool, /) -> None: ...
    def setAltSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setAltSuppressZeroInches(self, val: bool, /) -> None: ...
    def setAltTextPrefix(self, val: str, /) -> None: ...
    def setAltTextSuffix(self, val: str, /) -> None: ...
    def setAltTolerancePrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setAltToleranceSuppressLeadingZeros(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressTrailingZeros(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressZeroInches(self, val: bool, /) -> None: ...
    def setAltUnits(self, val: bool, /) -> None: ...
    def setAltUnitsFormat(self, val: PyAx.AcDimUnits, /) -> None: ...
    def setAltUnitsPrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setAltUnitsScale(self, val: bool, /) -> None: ...
    def setArrowhead1Block(self, val: str, /) -> None: ...
    def setArrowhead1Type(self, val: PyAx.AcDimArrowheadType, /) -> None: ...
    def setArrowhead2Block(self, val: str, /) -> None: ...
    def setArrowhead2Type(self, val: PyAx.AcDimArrowheadType, /) -> None: ...
    def setArrowheadSize(self, val: float, /) -> None: ...
    def setCenterMarkSize(self, val: float, /) -> None: ...
    def setCenterType(self, val: PyAx.AcDimCenterType, /) -> None: ...
    def setDimConstrDesc(self, val: str, /) -> None: ...
    def setDimConstrExpression(self, val: str, /) -> None: ...
    def setDimConstrForm(self, val: bool, /) -> None: ...
    def setDimConstrName(self, val: str, /) -> None: ...
    def setDimConstrReference(self, val: bool, /) -> None: ...
    def setDimConstrValue(self, val: str, /) -> None: ...
    def setDimLine1Suppress(self, val: bool, /) -> None: ...
    def setDimLine2Suppress(self, val: bool, /) -> None: ...
    def setDimensionLineColor(self, val: PyAx.AcColor, /) -> None: ...
    def setDimensionLineWeight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setDimensionLinetype(self, val: str, /) -> None: ...
    def setFit(self, val: PyAx.AcDimFit, /) -> None: ...
    def setForceLineInside(self, val: bool, /) -> None: ...
    def setFractionFormat(self, val: PyAx.AcDimFractionType, /) -> None: ...
    def setLeaderLength(self, val: float, /) -> None: ...
    def setLinearScaleFactor(self, val: float, /) -> None: ...
    def setPrimaryUnitsPrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setRoundDistance(self, val: float, /) -> None: ...
    def setSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setSuppressZeroInches(self, val: bool, /) -> None: ...
    def setTextInside(self, val: bool, /) -> None: ...
    def setTextInsideAlign(self, val: bool, /) -> None: ...
    def setTextOutsideAlign(self, val: bool, /) -> None: ...
    def setToleranceSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setToleranceSuppressZeroInches(self, val: bool, /) -> None: ...
    def setUnitsFormat(self, val: AcDimLUnits, /) -> None: ...
    def suppressZeroFeet(self, /) -> bool: ...
    def suppressZeroInches(self, /) -> bool: ...
    def textInside(self, /) -> bool: ...
    def textInsideAlign(self, /) -> bool: ...
    def textOutsideAlign(self, /) -> bool: ...
    def toleranceSuppressZeroFeet(self, /) -> bool: ...
    def toleranceSuppressZeroInches(self, /) -> bool: ...
    def unitsFormat(self, /) -> AcDimLUnits: ...

class AcadDimOrdinate(PyAx.AcadDimension):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def altRoundDistance(self, /) -> float: ...
    def altSubUnitsFactor(self, /) -> float: ...
    def altSubUnitsSuffix(self, /) -> str: ...
    def altSuppressLeadingZeros(self, /) -> bool: ...
    def altSuppressTrailingZeros(self, /) -> bool: ...
    def altSuppressZeroFeet(self, /) -> bool: ...
    def altSuppressZeroInches(self, /) -> bool: ...
    def altTextPrefix(self, /) -> str: ...
    def altTextSuffix(self, /) -> str: ...
    def altTolerancePrecision(self, /) -> AcDimPrecision: ...
    def altToleranceSuppressLeadingZeros(self, /) -> bool: ...
    def altToleranceSuppressTrailingZeros(self, /) -> bool: ...
    def altToleranceSuppressZeroFeet(self, /) -> bool: ...
    def altToleranceSuppressZeroInches(self, /) -> bool: ...
    def altUnits(self, /) -> bool: ...
    def altUnitsFormat(self, /) -> AcDimUnits: ...
    def altUnitsPrecision(self, /) -> AcDimPrecision: ...
    def altUnitsScale(self, /) -> float: ...
    def arrowheadSize(self, /) -> float: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadDimOrdinate: ...
    @staticmethod
    def className() -> str: ...
    def extLineFixedLen(self, /) -> float: ...
    def extLineFixedLenSuppress(self, /) -> bool: ...
    def extensionLineColor(self, /) -> AcColor: ...
    def extensionLineOffset(self, /) -> float: ...
    def extensionLineWeight(self, /) -> AcLineWeight: ...
    def fractionFormat(self, /) -> AcDimFractionType: ...
    def linearScaleFactor(self, /) -> float: ...
    def measurement(self, /) -> float: ...
    def primaryUnitsPrecision(self, /) -> AcDimPrecision: ...
    def roundDistance(self, /) -> float: ...
    def setAltRoundDistance(self, val: float, /) -> None: ...
    def setAltSubUnitsFactor(self, val: float, /) -> None: ...
    def setAltSubUnitsSuffix(self, val: str, /) -> None: ...
    def setAltSuppressLeadingZeros(self, val: bool, /) -> None: ...
    def setAltSuppressTrailingZeros(self, val: bool, /) -> None: ...
    def setAltSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setAltSuppressZeroInches(self, val: bool, /) -> None: ...
    def setAltTextPrefix(self, val: str, /) -> None: ...
    def setAltTextSuffix(self, val: str, /) -> None: ...
    def setAltTolerancePrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setAltToleranceSuppressLeadingZeros(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressTrailingZeros(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressZeroInches(self, val: bool, /) -> None: ...
    def setAltUnits(self, val: bool, /) -> None: ...
    def setAltUnitsFormat(self, val: PyAx.AcDimUnits, /) -> None: ...
    def setAltUnitsPrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setAltUnitsScale(self, val: float, /) -> None: ...
    def setArrowheadSize(self, val: float, /) -> None: ...
    def setExtLineFixedLen(self, val: bool, /) -> None: ...
    def setExtLineFixedLenSuppress(self, val: bool, /) -> None: ...
    def setExtensionLineColor(self, val: PyAx.AcColor, /) -> None: ...
    def setExtensionLineOffset(self, val: float, /) -> None: ...
    def setExtensionLineWeight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setFractionFormat(self, val: PyAx.AcDimFractionType, /) -> None: ...
    def setLinearScaleFactor(self, val: float, /) -> None: ...
    def setPrimaryUnitsPrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setRoundDistance(self, val: float, /) -> None: ...
    def setSubUnitsFactor(self, val: float, /) -> None: ...
    def setSubUnitsSuffix(self, val: str, /) -> None: ...
    def setSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setSuppressZeroInches(self, val: bool, /) -> None: ...
    def setToleranceSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setToleranceSuppressZeroInches(self, val: bool, /) -> None: ...
    def setUnitsFormat(self, val: PyAx.AcDimLUnits, /) -> None: ...
    def subUnitsFactor(self, /) -> float: ...
    def subUnitsSuffix(self, /) -> str: ...
    def suppressZeroFeet(self, /) -> bool: ...
    def suppressZeroInches(self, /) -> bool: ...
    def toleranceSuppressZeroFeet(self, /) -> bool: ...
    def toleranceSuppressZeroInches(self, /) -> bool: ...
    def unitsFormat(self, /) -> AcDimLUnits: ...

class AcadDimRadial(PyAx.AcadDimension):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def altRoundDistance(self, /) -> float: ...
    def altSuppressLeadingZeros(self, /) -> bool: ...
    def altSuppressTrailingZeros(self, /) -> bool: ...
    def altSuppressZeroFeet(self, /) -> bool: ...
    def altSuppressZeroInches(self, /) -> bool: ...
    def altTextPrefix(self, /) -> str: ...
    def altTextSuffix(self, /) -> str: ...
    def altTolerancePrecision(self, /) -> AcDimPrecision: ...
    def altToleranceSuppressLeadingZeros(self, /) -> bool: ...
    def altToleranceSuppressTrailingZeros(self, /) -> bool: ...
    def altToleranceSuppressZeroFeet(self, /) -> bool: ...
    def altToleranceSuppressZeroInches(self, /) -> bool: ...
    def altUnits(self, /) -> bool: ...
    def altUnitsFormat(self, /) -> AcDimUnits: ...
    def altUnitsPrecision(self, /) -> AcDimPrecision: ...
    def altUnitsScale(self, /) -> float: ...
    def arrowheadBlock(self, /) -> str: ...
    def arrowheadSize(self, /) -> float: ...
    def arrowheadType(self, /) -> AcDimArrowheadType: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadDimRadial: ...
    def centerMarkSize(self, /) -> float: ...
    def centerType(self, /) -> AcDimCenterType: ...
    @staticmethod
    def className() -> str: ...
    def dimConstrDesc(self, /) -> str: ...
    def dimConstrExpression(self, /) -> str: ...
    def dimConstrForm(self, /) -> bool: ...
    def dimConstrName(self, /) -> str: ...
    def dimConstrReference(self, /) -> bool: ...
    def dimConstrValue(self, /) -> str: ...
    def dimLineSuppress(self, /) -> bool: ...
    def dimensionLineColor(self, /) -> AcColor: ...
    def dimensionLineWeight(self, /) -> AcLineWeight: ...
    def dimensionLinetype(self, /) -> str: ...
    def fit(self, /) -> AcDimFit: ...
    def forceLineInside(self, /) -> bool: ...
    def fractionFormat(self, /) -> AcDimFractionType: ...
    def linearScaleFactor(self, /) -> float: ...
    def measurement(self, /) -> float: ...
    def primaryUnitsPrecision(self, /) -> AcDimPrecision: ...
    def roundDistance(self, /) -> float: ...
    def setAltRoundDistance(self, val: float, /) -> None: ...
    def setAltSuppressLeadingZeros(self, val: bool, /) -> None: ...
    def setAltSuppressTrailingZeros(self, val: bool, /) -> None: ...
    def setAltSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setAltSuppressZeroInches(self, val: bool, /) -> None: ...
    def setAltTextPrefix(self, val: str, /) -> None: ...
    def setAltTextSuffix(self, val: str, /) -> None: ...
    def setAltTolerancePrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setAltToleranceSuppressLeadingZeros(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressTrailingZeros(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressZeroInches(self, val: bool, /) -> None: ...
    def setAltUnits(self, val: bool, /) -> None: ...
    def setAltUnitsFormat(self, val: PyAx.AcDimUnits, /) -> None: ...
    def setAltUnitsPrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setAltUnitsScale(self, val: float, /) -> None: ...
    def setArrowheadBlock(self, val: str, /) -> None: ...
    def setArrowheadSize(self, val: float, /) -> None: ...
    def setArrowheadType(self, val: PyAx.AcDimArrowheadType, /) -> None: ...
    def setCenterMarkSize(self, val: float, /) -> None: ...
    def setCenterType(self, val: PyAx.AcDimCenterType, /) -> None: ...
    def setDimConstrDesc(self, val: str, /) -> None: ...
    def setDimConstrExpression(self, val: str, /) -> None: ...
    def setDimConstrForm(self, val: bool, /) -> None: ...
    def setDimConstrName(self, val: str, /) -> None: ...
    def setDimConstrReference(self, val: bool, /) -> None: ...
    def setDimConstrValue(self, val: str, /) -> None: ...
    def setDimLineSuppress(self, val: bool, /) -> None: ...
    def setDimensionLineColor(self, val: PyAx.AcColor, /) -> None: ...
    def setDimensionLineWeight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setDimensionLinetype(self, val: str, /) -> None: ...
    def setFit(self, val: PyAx.AcDimFit, /) -> None: ...
    def setForceLineInside(self, val: bool, /) -> None: ...
    def setFractionFormat(self, val: PyAx.AcDimFractionType, /) -> None: ...
    def setLeaderLength(self, val: float, /) -> None: ...
    def setLinearScaleFactor(self, val: float, /) -> None: ...
    def setPrimaryUnitsPrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setRoundDistance(self, val: float, /) -> None: ...
    def setSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setSuppressZeroInches(self, val: bool, /) -> None: ...
    def setTextInside(self, val: bool, /) -> None: ...
    def setTextInsideAlign(self, val: bool, /) -> None: ...
    def setTextOutsideAlign(self, val: bool, /) -> None: ...
    def setToleranceSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setToleranceSuppressZeroInches(self, val: bool, /) -> None: ...
    def setUnitsFormat(self, val: PyAx.AcDimLUnits, /) -> None: ...
    def suppressZeroFeet(self, /) -> bool: ...
    def suppressZeroInches(self, /) -> bool: ...
    def textInside(self, /) -> bool: ...
    def textInsideAlign(self, /) -> bool: ...
    def textOutsideAlign(self, /) -> bool: ...
    def toleranceSuppressZeroFeet(self, /) -> bool: ...
    def toleranceSuppressZeroInches(self, /) -> bool: ...
    def unitsFormat(self, /) -> AcDimLUnits: ...

class AcadDimRadialLarge(PyAx.AcadDimension):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def altRoundDistance(self, /) -> float: ...
    def altSuppressLeadingZeros(self, /) -> bool: ...
    def altSuppressTrailingZeros(self, /) -> bool: ...
    def altSuppressZeroFeet(self, /) -> bool: ...
    def altSuppressZeroInches(self, /) -> bool: ...
    def altTextPrefix(self, /) -> str: ...
    def altTextSuffix(self, /) -> str: ...
    def altTolerancePrecision(self, /) -> AcDimPrecision: ...
    def altToleranceSuppressLeadingZeros(self, /) -> bool: ...
    def altToleranceSuppressTrailingZeros(self, /) -> bool: ...
    def altToleranceSuppressZeroFeet(self, /) -> bool: ...
    def altToleranceSuppressZeroInches(self, /) -> bool: ...
    def altUnits(self, /) -> bool: ...
    def altUnitsFormat(self, /) -> AcDimUnits: ...
    def altUnitsPrecision(self, /) -> AcDimPrecision: ...
    def altUnitsScale(self, /) -> float: ...
    def arrowheadBlock(self, /) -> str: ...
    def arrowheadSize(self, /) -> float: ...
    def arrowheadType(self, /) -> AcDimArrowheadType: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadDimRadialLarge: ...
    def center(self, /) -> PyGe.Point3d: ...
    def centerMarkSize(self, /) -> float: ...
    def centerType(self, /) -> AcDimCenterType: ...
    def chordPoint(self, /) -> PyGe.Point3d: ...
    @staticmethod
    def className() -> str: ...
    def dimLineSuppress(self, /) -> bool: ...
    def dimensionLineColor(self, /) -> AcColor: ...
    def dimensionLineWeight(self, /) -> AcLineWeight: ...
    def dimensionLinetype(self, /) -> str: ...
    def fit(self, /) -> AcDimFit: ...
    def forceLineInside(self, /) -> bool: ...
    def fractionFormat(self, /) -> AcDimFractionType: ...
    def jogAngle(self, /) -> float: ...
    def jogLocation(self, /) -> PyGe.Point3d: ...
    def linearScaleFactor(self, /) -> float: ...
    def measurement(self, /) -> float: ...
    def overrideCenter(self, /) -> PyGe.Point3d: ...
    def primaryUnitsPrecision(self, /) -> AcDimPrecision: ...
    def roundDistance(self, /) -> float: ...
    def setAltRoundDistance(self, val: float, /) -> None: ...
    def setAltSuppressLeadingZeros(self, val: bool, /) -> None: ...
    def setAltSuppressTrailingZeros(self, val: bool, /) -> None: ...
    def setAltSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setAltSuppressZeroInches(self, val: bool, /) -> None: ...
    def setAltTextPrefix(self, val: str, /) -> None: ...
    def setAltTextSuffix(self, val: str, /) -> None: ...
    def setAltTolerancePrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setAltToleranceSuppressLeadingZeros(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressTrailingZeros(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressZeroInches(self, val: bool, /) -> None: ...
    def setAltUnits(self, val: bool, /) -> None: ...
    def setAltUnitsFormat(self, val: PyAx.AcDimUnits, /) -> None: ...
    def setAltUnitsPrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setAltUnitsScale(self, val: float, /) -> None: ...
    def setArrowheadBlock(self, val: PyAx.AcDimArrowheadType, /) -> None: ...
    def setArrowheadSize(self, val: float, /) -> None: ...
    def setArrowheadType(self, val: PyAx.AcDimArrowheadType, /) -> None: ...
    def setCenter(self, val: PyGe.Point3d, /) -> None: ...
    def setCenterMarkSize(self, val: float, /) -> None: ...
    def setCenterType(self, val: PyAx.AcDimCenterType, /) -> None: ...
    def setChordPoint(self, val: PyGe.Point3d, /) -> None: ...
    def setDimLineSuppress(self, val: bool, /) -> None: ...
    def setDimensionLineColor(self, val: PyAx.AcColor, /) -> None: ...
    def setDimensionLineWeight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setDimensionLinetype(self, val: str, /) -> None: ...
    def setFit(self, val: PyAx.AcDimFit, /) -> None: ...
    def setForceLineInside(self, val: bool, /) -> None: ...
    def setFractionFormat(self, val: PyAx.AcDimFractionType, /) -> None: ...
    def setJogAngle(self, val: float, /) -> None: ...
    def setJogLocation(self, val: PyGe.Point3d, /) -> None: ...
    def setLinearScaleFactor(self, val: float, /) -> None: ...
    def setOverrideCenter(self, val: PyGe.Point3d, /) -> None: ...
    def setPrimaryUnitsPrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setRoundDistance(self, val: float, /) -> None: ...
    def setSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setSuppressZeroInches(self, val: bool, /) -> None: ...
    def setTextInside(self, val: bool, /) -> None: ...
    def setTextInsideAlign(self, val: bool, /) -> None: ...
    def setTextOutsideAlign(self, val: bool, /) -> None: ...
    def setToleranceSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setToleranceSuppressZeroInches(self, val: bool, /) -> None: ...
    def setUnitsFormat(self, val: PyAx.AcDimLUnits, /) -> None: ...
    def suppressZeroFeet(self, /) -> bool: ...
    def suppressZeroInches(self, /) -> bool: ...
    def textInside(self, /) -> bool: ...
    def textInsideAlign(self, /) -> bool: ...
    def textOutsideAlign(self, /) -> bool: ...
    def toleranceSuppressZeroFeet(self, /) -> bool: ...
    def toleranceSuppressZeroInches(self, /) -> bool: ...
    def unitsFormat(self, /) -> AcDimLUnits: ...

class AcadDimRotated(PyAx.AcadDimension):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def altRoundDistance(self, /) -> float: ...
    def altSubUnitsFactor(self, /) -> float: ...
    def altSubUnitsSuffix(self, /) -> str: ...
    def altSuppressLeadingZeros(self, /) -> bool: ...
    def altSuppressTrailingZeros(self, /) -> bool: ...
    def altSuppressZeroFeet(self, /) -> bool: ...
    def altSuppressZeroInches(self, /) -> bool: ...
    def altTextPrefix(self, /) -> str: ...
    def altTextSuffix(self, /) -> str: ...
    def altTolerancePrecision(self, /) -> AcDimPrecision: ...
    def altToleranceSuppressLeadingZeros(self, /) -> bool: ...
    def altToleranceSuppressTrailingZeros(self, /) -> bool: ...
    def altToleranceSuppressZeroFeet(self, /) -> bool: ...
    def altToleranceSuppressZeroInches(self, /) -> bool: ...
    def altUnits(self, /) -> bool: ...
    def altUnitsFormat(self, /) -> AcDimUnits: ...
    def altUnitsPrecision(self, /) -> AcDimPrecision: ...
    def altUnitsScale(self, /) -> float: ...
    def arrowhead1Block(self, /) -> str: ...
    def arrowhead1Type(self, /) -> AcDimArrowheadType: ...
    def arrowhead2Block(self, /) -> str: ...
    def arrowhead2Type(self, /) -> AcDimArrowheadType: ...
    def arrowheadSize(self, /) -> float: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadDimRotated: ...
    @staticmethod
    def className() -> str: ...
    def dimConstrDesc(self, /) -> str: ...
    def dimConstrExpression(self, /) -> str: ...
    def dimConstrForm(self, /) -> bool: ...
    def dimConstrName(self, /) -> str: ...
    def dimConstrReference(self, /) -> bool: ...
    def dimConstrValue(self, /) -> str: ...
    def dimLine1Suppress(self, /) -> bool: ...
    def dimLine2Suppress(self, /) -> bool: ...
    def dimLineInside(self, /) -> bool: ...
    def dimensionLineColor(self, /) -> AcColor: ...
    def dimensionLineExtend(self, /) -> float: ...
    def dimensionLineWeight(self, /) -> AcLineWeight: ...
    def dimensionLinetype(self, /) -> str: ...
    def extLine1Linetype(self, /) -> str: ...
    def extLine1Suppress(self, /) -> bool: ...
    def extLine2Linetype(self, /) -> str: ...
    def extLine2Suppress(self, /) -> bool: ...
    def extLineFixedLen(self, /) -> float: ...
    def extLineFixedLenSuppress(self, /) -> bool: ...
    def extensionLineColor(self, /) -> AcColor: ...
    def extensionLineExtend(self, /) -> float: ...
    def extensionLineOffset(self, /) -> float: ...
    def extensionLineWeight(self, /) -> AcLineWeight: ...
    def fit(self, /) -> AcDimFit: ...
    def forceLineInside(self, /) -> bool: ...
    def fractionFormat(self, /) -> AcDimFractionType: ...
    def horizontalTextPosition(self, /) -> AcDimHorizontalJustification: ...
    def linearScaleFactor(self, /) -> float: ...
    def measurement(self, /) -> float: ...
    def primaryUnitsPrecision(self, /) -> AcDimPrecision: ...
    def roundDistance(self, /) -> float: ...
    def setAltRoundDistance(self, val: float, /) -> None: ...
    def setAltSubUnitsFactor(self, val: float, /) -> None: ...
    def setAltSubUnitsSuffix(self, val: str, /) -> None: ...
    def setAltSuppressLeadingZeros(self, val: bool, /) -> None: ...
    def setAltSuppressTrailingZeros(self, val: bool, /) -> None: ...
    def setAltSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setAltSuppressZeroInches(self, val: bool, /) -> None: ...
    def setAltTextPrefix(self, val: str, /) -> None: ...
    def setAltTextSuffix(self, val: str, /) -> None: ...
    def setAltTolerancePrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setAltToleranceSuppressLeadingZeros(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressTrailingZeros(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setAltToleranceSuppressZeroInches(self, val: bool, /) -> None: ...
    def setAltUnits(self, val: bool, /) -> None: ...
    def setAltUnitsFormat(self, val: PyAx.AcDimUnits, /) -> None: ...
    def setAltUnitsPrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setAltUnitsScale(self, val: float, /) -> None: ...
    def setArrowhead1Block(self, val: str, /) -> None: ...
    def setArrowhead1Type(self, val: PyAx.AcDimArrowheadType, /) -> None: ...
    def setArrowhead2Block(self, val: str, /) -> None: ...
    def setArrowhead2Type(self, val: PyAx.AcDimArrowheadType, /) -> None: ...
    def setArrowheadSize(self, val: float, /) -> None: ...
    def setDimConstrDesc(self, val: str, /) -> None: ...
    def setDimConstrExpression(self, val: str, /) -> None: ...
    def setDimConstrForm(self, val: bool, /) -> None: ...
    def setDimConstrName(self, val: str, /) -> None: ...
    def setDimConstrReference(self, val: bool, /) -> None: ...
    def setDimConstrValue(self, val: str, /) -> None: ...
    def setDimLine1Suppress(self, val: bool, /) -> None: ...
    def setDimLine2Suppress(self, val: bool, /) -> None: ...
    def setDimLineInside(self, val: bool, /) -> None: ...
    def setDimensionLineColor(self, val: PyAx.AcColor, /) -> None: ...
    def setDimensionLineExtend(self, val: float, /) -> None: ...
    def setDimensionLineWeight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setDimensionLinetype(self, val: str, /) -> None: ...
    def setExtLine1Linetype(self, val: str, /) -> None: ...
    def setExtLine1Suppress(self, val: bool, /) -> None: ...
    def setExtLine2Linetype(self, val: str, /) -> None: ...
    def setExtLine2Suppress(self, val: bool, /) -> None: ...
    def setExtLineFixedLen(self, val: float, /) -> None: ...
    def setExtLineFixedLenSuppress(self, val: bool, /) -> None: ...
    def setExtensionLineColor(self, val: PyAx.AcColor, /) -> None: ...
    def setExtensionLineExtend(self, val: float, /) -> None: ...
    def setExtensionLineOffset(self, val: float, /) -> None: ...
    def setExtensionLineWeight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setFit(self, val: PyAx.AcDimFit, /) -> None: ...
    def setForceLineInside(self, val: bool, /) -> None: ...
    def setFractionFormat(self, val: PyAx.AcDimFractionType, /) -> None: ...
    def setHorizontalTextPosition(self, val: PyAx.AcDimHorizontalJustification, /) -> None: ...
    def setLinearScaleFactor(self, val: float, /) -> None: ...
    def setPrimaryUnitsPrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setRoundDistance(self, val: float, /) -> None: ...
    def setSubUnitsFactor(self, val: float, /) -> None: ...
    def setSubUnitsSuffix(self, val: str, /) -> None: ...
    def setSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setSuppressZeroInches(self, val: bool, /) -> None: ...
    def setTextInside(self, val: bool, /) -> None: ...
    def setTextInsideAlign(self, val: bool, /) -> None: ...
    def setTextOutsideAlign(self, val: bool, /) -> None: ...
    def setToleranceSuppressZeroFeet(self, val: bool, /) -> None: ...
    def setToleranceSuppressZeroInches(self, val: bool, /) -> None: ...
    def setUnitsFormat(self, val: PyAx.AcDimLUnits, /) -> None: ...
    def subUnitsFactor(self, /) -> float: ...
    def subUnitsSuffix(self, /) -> str: ...
    def suppressZeroFeet(self, /) -> bool: ...
    def suppressZeroInches(self, /) -> bool: ...
    def textInside(self, /) -> bool: ...
    def textInsideAlign(self, /) -> bool: ...
    def textOutsideAlign(self, /) -> bool: ...
    def toleranceSuppressZeroFeet(self, /) -> bool: ...
    def toleranceSuppressZeroInches(self, /) -> bool: ...
    def unitsFormat(self, /) -> AcDimLUnits: ...

class AcadDimStyle(PyAx.AcadObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadDimStyle: ...
    @staticmethod
    def className() -> str: ...
    def copyFrom(self, val: PyAx.AcadObject, /) -> None: ...
    def name(self, /) -> str: ...
    def setName(self, val: str, /) -> None: ...

class AcadDimStyles(PyAx.AcadObject):
    def __getitem__(self, index: int, /) -> AcadDimStyle: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __iter__(self, /) -> Iterator[PyAx.AcadDimStyle]: ...
    def __reduce__(self, /) -> Any: ...
    def add(self, name: str, /) -> AcadDimStyle: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadDimStyles: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, index: int, /) -> AcadDimStyle: ...
    def items(self, /) -> list[PyAx.AcadDimStyle]: ...

class AcadDimension(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadDimension: ...
    @staticmethod
    def className() -> str: ...
    def decimalSeparator(self, /) -> str: ...
    def dimTxtDirection(self, /) -> bool: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def rotation(self, /) -> float: ...
    def scaleFactor(self, /) -> float: ...
    def setDecimalSeparator(self, val: str, /) -> None: ...
    def setDimTxtDirection(self, val: bool, /) -> None: ...
    def setNormal(self, val: PyGe.Vector3d, /) -> None: ...
    def setRotation(self, val: float, /) -> None: ...
    def setScaleFactor(self, val: float, /) -> None: ...
    def setStyleName(self, val: str, /) -> None: ...
    def setSuppressLeadingZeros(self, val: bool, /) -> None: ...
    def setSuppressTrailingZeros(self, val: bool, /) -> None: ...
    def setTextColor(self, val: PyAx.AcColor, /) -> None: ...
    def setTextFill(self, val: bool, /) -> None: ...
    def setTextFillColor(self, val: PyAx.AcColor, /) -> None: ...
    def setTextGap(self, val: float, /) -> None: ...
    def setTextHeight(self, val: float, /) -> None: ...
    def setTextMovement(self, val: PyAx.AcDimTextMovement, /) -> None: ...
    def setTextOverride(self, val: str, /) -> None: ...
    def setTextPosition(self, val: PyGe.Point3d, /) -> None: ...
    def setTextPrefix(self, val: str, /) -> None: ...
    def setTextRotation(self, val: float, /) -> None: ...
    def setTextStyle(self, val: str, /) -> None: ...
    def setTextSuffix(self, val: str, /) -> None: ...
    def setToleranceDisplay(self, val: PyAx.AcDimToleranceMethod, /) -> None: ...
    def setToleranceHeightScale(self, val: float, /) -> None: ...
    def setToleranceJustification(self, val: PyAx.AcDimToleranceJustify, /) -> None: ...
    def setToleranceLowerLimit(self, val: float, /) -> None: ...
    def setTolerancePrecision(self, val: PyAx.AcDimPrecision, /) -> None: ...
    def setToleranceSuppressLeadingZeros(self, val: bool, /) -> None: ...
    def setToleranceSuppressTrailingZeros(self, val: bool, /) -> None: ...
    def setToleranceUpperLimit(self, val: float, /) -> None: ...
    def setVerticalTextPosition(self, val: PyAx.AcDimVerticalJustification, /) -> None: ...
    def styleName(self, /) -> str: ...
    def suppressLeadingZeros(self, /) -> bool: ...
    def suppressTrailingZeros(self, /) -> bool: ...
    def textColor(self, /) -> AcColor: ...
    def textFill(self, /) -> bool: ...
    def textFillColor(self, /) -> AcColor: ...
    def textGap(self, /) -> float: ...
    def textHeight(self, /) -> float: ...
    def textMovement(self, /) -> AcDimTextMovement: ...
    def textOverride(self, /) -> str: ...
    def textPosition(self, /) -> PyGe.Point3d: ...
    def textPrefix(self, /) -> str: ...
    def textRotation(self, /) -> float: ...
    def textStyle(self, /) -> str: ...
    def textSuffix(self, /) -> str: ...
    def toleranceDisplay(self, /) -> AcDimToleranceMethod: ...
    def toleranceHeightScale(self, /) -> float: ...
    def toleranceJustification(self, /) -> AcDimToleranceJustify: ...
    def toleranceLowerLimit(self, /) -> float: ...
    def tolerancePrecision(self, /) -> AcDimPrecision: ...
    def toleranceSuppressLeadingZeros(self, /) -> bool: ...
    def toleranceSuppressTrailingZeros(self, /) -> bool: ...
    def toleranceUpperLimit(self, /) -> float: ...
    def verticalTextPosition(self, /) -> AcDimVerticalJustification: ...

class AcadDocument(PyAx.AcadDatabase):
    def HWND(self, /) -> int: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def activate(self, /) -> None: ...
    def activeDimStyle(self, /) -> AcadDimStyle: ...
    def activeLayer(self, /) -> AcadLayer: ...
    def activeLayout(self, /) -> AcadLayout: ...
    def activeLinetype(self, /) -> AcadLineType: ...
    def activeMaterial(self, /) -> AcadMaterial: ...
    def activePViewport(self, /) -> AcadPViewport: ...
    def activeSelectionSet(self, /) -> AcadSelectionSet: ...
    def activeSpace(self, /) -> AcActiveSpace: ...
    def activeTextStyle(self, /) -> AcadTextStyle: ...
    def activeUCS(self, /) -> AcadUCS: ...
    def activeViewport(self, /) -> AcadViewport: ...
    def auditInfo(self, val: bool, /) -> None: ...
    @staticmethod
    def className() -> str: ...
    def close(self, saveChanges: bool = False, fileName: str = ..., /) -> None: ...
    def database(self, /) -> AcadDatabase: ...
    def endUndoMark(self, /) -> None: ...
    def exportToFile(
        self, fileName: str, extension: str, sset: PyAx.AcadSelectionSet, /
    ) -> None: ...
    def fullName(self, /) -> str: ...
    def getVariable(self, varName: str, /) -> object: ...
    def height(self, /) -> int: ...
    def importFile(
        self, fullPath: str, insertionPoint: PyGe.Point3d, scaleFactor: float, /
    ) -> AcadBlockReference: ...
    def isActive(self, /) -> bool: ...
    def isReadOnly(self, /) -> bool: ...
    def isSaved(self, /) -> bool: ...
    def loadShapeFile(self, name: str, /) -> None: ...
    def mSpace(self, /) -> bool: ...
    def name(self, /) -> str: ...
    def objectSnapMode(self, /) -> bool: ...
    def open(self, fullPath: str, /) -> AcadDocument: ...
    def path(self, /) -> str: ...
    def pickfirstSelectionSet(self, /) -> AcadSelectionSet: ...
    def plot(self, /) -> AcadPlot: ...
    def postCommand(self, cmd: str, /) -> None: ...
    def purgeAll(self, /) -> None: ...
    def regen(self, rt: PyAx.AcRegenType, /) -> None: ...
    def save(self, /) -> None: ...
    @overload
    def saveAs(self, fileName: str, /) -> None: ...
    @overload
    def saveAs(self, fileName: str, saType: PyAx.AcSaveAsType, /) -> None: ...
    @overload
    def saveAs(
        self, fileName: str, saType: PyAx.AcSaveAsType, pr: PyAx.AcadSecurityParams, /
    ) -> None: ...
    @overload
    def saveAs(self, *args) -> None: ...
    def selectionSets(self, /) -> AcadSelectionSets: ...
    def sendCommand(self, cmd: str, /) -> None: ...
    def setActiveDimStyle(self, val: PyAx.AcadDimStyle, /) -> None: ...
    def setActiveLayer(self, val: PyAx.AcadLayer, /) -> None: ...
    def setActiveLayout(self, val: PyAx.AcadLayout, /) -> None: ...
    def setActiveLinetype(self, val: PyAx.AcadLineType, /) -> None: ...
    def setActiveMaterial(self, val: PyAx.AcadMaterial, /) -> None: ...
    def setActivePViewport(self, val: PyAx.AcadPViewport, /) -> None: ...
    def setActiveSpace(self, val: PyAx.AcActiveSpace, /) -> None: ...
    def setActiveTextStyle(self, val: PyAx.AcadTextStyle, /) -> None: ...
    def setActiveUCS(self, val: PyAx.AcadUCS, /) -> None: ...
    def setActiveViewport(self, val: PyAx.AcadViewport, /) -> None: ...
    def setHeight(self, val: int, /) -> None: ...
    def setMSpace(self, val: bool, /) -> None: ...
    def setObjectSnapMode(self, val: bool, /) -> None: ...
    def setVariable(self, varName: str, obj: Any, /) -> None: ...
    def setWidth(self, val: int, /) -> None: ...
    def setWindowState(self, val: PyAx.AcWindowState, /) -> None: ...
    def startUndoMark(self, /) -> None: ...
    def utility(self, /) -> AcadUtility: ...
    def wblock(self, fileName: str, sset: PyAx.AcadSelectionSet, /) -> None: ...
    def width(self, /) -> int: ...
    def windowState(self, /) -> AcWindowState: ...
    def windowTitle(self, /) -> str: ...

class AcadDocuments:
    def __getitem__(self, index: int, /) -> AcadDocument: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def add(self, template: str = ..., /) -> AcadDocument: ...
    @staticmethod
    def className() -> str: ...
    def close(self, /) -> None: ...
    def count(self, /) -> int: ...
    def item(self, index: int, /) -> AcadDocument: ...
    def open(self, path: str, readOnly: bool, /) -> AcadDocument: ...

class AcadDynamicBlockReferenceProperty:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def allowedValues(self, /) -> list[PyDb.EvalVariant]: ...
    @staticmethod
    def className() -> str: ...
    def description(self, /) -> str: ...
    def isReadOnly(self, /) -> bool: ...
    def isShown(self, /) -> bool: ...
    def propertyName(self, /) -> str: ...
    def setValue(self, val: PyDb.EvalVariant, /) -> None: ...
    def unitsType(self, /) -> AcDynamicBlockReferencePropertyUnitsType: ...
    def value(self, /) -> PyDb.EvalVariant: ...

class AcadEllipse(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def area(self, /) -> float: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadEllipse: ...
    def center(self, /) -> PyGe.Point3d: ...
    @staticmethod
    def className() -> str: ...
    def endAngle(self, /) -> float: ...
    def endParameter(self, /) -> float: ...
    def endPoint(self, /) -> PyGe.Point3d: ...
    def majorAxis(self, /) -> PyGe.Vector3d: ...
    def majorRadius(self, /) -> float: ...
    def minorAxis(self, /) -> PyGe.Vector3d: ...
    def minorRadius(self, /) -> float: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def offset(self, val: float, /) -> list[PyAx.AcadEntity]: ...
    def radiusRatio(self, /) -> float: ...
    def setCenter(self, val: PyGe.Point3d, /) -> None: ...
    def setEndAngle(self, val: float, /) -> None: ...
    def setEndParameter(self, val: float, /) -> None: ...
    def setMajorAxis(self, val: PyGe.Vector3d, /) -> None: ...
    def setMajorRadius(self, val: float, /) -> None: ...
    def setMinorRadius(self, val: float, /) -> None: ...
    def setNormal(self, val: PyGe.Vector3d, /) -> None: ...
    def setRadiusRatio(self, val: float, /) -> None: ...
    def setStartAngle(self, val: float, /) -> None: ...
    def setStartParameter(self, val: float, /) -> None: ...
    def startAngle(self, /) -> float: ...
    def startParameter(self, /) -> float: ...
    def startPoint(self, /) -> PyGe.Point3d: ...

class AcadEntity(PyAx.AcadObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def arrayPolar(
        self, numberOfObjects: int, angleToFill: float, centerPoint: PyGe.Point3d, /
    ) -> list[PyAx.AcadEntity]: ...
    def arrayRectangular(
        self,
        nRows: int,
        nColumns: int,
        nLevels: int,
        rowDist: float,
        colDist: float,
        levelDist: float,
        /,
    ) -> list[PyAx.AcadEntity]: ...
    def boundingBox(self, /) -> tuple[PyGe.Point3d, PyGe.Point3d]: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadEntity: ...
    @staticmethod
    def className() -> str: ...
    def color(self, /) -> AcColor: ...
    def copy(self, /) -> AcadEntity: ...
    def entityName(self, /) -> str: ...
    def entityTransparency(self, /) -> str: ...
    def entityType(self, /) -> int: ...
    def highlight(self, bHighlight: bool, /) -> None: ...
    def hyperlinks(self, /) -> AcadHyperlinks: ...
    def intersectWith(
        self, intersectObject: PyAx.AcadEntity, option: PyAx.AcExtendOption, /
    ) -> list[PyGe.Point3d]: ...
    def isVisible(self, /) -> bool: ...
    def layer(self, /) -> str: ...
    def linetype(self, /) -> str: ...
    def linetypeScale(self, /) -> float: ...
    def lineweight(self, /) -> AcLineWeight: ...
    def material(self, /) -> str: ...
    def mirror(self, point1: PyGe.Point3d, point2: PyGe.Point3d, /) -> AcadEntity: ...
    def mirror3D(
        self, point1: PyGe.Point3d, point2: PyGe.Point3d, point3: PyGe.Point3d, /
    ) -> AcadEntity: ...
    def move(self, fromPoint: PyGe.Point3d, toPoint: PyGe.Point3d, /) -> None: ...
    def plotStyleName(self, /) -> str: ...
    def rotate(self, basePoint: PyGe.Point3d, rotationAngle: float, /) -> None: ...
    def rotate3D(
        self, point1: PyGe.Point3d, point2: PyGe.Point3d, rotationAngle: float, /
    ) -> None: ...
    def scaleEntity(self, basePoint: PyGe.Point3d, scaleFactor: float, /) -> None: ...
    def setColor(self, color: PyAx.AcColor, /) -> None: ...
    def setEntityTransparency(self, entityTransparency: str, /) -> None: ...
    def setLayer(self, layer: str, /) -> None: ...
    def setLinetype(self, linetype: str, /) -> None: ...
    def setLinetypeScale(self, linetypeScale: float, /) -> None: ...
    def setLineweight(self, lineweight: PyAx.AcLineWeight, /) -> None: ...
    def setMaterial(self, material: str, /) -> None: ...
    def setPlotStyleName(self, plotStyleName: str, /) -> None: ...
    def setTrueColor(self, trueColor: PyAx.AcadAcCmColor, /) -> None: ...
    def setVisible(self, bVisible: bool, /) -> None: ...
    def transformBy(self, xform: PyGe.Matrix3d, /) -> None: ...
    def trueColor(self, /) -> AcadAcCmColor: ...
    def update(self, /) -> None: ...

class AcadExternalReference(PyAx.AcadBlockReference):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadExternalReference: ...
    @staticmethod
    def className() -> str: ...
    def layerPropertyOverrides(self, val: str, /) -> bool: ...
    def path(self, /) -> str: ...
    def setPath(self, val: str, /) -> None: ...

class AcadGroup(PyAx.AcadObject):
    def __getitem__(self, index: int, /) -> AcadEntity: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __iter__(self, /) -> Iterator[PyAx.AcadEntity]: ...
    def __reduce__(self, /) -> Any: ...
    def appendItems(self, val: Collection[PyAx.AcadEntity], /) -> None: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadGroup: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def highlight(self, val: bool, /) -> None: ...
    def item(self, index: int, /) -> AcadEntity: ...
    def items(self, /) -> list[PyAx.AcadEntity]: ...
    def name(self, /) -> str: ...
    def removeItems(self, val: Collection[PyAx.AcadEntity], /) -> None: ...
    def setColor(self, val: PyAx.AcColor, /) -> None: ...
    def setLayer(self, val: str, /) -> None: ...
    def setLineWeight(self, val: bool, /) -> None: ...
    def setLinetype(self, val: str, /) -> None: ...
    def setLinetypeScale(self, val: float, /) -> None: ...
    def setMaterial(self, /) -> None: ...
    def setName(self, val: str, /) -> None: ...
    def setPlotStyleName(self, val: bool, /) -> None: ...
    def setTrueColor(self, val: PyAx.AcadAcCmColor, /) -> None: ...
    def setVisible(self, val: float, /) -> None: ...
    def update(self, /) -> None: ...

class AcadGroups(PyAx.AcadObject):
    def __getitem__(self, index: int, /) -> AcadGroup: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __iter__(self, /) -> Iterator[PyAx.AcadGroup]: ...
    def __reduce__(self, /) -> Any: ...
    def add(self, name: str, /) -> AcadGroup: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadGroups: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, index: int, /) -> AcadGroup: ...
    def items(self, /) -> list[PyAx.AcadGroup]: ...

class AcadHatch(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def appendInnerLoop(self, objects: Collection[PyAx.AcadEntity], /) -> None: ...
    def appendOuterLoop(self, objects: Collection[PyAx.AcadEntity], /) -> None: ...
    def area(self, /) -> float: ...
    def associativeHatch(self, /) -> bool: ...
    def backgroundColor(self, /) -> AcadAcCmColor: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadHatch: ...
    @staticmethod
    def className() -> str: ...
    def elevation(self, /) -> float: ...
    def evaluate(self, /) -> None: ...
    def gradientAngle(self, /) -> float: ...
    def gradientCentered(self, /) -> bool: ...
    def gradientColor1(self, /) -> AcadAcCmColor: ...
    def gradientColor2(self, /) -> AcadAcCmColor: ...
    def gradientName(self, /) -> str: ...
    def hatchObjectType(self, /) -> AcHatchObjectType: ...
    def hatchStyle(self, /) -> AcHatchStyle: ...
    def insertLoopAt(
        self, index: int, loopType: PyAx.AcLoopType, objects: Collection[PyAx.AcadEntity], /
    ) -> None: ...
    def isoPenWidth(self, /) -> AcISOPenWidth: ...
    def loopAt(self, index: int, /) -> list[PyAx.AcadEntity]: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def numberOfLoops(self, /) -> int: ...
    def origin(self, /) -> PyGe.Point3d: ...
    def patternAngle(self, /) -> float: ...
    def patternDouble(self, /) -> bool: ...
    def patternName(self, /) -> str: ...
    def patternScale(self, /) -> float: ...
    def patternSpace(self, /) -> float: ...
    def patternType(self, /) -> AcPatternType: ...
    def setAssociativeHatch(self, val: bool, /) -> None: ...
    def setBackgroundColor(self, val: PyAx.AcadAcCmColor, /) -> None: ...
    def setElevation(self, val: float, /) -> None: ...
    def setGradientAngle(self, val: float, /) -> None: ...
    def setGradientCentered(self, val: float, /) -> None: ...
    def setGradientColor1(self, val: PyAx.AcadAcCmColor, /) -> None: ...
    def setGradientColor2(self, val: PyAx.AcadAcCmColor, /) -> None: ...
    def setGradientName(self, val: str, /) -> None: ...
    def setHatchObjectType(self, val: PyAx.AcHatchObjectType, /) -> None: ...
    def setHatchStyle(self, val: PyAx.AcHatchStyle, /) -> None: ...
    def setISOPenWidth(self, val: PyAx.AcISOPenWidth, /) -> None: ...
    def setNormal(self, val: PyGe.Vector3d, /) -> None: ...
    def setOrigin(self, val: PyGe.Point3d, /) -> None: ...
    def setPattern(self, patternType: int, name: str, /) -> None: ...
    def setPatternAngle(self, val: float, /) -> None: ...
    def setPatternDouble(self, val: bool, /) -> None: ...
    def setPatternScale(self, val: float, /) -> None: ...
    def setPatternSpace(self, val: float, /) -> None: ...

class AcadHyperlink:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def clear(self, /) -> None: ...
    def setURL(self, val: str, /) -> None: ...
    def setURLDescription(self, val: str, /) -> None: ...
    def setURLNamedLocation(self, val: str, /) -> None: ...
    def url(self, /) -> str: ...
    def urlDescription(self, /) -> str: ...
    def urlNamedLocation(self, /) -> str: ...

class AcadHyperlinks:
    def __getitem__(self, index: int, /) -> AcadHyperlink: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def add(self, name: str, description: str, namedLocation: str, /) -> AcadHyperlink: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, index: int, /) -> AcadHyperlink: ...

class AcadIdPair:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def isCloned(self, /) -> bool: ...
    def isOwnerXlated(self, /) -> bool: ...
    def isPrimary(self, /) -> bool: ...
    def key(self, /) -> PyDb.ObjectId: ...
    def value(self, /) -> PyDb.ObjectId: ...

class AcadLWPolyline(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def addVertex(self, index: int, val: PyGe.Point2d, /) -> None: ...
    def area(self, /) -> float: ...
    def bulge(self, index: int, /) -> float: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadLWPolyline: ...
    @staticmethod
    def className() -> str: ...
    def constantWidth(self, /) -> float: ...
    def coordinate(self, index: int, /) -> PyGe.Point2d: ...
    def coordinates(self, /) -> list[PyGe.Point2d]: ...
    def elevation(self, /) -> float: ...
    def explode(self, /) -> list[PyAx.AcadEntity]: ...
    def isClosed(self, /) -> bool: ...
    def length(self, /) -> float: ...
    def linetypeGeneration(self, /) -> bool: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def offset(self, val: float, /) -> list[PyAx.AcadEntity]: ...
    def setBulge(self, index: int, val: float, /) -> None: ...
    def setClosed(self, val: bool, /) -> None: ...
    def setConstantWidth(self, val: float, /) -> None: ...
    def setCoordinate(self, index: int, val: PyGe.Point2d, /) -> None: ...
    def setCoordinates(self, coords: Collection[PyGe.Point2d], /) -> None: ...
    def setElevation(self, val: float, /) -> None: ...
    def setLinetypeGeneration(self, val: bool, /) -> None: ...
    def setNormal(self, val: PyGe.Vector3d, /) -> None: ...
    def setThickness(self, val: float, /) -> None: ...
    def setWidth(self, index: int, startWidth: float, endWidth: float, /) -> None: ...
    def thickness(self, /) -> float: ...
    def width(self, index: int, /) -> tuple[float, float]: ...

class AcadLayer(PyAx.AcadObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadLayer: ...
    @staticmethod
    def className() -> str: ...
    def color(self, /) -> AcColor: ...
    def description(self, /) -> str: ...
    def freeze(self, /) -> bool: ...
    def layerOn(self, /) -> bool: ...
    def linetype(self, /) -> str: ...
    def lineweight(self, /) -> AcLineWeight: ...
    def lock(self, /) -> bool: ...
    def material(self, /) -> str: ...
    def name(self, /) -> str: ...
    def plotStyleName(self, /) -> str: ...
    def plottable(self, /) -> bool: ...
    def setColor(self, val: PyAx.AcColor, /) -> None: ...
    def setDescription(self, val: str, /) -> None: ...
    def setFreeze(self, val: bool, /) -> None: ...
    def setLayerOn(self, val: bool, /) -> None: ...
    def setLineWeight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setLinetype(self, val: str, /) -> None: ...
    def setLock(self, val: bool, /) -> None: ...
    def setMaterial(self, val: str, /) -> None: ...
    def setName(self, val: str, /) -> None: ...
    def setPlotStyleName(self, val: str, /) -> None: ...
    def setPlottable(self, val: bool, /) -> None: ...
    def setTrueColor(self, val: PyAx.AcadAcCmColor, /) -> None: ...
    def setViewportDefault(self, val: bool, /) -> None: ...
    def trueColor(self, /) -> AcadAcCmColor: ...
    def used(self, /) -> bool: ...
    def viewportDefault(self, /) -> bool: ...

class AcadLayers(PyAx.AcadObject):
    def __getitem__(self, index: int, /) -> AcadLayer: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __iter__(self, /) -> Iterator[PyAx.AcadLayer]: ...
    def __reduce__(self, /) -> Any: ...
    def add(self, name: str, /) -> AcadLayer: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadLayers: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, index: int, /) -> AcadLayer: ...
    def items(self, /) -> list[PyAx.AcadLayer]: ...

class AcadLayout(PyAx.AcadPlotConfiguration):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def block(self, /) -> AcadBlock: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadLayout: ...
    @staticmethod
    def className() -> str: ...
    def setTabOrder(self, val: int, /) -> None: ...
    def tabOrder(self, /) -> int: ...

class AcadLayouts(PyAx.AcadObject):
    def __getitem__(self, index: int, /) -> AcadLayout: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __iter__(self, /) -> Iterator[PyAx.AcadLayout]: ...
    def __reduce__(self, /) -> Any: ...
    def add(self, name: str, /) -> AcadLayout: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadLayouts: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, index: int, /) -> AcadLayout: ...
    def items(self, /) -> list[PyAx.AcadLayout]: ...

class AcadLeader(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def annotation(self, /) -> AcadEntity: ...
    def arrowheadBlock(self, /) -> str: ...
    def arrowheadSize(self, /) -> float: ...
    def arrowheadType(self, /) -> AcDimArrowheadType: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadLeader: ...
    @staticmethod
    def className() -> str: ...
    def coordinate(self, index: int, /) -> PyGe.Point3d: ...
    def coordinates(self, /) -> list[PyGe.Point3d]: ...
    def dimensionLineColor(self, /) -> AcColor: ...
    def dimensionLineWeight(self, /) -> AcLineWeight: ...
    def evaluate(self, /) -> None: ...
    def leaderType(self, /) -> AcLeaderType: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def scaleFactor(self, /) -> float: ...
    def setAnnotation(self, val: PyAx.AcadEntity, /) -> None: ...
    def setArrowheadBlock(self, val: str, /) -> None: ...
    def setArrowheadSize(self, val: float, /) -> None: ...
    def setArrowheadType(self, val: PyAx.AcDimArrowheadType, /) -> None: ...
    def setCoordinates(self, coords: Collection[PyGe.Point3d], /) -> None: ...
    def setDimensionLineColor(self, val: PyAx.AcColor, /) -> None: ...
    def setDimensionLineWeight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setLeaderType(self, val: PyAx.AcLeaderType, /) -> None: ...
    def setScaleFactor(self, val: float, /) -> None: ...
    def setStyleName(self, val: str, /) -> None: ...
    def setTextGap(self, val: float, /) -> None: ...
    def setVerticalTextPosition(self, val: PyAx.AcDimVerticalJustification, /) -> None: ...
    def styleName(self, /) -> str: ...
    def textGap(self, /) -> float: ...
    def verticalTextPosition(self, /) -> AcDimVerticalJustification: ...

class AcadLine(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def angle(self, /) -> float: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadLine: ...
    @staticmethod
    def className() -> str: ...
    def delta(self, /) -> PyGe.Vector3d: ...
    def endPoint(self, /) -> PyGe.Point3d: ...
    def length(self, /) -> float: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def offset(self, val: float, /) -> list[PyAx.AcadEntity]: ...
    def setEndPoint(self, val: PyGe.Point3d, /) -> None: ...
    def setNormal(self, val: PyGe.Vector3d, /) -> None: ...
    def setStartPoint(self, val: PyGe.Point3d, /) -> None: ...
    def setThickness(self, val: float, /) -> None: ...
    def startPoint(self, /) -> PyGe.Point3d: ...
    def thickness(self, /) -> float: ...

class AcadLineType(PyAx.AcadObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadLineType: ...
    @staticmethod
    def className() -> str: ...
    def description(self, /) -> str: ...
    def name(self, /) -> str: ...
    def setDescription(self, val: str, /) -> None: ...
    def setName(self, val: str, /) -> None: ...

class AcadLineTypes(PyAx.AcadObject):
    def __getitem__(self, index: int, /) -> AcadLineType: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __iter__(self, /) -> Iterator[PyAx.AcadLineType]: ...
    def __reduce__(self, /) -> Any: ...
    def add(self, name: str, /) -> AcadLineType: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadLineTypes: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, index: int, /) -> AcadLineType: ...
    def items(self, /) -> list[PyAx.AcadLineType]: ...

class AcadMInsertBlock(PyAx.AcadBlockReference):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadMInsertBlock: ...
    @staticmethod
    def className() -> str: ...
    def columnSpacing(self, /) -> float: ...
    def columns(self, /) -> int: ...
    def rowSpacing(self, /) -> float: ...
    def rows(self, /) -> int: ...
    def setColumnSpacing(self, val: float, /) -> None: ...
    def setColumns(self, val: int, /) -> None: ...
    def setRowSpacing(self, val: float, /) -> None: ...
    def setRows(self, val: int, /) -> None: ...

class AcadMLeader(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def addLeader(self, /) -> int: ...
    def addLeaderLine(self, val: int, coords: Collection[PyGe.Point3d], /) -> int: ...
    def addLeaderLineEx(self, coords: Collection[PyGe.Point3d], /) -> int: ...
    def arrowheadBlock(self, /) -> str: ...
    def arrowheadSize(self, /) -> float: ...
    def arrowheadType(self, /) -> AcDimArrowheadType: ...
    def blockAttributeValue(self, val: PyDb.ObjectId, /) -> str: ...
    def blockConnectionType(self, /) -> AcBlockConnectionType: ...
    def blockScale(self, /) -> float: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadMLeader: ...
    @staticmethod
    def className() -> str: ...
    def contentBlockName(self, /) -> str: ...
    def contentBlockType(self, /) -> AcPredefBlockType: ...
    def contentType(self, /) -> AcMLeaderContentType: ...
    def dogLegged(self, /) -> bool: ...
    def doglegDirection(self, val: int, /) -> PyGe.Vector3d: ...
    def doglegLength(self, /) -> float: ...
    def landingGap(self, /) -> float: ...
    def leaderCount(self, /) -> int: ...
    def leaderIndex(self, val: int, /) -> int: ...
    def leaderLineColor(self, /) -> AcadAcCmColor: ...
    def leaderLineIndexes(self, val: int, /) -> list[int]: ...
    def leaderLineVertices(self, val: int, /) -> list[PyGe.Point3d]: ...
    def leaderLineWeight(self, /) -> AcLineWeight: ...
    def leaderLinetype(self, /) -> str: ...
    def leaderType(self, /) -> AcMLeaderType: ...
    def removeLeader(self, val: int, /) -> None: ...
    def removeLeaderLine(self, val: int, /) -> None: ...
    def scaleFactor(self, /) -> float: ...
    def setArrowheadBlock(self, val: str, /) -> None: ...
    def setArrowheadSize(self, val: float, /) -> None: ...
    def setArrowheadType(self, val: PyAx.AcDimArrowheadType, /) -> None: ...
    def setBlockAttributeValue(self, id: PyDb.ObjectId, val: str, /) -> None: ...
    def setBlockConnectionType(self, val: PyAx.AcBlockConnectionType, /) -> None: ...
    def setBlockScale(self, val: float, /) -> None: ...
    def setContentBlockName(self, val: str, /) -> None: ...
    def setContentBlockType(self, val: PyAx.AcPredefBlockType, /) -> None: ...
    def setContentType(self, val: PyAx.AcMLeaderContentType, /) -> None: ...
    def setDogLegged(self, val: bool, /) -> None: ...
    def setDoglegDirection(self, idx: int, val: PyGe.Vector3d, /) -> None: ...
    def setDoglegLength(self, val: float, /) -> None: ...
    def setLandingGap(self, val: float, /) -> None: ...
    def setLeaderLineColor(self, val: PyAx.AcadAcCmColor, /) -> None: ...
    def setLeaderLineVertices(self, val: int, coords: Collection[PyGe.Point3d], /) -> None: ...
    def setLeaderLineWeight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setLeaderLinetype(self, val: str, /) -> None: ...
    def setLeaderType(self, val: PyAx.AcMLeaderType, /) -> None: ...
    def setScaleFactor(self, val: float, /) -> None: ...
    def setStyleName(self, val: str, /) -> None: ...
    def setTextAttachmentDirection(self, val: PyAx.AcTextAttachmentDirection, /) -> None: ...
    def setTextBackgroundFill(self, val: bool, /) -> None: ...
    def setTextBottomAttachmentType(self, val: PyAx.AcVerticalTextAttachmentType, /) -> None: ...
    def setTextDirection(self, val: PyAx.AcDrawingDirection, /) -> None: ...
    def setTextFrameDisplay(self, val: bool, /) -> None: ...
    def setTextHeight(self, val: float, /) -> None: ...
    def setTextJustify(self, val: PyAx.AcAttachmentPoint, /) -> None: ...
    def setTextLeftAttachmentType(self, val: PyAx.AcTextAttachmentType, /) -> None: ...
    def setTextLineSpacingDistance(self, val: float, /) -> None: ...
    def setTextLineSpacingFactor(self, val: float, /) -> None: ...
    def setTextLineSpacingStyle(self, val: PyAx.AcLineSpacingStyle, /) -> None: ...
    def setTextRightAttachmentType(self, val: PyAx.AcTextAttachmentType, /) -> None: ...
    def setTextRotation(self, val: float, /) -> None: ...
    def setTextString(self, val: str, /) -> None: ...
    def setTextStyleName(self, val: str, /) -> None: ...
    def setTextTopAttachmentType(self, val: PyAx.AcVerticalTextAttachmentType, /) -> None: ...
    def setTextWidth(self, val: float, /) -> None: ...
    def styleName(self, /) -> str: ...
    def textAttachmentDirection(self, /) -> AcTextAttachmentDirection: ...
    def textBackgroundFill(self, /) -> bool: ...
    def textBottomAttachmentType(self, /) -> AcVerticalTextAttachmentType: ...
    def textDirection(self, /) -> AcDrawingDirection: ...
    def textFrameDisplay(self, /) -> bool: ...
    def textHeight(self, /) -> float: ...
    def textJustify(self, /) -> AcAttachmentPoint: ...
    def textLeftAttachmentType(self, /) -> AcTextAttachmentType: ...
    def textLineSpacingDistance(self, /) -> float: ...
    def textLineSpacingFactor(self, /) -> float: ...
    def textLineSpacingStyle(self, /) -> AcLineSpacingStyle: ...
    def textRightAttachmentType(self, /) -> AcTextAttachmentType: ...
    def textRotation(self, /) -> float: ...
    def textString(self, /) -> str: ...
    def textStyleName(self, /) -> str: ...
    def textTopAttachmentType(self, /) -> AcVerticalTextAttachmentType: ...
    def textWidth(self, /) -> float: ...
    def vertexCount(self, val: int, /) -> int: ...

class AcadMLeaderStyle(PyAx.AcadObject):
    def BlockRotation(self, /) -> float: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def alignSpace(self, /) -> float: ...
    def annotative(self, /) -> bool: ...
    def arrowSize(self, /) -> float: ...
    def arrowSymbol(self, /) -> str: ...
    def bitFlags(self, /) -> int: ...
    def block(self, /) -> str: ...
    def blockConnectionType(self, /) -> AcBlockConnectionType: ...
    def blockScale(self, /) -> float: ...
    def breakSize(self, /) -> float: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadMLeaderStyle: ...
    @staticmethod
    def className() -> str: ...
    def contentType(self, /) -> AcMLeaderContentType: ...
    def description(self, /) -> str: ...
    def doglegLength(self, /) -> float: ...
    def drawLeaderOrderType(self, /) -> AcDrawLeaderOrderType: ...
    def drawMLeaderOrderType(self, /) -> AcDrawMLeaderOrderType: ...
    def enableBlockRotation(self, /) -> bool: ...
    def enableBlockScale(self, /) -> bool: ...
    def enableDogleg(self, /) -> bool: ...
    def enableFrameText(self, /) -> bool: ...
    def enableLanding(self, /) -> bool: ...
    def firstSegmentAngleConstraint(self, /) -> AcSegmentAngleType: ...
    def landingGap(self, /) -> float: ...
    def leaderLineColor(self, /) -> AcadAcCmColor: ...
    def leaderLineType(self, /) -> AcMLeaderType: ...
    def leaderLineTypeId(self, /) -> str: ...
    def leaderLineWeight(self, /) -> AcLineWeight: ...
    def maxLeaderSegmentsPoints(self, /) -> int: ...
    def name(self, /) -> str: ...
    def overwritePropChanged(self, /) -> bool: ...
    def scaleFactor(self, /) -> float: ...
    def secondSegmentAngleConstraint(self, /) -> AcSegmentAngleType: ...
    def setAlignSpace(self, val: float, /) -> None: ...
    def setAnnotative(self, val: bool, /) -> None: ...
    def setArrowSize(self, val: float, /) -> None: ...
    def setArrowSymbol(self, val: str, /) -> None: ...
    def setBitFlags(self, val: int, /) -> None: ...
    def setBlock(self, val: PyAx.AcadAcCmColor, /) -> None: ...
    def setBlockConnectionType(self, val: PyAx.AcBlockConnectionType, /) -> None: ...
    def setBlockRotation(self, val: float, /) -> None: ...
    def setBlockScale(self, val: float, /) -> None: ...
    def setBreakSize(self, val: float, /) -> None: ...
    def setContentType(self, val: PyAx.AcMLeaderContentType, /) -> None: ...
    def setDescription(self, val: str, /) -> None: ...
    def setDoglegLength(self, val: float, /) -> None: ...
    def setDrawLeaderOrderType(self, val: PyAx.AcDrawLeaderOrderType, /) -> None: ...
    def setDrawMLeaderOrderType(self, val: PyAx.AcMLeaderContentType, /) -> None: ...
    def setEnableBlockRotation(self, val: bool, /) -> None: ...
    def setEnableBlockScale(self, val: bool, /) -> None: ...
    def setEnableDogleg(self, val: bool, /) -> None: ...
    def setEnableFrameText(self, val: bool, /) -> None: ...
    def setEnableLanding(self, val: bool, /) -> None: ...
    def setFirstSegmentAngleConstraint(self, val: PyAx.AcSegmentAngleType, /) -> None: ...
    def setLandingGap(self, val: float, /) -> None: ...
    def setLeaderLineColor(self, val: PyAx.AcadAcCmColor, /) -> None: ...
    def setLeaderLineType(self, val: PyAx.AcMLeaderType, /) -> None: ...
    def setLeaderLineTypeId(self, val: str, /) -> None: ...
    def setLeaderLineWeight(self, val: AcLineWeight, /) -> None: ...
    def setMaxLeaderSegmentsPoints(self, val: int, /) -> None: ...
    def setName(self, val: str, /) -> None: ...
    def setScaleFactor(self, val: float, /) -> None: ...
    def setSecondSegmentAngleConstraint(self, val: PyAx.AcSegmentAngleType, /) -> None: ...
    def setTextAlignmentType(self, val: PyAx.AcTextAlignmentType, /) -> None: ...
    def setTextAngleType(self, val: PyAx.AcTextAngleType, /) -> None: ...
    def setTextAttachmentDirection(self, val: PyAx.AcTextAttachmentDirection, /) -> None: ...
    def setTextBottomAttachmentType(self, val: PyAx.AcVerticalTextAttachmentType, /) -> None: ...
    def setTextColor(self, val: PyAx.AcadAcCmColor, /) -> None: ...
    def setTextHeight(self, val: float, /) -> None: ...
    def setTextLeftAttachmentType(self, val: PyAx.AcTextAttachmentType, /) -> None: ...
    def setTextRightAttachmentType(self, val: PyAx.AcTextAttachmentType, /) -> None: ...
    def setTextString(self, val: str, /) -> None: ...
    def setTextStyle(self, val: str, /) -> None: ...
    def setTextTopAttachmentType(self, val: PyAx.AcVerticalTextAttachmentType, /) -> None: ...
    def textAlignmentType(self, /) -> AcTextAlignmentType: ...
    def textAngleType(self, /) -> AcTextAngleType: ...
    def textAttachmentDirection(self, /) -> AcTextAttachmentDirection: ...
    def textBottomAttachmentType(self, /) -> AcVerticalTextAttachmentType: ...
    def textColor(self, /) -> AcadAcCmColor: ...
    def textHeight(self, /) -> float: ...
    def textLeftAttachmentType(self, /) -> AcTextAttachmentType: ...
    def textRightAttachmentType(self, /) -> AcTextAttachmentType: ...
    def textString(self, /) -> str: ...
    def textStyle(self, /) -> str: ...
    def textTopAttachmentType(self, /) -> AcVerticalTextAttachmentType: ...

class AcadMLine(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadMLine: ...
    @staticmethod
    def className() -> str: ...
    def coordinates(self, /) -> list[PyGe.Point3d]: ...
    def justification(self, /) -> AcMLineJustification: ...
    def mlineScale(self, /) -> float: ...
    def setCoordinates(self, coords: Collection[PyGe.Point3d], /) -> None: ...
    def setJustification(self, val: PyAx.AcMLineJustification, /) -> None: ...
    def setMLineScale(self, val: float, /) -> None: ...
    def styleName(self, /) -> str: ...

class AcadMText(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def attachmentPoint(self, /) -> AcAttachmentPoint: ...
    def backgroundFill(self, /) -> bool: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadMText: ...
    @staticmethod
    def className() -> str: ...
    def drawingDirection(self, /) -> AcDrawingDirection: ...
    def fieldCode(self, /) -> str: ...
    def height(self, /) -> float: ...
    def insertionPoint(self, /) -> PyGe.Point3d: ...
    def lineSpacingDistance(self, /) -> float: ...
    def lineSpacingFactor(self, /) -> float: ...
    def lineSpacingStyle(self, /) -> AcLineSpacingStyle: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def rotation(self, /) -> float: ...
    def setAttachmentPoint(self, val: PyAx.AcAttachmentPoint, /) -> None: ...
    def setBackgroundFill(self, val: bool, /) -> None: ...
    def setDrawingDirection(self, val: PyAx.AcDrawingDirection, /) -> None: ...
    def setHeight(self, val: float, /) -> None: ...
    def setInsertionPoint(self, val: PyGe.Point3d, /) -> None: ...
    def setLineSpacingDistance(self, val: float, /) -> None: ...
    def setLineSpacingFactor(self, val: float, /) -> None: ...
    def setLineSpacingStyle(self, val: str, /) -> None: ...
    def setNormal(self, val: PyGe.Vector3d, /) -> None: ...
    def setRotation(self, val: float, /) -> None: ...
    def setStyleName(self, val: str, /) -> None: ...
    def setTextString(self, val: str, /) -> None: ...
    def setWidth(self, val: float, /) -> None: ...
    def styleName(self, /) -> str: ...
    def text(self, /) -> str: ...
    def textString(self, /) -> str: ...
    def width(self, /) -> float: ...

class AcadMaterial(PyAx.AcadObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadMaterial: ...
    @staticmethod
    def className() -> str: ...
    def description(self, /) -> str: ...
    def name(self, /) -> str: ...
    def setDescription(self, description: str, /) -> None: ...
    def setName(self, name: str, /) -> None: ...

class AcadMaterials(PyAx.AcadObject):
    def __getitem__(self, index: int, /) -> AcadMaterial: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __iter__(self, /) -> Iterator[PyAx.AcadMaterial]: ...
    def __reduce__(self, /) -> Any: ...
    def add(self, name: str, /) -> AcadMaterial: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadMaterials: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, index: int, /) -> AcadMaterial: ...
    def items(self, /) -> list[PyAx.AcadMaterial]: ...

class AcadMenuBar:
    def __getitem__(self, index: int, /) -> AcadPopupMenu: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, index, /) -> AcadPopupMenu: ...

class AcadMenuGroup:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def fileName(self, /) -> str: ...
    def menuType(self, /) -> AcMenuGroupType: ...
    def menus(self, /) -> AcadPopupMenus: ...
    def name(self, /) -> str: ...
    def parent(self, /) -> AcadMenuGroups: ...
    def save(self, menuType: PyAx.AcadMenuGroup, /) -> None: ...
    def saveAs(self, menuFileName: str, menuType: PyAx.AcadMenuGroup, /) -> None: ...
    def toolbars(self, /) -> AcadToolbars: ...
    def unload(self, /) -> None: ...

class AcadMenuGroups:
    def __getitem__(self, index: int, /) -> AcadMenuGroup: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, idx: int, /) -> AcadMenuGroup: ...
    def load(self, menuFileName: str, baseMenu: PyAx.AcadMenuGroup = ..., /) -> AcadMenuGroup: ...

class AcadObject:
    def __hash__(self, /) -> int: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __ne__(self, rhs: PyAx.AcadObject, /) -> bool: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadObject: ...
    @staticmethod
    def className() -> str: ...
    def clear(self, /) -> None: ...
    def database(self, /) -> AcadDatabase: ...
    def erase(self, /) -> None: ...
    def extensionDictionary(self, /) -> AcadDictionary: ...
    def handle(self, /) -> PyDb.Handle: ...
    def hasExtensionDictionary(self, /) -> bool: ...
    def isEqualTo(self, /) -> bool: ...
    def isNull(self, /) -> bool: ...
    def objectId(self, /) -> PyDb.ObjectId: ...
    def objectName(self, /) -> str: ...
    def ownerId(self, /) -> PyDb.ObjectId: ...
    def setXdata(self, xdata: Collection[tuple[int, Any]], /) -> None: ...
    def xdata(self, appName: str, /) -> list[tuple[int, Any]]: ...

class AcadPViewport(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def arcSmoothness(self, /) -> int: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadPViewport: ...
    def center(self, /) -> PyGe.Point3d: ...
    @staticmethod
    def className() -> str: ...
    def clipped(self, /) -> bool: ...
    def customScale(self, /) -> float: ...
    def direction(self, /) -> PyGe.Vector3d: ...
    def display(self, /) -> None: ...
    def displayLocked(self, /) -> bool: ...
    def gridOn(self, /) -> bool: ...
    def gridSpacing(self, /) -> tuple[float, float]: ...
    def hasSheetView(self, /) -> bool: ...
    def height(self, /) -> float: ...
    def labelBlockId(self, /) -> PyDb.ObjectId: ...
    def layerPropertyOverrides(self, /) -> bool: ...
    def lensLength(self, /) -> float: ...
    def modelView(self, /) -> AcadView: ...
    def removeHiddenLines(self, /) -> bool: ...
    def setArcSmoothness(self, val: int, /) -> None: ...
    def setCenter(self, val: PyGe.Point3d, /) -> None: ...
    def setCustomScale(self, val: float, /) -> None: ...
    def setDirection(self, val: PyGe.Vector3d, /) -> None: ...
    def setDisplayLocked(self, val: bool, /) -> None: ...
    def setGridOn(self, val: bool, /) -> None: ...
    def setGridSpacing(self, XSpacing: float, YSpacing: float, /) -> None: ...
    def setHeight(self, val: float, /) -> None: ...
    def setLabelBlockId(self, val: PyDb.ObjectId, /) -> None: ...
    def setLensLength(self, val: float, /) -> None: ...
    def setModelView(self, val: PyAx.AcadView, /) -> None: ...
    def setRemoveHiddenLines(self, val: bool, /) -> None: ...
    def setShadePlot(self, val: int, /) -> None: ...
    def setSheetView(self, val: PyAx.AcadView, /) -> None: ...
    def setSnapBasePoint(self, val: PyGe.Point2d, /) -> None: ...
    def setSnapOn(self, val: bool, /) -> None: ...
    def setSnapRotationAngle(self, val: float, /) -> None: ...
    def setSnapSpacing(self, XSpacing: float, YSpacing: float, /) -> None: ...
    def setStandardScale(self, val: PyAx.AcViewportScale, /) -> None: ...
    def setStandardScale2(self, val: int, /) -> None: ...
    def setStyleSheet(self, val: str, /) -> None: ...
    def setTarget(self, val: PyGe.Point3d, /) -> None: ...
    def setTwistAngle(self, val: bool, /) -> None: ...
    def setUCSIconAtOrigin(self, val: bool, /) -> None: ...
    def setUCSIconOn(self, val: bool, /) -> None: ...
    def setUCSPerViewport(self, val: bool, /) -> None: ...
    def setViewportOn(self, val: bool, /) -> None: ...
    def setVisualStyle(self, val: int, /) -> None: ...
    def setWidth(self, val: float, /) -> None: ...
    def shadePlot(self, /) -> int: ...
    def sheetView(self, /) -> AcadView: ...
    def snapBasePoint(self, /) -> PyGe.Point2d: ...
    def snapOn(self, /) -> bool: ...
    def snapRotationAngle(self, /) -> float: ...
    def snapSpacing(self, /) -> tuple[float, float]: ...
    def standardScale(self, /) -> AcViewportScale: ...
    def standardScale2(self, /) -> int: ...
    def styleSheet(self, /) -> str: ...
    def syncModelView(self, /) -> None: ...
    def target(self, /) -> PyGe.Point3d: ...
    def twistAngle(self, /) -> float: ...
    def ucsIconAtOrigin(self, /) -> bool: ...
    def ucsIconOn(self, /) -> bool: ...
    def ucsPerViewport(self, /) -> bool: ...
    def viewportOn(self, /) -> bool: ...
    def visualStyle(self, /) -> int: ...
    def width(self, /) -> float: ...

class AcadPlot:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def batchPlotProgress(self, /) -> bool: ...
    @staticmethod
    def className() -> str: ...
    def numberOfCopies(self, /) -> int: ...
    def quietErrorMode(self, /) -> bool: ...
    def setBatchPlotProgress(self, val: bool, /) -> None: ...
    def setDisplayPlotPreview(self, val: PyAx.AcPreviewMode, /) -> None: ...
    def setLayoutsToPlot(self, layouts: list[str], /) -> None: ...
    def setNumberOfCopies(self, val: int, /) -> None: ...
    def setQuietErrorMode(self, val: bool, /) -> None: ...
    def startBatchMode(self, val: bool, /) -> None: ...

class AcadPlotConfiguration(PyAx.AcadObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def canonicalMediaName(self, /) -> str: ...
    def canonicalMediaNames(self, /) -> list[str]: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadPlotConfiguration: ...
    def centerPlot(self, /) -> bool: ...
    @staticmethod
    def className() -> str: ...
    def configName(self, /) -> str: ...
    def copyFrom(self, val: PyAx.AcadPlotConfiguration, /) -> None: ...
    def customScale(self, /) -> tuple[float, float]: ...
    def localeMediaName(self, val: str, /) -> str: ...
    def modelType(self, /) -> bool: ...
    def name(self, /) -> str: ...
    def paperMargins(self, /) -> tuple[PyGe.Point2d, PyGe.Point2d]: ...
    def paperSize(self, /) -> tuple[float, float]: ...
    def paperUnits(self, /) -> AcPlotPaperUnits: ...
    def plotDeviceNames(self, /) -> list[str]: ...
    def plotHidden(self, /) -> bool: ...
    def plotOrigin(self, /) -> PyGe.Point2d: ...
    def plotRotation(self, /) -> AcPlotRotation: ...
    def plotStyleTableNames(self, /) -> list[str]: ...
    def plotType(self, /) -> AcPlotType: ...
    def plotViewportBorders(self, /) -> bool: ...
    def plotViewportsFirst(self, /) -> bool: ...
    def plotWithLineweights(self, /) -> bool: ...
    def plotWithPlotStyles(self, /) -> bool: ...
    def refreshPlotDeviceInfo(self, /) -> None: ...
    def scaleLineweights(self, /) -> bool: ...
    def setCanonicalMediaName(self, val: str, /) -> None: ...
    def setCenterPlot(self, val: bool, /) -> None: ...
    def setConfigName(self, val: str, /) -> None: ...
    def setCustomScale(self, numerator: float, denominator: float, /) -> None: ...
    def setName(self, val: str, /) -> None: ...
    def setPaperUnits(self, val: PyAx.AcPlotPaperUnits, /) -> None: ...
    def setPlotHidden(self, val: bool, /) -> None: ...
    def setPlotOrigin(self, orgin: PyGe.Point2d, /) -> None: ...
    def setPlotRotation(self, val: PyAx.AcPlotRotation, /) -> None: ...
    def setPlotType(self, val: PyAx.AcPlotType, /) -> None: ...
    def setPlotViewportBorders(self, val: bool, /) -> None: ...
    def setPlotViewportsFirst(self, val: bool, /) -> None: ...
    def setPlotWithLineweights(self, val: bool, /) -> None: ...
    def setPlotWithPlotStyles(self, val: bool, /) -> None: ...
    def setScaleLineweights(self, val: bool, /) -> None: ...
    def setShowPlotStyles(self, val: bool, /) -> None: ...
    def setStandardScale(self, val: PyAx.AcPlotScale, /) -> None: ...
    def setStyleSheet(self, val: str, /) -> None: ...
    def setUseStandardScale(self, val: bool, /) -> None: ...
    def setViewToPlot(self, val: str, /) -> None: ...
    def setWindowToPlot(self, lowerLeft: PyGe.Point2d, upperRight: PyGe.Point2d, /) -> None: ...
    def showPlotStyles(self, /) -> bool: ...
    def standardScale(self, /) -> AcPlotScale: ...
    def styleSheet(self, /) -> str: ...
    def useStandardScale(self, /) -> bool: ...
    def viewToPlot(self, /) -> str: ...
    def windowToPlot(self, /) -> tuple[PyGe.Point2d, PyGe.Point2d]: ...

class AcadPlotConfigurations(PyAx.AcadObject):
    def __getitem__(self, index: int, /) -> AcadPlotConfiguration: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __iter__(self, /) -> Iterator[PyAx.AcadPlotConfiguration]: ...
    def __reduce__(self, /) -> Any: ...
    def add(self, name: str, /) -> AcadPlotConfiguration: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadPlotConfigurations: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, index: int, /) -> AcadPlotConfiguration: ...
    def items(self, /) -> list: ...

class AcadPoint(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadPoint: ...
    @staticmethod
    def className() -> str: ...
    def coordinates(self, /) -> PyGe.Point3d: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def setCoordinates(self, val: PyGe.Point3d, /) -> None: ...
    def setNormal(self, val: PyGe.Vector3d, /) -> None: ...
    def setThickness(self, val: float, /) -> None: ...
    def thickness(self, /) -> float: ...

class AcadPolyfaceMesh(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadPolyfaceMesh: ...
    @staticmethod
    def className() -> str: ...
    def coordinate(self, index: int, /) -> PyGe.Point3d: ...
    def coordinates(self, /) -> list[PyGe.Point3d]: ...
    def numberOfFaces(self, /) -> int: ...
    def numberOfVertices(self, /) -> int: ...
    def setCoordinate(self, index: int, point: PyGe.Point3d, /) -> None: ...
    def setCoordinates(self, coords: Collection[PyGe.Point3d], /) -> None: ...
    def setFaces(self, faces: Collection[int], /) -> None: ...

class AcadPolygonMesh(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def appendVertex(self, vertex: PyGe.Point3d, /) -> None: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadPolygonMesh: ...
    @staticmethod
    def className() -> str: ...
    def coordinate(self, index: int, /) -> PyGe.Point3d: ...
    def coordinates(self, /) -> list[PyGe.Point3d]: ...
    def explode(self, /) -> list[PyAx.AcadEntity]: ...
    def getType(self, /) -> AcPolymeshType: ...
    def mClose(self, /) -> bool: ...
    def mDensity(self, /) -> int: ...
    def mVertexCount(self, /) -> int: ...
    def nClose(self, /) -> bool: ...
    def nDensity(self, /) -> int: ...
    def nVertexCount(self, /) -> int: ...
    def setCoordinate(self, index: int, point: PyGe.Point3d, /) -> None: ...
    def setCoordinates(self, coords: Collection[PyGe.Point3d], /) -> None: ...
    def setMClose(self, val: bool, /) -> None: ...
    def setMDensity(self, val: int, /) -> None: ...
    def setNClose(self, val: bool, /) -> None: ...
    def setNDensity(self, val: int, /) -> None: ...
    def setType(self, val: PyAx.AcPolymeshType, /) -> None: ...

class AcadPolyline(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def area(self, /) -> float: ...
    def bulge(self, index: int, /) -> float: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadPolyline: ...
    @staticmethod
    def className() -> str: ...
    def constantWidth(self, /) -> float: ...
    def coordinate(self, index: int, /) -> PyGe.Point3d: ...
    def coordinates(self, /) -> list[PyGe.Point3d]: ...
    def elevation(self, /) -> float: ...
    def explode(self, /) -> list[PyAx.AcadEntity]: ...
    def isClosed(self, /) -> bool: ...
    def length(self, /) -> float: ...
    def linetypeGeneration(self, /) -> bool: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def offset(self, val: float, /) -> list[PyAx.AcadEntity]: ...
    def setBulge(self, index: int, val: float, /) -> None: ...
    def setClosed(self, val: bool, /) -> None: ...
    def setConstantWidth(self, val: float, /) -> None: ...
    def setCoordinate(self, index: int, val: PyGe.Point3d, /) -> None: ...
    def setCoordinates(self, coords: Collection[PyGe.Point3d], /) -> None: ...
    def setElevation(self, val: float, /) -> None: ...
    def setLinetypeGeneration(self, val: bool, /) -> None: ...
    def setNormal(self, val: PyGe.Vector3d, /) -> None: ...
    def setThickness(self, val: float, /) -> None: ...
    def setWidth(self, index: int, startWidth: float, endWidth: float, /) -> None: ...
    def thickness(self, /) -> float: ...
    def width(self, index: int, /) -> tuple: ...

class AcadPopupMenu:
    def __getitem__(self, index: int, /) -> AcadPopupMenuItem: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def addMenuItem(self, idx: int, label: str, macro: str, /) -> AcadPopupMenuItem: ...
    def addSeparator(self, idx: int, /) -> AcadPopupMenuItem: ...
    def addSubMenu(self, idx: int, label: str, /) -> AcadPopupMenuItem: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def insertInMenuBar(self, idx: int, /) -> None: ...
    def isOnMenuBar(self, /) -> bool: ...
    def isShortcutMenu(self, /) -> bool: ...
    def item(self, idx: int, /) -> AcadPopupMenuItem: ...
    def name(self, /) -> str: ...
    def nameNoMnemonic(self, /) -> str: ...
    def parent(self, /) -> AcadPopupMenus: ...
    def removeFromMenuBar(self, /) -> None: ...
    def setName(self, name: str, /) -> None: ...
    def tagString(self, /) -> str: ...

class AcadPopupMenuItem:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def caption(self, /) -> str: ...
    def check(self, /) -> bool: ...
    @staticmethod
    def className() -> str: ...
    def clear(self, /) -> None: ...
    def enable(self, /) -> bool: ...
    def endSubMenuLevel(self, /) -> int: ...
    def getType(self, /) -> AcMenuItemType: ...
    def helpString(self, /) -> str: ...
    def index(self, /) -> int: ...
    def label(self, /) -> str: ...
    def macro(self, /) -> str: ...
    def parent(self, /) -> AcadPopupMenu: ...
    def setCheck(self, enable: bool, /) -> None: ...
    def setEnable(self, enable: bool, /) -> None: ...
    def setEndSubMenuLevel(self, val: int, /) -> None: ...
    def setHelpString(self, helpString: str, /) -> None: ...
    def setLabel(self, label: str, /) -> None: ...
    def setMacro(self, macro: str, /) -> None: ...
    def setTagString(self, tag: str, /) -> None: ...
    def subMenu(self, /) -> AcadPopupMenu: ...
    def tagString(self, /) -> str: ...

class AcadPopupMenus:
    def __getitem__(self, index: int, /) -> AcadPopupMenu: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def add(self, toolbarName: str, /) -> AcadPopupMenu: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def insertMenuInMenuBar(self, insertMenuInMenuBar: str, idx: int, /) -> None: ...
    def item(self, idx: int, /) -> AcadPopupMenu: ...
    def parent(self, /) -> AcadMenuGroup: ...
    def removeMenuFromMenuBar(self, idx: int, /) -> None: ...

class AcadPreferences:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def display(self, /) -> AcadPreferencesDisplay: ...
    def drafting(self, /) -> AcadPreferencesDrafting: ...
    def files(self, /) -> AcadPreferencesFiles: ...
    def openSave(self, /) -> AcadPreferencesOpenSave: ...
    def output(self, /) -> AcadPreferencesOutput: ...
    def profiles(self, /) -> AcadPreferencesProfiles: ...
    def selection(self, /) -> AcadPreferencesSelection: ...
    def system(self, /) -> AcadPreferencesSystem: ...
    def user(self, /) -> AcadPreferencesUser: ...

class AcadPreferencesDisplay:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def autoTrackingVecColor(self, /) -> tuple[int, int, int]: ...
    @staticmethod
    def className() -> str: ...
    def cursorSize(self, /) -> int: ...
    def displayLayoutTabs(self, /) -> bool: ...
    def displayScreenMenu(self, /) -> bool: ...
    def displayScrollBars(self, /) -> bool: ...
    def dockedVisibleLines(self, /) -> int: ...
    def graphicsWinLayoutBackgrndColor(self, /) -> tuple[int, int, int]: ...
    def graphicsWinModelBackgrndColor(self, /) -> tuple[int, int, int]: ...
    def historyLines(self, /) -> int: ...
    def imageFrameHighlight(self, /) -> bool: ...
    def layoutCreateViewport(self, /) -> bool: ...
    def layoutCrosshairColor(self, /) -> tuple[int, int, int]: ...
    def layoutDisplayMargins(self, /) -> bool: ...
    def layoutDisplayPaper(self, /) -> bool: ...
    def layoutDisplayPaperShadow(self, /) -> bool: ...
    def layoutShowPlotSetup(self, /) -> bool: ...
    def maxAutoCADWindow(self, /) -> bool: ...
    def modelCrosshairColor(self, /) -> tuple[int, int, int]: ...
    def setAutoTrackingVecColor(self, rgb: tuple[int, int, int], /) -> None: ...
    def setCursorSize(self, val: int, /) -> None: ...
    def setDisplayLayoutTabs(self, val: bool, /) -> None: ...
    def setDisplayScreenMenu(self, val: bool, /) -> None: ...
    def setDisplayScrollBars(self, val: bool, /) -> None: ...
    def setDockedVisibleLines(self, val: int, /) -> None: ...
    def setGraphicsWinLayoutBackgrndColor(self, rgb: tuple[int, int, int], /) -> None: ...
    def setGraphicsWinModelBackgrndColor(self, rgb: tuple[int, int, int], /) -> None: ...
    def setHistoryLines(self, val: int, /) -> None: ...
    def setImageFrameHighlight(self, val: bool, /) -> None: ...
    def setLayoutCreateViewport(self, val: bool, /) -> None: ...
    def setLayoutCrosshairColor(self, rgb: tuple[int, int, int], /) -> None: ...
    def setLayoutDisplayMargins(self, val: bool, /) -> None: ...
    def setLayoutDisplayPaper(self, val: bool, /) -> None: ...
    def setLayoutDisplayPaperShadow(self, val: bool, /) -> None: ...
    def setLayoutShowPlotSetup(self, val: bool, /) -> None: ...
    def setMaxAutoCADWindow(self, val: bool, /) -> None: ...
    def setModelCrosshairColor(self, rgb: tuple[int, int, int], /) -> None: ...
    def setShowRasterImage(self, val: bool, /) -> None: ...
    def setTextFont(self, val: str, /) -> None: ...
    def setTextFontSize(self, val: int, /) -> None: ...
    def setTextFontStyle(self, val: PyAx.AcTextFontStyle, /) -> None: ...
    def setTextWinBackgrndColor(self, rgb: tuple[int, int, int], /) -> None: ...
    def setTextWinTextColor(self, rgb: tuple[int, int, int], /) -> None: ...
    def setTrueColorImages(self, val: bool, /) -> None: ...
    def setXRefFadeIntensity(self, val: bool, /) -> None: ...
    def showRasterImage(self, /) -> bool: ...
    def textFont(self, /) -> str: ...
    def textFontSize(self, /) -> int: ...
    def textFontStyle(self, /) -> AcTextFontStyle: ...
    def textWinBackgrndColor(self, /) -> tuple[int, int, int]: ...
    def textWinTextColor(self, /) -> tuple[int, int, int]: ...
    def trueColorImages(self, /) -> bool: ...
    def xrefFadeIntensity(self, /) -> int: ...

class AcadPreferencesDrafting:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def alignmentPointAcquisition(self, /) -> AcAlignmentPointAcquisition: ...
    def autoSnapAperture(self, /) -> bool: ...
    def autoSnapApertureSize(self, /) -> int: ...
    def autoSnapMagnet(self, /) -> bool: ...
    def autoSnapMarker(self, /) -> bool: ...
    def autoSnapMarkerColor(self, /) -> AcColor: ...
    def autoSnapMarkerSize(self, /) -> int: ...
    def autoSnapTooltip(self, /) -> bool: ...
    def autoTrackTooltip(self, /) -> bool: ...
    @staticmethod
    def className() -> str: ...
    def fullScreenTrackingVector(self, /) -> bool: ...
    def polarTrackingVector(self, /) -> bool: ...
    def setAlignmentPointAcquisition(self, flag: PyAx.AcAlignmentPointAcquisition, /) -> None: ...
    def setAutoSnapAperture(self, flag: bool, /) -> None: ...
    def setAutoSnapApertureSize(self, flag: int, /) -> None: ...
    def setAutoSnapMagnet(self, flag: bool, /) -> None: ...
    def setAutoSnapMarker(self, flag: bool, /) -> None: ...
    def setAutoSnapMarkerColor(self, flag: PyAx.AcColor, /) -> None: ...
    def setAutoSnapMarkerSize(self, flag: int, /) -> None: ...
    def setAutoSnapTooltip(self, flag: bool, /) -> None: ...
    def setAutoTrackTooltip(self, flag: bool, /) -> None: ...
    def setFullScreenTrackingVector(self, flag: bool, /) -> None: ...
    def setPolarTrackingVector(self, flag: bool, /) -> None: ...

class AcadPreferencesFiles:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def activeInvProject(self, /) -> str: ...
    def altFontFile(self, /) -> str: ...
    def altTabletMenuFile(self, /) -> str: ...
    def autoSavePath(self, /) -> str: ...
    @staticmethod
    def className() -> str: ...
    def colorBookPath(self, /) -> str: ...
    def configFile(self, /) -> str: ...
    def customDictionary(self, /) -> str: ...
    def customIconPath(self, /) -> str: ...
    def defaultInternetURL(self, /) -> str: ...
    def driversPath(self, /) -> str: ...
    def enterpriseMenuFile(self, /) -> str: ...
    def fontFileMap(self, /) -> str: ...
    def helpFilePath(self, /) -> str: ...
    def licenseServer(self, /) -> str: ...
    def logFilePath(self, /) -> str: ...
    def mainDictionary(self, /) -> str: ...
    def menuFile(self, /) -> str: ...
    def objectARXPath(self, /) -> str: ...
    def pageSetupOverridesTemplateFile(self, /) -> str: ...
    def plotLogFilePath(self, /) -> str: ...
    def postScriptPrologFile(self, /) -> str: ...
    def printFile(self, /) -> str: ...
    def printSpoolExecutable(self, /) -> str: ...
    def printSpoolerPath(self, /) -> str: ...
    def printerConfigPath(self, /) -> str: ...
    def printerDescPath(self, /) -> str: ...
    def printerStyleSheetPath(self, /) -> str: ...
    def projectFilePath(self, projectName: str, /) -> str: ...
    def qnewTemplateFile(self, /) -> str: ...
    def setActiveInvProject(self, val: str, /) -> None: ...
    def setAltFontFile(self, val: str, /) -> None: ...
    def setAltTabletMenuFile(self, val: str, /) -> None: ...
    def setAutoSavePath(self, val: str, /) -> None: ...
    def setColorBookPath(self, val: str, /) -> None: ...
    def setCustomDictionary(self, val: str, /) -> None: ...
    def setCustomIconPath(self, val: str, /) -> None: ...
    def setDefaultInternetURL(self, val: str, /) -> None: ...
    def setDriversPath(self, val: str, /) -> None: ...
    def setEnterpriseMenuFile(self, val: str, /) -> None: ...
    def setFontFileMap(self, val: str, /) -> None: ...
    def setHelpFilePath(self, val: str, /) -> None: ...
    def setLogFilePath(self, val: str, /) -> None: ...
    def setMainDictionary(self, val: str, /) -> None: ...
    def setMenuFile(self, val: str, /) -> None: ...
    def setObjectARXPath(self, val: str, /) -> None: ...
    def setPageSetupOverridesTemplateFile(self, val: str, /) -> None: ...
    def setPlotLogFilePath(self, val: str, /) -> None: ...
    def setPostScriptPrologFile(self, val: str, /) -> None: ...
    def setPrintFile(self, val: str, /) -> None: ...
    def setPrintSpoolExecutable(self, val: str, /) -> None: ...
    def setPrintSpoolerPath(self, val: str, /) -> None: ...
    def setPrinterConfigPath(self, val: str, /) -> None: ...
    def setPrinterDescPath(self, val: str, /) -> None: ...
    def setPrinterStyleSheetPath(self, val: str, /) -> None: ...
    def setProjectFilePath(self, projectName: str, projectFilePath: str, /) -> None: ...
    def setQNewTemplateFile(self, val: str, /) -> None: ...
    def setSupportPath(self, val: str, /) -> None: ...
    def setTempFilePath(self, val: str, /) -> None: ...
    def setTempXrefPath(self, val: str, /) -> None: ...
    def setTemplateDwgPath(self, val: str, /) -> None: ...
    def setTextEditor(self, val: str, /) -> None: ...
    def setTextureMapPath(self, val: str, /) -> None: ...
    def setToolPalettePath(self, val: str, /) -> None: ...
    def setWorkspacePath(self, val: str, /) -> None: ...
    def supportPath(self, /) -> str: ...
    def tempFilePath(self, /) -> str: ...
    def tempXrefPath(self, /) -> str: ...
    def templateDwgPath(self, /) -> str: ...
    def textEditor(self, /) -> str: ...
    def textureMapPath(self, /) -> str: ...
    def toolPalettePath(self, /) -> str: ...
    def workspacePath(self, /) -> str: ...

class AcadPreferencesOpenSave:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def autoAudit(self, /) -> bool: ...
    def autoSaveInterval(self, /) -> int: ...
    @staticmethod
    def className() -> str: ...
    def createBackup(self, /) -> bool: ...
    def demandLoadARXApp(self, /) -> object: ...
    def fullCRCValidation(self, /) -> bool: ...
    def incrementalSavePercent(self, /) -> int: ...
    def logFileOn(self, /) -> bool: ...
    def mruNumber(self, /) -> int: ...
    def proxyImage(self, /) -> AcProxyImage: ...
    def saveAsType(self, /) -> AcSaveAsType: ...
    def savePreviewThumbnail(self, /) -> bool: ...
    def setAutoAudit(self, val: bool, /) -> None: ...
    def setAutoSaveInterval(self, val: int, /) -> None: ...
    def setCreateBackup(self, val: bool, /) -> None: ...
    def setDemandLoadARXApp(self, val: PyAx.AcARXDemandLoad, /) -> None: ...
    def setFullCRCValidation(self, val: bool, /) -> None: ...
    def setIncrementalSavePercent(self, val: int, /) -> None: ...
    def setLogFileOn(self, val: bool, /) -> None: ...
    def setProxyImage(self, val: PyAx.AcProxyImage, /) -> None: ...
    def setSaveAsType(self, val: PyAx.AcSaveAsType, /) -> None: ...
    def setSavePreviewThumbnail(self, val: bool, /) -> None: ...
    def setShowProxyDialogBox(self, val: bool, /) -> None: ...
    def setTempFileExtension(self, val: str, /) -> None: ...
    def setXrefDemandLoad(self, val: PyAx.AcXRefDemandLoad, /) -> None: ...
    def showProxyDialogBox(self, /) -> bool: ...
    def tempFileExtension(self, /) -> str: ...
    def xrefDemandLoad(self, /) -> AcXRefDemandLoad: ...

class AcadPreferencesOutput:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def automaticPlotLog(self, /) -> bool: ...
    @staticmethod
    def className() -> str: ...
    def continuousPlotLog(self, /) -> bool: ...
    def defaultOutputDevice(self, /) -> str: ...
    def defaultPlotStyleForLayer(self, /) -> str: ...
    def defaultPlotStyleForObjects(self, /) -> str: ...
    def defaultPlotStyleTable(self, /) -> str: ...
    def defaultPlotToFilePath(self, /) -> str: ...
    def oleQuality(self, /) -> AcOleQuality: ...
    def plotLegacy(self, /) -> bool: ...
    def plotPolicy(self, /) -> object: ...
    def printerPaperSizeAlert(self, /) -> bool: ...
    def printerSpoolAlert(self, /) -> AcPrinterSpoolAlert: ...
    def setAutomaticPlotLog(self, val: bool, /) -> None: ...
    def setContinuousPlotLog(self, val: bool, /) -> None: ...
    def setDefaultOutputDevice(self, val: str, /) -> None: ...
    def setDefaultPlotStyleForLayer(self, val: str, /) -> None: ...
    def setDefaultPlotStyleForObjects(self, val: str, /) -> None: ...
    def setDefaultPlotStyleTable(self, val: str, /) -> None: ...
    def setDefaultPlotToFilePath(self, val: str, /) -> None: ...
    def setOLEQuality(self, val: PyAx.AcOleQuality, /) -> None: ...
    def setPlotLegacy(self, val: bool, /) -> None: ...
    def setPlotPolicy(self, val: PyAx.AcPlotPolicy, /) -> None: ...
    def setPrinterPaperSizeAlert(self, val: bool, /) -> None: ...
    def setPrinterSpoolAlert(self, val: PyAx.AcPrinterSpoolAlert, /) -> None: ...
    def setUseLastPlotSettings(self, val: bool, /) -> None: ...
    def useLastPlotSettings(self, /) -> bool: ...

class AcadPreferencesProfiles:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def activeProfile(self, /) -> str: ...
    @staticmethod
    def className() -> str: ...
    def copyProfile(self, oldProfileName: str, newProfileName: str, /) -> None: ...
    def deleteProfile(self, profileName: str, /) -> None: ...
    def exportProfile(self, profileName: str, regFile: str, /) -> None: ...
    def getAllProfileNames(self, /) -> list[str]: ...
    def importProfile(self, profileName: str, regFile: str, IncludePathInfo: bool, /) -> None: ...
    def renameProfile(self, origProfileName: str, newProfileName: str, /) -> None: ...
    def resetProfile(self, profile: str, /) -> None: ...
    def setActiveProfile(self, activeProfile: str, /) -> None: ...

class AcadPreferencesSelection:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def displayGrips(self, /) -> bool: ...
    def displayGripsWithinBlocks(self, /) -> bool: ...
    def gripColorSelected(self, /) -> AcColor: ...
    def gripColorUnselected(self, /) -> AcColor: ...
    def gripSize(self, /) -> int: ...
    def pickAdd(self, /) -> bool: ...
    def pickAuto(self, /) -> bool: ...
    def pickBoxSize(self, /) -> int: ...
    def pickDrag(self, /) -> bool: ...
    def pickFirst(self, /) -> bool: ...
    def pickGroup(self, /) -> bool: ...
    def setDisplayGrips(self, flag: bool, /) -> None: ...
    def setDisplayGripsWithinBlocks(self, flag: bool, /) -> None: ...
    def setGripColorSelected(self, clr: PyAx.AcColor, /) -> None: ...
    def setGripColorUnselected(self, clr: PyAx.AcColor, /) -> None: ...
    def setGripSize(self, flag: int, /) -> None: ...
    def setPickAdd(self, flag: bool, /) -> None: ...
    def setPickAuto(self, flag: bool, /) -> None: ...
    def setPickBoxSize(self, flag: int, /) -> None: ...
    def setPickDrag(self, flag: bool, /) -> None: ...
    def setPickFirst(self, flag: bool, /) -> None: ...
    def setPickGroup(self, flag: bool, /) -> None: ...

class AcadPreferencesSystem:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def beepOnError(self, /) -> bool: ...
    @staticmethod
    def className() -> str: ...
    def displayOLEScale(self, /) -> bool: ...
    def enableStartupDialog(self, /) -> bool: ...
    def loadAcadLspInAllDocuments(self, /) -> bool: ...
    def setBeepOnError(self, val: bool, /) -> None: ...
    def setDisplayOLEScale(self, val: bool, /) -> None: ...
    def setEnableStartupDialog(self, val: bool, /) -> None: ...
    def setLoadAcadLspInAllDocuments(self, val: bool, /) -> None: ...
    def setShowWarningMessages(self, val: bool, /) -> None: ...
    def setSingleDocumentMode(self, val: bool, /) -> None: ...
    def setStoreSQLIndex(self, val: bool, /) -> None: ...
    def setTablesReadOnly(self, val: bool, /) -> None: ...
    def showWarningMessages(self, /) -> bool: ...
    def singleDocumentMode(self, /) -> bool: ...
    def storeSQLIndex(self, /) -> bool: ...
    def tablesReadOnly(self, /) -> bool: ...

class AcadPreferencesUser:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def acmEditMode(self, /) -> AcDrawingAreaSCMEdit: ...
    def adcInsertUnitsDefaultSource(self, /) -> AcInsertUnits: ...
    def adcInsertUnitsDefaultTarget(self, /) -> AcInsertUnits: ...
    @staticmethod
    def className() -> str: ...
    def hyperlinkDisplayCursor(self, /) -> bool: ...
    def keyboardAccelerator(self, /) -> AcKeyboardAccelerator: ...
    def keyboardPriority(self, /) -> AcKeyboardPriority: ...
    def scmCommandMode(self, /) -> AcDrawingAreaSCMCommand: ...
    def scmDefaultMode(self, /) -> AcDrawingAreaSCMDefault: ...
    def scmTimeMode(self, /) -> bool: ...
    def scmTimeValue(self, /) -> int: ...
    def setADCInsertUnitsDefaultSource(self, val: PyAx.AcInsertUnits, /) -> None: ...
    def setADCInsertUnitsDefaultTarget(self, val: PyAx.AcInsertUnits, /) -> None: ...
    def setHyperlinkDisplayCursor(self, val: bool, /) -> None: ...
    def setKeyboardAccelerator(self, val: PyAx.AcKeyboardAccelerator, /) -> None: ...
    def setKeyboardPriority(self, val: PyAx.AcKeyboardPriority, /) -> None: ...
    def setSCMCommandMode(self, val: PyAx.AcDrawingAreaSCMCommand, /) -> None: ...
    def setSCMDefaultMode(self, val: PyAx.AcDrawingAreaSCMDefault, /) -> None: ...
    def setSCMEditMode(self, val: PyAx.AcDrawingAreaSCMEdit, /) -> None: ...
    def setSCMTimeMode(self, val: bool, /) -> None: ...
    def setSCMTimeValue(self, val: int, /) -> None: ...
    def setShortCutMenuDisplay(self, val: bool, /) -> None: ...
    def shortCutMenuDisplay(self, /) -> bool: ...

class AcadRasterImage(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def brightness(self, /) -> int: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadRasterImage: ...
    @staticmethod
    def className() -> str: ...
    def clipBoundary(self, val: Collection[PyGe.Point2d], /) -> None: ...
    def clippingEnabled(self, /) -> bool: ...
    def contrast(self, /) -> int: ...
    def fade(self, /) -> int: ...
    def height(self, /) -> float: ...
    def imageFile(self, /) -> str: ...
    def imageHeight(self, /) -> float: ...
    def imageVisibility(self, /) -> bool: ...
    def imageWidth(self, /) -> float: ...
    def name(self, /) -> str: ...
    def origin(self, /) -> PyGe.Point3d: ...
    def rotation(self, /) -> float: ...
    def scaleFactor(self, /) -> float: ...
    def setBrightness(self, val: int, /) -> None: ...
    def setClippingEnabled(self, val: bool, /) -> None: ...
    def setContrast(self, val: int, /) -> None: ...
    def setFade(self, val: int, /) -> None: ...
    def setImageFile(self, val: str, /) -> None: ...
    def setImageHeight(self, val: float, /) -> None: ...
    def setImageVisibility(self, val: bool, /) -> None: ...
    def setImageWidth(self, val: float, /) -> None: ...
    def setName(self, val: str, /) -> None: ...
    def setOrigin(self, val: PyGe.Point3d, /) -> None: ...
    def setRotation(self, val: float, /) -> None: ...
    def setScaleFactor(self, val: float, /) -> None: ...
    def setShowRotation(self, val: bool, /) -> None: ...
    def setTransparency(self, val: bool, /) -> None: ...
    def showRotation(self, /) -> bool: ...
    def transparency(self, /) -> bool: ...
    def width(self, /) -> float: ...

class AcadRay(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def basePoint(self, /) -> PyGe.Point3d: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadRay: ...
    @staticmethod
    def className() -> str: ...
    def directionVector(self, /) -> PyGe.Vector3d: ...
    def secondPoint(self, /) -> PyGe.Point3d: ...
    def setBasePoint(self, val: PyGe.Point3d, /) -> None: ...
    def setDirectionVector(self, val: PyGe.Vector3d, /) -> None: ...
    def setSecondPoint(self, val: PyGe.Point3d, /) -> None: ...

class AcadRegion(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def area(self, /) -> float: ...
    def boolean(self, booleanType: PyAx.AcBooleanType, region: PyAx.AcadRegion, /) -> None: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadRegion: ...
    def centroid(self, /) -> PyGe.Point2d: ...
    @staticmethod
    def className() -> str: ...
    def explode(self, /) -> list[PyAx.AcadEntity]: ...
    def momentOfInertia(self, /) -> PyGe.Point3d: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def perimeter(self, /) -> float: ...
    def principalDirections(self, /) -> list[PyGe.Vector3d]: ...
    def principalMoments(self, /) -> PyGe.Point3d: ...
    def radiiOfGyration(self, /) -> PyGe.Point3d: ...

class AcadRegisteredApplication(PyAx.AcadObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadRegisteredApplication: ...
    @staticmethod
    def className() -> str: ...
    def name(self, /) -> str: ...
    def setName(self, name: str, /) -> None: ...

class AcadRegisteredApplications(PyAx.AcadObject):
    def __getitem__(self, index: int, /) -> AcadRegisteredApplication: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __iter__(self, /) -> Iterator[PyAx.AcadRegisteredApplication]: ...
    def __reduce__(self, /) -> Any: ...
    def add(self, name: str, /) -> AcadRegisteredApplication: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadRegisteredApplications: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, index: int, /) -> AcadRegisteredApplication: ...
    def items(self, /) -> list[PyAx.AcadRegisteredApplication]: ...

class AcadSection(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def addVertex(self, index: int, val: PyGe.Point3d, /) -> None: ...
    def bottomHeight(self, /) -> float: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadSection: ...
    @staticmethod
    def className() -> str: ...
    def coordinate(self, index: int, /) -> PyGe.Point3d: ...
    def createJog(self, val: PyGe.Point3d, /) -> None: ...
    def elevation(self, /) -> float: ...
    def generateSectionGeometry(self, val: PyAx.AcadEntity, /) -> tuple: ...
    def hitTest(self, val: PyGe.Point3d, /) -> tuple: ...
    def indicatorFillColor(self, /) -> AcadAcCmColor: ...
    def indicatorTransparency(self, /) -> int: ...
    def liveSectionEnabled(self, /) -> bool: ...
    def name(self, /) -> str: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def numVertices(self, /) -> int: ...
    def removeVertex(self, index: int, /) -> None: ...
    def setBottomHeight(self, val: float, /) -> None: ...
    def setCoordinate(self, index: int, val: PyGe.Point3d, /) -> None: ...
    def setElevation(self, val: float, /) -> None: ...
    def setIndicatorFillColor(self, val: PyAx.AcadAcCmColor, /) -> None: ...
    def setIndicatorTransparency(self, val: int, /) -> None: ...
    def setLiveSectionEnabled(self, val: bool, /) -> None: ...
    def setName(self, val: str, /) -> None: ...
    def setState(self, val: PyAx.AcSectionState, /) -> None: ...
    def setTopHeight(self, val: float, /) -> None: ...
    def setVerticalDirection(self, val: PyGe.Vector3d, /) -> None: ...
    def setVertices(self, coords: Collection[PyGe.Point3d], /) -> None: ...
    def setViewingDirection(self, val: PyGe.Vector3d, /) -> None: ...
    def settings(self, /) -> AcadSectionSettings: ...
    def state(self, /) -> AcSectionState: ...
    def topHeight(self, /) -> float: ...
    def verticalDirection(self, /) -> PyGe.Vector3d: ...
    def vertices(self, /) -> list[PyGe.Point3d]: ...
    def viewingDirection(self, /) -> PyGe.Vector3d: ...

class AcadSectionManager(PyAx.AcadObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadSectionManager: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, index: int, /) -> AcadSection: ...
    def liveSection(self, /) -> AcadSection: ...
    def uniqueSectionName(self, baseName: str, /) -> str: ...

class AcadSectionSettings(PyAx.AcadObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadSectionSettings: ...
    @staticmethod
    def className() -> str: ...
    def currentSectionType(self, /) -> AcSectionType: ...
    def sectionTypeSettings(self, secType: PyAx.AcSectionType, /) -> AcadSectionTypeSettings: ...
    def setCurrentSectionType(self, secType: PyAx.AcSectionType, /) -> AcSectionType: ...

class AcadSectionTypeSettings:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def backgroundLinesColor(self, /) -> AcadAcCmColor: ...
    def backgroundLinesHiddenLine(self, /) -> bool: ...
    def backgroundLinesLayer(self, /) -> str: ...
    def backgroundLinesLinetype(self, /) -> str: ...
    def backgroundLinesLinetypeScale(self, /) -> float: ...
    def backgroundLinesLineweight(self, /) -> AcLineWeight: ...
    def backgroundLinesPlotStyleName(self, /) -> str: ...
    def backgroundLinesVisible(self, /) -> bool: ...
    @staticmethod
    def className() -> str: ...
    def curveTangencyLinesColor(self, /) -> AcadAcCmColor: ...
    def curveTangencyLinesLayer(self, /) -> str: ...
    def curveTangencyLinesLinetype(self, /) -> str: ...
    def curveTangencyLinesLinetypeScale(self, /) -> float: ...
    def curveTangencyLinesLineweight(self, /) -> AcLineWeight: ...
    def curveTangencyLinesPlotStyleName(self, /) -> str: ...
    def curveTangencyLinesVisible(self, /) -> bool: ...
    def destinationBlock(self, /) -> AcadBlock: ...
    def destinationFile(self, /) -> str: ...
    def foregroundLinesColor(self, /) -> AcadAcCmColor: ...
    def foregroundLinesEdgeTransparency(self, /) -> int: ...
    def foregroundLinesFaceTransparency(self, /) -> int: ...
    def foregroundLinesHiddenLine(self, /) -> bool: ...
    def foregroundLinesLayer(self, /) -> str: ...
    def foregroundLinesLinetype(self, /) -> str: ...
    def foregroundLinesLinetypeScale(self, /) -> float: ...
    def foregroundLinesLineweight(self, /) -> AcLineWeight: ...
    def foregroundLinesPlotStyleName(self, /) -> str: ...
    def foregroundLinesVisible(self, /) -> bool: ...
    def generationOptions(self, /) -> AcSectionGeneration: ...
    def intersectionBoundaryColor(self, /) -> AcadAcCmColor: ...
    def intersectionBoundaryDivisionLines(self, /) -> bool: ...
    def intersectionBoundaryLayer(self, /) -> str: ...
    def intersectionBoundaryLinetype(self, /) -> str: ...
    def intersectionBoundaryLinetypeScale(self, /) -> float: ...
    def intersectionBoundaryLineweight(self, /) -> AcLineWeight: ...
    def intersectionBoundaryPlotStyleName(self, /) -> str: ...
    def intersectionFillColor(self, /) -> AcadAcCmColor: ...
    def intersectionFillFaceTransparency(self, /) -> int: ...
    def intersectionFillHatchAngle(self, /) -> float: ...
    def intersectionFillHatchPatternName(self, /) -> str: ...
    def intersectionFillHatchPatternType(self, /) -> AcPatternType: ...
    def intersectionFillHatchScale(self, /) -> float: ...
    def intersectionFillHatchSpacing(self, /) -> float: ...
    def intersectionFillLayer(self, /) -> str: ...
    def intersectionFillLinetype(self, /) -> str: ...
    def intersectionFillLinetypeScale(self, /) -> float: ...
    def intersectionFillLineweight(self, /) -> AcLineWeight: ...
    def intersectionFillPlotStyleName(self, /) -> str: ...
    def intersectionFillVisible(self, /) -> bool: ...
    def setBackgroundLinesColor(self, val: PyAx.AcadAcCmColor, /) -> None: ...
    def setBackgroundLinesHiddenLine(self, val: bool, /) -> None: ...
    def setBackgroundLinesLayer(self, val: str, /) -> None: ...
    def setBackgroundLinesLinetype(self, val: str, /) -> None: ...
    def setBackgroundLinesLinetypeScale(self, val: float, /) -> None: ...
    def setBackgroundLinesLineweight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setBackgroundLinesPlotStyleName(self, val: str, /) -> None: ...
    def setBackgroundLinesVisible(self, val: bool, /) -> None: ...
    def setCurveTangencyLinesColor(self, val: PyAx.AcadAcCmColor, /) -> None: ...
    def setCurveTangencyLinesLayer(self, val: str, /) -> None: ...
    def setCurveTangencyLinesLinetype(self, val: str, /) -> None: ...
    def setCurveTangencyLinesLinetypeScale(self, val: float, /) -> None: ...
    def setCurveTangencyLinesLineweight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setCurveTangencyLinesPlotStyleName(self, val: str, /) -> None: ...
    def setCurveTangencyLinesVisible(self, val: bool, /) -> None: ...
    def setDestinationBlock(self, val: PyAx.AcadBlock, /) -> None: ...
    def setDestinationFile(self, val: str, /) -> None: ...
    def setForegroundLinesColor(self, val: PyAx.AcadAcCmColor, /) -> None: ...
    def setForegroundLinesEdgeTransparency(self, val: int, /) -> None: ...
    def setForegroundLinesFaceTransparency(self, val: int, /) -> None: ...
    def setForegroundLinesHiddenLine(self, val: bool, /) -> None: ...
    def setForegroundLinesLayer(self, val: str, /) -> None: ...
    def setForegroundLinesLinetype(self, val: str, /) -> None: ...
    def setForegroundLinesLinetypeScale(self, val: float, /) -> None: ...
    def setForegroundLinesLineweight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setForegroundLinesPlotStyleName(self, val: str, /) -> None: ...
    def setForegroundLinesVisible(self, val: bool, /) -> None: ...
    def setGenerationOptions(self, val: PyAx.AcSectionGeneration, /) -> None: ...
    def setIntersectionBoundaryColor(self, val: PyAx.AcadAcCmColor, /) -> None: ...
    def setIntersectionBoundaryDivisionLines(self, val: bool, /) -> None: ...
    def setIntersectionBoundaryLayer(self, val: str, /) -> None: ...
    def setIntersectionBoundaryLinetype(self, val: str, /) -> None: ...
    def setIntersectionBoundaryLinetypeScale(self, val: float, /) -> None: ...
    def setIntersectionBoundaryLineweight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setIntersectionBoundaryPlotStyleName(self, val: str, /) -> None: ...
    def setIntersectionFillColor(self, val: PyAx.AcadAcCmColor, /) -> None: ...
    def setIntersectionFillFaceTransparency(self, val: int, /) -> None: ...
    def setIntersectionFillHatchAngle(self, val: float, /) -> None: ...
    def setIntersectionFillHatchPatternName(self, val: str, /) -> None: ...
    def setIntersectionFillHatchPatternType(self, val: PyAx.AcPatternType, /) -> None: ...
    def setIntersectionFillHatchScale(self, val: float, /) -> None: ...
    def setIntersectionFillHatchSpacing(self, val: float, /) -> None: ...
    def setIntersectionFillLayer(self, val: str, /) -> None: ...
    def setIntersectionFillLinetype(self, val: str, /) -> None: ...
    def setIntersectionFillLinetypeScale(self, val: float, /) -> None: ...
    def setIntersectionFillLineweight(self, val: PyAx.AcLineWeight, /) -> None: ...
    def setIntersectionFillPlotStyleName(self, val: str, /) -> None: ...
    def setIntersectionFillVisible(self, val: bool, /) -> None: ...
    def setSourceObjects(self, ids: list[PyDb.ObjectId], /) -> None: ...
    def sourceObjects(self, /) -> list[PyDb.ObjectId]: ...

class AcadSecurityParams:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...

class AcadSelectionSet:
    def __getitem__(self, index: int, /) -> AcadEntity: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __iter__(self, /) -> Iterator[PyAx.AcadEntity]: ...
    def __reduce__(self, /) -> Any: ...
    def addItems(self, entities: Collection[PyAx.AcadEntity], /) -> None: ...
    @staticmethod
    def className() -> str: ...
    def clear(self, /) -> None: ...
    def count(self, /) -> int: ...
    def delete(self, /) -> None: ...
    def entities(self, /) -> list[PyAx.AcadEntity]: ...
    def highlight(self, bHighlight: bool, /) -> None: ...
    def item(self, index: int, /) -> AcadEntity: ...
    def name(self, /) -> str: ...
    def removeItems(self, entities: Collection[PyAx.AcadEntity], /) -> None: ...
    def selectAll(self, filter: Collection[tuple[int, Any]] = ..., /) -> None: ...
    def selectAtPoint(
        self, pt1: PyGe.Point3d, filter: Collection[tuple[int, Any]] = ..., /
    ) -> None: ...
    def selectCrossing(
        self, pt1: PyGe.Point3d, pt2: PyGe.Point3d, filter: Collection[tuple[int, Any]] = ..., /
    ) -> None: ...
    def selectCrossingPolygon(
        self, pts: Collection[PyGe.Point3d], filter: Collection[tuple[int, Any]] = ..., /
    ) -> None: ...
    def selectFence(
        self, pts: Collection[PyGe.Point3d], filter: Collection[tuple[int, Any]] = ..., /
    ) -> None: ...
    def selectLast(self, /) -> None: ...
    def selectOnScreen(self, filter: Collection[tuple[int, Any]] = ..., /) -> None: ...
    def selectWindow(
        self, pt1: PyGe.Point3d, pt2: PyGe.Point3d, filter: Collection[tuple[int, Any]] = ..., /
    ) -> None: ...
    def selectWindowPolygon(
        self, pts: Collection[PyGe.Point3d], filter: Collection[tuple[int, Any]] = ..., /
    ) -> None: ...
    def update(self, /) -> None: ...

class AcadSelectionSets:
    def __getitem__(self, index: int, /) -> AcadSelectionSet: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def add(self, name: str, /) -> AcadSelectionSet: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, index: int, /) -> AcadSelectionSet: ...

class AcadShape(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadShape: ...
    @staticmethod
    def className() -> str: ...
    def height(self, /) -> float: ...
    def insertionPoint(self, /) -> PyGe.Point3d: ...
    def name(self, /) -> str: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def obliqueAngle(self, /) -> float: ...
    def rotation(self, /) -> float: ...
    def scaleFactor(self, /) -> float: ...
    def setHeight(self, val: float, /) -> None: ...
    def setInsertionPoint(self, val: PyGe.Point3d, /) -> None: ...
    def setName(self, val: str, /) -> None: ...
    def setNormal(self, val: PyGe.Vector3d, /) -> None: ...
    def setObliqueAngle(self, val: float, /) -> None: ...
    def setRotation(self, val: float, /) -> None: ...
    def setScaleFactor(self, val: float, /) -> None: ...
    def setThickness(self, val: float, /) -> None: ...
    def thickness(self, /) -> float: ...

class AcadSolid(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadSolid: ...
    @staticmethod
    def className() -> str: ...
    def coordinates(self, /) -> list[PyGe.Point3d]: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def setCoordinates(self, coords: Collection[PyGe.Point3d], /) -> None: ...
    def setNormal(self, val: PyGe.Vector3d, /) -> None: ...
    def setThickness(self, val: float, /) -> None: ...
    def thickness(self, /) -> float: ...

class AcadSortentsTable(PyAx.AcadObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def block(self, /) -> AcadBlock: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadSortentsTable: ...
    @staticmethod
    def className() -> str: ...
    def fullDrawOrder(self, honorSortentsSysvar: bool, /) -> list[PyAx.AcadEntity]: ...
    def moveAbove(
        self, pyents: Collection[PyAx.AcadEntity], target: PyAx.AcadEntity, /
    ) -> None: ...
    def moveBelow(
        self, pyents: Collection[PyAx.AcadEntity], target: PyAx.AcadEntity, /
    ) -> None: ...
    def moveToBottom(self, pyents: Collection[PyAx.AcadEntity], /) -> None: ...
    def moveToTop(self, pyents: Collection[PyAx.AcadEntity], /) -> None: ...
    def relativeDrawOrder(self, honorSortentsSysvar: bool, /) -> list[PyAx.AcadEntity]: ...
    def setRelativeDrawOrder(self, pyents: Collection[PyAx.AcadEntity], /) -> None: ...
    def swapOrder(self, left: PyAx.AcadEntity, right: PyAx.AcadEntity, /) -> None: ...

class AcadSpline(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def addFitPoint(self, val: int, point: PyGe.Point3d, /) -> None: ...
    def area(self, /) -> float: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadSpline: ...
    @staticmethod
    def className() -> str: ...
    def closed(self, /) -> bool: ...
    def closed2(self, /) -> bool: ...
    def controlPoint(self, val: int, /) -> PyGe.Point3d: ...
    def controlPoints(self, /) -> list[PyGe.Point3d]: ...
    def degree(self, /) -> int: ...
    def degree2(self, /) -> int: ...
    def deleteFitPoint(self, val: int, /) -> None: ...
    def elevateOrder(self, val: int, /) -> None: ...
    def endTangent(self, /) -> PyGe.Vector3d: ...
    def fitPoint(self, val: int, /) -> PyGe.Point3d: ...
    def fitPoints(self, /) -> list[PyGe.Point3d]: ...
    def fitTolerance(self, /) -> float: ...
    def isPeriodic(self, /) -> bool: ...
    def isPlanar(self, /) -> tuple[bool, PyGe.Plane]: ...
    def isRational(self, /) -> bool: ...
    def knotParameterization(self, /) -> AcSplineKnotParameterizationType: ...
    def knots(self, /) -> list[PyGe.Vector3d]: ...
    def numberOfControlPoints(self, /) -> int: ...
    def offset(self, val: float, /) -> list[PyAx.AcadEntity]: ...
    def purgeFitData(self, /) -> None: ...
    def reverse(self, /) -> None: ...
    def setClosed2(self, val: bool, /) -> None: ...
    def setControlPoint(self, val: int, point: PyGe.Point3d, /) -> None: ...
    def setControlPoints(self, items: Collection[PyGe.Point3d], /) -> None: ...
    def setDegree2(self, val: int, /) -> None: ...
    def setEndTangent(self, val: PyGe.Vector3d, /) -> None: ...
    def setFitPoint(self, val: int, point: PyGe.Point3d, /) -> None: ...
    def setFitPoints(self, items: Collection[PyGe.Point3d], /) -> None: ...
    def setFitTolerance(self, val: float, /) -> None: ...
    def setKnotParameterization(self, val: PyAx.AcSplineKnotParameterizationType, /) -> None: ...
    def setKnots(self, items: Collection[PyGe.Vector3d], /) -> None: ...
    def setSplineFrame(self, val: PyAx.AcSplineFrameType, /) -> None: ...
    def setSplineMethod(self, val: PyAx.AcSplineMethodType, /) -> None: ...
    def setStartTangent(self, val: PyGe.Vector3d, /) -> None: ...
    def setWeight(self, val: int, weight: float, /) -> None: ...
    def setWeights(self, items: Collection[float], /) -> None: ...
    def splineFrame(self, /) -> AcSplineFrameType: ...
    def splineMethod(self, /) -> AcSplineMethodType: ...
    def startTangent(self, /) -> PyGe.Vector3d: ...
    def weight(self, val: int, /) -> float: ...
    def weights(self, /) -> list[float]: ...

class AcadState:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def isQuiescent(self, /) -> bool: ...

class AcadSummaryInfo:
    def __getitem__(self, index: int, /) -> tuple[str, str]: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def addCustomInfo(self, key: str, val: str, /) -> None: ...
    def author(self, /) -> str: ...
    @staticmethod
    def className() -> str: ...
    def comments(self, /) -> str: ...
    def customByIndex(self, index: int, /) -> tuple[str, str]: ...
    def customByKey(self, key: str, /) -> str: ...
    def hyperlinkBase(self, /) -> str: ...
    def keywords(self, /) -> str: ...
    def lastSavedBy(self, /) -> str: ...
    def numCustomInfo(self, /) -> int: ...
    def removeCustomByIndex(self, index: int, /) -> None: ...
    def removeCustomByKey(self, key: str, /) -> None: ...
    def revisionNumber(self, /) -> str: ...
    def setAuthor(self, val: str, /) -> None: ...
    def setComments(self, val: str, /) -> None: ...
    def setCustomByIndex(self, index: int, key: str, val: str, /) -> None: ...
    def setCustomByKey(self, key: str, val: str, /) -> None: ...
    def setHyperlinkBase(self, val: str, /) -> None: ...
    def setKeywords(self, val: str, /) -> None: ...
    def setLastSavedBy(self, val: str, /) -> None: ...
    def setRevisionNumber(self, val: str, /) -> None: ...
    def setSubject(self, val: str, /) -> None: ...
    def setTitle(self, val: str, /) -> None: ...
    def subject(self, /) -> str: ...
    def title(self, /) -> str: ...

class AcadTable(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def allowManualHeights(self, /) -> bool: ...
    def allowManualPositions(self, /) -> bool: ...
    def attachmentPoint(self, row: int, col: int, /) -> PyGe.Point3d: ...
    def autoScale(self, row: int, col: int, /) -> bool: ...
    @overload
    def blockAttributeValue(self, row: int, col: int, id: PyDb.ObjectId, /) -> str: ...
    @overload
    def blockAttributeValue(
        self, row: int, col: int, nContent: int, id: PyDb.ObjectId, /
    ) -> str: ...
    @overload
    def blockAttributeValue(self, *args) -> str: ...
    def blockRotation(self, row: int, col: int, /) -> float: ...
    def blockScale(self, row: int, col: int, /) -> float: ...
    @overload
    def blockTableRecordId(self, row: int, col: int, /) -> PyDb.ObjectId: ...
    @overload
    def blockTableRecordId(self, row: int, col: int, nContent: int, /) -> PyDb.ObjectId: ...
    @overload
    def blockTableRecordId(self, *args) -> PyDb.ObjectId: ...
    def breakHeight(self, idx: int, /) -> float: ...
    def breakSpacing(self, /) -> float: ...
    def breaksEnabled(self, /) -> bool: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadTable: ...
    def cellAlignment(self, row: int, col: int, /) -> AcCellAlignment: ...
    def cellBackgroundColor(self, row: int, col: int, /) -> AcadAcCmColor: ...
    def cellBackgroundColorNone(self, row: int, col: int, /) -> bool: ...
    def cellContentColor(self, row: int, col: int, /) -> AcadAcCmColor: ...
    def cellDataType(
        self, row: int, col: int, /
    ) -> tuple[PyAx.AcValueDataType, PyAx.AcValueUnitType]: ...
    def cellExtents(self, row: int, col: int, bOuterCell: bool, /) -> list[PyGe.Point3d]: ...
    def cellFormat(self, row: int, col: int, /) -> str: ...
    def cellGridColor(self, row: int, col: int, mask: PyAx.AcCellEdgeMask, /) -> AcadAcCmColor: ...
    def cellGridLineWeight(
        self, row: int, col: int, mask: PyAx.AcCellEdgeMask, /
    ) -> AcLineWeight: ...
    def cellGridVisibility(self, row: int, col: int, mask: PyAx.AcCellEdgeMask, /) -> bool: ...
    def cellState(self, row: int, col: int, /) -> AcCellState: ...
    def cellStyle(self, row: int, col: int, /) -> str: ...
    def cellStyleOverrides(self, row: int, col: int, /) -> list: ...
    def cellTextHeight(self, row: int, col: int, /) -> float: ...
    def cellTextStyle(self, row: int, col: int, /) -> str: ...
    def cellType(self, row: int, col: int, /) -> AcCellType: ...
    def cellValue(self, row: int, col: int, /) -> PyDb.AcValue: ...
    @staticmethod
    def className() -> str: ...
    def clearSubSelection(self, /) -> None: ...
    def clearTableStyleOverrides(self, val: int, /) -> None: ...
    def columnName(self, col: int, /) -> float: ...
    def columnWidth(self, /) -> float: ...
    def columns(self, /) -> int: ...
    def contentColor(self, row: int, col: int, nContent: int, /) -> AcadAcCmColor: ...
    def contentLayout(self, row: int, col: int, /) -> AcCellContentLayout: ...
    def contentType(self, row: int, col: int, /) -> AcCellContentType: ...
    def customData(self, row: int, col: int, key: str, /) -> str: ...
    def dataFormat(self, row: int, col: int, nContent: int, /) -> str: ...
    def dataType(
        self, row: int, col: int, nContent: int, /
    ) -> tuple[PyAx.AcValueDataType, PyAx.AcValueUnitType]: ...
    def deleteCellContent(self, row: int, col: int, /) -> None: ...
    def deleteColumns(self, col: int, cols: int, /) -> None: ...
    def deleteRows(self, row: int, rows: int, /) -> None: ...
    def direction(self, /) -> PyGe.Vector3d: ...
    def enableMergeAll(self, row: int, col: int, val: bool, /) -> None: ...
    @overload
    def fieldId(self, row: int, col: int, /) -> PyDb.ObjectId: ...
    @overload
    def fieldId(self, row: int, col: int, nContent: int, /) -> PyDb.ObjectId: ...
    @overload
    def fieldId(self, *args) -> PyDb.ObjectId: ...
    def flowDirection(self, /) -> AcTableDirection: ...
    def formatValue(self, row: int, col: int, val: PyAx.AcFormatOption, /) -> str: ...
    def formula(self, row: int, col: int, nContent: int, /) -> str: ...
    def generateLayout(self, /) -> None: ...
    def gridColor(self, row: int, col: int, lt: PyAx.AcGridLineType, /) -> AcadAcCmColor: ...
    def gridDoubleLineSpacing(self, row: int, col: int, lt: PyAx.AcGridLineType, /) -> float: ...
    def gridLineStyle(self, row: int, col: int, lt: PyAx.AcGridLineType, /) -> AcGridLineStyle: ...
    def gridLineWeight(self, row: int, col: int, lt: PyAx.AcGridLineType, /) -> AcLineWeight: ...
    def gridLinetype(self, row: int, col: int, lt: PyAx.AcGridLineType, /) -> PyDb.ObjectId: ...
    def gridVisibility(self, row: int, col: int, lt: PyAx.AcGridLineType, /) -> bool: ...
    def hasFormula(self, row: int, col: int, nContent: int, /) -> bool: ...
    def hasSubSelection(self, /) -> bool: ...
    def headerSuppressed(self, /) -> bool: ...
    def height(self, /) -> float: ...
    def hitTest(self, wpt: PyGe.Point3d, wviewVec: PyGe.Vector3d, /) -> tuple[bool, int, int]: ...
    def horzCellMargin(self, /) -> float: ...
    def insertColumns(self, col: int, width: float, rows: int, /) -> None: ...
    def insertColumnsAndInherit(
        self, nIndex: int, nInheritFrom: int, nNumCols: int, /
    ) -> None: ...
    def insertRows(self, row: int, width: float, rows: int, /) -> None: ...
    def insertRowsAndInherit(self, nIndex: int, nInheritFrom: int, nNumRows: int, /) -> None: ...
    def insertionPoint(self, /) -> PyGe.Point3d: ...
    def isContentEditable(self, row: int, col: int, /) -> bool: ...
    def isFormatEditable(self, row: int, col: int, /) -> bool: ...
    def isMergeAllEnabled(self, row: int, col: int, /) -> bool: ...
    def isMergedCell(self, row: int, col: int, /) -> tuple[bool, int, int, int, int]: ...
    def margin(self, row: int, col: int, margin: PyAx.AcCellMargin, /) -> float: ...
    def mergeCells(self, minRow: int, maxRow: int, minCol: int, maxCol: int, /) -> None: ...
    def minimumColumnWidth(self, val: int, /) -> float: ...
    def minimumRowHeight(self, val: int, /) -> float: ...
    def minimumTableHeight(self, /) -> float: ...
    def minimumTableWidth(self, /) -> float: ...
    def override(self, row: int, col: int, nContent: int, /) -> AcCellProperty: ...
    def recomputeTableBlock(self, bForceUpdate: bool, /) -> None: ...
    def regenerateTableSuppressed(self, /) -> bool: ...
    def removeAllOverrides(self, row: int, col: int, /) -> None: ...
    def repeatBottomLabels(self, /) -> bool: ...
    def repeatTopLabels(self, /) -> bool: ...
    def reselectSubRegion(self, /) -> None: ...
    def rotation(self, row: int, col: int, nContent: int, /) -> float: ...
    def rowHeight(self, /) -> float: ...
    def rowType(self, row: int, /) -> AcRowType: ...
    def rows(self, /) -> int: ...
    def scale(self, row: int, col: int, nContent: int, /) -> float: ...
    def select(
        self,
        wpt: PyGe.Point3d,
        wvwVec: PyGe.Vector3d,
        wvwxVec: PyGe.Vector3d,
        wxaper: float,
        wyaper: float,
        allowOutside: bool,
        /,
    ) -> tuple[int, int]: ...
    def selectSubRegion(
        self,
        wpt1: PyGe.Point3d,
        wpt2: PyGe.Point3d,
        wvwVec: PyGe.Vector3d,
        wvwxVec: PyGe.Vector3d,
        seltype: PyAx.AcSelectType,
        bIncludeCurrent: bool,
        /,
    ) -> tuple[int, int, int, int]: ...
    def setAllowManualHeights(self, val: bool, /) -> None: ...
    def setAllowManualPositions(self, val: bool, /) -> None: ...
    def setAutoScale(self, row: int, col: int, val: bool, /) -> None: ...
    @overload
    def setBlockAttributeValue(
        self, row: int, col: int, id: PyDb.ObjectId, val: str, /
    ) -> None: ...
    @overload
    def setBlockAttributeValue(
        self, row: int, col: int, nContent: int, id: PyDb.ObjectId, val: str, /
    ) -> None: ...
    @overload
    def setBlockAttributeValue(self, *args) -> None: ...
    def setBlockRotation(self, row: int, col: int, val: float, /) -> None: ...
    def setBlockScale(self, row: int, col: int, val: float, /) -> None: ...
    @overload
    def setBlockTableRecordId(
        self, row: int, col: int, id: PyDb.ObjectId, autoScale: bool, /
    ) -> None: ...
    @overload
    def setBlockTableRecordId(
        self, row: int, col: int, nContent: int, id: PyDb.ObjectId, autoScale: bool, /
    ) -> None: ...
    @overload
    def setBlockTableRecordId(self, *args) -> None: ...
    def setBreakHeight(self, idx: int, val: float, /) -> None: ...
    def setBreakSpacing(self, val: float, /) -> None: ...
    def setBreaksEnabled(self, val: bool, /) -> None: ...
    def setCellAlignment(self, row: int, col: int, val: PyAx.AcCellAlignment, /) -> None: ...
    def setCellBackgroundColor(self, row: int, col: int, val: PyAx.AcadAcCmColor, /) -> None: ...
    def setCellBackgroundColorNone(self, row: int, col: int, val: bool, /) -> None: ...
    def setCellContentColor(self, row: int, col: int, val: PyAx.AcadAcCmColor, /) -> None: ...
    def setCellDataType(
        self, row: int, col: int, dataType: PyAx.AcValueDataType, unitType: PyAx.AcValueUnitType, /
    ) -> None: ...
    def setCellFormat(self, row: int, col: int, fmt: str, /) -> None: ...
    def setCellGridColor(
        self, row: int, col: int, mask: PyAx.AcCellEdgeMask, val: PyAx.AcadAcCmColor, /
    ) -> None: ...
    def setCellGridLineWeight(
        self, row: int, col: int, mask: PyAx.AcCellEdgeMask, lw: PyAx.AcLineWeight, /
    ) -> None: ...
    def setCellGridVisibility(
        self, row: int, col: int, mask: PyAx.AcCellEdgeMask, val: bool, /
    ) -> None: ...
    def setCellState(self, row: int, col: int, val: PyAx.AcCellState, /) -> None: ...
    def setCellStyle(self, row: int, col: int, style: str, /) -> None: ...
    def setCellTextHeight(self, row: int, col: int, val: float, /) -> None: ...
    def setCellTextStyle(self, row: int, col: int, val: str, /) -> None: ...
    def setCellValue(self, row: int, col: int, val: PyDb.AcValue, /) -> None: ...
    def setCellValueFromText(
        self, row: int, col: int, val: str, nOption: PyAx.AcParseOption, /
    ) -> None: ...
    def setColumnName(self, col: int, val: str, /) -> None: ...
    @overload
    def setColumnWidth(self, val: float, /) -> None: ...
    @overload
    def setColumnWidth(self, col: int, val: float, /) -> None: ...
    @overload
    def setColumnWidth(self, *args) -> None: ...
    def setColumns(self, val: int, /) -> None: ...
    def setContentColor(
        self, row: int, col: int, nContent: int, val: PyAx.AcadAcCmColor, /
    ) -> None: ...
    def setContentLayout(self, row: int, col: int, val: PyAx.AcCellContentLayout, /) -> None: ...
    def setCustomData(self, row: int, col: int, key: str, val: PyDb.AcValue, /) -> None: ...
    def setDataFormat(self, row: int, col: int, nContent: int, val: str, /) -> None: ...
    def setDataType(
        self,
        row: int,
        col: int,
        nContent: int,
        dataType: PyAx.AcValueDataType,
        unitType: PyAx.AcValueUnitType,
        /,
    ) -> None: ...
    def setDirection(self, val: PyGe.Vector3d, /) -> None: ...
    def setEnableBreak(self, val: bool, /) -> None: ...
    @overload
    def setFieldId(self, row: int, col: int, id: PyDb.ObjectId, /) -> None: ...
    @overload
    def setFieldId(
        self, row: int, col: int, nContent: int, id: PyDb.ObjectId, nflag: PyAx.AcCellOption, /
    ) -> None: ...
    @overload
    def setFieldId(self, *args) -> None: ...
    def setFlowDirection(self, val: PyAx.AcTableDirection, /) -> None: ...
    def setFormula(self, row: int, col: int, nContent: int, val: str, /) -> None: ...
    def setGridColor(
        self, row: int, col: int, lt: PyAx.AcGridLineType, val: PyAx.AcadAcCmColor, /
    ) -> None: ...
    def setGridDoubleLineSpacing(
        self, row: int, col: int, lt: PyAx.AcGridLineType, val: float, /
    ) -> None: ...
    def setGridLineStyle(
        self, row: int, col: int, lt: PyAx.AcGridLineType, val: PyAx.AcGridLineStyle, /
    ) -> None: ...
    def setGridLineWeight(
        self, row: int, col: int, lt: PyAx.AcGridLineType, lw: PyAx.AcLineWeight, /
    ) -> None: ...
    def setGridLinetype(
        self, row: int, col: int, lt: PyAx.AcGridLineType, val: PyDb.ObjectId, /
    ) -> None: ...
    def setGridVisibility(
        self, row: int, col: int, lt: PyAx.AcGridLineType, val: bool, /
    ) -> None: ...
    def setHeaderSuppressed(self, val: bool, /) -> None: ...
    def setHeight(self, val: float, /) -> None: ...
    def setHorzCellMargin(self, val: float, /) -> None: ...
    def setInsertionPoint(self, val: float, /) -> None: ...
    def setMargin(self, row: int, col: int, margin: PyAx.AcCellMargin, val: float, /) -> None: ...
    def setOverride(
        self, row: int, col: int, nContent: int, val: PyAx.AcCellProperty, /
    ) -> None: ...
    def setRegenerateTableSuppressed(self, val: bool, /) -> None: ...
    def setRepeatBottomLabels(self, val: bool, /) -> None: ...
    def setRepeatTopLabels(self, val: bool, /) -> None: ...
    def setRotation(self, row: int, col: int, nContent: int, val: float, /) -> None: ...
    @overload
    def setRowHeight(self, val: float, /) -> None: ...
    @overload
    def setRowHeight(self, row: int, val: float, /) -> None: ...
    @overload
    def setRowHeight(self, *args) -> None: ...
    def setRows(self, val: int, /) -> None: ...
    def setScale(self, row: int, col: int, nContent: int, val: float, /) -> None: ...
    def setStyleName(self, val: str, /) -> None: ...
    def setSubSelection(self, minRow: int, maxRow: int, minCol: int, maxCol: int, /) -> None: ...
    def setTableBreakFlowDirection(self, val: PyAx.AcTableFlowDirection, /) -> None: ...
    def setTableBreakHeight(self, val: float, /) -> None: ...
    def setText(self, row: int, col: int, val: str, /) -> None: ...
    def setTextHeight(self, row: int, col: int, nContent: int, val: float, /) -> None: ...
    def setTextRotation(self, row: int, col: int, val: PyAx.AcRotationAngle, /) -> None: ...
    def setTextString(self, row: int, col: int, nContent: int, val: str, /) -> None: ...
    def setTextStyle(self, row: int, col: int, nContent: int, style: str, /) -> None: ...
    def setTitleSuppressed(self, val: bool, /) -> None: ...
    def setToolTip(self, row: int, col: int, val: str, /) -> None: ...
    def setValue(self, row: int, col: int, nContent: int, val: PyDb.AcValue, /) -> None: ...
    def setVertCellMargin(self, val: float, /) -> None: ...
    def setWidth(self, val: float, /) -> None: ...
    def styleName(self, /) -> str: ...
    def subSelection(self, /) -> tuple[int, int, int, int]: ...
    def tableBreakFlowDirection(self, /) -> AcTableFlowDirection: ...
    def tableBreakHeight(self, /) -> float: ...
    def tableStyleOverrides(self, /) -> list[int]: ...
    def text(self, row: int, col: int, /) -> str: ...
    def textHeight(self, row: int, col: int, nContent: int, /) -> float: ...
    def textRotation(self, row: int, col: int, /) -> AcRotationAngle: ...
    def textString(self, row: int, col: int, nContent: int, /) -> str: ...
    def textStyle(self, row: int, col: int, nContent: int, /) -> str: ...
    def titleSuppressed(self, /) -> bool: ...
    def unmergeCells(self, minRow: int, maxRow: int, minCol: int, maxCol: int, /) -> None: ...
    def value(self, row: int, col: int, nContent: int, /) -> PyDb.AcValue: ...
    def vertCellMargin(self, /) -> float: ...
    def width(self, /) -> float: ...

class AcadTableStyle(PyAx.AcadObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def alignment(self, cellStyle: str, /) -> AcCellAlignment: ...
    def backgroundColor(self, cellStyle: str, /) -> AcadAcCmColor: ...
    def bitFlags(self, /) -> int: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadTableStyle: ...
    def cellClass(self, cellStyle: str, /) -> int: ...
    def cellStyles(self, /) -> list[str]: ...
    @staticmethod
    def className() -> str: ...
    def color(self, cellStyle: str, /) -> AcadAcCmColor: ...
    def createCellStyle(self, cellStyle: str, /) -> None: ...
    def createCellStyleFromStyle(self, cellStyle: str, sourceCellStyle: str, /) -> None: ...
    def dataType(self, cellStyle: str, /) -> tuple[PyAx.AcValueDataType, PyAx.AcValueUnitType]: ...
    def deleteCellStyle(self, cellStyle: str, /) -> None: ...
    def description(self, /) -> str: ...
    def enableMergeAll(self, cellStyle: str, val: bool, /) -> None: ...
    def flowDirection(self, /) -> AcTableDirection: ...
    def format(self, cellStyle: str, /) -> str: ...
    def gridColor(self, cellStyle: str, gridLineType: PyAx.AcGridLineType, /) -> AcadAcCmColor: ...
    def gridLineWeight(
        self, cellStyle: str, gridLineType: PyAx.AcGridLineType, /
    ) -> AcLineWeight: ...
    def gridVisibility(self, cellStyle: str, gridLineType: PyAx.AcGridLineType, /) -> bool: ...
    def headerSuppressed(self, /) -> bool: ...
    def horzCellMargin(self, /) -> float: ...
    def isCellStyleInUse(self, cellStyle: str, /) -> bool: ...
    def isMergeAllEnabled(self, cellStyle: str, /) -> bool: ...
    def name(self, /) -> str: ...
    def numCellStyles(self, /) -> int: ...
    def renameCellStyle(self, oldName: str, newName: str, /) -> None: ...
    def rotation(self, cellStyle: str, /) -> float: ...
    def setAlignment(self, cellStyle: str, val: PyAx.AcCellAlignment, /) -> None: ...
    def setBackgroundColor(self, cellStyle: str, val: PyAx.AcadAcCmColor, /) -> None: ...
    def setBitFlags(self, val: int, /) -> None: ...
    def setCellClass(self, cellStyle: str, val: int, /) -> None: ...
    def setColor(self, cellStyle: str, val: PyAx.AcadAcCmColor, /) -> None: ...
    def setDataType(
        self, cellStyle: str, nDataType: PyAx.AcValueDataType, nUnitType: PyAx.AcValueUnitType, /
    ) -> None: ...
    def setDescription(self, val: str, /) -> None: ...
    def setFlowDirections(self, val: PyAx.AcTableDirection, /) -> None: ...
    def setFormat(self, cellStyle: str, val: str, /) -> None: ...
    def setGridColor(
        self, cellStyle: str, gridLineType: PyAx.AcGridLineType, val: PyAx.AcadAcCmColor, /
    ) -> None: ...
    def setGridVisibility(
        self, cellStyle: str, gridLineType: PyAx.AcGridLineType, val: bool, /
    ) -> None: ...
    def setHeaderSuppressed(self, val: bool, /) -> None: ...
    def setHorzCellMargin(self, val: float, /) -> None: ...
    def setName(self, val: str, /) -> None: ...
    def setRotation(self, cellStyle: str, val: int, /) -> None: ...
    def setTemplateId(
        self,
        id: PyDb.ObjectId,
        option: PyAx.AcMergeCellStyleOption = PyAx.AcMergeCellStyleOption.acMergeCellStyleNone,
        /,
    ) -> None: ...
    def setTextHeight(self, cellStyle: str, val: float, /) -> None: ...
    def setTextStyleId(self, cellStyle: str, id: PyDb.ObjectIdr, /) -> None: ...
    def setTitleSuppressed(self, val: bool, /) -> None: ...
    def setVertCellMargin(self, val: float, /) -> None: ...
    def templateId(self, /) -> PyDb.ObjectId: ...
    def textHeight(self, cellStyle: str, /) -> float: ...
    def textStyleId(self, cellStyle: str, /) -> PyDb.ObjectId: ...
    def titleSuppressed(self, /) -> bool: ...
    def uniqueCellStyleName(self, cellStyle: str, /) -> str: ...
    def vertCellMargin(self, /) -> float: ...

class AcadText(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def alignment(self, /) -> AcAlignment: ...
    def backward(self, /) -> bool: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadText: ...
    @staticmethod
    def className() -> str: ...
    def fieldCode(self, /) -> str: ...
    def height(self, /) -> float: ...
    def horizontalAlignment(self, /) -> AcHorizontalAlignment: ...
    def insertionPoint(self, /) -> PyGe.Point3d: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def obliqueAngle(self, /) -> float: ...
    def rotation(self, /) -> float: ...
    def scaleFactor(self, /) -> float: ...
    def setAlignment(self, val: PyAx.AcAlignment, /) -> None: ...
    def setBackward(self, val: bool, /) -> None: ...
    def setHeight(self, val: float, /) -> None: ...
    def setHorizontalAlignment(self, val: PyAx.AcHorizontalAlignment, /) -> None: ...
    def setInsertionPoint(self, val: PyGe.Point3d, /) -> None: ...
    def setNormal(self, val: PyGe.Vector3d, /) -> None: ...
    def setObliqueAngle(self, val: float, /) -> None: ...
    def setRotation(self, val: float, /) -> None: ...
    def setScaleFactor(self, val: float, /) -> None: ...
    def setStyleName(self, val: str, /) -> None: ...
    def setTextAlignmentPoint(self, val: PyGe.Point3d, /) -> None: ...
    def setTextGenerationFlag(self, val: int, /) -> None: ...
    def setTextString(self, val: str, /) -> None: ...
    def setThickness(self, val: float, /) -> None: ...
    def setUpsideDown(self, val: bool, /) -> None: ...
    def setVerticalAlignment(self, val: PyAx.AcVerticalAlignment, /) -> None: ...
    def styleName(self, /) -> str: ...
    def textAlignmentPoint(self, /) -> PyGe.Point3d: ...
    def textGenerationFlag(self, /) -> int: ...
    def textString(self, /) -> str: ...
    def thickness(self, /) -> float: ...
    def upsideDown(self, /) -> bool: ...
    def verticalAlignment(self, /) -> AcVerticalAlignment: ...

class AcadTextStyle(PyAx.AcadObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def bigFontFile(self, /) -> str: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadTextStyle: ...
    @staticmethod
    def className() -> str: ...
    def font(self, /) -> tuple: ...
    def fontFile(self, /) -> str: ...
    def height(self, /) -> float: ...
    def lastHeight(self, /) -> float: ...
    def name(self, /) -> str: ...
    def obliqueAngle(self, /) -> float: ...
    def setBigFontFile(self, val: str, /) -> None: ...
    def setFont(
        self, typeFace: str, bold: bool, italic: bool, charset: int, pitchAndFamily: int, /
    ) -> None: ...
    def setFontFile(self, val: str, /) -> None: ...
    def setHeight(self, val: float, /) -> None: ...
    def setLastHeight(self, val: float, /) -> None: ...
    def setObliqueAngle(self, val: float, /) -> None: ...
    def setTextGenerationFlag(self, val: int, /) -> None: ...
    def setWidth(self, val: float, /) -> None: ...
    def textGenerationFlag(self, /) -> int: ...
    def width(self, /) -> float: ...

class AcadTextStyles(PyAx.AcadObject):
    def __getitem__(self, index: int, /) -> AcadTextStyle: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __iter__(self, /) -> Iterator[PyAx.AcadTextStyle]: ...
    def __reduce__(self, /) -> Any: ...
    def add(self, name: str, /) -> AcadTextStyle: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadTextStyles: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, index: int, /) -> AcadTextStyle: ...
    def items(self, /) -> list[PyAx.AcadTextStyle]: ...

class AcadTolerance(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadTolerance: ...
    @staticmethod
    def className() -> str: ...
    def dimensionLineColor(self, /) -> AcColor: ...
    def directionVector(self, /) -> PyGe.Vector3d: ...
    def insertionPoint(self, /) -> PyGe.Point3d: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def scaleFactor(self, /) -> float: ...
    def setDimensionLineColor(self, val: float, /) -> None: ...
    def setDirectionVector(self, val: PyGe.Vector3d, /) -> None: ...
    def setInsertionPoint(self, val: PyGe.Point3d, /) -> None: ...
    def setNormal(self, val: PyGe.Vector3d, /) -> None: ...
    def setScaleFactor(self, val: float, /) -> None: ...
    def setStyleName(self, val: str, /) -> None: ...
    def setTextColor(self, val: PyAx.AcColor, /) -> None: ...
    def setTextHeight(self, val: float, /) -> None: ...
    def setTextString(self, val: str, /) -> None: ...
    def setTextStyle(self, val: str, /) -> None: ...
    def styleName(self, /) -> str: ...
    def textColor(self, /) -> AcColor: ...
    def textHeight(self, /) -> float: ...
    def textString(self, /) -> str: ...
    def textStyle(self, /) -> str: ...

class AcadToolbar:
    def __getitem__(self, index: int, /) -> AcadToolbarItem: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def addToolbarButton(
        self, index: int, name: str, helpstr: str, macro: str, flyoutButton: bool, /
    ) -> AcadToolbarItem: ...
    @staticmethod
    def className() -> str: ...
    def clear(self, /) -> None: ...
    def count(self, /) -> int: ...
    def dock(self, val: PyAx.AcToolbarDockStatus, /) -> None: ...
    def dockStatus(self, /) -> AcToolbarDockStatus: ...
    def floatingRows(self, /) -> int: ...
    def height(self, /) -> int: ...
    def helpString(self, /) -> str: ...
    def isVisible(self, /) -> bool: ...
    def item(self, idx: int, /) -> AcadToolbarItem: ...
    def largeButtons(self, /) -> bool: ...
    def left(self, /) -> int: ...
    def name(self, /) -> str: ...
    def parent(self, /) -> AcadToolbars: ...
    def setFloat(self, top: int, left: int, numberFloatRows: int, /) -> None: ...
    def setFloatingRows(self, nRows: int, /) -> None: ...
    def setHelpString(self, helpString: str, /) -> None: ...
    def setLeft(self, left: int, /) -> None: ...
    def setName(self, name: str, /) -> None: ...
    def setTop(self, top: int, /) -> None: ...
    def setVisible(self, visible: bool, /) -> None: ...
    def tagString(self, /) -> str: ...
    def top(self, /) -> int: ...
    def width(self, /) -> int: ...

class AcadToolbarItem:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def attachToolbarToFlyout(self, menuGroupName: str, toolbarGroupName: str, /) -> None: ...
    def bitmaps(self, /) -> tuple[str, str]: ...
    @staticmethod
    def className() -> str: ...
    def clear(self, /) -> None: ...
    def commandDisplayName(self, /) -> str: ...
    def getType(self, /) -> AcToolbarItemType: ...
    def helpString(self, /) -> str: ...
    def index(self, /) -> int: ...
    def macro(self, /) -> str: ...
    def name(self, /) -> str: ...
    def parent(self, /) -> AcadToolbar: ...
    def setBitmaps(self, smallIconName: str, largeIconName: str, /) -> None: ...
    def setCommandDisplayName(self, commandDisplayName: str, /) -> None: ...
    def setHelpString(self, helpString: str, /) -> None: ...
    def setMacro(self, macro: str, /) -> None: ...
    def setName(self, name: str, /) -> None: ...
    def setTagString(self, tag: str, /) -> None: ...
    def tagString(self, /) -> str: ...

class AcadToolbars:
    def __getitem__(self, index: int, /) -> AcadToolbar: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def add(self, toolbarName: str, /) -> AcadToolbar: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, idx: int, /) -> AcadToolbar: ...
    def largeButtons(self, /) -> bool: ...
    def parent(self, /) -> AcadMenuGroup: ...
    def setLargeButtons(self, largeButtons: bool, /) -> None: ...

class AcadTrace(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadTrace: ...
    @staticmethod
    def className() -> str: ...
    def coordinates(self, /) -> list[PyGe.Point3d]: ...
    def normal(self, /) -> PyGe.Vector3d: ...
    def setCoordinates(self, coords: Collection[PyGe.Point3d], /) -> None: ...
    def setNormal(self, val: PyGe.Vector3d, /) -> None: ...
    def setThickness(self, val: float, /) -> None: ...
    def thickness(self, /) -> float: ...

class AcadUCS(PyAx.AcadObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadUCS: ...
    @staticmethod
    def className() -> str: ...
    def name(self, /) -> str: ...
    def origin(self, /) -> PyGe.Point3d: ...
    def setName(self, name: str, /) -> None: ...
    def setXVector(self, val: PyGe.Vector3d, /) -> None: ...
    def setYVector(self, val: PyGe.Vector3d, /) -> None: ...
    def ucsMatrix(self, /) -> PyGe.Matrix3d: ...
    def xVector(self, /) -> PyGe.Vector3d: ...
    def yVector(self, /) -> PyGe.Vector3d: ...

class AcadUCSs(PyAx.AcadObject):
    def __getitem__(self, index: int, /) -> AcadUCS: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __iter__(self, /) -> Iterator[PyAx.AcadUCS]: ...
    def __reduce__(self, /) -> Any: ...
    def add(
        self, origin: PyGe.Point3d, XDir: PyGe.Vector3d, YDir: PyGe.Vector3d, name: str, /
    ) -> AcadUCS: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadUCSs: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, index: int, /) -> AcadUCS: ...
    def items(self, /) -> list[PyAx.AcadUCS]: ...

class AcadUtility:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def angleFromXAxis(self, startPoint: PyGe.Point3d, endPoint: PyGe.Point3d, /) -> float: ...
    def angleToReal(self, angle: str, unit: PyAx.AcAngleUnits, /) -> float: ...
    def angleToString(self, angle: float, unit: PyAx.AcAngleUnits, precision: int, /) -> str: ...
    @staticmethod
    def className() -> str: ...
    def distanceToReal(self, dist: str, unit: PyAx.AcAngleUnits, /) -> float: ...
    @overload
    def getAngle(self, prompt: str, /) -> float: ...
    @overload
    def getAngle(self, basePoint: PyGe.Point3d, prompt: str, /) -> float: ...
    @overload
    def getAngle(self, *args) -> float: ...
    def getCorner(self, point: PyGe.Point3d, prompt: str, /) -> PyGe.Point3d: ...
    def getDistance(self, point: PyGe.Point3d, prompt: str, /) -> float: ...
    def getEntity(self, prompt: str, /) -> tuple[PyAx.AcadEntity, PyGe.Point3d]: ...
    def getInput(self, /) -> str: ...
    def getInteger(self, prompt: str, /) -> int: ...
    def getKeyword(self, prompt: str, /) -> str: ...
    def getObjectIdString(self, obj: PyAx.AcadEntity, bHex: bool, /) -> str: ...
    def getOrientation(self, point: PyGe.Point3d, prompt: str, /) -> float: ...
    @overload
    def getPoint(self, prompt: str, /) -> PyGe.Point3d: ...
    @overload
    def getPoint(self, basePoint: PyGe.Point3d, prompt: str, /) -> PyGe.Point3d: ...
    @overload
    def getPoint(self, *args) -> PyGe.Point3d: ...
    def getReal(self, prompt: str, /) -> float: ...
    def getRemoteFile(self, URL: str, ignoreCache: bool, /) -> str: ...
    def getString(self, hasSpaces: int, prompt: str, /) -> str: ...
    def getSubEntity(self, prompt: str, /) -> tuple: ...
    def initializeUserInput(self, bits: int, keyWordList: str, /) -> None: ...
    def isRemoteFile(self, localFile: str, /) -> None: ...
    def isURL(self, URL: str, /) -> bool: ...
    def launchBrowserDialog(
        self, title: str, caption: str, URL: str, regkey: str, bnEnabled: bool, /
    ) -> tuple: ...
    def polarPoint(
        self, point: PyGe.Point3d, angle: float, distance: float, /
    ) -> PyGe.Point3d: ...
    def prompt(self, prompt: str, /) -> None: ...
    def putRemoteFile(self, URL: str, localFile: str, /) -> None: ...
    def realToString(self, real: str, unit: PyAx.AcAngleUnits, /) -> str: ...
    def sendModelessOperationEnded(self, context: str, /) -> None: ...
    def sendModelessOperationStart(self, context: str, /) -> None: ...
    def translateCoordinates(self, /) -> PyGe.Point3d: ...

class AcadView(PyAx.AcadObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadView: ...
    def categoryName(self, /) -> str: ...
    def center(self, /) -> PyGe.Point3d: ...
    @staticmethod
    def className() -> str: ...
    def direction(self, /) -> PyGe.Vector3d: ...
    def hasVpAssociation(self, /) -> bool: ...
    def height(self, /) -> float: ...
    def layerState(self, /) -> str: ...
    def layoutId(self, /) -> PyDb.ObjectId: ...
    def name(self, /) -> str: ...
    def setCategoryName(self, val: str, /) -> None: ...
    def setCenter(self, val: PyGe.Point3d, /) -> None: ...
    def setDirection(self, val: PyGe.Vector3d, /) -> None: ...
    def setHasVpAssociation(self, val: str, /) -> None: ...
    def setHeight(self, val: float, /) -> None: ...
    def setLayerState(self, val: str, /) -> None: ...
    def setLayoutId(self, val: PyDb.ObjectId, /) -> None: ...
    def setName(self, val: str, /) -> None: ...
    def setTarget(self, val: PyGe.Point3d, /) -> None: ...
    def setWidth(self, val: float, /) -> None: ...
    def target(self, /) -> PyGe.Point3d: ...
    def width(self, /) -> float: ...

class AcadViewport(PyAx.AcadObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def arcSmoothness(self, /) -> int: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadViewport: ...
    def center(self, /) -> PyGe.Point3d: ...
    @staticmethod
    def className() -> str: ...
    def direction(self, /) -> PyGe.Vector3d: ...
    def gridOn(self, /) -> bool: ...
    def gridSpacing(self, /) -> tuple[float, float]: ...
    def height(self, /) -> float: ...
    def lowerLeftCorner(self, /) -> PyGe.Point2d: ...
    def name(self, /) -> str: ...
    def orthoOn(self, /) -> bool: ...
    def setArcSmoothness(self, val: int, /) -> None: ...
    def setCenter(self, val: PyGe.Point3d, /) -> None: ...
    def setDirection(self, val: PyGe.Vector3d, /) -> None: ...
    def setGridOn(self, val: bool, /) -> None: ...
    def setGridSpacing(self, XSpacing: float, YSpacing: float, /) -> None: ...
    def setHeight(self, val: float, /) -> None: ...
    def setName(self, val: str, /) -> None: ...
    def setOrthoOn(self, val: bool, /) -> None: ...
    def setSnapBasePoint(self, val: PyGe.Point3d, /) -> None: ...
    def setSnapOn(self, val: bool, /) -> None: ...
    def setSnapRotationAngle(self, val: float, /) -> None: ...
    def setSnapSpacing(self, XSpacing: float, YSpacing: float, /) -> None: ...
    def setTarget(self, val: PyGe.Point3d, /) -> None: ...
    def setUCSIconAtOrigin(self, val: bool, /) -> None: ...
    def setUCSIconOn(self, val: bool, /) -> None: ...
    def setView(self, val: PyAx.AcadView, /) -> None: ...
    def setWidth(self, val: float, /) -> None: ...
    def snapBasePoint(self, /) -> PyGe.Point3d: ...
    def snapOn(self, /) -> bool: ...
    def snapRotationAngle(self, /) -> float: ...
    def snapSpacing(self, /) -> tuple[float, float]: ...
    def split(self, val: PyAx.AcViewportSplitType, /) -> None: ...
    def target(self, /) -> PyGe.Point3d: ...
    def ucsIconAtOrigin(self, /) -> bool: ...
    def ucsIconOn(self, /) -> bool: ...
    def upperRightCorner(self, /) -> PyGe.Point2d: ...
    def width(self, /) -> float: ...

class AcadViewports(PyAx.AcadObject):
    def __getitem__(self, index: int, /) -> AcadViewport: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __iter__(self, /) -> Iterator[PyAx.AcadViewport]: ...
    def __reduce__(self, /) -> Any: ...
    def add(self, name: str, /) -> AcadViewport: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadViewports: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, index: int, /) -> AcadViewport: ...
    def items(self, /) -> list[PyAx.AcadViewport]: ...

class AcadViews(PyAx.AcadObject):
    def __getitem__(self, index: int, /) -> AcadView: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __iter__(self, /) -> Iterator[PyAx.AcadView]: ...
    def __reduce__(self, /) -> Any: ...
    def add(self, name: str, /) -> AcadView: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadViews: ...
    @staticmethod
    def className() -> str: ...
    def count(self, /) -> int: ...
    def item(self, index: int, /) -> AcadView: ...
    def items(self, /) -> list[PyAx.AcadView]: ...

class AcadXRecord(PyAx.AcadObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadXRecord: ...
    @staticmethod
    def className() -> str: ...
    def name(self, /) -> str: ...
    def setName(self, val: str, /) -> None: ...
    def setTranslateIDs(self, val: bool, /) -> None: ...
    def setXRecordData(self, xrecordData: Collection[tuple[int, Any]], /) -> None: ...
    def translateIDs(self, /) -> bool: ...
    def xrecordData(self, /) -> list: ...

class AcadXline(PyAx.AcadEntity):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def basePoint(self, /) -> PyGe.Point3d: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> AcadXline: ...
    @staticmethod
    def className() -> str: ...
    def directionVector(self, /) -> PyGe.Vector3d: ...
    def offset(self, val: float, /) -> list[PyAx.AcadEntity]: ...
    def secondPoint(self, /) -> PyGe.Point3d: ...
    def setBasePoint(self, val: PyGe.Point3d, /) -> None: ...
    def setDirectionVector(self, val: PyGe.Vector3d, /) -> None: ...
    def setSecondPoint(self, val: PyGe.Point3d, /) -> None: ...

class ModelSpace(PyAx.AcadBlock):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> ModelSpace: ...
    @staticmethod
    def className() -> str: ...

class PaperSpace(PyAx.AcadBlock):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def addPViewport(self, /) -> AcadPViewport: ...
    @staticmethod
    def cast(otherObject: PyAx.AcadObject, /) -> PaperSpace: ...
    @staticmethod
    def className() -> str: ...
