from __future__ import annotations

from typing import Any, ClassVar, Self, overload

from pyrx import Db as PyDb
from pyrx import Pl as PyPl
from pyrx import Rx as PyRx
from pyrx.doc_utils.boost_meta import _BoostPythonEnum

eDeviceLoadFailed: CustomSizeResult  # 8192
eException: CustomSizeResult  # 256
eMustCreatePC3: CustomSizeResult  # 1
ePC3DirReadOnly: CustomSizeResult  # 4
ePC3FileReadOnly: CustomSizeResult  # 64
ePMPDirMissing: CustomSizeResult  # 16
ePMPDirReadOnly: CustomSizeResult  # 8
ePMPFileReadOnly: CustomSizeResult  # 2048
ePossible: CustomSizeResult  # 0
eRotationRequired: CustomSizeResult  # 2
eSizeTooBig: CustomSizeResult  # 128
eUnknownErrPC3File: CustomSizeResult  # 512
eUnknownErrPMPDir: CustomSizeResult  # 32
eUnknownErrPMPFile: CustomSizeResult  # 1024
eWidthAndHeightMustBePositive: CustomSizeResult  # 4096
k3dDwf: SetupType  # 3
kAll: RefreshCode  # 0
kAllTypes: StyTypes  # 7
kBackgroundPlotting: ProcessPlotState  # 2
kCancelJobBtnMsg: PlotMSGIndex  # 9
kCancelSheetBtnMsg: PlotMSGIndex  # 8
kColorDep: StyTypes  # 4
kDWF6ePlot: StdConfigs  # 2
kDWFePlotOptForPlotting: StdConfigs  # 3
kDWFePlotOptForViewing: StdConfigs  # 4
kDWFxePlot: StdConfigs  # 8
kDefaultWindowsSysPrinter: StdConfigs  # 1
kDialogTitle: PlotMSGIndex  # 0
kForegroundPlotting: ProcessPlotState  # 1
kMatchDisabled: MatchingPolicy  # 1
kMatchEnabled: MatchingPolicy  # 2
kMatchEnabledCustom: MatchingPolicy  # 3
kMatchEnabledTmpCustom: MatchingPolicy  # 4
kMsgCancelling: PlotMSGIndex  # 6
kMsgCancellingCurrent: PlotMSGIndex  # 7
kMsgCount: PlotMSGIndex  # 10
kMultiDWF: SheetType  # 1
kMultiDWFx: SheetType  # 4
kMultiPDF: SheetType  # 6
kMultiSVF: SheetType  # 8
kMustPlotToFile: PlotToFileCapability  # 2
kNPSOtherDWG: SetupType  # 2
kNPSSameDWG: SetupType  # 1
kNoPlotToFile: PlotToFileCapability  # 0
kNoneDevice: StdConfigs  # 0
kNotPlotting: ProcessPlotState  # 0
kOneOffConfig: DeviceType  # 2
kOriginalDevice: SheetType  # 2
kOriginalPS: SetupType  # 0
kOverridePS: SetupType  # 4
kPC3File: DeviceType  # 1
kPDFePlot: StdConfigs  # 10
kPDFePlotGeneralDocs: StdConfigs  # 11
kPDFePlotHighQuality: StdConfigs  # 12
kPDFePlotSmallerFile: StdConfigs  # 13
kPDFePlotWebMobile: StdConfigs  # 14
kPlotCancelStatusCount: PlotCancelStatus  # 3
kPlotCanceledByCaller: PlotCancelStatus  # 1
kPlotCanceledByCancelAllButton: PlotCancelStatus  # 2
kPlotContinue: PlotCancelStatus  # 0
kPlotToFileAllowed: PlotToFileCapability  # 1
kPublishToWebDWF: StdConfigs  # 5
kPublishToWebDWFx: StdConfigs  # 9
kPublishToWebJPG: StdConfigs  # 6
kPublishToWebPNG: StdConfigs  # 7
kRefreshDevicesList: RefreshCode  # 1
kRefreshPC3DevicesList: RefreshCode  # 4
kRefreshStyleList: RefreshCode  # 2
kRefreshSystemDevicesList: RefreshCode  # 3
kRegular: StyTypes  # 1
kSVFePlot: StdConfigs  # 15
kSheetCancelStatusCount: SheetCancelStatus  # 4
kSheetCanceledByCaller: SheetCancelStatus  # 3
kSheetCanceledByCancelAllButton: SheetCancelStatus  # 2
kSheetCanceledByCancelButton: SheetCancelStatus  # 1
kSheetContinue: SheetCancelStatus  # 0
kSheetName: PlotMSGIndex  # 1
kSheetNameToolTip: PlotMSGIndex  # 2
kSheetProgressCaption: PlotMSGIndex  # 4
kSheetSetProgressCaption: PlotMSGIndex  # 5
kSingleDWF: SheetType  # 0
kSingleDWFx: SheetType  # 3
kSinglePDF: SheetType  # 5
kSingleSVF: SheetType  # 7
kStatus: PlotMSGIndex  # 3
kSystemPrinter: DeviceType  # 0
kTranslation: StyTypes  # 2
kUndefined: StyTypes  # 0
kUninitialized: DeviceType  # -1

class Core:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def processPlotState() -> ProcessPlotState: ...
    @staticmethod
    def publishExecute(
        dsdDataObj: PyPl.DSDData, pConfig: PyPl.PlotConfig, bShowPlotProgress: bool, /
    ) -> None: ...

class CustomSizeResult(_BoostPythonEnum):
    ePossible: ClassVar[Self]  # 0
    eMustCreatePC3: ClassVar[Self]  # 1
    eRotationRequired: ClassVar[Self]  # 2
    ePC3DirReadOnly: ClassVar[Self]  # 4
    ePMPDirReadOnly: ClassVar[Self]  # 8
    ePMPDirMissing: ClassVar[Self]  # 16
    eUnknownErrPMPDir: ClassVar[Self]  # 32
    ePC3FileReadOnly: ClassVar[Self]  # 64
    eSizeTooBig: ClassVar[Self]  # 128
    eException: ClassVar[Self]  # 256
    eUnknownErrPC3File: ClassVar[Self]  # 512
    eUnknownErrPMPFile: ClassVar[Self]  # 1024
    ePMPFileReadOnly: ClassVar[Self]  # 2048
    eWidthAndHeightMustBePositive: ClassVar[Self]  # 4096
    eDeviceLoadFailed: ClassVar[Self]  # 8192

class DSDData(PyPl.PlObject):
    def __init__(self, /) -> None:
        """
        This utility class reads and writes DSD files. It holds an array of AcPlDSDEntry objects in
        addition to DSD sheet set information.
        """
    def __reduce__(self, /) -> Any: ...
    def categoryName(self, /) -> str: ...
    @staticmethod
    def className() -> str: ...
    def currentPrecision(self, /) -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def destinationName(self, /) -> str: ...
    def get3dDwfOptions(self, /) -> tuple[bool, bool]: ...
    def getDSDEntries(self, /) -> list[PyPl.DSDEntry]: ...
    def getPrecisionEntries(self, /) -> list[PyPl.PrecisionEntry]: ...
    def getUnrecognizedData(self, /) -> tuple: ...
    def includeLayerInfo(self, /) -> bool: ...
    def initializeLayouts(self, /) -> bool: ...
    def isHomogeneous(self, /) -> bool: ...
    def isSheetSet(self, /) -> bool: ...
    def lineMerge(self, /) -> bool: ...
    def logFilePath(self, /) -> str: ...
    def majorVersion(self, /) -> int: ...
    def minorVersion(self, /) -> int: ...
    def noOfCopies(self, /) -> int: ...
    def numberOfDSDEntries(self, /) -> int: ...
    def password(self, /) -> str: ...
    def plotStampOn(self, /) -> bool: ...
    def projectPath(self, /) -> str: ...
    def promptForDwfName(self, /) -> bool: ...
    def promptForPassword(self, /) -> bool: ...
    def pwdProtectPublishedDWF(self, /) -> bool: ...
    def selectionSetName(self, /) -> str: ...
    def set3dDwfOptions(
        self, groupByXrefHierarchy: bool, publishWithMaterials: bool, /
    ) -> None: ...
    def setCategoryName(self, val: str, /) -> None: ...
    def setCurrentPrecision(self, val: str, /) -> None: ...
    def setDSDEntries(self, entries: list[PyPl.DSDEntry], /) -> None: ...
    def setDestinationName(self, val: str, /) -> None: ...
    def setIncludeLayerInfo(self, val: bool, /) -> None: ...
    def setInitializeLayouts(self, val: bool, /) -> None: ...
    def setIsHomogeneous(self, val: bool, /) -> None: ...
    def setIsSheetSet(self, val: bool, /) -> None: ...
    def setLineMerge(self, val: bool, /) -> None: ...
    def setLogFilePath(self, val: str, /) -> None: ...
    def setMajorVersion(self, val: int, /) -> None: ...
    def setMinorVersion(self, val: int, /) -> None: ...
    def setNoOfCopies(self, val: int, /) -> None: ...
    def setPassword(self, val: str, /) -> None: ...
    def setPlotStampOn(self, val: bool, /) -> None: ...
    def setPrecisionEntries(self, val: list[PyPl.PrecisionEntry], /) -> None: ...
    def setProjectPath(self, path: str, /) -> None: ...
    def setPromptForDwfName(self, val: bool, /) -> None: ...
    def setPromptForPassword(self, val: bool, /) -> None: ...
    def setPwdProtectPublishedDWF(self, val: bool, /) -> None: ...
    def setSelectionSetName(self, val: str, /) -> None: ...
    def setSheetSetName(self, val: str, /) -> None: ...
    def setSheetType(self, val: PyPl.SheetType, /) -> None: ...
    def setUnrecognizedData(self, sectionName: str, sectionData: str, /) -> None: ...
    def setViewFile(self, val: bool, /) -> None: ...
    def sheetSetName(self, /) -> str: ...
    def sheetType(self, /) -> SheetType: ...
    def viewFile(self, /) -> bool: ...

class DSDEntry(PyPl.PlObject):
    def NPS(self, /) -> str: ...
    def NPSSourceDWG(self, /) -> str: ...
    def __init__(self, /) -> None:
        """
        This container class holds information specific to a sheet (in a sheet set). AcPlDSDData
        holds a collection of AcPlDSDEntry objects to configure a publish job.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def dwgName(self, /) -> str: ...
    def has3dDwfSetup(self, /) -> bool: ...
    def layout(self, /) -> str: ...
    def orgSheetPath(self, /) -> str: ...
    def setDwgName(self, val: str, /) -> None: ...
    def setHas3dDwfSetup(self, val: bool, /) -> None: ...
    def setLayout(self, val: str, /) -> None: ...
    def setNPS(self, val: str, /) -> None: ...
    def setNPSSourceDWG(self, val: str, /) -> None: ...
    def setSetupType(self, val: PyPl.SetupType, /) -> None: ...
    def setTitle(self, val: str, /) -> None: ...
    def setTraceSession(self, val: str, /) -> None: ...
    def setupType(self, /) -> SetupType: ...
    def title(self, /) -> str: ...
    def traceSession(self, /) -> str: ...

class DeviceType(_BoostPythonEnum):
    kSystemPrinter: ClassVar[Self]  # 0
    kPC3File: ClassVar[Self]  # 1
    kOneOffConfig: ClassVar[Self]  # 2
    kUninitialized: ClassVar[Self]  # -1

class MatchingPolicy(_BoostPythonEnum):
    kMatchDisabled: ClassVar[Self]  # 1
    kMatchEnabled: ClassVar[Self]  # 2
    kMatchEnabledCustom: ClassVar[Self]  # 3
    kMatchEnabledTmpCustom: ClassVar[Self]  # 4

class PlObject(PyRx.RxObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...

class PlotCancelStatus(_BoostPythonEnum):
    kPlotContinue: ClassVar[Self]  # 0
    kPlotCanceledByCaller: ClassVar[Self]  # 1
    kPlotCanceledByCancelAllButton: ClassVar[Self]  # 2
    kPlotCancelStatusCount: ClassVar[Self]  # 3

class PlotConfig(PyPl.PlObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def deviceName(self, /) -> str: ...
    def deviceType(self, /) -> int: ...
    def fullPath(self, /) -> str: ...
    def getCanonicalMediaNameList(self, /) -> list[str]: ...
    def getDefaultFileExtension(self, /) -> str: ...
    def getDescriptionFields(self, /) -> tuple[str, ...]: ...
    def getLocalMediaName(self, canonicalMediaName: str, /) -> str: ...
    def getMediaBounds(self, canonicalMediaName: str, /) -> tuple: ...
    def isPlotToFile(self, /) -> bool: ...
    def maxDeviceDPI(self, /) -> int: ...
    def plotToFileCapability(self, /) -> PlotToFileCapability: ...
    def refreshMediaNameList(self, /) -> None: ...
    def saveToPC3(self, val: str, /) -> bool: ...
    def setPlotToFile(self, val: bool, /) -> None: ...

class PlotConfigInfo(PyPl.PlObject):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def deviceId(self, /) -> str: ...
    def deviceName(self, /) -> str: ...
    def deviceType(self, /) -> DeviceType: ...
    def fullPath(self, /) -> str: ...
    def setDeviceId(self, val: type, /) -> None: ...
    def setDeviceName(self, val: str, /) -> None: ...
    def setDeviceType(self, val: PyPl.DeviceType, /) -> None: ...
    def setFullPath(self, val: str, /) -> None: ...

class PlotConfigManager:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def getCurrentConfig(self, /) -> PlotConfig: ...
    def getDevicesList(self, /) -> list[PyPl.PlotConfigInfo]: ...
    def getStdConfigName(self, /) -> str: ...
    def getStyleList(self, /) -> list[str]: ...
    def refreshList(self, refreshCode: PyPl.RefreshCode = PyPl.RefreshCode.kAll, /) -> None: ...
    def setCurrentConfig(self, deviceName: str, /) -> PlotConfig: ...

class PlotEngine:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def beginDocument(
        self, plotInfo: PyPl.PlotInfo, docName: str, plotToFile: bool, fileName: str, /
    ) -> None: ...
    def beginGenerateGraphics(self, /) -> None: ...
    def beginPage(
        self, pageInfo: PyPl.PlotPageInfo, plotInfo: PyPl.PlotInfo, lastPage: bool, /
    ) -> None: ...
    def beginPlot(self, dlgRef: PyPl.PlotProgressDialog, /) -> None: ...
    @staticmethod
    def className() -> str: ...
    def destroy(self, /) -> None: ...
    def endDocument(self, /) -> None: ...
    def endGenerateGraphics(self, /) -> None: ...
    def endPage(self, /) -> None: ...
    def endPlot(self, /) -> None: ...
    def isBackgroundPackaging(self, /) -> bool: ...

class PlotFactory:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def createPreviewEngine(flags: int = 1, /) -> PlotEngine: ...
    @staticmethod
    def createPublishEngine() -> PlotEngine: ...
    @staticmethod
    def processPlotState() -> ProcessPlotState: ...

class PlotInfo(PyPl.PlObject):
    def OrgFilePath(self, /) -> str: ...
    def __init__(self, /) -> None:
        """
        AcPlPlotInfo is a utility class that provides methods for building information about how
        and what to plot and, ultimately, acts as a vehicle to transport this information to the
        plotting pipeline. Applications must provide the object ID of the layout to be plotted to
        this object before passing it to an AcPlPlotEngine object for processing. Applications can
        provide overrides, in the form of an AcDbPlotSettings object, to be used for plotting the
        layout in place of the settings on the layout itself. Applications can also override the
        output device by providing an AcPlPlotConfig object designating the device to plot to. If a
        device override is applied, it supercedes the device in the layout and the device in the
        AcDbPlotSettings overrides object. AcPlPlotInfo objects must be validated using an
        AcDbPlotInfoValidator before they can be processed by an AcPlPlotEngine. Validated
        AcPlPlotInfo objects have non-null validated settings data and non-null validated
        configurations, which will be used by the AcPlPlotEngine to plot the layout when it is
        processed.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def copyFrom(self, otherObject: PyRx.RxObject, /) -> None: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def deviceOverride(self, /) -> PlotConfig: ...
    def isCompatibleDocument(self, val: PyPl.PlotInfo, /) -> bool: ...
    def isValidated(self, /) -> bool: ...
    def layout(self, /) -> PyDb.ObjectId: ...
    def mergeStatus(self, /) -> int: ...
    def overrideSettings(self, /) -> PyDb.PlotSettings: ...
    def setDeviceOverride(self, val: PyPl.PlotConfig, /) -> None: ...
    def setLayout(self, id: PyDb.ObjectId, /) -> None: ...
    def setOverrideSettings(self, val: PyDb.PlotSettings, /) -> None: ...
    def setValidatedConfig(self, val: PyPl.PlotConfig, /) -> None: ...
    def setValidatedSettings(self, val: PyDb.PlotSettings, /) -> None: ...
    def validatedConfig(self, /) -> PlotConfig: ...
    def validatedSettings(self, /) -> PyDb.PlotSettings: ...

class PlotInfoValidator(PyPl.PlObject):
    def __init__(self, /) -> None:
        """
        The AcPlPlotInfoValidator class merges plot settings from a layout object, an
        AcDbPlotSettings object (settings overrides), and an output device override into a new plot
        settings object. The validator returns a set of codes indicating any problems found during
        the merge operation. The validator supports paper-matching policies in its validation
        algorithmn. Depending on the setting of the policy, the validator may try to find a
        matching paper size if the canonical paper name provided in the layout or overrides does
        not exist on the device. The validator also has policies to create a custom paper size, if
        possible, in case the matching algorithmn fails.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def dimensionalWeight(self, /) -> int: ...
    def isCustomPossible(self, valByRef: PyPl.PlotInfo, /) -> CustomSizeResult: ...
    def matchingPolicy(self, /) -> MatchingPolicy: ...
    def mediaBoundsWeight(self, val: int, /) -> int: ...
    def mediaGroupWeight(self, /) -> int: ...
    def mediaMatchingThreshold(self, /) -> int: ...
    def printableBoundsWeight(self, /) -> int: ...
    def setDefDimensionalWeight(self, /) -> None: ...
    def setDefMediaBoundsWeight(self, /) -> None: ...
    def setDefMediaGroupWeight(self, val: int, /) -> None: ...
    def setDefMediaMatchingThreshold(self, /) -> None: ...
    def setDefPrintableBoundsWeight(self, /) -> None: ...
    def setDefSheetDimensionalWeight(self, /) -> None: ...
    def setDefSheetMediaGroupWeight(self, /) -> None: ...
    def setDimensionalWeight(self, val: int, /) -> None: ...
    def setMediaBoundsWeight(self, val: int, /) -> None: ...
    def setMediaGroupWeight(self, val: int, /) -> None: ...
    def setMediaMatchingPolicy(self, val: PyPl.MatchingPolicy, /) -> None: ...
    def setMediaMatchingThreshold(self, val: int, /) -> None: ...
    def setPrintableBoundsWeight(self, val: int, /) -> None: ...
    def setSheetDimensionalWeight(self, val: int, /) -> None: ...
    def setSheetMediaGroupWeight(self, val: int, /) -> None: ...
    def sheetDimensionalWeight(self, /) -> int: ...
    def sheetMediaGroupWeight(self, /) -> int: ...
    def validate(self, valByRef: PyPl.PlotInfo, /) -> None: ...

class PlotMSGIndex(_BoostPythonEnum):
    kDialogTitle: ClassVar[Self]  # 0
    kSheetName: ClassVar[Self]  # 1
    kSheetNameToolTip: ClassVar[Self]  # 2
    kStatus: ClassVar[Self]  # 3
    kSheetProgressCaption: ClassVar[Self]  # 4
    kSheetSetProgressCaption: ClassVar[Self]  # 5
    kMsgCancelling: ClassVar[Self]  # 6
    kMsgCancellingCurrent: ClassVar[Self]  # 7
    kCancelSheetBtnMsg: ClassVar[Self]  # 8
    kCancelJobBtnMsg: ClassVar[Self]  # 9
    kMsgCount: ClassVar[Self]  # 10

class PlotPageInfo(PyPl.PlObject):
    def __init__(self, /) -> None:
        """
        Returns information about the objects contained on a plotted page. Applications can use
        this information as a starting point for estimating the time required to plot the page (or,
        more precisely, to determine whether to warn the user that the page will take a long time
        to plot). An object of this type is returned by the AcPlPlotEngine::startPage() method.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    @staticmethod
    def entityCount() -> int: ...
    @staticmethod
    def gradientCount() -> int: ...
    @staticmethod
    def oleObjectCount() -> int: ...
    @staticmethod
    def rasterCount() -> int: ...
    @staticmethod
    def shadedViewportType() -> int: ...

class PlotProgressDialog:
    @overload
    def __init__(self, /) -> None: ...
    @overload
    def __init__(self, bPreview: bool, nSheets: int, bShowCancelSheetButton: bool, /) -> None: ...
    @overload
    def __init__(
        self, hwnd: int, bPreview: bool, nSheets: int, bShowCancelSheetButton: bool, /
    ) -> None: ...
    @overload
    def __init__(self, *args) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def destroy(self, /) -> None: ...
    def getPlotMsgString(self, index: PyPl.PlotMSGIndex, /) -> str: ...
    def getPlotProgressRange(self, /) -> tuple[int, int]: ...
    def getSheetProgressRange(self, /) -> tuple[int, int]: ...
    def getStatusMsgString(self, /) -> str: ...
    def heartbeat(self, /) -> None: ...
    def isPlotCancelled(self, /) -> bool: ...
    def isSheetCancelled(self, /) -> bool: ...
    def isSingleSheetPlot(self, /) -> bool: ...
    def isVisible(self, /) -> bool: ...
    def onBeginPlot(self, /) -> bool: ...
    def onBeginSheet(self, /) -> bool: ...
    def onEndPlot(self, /) -> bool: ...
    def onEndSheet(self, /) -> bool: ...
    def plotCancelStatus(self, /) -> PlotCancelStatus: ...
    def plotProgressPos(self, /) -> int: ...
    def setIsVisible(self, val: bool, /) -> bool: ...
    def setPlotCancelStatus(self, val: PyPl.PlotCancelStatus, /) -> None: ...
    def setPlotMsgString(self, index: PyPl.PlotMSGIndex, val: str, /) -> bool: ...
    def setPlotProgressPos(self, pos: int, /) -> None: ...
    def setPlotProgressRange(self, lower: int, upper: int, /) -> None: ...
    def setSheetCancelStatus(self, val: PyPl.SheetCancelStatus, /) -> None: ...
    def setSheetProgressPos(self, pos: int, /) -> None: ...
    def setSheetProgressRange(self, lower: int, upper: int, /) -> None: ...
    def setStatusMsgString(self, val: str, /) -> bool: ...
    def sheetCancelStatus(self, /) -> SheetCancelStatus: ...
    def sheetProgressPos(self, /) -> int: ...

class PlotToFileCapability(_BoostPythonEnum):
    kNoPlotToFile: ClassVar[Self]  # 0
    kPlotToFileAllowed: ClassVar[Self]  # 1
    kMustPlotToFile: ClassVar[Self]  # 2

class PrecisionEntry(PyPl.PlObject):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def colorResolution(self, /) -> int: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def description(self, /) -> str: ...
    def desiredPrecision(self, /) -> float: ...
    def gradientResolution(self, /) -> int: ...
    def monoResolution(self, /) -> int: ...
    def setColorResolution(self, val: int, /) -> None: ...
    def setDescription(self, val: str, /) -> None: ...
    def setDesiredPrecision(self, val: float, /) -> None: ...
    def setGradientResolution(self, val: int, /) -> None: ...
    def setMonoResolution(self, val: type, /) -> None: ...
    def setTitle(self, val: str, /) -> None: ...
    def setUnitScale(self, val: str, /) -> None: ...
    def setUnitType(self, val: str, /) -> None: ...
    def title(self, /) -> str: ...
    def unitScale(self, /) -> str: ...
    def unitType(self, /) -> str: ...

class ProcessPlotState(_BoostPythonEnum):
    kNotPlotting: ClassVar[Self]  # 0
    kForegroundPlotting: ClassVar[Self]  # 1
    kBackgroundPlotting: ClassVar[Self]  # 2

class RefreshCode(_BoostPythonEnum):
    kAll: ClassVar[Self]  # 0
    kRefreshDevicesList: ClassVar[Self]  # 1
    kRefreshStyleList: ClassVar[Self]  # 2
    kRefreshSystemDevicesList: ClassVar[Self]  # 3
    kRefreshPC3DevicesList: ClassVar[Self]  # 4

class SetupType(_BoostPythonEnum):
    kOriginalPS: ClassVar[Self]  # 0
    kNPSSameDWG: ClassVar[Self]  # 1
    kNPSOtherDWG: ClassVar[Self]  # 2
    k3dDwf: ClassVar[Self]  # 3
    kOverridePS: ClassVar[Self]  # 4

class SheetCancelStatus(_BoostPythonEnum):
    kSheetContinue: ClassVar[Self]  # 0
    kSheetCanceledByCancelButton: ClassVar[Self]  # 1
    kSheetCanceledByCancelAllButton: ClassVar[Self]  # 2
    kSheetCanceledByCaller: ClassVar[Self]  # 3
    kSheetCancelStatusCount: ClassVar[Self]  # 4

class SheetType(_BoostPythonEnum):
    kSingleDWF: ClassVar[Self]  # 0
    kMultiDWF: ClassVar[Self]  # 1
    kOriginalDevice: ClassVar[Self]  # 2
    kSingleDWFx: ClassVar[Self]  # 3
    kMultiDWFx: ClassVar[Self]  # 4
    kSinglePDF: ClassVar[Self]  # 5
    kMultiPDF: ClassVar[Self]  # 6
    kSingleSVF: ClassVar[Self]  # 7
    kMultiSVF: ClassVar[Self]  # 8

class StdConfigs(_BoostPythonEnum):
    kNoneDevice: ClassVar[Self]  # 0
    kDefaultWindowsSysPrinter: ClassVar[Self]  # 1
    kDWF6ePlot: ClassVar[Self]  # 2
    kDWFePlotOptForPlotting: ClassVar[Self]  # 3
    kDWFePlotOptForViewing: ClassVar[Self]  # 4
    kPublishToWebDWF: ClassVar[Self]  # 5
    kPublishToWebJPG: ClassVar[Self]  # 6
    kPublishToWebPNG: ClassVar[Self]  # 7
    kDWFxePlot: ClassVar[Self]  # 8
    kPublishToWebDWFx: ClassVar[Self]  # 9
    kPDFePlot: ClassVar[Self]  # 10
    kPDFePlotGeneralDocs: ClassVar[Self]  # 11
    kPDFePlotHighQuality: ClassVar[Self]  # 12
    kPDFePlotSmallerFile: ClassVar[Self]  # 13
    kPDFePlotWebMobile: ClassVar[Self]  # 14
    kSVFePlot: ClassVar[Self]  # 15

class StyTypes(_BoostPythonEnum):
    kUndefined: ClassVar[Self]  # 0
    kRegular: ClassVar[Self]  # 1
    kTranslation: ClassVar[Self]  # 2
    kColorDep: ClassVar[Self]  # 4
    kAllTypes: ClassVar[Self]  # 7
