# Generated by Django 4.1.9 on 2023-07-11 10:27

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("wbwiki", "0001_initial_squashed_0004_alter_wikiarticle_tags"),
    ]

    operations = [
        migrations.CreateModel(
            name="WikiArticleRelationship",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True, verbose_name="Name")),
                ("object_id", models.PositiveIntegerField(verbose_name="Related Item")),
                (
                    "content_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                        verbose_name="Item Type",
                    ),
                ),
                (
                    "wiki",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="relationships",
                        to="wbwiki.wikiarticle",
                    ),
                ),
            ],
            options={
                "verbose_name": "Wiki Relationship",
                "verbose_name_plural": "Wiki Relationships",
            },
        ),
        migrations.AddIndex(
            model_name="wikiarticlerelationship",
            index=models.Index(fields=["content_type", "object_id"], name="wbwiki_wiki_content_9ba127_idx"),
        ),
        migrations.AddConstraint(
            model_name="wikiarticlerelationship",
            constraint=models.UniqueConstraint(
                fields=("wiki", "content_type", "object_id"), name="unique_wiki_article_relationship"
            ),
        ),
    ]
