"""Stub file for reflex/components/markdown/markdown.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
import dataclasses
from collections.abc import Callable, Mapping, Sequence
from functools import lru_cache
from typing import Any

from reflex.components.component import Component
from reflex.components.core.breakpoints import Breakpoints
from reflex.event import EventType, PointerEventInfo
from reflex.utils.imports import ImportDict
from reflex.vars.base import LiteralVar, Var, VarData

_CHILDREN = Var(_js_expr="children", _var_type=str)
_PROPS = Var(_js_expr="props")
_PROPS_SPREAD = Var(_js_expr="...props")
_MOCK_ARG = Var(_js_expr="", _var_type=str)
_LANGUAGE = Var(_js_expr="_language", _var_type=str)
_REMARK_MATH = Var(_js_expr="remarkMath")
_REMARK_GFM = Var(_js_expr="remarkGfm")
_REMARK_UNWRAP_IMAGES = Var(_js_expr="remarkUnwrapImages")
_REMARK_PLUGINS = LiteralVar.create([_REMARK_MATH, _REMARK_GFM, _REMARK_UNWRAP_IMAGES])
_REHYPE_KATEX = Var(_js_expr="rehypeKatex")
_REHYPE_RAW = Var(_js_expr="rehypeRaw")
_REHYPE_PLUGINS = LiteralVar.create([_REHYPE_KATEX, _REHYPE_RAW])
NO_PROPS_TAGS = ("ul", "ol", "li")

@lru_cache
def get_base_component_map() -> dict[str, Callable]: ...
@dataclasses.dataclass()
class MarkdownComponentMap:
    @classmethod
    def get_component_map_custom_code(cls) -> Var: ...
    @classmethod
    def create_map_fn_var(
        cls,
        fn_body: Var | None = None,
        fn_args: Sequence[str] | None = None,
        explicit_return: bool | None = None,
        var_data: VarData | None = None,
    ) -> Var: ...
    @classmethod
    def get_fn_args(cls) -> Sequence[str]: ...
    @classmethod
    def get_fn_body(cls) -> Var: ...

class Markdown(Component):
    @classmethod
    def create(
        cls,
        *children,
        component_map: dict[str, Any] | None = None,
        component_map_hash: str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Markdown:
        """Create a markdown component.

        Args:
            *children: The children of the component.
            component_map: The component map from a tag to a lambda that creates a component.
            component_map_hash: The hash of the component map, generated at create() time.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the component.

        Raises:
            ValueError: If the children are not valid.

        Returns:
            The markdown component.
        """

    def add_imports(self) -> ImportDict | list[ImportDict]: ...
    def format_component_map(self) -> dict[str, Var]: ...
    def get_component(self, tag: str, **props) -> Component: ...
    def format_component(self, tag: str, **props) -> str: ...
