"""Stub file for reflex/components/radix/themes/components/radio_group.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from collections.abc import Mapping, Sequence
from typing import Any, Literal

from reflex.components.component import ComponentNamespace
from reflex.components.core.breakpoints import Breakpoints
from reflex.components.radix.themes.base import RadixThemesComponent
from reflex.event import EventType, PointerEventInfo
from reflex.vars.base import Var

LiteralFlexDirection = Literal["row", "column", "row-reverse", "column-reverse"]

class RadioGroupRoot(RadixThemesComponent):
    @classmethod
    def create(
        cls,
        *children,
        size: Breakpoints[str, Literal["1", "2", "3"]]
        | Literal["1", "2", "3"]
        | Var[Breakpoints[str, Literal["1", "2", "3"]] | Literal["1", "2", "3"]]
        | None = None,
        variant: Literal["classic", "soft", "surface"]
        | Var[Literal["classic", "soft", "surface"]]
        | None = None,
        color_scheme: Literal[
            "amber",
            "blue",
            "bronze",
            "brown",
            "crimson",
            "cyan",
            "gold",
            "grass",
            "gray",
            "green",
            "indigo",
            "iris",
            "jade",
            "lime",
            "mint",
            "orange",
            "pink",
            "plum",
            "purple",
            "red",
            "ruby",
            "sky",
            "teal",
            "tomato",
            "violet",
            "yellow",
        ]
        | Var[
            Literal[
                "amber",
                "blue",
                "bronze",
                "brown",
                "crimson",
                "cyan",
                "gold",
                "grass",
                "gray",
                "green",
                "indigo",
                "iris",
                "jade",
                "lime",
                "mint",
                "orange",
                "pink",
                "plum",
                "purple",
                "red",
                "ruby",
                "sky",
                "teal",
                "tomato",
                "violet",
                "yellow",
            ]
        ]
        | None = None,
        high_contrast: Var[bool] | bool | None = None,
        value: Var[str] | str | None = None,
        default_value: Var[str] | str | None = None,
        disabled: Var[bool] | bool | None = None,
        name: Var[str] | str | None = None,
        required: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_change: EventType[()] | EventType[str] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> RadioGroupRoot:
        """Create a new component instance.

        Will prepend "RadixThemes" to the component tag to avoid conflicts with
        other UI libraries for common names, like Text and Button.

        Args:
            *children: Child components.
            size: The size of the radio group: "1" | "2" | "3"
            variant: The variant of the radio group
            color_scheme: The color of the radio group
            high_contrast: Whether to render the radio group with higher contrast color against background
            value: The controlled value of the radio item to check. Should be used in conjunction with on_change.
            default_value: The initial value of checked radio item. Should be used in conjunction with on_change.
            disabled: Whether the radio group is disabled
            name: The name of the group. Submitted with its owning form as part of a name/value pair.
            required: Whether the radio group is required
            on_change: Fired when the value of the radio group changes.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: Component properties.

        Returns:
            A new component instance.
        """

class RadioGroupItem(RadixThemesComponent):
    @classmethod
    def create(
        cls,
        *children,
        value: Var[str] | str | None = None,
        disabled: Var[bool] | bool | None = None,
        required: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> RadioGroupItem:
        """Create a new component instance.

        Will prepend "RadixThemes" to the component tag to avoid conflicts with
        other UI libraries for common names, like Text and Button.

        Args:
            *children: Child components.
            value: The value of the radio item to check. Should be used in conjunction with on_change.
            disabled: When true, prevents the user from interacting with the radio item.
            required: When true, indicates that the user must check the radio item before the owning form can be submitted.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: Component properties.

        Returns:
            A new component instance.
        """

class HighLevelRadioGroup(RadixThemesComponent):
    @classmethod
    def create(
        cls,
        *children,
        items: Sequence[str] | Var[Sequence[str]] | None = None,
        direction: Literal["column", "column-reverse", "row", "row-reverse"]
        | Var[Literal["column", "column-reverse", "row", "row-reverse"]]
        | None = None,
        spacing: Literal["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"]
        | Var[Literal["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"]]
        | None = None,
        size: Literal["1", "2", "3"] | Var[Literal["1", "2", "3"]] | None = None,
        variant: Literal["classic", "soft", "surface"]
        | Var[Literal["classic", "soft", "surface"]]
        | None = None,
        color_scheme: Literal[
            "amber",
            "blue",
            "bronze",
            "brown",
            "crimson",
            "cyan",
            "gold",
            "grass",
            "gray",
            "green",
            "indigo",
            "iris",
            "jade",
            "lime",
            "mint",
            "orange",
            "pink",
            "plum",
            "purple",
            "red",
            "ruby",
            "sky",
            "teal",
            "tomato",
            "violet",
            "yellow",
        ]
        | Var[
            Literal[
                "amber",
                "blue",
                "bronze",
                "brown",
                "crimson",
                "cyan",
                "gold",
                "grass",
                "gray",
                "green",
                "indigo",
                "iris",
                "jade",
                "lime",
                "mint",
                "orange",
                "pink",
                "plum",
                "purple",
                "red",
                "ruby",
                "sky",
                "teal",
                "tomato",
                "violet",
                "yellow",
            ]
        ]
        | None = None,
        high_contrast: Var[bool] | bool | None = None,
        value: Var[str] | str | None = None,
        default_value: Var[str] | str | None = None,
        disabled: Var[bool] | bool | None = None,
        name: Var[str] | str | None = None,
        required: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> HighLevelRadioGroup:
        """Create a radio group component.

        Args:
            items: The items of the radio group.
            items: The items of the radio group.
            direction: The direction of the radio group.
            spacing: The gap between the items of the radio group.
            size: The size of the radio group.
            variant: The variant of the radio group
            color_scheme: The color of the radio group
            high_contrast: Whether to render the radio group with higher contrast color against background
            value: The controlled value of the radio item to check. Should be used in conjunction with on_change.
            default_value: The initial value of checked radio item. Should be used in conjunction with on_change.
            disabled: Whether the radio group is disabled
            name: The name of the group. Submitted with its owning form as part of a name/value pair.
            required: Whether the radio group is required
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: Additional properties to apply to the accordion item.

        Returns:
            The created radio group component.

        Raises:
            TypeError: If the type of items is invalid.
        """

class RadioGroup(ComponentNamespace):
    root = staticmethod(RadioGroupRoot.create)
    item = staticmethod(RadioGroupItem.create)

    @staticmethod
    def __call__(
        *children,
        items: Sequence[str] | Var[Sequence[str]] | None = None,
        direction: Literal["column", "column-reverse", "row", "row-reverse"]
        | Var[Literal["column", "column-reverse", "row", "row-reverse"]]
        | None = None,
        spacing: Literal["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"]
        | Var[Literal["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"]]
        | None = None,
        size: Literal["1", "2", "3"] | Var[Literal["1", "2", "3"]] | None = None,
        variant: Literal["classic", "soft", "surface"]
        | Var[Literal["classic", "soft", "surface"]]
        | None = None,
        color_scheme: Literal[
            "amber",
            "blue",
            "bronze",
            "brown",
            "crimson",
            "cyan",
            "gold",
            "grass",
            "gray",
            "green",
            "indigo",
            "iris",
            "jade",
            "lime",
            "mint",
            "orange",
            "pink",
            "plum",
            "purple",
            "red",
            "ruby",
            "sky",
            "teal",
            "tomato",
            "violet",
            "yellow",
        ]
        | Var[
            Literal[
                "amber",
                "blue",
                "bronze",
                "brown",
                "crimson",
                "cyan",
                "gold",
                "grass",
                "gray",
                "green",
                "indigo",
                "iris",
                "jade",
                "lime",
                "mint",
                "orange",
                "pink",
                "plum",
                "purple",
                "red",
                "ruby",
                "sky",
                "teal",
                "tomato",
                "violet",
                "yellow",
            ]
        ]
        | None = None,
        high_contrast: Var[bool] | bool | None = None,
        value: Var[str] | str | None = None,
        default_value: Var[str] | str | None = None,
        disabled: Var[bool] | bool | None = None,
        name: Var[str] | str | None = None,
        required: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> HighLevelRadioGroup:
        """Create a radio group component.

        Args:
            items: The items of the radio group.
            items: The items of the radio group.
            direction: The direction of the radio group.
            spacing: The gap between the items of the radio group.
            size: The size of the radio group.
            variant: The variant of the radio group
            color_scheme: The color of the radio group
            high_contrast: Whether to render the radio group with higher contrast color against background
            value: The controlled value of the radio item to check. Should be used in conjunction with on_change.
            default_value: The initial value of checked radio item. Should be used in conjunction with on_change.
            disabled: Whether the radio group is disabled
            name: The name of the group. Submitted with its owning form as part of a name/value pair.
            required: Whether the radio group is required
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: Additional properties to apply to the accordion item.

        Returns:
            The created radio group component.

        Raises:
            TypeError: If the type of items is invalid.
        """

radio = radio_group = RadioGroup()
