"""Stub file for reflex/components/react_player/audio.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from collections.abc import Mapping, Sequence
from typing import Any

import reflex
from reflex.components.core.breakpoints import Breakpoints
from reflex.components.react_player.react_player import ReactPlayer
from reflex.event import EventType, PointerEventInfo
from reflex.vars.base import Var

class Audio(ReactPlayer):
    @classmethod
    def create(
        cls,
        *children,
        url: Var[str] | str | None = None,
        playing: Var[bool] | bool | None = None,
        loop: Var[bool] | bool | None = None,
        controls: Var[bool] | bool | None = None,
        light: Var[bool] | bool | None = None,
        volume: Var[float] | float | None = None,
        muted: Var[bool] | bool | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_buffer: EventType[()] | None = None,
        on_buffer_end: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_click_preview: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_disable_pip: EventType[()] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_duration: EventType[()] | EventType[float] | None = None,
        on_enable_pip: EventType[()] | None = None,
        on_ended: EventType[()] | None = None,
        on_error: EventType[()] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_pause: EventType[()] | None = None,
        on_play: EventType[()] | None = None,
        on_playback_quality_change: EventType[()] | None = None,
        on_playback_rate_change: EventType[()] | None = None,
        on_progress: EventType[()]
        | EventType[reflex.components.react_player.react_player.Progress]
        | None = None,
        on_ready: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_seek: EventType[()] | EventType[float] | None = None,
        on_start: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Audio:
        """Create the component.

        Args:
            *children: The children of the component.
            url: The url of a video or song to play
            playing: Set to true or false to pause or play the media
            loop: Set to true or false to loop the media
            controls: Set to true or false to display native player controls.
            light: Set to true to show just the video thumbnail, which loads the full player on click
            volume: Set the volume of the player, between 0 and 1
            muted: Mutes the player
            on_ready: Called when media is loaded and ready to play. If playing is set to true, media will play immediately.
            on_start: Called when media starts playing.
            on_play: Called when media starts or resumes playing after pausing or buffering.
            on_progress: Callback containing played and loaded progress as a fraction, and playedSeconds and loadedSeconds in seconds. eg { played: 0.12, playedSeconds: 11.3, loaded: 0.34, loadedSeconds: 16.7 }
            on_duration: Callback containing duration of the media, in seconds.
            on_pause: Called when media is paused.
            on_buffer: Called when media starts buffering.
            on_buffer_end: Called when media has finished buffering. Works for files, YouTube and Facebook.
            on_seek: Called when media seeks with seconds parameter.
            on_playback_rate_change: Called when playback rate of the player changed. Only supported by YouTube, Vimeo (if enabled), Wistia, and file paths.
            on_playback_quality_change: Called when playback quality of the player changed. Only supported by YouTube (if enabled).
            on_ended: Called when media finishes playing. Does not fire when loop is set to true.
            on_error: Called when an error occurs whilst attempting to play media.
            on_click_preview: Called when user clicks the light mode preview.
            on_enable_pip: Called when picture-in-picture mode is enabled.
            on_disable_pip: Called when picture-in-picture mode is disabled.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """
