from dev_gpt.apis.gpt import ask_gpt
from dev_gpt.options.generate.chains.auto_refine_description import enhance_description, \
    summarize_description_and_schemas_prompt
from dev_gpt.options.generate.parser import identity_parser
from dev_gpt.options.generate.prompt_factory import context_to_string


def test_better_description(init_gpt):

    better_description = enhance_description({
        'microservice_description': 'Input is a tweet that contains passive aggressive language. The output is the positive version of that tweet.'
    })
    assert 'gpt_3_5_turbo' in better_description
    assert 'such as' not in better_description

def test_update_description_based_on_schema(init_gpt):
    updated_description = ask_gpt(
        summarize_description_and_schemas_prompt,
        identity_parser,
        context_string=context_to_string({
            'microservice_description': '''\
Microservice Description:

Given a tweet that contains passive aggressive language, the microservice will generate a positive version of that tweet. The microservice will perform the following tasks:

1. Use a natural language processing tool such as gpt_3_5_turbo to analyze the sentiment of the input tweet and identify the passive aggressive language.
2. Generate a positive version of the tweet using gpt_3_5_turbo or a similar text generation tool.
3. Check the generated tweet for any grammatical errors or typos and correct them if necessary.
4. Return the positive version of the tweet as output.''',
            'request_schema': '''\
{
  "type": "object",
  "properties": {
    "tweet": {
      "type": "string",
      "description": "The input tweet that contains passive aggressive language."
    }
  },
  "required": ["tweet"]
}''',
            'response_schema': '''\
{
  "type": "object",
  "properties": {
    "positive_tweet": {
      "type": "string",
      "description": "The positive version of the input tweet generated by the microservice."
    }
  },
  "required": ["positive_tweet"]
}'''
        })
    )
    assert 'gpt_3_5_turbo' in updated_description