# Import agent queries (used by AI agent) - ONLY 6 EXPOSED QUERIES FOR AGENT
from .agent_queries import (
    GET_FILE_BY_ID,
    GET_FILE_BLOCK_SUMMARY,
    GET_CHILD_BLOCKS,
    GET_PARENT_BLOCK,
    GET_DEPENDENCY_CHAIN,
)

# Import graph queries (used by cross-indexing service)
from .graph_queries import (
    GET_EXISTING_INCOMING_CONNECTIONS,
    GET_EXISTING_OUTGOING_CONNECTIONS,
    GET_CONNECTIONS_BY_IDS,
    INSERT_INCOMING_CONNECTION,
    INSERT_OUTGOING_CONNECTION,
    INSERT_CONNECTION_MAPPING,
    UPDATE_PROJECT_DESCRIPTION,
)


__all__ = [
    "GET_FILE_BY_ID",
    "GET_FILE_BLOCK_SUMMARY",
    "GET_CHILD_BLOCKS",
    "GET_PARENT_BLOCK",
    "GET_DEPENDENCY_CHAIN",
    # GRAPH QUERIES FOR CROSS-INDEXING
    "GET_EXISTING_INCOMING_CONNECTIONS",
    "GET_EXISTING_OUTGOING_CONNECTIONS",
    "GET_CONNECTIONS_BY_IDS",
    "INSERT_INCOMING_CONNECTION",
    "INSERT_OUTGOING_CONNECTION",
    "INSERT_CONNECTION_MAPPING",
    "UPDATE_PROJECT_DESCRIPTION",
]
