"""
CLI commands for claude-mpm.

WHY: This package contains individual command implementations, organized into
separate modules for better maintainability and code organization.
"""

from .agents import manage_agents
from .agent_manager import manage_agent_manager
from .aggregate import aggregate_command
from .cleanup import cleanup_memory
from .config import manage_config
from .doctor import run_doctor
from .info import show_info
from .mcp import manage_mcp
from .memory import manage_memory
from .monitor import manage_monitor
from .run import run_session


from .tickets import list_tickets, manage_tickets

__all__ = [
    "run_session",
    # 'run_guarded_session',  # Excluded from default exports (experimental)
    "manage_tickets",
    "list_tickets",
    "show_info",
    "manage_agents",
    "manage_agent_manager",
    "manage_memory",
    "manage_monitor",
    "manage_config",
    "aggregate_command",
    "cleanup_memory",
    "manage_mcp",
    "run_doctor",
]
