# Guayaba

Designed to create a backend for LLM to save informations with a predefined schema.

```bash
pip install guayaba
```

<br />

## Usage

Import the library and define the output directory for the generated files.

```python
import guayaba as guba

app = guba.get_app("docs")

@guba.dataclass("/hello/{id}")
class User:
    id: int
    name: str
    tags: list[str]

```

Then run with

```bash
uvicorn main:app --reload
```

<br />

## Development

Install the package in editable mode with the development dependencies:

```
pip install -e .
```

Run the example app with:

```bash
uvicorn example.main:app --reload
```

Run the tests with:

```bash
python -m unittest discover -s tests
```
