from enum import Enum
from typing import Optional
import guayaba as guba


class FuelType(Enum):
    PETROL = "Petrol"
    DIESEL = "Diesel"
    ELECTRIC = "Electric"
    HYBRID = "Hybrid"


class TransmissionType(Enum):
    MANUAL = "Manual"
    AUTOMATIC = "Automatic"


@guba.dataclass("/cars/{name}")
class Car:
    name: str
    maker: str
    model: str
    year: int
    fuel_type: Optional[FuelType]
    transmission: Optional[TransmissionType]
    range: float
    price: int
