import os
from pathlib import Path
from fastapi import FastAPI
from fastapi.routing import APIRoute


app = FastAPI()
output = Path("docs")


def get_app(path: str = "docs") -> FastAPI:
    global app, output
    output = Path(path)
    os.makedirs(output, exist_ok=True)
    return app


def route_exists(path: str, method: str | None = None) -> bool:
    for r in app.router.routes:
        if isinstance(r, APIRoute) and r.path == path:
            if method is None or method in r.methods:
                return True
    return False


# TODO: Add a /save endpoint to use gitpython to push changes to a branch ready for PR
@app.get("/save")
async def save():
    return {"message": "Save endpoint not implemented yet."}

