import unittest
import guayaba as guba
from fastapi.testclient import TestClient


@guba.dataclass("/hello/{id}")
class User:
    id: int
    name: str
    tags: list[str]


class TestClassID(unittest.TestCase):
    def setUp(self) -> None:
        app = guba.get_app()
        self.client = TestClient(app)

    def test_get(self):
        # Now, test the GET endpoint
        response = self.client.get("/hello/1")
        print(response)

    def test_post(self):
        # Now, test the POST endpoint
        response = self.client.post("/hello/1", json={"name": "John", "tags": ["tag1", "tag2"]})
        print(response)
    
    def test_put(self):
        # Now, test the PUT endpoint
        response = self.client.put("/hello/1", json={"name": "Jane", "tags": ["tag3"]})
        print(response)

    def test_delete(self):
        # Now, test the DELETE endpoint
        response = self.client.delete("/hello/1")
        print(response)

