# Generated by Django 4.2.6 on 2023-10-07 13:51

from django.db import migrations, models
import django.db.models.deletion
import mptt.fields


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
    ]

    operations = [
        migrations.CreateModel(
            name="Menu",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "language",
                    models.CharField(
                        choices=[("fa", "Persian"), ("en", "English")],
                        default="en",
                        max_length=5,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "name",
                    models.CharField(max_length=50, unique=True, verbose_name="name"),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[("sb", "Sidebar"), ("nb", "Navbar")],
                        max_length=2,
                        verbose_name="menu type",
                    ),
                ),
                ("slug", models.SlugField(unique=True, verbose_name="slug")),
                (
                    "attributes",
                    models.JSONField(default=dict, verbose_name="attributes"),
                ),
                ("icon", models.CharField(blank=True, max_length=50, null=True)),
                ("enabled", models.BooleanField(default=True, verbose_name="enabled")),
            ],
            options={
                "verbose_name": "Menu",
                "verbose_name_plural": "Menus",
            },
        ),
        migrations.CreateModel(
            name="MenuItem",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "language",
                    models.CharField(
                        choices=[("fa", "Persian"), ("en", "English")],
                        default="en",
                        max_length=5,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "label",
                    models.CharField(
                        help_text="Display name on the website.",
                        max_length=50,
                        verbose_name="label",
                    ),
                ),
                (
                    "slug",
                    models.SlugField(
                        help_text="Unique identifier for the menu.",
                        unique=True,
                        verbose_name="slug",
                    ),
                ),
                (
                    "link",
                    models.CharField(
                        blank=True, default="#", max_length=255, verbose_name="link"
                    ),
                ),
                ("order", models.IntegerField(verbose_name="order")),
                (
                    "icon",
                    models.CharField(
                        blank=True, max_length=50, null=True, verbose_name="icon"
                    ),
                ),
                ("enabled", models.BooleanField(default=True, verbose_name="enabled")),
                (
                    "login_required",
                    models.BooleanField(
                        default=False,
                        help_text="If this is checked, only logged-in users will be able to view the item.",
                        verbose_name="login required",
                    ),
                ),
                ("no_reload", models.BooleanField(default=True)),
                (
                    "extras",
                    models.CharField(
                        blank=True,
                        help_text='Comma separated list of extra-attributes, e.g.: <code>icon="fa fa-user",data-tooltip="Go home!"</code>',
                        max_length=255,
                        null=True,
                        verbose_name="extras",
                    ),
                ),
                ("lft", models.PositiveIntegerField(editable=False)),
                ("rght", models.PositiveIntegerField(editable=False)),
                ("tree_id", models.PositiveIntegerField(db_index=True, editable=False)),
                ("level", models.PositiveIntegerField(editable=False)),
                (
                    "menu",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="items",
                        to="flex_menu.menu",
                        verbose_name="menu",
                    ),
                ),
                (
                    "parent",
                    mptt.fields.TreeForeignKey(
                        blank=True,
                        limit_choices_to={"parent": None},
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="children",
                        to="flex_menu.menuitem",
                        verbose_name="parent",
                    ),
                ),
                (
                    "permissions",
                    models.ManyToManyField(
                        blank=True,
                        help_text="If empty, the menu item will be publicly visible, otherwise only users with at least one of the selected permissions could see it.",
                        to="auth.permission",
                        verbose_name="permissions",
                    ),
                ),
            ],
            options={
                "verbose_name": "MenuItem",
                "verbose_name_plural": "MenuItems",
                "ordering": ["order"],
            },
        ),
    ]
