"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _UnaryOperatorType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _UnaryOperatorTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_UnaryOperatorType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNARY_OPERATOR_TYPE_INVALID: _UnaryOperatorType.ValueType  # 0
    UNARY_OPERATOR_TYPE_EXACT_MATCH: _UnaryOperatorType.ValueType  # 1
    UNARY_OPERATOR_TYPE_SAFE_REGEX_MATCH: _UnaryOperatorType.ValueType  # 2
    UNARY_OPERATOR_TYPE_PRESENT_MATCH: _UnaryOperatorType.ValueType  # 3
    UNARY_OPERATOR_TYPE_PREFIX_MATCH: _UnaryOperatorType.ValueType  # 4
    UNARY_OPERATOR_TYPE_SUFFIX_MATCH: _UnaryOperatorType.ValueType  # 5
    UNARY_OPERATOR_TYPE_CONTAINS_MATCH: _UnaryOperatorType.ValueType  # 6

class UnaryOperatorType(_UnaryOperatorType, metaclass=_UnaryOperatorTypeEnumTypeWrapper):
    """Unary operators available types"""

UNARY_OPERATOR_TYPE_INVALID: UnaryOperatorType.ValueType  # 0
UNARY_OPERATOR_TYPE_EXACT_MATCH: UnaryOperatorType.ValueType  # 1
UNARY_OPERATOR_TYPE_SAFE_REGEX_MATCH: UnaryOperatorType.ValueType  # 2
UNARY_OPERATOR_TYPE_PRESENT_MATCH: UnaryOperatorType.ValueType  # 3
UNARY_OPERATOR_TYPE_PREFIX_MATCH: UnaryOperatorType.ValueType  # 4
UNARY_OPERATOR_TYPE_SUFFIX_MATCH: UnaryOperatorType.ValueType  # 5
UNARY_OPERATOR_TYPE_CONTAINS_MATCH: UnaryOperatorType.ValueType  # 6
global___UnaryOperatorType = UnaryOperatorType

class _BinaryOperatorType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _BinaryOperatorTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_BinaryOperatorType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    BINARY_OPERATOR_TYPE_INVALID: _BinaryOperatorType.ValueType  # 0
    BINARY_OPERATOR_TYPE_RANGE_MATCH: _BinaryOperatorType.ValueType  # 1

class BinaryOperatorType(_BinaryOperatorType, metaclass=_BinaryOperatorTypeEnumTypeWrapper):
    """Binary operators available types"""

BINARY_OPERATOR_TYPE_INVALID: BinaryOperatorType.ValueType  # 0
BINARY_OPERATOR_TYPE_RANGE_MATCH: BinaryOperatorType.ValueType  # 1
global___BinaryOperatorType = BinaryOperatorType

class AudienceEntry(google.protobuf.message.Message):
    """Describe audience entry with ID its equivalent ID for CRUD operation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    AUDIENCE_FIELD_NUMBER: builtins.int
    id: builtins.str
    @property
    def audience(self) -> global___Audience: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        audience: global___Audience | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["audience", b"audience"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["audience", b"audience", "id", b"id"]) -> None: ...

global___AudienceEntry = AudienceEntry

class Audience(google.protobuf.message.Message):
    """Specifies Condition based route configuration, If all conditions evaluated to true prediction request will route to routes config.
    For example: Condition check if prediction request include an header key, value which value is exactly "hello" than route
                 configuration will take effect.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class EnvironmentRoutesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___EnvironmentAudienceRoutes: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___EnvironmentAudienceRoutes | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CONDITIONS_FIELD_NUMBER: builtins.int
    ROUTES_FIELD_NUMBER: builtins.int
    CREATED_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    MODIFIED_FIELD_NUMBER: builtins.int
    MODIFIED_BY_FIELD_NUMBER: builtins.int
    ENVIRONMENT_ROUTES_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Audience name"""
    description: builtins.str
    """Audience description"""
    @property
    def conditions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Condition]:
        """All conditions should evaluated to true"""
    @property
    def routes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Route]:
        """If all evaluated to true the prediction will the routes"""
    @property
    def created(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Create date"""
    created_by: builtins.str
    """Created by"""
    @property
    def modified(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Update date"""
    modified_by: builtins.str
    """Updated by"""
    @property
    def environment_routes(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___EnvironmentAudienceRoutes]:
        """Routes by environment id"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        conditions: collections.abc.Iterable[global___Condition] | None = ...,
        routes: collections.abc.Iterable[global___Route] | None = ...,
        created: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by: builtins.str = ...,
        modified: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_by: builtins.str = ...,
        environment_routes: collections.abc.Mapping[builtins.str, global___EnvironmentAudienceRoutes] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created", b"created", "modified", b"modified"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["conditions", b"conditions", "created", b"created", "created_by", b"created_by", "description", b"description", "environment_routes", b"environment_routes", "modified", b"modified", "modified_by", b"modified_by", "name", b"name", "routes", b"routes"]) -> None: ...

global___Audience = Audience

class EnvironmentAudienceRoutes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROUTES_FIELD_NUMBER: builtins.int
    @property
    def routes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Route]: ...
    def __init__(
        self,
        *,
        routes: collections.abc.Iterable[global___Route] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["routes", b"routes"]) -> None: ...

global___EnvironmentAudienceRoutes = EnvironmentAudienceRoutes

class AudienceRoutesEntry(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIENCE_ID_FIELD_NUMBER: builtins.int
    AUDIENCE_NAME_FIELD_NUMBER: builtins.int
    ROUTES_FIELD_NUMBER: builtins.int
    ORDER_FIELD_NUMBER: builtins.int
    audience_id: builtins.str
    audience_name: builtins.str
    @property
    def routes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Route]: ...
    order: builtins.int
    def __init__(
        self,
        *,
        audience_id: builtins.str = ...,
        audience_name: builtins.str = ...,
        routes: collections.abc.Iterable[global___Route] | None = ...,
        order: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["audience_id", b"audience_id", "audience_name", b"audience_name", "order", b"order", "routes", b"routes"]) -> None: ...

global___AudienceRoutesEntry = AudienceRoutesEntry

class Condition(google.protobuf.message.Message):
    """Condition which applied on prediction request header"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    BINARY_CONDITION_FIELD_NUMBER: builtins.int
    UNARY_CONDITION_FIELD_NUMBER: builtins.int
    INVERT_FIELD_NUMBER: builtins.int
    key: builtins.str
    """key to extract value for evaluation"""
    @property
    def binary_condition(self) -> global___BinaryCondition: ...
    @property
    def unary_condition(self) -> global___UnaryCondition: ...
    invert: builtins.bool
    """Condition evaluation should be inverted (For example False will be True)"""
    def __init__(
        self,
        *,
        key: builtins.str = ...,
        binary_condition: global___BinaryCondition | None = ...,
        unary_condition: global___UnaryCondition | None = ...,
        invert: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["binary_condition", b"binary_condition", "condition", b"condition", "unary_condition", b"unary_condition"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["binary_condition", b"binary_condition", "condition", b"condition", "invert", b"invert", "key", b"key", "unary_condition", b"unary_condition"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["condition", b"condition"]) -> typing_extensions.Literal["binary_condition", "unary_condition"] | None: ...

global___Condition = Condition

class UnaryCondition(google.protobuf.message.Message):
    """Unary condition definition
    For example: unary_operator UnaryOperator.UNARY_OPERATOR_EXACT_MATCH with operand hello,
                 will check that header value will be exactly hello.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATOR_FIELD_NUMBER: builtins.int
    OPERAND_FIELD_NUMBER: builtins.int
    operator: global___UnaryOperatorType.ValueType
    operand: builtins.str
    def __init__(
        self,
        *,
        operator: global___UnaryOperatorType.ValueType = ...,
        operand: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["operand", b"operand", "operator", b"operator"]) -> None: ...

global___UnaryCondition = UnaryCondition

class BinaryCondition(google.protobuf.message.Message):
    """Binary condition definition
    For example: unary_operator BinaryOperatorType.BINARY_OPERATOR_TYPE_RANGE_MATCH with first_operand 1,
                 and second operand 3 will check that header value will be in range of 1-3 included)
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATOR_FIELD_NUMBER: builtins.int
    FIRST_OPERAND_FIELD_NUMBER: builtins.int
    SECOND_OPERAND_FIELD_NUMBER: builtins.int
    operator: global___BinaryOperatorType.ValueType
    first_operand: builtins.str
    second_operand: builtins.str
    def __init__(
        self,
        *,
        operator: global___BinaryOperatorType.ValueType = ...,
        first_operand: builtins.str = ...,
        second_operand: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["first_operand", b"first_operand", "operator", b"operator", "second_operand", b"second_operand"]) -> None: ...

global___BinaryCondition = BinaryCondition

class Route(google.protobuf.message.Message):
    """Route configuration to apply on specific variation if all conditions evaluated to true."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VARIATION_NAME_FIELD_NUMBER: builtins.int
    WEIGHT_FIELD_NUMBER: builtins.int
    SHADOW_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    ENVIRONMENT_ID_FIELD_NUMBER: builtins.int
    AUDIENCE_ID_FIELD_NUMBER: builtins.int
    REQUEST_TIMEOUT_MS_FIELD_NUMBER: builtins.int
    variation_name: builtins.str
    """Deployment variation name"""
    weight: builtins.int
    """Weight of variation on splitting between other variations (Not percentage)"""
    shadow: builtins.bool
    """Shadow all traffic to this variation (All response from this variation will be ignored)"""
    model_id: builtins.str
    environment_id: builtins.str
    audience_id: builtins.str
    request_timeout_ms: builtins.int
    """Timeout of the request in ms"""
    def __init__(
        self,
        *,
        variation_name: builtins.str = ...,
        weight: builtins.int = ...,
        shadow: builtins.bool = ...,
        model_id: builtins.str = ...,
        environment_id: builtins.str = ...,
        audience_id: builtins.str = ...,
        request_timeout_ms: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["audience_id", b"audience_id", "environment_id", b"environment_id", "model_id", b"model_id", "request_timeout_ms", b"request_timeout_ms", "shadow", b"shadow", "variation_name", b"variation_name", "weight", b"weight"]) -> None: ...

global___Route = Route
