"""
This file contains sample run results responses from different DBT versions and invocations
"""

DBT_RPC_RESPONSE_SAMPLE = {
    "state": "success",
    "start": "2021-07-01T16:54:35.272871Z",
    "end": "2021-07-01T16:54:43.771222Z",
    "elapsed": 8.498351,
    "logs": [],
    "tags": None,
    "results": [
        {
            "status": "success",
            "timing": [
                {
                    "name": "compile",
                    "started_at": "2021-07-01T16:54:38.994465Z",
                    "completed_at": "2021-07-01T16:54:39.041429Z",
                },
                {
                    "name": "execute",
                    "started_at": "2021-07-01T16:54:39.041702Z",
                    "completed_at": "2021-07-01T16:54:40.145838Z",
                },
            ],
            "thread_id": "Thread-2",
            "execution_time": 1.152327060699463,
            "message": "OK",
            "adapter_response": {"code": "CREATE VIEW"},
            "node": {
                "raw_sql": "SELECT 1",
                "compiled": True,
                "database": "my_db",
                "schema": "my_schema",
                "fqn": ["my_schema", "table_1"],
                "unique_id": "model.my_schema.table_1",
                "package_name": "my_schema",
                "root_path": "",
                "path": "table_1.sql",
                "original_file_path": "models/table_1.sql",
                "name": "table_1",
                "resource_type": "model",
                "alias": "table_1",
                "checksum": {
                    "name": "sha256",
                    "checksum": "45afa8005125955c5c7c4a276395dbb5c212a46a2b4baff27871e8464731b95b",
                },
                "config": {
                    "enabled": True,
                    "materialized": "view",
                    "persist_docs": {},
                    "post-hook": [],
                    "pre-hook": [],
                    "vars": {},
                    "quoting": {},
                    "column_types": {},
                    "alias": None,
                    "schema": None,
                    "database": None,
                    "tags": [],
                    "full_refresh": None,
                },
                "tags": [],
                "refs": [],
                "sources": [],
                "depends_on": {
                    "macros": [
                        "macro.my_schema.aggregate_actions",
                        "macro.dbt.create_or_replace_view",
                        "macro.dbt.persist_docs",
                    ],
                    "nodes": [],
                },
                "description": "",
                "columns": {},
                "meta": {},
                "docs": {"show": True},
                "patch_path": "models/schema.yml",
                "build_path": "target/run/my_schema/models/table_1.sql",
                "deferred": False,
                "unrendered_config": {"materialized": "view"},
                "compiled_sql": "SELECT 1",
                "extra_ctes_injected": True,
                "extra_ctes": [],
                "relation_name": "`my_db`.`my_schema`.`table_1`",
            },
            "agate_table": None,
        },
        {
            "status": "success",
            "timing": [
                {
                    "name": "compile",
                    "started_at": "2021-07-01T16:54:38.988603Z",
                    "completed_at": "2021-07-01T16:54:39.029304Z",
                },
                {
                    "name": "execute",
                    "started_at": "2021-07-01T16:54:39.029574Z",
                    "completed_at": "2021-07-01T16:54:40.293289Z",
                },
            ],
            "thread_id": "Thread-1",
            "execution_time": 1.3059329986572266,
            "message": "OK",
            "adapter_response": {"code": "CREATE VIEW"},
            "node": {
                "raw_sql": "SELECT 1",
                "compiled": True,
                "database": "my_db",
                "schema": "my_schema",
                "fqn": ["my_schema", "table_2"],
                "unique_id": "model.my_schema.table_2",
                "package_name": "my_schema",
                "root_path": "/path",
                "path": "table_2.sql",
                "original_file_path": "models/table_2.sql",
                "name": "table_2",
                "resource_type": "model",
                "alias": "table_2",
                "checksum": {
                    "name": "sha256",
                    "checksum": "b93f2e03712ec1e65f837c8b8d7346e22be2b2c345f01f390280f91904d58c99",
                },
                "config": {
                    "enabled": True,
                    "materialized": "view",
                    "persist_docs": {},
                    "post-hook": [],
                    "pre-hook": [],
                    "vars": {},
                    "quoting": {},
                    "column_types": {},
                    "alias": None,
                    "schema": None,
                    "database": None,
                    "tags": [],
                    "full_refresh": None,
                },
                "tags": [],
                "refs": [],
                "sources": [],
                "depends_on": {
                    "macros": [
                        "macro.my_schema.aggregate_actions",
                        "macro.dbt.create_or_replace_view",
                        "macro.dbt.persist_docs",
                    ],
                    "nodes": [],
                },
                "description": "HackerNews comments",
                "columns": {},
                "meta": {},
                "docs": {"show": True},
                "patch_path": "models/schema.yml",
                "build_path": "target/run/my_schema/models/table_2.sql",
                "deferred": False,
                "unrendered_config": {"materialized": "view"},
                "compiled_sql": "SELECT 1",
                "extra_ctes_injected": True,
                "extra_ctes": [],
                "relation_name": "`my_db`.`my_schema`.`table_2`",
            },
            "agate_table": None,
        },
        {
            "status": "success",
            "timing": [
                {
                    "name": "compile",
                    "started_at": "2021-07-01T16:54:40.300764Z",
                    "completed_at": "2021-07-01T16:54:40.315514Z",
                },
                {
                    "name": "execute",
                    "started_at": "2021-07-01T16:54:40.315903Z",
                    "completed_at": "2021-07-01T16:54:43.423675Z",
                },
            ],
            "thread_id": "Thread-2",
            "execution_time": 3.124420642852783,
            "message": "CREATED 1 PARTITION",
            "adapter_response": {},
            "node": {
                "raw_sql": "SELECT 1",
                "compiled": True,
                "database": "my_db",
                "schema": "my_schema",
                "fqn": ["my_schema", "table_3"],
                "unique_id": "model.my_schema.table_3",
                "package_name": "my_schema",
                "root_path": "/path",
                "path": "table_3.sql",
                "original_file_path": "models/table_3.sql",
                "name": "table_3",
                "resource_type": "model",
                "alias": "table_3",
                "checksum": {
                    "name": "sha256",
                    "checksum": "82e41708b50b4cca018f91c2c0189de353fbf24db282aa13d9d04cf1eba378b5",
                },
                "config": {
                    "enabled": True,
                    "materialized": "table",
                    "persist_docs": {},
                    "post-hook": [],
                    "pre-hook": [],
                    "vars": {},
                    "quoting": {},
                    "column_types": {},
                    "alias": None,
                    "schema": None,
                    "database": None,
                    "tags": [],
                    "full_refresh": None,
                    "partitions": [20201230],
                },
                "tags": [],
                "refs": [["table_2"], ["table_1"]],
                "sources": [],
                "depends_on": {
                    "macros": [
                        "macro.dbt.run_hooks",
                        "macro.dbt_bigquery.make_date_partitioned_table",
                        "macro.dbt.persist_docs",
                    ],
                    "nodes": [
                        "model.my_schema.table_2",
                        "model.my_schema.table_1",
                    ],
                },
                "description": "HackerNews users with enriched data about activity",
                "columns": {},
                "meta": {},
                "docs": {"show": True},
                "patch_path": "models/schema.yml",
                "build_path": "target/compiled/my_schema/models/table_3.sql",
                "deferred": False,
                "unrendered_config": {"materialized": "table", "partitions": [20201230]},
                "compiled_sql": "\nSELECT * FROM `my_db`.`my_schema`.`table_2` FULL OUTER JOIN `my_db`.`my_schema`.`table_1` USING (`by`)",
                "extra_ctes_injected": True,
                "extra_ctes": [],
                "relation_name": "`my_db`.`my_schema`.`table_3`",
            },
            "agate_table": None,
        },
    ],
    "elapsed_time": 6.407902002334595,
    "args": {},
    "generated_at": "2021-07-01T16:54:43.526378Z",
}

DBT_18_RUN_RESULTS_SAMPLE = {
    "results": [
        {
            "node": {
                "raw_sql": "SELECT 1",
                "compiled": True,
                "database": "my_db",
                "schema": "my_schema",
                "fqn": ["my_schema", "table_1"],
                "unique_id": "model.my_schema.table_1",
                "package_name": "my_project",
                "root_path": "/some/path",
                "path": "table_1.sql",
                "original_file_path": "models/table_1.sql",
                "name": "table_1",
                "resource_type": "model",
                "alias": "table_1",
                "checksum": {
                    "name": "sha256",
                    "checksum": "45afa8005125955c5c7c4a276395dbb5c212a46a2b4baff27871e8464731b95b",
                },
                "config": {
                    "enabled": True,
                    "materialized": "view",
                    "persist_docs": {},
                    "post-hook": [],
                    "pre-hook": [],
                    "vars": {},
                    "quoting": {},
                    "column_types": {},
                    "alias": None,
                    "schema": None,
                    "database": None,
                    "tags": [],
                    "full_refresh": None,
                },
                "tags": [],
                "refs": [],
                "sources": [],
                "depends_on": {
                    "macros": [
                        "macro.my_project.my_macro",
                        "macro.dbt.create_or_replace_view",
                        "macro.dbt.persist_docs",
                    ],
                    "nodes": [],
                },
                "description": "",
                "columns": {},
                "meta": {},
                "docs": {"show": True},
                "patch_path": "models/schema.yml",
                "build_path": "target/run/path.sql",
                "deferred": False,
                "compiled_sql": "SELECT 1",
                "extra_ctes_injected": True,
                "extra_ctes": [],
                "injected_sql": "SELECT 1",
            },
            "error": None,
            "status": "CREATE VIEW",
            "execution_time": 2.213870048522949,
            "thread_id": "Thread-2",
            "timing": [
                {
                    "name": "compile",
                    "started_at": "2021-07-01T16:59:34.970262Z",
                    "completed_at": "2021-07-01T16:59:35.003768Z",
                },
                {
                    "name": "execute",
                    "started_at": "2021-07-01T16:59:35.004289Z",
                    "completed_at": "2021-07-01T16:59:37.182593Z",
                },
            ],
            "fail": None,
            "warn": None,
            "skip": False,
        },
        {
            "node": {
                "raw_sql": "SELECT 1",
                "compiled": True,
                "database": "my_db",
                "schema": "my_schema",
                "fqn": ["my_schema", "table_3"],
                "unique_id": "model.my_schema.table_3",
                "package_name": "my_schema",
                "root_path": "path",
                "path": "table_3.sql",
                "original_file_path": "models/table_3.sql",
                "name": "table_3",
                "resource_type": "model",
                "alias": "table_3",
                "checksum": {
                    "name": "sha256",
                    "checksum": "b93f2e03712ec1e65f837c8b8d7346e22be2b2c345f01f390280f91904d58c99",
                },
                "config": {
                    "enabled": True,
                    "materialized": "view",
                    "persist_docs": {},
                    "post-hook": [],
                    "pre-hook": [],
                    "vars": {},
                    "quoting": {},
                    "column_types": {},
                    "alias": None,
                    "schema": None,
                    "database": None,
                    "tags": [],
                    "full_refresh": None,
                },
                "tags": [],
                "refs": [],
                "sources": [],
                "depends_on": {
                    "macros": [
                        "macro.my_schema.aggregate_actions",
                        "macro.dbt.create_or_replace_view",
                        "macro.dbt.persist_docs",
                    ],
                    "nodes": [],
                },
                "description": "",
                "columns": {},
                "meta": {},
                "docs": {"show": True},
                "patch_path": "models/schema.yml",
                "build_path": "target/run/my_schema/models/table_3.sql",
                "deferred": False,
                "compiled_sql": "SELECT 1",
                "extra_ctes_injected": True,
                "extra_ctes": [],
                "injected_sql": "SELECT 1",
            },
            "error": None,
            "status": "CREATE VIEW",
            "execution_time": 2.2256979942321777,
            "thread_id": "Thread-1",
            "timing": [
                {
                    "name": "compile",
                    "started_at": "2021-07-01T16:59:34.970071Z",
                    "completed_at": "2021-07-01T16:59:35.010987Z",
                },
                {
                    "name": "execute",
                    "started_at": "2021-07-01T16:59:35.011277Z",
                    "completed_at": "2021-07-01T16:59:37.194171Z",
                },
            ],
            "fail": None,
            "warn": None,
            "skip": False,
        },
        {
            "node": {
                "raw_sql": "SELECT 1",
                "compiled": True,
                "database": "my_db",
                "schema": "my_schema",
                "fqn": ["my_schema", "table_2"],
                "unique_id": "model.my_schema.table_2",
                "package_name": "my_schema",
                "root_path": "path",
                "path": "table_2.sql",
                "original_file_path": "models/table_2.sql",
                "name": "table_2",
                "resource_type": "model",
                "alias": "table_2",
                "checksum": {
                    "name": "sha256",
                    "checksum": "82e41708b50b4cca018f91c2c0189de353fbf24db282aa13d9d04cf1eba378b5",
                },
                "config": {
                    "enabled": True,
                    "materialized": "table",
                    "persist_docs": {},
                    "post-hook": [],
                    "pre-hook": [],
                    "vars": {},
                    "quoting": {},
                    "column_types": {},
                    "alias": None,
                    "schema": None,
                    "database": None,
                    "tags": [],
                    "full_refresh": None,
                    "partitions": ["20210101"],
                },
                "tags": [],
                "refs": [["table_3"], ["table_1"]],
                "sources": [],
                "depends_on": {
                    "macros": [
                        "macro.dbt.run_hooks",
                        "macro.dbt_bigquery.make_date_partitioned_table",
                        "macro.dbt.persist_docs",
                    ],
                    "nodes": [
                        "model.my_schema.table_3",
                        "model.my_schema.table_1",
                    ],
                },
                "description": "",
                "columns": {},
                "meta": {},
                "docs": {"show": True},
                "patch_path": "models/schema.yml",
                "build_path": "target/compiled/my_schema/models/table_2.sql",
                "deferred": False,
                "compiled_sql": "SELECT 1",
                "extra_ctes_injected": True,
                "extra_ctes": [],
                "injected_sql": "SELECT 1",
            },
            "error": None,
            "status": "CREATED 1 PARTITION",
            "execution_time": 4.218987941741943,
            "thread_id": "Thread-2",
            "timing": [
                {
                    "name": "compile",
                    "started_at": "2021-07-01T16:59:37.199243Z",
                    "completed_at": "2021-07-01T16:59:37.209469Z",
                },
                {
                    "name": "execute",
                    "started_at": "2021-07-01T16:59:37.209705Z",
                    "completed_at": "2021-07-01T16:59:41.416506Z",
                },
            ],
            "fail": None,
            "warn": None,
            "skip": False,
        },
    ],
    "generated_at": "2021-07-01T16:59:41.461453Z",
    "elapsed_time": 9.838910341262817,
}


DBT_CLI_V1_RUN_RESULTS_SAMPLE = {
    "metadata": {
        "dbt_schema_version": "https://schemas.getdbt.com/dbt/run-results/v1.json",
        "dbt_version": "0.19.0",
        "generated_at": "2021-07-01T16:29:55.050085Z",
        "invocation_id": "608382e9-f075-4ed1-94ec-6d6747ee3539",
        "env": {},
    },
    "results": [
        {
            "status": "success",
            "timing": [
                {
                    "name": "compile",
                    "started_at": "2021-07-01T16:29:51.343743Z",
                    "completed_at": "2021-07-01T16:29:51.381224Z",
                },
                {
                    "name": "execute",
                    "started_at": "2021-07-01T16:29:51.381724Z",
                    "completed_at": "2021-07-01T16:29:52.450618Z",
                },
            ],
            "thread_id": "Thread-2",
            "execution_time": 1.1084280014038086,
            "message": "OK",
            "adapter_response": {"code": "CREATE VIEW"},
            "unique_id": "model.my_schema.table_1",
        },
        {
            "status": "success",
            "timing": [
                {
                    "name": "compile",
                    "started_at": "2021-07-01T16:29:51.343539Z",
                    "completed_at": "2021-07-01T16:29:51.382638Z",
                },
                {
                    "name": "execute",
                    "started_at": "2021-07-01T16:29:51.382925Z",
                    "completed_at": "2021-07-01T16:29:52.459771Z",
                },
            ],
            "thread_id": "Thread-1",
            "execution_time": 1.1179609298706055,
            "message": "OK",
            "adapter_response": {"code": "CREATE VIEW"},
            "unique_id": "model.my_schema.table_2",
        },
        {
            "status": "success",
            "timing": [
                {
                    "name": "compile",
                    "started_at": "2021-07-01T16:29:52.463808Z",
                    "completed_at": "2021-07-01T16:29:52.473312Z",
                },
                {
                    "name": "execute",
                    "started_at": "2021-07-01T16:29:52.473566Z",
                    "completed_at": "2021-07-01T16:29:55.013429Z",
                },
            ],
            "thread_id": "Thread-2",
            "execution_time": 2.551043748855591,
            "message": "CREATED 1 PARTITION",
            "adapter_response": {},
            "unique_id": "model.my_schema.table_3",
        },
    ],
    "elapsed_time": 6.90458607673645,
    "args": {
        "log_format": "default",
        "write_json": True,
        "profiles_dir": "/some/dir",
        "target": "prod",
        "vars": '{"var":"value", "other_var":"value"}',
        "use_cache": True,
        "version_check": True,
        "which": "run",
        "rpc_method": "run",
    },
}
