# generated by datamodel-codegen:
#   filename:  api/data/createMetric.json
#   timestamp: 2025-08-22T15:30:10+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.data import metric
from ...type import basic, entityReferenceList, tagLabel


class CreateMetricRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies this metric.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this metric.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the metric instance.'),
    ]
    metricExpression: Annotated[
        Optional[metric.MetricExpression],
        Field(None, description='Expression used to compute the metric.'),
    ]
    metricType: Annotated[
        Optional[metric.MetricType], Field(None, description='Type of the metric.')
    ]
    unitOfMeasurement: Annotated[
        Optional[metric.UnitOfMeasurement],
        Field(None, description='Unit of measurement for the metric.'),
    ]
    granularity: Annotated[
        Optional[metric.MetricGranularity],
        Field(None, description="Metric's granularity."),
    ]
    relatedMetrics: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='Other array of related metric fully qualified names that are related to this Metric.',
        ),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this metric'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this metric'),
    ]
    domains: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Fully qualified names of the domains the Metric belongs to.',
        ),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
