# generated by datamodel-codegen:
#   filename:  api/entityRelationship/esEntityRelationshipData.json
#   timestamp: 2025-08-22T15:30:10+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import relationshipRef


class Column(BaseModel):
    columnFQN: Annotated[
        Optional[str], Field(None, description='Column FQN in the entity.')
    ]
    relatedColumnFQN: Annotated[
        Optional[str],
        Field(None, description='Related column FQN in the related entity.'),
    ]
    relationshipType: Annotated[
        Optional[str], Field(None, description='Type of relationship between columns.')
    ]


class EsEntityRelationshipData(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    entity: Annotated[
        Optional[relationshipRef.RelationshipRef],
        Field(None, description='Entity in the relationship (upstream/source entity).'),
    ]
    relatedEntity: Annotated[
        Optional[relationshipRef.RelationshipRef],
        Field(
            None,
            description='Related Entity in the relationship (downstream/target entity).',
        ),
    ]
    columns: Annotated[
        Optional[List[Column]],
        Field(None, description='Columns associated with the relationship.'),
    ]
    description: Annotated[
        Optional[str], Field(None, description='Description of the relationship.')
    ]
    docId: Annotated[
        Optional[str], Field(None, description='Doc Id for the Entity Relationship.')
    ]
    relationshipType: Annotated[
        Optional[str], Field(None, description='Type of relationship.')
    ]
