# generated by datamodel-codegen:
#   filename:  api/mcp/mcpToolDefinition.json
#   timestamp: 2025-08-22T15:30:10+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class Type(Enum):
    string = 'string'
    number = 'number'
    integer = 'integer'
    boolean = 'boolean'
    array = 'array'
    object = 'object'


class ToolParameter(BaseModel):
    type: Annotated[Type, Field(description='Type of parameter')]
    description: Annotated[str, Field(description='Description of the parameter')]
    enum: Annotated[
        Optional[List],
        Field(None, description='Possible enum values for this parameter'),
    ]
    default: Annotated[
        Optional[Any], Field(None, description='Default value for this parameter')
    ]


class ToolParameters(BaseModel):
    type: Annotated[
        Optional[str], Field('object', description='Type of parameter schema')
    ]
    properties: Annotated[
        Dict[str, ToolParameter], Field(description='Parameter properties')
    ]
    required: Annotated[
        Optional[List[str]], Field(None, description='List of required parameters')
    ]


class McpToolDefinition(BaseModel):
    name: Annotated[str, Field(description='Name of the tool')]
    description: Annotated[str, Field(description='Description of what the tool does')]
    parameters: Annotated[
        ToolParameters, Field(description='Definition of tool parameters')
    ]
