# generated by datamodel-codegen:
#   filename:  entity/applications/configuration/external/automator/addTestCaseAction.json
#   timestamp: 2025-08-22T15:30:10+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ......tests import testCase
from ......type import basic, tagLabel


class AddTestCaseActionType(Enum):
    AddTestCaseAction = 'AddTestCaseAction'


class TestCaseDefinitions(BaseModel):
    testDefinition: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='Fully qualified name of the test definition.'),
    ]
    parameterValues: Optional[List[testCase.TestCaseParameterValue]] = None
    computePassedFailedRowCount: Annotated[
        Optional[bool],
        Field(
            False,
            description='Compute the passed and failed row count for the test case.',
        ),
    ]
    useDynamicAssertion: Annotated[
        Optional[bool],
        Field(
            False,
            description='If the test definition supports it, use dynamic assertion to evaluate the test case.',
        ),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]], Field([], description='Tags to apply')
    ]


class AddTestCaseAction(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        AddTestCaseActionType,
        Field(description='Application Type', title='Application Type'),
    ]
    testCases: Annotated[
        List[TestCaseDefinitions], Field(description='Test Cases to apply')
    ]
    applyToChildren: Annotated[
        Optional[List[basic.EntityName]],
        Field(
            None,
            description='Add tests to the selected table columns',
            title='Apply to Children',
        ),
    ]
    overwriteMetadata: Annotated[
        Optional[bool],
        Field(
            False,
            description='Update the test even if it is defined in the asset. By default, we will only apply the test to assets without the existing test already existing.',
            title='Overwrite Metadata',
        ),
    ]
