# generated by datamodel-codegen:
#   filename:  entity/applications/configuration/internal/searchIndexingAppConfig.json
#   timestamp: 2025-08-22T15:30:10+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....configuration import elasticSearchConfiguration


class SearchIndexingType(Enum):
    SearchIndexing = 'SearchIndexing'


class SearchIndexingApp(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[SearchIndexingType],
        Field(
            SearchIndexingType.SearchIndexing,
            description='Application Type',
            title='Application Type',
        ),
    ]
    entities: Annotated[
        Optional[List[str]], Field(['all'], description='List of Entities to Reindex')
    ]
    recreateIndex: Annotated[
        Optional[bool], Field(False, description='This schema publisher run modes.')
    ]
    batchSize: Annotated[
        Optional[int],
        Field(
            100, description='Maximum number of events sent in a batch (Default 100).'
        ),
    ]
    payLoadSize: Annotated[
        Optional[int],
        Field(
            104857600,
            description='Maximum number of events sent in a batch (Default 100).',
        ),
    ]
    producerThreads: Annotated[
        Optional[int],
        Field(
            10,
            description='Number of threads to use for reindexing',
            title='Number of Producer Threads',
        ),
    ]
    consumerThreads: Annotated[
        Optional[int],
        Field(
            10,
            description='Number of threads to use for reindexing',
            title='Number of Consumer Threads',
        ),
    ]
    maxConcurrentRequests: Annotated[
        Optional[int],
        Field(
            100,
            description='Maximum number of concurrent requests to the search index',
            title='Max Concurrent Requests',
        ),
    ]
    maxRetries: Annotated[
        Optional[int],
        Field(
            3,
            description='Maximum number of retries for a failed request',
            title='Max Retries',
        ),
    ]
    initialBackoff: Annotated[
        Optional[int],
        Field(
            1000,
            description='Initial backoff time in milliseconds',
            title='Initial Backoff Millis',
        ),
    ]
    maxBackoff: Annotated[
        Optional[int],
        Field(
            10000,
            description='Maximum backoff time in milliseconds',
            title='Max Backoff Millis',
        ),
    ]
    queueSize: Annotated[
        Optional[int],
        Field(
            100,
            description='Queue Size to user internally for reindexing.',
            title='Queue Size to use.',
        ),
    ]
    searchIndexMappingLanguage: Annotated[
        Optional[elasticSearchConfiguration.SearchIndexMappingLanguage],
        Field(
            elasticSearchConfiguration.SearchIndexMappingLanguage.EN,
            description='Recreate Indexes with updated Language',
        ),
    ]
    autoTune: Annotated[
        Optional[bool],
        Field(
            False,
            description='Enable automatic performance tuning based on cluster capabilities and database entity count',
            title='Auto Tune',
        ),
    ]
