# generated by datamodel-codegen:
#   filename:  entity/applications/createAppRequest.json
#   timestamp: 2025-08-22T15:30:10+00:00

from __future__ import annotations

from typing import Any, List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityReferenceList
from . import app


class CreateAppRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        Optional[basic.EntityName], Field(None, description='Name of the Application.')
    ]
    displayName: Annotated[
        Optional[str], Field(None, description='Display Name for the application.')
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the Application.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this workflow.'),
    ]
    bot: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='Fqn of Bot Associated with this application.'),
    ]
    appConfiguration: Annotated[
        Optional[Any], Field(None, description='Application Configuration object.')
    ]
    appSchedule: Optional[app.AppSchedule] = None
    domains: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Fully qualified names of the domains the Application belongs to.',
        ),
    ]
    supportsInterrupt: Annotated[
        Optional[bool],
        Field(
            False,
            description='If the app run can be interrupted as part of the execution.',
        ),
    ]
