# generated by datamodel-codegen:
#   filename:  entity/bot.json
#   timestamp: 2025-08-22T15:30:10+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import basic, entityHistory, entityReference, entityReferenceList


class Bot(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[basic.Uuid, Field(description='Unique identifier of a bot instance.')]
    name: Annotated[basic.EntityName, Field(description='Name of the bot.')]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description="Name used for display purposes. Example 'FirstName LastName'.",
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown], Field(None, description='Description of the bot.')
    ]
    botUser: Annotated[
        entityReference.EntityReference,
        Field(
            description='Bot user created for this bot on behalf of which the bot performs all the operations, such as updating description, responding on the conversation threads, etc.'
        ),
    ]
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this bot.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Domains the asset belongs to. When not set, the asset inherits the domain from the parent it belongs to.',
        ),
    ]
