# generated by datamodel-codegen:
#   filename:  entity/data/glossary.json
#   timestamp: 2025-08-22T15:30:10+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import (
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    tagLabel,
    votes,
)


class Glossary(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid, Field(description='Unique identifier of a glossary instance.')
    ]
    name: Annotated[basic.EntityName, Field(description='Name of the glossary')]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as name.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this glossary.'),
    ]
    description: Annotated[
        basic.Markdown, Field(description='Description of the glossary.')
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    reviewers: Annotated[
        Optional[List[entityReference.EntityReference]],
        Field(None, description='User references of the reviewers for this glossary.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this glossary.'),
    ]
    usageCount: Annotated[
        Optional[int],
        Field(
            None,
            description='Count of how many times terms from this glossary are used.',
        ),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field([], description='Tags for this glossary.'),
    ]
    termCount: Annotated[
        Optional[int],
        Field(
            None,
            description='Total number of terms in the glossary. This includes all the children in the hierarchy.',
            ge=0,
        ),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    disabled: Annotated[
        Optional[bool],
        Field(
            None,
            description="System glossary can't be deleted. Use this flag to disable them.",
        ),
    ]
    mutuallyExclusive: Annotated[
        Optional[bool],
        Field(
            'false',
            description='Glossary terms that are direct children in this glossary are mutually exclusive. When mutually exclusive is `true` only one term can be used to label an entity. When mutually exclusive is `false`, multiple terms from this group can be used to label an entity.',
        ),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Domains the Glossary belongs to.'),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    votes: Annotated[
        Optional[votes.Votes], Field(None, description='Votes on the entity.')
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
