# generated by datamodel-codegen:
#   filename:  entity/data/queryCostRecord.json
#   timestamp: 2025-08-22T15:30:10+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityReference


class QueryCostRecord(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        Optional[basic.Uuid],
        Field(None, description='Unique identifier of this failure instance'),
    ]
    timestamp: Annotated[
        basic.Timestamp,
        Field(description='Timestamp on which the failure was created.'),
    ]
    jsonSchema: Annotated[
        Optional[str], Field(None, description='Json schema of the query')
    ]
    queryReference: Annotated[
        entityReference.EntityReference, Field(description='Query entity reference')
    ]
    cost: Annotated[float, Field(description='Avg query cost per execution')]
    updatedBy: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='User who updated the query cost record.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(None, description='Time when query cost record was updated.'),
    ]
    count: Annotated[float, Field(description='Number of times the query was executed')]
    totalDuration: Annotated[
        Optional[float], Field(0, description='Total duration of the query')
    ]
