# generated by datamodel-codegen:
#   filename:  entity/feed/suggestion.json
#   timestamp: 2025-08-22T15:30:10+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityReference, tagLabel


class SuggestionType(Enum):
    SuggestDescription = 'SuggestDescription'
    SuggestTagLabel = 'SuggestTagLabel'


class SuggestionStatus(Enum):
    Open = 'Open'
    Accepted = 'Accepted'
    Rejected = 'Rejected'


class Suggestion1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid,
        Field(description='Unique identifier that identifies an entity instance.'),
    ]
    type: Optional[SuggestionType] = None
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    entityLink: Annotated[
        basic.EntityLink,
        Field(
            description='Data asset about which this thread is created for with format <#E::{entities}::{entityName}::{field}::{fieldValue}.'
        ),
    ]
    createdAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    createdBy: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='User or Bot who made the suggestion.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the update version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str],
        Field(None, description='User or Bot who updated the suggestion.'),
    ]
    status: Optional[SuggestionStatus] = SuggestionStatus.Open
    description: Annotated[
        str, Field(description='The main message of the thread in Markdown format.')
    ]
    tagLabels: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags or Glossary Terms.'),
    ]


class Suggestion2(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid,
        Field(description='Unique identifier that identifies an entity instance.'),
    ]
    type: Optional[SuggestionType] = None
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    entityLink: Annotated[
        basic.EntityLink,
        Field(
            description='Data asset about which this thread is created for with format <#E::{entities}::{entityName}::{field}::{fieldValue}.'
        ),
    ]
    createdAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    createdBy: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='User or Bot who made the suggestion.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the update version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str],
        Field(None, description='User or Bot who updated the suggestion.'),
    ]
    status: Optional[SuggestionStatus] = SuggestionStatus.Open
    description: Annotated[
        Optional[str],
        Field(None, description='The main message of the thread in Markdown format.'),
    ]
    tagLabels: Annotated[
        List[tagLabel.TagLabel], Field(description='Tags or Glossary Terms.')
    ]


class Suggestion(RootModel[Union[Suggestion1, Suggestion2]]):
    root: Annotated[
        Union[Suggestion1, Suggestion2],
        Field(
            description='This schema defines the Suggestion entity. A suggestion can be applied to an asset to give the owner context about possible changes or improvements to descriptions, tags,...',
            title='Suggestion',
        ),
    ]
