# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/tableauConnection.json
#   timestamp: 2025-08-22T15:30:10+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.credentials import accessTokenAuth, basicAuth
from .....security.ssl import verifySSLConfig
from .....type import filterPattern
from .. import connectionBasicType


class TableauType(Enum):
    Tableau = 'Tableau'


class TableauConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[TableauType],
        Field(TableauType.Tableau, description='Service Type', title='Service Type'),
    ]
    hostPort: Annotated[
        AnyUrl, Field(description='Tableau Server url.', title='Host and Port')
    ]
    authType: Annotated[
        Optional[Union[basicAuth.BasicAuth, accessTokenAuth.AccessTokenAuth]],
        Field(
            None,
            description='Types of methods used to authenticate to the tableau instance',
            title='Authentication type for Tableau',
        ),
    ]
    siteName: Annotated[
        Optional[str], Field(None, description='Tableau Site Name.', title='Site Name')
    ]
    paginationLimit: Annotated[
        Optional[int],
        Field(
            10,
            description='Pagination limit used while querying the tableau metadata API for getting data sources',
            title='Pagination Limit',
        ),
    ]
    apiVersion: Annotated[
        Optional[str],
        Field(
            None,
            description='Tableau API version. If not provided, the version will be used from the tableau server.',
            title='API Version',
        ),
    ]
    proxyURL: Annotated[
        Optional[AnyUrl],
        Field(
            None,
            description='Proxy URL for the tableau server. If not provided, the hostPort will be used. This is used to generate the dashboard & Chart URL.',
            title='Proxy URL',
        ),
    ]
    verifySSL: Optional[verifySSLConfig.VerifySSL] = verifySSLConfig.VerifySSL.no_ssl
    sslConfig: Optional[verifySSLConfig.SslConfig] = None
    dashboardFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include dashboards that matches the pattern.',
            title='Default Dashboard Filter Pattern',
        ),
    ]
    chartFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include charts that matches the pattern.',
            title='Default Chart Filter Pattern',
        ),
    ]
    dataModelFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include data models that matches the pattern.',
            title='Default Data Model Filter Pattern',
        ),
    ]
    projectFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include projects that matches the pattern.',
            title='Default Project Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
