# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/thoughtSpotConnection.json
#   timestamp: 2025-08-22T15:30:10+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.credentials import apiAccessTokenAuth, basicAuth
from .. import connectionBasicType


class ApiVersion(Enum):
    v1 = 'v1'
    v2 = 'v2'


class ThoughtSpotType(Enum):
    ThoughtSpot = 'ThoughtSpot'


class ThoughtSpotConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[ThoughtSpotType],
        Field(
            ThoughtSpotType.ThoughtSpot,
            description='Service Type',
            title='Service Type',
        ),
    ]
    hostPort: Annotated[
        AnyUrl,
        Field(
            description='ThoughtSpot instance URL. Example: https://my-company.thoughtspot.cloud',
            title='Host and Port',
        ),
    ]
    authentication: Annotated[
        Union[basicAuth.BasicAuth, apiAccessTokenAuth.ApiAccessTokenAuth],
        Field(
            description='ThoughtSpot authentication configuration',
            title='Authentication',
        ),
    ]
    apiVersion: Annotated[
        Optional[ApiVersion],
        Field(
            ApiVersion.v2,
            description='ThoughtSpot API version to use',
            title='API Version',
        ),
    ]
    orgId: Annotated[
        Optional[str],
        Field(
            None,
            description='Org ID for multi-tenant ThoughtSpot instances. This is applicable for ThoughtSpot Cloud only.',
            title='Organization ID',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(
            None,
            description='Supports Metadata Extraction.',
            title='Supports Metadata Extraction',
        ),
    ]
