# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/cassandraConnection.json
#   timestamp: 2025-08-22T15:30:10+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.ssl import verifySSLConfig
from .....type import filterPattern
from .. import connectionBasicType
from .cassandra import cloudConfig
from .common import basicAuth


class CassandraType(Enum):
    Cassandra = 'Cassandra'


class CassandraConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[CassandraType],
        Field(
            CassandraType.Cassandra, description='Service Type', title='Service Type'
        ),
    ]
    username: Annotated[
        Optional[str],
        Field(
            None,
            description='Username to connect to Cassandra. This user should have privileges to read all the metadata in Cassandra.',
            title='Username',
        ),
    ]
    authType: Annotated[
        Optional[Union[basicAuth.BasicAuth, cloudConfig.CloudConfig]],
        Field(
            None,
            description='Choose Auth Config Type.',
            title='Auth Configuration Type',
        ),
    ]
    hostPort: Annotated[
        Optional[str],
        Field(
            None,
            description='Host and port of the Cassandra service when using the `cassandra` connection scheme. Only host when using the `cassandra+srv` scheme.',
            title='Host and Port',
        ),
    ]
    databaseName: Annotated[
        Optional[str],
        Field(
            None,
            description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
            title='Database Name',
        ),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    sslMode: Annotated[
        Optional[verifySSLConfig.SslMode],
        Field(verifySSLConfig.SslMode.disable, title='SSL Mode'),
    ]
    sslConfig: Annotated[
        Optional[verifySSLConfig.SslConfig], Field(None, title='SSL Configuration')
    ]
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude schemas that matches the pattern.',
            title='Default Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude tables that matches the pattern.',
            title='Default Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude databases that matches the pattern.',
            title='Default Database Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
