# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/cockroachConnection.json
#   timestamp: 2025-08-22T15:30:10+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.ssl import verifySSLConfig
from .....type import filterPattern
from .. import connectionBasicType
from .common import basicAuth


class CockroachType(Enum):
    Cockroach = 'Cockroach'


class CockroachScheme(Enum):
    cockroachdb_psycopg2 = 'cockroachdb+psycopg2'


class CockroachConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[CockroachType],
        Field(
            CockroachType.Cockroach, description='Service Type', title='Service Type'
        ),
    ]
    scheme: Annotated[
        Optional[CockroachScheme],
        Field(
            CockroachScheme.cockroachdb_psycopg2,
            description='SQLAlchemy driver scheme options.',
            title='Connection Scheme',
        ),
    ]
    username: Annotated[
        str,
        Field(
            description='Username to connect to Cockroach. This user should have privileges to read all the metadata in Cockroach.',
            title='Username',
        ),
    ]
    authType: Annotated[
        Optional[basicAuth.BasicAuth],
        Field(
            None,
            description='Choose Auth Config Type.',
            title='Auth Configuration Type',
        ),
    ]
    hostPort: Annotated[
        str,
        Field(
            description='Host and port of the Cockrooach service.',
            title='Host and Port',
        ),
    ]
    database: Annotated[
        str,
        Field(
            description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
            title='Database Name',
        ),
    ]
    ingestAllDatabases: Annotated[
        Optional[bool],
        Field(
            False,
            description='Ingest data from all databases in Postgres. You can use databaseFilterPattern on top of this.',
            title='Ingest All Databases',
        ),
    ]
    databaseSchema: Annotated[
        Optional[str],
        Field(
            None,
            description='Database Schema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single schema. When left blank, OpenMetadata Ingestion attempts to scan all the schemas.',
            title='Database Schema',
        ),
    ]
    sslConfig: Annotated[
        Optional[verifySSLConfig.SslConfig],
        Field(None, description='SSL Configuration details.', title='SSL'),
    ]
    sslMode: Optional[verifySSLConfig.SslMode] = verifySSLConfig.SslMode.disable
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude schemas that matches the pattern.',
            title='Default Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude tables that matches the pattern.',
            title='Default Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude databases that matches the pattern.',
            title='Default Database Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsProfiler: Annotated[
        Optional[connectionBasicType.SupportsProfiler],
        Field(None, title='Supports Profiler'),
    ]
