# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/databricksConnection.json
#   timestamp: 2025-08-22T15:30:10+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class DatabricksType(Enum):
    Databricks = 'Databricks'


class DatabricksScheme(Enum):
    databricks_connector = 'databricks+connector'


class DatabricksConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[DatabricksType],
        Field(
            DatabricksType.Databricks, description='Service Type', title='Service Type'
        ),
    ]
    scheme: Annotated[
        Optional[DatabricksScheme],
        Field(
            DatabricksScheme.databricks_connector,
            description='SQLAlchemy driver scheme options.',
            title='Connection Scheme',
        ),
    ]
    hostPort: Annotated[
        str,
        Field(
            description='Host and port of the Databricks service.',
            title='Host and Port',
        ),
    ]
    token: Annotated[
        CustomSecretStr,
        Field(description='Generated Token to connect to Databricks.', title='Token'),
    ]
    httpPath: Annotated[
        str, Field(description='Databricks compute resources URL.', title='Http Path')
    ]
    catalog: Annotated[
        Optional[str],
        Field(
            None,
            description='Catalog of the data source(Example: hive_metastore). This is optional parameter, if you would like to restrict the metadata reading to a single catalog. When left blank, OpenMetadata Ingestion attempts to scan all the catalog.',
            title='Catalog',
        ),
    ]
    databaseSchema: Annotated[
        Optional[str],
        Field(
            None,
            description='Database Schema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single schema. When left blank, OpenMetadata Ingestion attempts to scan all the schemas.',
            title='Database Schema',
        ),
    ]
    connectionTimeout: Annotated[
        Optional[int],
        Field(
            120,
            description='The maximum amount of time (in seconds) to wait for a successful connection to the data source. If the connection attempt takes longer than this timeout period, an error will be returned.',
            title='Connection Timeout',
        ),
    ]
    queryHistoryTable: Annotated[
        Optional[str],
        Field(
            'system.query.history',
            description='Table name to fetch the query history.',
            title='Query History Table',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            {'includes': [], 'excludes': ['^information_schema$']},
            description='Regex to only include/exclude schemas that matches the pattern.',
            title='Default Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude tables that matches the pattern.',
            title='Default Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            {'includes': [], 'excludes': ['^system$']},
            description='Regex to only include/exclude databases that matches the pattern.',
            title='Default Database Filter Pattern',
        ),
    ]
    supportsUsageExtraction: Optional[
        connectionBasicType.SupportsUsageExtraction
    ] = None
    supportsLineageExtraction: Optional[
        connectionBasicType.SupportsLineageExtraction
    ] = None
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsProfiler: Annotated[
        Optional[connectionBasicType.SupportsProfiler],
        Field(None, title='Supports Profiler'),
    ]
    supportsDatabase: Annotated[
        Optional[connectionBasicType.SupportsDatabase],
        Field(None, title='Supports Database'),
    ]
    supportsQueryComment: Annotated[
        Optional[connectionBasicType.SupportsQueryComment],
        Field(None, title='Supports Query Comment'),
    ]
    sampleDataStorageConfig: Annotated[
        Optional[connectionBasicType.SampleDataStorageConfig],
        Field(None, title='Storage Config for Sample Data'),
    ]
