# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/airflowConnection.json
#   timestamp: 2025-08-22T15:30:10+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....type import filterPattern
from .. import connectionBasicType
from ..database import mysqlConnection, postgresConnection, sqliteConnection
from . import backendConnection


class AirflowType(Enum):
    Airflow = 'Airflow'


class AirflowConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[AirflowType],
        Field(AirflowType.Airflow, description='Service Type', title='Service Type'),
    ]
    hostPort: Annotated[
        AnyUrl,
        Field(description='Pipeline Service Management/UI URI.', title='Host And Port'),
    ]
    numberOfStatus: Annotated[
        Optional[int], Field('10', description='Pipeline Service Number Of Status')
    ]
    connection: Annotated[
        Union[
            backendConnection.BackendConnection,
            mysqlConnection.MysqlConnection,
            postgresConnection.PostgresConnection,
            sqliteConnection.SQLiteConnection,
        ],
        Field(
            description='Underlying database connection. See https://airflow.apache.org/docs/apache-airflow/stable/howto/set-up-database.html for supported backends.',
            title='Metadata Database Connection',
        ),
    ]
    pipelineFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude pipelines.',
            title='Default Pipeline Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
