# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/fivetranConnection.json
#   timestamp: 2025-08-22T15:30:10+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class FivetranType(Enum):
    Fivetran = 'Fivetran'


class FivetranConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[FivetranType],
        Field(FivetranType.Fivetran, description='Service Type', title='Service Type'),
    ]
    apiKey: Annotated[
        str, Field(description='Fivetran API Secret.', title='Fivetran API Key')
    ]
    hostPort: Annotated[
        Optional[AnyUrl],
        Field(
            'https://api.fivetran.com',
            description='Pipeline Service Management/UI URI.',
            title='Host And Port',
        ),
    ]
    apiSecret: Annotated[
        CustomSecretStr,
        Field(description='Fivetran API Secret.', title='Fivetran API Secret'),
    ]
    limit: Annotated[
        Optional[int],
        Field(
            1000,
            description='Fivetran API Limit For Pagination.',
            title='Fivetran API Limit',
        ),
    ]
    pipelineFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude pipelines.',
            title='Default Pipeline Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
