# generated by datamodel-codegen:
#   filename:  metadataIngestion/dbtconfig/dbtHttpConfig.json
#   timestamp: 2025-08-22T15:30:10+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class DbtConfigType(Enum):
    http = 'http'


class DbtHttpConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    dbtConfigType: Annotated[DbtConfigType, Field(description='dbt Configuration type')]
    dbtCatalogHttpPath: Annotated[
        Optional[str],
        Field(
            None,
            description='DBT catalog http file path to extract dbt models with their column schemas.',
            title='DBT Catalog HTTP File Path',
        ),
    ]
    dbtManifestHttpPath: Annotated[
        str,
        Field(
            description='DBT manifest http file path to extract dbt models and associate with tables.',
            title='DBT Manifest HTTP File Path',
        ),
    ]
    dbtRunResultsHttpPath: Annotated[
        Optional[str],
        Field(
            None,
            description='DBT run results http file path to extract the test results information.',
            title='DBT Run Results HTTP File Path',
        ),
    ]
    dbtSourcesHttpPath: Annotated[
        Optional[str],
        Field(
            None,
            description='DBT sources http file path to extract freshness test results information.',
            title='DBT Sources HTTP File Path',
        ),
    ]
