import { AwsCdkDeps, AwsCdkDepsCommonOptions, CdkConfig, CdkConfigCommonOptions, CdkTasks } from ".";
import { PythonProject, PythonProjectOptions } from "../python/python-project";
/**
 * Options for `AwsCdkPythonApp`
 */
export interface AwsCdkPythonAppOptions extends PythonProjectOptions, CdkConfigCommonOptions, AwsCdkDepsCommonOptions {
    /**
     * The CDK app's entrypoint (relative to the source directory, which is
     * "src" by default).
     *
     * @default "app.py"
     */
    readonly appEntrypoint?: string;
    /**
     * Python sources directory.
     *
     * @default "tests"
     * @deprecated Use `sampleTestdir` instead.
     */
    readonly testdir?: string;
}
/**
 * AWS CDK app in Python
 *
 * @pjid awscdk-app-py
 */
export declare class AwsCdkPythonApp extends PythonProject {
    /**
     * Common CDK tasks.
     */
    readonly cdkTasks: CdkTasks;
    /**
     * cdk.json configuration.
     */
    readonly cdkConfig: CdkConfig;
    readonly cdkDeps: AwsCdkDeps;
    /**
     * The CDK app entrypoint
     */
    readonly appEntrypoint: string;
    /**
     * The directory in which the python tests reside.
     * @deprecated Use `sampleTestdir` instead.
     */
    readonly testdir: string;
    /**
     * The directory in which the python sample tests reside.
     */
    readonly sampleTestdir: string;
    /**
     * The CDK version this app is using.
     */
    get cdkVersion(): string;
    constructor(options: AwsCdkPythonAppOptions);
}
