"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructLibraryAws = exports.AwsCdkConstructLibrary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const semver = require("semver");
const auto_discover_1 = require("./auto-discover");
const awscdk_deps_js_1 = require("./awscdk-deps-js");
const integ_runner_1 = require("./integ-runner");
const cdk_1 = require("../cdk");
const dependencies_1 = require("../dependencies");
/**
 * AWS CDK construct library project
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the AWS CDK with a friendly workflow and automatic publishing to
 * the construct catalog.
 *
 * @pjid awscdk-construct
 */
class AwsCdkConstructLibrary extends cdk_1.ConstructLibrary {
    constructor(options) {
        const cdkMajorVersion = semver.parse(options.cdkVersion)?.major;
        super({
            peerDependencyOptions: cdkMajorVersion === 1
                ? {
                    pinnedDevDependency: false,
                }
                : undefined,
            workflowNodeVersion: options.minNodeVersion ?? "lts/*",
            ...options,
        });
        this.cdkDeps = new awscdk_deps_js_1.AwsCdkDepsJs(this, {
            // since this we are a library, dependencies should be added a peers
            dependencyType: dependencies_1.DependencyType.PEER,
            ...options,
        });
        new auto_discover_1.AutoDiscover(this, {
            srcdir: this.srcdir,
            testdir: this.testdir,
            lambdaOptions: options.lambdaOptions,
            tsconfigPath: this.tsconfigDev.fileName,
            cdkDeps: this.cdkDeps,
            lambdaAutoDiscover: options.lambdaAutoDiscover ?? true,
            edgeLambdaAutoDiscover: options.edgeLambdaAutoDiscover ?? true,
            lambdaExtensionAutoDiscover: options.lambdaExtensionAutoDiscover ?? true,
            integrationTestAutoDiscover: options.integrationTestAutoDiscover ?? true,
        });
        if (options.experimentalIntegRunner) {
            new integ_runner_1.IntegRunner(this);
        }
    }
    /**
     * The target CDK version for this library.
     */
    get cdkVersion() {
        return this.cdkDeps.cdkVersion;
    }
    /**
     * @deprecated use `cdkVersion`
     */
    get version() {
        return this.cdkVersion;
    }
    /**
     * Adds dependencies to AWS CDK modules.
     *
     * Since this is a library project, dependencies will be added as peer dependencies.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @deprecated Not supported in v2. For v1, use `project.cdkDeps.addV1Dependencies()`
     */
    addCdkDependencies(...deps) {
        return this.cdkDeps.addV1Dependencies(...deps);
    }
    /**
     * Adds AWS CDK modules as dev dependencies.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @deprecated Not supported in v2. For v1, use `project.cdkDeps.addV1DevDependencies()`
     */
    addCdkTestDependencies(...deps) {
        return this.cdkDeps.addV1DevDependencies(...deps);
    }
}
exports.AwsCdkConstructLibrary = AwsCdkConstructLibrary;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkConstructLibrary[_a] = { fqn: "projen.awscdk.AwsCdkConstructLibrary", version: "0.96.2" };
/** @deprecated use `AwsCdkConstructLibrary` */
class ConstructLibraryAws extends AwsCdkConstructLibrary {
}
exports.ConstructLibraryAws = ConstructLibraryAws;
_b = JSII_RTTI_SYMBOL_1;
ConstructLibraryAws[_b] = { fqn: "projen.awscdk.ConstructLibraryAws", version: "0.96.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzY2RrLWNvbnN0cnVjdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9hd3NjZGsvYXdzY2RrLWNvbnN0cnVjdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLGlDQUFpQztBQUNqQyxtREFBK0M7QUFFL0MscURBQWdEO0FBQ2hELGlEQUE2QztBQUU3QyxnQ0FBbUU7QUFDbkUsa0RBQWlEO0FBNERqRDs7Ozs7Ozs7R0FRRztBQUNILE1BQWEsc0JBQXVCLFNBQVEsc0JBQWdCO0lBRzFELFlBQVksT0FBc0M7UUFDaEQsTUFBTSxlQUFlLEdBQUcsTUFBTSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLEVBQUUsS0FBSyxDQUFDO1FBRWhFLEtBQUssQ0FBQztZQUNKLHFCQUFxQixFQUNuQixlQUFlLEtBQUssQ0FBQztnQkFDbkIsQ0FBQyxDQUFDO29CQUNFLG1CQUFtQixFQUFFLEtBQUs7aUJBQzNCO2dCQUNILENBQUMsQ0FBQyxTQUFTO1lBQ2YsbUJBQW1CLEVBQUUsT0FBTyxDQUFDLGNBQWMsSUFBSSxPQUFPO1lBQ3RELEdBQUcsT0FBTztTQUNYLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSw2QkFBWSxDQUFDLElBQUksRUFBRTtZQUNwQyxvRUFBb0U7WUFDcEUsY0FBYyxFQUFFLDZCQUFjLENBQUMsSUFBSTtZQUNuQyxHQUFHLE9BQU87U0FDWCxDQUFDLENBQUM7UUFFSCxJQUFJLDRCQUFZLENBQUMsSUFBSSxFQUFFO1lBQ3JCLE1BQU0sRUFBRSxJQUFJLENBQUMsTUFBTTtZQUNuQixPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87WUFDckIsYUFBYSxFQUFFLE9BQU8sQ0FBQyxhQUFhO1lBQ3BDLFlBQVksRUFBRSxJQUFJLENBQUMsV0FBVyxDQUFDLFFBQVE7WUFDdkMsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO1lBQ3JCLGtCQUFrQixFQUFFLE9BQU8sQ0FBQyxrQkFBa0IsSUFBSSxJQUFJO1lBQ3RELHNCQUFzQixFQUFFLE9BQU8sQ0FBQyxzQkFBc0IsSUFBSSxJQUFJO1lBQzlELDJCQUEyQixFQUFFLE9BQU8sQ0FBQywyQkFBMkIsSUFBSSxJQUFJO1lBQ3hFLDJCQUEyQixFQUFFLE9BQU8sQ0FBQywyQkFBMkIsSUFBSSxJQUFJO1NBQ3pFLENBQUMsQ0FBQztRQUVILElBQUksT0FBTyxDQUFDLHVCQUF1QixFQUFFLENBQUM7WUFDcEMsSUFBSSwwQkFBVyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ3hCLENBQUM7SUFDSCxDQUFDO0lBRUQ7O09BRUc7SUFDSCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQztJQUNqQyxDQUFDO0lBRUQ7O09BRUc7SUFDSCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDO0lBQ3pCLENBQUM7SUFFRDs7Ozs7OztPQU9HO0lBQ0ksa0JBQWtCLENBQUMsR0FBRyxJQUFjO1FBQ3pDLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxHQUFHLElBQUksQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFFRDs7Ozs7T0FLRztJQUNJLHNCQUFzQixDQUFDLEdBQUcsSUFBYztRQUM3QyxPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsb0JBQW9CLENBQUMsR0FBRyxJQUFJLENBQUMsQ0FBQztJQUNwRCxDQUFDOztBQTFFSCx3REEyRUM7OztBQU1ELCtDQUErQztBQUMvQyxNQUFhLG1CQUFvQixTQUFRLHNCQUFzQjs7QUFBL0Qsa0RBQWtFIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgc2VtdmVyIGZyb20gXCJzZW12ZXJcIjtcbmltcG9ydCB7IEF1dG9EaXNjb3ZlciB9IGZyb20gXCIuL2F1dG8tZGlzY292ZXJcIjtcbmltcG9ydCB7IEF3c0Nka0RlcHMsIEF3c0Nka0RlcHNDb21tb25PcHRpb25zIH0gZnJvbSBcIi4vYXdzY2RrLWRlcHNcIjtcbmltcG9ydCB7IEF3c0Nka0RlcHNKcyB9IGZyb20gXCIuL2F3c2Nkay1kZXBzLWpzXCI7XG5pbXBvcnQgeyBJbnRlZ1J1bm5lciB9IGZyb20gXCIuL2ludGVnLXJ1bm5lclwiO1xuaW1wb3J0IHsgTGFtYmRhRnVuY3Rpb25Db21tb25PcHRpb25zIH0gZnJvbSBcIi4vbGFtYmRhLWZ1bmN0aW9uXCI7XG5pbXBvcnQgeyBDb25zdHJ1Y3RMaWJyYXJ5LCBDb25zdHJ1Y3RMaWJyYXJ5T3B0aW9ucyB9IGZyb20gXCIuLi9jZGtcIjtcbmltcG9ydCB7IERlcGVuZGVuY3lUeXBlIH0gZnJvbSBcIi4uL2RlcGVuZGVuY2llc1wiO1xuXG4vKipcbiAqIE9wdGlvbnMgZm9yIGBBd3NDZGtDb25zdHJ1Y3RMaWJyYXJ5YC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBBd3NDZGtDb25zdHJ1Y3RMaWJyYXJ5T3B0aW9uc1xuICBleHRlbmRzIENvbnN0cnVjdExpYnJhcnlPcHRpb25zLFxuICAgIEF3c0Nka0RlcHNDb21tb25PcHRpb25zIHtcbiAgLyoqXG4gICAqIEF1dG9tYXRpY2FsbHkgYWRkcyBhbiBgYXdzX2xhbWJkYS5GdW5jdGlvbmAgZm9yIGVhY2ggYC5sYW1iZGEudHNgIGhhbmRsZXJcbiAgICogaW4geW91ciBzb3VyY2UgdHJlZS4gSWYgdGhpcyBpcyBkaXNhYmxlZCwgeW91IGVpdGhlciBuZWVkIHRvIGV4cGxpY2l0bHlcbiAgICogY2FsbCBgYXdzX2xhbWJkYS5GdW5jdGlvbi5hdXRvRGlzY292ZXIoKWAgb3IgZGVmaW5lIGEgYG5ld1xuICAgKiBhd3NfbGFtYmRhLkZ1bmN0aW9uKClgIGZvciBlYWNoIGhhbmRsZXIuXG4gICAqXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IGxhbWJkYUF1dG9EaXNjb3Zlcj86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIEF1dG9tYXRpY2FsbHkgYWRkcyBhbiBgY2xvdWRmcm9udC5leHBlcmltZW50YWwuRWRnZUZ1bmN0aW9uYCBmb3IgZWFjaFxuICAgKiBgLmVkZ2UtbGFtYmRhLnRzYCBoYW5kbGVyIGluIHlvdXIgc291cmNlIHRyZWUuIElmIHRoaXMgaXMgZGlzYWJsZWQsIHlvdSBjYW5cbiAgICogbWFudWFsbHkgYWRkIGFuIGBhd3NjZGsuQXV0b0Rpc2NvdmVyYCBjb21wb25lbnQgdG8geW91ciBwcm9qZWN0LlxuICAgKlxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSBlZGdlTGFtYmRhQXV0b0Rpc2NvdmVyPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogQXV0b21hdGljYWxseSBhZGRzIGFuIGBhd3NjZGsuTGFtYmRhRXh0ZW5zaW9uYCBmb3IgZWFjaCBgLmxhbWJkYS1leHRlbnNpb24udHNgXG4gICAqIGVudHJ5cG9pbnQgaW4geW91ciBzb3VyY2UgdHJlZS4gSWYgdGhpcyBpcyBkaXNhYmxlZCwgeW91IGNhbiBtYW51YWxseSBhZGQgYW5cbiAgICogYGF3c2Nkay5BdXRvRGlzY292ZXJgIGNvbXBvbmVudCB0byB5b3VyIHByb2plY3RcbiAgICpcbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgbGFtYmRhRXh0ZW5zaW9uQXV0b0Rpc2NvdmVyPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogQXV0b21hdGljYWxseSBkaXNjb3ZlcnMgYW5kIGNyZWF0ZXMgaW50ZWdyYXRpb24gdGVzdHMgZm9yIGVhY2ggYC5pbnRlZy50c2BcbiAgICogZmlsZSB1bmRlciB5b3VyIHRlc3QgZGlyZWN0b3J5LlxuICAgKlxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSBpbnRlZ3JhdGlvblRlc3RBdXRvRGlzY292ZXI/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBFbmFibGUgZXhwZXJpbWVudGFsIHN1cHBvcnQgZm9yIHRoZSBBV1MgQ0RLIGludGVnLXJ1bm5lci5cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICogQGV4cGVyaW1lbnRhbFxuICAgKi9cbiAgcmVhZG9ubHkgZXhwZXJpbWVudGFsSW50ZWdSdW5uZXI/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBDb21tb24gb3B0aW9ucyBmb3IgYWxsIEFXUyBMYW1iZGEgZnVuY3Rpb25zLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIGRlZmF1bHQgb3B0aW9uc1xuICAgKi9cbiAgcmVhZG9ubHkgbGFtYmRhT3B0aW9ucz86IExhbWJkYUZ1bmN0aW9uQ29tbW9uT3B0aW9ucztcbn1cblxuLyoqXG4gKiBBV1MgQ0RLIGNvbnN0cnVjdCBsaWJyYXJ5IHByb2plY3RcbiAqXG4gKiBBIG11bHRpLWxhbmd1YWdlIChqc2lpKSBjb25zdHJ1Y3QgbGlicmFyeSB3aGljaCB2ZW5kcyBjb25zdHJ1Y3RzIGRlc2lnbmVkIHRvXG4gKiB1c2Ugd2l0aGluIHRoZSBBV1MgQ0RLIHdpdGggYSBmcmllbmRseSB3b3JrZmxvdyBhbmQgYXV0b21hdGljIHB1Ymxpc2hpbmcgdG9cbiAqIHRoZSBjb25zdHJ1Y3QgY2F0YWxvZy5cbiAqXG4gKiBAcGppZCBhd3NjZGstY29uc3RydWN0XG4gKi9cbmV4cG9ydCBjbGFzcyBBd3NDZGtDb25zdHJ1Y3RMaWJyYXJ5IGV4dGVuZHMgQ29uc3RydWN0TGlicmFyeSB7XG4gIHB1YmxpYyByZWFkb25seSBjZGtEZXBzOiBBd3NDZGtEZXBzO1xuXG4gIGNvbnN0cnVjdG9yKG9wdGlvbnM6IEF3c0Nka0NvbnN0cnVjdExpYnJhcnlPcHRpb25zKSB7XG4gICAgY29uc3QgY2RrTWFqb3JWZXJzaW9uID0gc2VtdmVyLnBhcnNlKG9wdGlvbnMuY2RrVmVyc2lvbik/Lm1ham9yO1xuXG4gICAgc3VwZXIoe1xuICAgICAgcGVlckRlcGVuZGVuY3lPcHRpb25zOlxuICAgICAgICBjZGtNYWpvclZlcnNpb24gPT09IDFcbiAgICAgICAgICA/IHtcbiAgICAgICAgICAgICAgcGlubmVkRGV2RGVwZW5kZW5jeTogZmFsc2UsXG4gICAgICAgICAgICB9XG4gICAgICAgICAgOiB1bmRlZmluZWQsXG4gICAgICB3b3JrZmxvd05vZGVWZXJzaW9uOiBvcHRpb25zLm1pbk5vZGVWZXJzaW9uID8/IFwibHRzLypcIixcbiAgICAgIC4uLm9wdGlvbnMsXG4gICAgfSk7XG5cbiAgICB0aGlzLmNka0RlcHMgPSBuZXcgQXdzQ2RrRGVwc0pzKHRoaXMsIHtcbiAgICAgIC8vIHNpbmNlIHRoaXMgd2UgYXJlIGEgbGlicmFyeSwgZGVwZW5kZW5jaWVzIHNob3VsZCBiZSBhZGRlZCBhIHBlZXJzXG4gICAgICBkZXBlbmRlbmN5VHlwZTogRGVwZW5kZW5jeVR5cGUuUEVFUixcbiAgICAgIC4uLm9wdGlvbnMsXG4gICAgfSk7XG5cbiAgICBuZXcgQXV0b0Rpc2NvdmVyKHRoaXMsIHtcbiAgICAgIHNyY2RpcjogdGhpcy5zcmNkaXIsXG4gICAgICB0ZXN0ZGlyOiB0aGlzLnRlc3RkaXIsXG4gICAgICBsYW1iZGFPcHRpb25zOiBvcHRpb25zLmxhbWJkYU9wdGlvbnMsXG4gICAgICB0c2NvbmZpZ1BhdGg6IHRoaXMudHNjb25maWdEZXYuZmlsZU5hbWUsXG4gICAgICBjZGtEZXBzOiB0aGlzLmNka0RlcHMsXG4gICAgICBsYW1iZGFBdXRvRGlzY292ZXI6IG9wdGlvbnMubGFtYmRhQXV0b0Rpc2NvdmVyID8/IHRydWUsXG4gICAgICBlZGdlTGFtYmRhQXV0b0Rpc2NvdmVyOiBvcHRpb25zLmVkZ2VMYW1iZGFBdXRvRGlzY292ZXIgPz8gdHJ1ZSxcbiAgICAgIGxhbWJkYUV4dGVuc2lvbkF1dG9EaXNjb3Zlcjogb3B0aW9ucy5sYW1iZGFFeHRlbnNpb25BdXRvRGlzY292ZXIgPz8gdHJ1ZSxcbiAgICAgIGludGVncmF0aW9uVGVzdEF1dG9EaXNjb3Zlcjogb3B0aW9ucy5pbnRlZ3JhdGlvblRlc3RBdXRvRGlzY292ZXIgPz8gdHJ1ZSxcbiAgICB9KTtcblxuICAgIGlmIChvcHRpb25zLmV4cGVyaW1lbnRhbEludGVnUnVubmVyKSB7XG4gICAgICBuZXcgSW50ZWdSdW5uZXIodGhpcyk7XG4gICAgfVxuICB9XG5cbiAgLyoqXG4gICAqIFRoZSB0YXJnZXQgQ0RLIHZlcnNpb24gZm9yIHRoaXMgbGlicmFyeS5cbiAgICovXG4gIHB1YmxpYyBnZXQgY2RrVmVyc2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy5jZGtEZXBzLmNka1ZlcnNpb247XG4gIH1cblxuICAvKipcbiAgICogQGRlcHJlY2F0ZWQgdXNlIGBjZGtWZXJzaW9uYFxuICAgKi9cbiAgcHVibGljIGdldCB2ZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLmNka1ZlcnNpb247XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBkZXBlbmRlbmNpZXMgdG8gQVdTIENESyBtb2R1bGVzLlxuICAgKlxuICAgKiBTaW5jZSB0aGlzIGlzIGEgbGlicmFyeSBwcm9qZWN0LCBkZXBlbmRlbmNpZXMgd2lsbCBiZSBhZGRlZCBhcyBwZWVyIGRlcGVuZGVuY2llcy5cbiAgICpcbiAgICogQHBhcmFtIGRlcHMgbmFtZXMgb2YgY2RrIG1vZHVsZXMgKGUuZy4gYEBhd3MtY2RrL2F3cy1sYW1iZGFgKS5cbiAgICogQGRlcHJlY2F0ZWQgTm90IHN1cHBvcnRlZCBpbiB2Mi4gRm9yIHYxLCB1c2UgYHByb2plY3QuY2RrRGVwcy5hZGRWMURlcGVuZGVuY2llcygpYFxuICAgKi9cbiAgcHVibGljIGFkZENka0RlcGVuZGVuY2llcyguLi5kZXBzOiBzdHJpbmdbXSkge1xuICAgIHJldHVybiB0aGlzLmNka0RlcHMuYWRkVjFEZXBlbmRlbmNpZXMoLi4uZGVwcyk7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBBV1MgQ0RLIG1vZHVsZXMgYXMgZGV2IGRlcGVuZGVuY2llcy5cbiAgICpcbiAgICogQHBhcmFtIGRlcHMgbmFtZXMgb2YgY2RrIG1vZHVsZXMgKGUuZy4gYEBhd3MtY2RrL2F3cy1sYW1iZGFgKS5cbiAgICogQGRlcHJlY2F0ZWQgTm90IHN1cHBvcnRlZCBpbiB2Mi4gRm9yIHYxLCB1c2UgYHByb2plY3QuY2RrRGVwcy5hZGRWMURldkRlcGVuZGVuY2llcygpYFxuICAgKi9cbiAgcHVibGljIGFkZENka1Rlc3REZXBlbmRlbmNpZXMoLi4uZGVwczogc3RyaW5nW10pIHtcbiAgICByZXR1cm4gdGhpcy5jZGtEZXBzLmFkZFYxRGV2RGVwZW5kZW5jaWVzKC4uLmRlcHMpO1xuICB9XG59XG5cbi8qKiBAZGVwcmVjYXRlZCB1c2UgYEF3c0Nka0NvbnN0cnVjdExpYnJhcnlPcHRpb25zYCAqL1xuZXhwb3J0IGludGVyZmFjZSBDb25zdHJ1Y3RMaWJyYXJ5QXdzT3B0aW9uc1xuICBleHRlbmRzIEF3c0Nka0NvbnN0cnVjdExpYnJhcnlPcHRpb25zIHt9XG5cbi8qKiBAZGVwcmVjYXRlZCB1c2UgYEF3c0Nka0NvbnN0cnVjdExpYnJhcnlgICovXG5leHBvcnQgY2xhc3MgQ29uc3RydWN0TGlicmFyeUF3cyBleHRlbmRzIEF3c0Nka0NvbnN0cnVjdExpYnJhcnkge31cbiJdfQ==