"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationTest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const posix_1 = require("path/posix");
const internal_1 = require("./internal");
const cdk_1 = require("../cdk");
const dependencies_1 = require("../dependencies");
/**
 * Cloud integration tests.
 */
class IntegrationTest extends cdk_1.IntegrationTestBase {
    constructor(project, options) {
        super(project, options);
        if (!project.deps.tryGetDependency("aws-cdk")) {
            project.deps.addDependency(`aws-cdk@^${options.cdkDeps.cdkMajorVersion}`, dependencies_1.DependencyType.BUILD);
        }
        if (!project.deps.tryGetDependency("ts-node")) {
            project.deps.addDependency("ts-node", dependencies_1.DependencyType.BUILD);
        }
        const deployDir = (0, posix_1.join)(this.tmpDir, "deploy.cdk.out");
        const assertDir = (0, posix_1.join)(this.tmpDir, "assert.cdk.out");
        const app = `ts-node -P ${options.tsconfigPath} ${options.entrypoint}`;
        const opts = [
            `--app "${app}"`,
            "--no-notices",
            "--no-version-reporting",
            // don't inject cloudformation metadata into template
            "--no-asset-metadata",
        ];
        const pathMetadata = options.pathMetadata ?? false;
        if (!pathMetadata) {
            opts.push("--no-path-metadata");
        }
        if (options.cdkDeps.cdkMajorVersion === 1) {
            // add all feature flags
            const features = [
                ...internal_1.FEATURE_FLAGS,
                "@aws-cdk/core:newStyleStackSynthesis", // simplifies asset coordinates in synth output
            ];
            for (const feature of features) {
                opts.push(`--context ${feature}=true`);
            }
        }
        const cdkopts = opts.join(" ");
        // Determine which stacks to deploy
        const stacks = options.stacks ?? ["**"];
        const stackOpts = stacks.map((stack) => `'${stack}'`).join(" ");
        this.deployTask.exec(`rm -fr ${deployDir}`);
        this.deployTask.exec(`cdk deploy ${cdkopts} ${stackOpts} --require-approval=never -o ${deployDir}`);
        // if deployment was successful, copy the deploy dir to the expected dir
        this.deployTask.exec(`rm -fr ${this.snapshotDir}`);
        this.deployTask.exec(`mv ${deployDir} ${this.snapshotDir}`);
        this.watchTask = project.addTask(`integ:${this.name}:watch`, {
            description: `watch integration test '${this.name}' (without updating snapshots)`,
            exec: `cdk watch ${cdkopts} ${stackOpts} -o ${deployDir}`,
        });
        this.destroyTask = project.addTask(`integ:${this.name}:destroy`, {
            description: `destroy integration test '${this.name}'`,
            exec: `cdk destroy --app ${this.snapshotDir} ${stackOpts} --no-version-reporting`,
        });
        const destroyAfterDeploy = options.destroyAfterDeploy ?? true;
        if (destroyAfterDeploy) {
            this.deployTask.spawn(this.destroyTask);
        }
        this.snapshotTask.exec(`cdk synth ${cdkopts} -o ${this.snapshotDir} > /dev/null`);
        const exclude = ["asset.*", "cdk.out", "manifest.json", "tree.json"];
        this.assertTask.exec(`cdk synth ${cdkopts} -o ${assertDir} > /dev/null`);
        this.assertTask.exec(`diff -r ${exclude.map((x) => `-x ${x}`).join(" ")} ${this.snapshotDir}/ ${assertDir}/`);
        // do not commit all files we are excluding
        for (const x of exclude) {
            project.addGitIgnore(`${this.snapshotDir}/${x}`);
            project.addGitIgnore(`${this.snapshotDir}/**/${x}`); // nested assemblies
        }
    }
}
exports.IntegrationTest = IntegrationTest;
_a = JSII_RTTI_SYMBOL_1;
IntegrationTest[_a] = { fqn: "projen.awscdk.IntegrationTest", version: "0.96.2" };
//# sourceMappingURL=data:application/json;base64,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