"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoApprove = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const workflows_model_1 = require("./workflows-model");
const component_1 = require("../component");
const runner_options_1 = require("../runner-options");
/**
 * Auto approve pull requests that meet a criteria
 */
class AutoApprove extends component_1.Component {
    constructor(github, options = {}) {
        super(github.project);
        this.label = options.label ?? "auto-approve";
        const usernames = options.allowedUsernames ?? ["github-actions[bot]"];
        let condition = `contains(github.event.pull_request.labels.*.name, '${this.label}')`;
        if (usernames.length > 0) {
            condition += " && (";
            condition += usernames
                .map((u) => `github.event.pull_request.user.login == '${u}'`)
                .join(" || ");
            condition += ")";
        }
        const secret = options.secret ?? "GITHUB_TOKEN";
        const approveJob = {
            ...(0, runner_options_1.filteredRunsOnOptions)(options.runsOn, options.runsOnGroup),
            permissions: {
                pullRequests: workflows_model_1.JobPermission.WRITE,
            },
            if: condition,
            steps: [
                {
                    uses: "hmarr/auto-approve-action@f0939ea97e9205ef24d872e76833fa908a770363",
                    with: {
                        "github-token": `\${{ secrets.${secret} }}`,
                    },
                },
            ],
        };
        const workflow = github.addWorkflow("auto-approve");
        workflow.on({
            // The 'pull request' event gives the workflow 'read-only' permissions on some
            // pull requests (such as the ones from dependabot) when using the `GITHUB_TOKEN`
            // security token. This prevents the workflow from approving these pull requests.
            // Github has placed this guard so as to prevent security attacks by simply opening
            // a pull request and triggering a workflow on a commit that was not vetted to make
            // unintended changes to the repository.
            //
            // Instead use the 'pull request target' event here that gives the Github workflow
            // 'read-write' permissions. This is safe because, this event, unlike the 'pull request'
            // event references the BASE commit of the pull request and not the HEAD commit.
            pullRequestTarget: {
                types: [
                    "labeled",
                    "opened",
                    "synchronize",
                    "reopened",
                    "ready_for_review",
                ],
            },
        });
        workflow.addJobs({ approve: approveJob });
    }
}
exports.AutoApprove = AutoApprove;
_a = JSII_RTTI_SYMBOL_1;
AutoApprove[_a] = { fqn: "projen.github.AutoApprove", version: "0.96.2" };
//# sourceMappingURL=data:application/json;base64,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