"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Junit = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const component_1 = require("../component");
const sample_file_1 = require("../sample-file");
const TESTDIR = (0, path_1.join)("src", "test", "java");
/**
 * Implements JUnit-based testing.
 */
class Junit extends component_1.Component {
    constructor(project, options) {
        super(project);
        const pom = options.pom;
        const version = options.version ?? "5.7.0";
        pom.addTestDependency(`org.junit.jupiter/junit-jupiter-api@${version}`);
        pom.addTestDependency(`org.junit.jupiter/junit-jupiter-engine@${version}`);
        project.testTask.exec("mvn test");
        const javaPackage = options.sampleJavaPackage ?? "org.acme";
        const javaPackagePath = javaPackage.split(".");
        new sample_file_1.SampleDir(project, (0, path_1.join)(TESTDIR, ...javaPackagePath), {
            files: {
                "MyTest.java": [
                    `package ${javaPackage};`,
                    "",
                    "import org.junit.jupiter.api.Test;",
                    "",
                    "public class MyTest {",
                    "  @Test",
                    "  public void testHello() {",
                    '    System.out.println("Hello, world!");',
                    "  }",
                    "}",
                ].join("\n"),
            },
        });
    }
}
exports.Junit = Junit;
_a = JSII_RTTI_SYMBOL_1;
Junit[_a] = { fqn: "projen.java.Junit", version: "0.96.2" };
//# sourceMappingURL=data:application/json;base64,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