"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MavenPackaging = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
/**
 * Configures a maven project to produce a .jar archive with sources and javadocs.
 */
class MavenPackaging extends component_1.Component {
    constructor(project, pom, options = {}) {
        super(project);
        pom.addPlugin("org.apache.maven.plugins/maven-jar-plugin@3.2.0", {
            configuration: {
                archive: {
                    index: true,
                    manifest: {
                        addDefaultImplementationEntries: true,
                        addDefaultSpecificationEntries: true,
                    },
                },
            },
        });
        if (options.sources ?? true) {
            pom.addPlugin("org.apache.maven.plugins/maven-source-plugin@3.2.1", {
                executions: [{ id: "attach-sources", goals: ["jar"] }],
            });
        }
        if (options.javadocs ?? true) {
            pom.addPlugin("org.apache.maven.plugins/maven-javadoc-plugin@3.2.0", {
                executions: [{ id: "attach-javadocs", goals: ["jar"] }],
                configuration: {
                    failOnError: false,
                    show: "protected",
                    sourceFileExcludes: { exclude: options.javadocsExclude },
                    detectJavaApiLink: false, // https://stackoverflow.com/a/61884267
                    additionalJOptions: {
                        additionalJOption: [
                            "-J-XX:+TieredCompilation",
                            "-J-XX:TieredStopAtLevel=1",
                        ],
                    },
                },
            });
        }
        const env = {
            MAVEN_OPTS: "-XX:+TieredCompilation -XX:TieredStopAtLevel=1",
        };
        this.distdir = options.distdir ?? "dist/java";
        for (const [k, v] of Object.entries(env)) {
            this.project.packageTask.env(k, v);
        }
        this.project.packageTask.exec(`mkdir -p ${this.distdir}`);
        this.project.packageTask.exec(`mvn deploy -D=altDeploymentRepository=local::default::file:///$PWD/${this.distdir}`);
        project.gitignore.exclude(this.distdir);
    }
}
exports.MavenPackaging = MavenPackaging;
_a = JSII_RTTI_SYMBOL_1;
MavenPackaging[_a] = { fqn: "projen.java.MavenPackaging", version: "0.96.2" };
//# sourceMappingURL=data:application/json;base64,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