/**
 * The configuration that is contained inside the file `biome.json`
 *
 * @schema BiomeConfiguration
 */
export interface BiomeConfiguration {
    /**
     * A field for the [JSON schema](https://json-schema.org/) specification
     *
     * @schema BiomeConfiguration#$schema
     */
    readonly schema?: string;
    /**
     * Specific configuration for assists
     *
     * @schema BiomeConfiguration#assist
     */
    readonly assist?: AssistConfiguration;
    /**
     * Specific configuration for the Css language
     *
     * @schema BiomeConfiguration#css
     */
    readonly css?: CssConfiguration;
    /**
     * A list of paths to other JSON files, used to extends the current configuration.
     *
     * @schema BiomeConfiguration#extends
     */
    readonly extends?: string[];
    /**
     * The configuration of the filesystem
     *
     * @schema BiomeConfiguration#files
     */
    readonly files?: FilesConfiguration;
    /**
     * The configuration of the formatter
     *
     * @schema BiomeConfiguration#formatter
     */
    readonly formatter?: FormatterConfiguration;
    /**
     * Specific configuration for the GraphQL language
     *
     * @schema BiomeConfiguration#graphql
     */
    readonly graphql?: GraphqlConfiguration;
    /**
     * Specific configuration for the GraphQL language
     *
     * @schema BiomeConfiguration#grit
     */
    readonly grit?: GritConfiguration;
    /**
     * Specific configuration for the HTML language
     *
     * @schema BiomeConfiguration#html
     */
    readonly html?: HtmlConfiguration;
    /**
     * Specific configuration for the JavaScript language
     *
     * @schema BiomeConfiguration#javascript
     */
    readonly javascript?: JsConfiguration;
    /**
     * Specific configuration for the Json language
     *
     * @schema BiomeConfiguration#json
     */
    readonly json?: JsonConfiguration;
    /**
     * The configuration for the linter
     *
     * @schema BiomeConfiguration#linter
     */
    readonly linter?: LinterConfiguration;
    /**
     * A list of granular patterns that should be applied only to a sub set of files
     *
     * @schema BiomeConfiguration#overrides
     */
    readonly overrides?: OverridePattern[];
    /**
     * List of plugins to load.
     *
     * @schema BiomeConfiguration#plugins
     */
    readonly plugins?: string[];
    /**
     * Indicates whether this configuration file is at the root of a Biome project. By default, this is `true`.
     *
     * @schema BiomeConfiguration#root
     */
    readonly root?: boolean;
    /**
     * The configuration of the VCS integration
     *
     * @schema BiomeConfiguration#vcs
     */
    readonly vcs?: VcsConfiguration;
}
/**
 * Converts an object of type 'BiomeConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_BiomeConfiguration(obj: BiomeConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema AssistConfiguration
 */
export interface AssistConfiguration {
    /**
     * Whether Biome should fail in CLI if the assist were not applied to the code.
     *
     * @schema AssistConfiguration#actions
     */
    readonly actions?: Actions;
    /**
     * Whether Biome should enable assist via LSP and CLI.
     *
     * @schema AssistConfiguration#enabled
     */
    readonly enabled?: boolean;
    /**
     * A list of glob patterns. Biome will include files/folders that will match these patterns.
     *
     * @schema AssistConfiguration#includes
     */
    readonly includes?: string[];
}
/**
 * Converts an object of type 'AssistConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_AssistConfiguration(obj: AssistConfiguration | undefined): Record<string, any> | undefined;
/**
 * Options applied to CSS files
 *
 * @schema CssConfiguration
 */
export interface CssConfiguration {
    /**
     * CSS assist options
     *
     * @schema CssConfiguration#assist
     */
    readonly assist?: CssAssistConfiguration;
    /**
     * CSS formatter options
     *
     * @schema CssConfiguration#formatter
     */
    readonly formatter?: CssFormatterConfiguration;
    /**
     * CSS globals
     *
     * @schema CssConfiguration#globals
     */
    readonly globals?: string[];
    /**
     * CSS linter options
     *
     * @schema CssConfiguration#linter
     */
    readonly linter?: CssLinterConfiguration;
    /**
     * CSS parsing options
     *
     * @schema CssConfiguration#parser
     */
    readonly parser?: CssParserConfiguration;
}
/**
 * Converts an object of type 'CssConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_CssConfiguration(obj: CssConfiguration | undefined): Record<string, any> | undefined;
/**
 * The configuration of the filesystem
 *
 * @schema FilesConfiguration
 */
export interface FilesConfiguration {
    /**
     * Set of file and folder names that should be unconditionally ignored by Biome's scanner.
     *
     * Biome maintains an internal list of default ignore entries, which is based on user feedback and which may change in any release. This setting allows overriding this internal list completely.
     *
     * This is considered an advanced feature that users _should_ not need to tweak themselves, but they can as a last resort. This setting can only be configured in root configurations, and is ignored in nested configs.
     *
     * Entries must be file or folder *names*. Specific paths and globs are not supported.
     *
     * Examples where this may be useful:
     *
     * ```jsonc { "files": { "experimentalScannerIgnores": [ // You almost certainly don't want to scan your `.git` // folder, which is why it's already ignored by default: ".git",
     *
     * // But the scanner does scan `node_modules` by default. If // you *really* don't want this, you can ignore it like // this: "node_modules",
     *
     * // But it's probably better to ignore a specific dependency. // For instance, one that happens to be particularly slow to // scan: "RedisCommander.d.ts", ], } } ```
     *
     * Please be aware that rules relying on the module graph or type inference information may be negatively affected if dependencies of your project aren't (fully) scanned.
     *
     * @schema FilesConfiguration#experimentalScannerIgnores
     */
    readonly experimentalScannerIgnores?: string[];
    /**
     * Tells Biome to not emit diagnostics when handling files that doesn't know
     *
     * @schema FilesConfiguration#ignoreUnknown
     */
    readonly ignoreUnknown?: boolean;
    /**
     * A list of glob patterns. Biome will handle only those files/folders that will match these patterns.
     *
     * @schema FilesConfiguration#includes
     */
    readonly includes?: string[];
    /**
     * The maximum allowed size for source code files in bytes. Files above this limit will be ignored for performance reasons. Defaults to 1 MiB
     *
     * @default 1 MiB
     * @schema FilesConfiguration#maxSize
     */
    readonly maxSize?: number;
}
/**
 * Converts an object of type 'FilesConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_FilesConfiguration(obj: FilesConfiguration | undefined): Record<string, any> | undefined;
/**
 * Generic options applied to all files
 *
 * @schema FormatterConfiguration
 */
export interface FormatterConfiguration {
    /**
     * The attribute position style in HTML-ish languages. Defaults to auto.
     *
     * @default auto.
     * @schema FormatterConfiguration#attributePosition
     */
    readonly attributePosition?: AttributePosition;
    /**
     * Put the `>` of a multi-line HTML or JSX element at the end of the last line instead of being alone on the next line (does not apply to self closing elements).
     *
     * @schema FormatterConfiguration#bracketSameLine
     */
    readonly bracketSameLine?: boolean;
    /**
     * Whether to insert spaces around brackets in object literals. Defaults to true.
     *
     * @default true.
     * @schema FormatterConfiguration#bracketSpacing
     */
    readonly bracketSpacing?: boolean;
    /**
     * @schema FormatterConfiguration#enabled
     */
    readonly enabled?: boolean;
    /**
     * Whether to expand arrays and objects on multiple lines. When set to `auto`, object literals are formatted on multiple lines if the first property has a newline, and array literals are formatted on a single line if it fits in the line. When set to `always`, these literals are formatted on multiple lines, regardless of length of the list. When set to `never`, these literals are formatted on a single line if it fits in the line. When formatting `package.json`, Biome will use `always` unless configured otherwise. Defaults to "auto".
     *
     * @default auto".
     * @schema FormatterConfiguration#expand
     */
    readonly expand?: Expand;
    /**
     * Stores whether formatting should be allowed to proceed if a given file has syntax errors
     *
     * @schema FormatterConfiguration#formatWithErrors
     */
    readonly formatWithErrors?: boolean;
    /**
     * A list of glob patterns. The formatter will include files/folders that will match these patterns.
     *
     * @schema FormatterConfiguration#includes
     */
    readonly includes?: string[];
    /**
     * The indent style.
     *
     * @schema FormatterConfiguration#indentStyle
     */
    readonly indentStyle?: IndentStyle;
    /**
     * The size of the indentation, 2 by default
     *
     * @schema FormatterConfiguration#indentWidth
     */
    readonly indentWidth?: number;
    /**
     * The type of line ending.
     *
     * @schema FormatterConfiguration#lineEnding
     */
    readonly lineEnding?: LineEnding;
    /**
     * What's the max width of a line. Defaults to 80.
     *
     * @default 80.
     * @schema FormatterConfiguration#lineWidth
     */
    readonly lineWidth?: number;
    /**
     * Use any `.editorconfig` files to configure the formatter. Configuration in `biome.json` will override `.editorconfig` configuration.
     *
     * Default: `true`.
     *
     * @schema FormatterConfiguration#useEditorconfig
     */
    readonly useEditorconfig?: boolean;
}
/**
 * Converts an object of type 'FormatterConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_FormatterConfiguration(obj: FormatterConfiguration | undefined): Record<string, any> | undefined;
/**
 * Options applied to GraphQL files
 *
 * @schema GraphqlConfiguration
 */
export interface GraphqlConfiguration {
    /**
     * Assist options
     *
     * @schema GraphqlConfiguration#assist
     */
    readonly assist?: GraphqlAssistConfiguration;
    /**
     * GraphQL formatter options
     *
     * @schema GraphqlConfiguration#formatter
     */
    readonly formatter?: GraphqlFormatterConfiguration;
    /**
     * @schema GraphqlConfiguration#linter
     */
    readonly linter?: GraphqlLinterConfiguration;
}
/**
 * Converts an object of type 'GraphqlConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_GraphqlConfiguration(obj: GraphqlConfiguration | undefined): Record<string, any> | undefined;
/**
 * Options applied to GritQL files
 *
 * @schema GritConfiguration
 */
export interface GritConfiguration {
    /**
     * Assist options
     *
     * @schema GritConfiguration#assist
     */
    readonly assist?: GritAssistConfiguration;
    /**
     * Formatting options
     *
     * @schema GritConfiguration#formatter
     */
    readonly formatter?: GritFormatterConfiguration;
    /**
     * Formatting options
     *
     * @schema GritConfiguration#linter
     */
    readonly linter?: GritLinterConfiguration;
}
/**
 * Converts an object of type 'GritConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_GritConfiguration(obj: GritConfiguration | undefined): Record<string, any> | undefined;
/**
 * Options applied to HTML files
 *
 * @schema HtmlConfiguration
 */
export interface HtmlConfiguration {
    /**
     * HTML formatter options
     *
     * @schema HtmlConfiguration#formatter
     */
    readonly formatter?: HtmlFormatterConfiguration;
    /**
     * HTML parsing options
     *
     * @schema HtmlConfiguration#parser
     */
    readonly parser?: HtmlParserConfiguration;
}
/**
 * Converts an object of type 'HtmlConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_HtmlConfiguration(obj: HtmlConfiguration | undefined): Record<string, any> | undefined;
/**
 * A set of options applied to the JavaScript files
 *
 * @schema JsConfiguration
 */
export interface JsConfiguration {
    /**
     * Assist options
     *
     * @schema JsConfiguration#assist
     */
    readonly assist?: JsAssistConfiguration;
    /**
     * Formatting options
     *
     * @schema JsConfiguration#formatter
     */
    readonly formatter?: JsFormatterConfiguration;
    /**
     * A list of global bindings that should be ignored by the analyzers
     *
     * If defined here, they should not emit diagnostics.
     *
     * @schema JsConfiguration#globals
     */
    readonly globals?: string[];
    /**
     * Indicates the type of runtime or transformation used for interpreting JSX.
     *
     * @schema JsConfiguration#jsxRuntime
     */
    readonly jsxRuntime?: JsxRuntime;
    /**
     * Linter options
     *
     * @schema JsConfiguration#linter
     */
    readonly linter?: JsLinterConfiguration;
    /**
     * Parsing options
     *
     * @schema JsConfiguration#parser
     */
    readonly parser?: JsParserConfiguration;
}
/**
 * Converts an object of type 'JsConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_JsConfiguration(obj: JsConfiguration | undefined): Record<string, any> | undefined;
/**
 * Options applied to JSON files
 *
 * @schema JsonConfiguration
 */
export interface JsonConfiguration {
    /**
     * Assist options
     *
     * @schema JsonConfiguration#assist
     */
    readonly assist?: JsonAssistConfiguration;
    /**
     * Formatting options
     *
     * @schema JsonConfiguration#formatter
     */
    readonly formatter?: JsonFormatterConfiguration;
    /**
     * Linting options
     *
     * @schema JsonConfiguration#linter
     */
    readonly linter?: JsonLinterConfiguration;
    /**
     * Parsing options
     *
     * @schema JsonConfiguration#parser
     */
    readonly parser?: JsonParserConfiguration;
}
/**
 * Converts an object of type 'JsonConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_JsonConfiguration(obj: JsonConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema LinterConfiguration
 */
export interface LinterConfiguration {
    /**
     * An object where the keys are the names of the domains, and the values are `all`, `recommended`, or `none`.
     *
     * @schema LinterConfiguration#domains
     */
    readonly domains?: {
        [key: string]: RuleDomainValue;
    };
    /**
     * if `false`, it disables the feature and the linter won't be executed. `true` by default
     *
     * @schema LinterConfiguration#enabled
     */
    readonly enabled?: boolean;
    /**
     * A list of glob patterns. The analyzer will handle only those files/folders that will match these patterns.
     *
     * @schema LinterConfiguration#includes
     */
    readonly includes?: string[];
    /**
     * List of rules
     *
     * @schema LinterConfiguration#rules
     */
    readonly rules?: Rules;
}
/**
 * Converts an object of type 'LinterConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_LinterConfiguration(obj: LinterConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema OverridePattern
 */
export interface OverridePattern {
    /**
     * Specific configuration for the Json language
     *
     * @schema OverridePattern#assist
     */
    readonly assist?: OverrideAssistConfiguration;
    /**
     * Specific configuration for the CSS language
     *
     * @schema OverridePattern#css
     */
    readonly css?: CssConfiguration;
    /**
     * Specific configuration for the filesystem
     *
     * @schema OverridePattern#files
     */
    readonly files?: OverrideFilesConfiguration;
    /**
     * Specific configuration for the Json language
     *
     * @schema OverridePattern#formatter
     */
    readonly formatter?: OverrideFormatterConfiguration;
    /**
     * Specific configuration for the Graphql language
     *
     * @schema OverridePattern#graphql
     */
    readonly graphql?: GraphqlConfiguration;
    /**
     * Specific configuration for the GritQL language
     *
     * @schema OverridePattern#grit
     */
    readonly grit?: GritConfiguration;
    /**
     * Specific configuration for the GritQL language
     *
     * @schema OverridePattern#html
     */
    readonly html?: HtmlConfiguration;
    /**
     * A list of glob patterns. Biome will include files/folders that will match these patterns.
     *
     * @schema OverridePattern#includes
     */
    readonly includes?: string[];
    /**
     * Specific configuration for the JavaScript language
     *
     * @schema OverridePattern#javascript
     */
    readonly javascript?: JsConfiguration;
    /**
     * Specific configuration for the Json language
     *
     * @schema OverridePattern#json
     */
    readonly json?: JsonConfiguration;
    /**
     * Specific configuration for the Json language
     *
     * @schema OverridePattern#linter
     */
    readonly linter?: OverrideLinterConfiguration;
    /**
     * Specific configuration for additional plugins
     *
     * @schema OverridePattern#plugins
     */
    readonly plugins?: string[];
}
/**
 * Converts an object of type 'OverridePattern' to JSON representation.
 * @internal
 */
export declare function toJson_OverridePattern(obj: OverridePattern | undefined): Record<string, any> | undefined;
/**
 * Set of properties to integrate Biome with a VCS software.
 *
 * @schema VcsConfiguration
 */
export interface VcsConfiguration {
    /**
     * The kind of client.
     *
     * @schema VcsConfiguration#clientKind
     */
    readonly clientKind?: VcsClientKind;
    /**
     * The main branch of the project
     *
     * @schema VcsConfiguration#defaultBranch
     */
    readonly defaultBranch?: string;
    /**
     * Whether Biome should integrate itself with the VCS client
     *
     * @schema VcsConfiguration#enabled
     */
    readonly enabled?: boolean;
    /**
     * The folder where Biome should check for VCS files. By default, Biome will use the same folder where `biome.json` was found.
     *
     * If Biome can't find the configuration, it will attempt to use the current working directory. If no current working directory can't be found, Biome won't use the VCS integration, and a diagnostic will be emitted
     *
     * @schema VcsConfiguration#root
     */
    readonly root?: string;
    /**
     * Whether Biome should use the VCS ignore file. When [true], Biome will ignore the files specified in the ignore file.
     *
     * @schema VcsConfiguration#useIgnoreFile
     */
    readonly useIgnoreFile?: boolean;
}
/**
 * Converts an object of type 'VcsConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_VcsConfiguration(obj: VcsConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema Actions
 */
export interface Actions {
    /**
     * It enables the assist actions recommended by Biome. `true` by default.
     *
     * @schema Actions#recommended
     */
    readonly recommended?: boolean;
    /**
     * @schema Actions#source
     */
    readonly source?: Source;
}
/**
 * Converts an object of type 'Actions' to JSON representation.
 * @internal
 */
export declare function toJson_Actions(obj: Actions | undefined): Record<string, any> | undefined;
/**
 * Options that changes how the CSS assist behaves
 *
 * @schema CssAssistConfiguration
 */
export interface CssAssistConfiguration {
    /**
     * Control the assist for CSS files.
     *
     * @schema CssAssistConfiguration#enabled
     */
    readonly enabled?: boolean;
}
/**
 * Converts an object of type 'CssAssistConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_CssAssistConfiguration(obj: CssAssistConfiguration | undefined): Record<string, any> | undefined;
/**
 * Options that changes how the CSS formatter behaves
 *
 * @schema CssFormatterConfiguration
 */
export interface CssFormatterConfiguration {
    /**
     * Control the formatter for CSS (and its super languages) files.
     *
     * @schema CssFormatterConfiguration#enabled
     */
    readonly enabled?: boolean;
    /**
     * The indent style applied to CSS (and its super languages) files.
     *
     * @schema CssFormatterConfiguration#indentStyle
     */
    readonly indentStyle?: IndentStyle;
    /**
     * The size of the indentation applied to CSS (and its super languages) files. Default to 2.
     *
     * @default 2.
     * @schema CssFormatterConfiguration#indentWidth
     */
    readonly indentWidth?: number;
    /**
     * The type of line ending applied to CSS (and its super languages) files.
     *
     * @schema CssFormatterConfiguration#lineEnding
     */
    readonly lineEnding?: LineEnding;
    /**
     * What's the max width of a line applied to CSS (and its super languages) files. Defaults to 80.
     *
     * @default 80.
     * @schema CssFormatterConfiguration#lineWidth
     */
    readonly lineWidth?: number;
    /**
     * The type of quotes used in CSS code. Defaults to double.
     *
     * @default double.
     * @schema CssFormatterConfiguration#quoteStyle
     */
    readonly quoteStyle?: QuoteStyle;
}
/**
 * Converts an object of type 'CssFormatterConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_CssFormatterConfiguration(obj: CssFormatterConfiguration | undefined): Record<string, any> | undefined;
/**
 * Options that changes how the CSS linter behaves
 *
 * @schema CssLinterConfiguration
 */
export interface CssLinterConfiguration {
    /**
     * Control the linter for CSS files.
     *
     * @schema CssLinterConfiguration#enabled
     */
    readonly enabled?: boolean;
}
/**
 * Converts an object of type 'CssLinterConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_CssLinterConfiguration(obj: CssLinterConfiguration | undefined): Record<string, any> | undefined;
/**
 * Options that changes how the CSS parser behaves
 *
 * @schema CssParserConfiguration
 */
export interface CssParserConfiguration {
    /**
     * Allow comments to appear on incorrect lines in `.css` files
     *
     * @schema CssParserConfiguration#allowWrongLineComments
     */
    readonly allowWrongLineComments?: boolean;
    /**
     * Enables parsing of CSS Modules specific features.
     *
     * @schema CssParserConfiguration#cssModules
     */
    readonly cssModules?: boolean;
}
/**
 * Converts an object of type 'CssParserConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_CssParserConfiguration(obj: CssParserConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema AttributePosition
 */
export declare enum AttributePosition {
    /** auto */
    AUTO = "auto",
    /** multiline */
    MULTILINE = "multiline"
}
/**
 * @schema Expand
 */
export declare enum Expand {
    /** auto */
    AUTO = "auto",
    /** always */
    ALWAYS = "always",
    /** never */
    NEVER = "never"
}
/**
 * @schema IndentStyle
 */
export declare enum IndentStyle {
    /** tab */
    TAB = "tab",
    /** space */
    SPACE = "space"
}
/**
 * @schema LineEnding
 */
export declare enum LineEnding {
    /** lf */
    LF = "lf",
    /** crlf */
    CRLF = "crlf",
    /** cr */
    CR = "cr"
}
/**
 * Options that changes how the GraphQL linter behaves
 *
 * @schema GraphqlAssistConfiguration
 */
export interface GraphqlAssistConfiguration {
    /**
     * Control the formatter for GraphQL files.
     *
     * @schema GraphqlAssistConfiguration#enabled
     */
    readonly enabled?: boolean;
}
/**
 * Converts an object of type 'GraphqlAssistConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_GraphqlAssistConfiguration(obj: GraphqlAssistConfiguration | undefined): Record<string, any> | undefined;
/**
 * Options that changes how the GraphQL formatter behaves
 *
 * @schema GraphqlFormatterConfiguration
 */
export interface GraphqlFormatterConfiguration {
    /**
     * Whether to insert spaces around brackets in object literals. Defaults to true.
     *
     * @default true.
     * @schema GraphqlFormatterConfiguration#bracketSpacing
     */
    readonly bracketSpacing?: boolean;
    /**
     * Control the formatter for GraphQL files.
     *
     * @schema GraphqlFormatterConfiguration#enabled
     */
    readonly enabled?: boolean;
    /**
     * The indent style applied to GraphQL files.
     *
     * @schema GraphqlFormatterConfiguration#indentStyle
     */
    readonly indentStyle?: IndentStyle;
    /**
     * The size of the indentation applied to GraphQL files. Default to 2.
     *
     * @default 2.
     * @schema GraphqlFormatterConfiguration#indentWidth
     */
    readonly indentWidth?: number;
    /**
     * The type of line ending applied to GraphQL files.
     *
     * @schema GraphqlFormatterConfiguration#lineEnding
     */
    readonly lineEnding?: LineEnding;
    /**
     * What's the max width of a line applied to GraphQL files. Defaults to 80.
     *
     * @default 80.
     * @schema GraphqlFormatterConfiguration#lineWidth
     */
    readonly lineWidth?: number;
    /**
     * The type of quotes used in GraphQL code. Defaults to double.
     *
     * @default double.
     * @schema GraphqlFormatterConfiguration#quoteStyle
     */
    readonly quoteStyle?: QuoteStyle;
}
/**
 * Converts an object of type 'GraphqlFormatterConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_GraphqlFormatterConfiguration(obj: GraphqlFormatterConfiguration | undefined): Record<string, any> | undefined;
/**
 * Options that change how the GraphQL linter behaves.
 *
 * @schema GraphqlLinterConfiguration
 */
export interface GraphqlLinterConfiguration {
    /**
     * Control the formatter for GraphQL files.
     *
     * @schema GraphqlLinterConfiguration#enabled
     */
    readonly enabled?: boolean;
}
/**
 * Converts an object of type 'GraphqlLinterConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_GraphqlLinterConfiguration(obj: GraphqlLinterConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema GritAssistConfiguration
 */
export interface GritAssistConfiguration {
    /**
     * Control the assist functionality for Grit files.
     *
     * @schema GritAssistConfiguration#enabled
     */
    readonly enabled?: boolean;
}
/**
 * Converts an object of type 'GritAssistConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_GritAssistConfiguration(obj: GritAssistConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema GritFormatterConfiguration
 */
export interface GritFormatterConfiguration {
    /**
     * Control the formatter for Grit files.
     *
     * @schema GritFormatterConfiguration#enabled
     */
    readonly enabled?: boolean;
    /**
     * The indent style applied to Grit files.
     *
     * @schema GritFormatterConfiguration#indentStyle
     */
    readonly indentStyle?: IndentStyle;
    /**
     * The size of the indentation applied to Grit files. Default to 2.
     *
     * @default 2.
     * @schema GritFormatterConfiguration#indentWidth
     */
    readonly indentWidth?: number;
    /**
     * The type of line ending applied to Grit files.
     *
     * @schema GritFormatterConfiguration#lineEnding
     */
    readonly lineEnding?: LineEnding;
    /**
     * What's the max width of a line applied to Grit files. Defaults to 80.
     *
     * @default 80.
     * @schema GritFormatterConfiguration#lineWidth
     */
    readonly lineWidth?: number;
}
/**
 * Converts an object of type 'GritFormatterConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_GritFormatterConfiguration(obj: GritFormatterConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema GritLinterConfiguration
 */
export interface GritLinterConfiguration {
    /**
     * Control the linter for Grit files.
     *
     * @schema GritLinterConfiguration#enabled
     */
    readonly enabled?: boolean;
}
/**
 * Converts an object of type 'GritLinterConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_GritLinterConfiguration(obj: GritLinterConfiguration | undefined): Record<string, any> | undefined;
/**
 * Options that changes how the HTML formatter behaves
 *
 * @schema HtmlFormatterConfiguration
 */
export interface HtmlFormatterConfiguration {
    /**
     * The attribute position style in HTML elements. Defaults to auto.
     *
     * @default auto.
     * @schema HtmlFormatterConfiguration#attributePosition
     */
    readonly attributePosition?: AttributePosition;
    /**
     * Whether to hug the closing bracket of multiline HTML tags to the end of the last line, rather than being alone on the following line. Defaults to false.
     *
     * @default false.
     * @schema HtmlFormatterConfiguration#bracketSameLine
     */
    readonly bracketSameLine?: boolean;
    /**
     * Control the formatter for HTML (and its super languages) files.
     *
     * @schema HtmlFormatterConfiguration#enabled
     */
    readonly enabled?: boolean;
    /**
     * Whether to indent the `<script>` and `<style>` tags for HTML (and its super languages). Defaults to false.
     *
     * @default false.
     * @schema HtmlFormatterConfiguration#indentScriptAndStyle
     */
    readonly indentScriptAndStyle?: boolean;
    /**
     * The indent style applied to HTML (and its super languages) files.
     *
     * @schema HtmlFormatterConfiguration#indentStyle
     */
    readonly indentStyle?: IndentStyle;
    /**
     * The size of the indentation applied to HTML (and its super languages) files. Default to 2.
     *
     * @default 2.
     * @schema HtmlFormatterConfiguration#indentWidth
     */
    readonly indentWidth?: number;
    /**
     * The type of line ending applied to HTML (and its super languages) files.
     *
     * @schema HtmlFormatterConfiguration#lineEnding
     */
    readonly lineEnding?: LineEnding;
    /**
     * What's the max width of a line applied to HTML (and its super languages) files. Defaults to 80.
     *
     * @default 80.
     * @schema HtmlFormatterConfiguration#lineWidth
     */
    readonly lineWidth?: number;
    /**
     * Whether void elements should be self-closed. Defaults to never.
     *
     * @default never.
     * @schema HtmlFormatterConfiguration#selfCloseVoidElements
     */
    readonly selfCloseVoidElements?: SelfCloseVoidElements;
    /**
     * Whether to account for whitespace sensitivity when formatting HTML (and its super languages). Defaults to "css".
     *
     * @default css".
     * @schema HtmlFormatterConfiguration#whitespaceSensitivity
     */
    readonly whitespaceSensitivity?: WhitespaceSensitivity;
}
/**
 * Converts an object of type 'HtmlFormatterConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_HtmlFormatterConfiguration(obj: HtmlFormatterConfiguration | undefined): Record<string, any> | undefined;
/**
 * Options that changes how the HTML parser behaves
 *
 * @schema HtmlParserConfiguration
 */
export interface HtmlParserConfiguration {
    /**
     * Enables the parsing of double text expressions such as `{{ expression }}` inside `.html` files
     *
     * @schema HtmlParserConfiguration#interpolation
     */
    readonly interpolation?: boolean;
}
/**
 * Converts an object of type 'HtmlParserConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_HtmlParserConfiguration(obj: HtmlParserConfiguration | undefined): Record<string, any> | undefined;
/**
 * Assist options specific to the JavaScript assist
 *
 * @schema JsAssistConfiguration
 */
export interface JsAssistConfiguration {
    /**
     * Control the assist for JavaScript (and its super languages) files.
     *
     * @schema JsAssistConfiguration#enabled
     */
    readonly enabled?: boolean;
}
/**
 * Converts an object of type 'JsAssistConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_JsAssistConfiguration(obj: JsAssistConfiguration | undefined): Record<string, any> | undefined;
/**
 * Formatting options specific to the JavaScript files
 *
 * @schema JsFormatterConfiguration
 */
export interface JsFormatterConfiguration {
    /**
     * Whether to add non-necessary parentheses to arrow functions. Defaults to "always".
     *
     * @default always".
     * @schema JsFormatterConfiguration#arrowParentheses
     */
    readonly arrowParentheses?: ArrowParentheses;
    /**
     * The attribute position style in JSX elements. Defaults to auto.
     *
     * @default auto.
     * @schema JsFormatterConfiguration#attributePosition
     */
    readonly attributePosition?: AttributePosition;
    /**
     * Whether to hug the closing bracket of multiline HTML/JSX tags to the end of the last line, rather than being alone on the following line. Defaults to false.
     *
     * @default false.
     * @schema JsFormatterConfiguration#bracketSameLine
     */
    readonly bracketSameLine?: boolean;
    /**
     * Whether to insert spaces around brackets in object literals. Defaults to true.
     *
     * @default true.
     * @schema JsFormatterConfiguration#bracketSpacing
     */
    readonly bracketSpacing?: boolean;
    /**
     * Control the formatter for JavaScript (and its super languages) files.
     *
     * @schema JsFormatterConfiguration#enabled
     */
    readonly enabled?: boolean;
    /**
     * Whether to expand arrays and objects on multiple lines. When set to `auto`, object literals are formatted on multiple lines if the first property has a newline, and array literals are formatted on a single line if it fits in the line. When set to `always`, these literals are formatted on multiple lines, regardless of length of the list. When set to `never`, these literals are formatted on a single line if it fits in the line. When formatting `package.json`, Biome will use `always` unless configured otherwise. Defaults to "auto".
     *
     * @default auto".
     * @schema JsFormatterConfiguration#expand
     */
    readonly expand?: Expand;
    /**
     * The indent style applied to JavaScript (and its super languages) files.
     *
     * @schema JsFormatterConfiguration#indentStyle
     */
    readonly indentStyle?: IndentStyle;
    /**
     * The size of the indentation applied to JavaScript (and its super languages) files. Default to 2.
     *
     * @default 2.
     * @schema JsFormatterConfiguration#indentWidth
     */
    readonly indentWidth?: number;
    /**
     * The type of quotes used in JSX. Defaults to double.
     *
     * @default double.
     * @schema JsFormatterConfiguration#jsxQuoteStyle
     */
    readonly jsxQuoteStyle?: QuoteStyle;
    /**
     * The type of line ending applied to JavaScript (and its super languages) files.
     *
     * @schema JsFormatterConfiguration#lineEnding
     */
    readonly lineEnding?: LineEnding;
    /**
     * What's the max width of a line applied to JavaScript (and its super languages) files. Defaults to 80.
     *
     * @default 80.
     * @schema JsFormatterConfiguration#lineWidth
     */
    readonly lineWidth?: number;
    /**
     * When breaking binary expressions into multiple lines, whether to break them before or after the binary operator. Defaults to "after".
     *
     * @default after".
     * @schema JsFormatterConfiguration#operatorLinebreak
     */
    readonly operatorLinebreak?: OperatorLinebreak;
    /**
     * When properties in objects are quoted. Defaults to asNeeded.
     *
     * @default asNeeded.
     * @schema JsFormatterConfiguration#quoteProperties
     */
    readonly quoteProperties?: QuoteProperties;
    /**
     * The type of quotes used in JavaScript code. Defaults to double.
     *
     * @default double.
     * @schema JsFormatterConfiguration#quoteStyle
     */
    readonly quoteStyle?: QuoteStyle;
    /**
     * Whether the formatter prints semicolons for all statements or only in for statements where it is necessary because of ASI.
     *
     * @schema JsFormatterConfiguration#semicolons
     */
    readonly semicolons?: Semicolons;
    /**
     * Print trailing commas wherever possible in multi-line comma-separated syntactic structures. Defaults to "all".
     *
     * @default all".
     * @schema JsFormatterConfiguration#trailingCommas
     */
    readonly trailingCommas?: TrailingCommas;
}
/**
 * Converts an object of type 'JsFormatterConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_JsFormatterConfiguration(obj: JsFormatterConfiguration | undefined): Record<string, any> | undefined;
/**
 * Indicates the type of runtime or transformation used for interpreting JSX.
 *
 * @schema JsxRuntime
 */
export declare enum JsxRuntime {
    /** transparent */
    TRANSPARENT = "transparent",
    /** reactClassic */
    REACT_CLASSIC = "reactClassic"
}
/**
 * Linter options specific to the JavaScript linter
 *
 * @schema JsLinterConfiguration
 */
export interface JsLinterConfiguration {
    /**
     * Control the linter for JavaScript (and its super languages) files.
     *
     * @schema JsLinterConfiguration#enabled
     */
    readonly enabled?: boolean;
}
/**
 * Converts an object of type 'JsLinterConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_JsLinterConfiguration(obj: JsLinterConfiguration | undefined): Record<string, any> | undefined;
/**
 * Options that changes how the JavaScript parser behaves
 *
 * @schema JsParserConfiguration
 */
export interface JsParserConfiguration {
    /**
     * Enables parsing of Grit metavariables. Defaults to `false`.
     *
     * @default false`.
     * @schema JsParserConfiguration#gritMetavariables
     */
    readonly gritMetavariables?: boolean;
    /**
     * When enabled, files like `.js`/`.mjs`/`.cjs` may contain JSX syntax.
     *
     * Defaults to `true`.
     *
     * @default true`.
     * @schema JsParserConfiguration#jsxEverywhere
     */
    readonly jsxEverywhere?: boolean;
    /**
     * It enables the experimental and unsafe parsing of parameter decorators
     *
     * These decorators belong to an old proposal, and they are subject to change.
     *
     * @schema JsParserConfiguration#unsafeParameterDecoratorsEnabled
     */
    readonly unsafeParameterDecoratorsEnabled?: boolean;
}
/**
 * Converts an object of type 'JsParserConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_JsParserConfiguration(obj: JsParserConfiguration | undefined): Record<string, any> | undefined;
/**
 * Linter options specific to the JSON linter
 *
 * @schema JsonAssistConfiguration
 */
export interface JsonAssistConfiguration {
    /**
     * Control the assist for JSON (and its super languages) files.
     *
     * @schema JsonAssistConfiguration#enabled
     */
    readonly enabled?: boolean;
}
/**
 * Converts an object of type 'JsonAssistConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_JsonAssistConfiguration(obj: JsonAssistConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema JsonFormatterConfiguration
 */
export interface JsonFormatterConfiguration {
    /**
     * Whether to insert spaces around brackets in object literals. Defaults to true.
     *
     * @default true.
     * @schema JsonFormatterConfiguration#bracketSpacing
     */
    readonly bracketSpacing?: boolean;
    /**
     * Control the formatter for JSON (and its super languages) files.
     *
     * @schema JsonFormatterConfiguration#enabled
     */
    readonly enabled?: boolean;
    /**
     * Whether to expand arrays and objects on multiple lines. When set to `auto`, object literals are formatted on multiple lines if the first property has a newline, and array literals are formatted on a single line if it fits in the line. When set to `always`, these literals are formatted on multiple lines, regardless of length of the list. When set to `never`, these literals are formatted on a single line if it fits in the line. When formatting `package.json`, Biome will use `always` unless configured otherwise. Defaults to "auto".
     *
     * @default auto".
     * @schema JsonFormatterConfiguration#expand
     */
    readonly expand?: Expand;
    /**
     * The indent style applied to JSON (and its super languages) files.
     *
     * @schema JsonFormatterConfiguration#indentStyle
     */
    readonly indentStyle?: IndentStyle;
    /**
     * The size of the indentation applied to JSON (and its super languages) files. Default to 2.
     *
     * @default 2.
     * @schema JsonFormatterConfiguration#indentWidth
     */
    readonly indentWidth?: number;
    /**
     * The type of line ending applied to JSON (and its super languages) files.
     *
     * @schema JsonFormatterConfiguration#lineEnding
     */
    readonly lineEnding?: LineEnding;
    /**
     * What's the max width of a line applied to JSON (and its super languages) files. Defaults to 80.
     *
     * @default 80.
     * @schema JsonFormatterConfiguration#lineWidth
     */
    readonly lineWidth?: number;
    /**
     * Print trailing commas wherever possible in multi-line comma-separated syntactic structures. Defaults to "none".
     *
     * @default none".
     * @schema JsonFormatterConfiguration#trailingCommas
     */
    readonly trailingCommas?: TrailingCommas2;
}
/**
 * Converts an object of type 'JsonFormatterConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_JsonFormatterConfiguration(obj: JsonFormatterConfiguration | undefined): Record<string, any> | undefined;
/**
 * Linter options specific to the JSON linter
 *
 * @schema JsonLinterConfiguration
 */
export interface JsonLinterConfiguration {
    /**
     * Control the linter for JSON (and its super languages) files.
     *
     * @schema JsonLinterConfiguration#enabled
     */
    readonly enabled?: boolean;
}
/**
 * Converts an object of type 'JsonLinterConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_JsonLinterConfiguration(obj: JsonLinterConfiguration | undefined): Record<string, any> | undefined;
/**
 * Options that changes how the JSON parser behaves
 *
 * @schema JsonParserConfiguration
 */
export interface JsonParserConfiguration {
    /**
     * Allow parsing comments in `.json` files
     *
     * @schema JsonParserConfiguration#allowComments
     */
    readonly allowComments?: boolean;
    /**
     * Allow parsing trailing commas in `.json` files
     *
     * @schema JsonParserConfiguration#allowTrailingCommas
     */
    readonly allowTrailingCommas?: boolean;
}
/**
 * Converts an object of type 'JsonParserConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_JsonParserConfiguration(obj: JsonParserConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema RuleDomainValue
 */
export declare enum RuleDomainValue {
    /** all */
    ALL = "all",
    /** none */
    NONE = "none",
    /** recommended */
    RECOMMENDED = "recommended"
}
/**
 * @schema Rules
 */
export interface Rules {
    /**
     * @schema Rules#a11y
     */
    readonly a11Y?: any;
    /**
     * @schema Rules#complexity
     */
    readonly complexity?: any;
    /**
     * @schema Rules#correctness
     */
    readonly correctness?: any;
    /**
     * @schema Rules#nursery
     */
    readonly nursery?: any;
    /**
     * @schema Rules#performance
     */
    readonly performance?: any;
    /**
     * It enables the lint rules recommended by Biome. `true` by default.
     *
     * @schema Rules#recommended
     */
    readonly recommended?: boolean;
    /**
     * @schema Rules#security
     */
    readonly security?: any;
    /**
     * @schema Rules#style
     */
    readonly style?: any;
    /**
     * @schema Rules#suspicious
     */
    readonly suspicious?: any;
}
/**
 * Converts an object of type 'Rules' to JSON representation.
 * @internal
 */
export declare function toJson_Rules(obj: Rules | undefined): Record<string, any> | undefined;
/**
 * @schema OverrideAssistConfiguration
 */
export interface OverrideAssistConfiguration {
    /**
     * List of actions
     *
     * @schema OverrideAssistConfiguration#actions
     */
    readonly actions?: Actions;
    /**
     * if `false`, it disables the feature and the assist won't be executed. `true` by default
     *
     * @schema OverrideAssistConfiguration#enabled
     */
    readonly enabled?: boolean;
}
/**
 * Converts an object of type 'OverrideAssistConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_OverrideAssistConfiguration(obj: OverrideAssistConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema OverrideFilesConfiguration
 */
export interface OverrideFilesConfiguration {
    /**
     * File size limit in bytes
     *
     * @schema OverrideFilesConfiguration#maxSize
     */
    readonly maxSize?: number;
}
/**
 * Converts an object of type 'OverrideFilesConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_OverrideFilesConfiguration(obj: OverrideFilesConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema OverrideFormatterConfiguration
 */
export interface OverrideFormatterConfiguration {
    /**
     * The attribute position style.
     *
     * @schema OverrideFormatterConfiguration#attributePosition
     */
    readonly attributePosition?: AttributePosition;
    /**
     * Put the `>` of a multi-line HTML or JSX element at the end of the last line instead of being alone on the next line (does not apply to self closing elements).
     *
     * @schema OverrideFormatterConfiguration#bracketSameLine
     */
    readonly bracketSameLine?: boolean;
    /**
     * Whether to insert spaces around brackets in object literals. Defaults to true.
     *
     * @default true.
     * @schema OverrideFormatterConfiguration#bracketSpacing
     */
    readonly bracketSpacing?: boolean;
    /**
     * @schema OverrideFormatterConfiguration#enabled
     */
    readonly enabled?: boolean;
    /**
     * Whether to expand arrays and objects on multiple lines. When set to `auto`, object literals are formatted on multiple lines if the first property has a newline, and array literals are formatted on a single line if it fits in the line. When set to `always`, these literals are formatted on multiple lines, regardless of length of the list. When set to `never`, these literals are formatted on a single line if it fits in the line. When formatting `package.json`, Biome will use `always` unless configured otherwise. Defaults to "auto".
     *
     * @default auto".
     * @schema OverrideFormatterConfiguration#expand
     */
    readonly expand?: Expand;
    /**
     * Stores whether formatting should be allowed to proceed if a given file has syntax errors
     *
     * @schema OverrideFormatterConfiguration#formatWithErrors
     */
    readonly formatWithErrors?: boolean;
    /**
     * The size of the indentation, 2 by default (deprecated, use `indent-width`)
     *
     * @schema OverrideFormatterConfiguration#indentSize
     */
    readonly indentSize?: number;
    /**
     * The indent style.
     *
     * @schema OverrideFormatterConfiguration#indentStyle
     */
    readonly indentStyle?: IndentStyle;
    /**
     * The size of the indentation, 2 by default
     *
     * @schema OverrideFormatterConfiguration#indentWidth
     */
    readonly indentWidth?: number;
    /**
     * The type of line ending.
     *
     * @schema OverrideFormatterConfiguration#lineEnding
     */
    readonly lineEnding?: LineEnding;
    /**
     * What's the max width of a line. Defaults to 80.
     *
     * @default 80.
     * @schema OverrideFormatterConfiguration#lineWidth
     */
    readonly lineWidth?: number;
}
/**
 * Converts an object of type 'OverrideFormatterConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_OverrideFormatterConfiguration(obj: OverrideFormatterConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema OverrideLinterConfiguration
 */
export interface OverrideLinterConfiguration {
    /**
     * List of rules
     *
     * @schema OverrideLinterConfiguration#domains
     */
    readonly domains?: {
        [key: string]: RuleDomainValue;
    };
    /**
     * if `false`, it disables the feature and the linter won't be executed. `true` by default
     *
     * @schema OverrideLinterConfiguration#enabled
     */
    readonly enabled?: boolean;
    /**
     * List of rules
     *
     * @schema OverrideLinterConfiguration#rules
     */
    readonly rules?: Rules;
}
/**
 * Converts an object of type 'OverrideLinterConfiguration' to JSON representation.
 * @internal
 */
export declare function toJson_OverrideLinterConfiguration(obj: OverrideLinterConfiguration | undefined): Record<string, any> | undefined;
/**
 * Integration with the git client as VCS
 *
 * @schema VcsClientKind
 */
export declare enum VcsClientKind {
    /** git */
    GIT = "git"
}
/**
 * A list of rules that belong to this group
 *
 * @schema Source
 */
export interface Source {
    /**
     * Provides a code action to sort the imports and exports in the file using a built-in or custom order.
     *
     * @schema Source#organizeImports
     */
    readonly organizeImports?: any;
    /**
     * Enables the recommended rules for this group
     *
     * @schema Source#recommended
     */
    readonly recommended?: boolean;
    /**
     * Enforce attribute sorting in JSX elements.
     *
     * @schema Source#useSortedAttributes
     */
    readonly useSortedAttributes?: any;
    /**
     * Sort the keys of a JSON object in natural order.
     *
     * @schema Source#useSortedKeys
     */
    readonly useSortedKeys?: any;
    /**
     * Enforce ordering of CSS properties and nested rules.
     *
     * @schema Source#useSortedProperties
     */
    readonly useSortedProperties?: any;
}
/**
 * Converts an object of type 'Source' to JSON representation.
 * @internal
 */
export declare function toJson_Source(obj: Source | undefined): Record<string, any> | undefined;
/**
 * @schema QuoteStyle
 */
export declare enum QuoteStyle {
    /** double */
    DOUBLE = "double",
    /** single */
    SINGLE = "single"
}
/**
 * Controls whether void-elements should be self closed
 *
 * @schema SelfCloseVoidElements
 */
export declare enum SelfCloseVoidElements {
    /** never */
    NEVER = "never",
    /** always */
    ALWAYS = "always"
}
/**
 * Whitespace sensitivity for HTML formatting.
 *
 * The following two cases won't produce the same output:
 *
 * |                |      html      |    output    | | -------------- | :------------: | :----------: | | with spaces    | `1<b> 2 </b>3` | 1<b> 2 </b>3 | | without spaces |  `1<b>2</b>3`  |  1<b>2</b>3  |
 *
 * This happens because whitespace is significant in inline elements.
 *
 * As a consequence of this, the formatter must format blocks that look like this (assume a small line width, <20): ```html <span>really long content</span> ``` as this, where the content hugs the tags: ```html <span >really long content</span > ```
 *
 * Note that this is only necessary for inline elements. Block elements do not have this restriction.
 *
 * @schema WhitespaceSensitivity
 */
export declare enum WhitespaceSensitivity {
    /** css */
    CSS = "css",
    /** strict */
    STRICT = "strict",
    /** ignore */
    IGNORE = "ignore"
}
/**
 * @schema ArrowParentheses
 */
export declare enum ArrowParentheses {
    /** always */
    ALWAYS = "always",
    /** asNeeded */
    AS_NEEDED = "asNeeded"
}
/**
 * @schema OperatorLinebreak
 */
export declare enum OperatorLinebreak {
    /** after */
    AFTER = "after",
    /** before */
    BEFORE = "before"
}
/**
 * @schema QuoteProperties
 */
export declare enum QuoteProperties {
    /** asNeeded */
    AS_NEEDED = "asNeeded",
    /** preserve */
    PRESERVE = "preserve"
}
/**
 * @schema Semicolons
 */
export declare enum Semicolons {
    /** always */
    ALWAYS = "always",
    /** asNeeded */
    AS_NEEDED = "asNeeded"
}
/**
 * Print trailing commas wherever possible in multi-line comma-separated syntactic structures.
 *
 * @schema TrailingCommas
 */
export declare enum TrailingCommas {
    /** all */
    ALL = "all",
    /** es5 */
    ES5 = "es5",
    /** none */
    NONE = "none"
}
/**
 * @schema TrailingCommas2
 */
export declare enum TrailingCommas2 {
    /** none */
    NONE = "none",
    /** all */
    ALL = "all"
}
