"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrailingCommas2 = exports.TrailingCommas = exports.Semicolons = exports.QuoteProperties = exports.OperatorLinebreak = exports.ArrowParentheses = exports.WhitespaceSensitivity = exports.SelfCloseVoidElements = exports.QuoteStyle = exports.VcsClientKind = exports.RuleDomainValue = exports.JsxRuntime = exports.LineEnding = exports.IndentStyle = exports.Expand = exports.AttributePosition = void 0;
exports.toJson_BiomeConfiguration = toJson_BiomeConfiguration;
exports.toJson_AssistConfiguration = toJson_AssistConfiguration;
exports.toJson_CssConfiguration = toJson_CssConfiguration;
exports.toJson_FilesConfiguration = toJson_FilesConfiguration;
exports.toJson_FormatterConfiguration = toJson_FormatterConfiguration;
exports.toJson_GraphqlConfiguration = toJson_GraphqlConfiguration;
exports.toJson_GritConfiguration = toJson_GritConfiguration;
exports.toJson_HtmlConfiguration = toJson_HtmlConfiguration;
exports.toJson_JsConfiguration = toJson_JsConfiguration;
exports.toJson_JsonConfiguration = toJson_JsonConfiguration;
exports.toJson_LinterConfiguration = toJson_LinterConfiguration;
exports.toJson_OverridePattern = toJson_OverridePattern;
exports.toJson_VcsConfiguration = toJson_VcsConfiguration;
exports.toJson_Actions = toJson_Actions;
exports.toJson_CssAssistConfiguration = toJson_CssAssistConfiguration;
exports.toJson_CssFormatterConfiguration = toJson_CssFormatterConfiguration;
exports.toJson_CssLinterConfiguration = toJson_CssLinterConfiguration;
exports.toJson_CssParserConfiguration = toJson_CssParserConfiguration;
exports.toJson_GraphqlAssistConfiguration = toJson_GraphqlAssistConfiguration;
exports.toJson_GraphqlFormatterConfiguration = toJson_GraphqlFormatterConfiguration;
exports.toJson_GraphqlLinterConfiguration = toJson_GraphqlLinterConfiguration;
exports.toJson_GritAssistConfiguration = toJson_GritAssistConfiguration;
exports.toJson_GritFormatterConfiguration = toJson_GritFormatterConfiguration;
exports.toJson_GritLinterConfiguration = toJson_GritLinterConfiguration;
exports.toJson_HtmlFormatterConfiguration = toJson_HtmlFormatterConfiguration;
exports.toJson_HtmlParserConfiguration = toJson_HtmlParserConfiguration;
exports.toJson_JsAssistConfiguration = toJson_JsAssistConfiguration;
exports.toJson_JsFormatterConfiguration = toJson_JsFormatterConfiguration;
exports.toJson_JsLinterConfiguration = toJson_JsLinterConfiguration;
exports.toJson_JsParserConfiguration = toJson_JsParserConfiguration;
exports.toJson_JsonAssistConfiguration = toJson_JsonAssistConfiguration;
exports.toJson_JsonFormatterConfiguration = toJson_JsonFormatterConfiguration;
exports.toJson_JsonLinterConfiguration = toJson_JsonLinterConfiguration;
exports.toJson_JsonParserConfiguration = toJson_JsonParserConfiguration;
exports.toJson_Rules = toJson_Rules;
exports.toJson_OverrideAssistConfiguration = toJson_OverrideAssistConfiguration;
exports.toJson_OverrideFilesConfiguration = toJson_OverrideFilesConfiguration;
exports.toJson_OverrideFormatterConfiguration = toJson_OverrideFormatterConfiguration;
exports.toJson_OverrideLinterConfiguration = toJson_OverrideLinterConfiguration;
exports.toJson_Source = toJson_Source;
/**
 * Converts an object of type 'BiomeConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_BiomeConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        '$schema': obj.schema,
        'assist': toJson_AssistConfiguration(obj.assist),
        'css': toJson_CssConfiguration(obj.css),
        'extends': obj.extends?.map(y => y),
        'files': toJson_FilesConfiguration(obj.files),
        'formatter': toJson_FormatterConfiguration(obj.formatter),
        'graphql': toJson_GraphqlConfiguration(obj.graphql),
        'grit': toJson_GritConfiguration(obj.grit),
        'html': toJson_HtmlConfiguration(obj.html),
        'javascript': toJson_JsConfiguration(obj.javascript),
        'json': toJson_JsonConfiguration(obj.json),
        'linter': toJson_LinterConfiguration(obj.linter),
        'overrides': obj.overrides?.map(y => toJson_OverridePattern(y)),
        'plugins': obj.plugins?.map(y => y),
        'root': obj.root,
        'vcs': toJson_VcsConfiguration(obj.vcs),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'AssistConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_AssistConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'actions': toJson_Actions(obj.actions),
        'enabled': obj.enabled,
        'includes': obj.includes?.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'CssConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_CssConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'assist': toJson_CssAssistConfiguration(obj.assist),
        'formatter': toJson_CssFormatterConfiguration(obj.formatter),
        'globals': obj.globals?.map(y => y),
        'linter': toJson_CssLinterConfiguration(obj.linter),
        'parser': toJson_CssParserConfiguration(obj.parser),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'FilesConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_FilesConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'experimentalScannerIgnores': obj.experimentalScannerIgnores?.map(y => y),
        'ignoreUnknown': obj.ignoreUnknown,
        'includes': obj.includes?.map(y => y),
        'maxSize': obj.maxSize,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'FormatterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_FormatterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'attributePosition': obj.attributePosition,
        'bracketSameLine': obj.bracketSameLine,
        'bracketSpacing': obj.bracketSpacing,
        'enabled': obj.enabled,
        'expand': obj.expand,
        'formatWithErrors': obj.formatWithErrors,
        'includes': obj.includes?.map(y => y),
        'indentStyle': obj.indentStyle,
        'indentWidth': obj.indentWidth,
        'lineEnding': obj.lineEnding,
        'lineWidth': obj.lineWidth,
        'useEditorconfig': obj.useEditorconfig,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'GraphqlConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_GraphqlConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'assist': toJson_GraphqlAssistConfiguration(obj.assist),
        'formatter': toJson_GraphqlFormatterConfiguration(obj.formatter),
        'linter': toJson_GraphqlLinterConfiguration(obj.linter),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'GritConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_GritConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'assist': toJson_GritAssistConfiguration(obj.assist),
        'formatter': toJson_GritFormatterConfiguration(obj.formatter),
        'linter': toJson_GritLinterConfiguration(obj.linter),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'HtmlConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_HtmlConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'formatter': toJson_HtmlFormatterConfiguration(obj.formatter),
        'parser': toJson_HtmlParserConfiguration(obj.parser),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'JsConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'assist': toJson_JsAssistConfiguration(obj.assist),
        'formatter': toJson_JsFormatterConfiguration(obj.formatter),
        'globals': obj.globals?.map(y => y),
        'jsxRuntime': obj.jsxRuntime,
        'linter': toJson_JsLinterConfiguration(obj.linter),
        'parser': toJson_JsParserConfiguration(obj.parser),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'JsonConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsonConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'assist': toJson_JsonAssistConfiguration(obj.assist),
        'formatter': toJson_JsonFormatterConfiguration(obj.formatter),
        'linter': toJson_JsonLinterConfiguration(obj.linter),
        'parser': toJson_JsonParserConfiguration(obj.parser),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'LinterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_LinterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'domains': ((obj.domains) === undefined) ? undefined : (Object.entries(obj.domains).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {})),
        'enabled': obj.enabled,
        'includes': obj.includes?.map(y => y),
        'rules': toJson_Rules(obj.rules),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'OverridePattern' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_OverridePattern(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'assist': toJson_OverrideAssistConfiguration(obj.assist),
        'css': toJson_CssConfiguration(obj.css),
        'files': toJson_OverrideFilesConfiguration(obj.files),
        'formatter': toJson_OverrideFormatterConfiguration(obj.formatter),
        'graphql': toJson_GraphqlConfiguration(obj.graphql),
        'grit': toJson_GritConfiguration(obj.grit),
        'html': toJson_HtmlConfiguration(obj.html),
        'includes': obj.includes?.map(y => y),
        'javascript': toJson_JsConfiguration(obj.javascript),
        'json': toJson_JsonConfiguration(obj.json),
        'linter': toJson_OverrideLinterConfiguration(obj.linter),
        'plugins': obj.plugins?.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'VcsConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_VcsConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'clientKind': obj.clientKind,
        'defaultBranch': obj.defaultBranch,
        'enabled': obj.enabled,
        'root': obj.root,
        'useIgnoreFile': obj.useIgnoreFile,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'Actions' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_Actions(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'recommended': obj.recommended,
        'source': toJson_Source(obj.source),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'CssAssistConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_CssAssistConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'CssFormatterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_CssFormatterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
        'indentStyle': obj.indentStyle,
        'indentWidth': obj.indentWidth,
        'lineEnding': obj.lineEnding,
        'lineWidth': obj.lineWidth,
        'quoteStyle': obj.quoteStyle,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'CssLinterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_CssLinterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'CssParserConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_CssParserConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'allowWrongLineComments': obj.allowWrongLineComments,
        'cssModules': obj.cssModules,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/* eslint-enable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
/**
 * @schema AttributePosition
 */
var AttributePosition;
(function (AttributePosition) {
    /** auto */
    AttributePosition["AUTO"] = "auto";
    /** multiline */
    AttributePosition["MULTILINE"] = "multiline";
})(AttributePosition || (exports.AttributePosition = AttributePosition = {}));
/**
 * @schema Expand
 */
var Expand;
(function (Expand) {
    /** auto */
    Expand["AUTO"] = "auto";
    /** always */
    Expand["ALWAYS"] = "always";
    /** never */
    Expand["NEVER"] = "never";
})(Expand || (exports.Expand = Expand = {}));
/**
 * @schema IndentStyle
 */
var IndentStyle;
(function (IndentStyle) {
    /** tab */
    IndentStyle["TAB"] = "tab";
    /** space */
    IndentStyle["SPACE"] = "space";
})(IndentStyle || (exports.IndentStyle = IndentStyle = {}));
/**
 * @schema LineEnding
 */
var LineEnding;
(function (LineEnding) {
    /** lf */
    LineEnding["LF"] = "lf";
    /** crlf */
    LineEnding["CRLF"] = "crlf";
    /** cr */
    LineEnding["CR"] = "cr";
})(LineEnding || (exports.LineEnding = LineEnding = {}));
/**
 * Converts an object of type 'GraphqlAssistConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_GraphqlAssistConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'GraphqlFormatterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_GraphqlFormatterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'bracketSpacing': obj.bracketSpacing,
        'enabled': obj.enabled,
        'indentStyle': obj.indentStyle,
        'indentWidth': obj.indentWidth,
        'lineEnding': obj.lineEnding,
        'lineWidth': obj.lineWidth,
        'quoteStyle': obj.quoteStyle,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'GraphqlLinterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_GraphqlLinterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'GritAssistConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_GritAssistConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'GritFormatterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_GritFormatterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
        'indentStyle': obj.indentStyle,
        'indentWidth': obj.indentWidth,
        'lineEnding': obj.lineEnding,
        'lineWidth': obj.lineWidth,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'GritLinterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_GritLinterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'HtmlFormatterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_HtmlFormatterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'attributePosition': obj.attributePosition,
        'bracketSameLine': obj.bracketSameLine,
        'enabled': obj.enabled,
        'indentScriptAndStyle': obj.indentScriptAndStyle,
        'indentStyle': obj.indentStyle,
        'indentWidth': obj.indentWidth,
        'lineEnding': obj.lineEnding,
        'lineWidth': obj.lineWidth,
        'selfCloseVoidElements': obj.selfCloseVoidElements,
        'whitespaceSensitivity': obj.whitespaceSensitivity,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'HtmlParserConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_HtmlParserConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'interpolation': obj.interpolation,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'JsAssistConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsAssistConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'JsFormatterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsFormatterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'arrowParentheses': obj.arrowParentheses,
        'attributePosition': obj.attributePosition,
        'bracketSameLine': obj.bracketSameLine,
        'bracketSpacing': obj.bracketSpacing,
        'enabled': obj.enabled,
        'expand': obj.expand,
        'indentStyle': obj.indentStyle,
        'indentWidth': obj.indentWidth,
        'jsxQuoteStyle': obj.jsxQuoteStyle,
        'lineEnding': obj.lineEnding,
        'lineWidth': obj.lineWidth,
        'operatorLinebreak': obj.operatorLinebreak,
        'quoteProperties': obj.quoteProperties,
        'quoteStyle': obj.quoteStyle,
        'semicolons': obj.semicolons,
        'trailingCommas': obj.trailingCommas,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/* eslint-enable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
/**
 * Indicates the type of runtime or transformation used for interpreting JSX.
 *
 * @schema JsxRuntime
 */
var JsxRuntime;
(function (JsxRuntime) {
    /** transparent */
    JsxRuntime["TRANSPARENT"] = "transparent";
    /** reactClassic */
    JsxRuntime["REACT_CLASSIC"] = "reactClassic";
})(JsxRuntime || (exports.JsxRuntime = JsxRuntime = {}));
/**
 * Converts an object of type 'JsLinterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsLinterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'JsParserConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsParserConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'gritMetavariables': obj.gritMetavariables,
        'jsxEverywhere': obj.jsxEverywhere,
        'unsafeParameterDecoratorsEnabled': obj.unsafeParameterDecoratorsEnabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'JsonAssistConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsonAssistConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'JsonFormatterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsonFormatterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'bracketSpacing': obj.bracketSpacing,
        'enabled': obj.enabled,
        'expand': obj.expand,
        'indentStyle': obj.indentStyle,
        'indentWidth': obj.indentWidth,
        'lineEnding': obj.lineEnding,
        'lineWidth': obj.lineWidth,
        'trailingCommas': obj.trailingCommas,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'JsonLinterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsonLinterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'JsonParserConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsonParserConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'allowComments': obj.allowComments,
        'allowTrailingCommas': obj.allowTrailingCommas,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/* eslint-enable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
/**
 * @schema RuleDomainValue
 */
var RuleDomainValue;
(function (RuleDomainValue) {
    /** all */
    RuleDomainValue["ALL"] = "all";
    /** none */
    RuleDomainValue["NONE"] = "none";
    /** recommended */
    RuleDomainValue["RECOMMENDED"] = "recommended";
})(RuleDomainValue || (exports.RuleDomainValue = RuleDomainValue = {}));
/**
 * Converts an object of type 'Rules' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_Rules(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'a11y': obj.a11Y,
        'complexity': obj.complexity,
        'correctness': obj.correctness,
        'nursery': obj.nursery,
        'performance': obj.performance,
        'recommended': obj.recommended,
        'security': obj.security,
        'style': obj.style,
        'suspicious': obj.suspicious,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'OverrideAssistConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_OverrideAssistConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'actions': toJson_Actions(obj.actions),
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'OverrideFilesConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_OverrideFilesConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'maxSize': obj.maxSize,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'OverrideFormatterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_OverrideFormatterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'attributePosition': obj.attributePosition,
        'bracketSameLine': obj.bracketSameLine,
        'bracketSpacing': obj.bracketSpacing,
        'enabled': obj.enabled,
        'expand': obj.expand,
        'formatWithErrors': obj.formatWithErrors,
        'indentSize': obj.indentSize,
        'indentStyle': obj.indentStyle,
        'indentWidth': obj.indentWidth,
        'lineEnding': obj.lineEnding,
        'lineWidth': obj.lineWidth,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'OverrideLinterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_OverrideLinterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'domains': ((obj.domains) === undefined) ? undefined : (Object.entries(obj.domains).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {})),
        'enabled': obj.enabled,
        'rules': toJson_Rules(obj.rules),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/* eslint-enable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
/**
 * Integration with the git client as VCS
 *
 * @schema VcsClientKind
 */
var VcsClientKind;
(function (VcsClientKind) {
    /** git */
    VcsClientKind["GIT"] = "git";
})(VcsClientKind || (exports.VcsClientKind = VcsClientKind = {}));
/**
 * Converts an object of type 'Source' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_Source(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'organizeImports': obj.organizeImports,
        'recommended': obj.recommended,
        'useSortedAttributes': obj.useSortedAttributes,
        'useSortedKeys': obj.useSortedKeys,
        'useSortedProperties': obj.useSortedProperties,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/* eslint-enable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
/**
 * @schema QuoteStyle
 */
var QuoteStyle;
(function (QuoteStyle) {
    /** double */
    QuoteStyle["DOUBLE"] = "double";
    /** single */
    QuoteStyle["SINGLE"] = "single";
})(QuoteStyle || (exports.QuoteStyle = QuoteStyle = {}));
/**
 * Controls whether void-elements should be self closed
 *
 * @schema SelfCloseVoidElements
 */
var SelfCloseVoidElements;
(function (SelfCloseVoidElements) {
    /** never */
    SelfCloseVoidElements["NEVER"] = "never";
    /** always */
    SelfCloseVoidElements["ALWAYS"] = "always";
})(SelfCloseVoidElements || (exports.SelfCloseVoidElements = SelfCloseVoidElements = {}));
/**
 * Whitespace sensitivity for HTML formatting.
 *
 * The following two cases won't produce the same output:
 *
 * |                |      html      |    output    | | -------------- | :------------: | :----------: | | with spaces    | `1<b> 2 </b>3` | 1<b> 2 </b>3 | | without spaces |  `1<b>2</b>3`  |  1<b>2</b>3  |
 *
 * This happens because whitespace is significant in inline elements.
 *
 * As a consequence of this, the formatter must format blocks that look like this (assume a small line width, <20): ```html <span>really long content</span> ``` as this, where the content hugs the tags: ```html <span >really long content</span > ```
 *
 * Note that this is only necessary for inline elements. Block elements do not have this restriction.
 *
 * @schema WhitespaceSensitivity
 */
var WhitespaceSensitivity;
(function (WhitespaceSensitivity) {
    /** css */
    WhitespaceSensitivity["CSS"] = "css";
    /** strict */
    WhitespaceSensitivity["STRICT"] = "strict";
    /** ignore */
    WhitespaceSensitivity["IGNORE"] = "ignore";
})(WhitespaceSensitivity || (exports.WhitespaceSensitivity = WhitespaceSensitivity = {}));
/**
 * @schema ArrowParentheses
 */
var ArrowParentheses;
(function (ArrowParentheses) {
    /** always */
    ArrowParentheses["ALWAYS"] = "always";
    /** asNeeded */
    ArrowParentheses["AS_NEEDED"] = "asNeeded";
})(ArrowParentheses || (exports.ArrowParentheses = ArrowParentheses = {}));
/**
 * @schema OperatorLinebreak
 */
var OperatorLinebreak;
(function (OperatorLinebreak) {
    /** after */
    OperatorLinebreak["AFTER"] = "after";
    /** before */
    OperatorLinebreak["BEFORE"] = "before";
})(OperatorLinebreak || (exports.OperatorLinebreak = OperatorLinebreak = {}));
/**
 * @schema QuoteProperties
 */
var QuoteProperties;
(function (QuoteProperties) {
    /** asNeeded */
    QuoteProperties["AS_NEEDED"] = "asNeeded";
    /** preserve */
    QuoteProperties["PRESERVE"] = "preserve";
})(QuoteProperties || (exports.QuoteProperties = QuoteProperties = {}));
/**
 * @schema Semicolons
 */
var Semicolons;
(function (Semicolons) {
    /** always */
    Semicolons["ALWAYS"] = "always";
    /** asNeeded */
    Semicolons["AS_NEEDED"] = "asNeeded";
})(Semicolons || (exports.Semicolons = Semicolons = {}));
/**
 * Print trailing commas wherever possible in multi-line comma-separated syntactic structures.
 *
 * @schema TrailingCommas
 */
var TrailingCommas;
(function (TrailingCommas) {
    /** all */
    TrailingCommas["ALL"] = "all";
    /** es5 */
    TrailingCommas["ES5"] = "es5";
    /** none */
    TrailingCommas["NONE"] = "none";
})(TrailingCommas || (exports.TrailingCommas = TrailingCommas = {}));
/**
 * @schema TrailingCommas2
 */
var TrailingCommas2;
(function (TrailingCommas2) {
    /** none */
    TrailingCommas2["NONE"] = "none";
    /** all */
    TrailingCommas2["ALL"] = "all";
})(TrailingCommas2 || (exports.TrailingCommas2 = TrailingCommas2 = {}));
//# sourceMappingURL=data:application/json;base64,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