"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Testing = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const synth_1 = require("./util/synth");
/**
 * A Testing static class with a .synth helper for getting a snapshots of construct outputs.
 * Useful for snapshot testing with Jest.
 *
 * @example `expect(Testing.synth(someProject)).toMatchSnapshot()`
 */
class Testing {
    /**
     * Produces a simple JS object that represents the contents of the projects with field names being file paths.
     * @param project the project to produce a snapshot for
     * @return { [filename:string]: any }
     */
    static synth(project, options = {}) {
        return (0, synth_1.synthSnapshot)(project, options);
    }
    constructor() { } // utility
}
exports.Testing = Testing;
_a = JSII_RTTI_SYMBOL_1;
Testing[_a] = { fqn: "projen.Testing", version: "0.96.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdGluZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy90ZXN0aW5nLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQ0Esd0NBQThEO0FBRTlEOzs7OztHQUtHO0FBQ0gsTUFBYSxPQUFPO0lBQ2xCOzs7O09BSUc7SUFDSSxNQUFNLENBQUMsS0FBSyxDQUNqQixPQUFnQixFQUNoQixVQUEyQixFQUFFO1FBRTdCLE9BQU8sSUFBQSxxQkFBYSxFQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQsZ0JBQXVCLENBQUMsQ0FBQyxVQUFVOztBQWJyQywwQkFjQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFByb2plY3QgfSBmcm9tIFwiLi9wcm9qZWN0XCI7XG5pbXBvcnQgeyBTbmFwc2hvdE9wdGlvbnMsIHN5bnRoU25hcHNob3QgfSBmcm9tIFwiLi91dGlsL3N5bnRoXCI7XG5cbi8qKlxuICogQSBUZXN0aW5nIHN0YXRpYyBjbGFzcyB3aXRoIGEgLnN5bnRoIGhlbHBlciBmb3IgZ2V0dGluZyBhIHNuYXBzaG90cyBvZiBjb25zdHJ1Y3Qgb3V0cHV0cy5cbiAqIFVzZWZ1bCBmb3Igc25hcHNob3QgdGVzdGluZyB3aXRoIEplc3QuXG4gKlxuICogQGV4YW1wbGUgYGV4cGVjdChUZXN0aW5nLnN5bnRoKHNvbWVQcm9qZWN0KSkudG9NYXRjaFNuYXBzaG90KClgXG4gKi9cbmV4cG9ydCBjbGFzcyBUZXN0aW5nIHtcbiAgLyoqXG4gICAqIFByb2R1Y2VzIGEgc2ltcGxlIEpTIG9iamVjdCB0aGF0IHJlcHJlc2VudHMgdGhlIGNvbnRlbnRzIG9mIHRoZSBwcm9qZWN0cyB3aXRoIGZpZWxkIG5hbWVzIGJlaW5nIGZpbGUgcGF0aHMuXG4gICAqIEBwYXJhbSBwcm9qZWN0IHRoZSBwcm9qZWN0IHRvIHByb2R1Y2UgYSBzbmFwc2hvdCBmb3JcbiAgICogQHJldHVybiB7IFtmaWxlbmFtZTpzdHJpbmddOiBhbnkgfVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBzeW50aChcbiAgICBwcm9qZWN0OiBQcm9qZWN0LFxuICAgIG9wdGlvbnM6IFNuYXBzaG90T3B0aW9ucyA9IHt9XG4gICk6IFJlY29yZDxzdHJpbmcsIGFueT4ge1xuICAgIHJldHVybiBzeW50aFNuYXBzaG90KHByb2plY3QsIG9wdGlvbnMpO1xuICB9XG5cbiAgcHJpdmF0ZSBjb25zdHJ1Y3RvcigpIHt9IC8vIHV0aWxpdHlcbn1cblxuZXhwb3J0IHsgU25hcHNob3RPcHRpb25zIH0gZnJvbSBcIi4vdXRpbC9zeW50aFwiO1xuIl19