"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeRecommendedExtensions = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const json_1 = require("../json");
/**
 * VS Code Workspace recommended extensions
 * Source: https://code.visualstudio.com/docs/editor/extension-marketplace#_workspace-recommended-extensions
 */
class VsCodeRecommendedExtensions extends component_1.Component {
    constructor(vscode) {
        super(vscode.project);
        /**
         * List of extensions which should be recommended for users of this workspace.
         * The identifier of an extension is always '${publisher}.${name}'. For example: 'ms-python.python'.
         *
         * @default - no recommendations are made
         */
        this.recommendations = [];
        /**
         * List of extensions recommended by VS Code that should not be recommended for users of this workspace.
         * The identifier of an extension is always '${publisher}.${name}'. For example: 'ms-python.python'.
         *
         * @default - no recommendations are marked unwanted
         */
        this.unwantedRecommendations = [];
        this.file = new json_1.JsonFile(vscode.project, ".vscode/extensions.json", {
            omitEmpty: true,
            allowComments: true,
            obj: {
                recommendations: this.recommendations,
                unwantedRecommendations: this.unwantedRecommendations,
            },
        });
    }
    /**
     * Adds a list of VS Code extensions as recommendations for this workspace.
     *
     * @param extensions The extension IDs
     */
    addRecommendations(...extensions) {
        this.recommendations.push(...extensions);
    }
    /**
     * Marks a list of VS Code extensions as unwanted recommendations for this workspace.
     * VS Code should not be recommend these extensions for users of this workspace.
     *
     * @param extensions The extension IDs
     */
    addUnwantedRecommendations(...extensions) {
        this.unwantedRecommendations.push(...extensions);
    }
}
exports.VsCodeRecommendedExtensions = VsCodeRecommendedExtensions;
_a = JSII_RTTI_SYMBOL_1;
VsCodeRecommendedExtensions[_a] = { fqn: "projen.vscode.VsCodeRecommendedExtensions", version: "0.96.2" };
//# sourceMappingURL=data:application/json;base64,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