"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NextComponent = exports.NextJsTypeScriptProject = exports.NextJsProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const postcss_1 = require("./postcss");
const component_1 = require("../component");
const javascript_1 = require("../javascript");
const sample_file_1 = require("../sample-file");
const typescript_1 = require("../typescript");
const util_1 = require("../util");
const MINIMUM_NEXT_JS_NODE_VERSION = "16.14.0"; // https://nextjs.org/docs/pages/building-your-application/upgrading/version-13
/**
 * Next.js project using JavaScript.
 *
 * @pjid nextjs
 */
class NextJsProject extends javascript_1.NodeProject {
    constructor(options) {
        super({
            jest: false,
            minNodeVersion: MINIMUM_NEXT_JS_NODE_VERSION,
            workflowNodeVersion: "lts/*",
            ...options,
        });
        this.srcdir = options.srcdir ?? "pages";
        this.assetsdir = options.assetsdir ?? "public";
        this.tailwind = options.tailwind ?? true;
        new NextComponent(this, { typescript: false, tailwind: this.tailwind });
        // generate sample code in `pages` and `public` if these directories are empty or non-existent.
        if (options.sampleCode ?? true) {
            new NextSampleCode(this, {
                fileExt: "js",
                srcdir: this.srcdir,
                assetsdir: this.assetsdir,
                tailwind: this.tailwind,
            });
        }
    }
}
exports.NextJsProject = NextJsProject;
_a = JSII_RTTI_SYMBOL_1;
NextJsProject[_a] = { fqn: "projen.web.NextJsProject", version: "0.96.2" };
/**
 * Next.js project using TypeScript.
 *
 * @pjid nextjs-ts
 */
class NextJsTypeScriptProject extends typescript_1.TypeScriptAppProject {
    constructor(options) {
        const defaultOptions = {
            srcdir: "pages",
            eslint: false,
            minNodeVersion: MINIMUM_NEXT_JS_NODE_VERSION,
            jest: false,
            workflowNodeVersion: "lts/*",
            tsconfig: {
                include: [
                    "**/*.ts",
                    "**/*.tsx",
                    "next-env.d.ts",
                    ".next/types/**/*.ts",
                ],
                compilerOptions: {
                    // required by Next.js - https://github.com/vercel/next.js/blob/canary/packages/create-next-app/templates/app/ts/tsconfig.json
                    esModuleInterop: true,
                    module: "esnext",
                    moduleResolution: javascript_1.TypeScriptModuleResolution.BUNDLER,
                    isolatedModules: true,
                    resolveJsonModule: true,
                    jsx: javascript_1.TypeScriptJsxMode.PRESERVE,
                    // recommended by Next.js
                    allowJs: true,
                    skipLibCheck: true,
                    forceConsistentCasingInFileNames: true,
                    noEmit: true,
                    lib: ["dom", "dom.iterable", "esnext"],
                    strict: true,
                    target: "es5",
                    incremental: true,
                    plugins: [
                        {
                            name: "next",
                        },
                    ],
                    paths: {
                        "@/*": ["./*"],
                    },
                },
            },
            // ts-config for projen default needs to be overridden to commonjs
            // https://stackoverflow.com/questions/67089549/is-it-ok-to-use-module-commonjs-in-tsconfig-json-for-a-next-js-project-usi
            tsconfigDev: {
                compilerOptions: {
                    module: "commonjs",
                },
            },
        };
        // never generate default TypeScript sample code, since this class provides its own
        super((0, util_1.deepMerge)([
            defaultOptions,
            options,
            { sampleCode: false },
        ]));
        this.srcdir = options.srcdir ?? "pages";
        this.assetsdir = options.assetsdir ?? "public";
        this.tailwind = options.tailwind ?? true;
        new NextComponent(this, { typescript: true, tailwind: this.tailwind });
        // 'next build' command fails if tsconfig.json is immutable
        if (this.tsconfig) {
            this.tsconfig.file.readonly = false;
        }
        // generate sample code in `pages` and `public` if these directories are empty or non-existent.
        if (options.sampleCode ?? true) {
            new NextSampleCode(this, {
                fileExt: "tsx",
                srcdir: this.srcdir,
                assetsdir: this.assetsdir,
                tailwind: this.tailwind,
            });
        }
    }
}
exports.NextJsTypeScriptProject = NextJsTypeScriptProject;
_b = JSII_RTTI_SYMBOL_1;
NextJsTypeScriptProject[_b] = { fqn: "projen.web.NextJsTypeScriptProject", version: "0.96.2" };
class NextComponent extends component_1.Component {
    constructor(project, options) {
        super(project);
        this.typescript = options.typescript ?? false;
        this.tailwind = options.tailwind ?? true;
        project.addDeps("next", "react", "react-dom");
        if (this.typescript) {
            project.addDevDeps("@types/react", "@types/react-dom");
        }
        if (this.tailwind) {
            new postcss_1.PostCss(project, { tailwind: true });
        }
        // NextJS CLI commands, see: https://nextjs.org/docs/api-reference/cli
        project.addTask("dev", {
            description: "Starts the Next.js application in development mode",
            exec: "next dev",
        });
        project.compileTask.exec("next build");
        project.addTask("export", {
            description: "Exports the application for production deployment",
            exec: "next export",
        });
        project.addTask("server", {
            description: "Starts the Next.js application in production mode",
            exec: "next start",
        });
        project.addTask("telemetry", {
            description: "Checks the status of Next.js telemetry collection",
            exec: "next telemetry",
        });
        project.npmignore?.exclude("# Next.js", "/.next/");
        project.gitignore.exclude("# Next.js", "/.next/");
    }
}
exports.NextComponent = NextComponent;
_c = JSII_RTTI_SYMBOL_1;
NextComponent[_c] = { fqn: "projen.web.NextComponent", version: "0.96.2" };
class NextSampleCode extends component_1.Component {
    constructor(project, options) {
        super(project);
        this.fileExt = options.fileExt ?? "js";
        this.srcdir = options.srcdir;
        this.assetsdir = options.assetsdir;
        this.tailwind = options.tailwind;
        const indexJs = [
            'import Head from "next/head"',
            "",
            "export default function Home() {",
            "  return (",
            '    <div className="container">',
            "      <Head>",
            "        <title>Create Next App</title>",
            "      </Head>",
            "",
            "      <main>",
            '        <h1 className="title">',
            '          Welcome to <a href="https://nextjs.org">Next.js!</a>',
            "        </h1>",
            "",
            '        <p className="description">',
            "          Get started by editing <code>pages/index.js</code>",
            "        </p>",
            "",
            '        <div className="grid">',
            '          <a href="https://nextjs.org/docs" className="card">',
            "            <h3>Documentation &rarr;</h3>",
            "            <p>Find in-depth information about Next.js features and API.</p>",
            "          </a>",
            "",
            '          <a href="https://nextjs.org/learn" className="card">',
            "            <h3>Learn &rarr;</h3>",
            "            <p>Learn about Next.js in an interactive course with quizzes!</p>",
            "          </a>",
            "",
            "          <a",
            '            href="https://github.com/vercel/next.js/tree/master/examples"',
            '            className="card"',
            "          >",
            "            <h3>Examples &rarr;</h3>",
            "            <p>Discover and deploy boilerplate example Next.js projects.</p>",
            "          </a>",
            "",
            "          <a",
            '            href="https://vercel.com/import?filter=next.js&utm_source=create-next-app&utm_medium=default-template&utm_campaign=create-next-app"',
            '            className="card"',
            "          >",
            "            <h3>Deploy &rarr;</h3>",
            "            <p>",
            "              Instantly deploy your Next.js site to a public URL with Vercel.",
            "            </p>",
            "          </a>",
            "        </div>",
            "      </main>",
            "",
            "      <footer>",
            "        <a",
            '          href="https://vercel.com?utm_source=create-next-app&utm_medium=default-template&utm_campaign=create-next-app"',
            '          target="_blank"',
            '          rel="noopener noreferrer"',
            "        >",
            "          Powered by Vercel",
            '          <img src="/vercel.svg" alt="Vercel Logo" className="logo" />',
            "        </a>",
            "      </footer>",
            "",
            "      <style jsx>{`",
            "        .container {",
            "          min-height: 100vh;",
            "          padding: 0 0.5rem;",
            "          display: flex;",
            "          flex-direction: column;",
            "          justify-content: center;",
            "          align-items: center;",
            "        }",
            "",
            "        main {",
            "          padding: 5rem 0;",
            "          flex: 1;",
            "          display: flex;",
            "          flex-direction: column;",
            "          justify-content: center;",
            "          align-items: center;",
            "        }",
            "",
            "        footer {",
            "          width: 100%;",
            "          height: 100px;",
            "          border-top: 1px solid #eaeaea;",
            "          display: flex;",
            "          justify-content: center;",
            "          align-items: center;",
            "        }",
            "",
            "        footer img {",
            "          margin-left: 0.5rem;",
            "        }",
            "",
            "        footer a {",
            "          display: flex;",
            "          justify-content: center;",
            "          align-items: center;",
            "        }",
            "",
            "        a {",
            "          color: inherit;",
            "          text-decoration: none;",
            "        }",
            "",
            "        .title a {",
            "          color: #0070f3;",
            "          text-decoration: none;",
            "        }",
            "",
            "        .title a:hover,",
            "        .title a:focus,",
            "        .title a:active {",
            "          text-decoration: underline;",
            "        }",
            "",
            "        .title {",
            "          margin: 0;",
            "          line-height: 1.15;",
            "          font-size: 4rem;",
            "        }",
            "",
            "        .title,",
            "        .description {",
            "          text-align: center;",
            "        }",
            "",
            "        .description {",
            "          line-height: 1.5;",
            "          font-size: 1.5rem;",
            "        }",
            "",
            "        code {",
            "          background: #fafafa;",
            "          border-radius: 5px;",
            "          padding: 0.75rem;",
            "          font-size: 1.1rem;",
            "          font-family: Menlo, Monaco, Lucida Console, Liberation Mono,",
            "            DejaVu Sans Mono, Bitstream Vera Sans Mono, Courier New, monospace;",
            "        }",
            "",
            "        .grid {",
            "          display: flex;",
            "          align-items: center;",
            "          justify-content: center;",
            "          flex-wrap: wrap;",
            "",
            "          max-width: 800px;",
            "          margin-top: 3rem;",
            "        }",
            "",
            "        .card {",
            "          margin: 1rem;",
            "          flex-basis: 45%;",
            "          padding: 1.5rem;",
            "          text-align: left;",
            "          color: inherit;",
            "          text-decoration: none;",
            "          border: 1px solid #eaeaea;",
            "          border-radius: 10px;",
            "          transition: color 0.15s ease, border-color 0.15s ease;",
            "        }",
            "",
            "        .card:hover,",
            "        .card:focus,",
            "        .card:active {",
            "          color: #0070f3;",
            "          border-color: #0070f3;",
            "        }",
            "",
            "        .card h3 {",
            "          margin: 0 0 1rem 0;",
            "          font-size: 1.5rem;",
            "        }",
            "",
            "        .card p {",
            "          margin: 0;",
            "          font-size: 1.25rem;",
            "          line-height: 1.5;",
            "        }",
            "",
            "        .logo {",
            "          height: 1em;",
            "        }",
            "",
            "        @media (max-width: 600px) {",
            "          .grid {",
            "            width: 100%;",
            "            flex-direction: column;",
            "          }",
            "        }",
            "      `}</style>",
            "",
            "      <style jsx global>{`",
            "        html,",
            "        body {",
            "          padding: 0;",
            "          margin: 0;",
            "          font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Roboto,",
            "            Oxygen, Ubuntu, Cantarell, Fira Sans, Droid Sans, Helvetica Neue,",
            "            sans-serif;",
            "        }",
            "",
            "        * {",
            "          box-sizing: border-box;",
            "        }",
            "      `}</style>",
            "    </div>",
            "  )",
            "}",
            "",
        ];
        if (this.tailwind) {
            indexJs.unshift('import "tailwindcss/tailwind.css"');
        }
        const vercelSvg = [
            '<svg width="283" height="64" viewBox="0 0 283 64" fill="none" ',
            '    xmlns="http://www.w3.org/2000/svg">',
            '    <path d="M141.04 16c-11.04 0-19 7.2-19 18s8.96 18 20 18c6.67 0 12.55-2.64 16.19-7.09l-7.65-4.42c-2.02 2.21-5.09 3.5-8.54 3.5-4.79 0-8.86-2.5-10.37-6.5h28.02c.22-1.12.35-2.28.35-3.5 0-10.79-7.96-17.99-19-17.99zm-9.46 14.5c1.25-3.99 4.67-6.5 9.45-6.5 4.79 0 8.21 2.51 9.45 6.5h-18.9zM248.72 16c-11.04 0-19 7.2-19 18s8.96 18 20 18c6.67 0 12.55-2.64 16.19-7.09l-7.65-4.42c-2.02 2.21-5.09 3.5-8.54 3.5-4.79 0-8.86-2.5-10.37-6.5h28.02c.22-1.12.35-2.28.35-3.5 0-10.79-7.96-17.99-19-17.99zm-9.45 14.5c1.25-3.99 4.67-6.5 9.45-6.5 4.79 0 8.21 2.51 9.45 6.5h-18.9zM200.24 34c0 6 3.92 10 10 10 4.12 0 7.21-1.87 8.8-4.92l7.68 4.43c-3.18 5.3-9.14 8.49-16.48 8.49-11.05 0-19-7.2-19-18s7.96-18 19-18c7.34 0 13.29 3.19 16.48 8.49l-7.68 4.43c-1.59-3.05-4.68-4.92-8.8-4.92-6.07 0-10 4-10 10zm82.48-29v46h-9V5h9zM36.95 0L73.9 64H0L36.95 0zm92.38 5l-27.71 48L73.91 5H84.3l17.32 30 17.32-30h10.39zm58.91 12v9.69c-1-.29-2.06-.49-3.2-.49-5.81 0-10 4-10 10V51h-9V17h9v9.2c0-5.08 5.91-9.2 13.2-9.2z" fill="#000"/>',
            "</svg>",
        ];
        new sample_file_1.SampleDir(project, this.srcdir, {
            files: {
                ["index." + this.fileExt]: indexJs.join("\n"),
            },
        });
        new sample_file_1.SampleDir(project, this.assetsdir, {
            files: {
                "vercel.svg": vercelSvg.join("\n"),
            },
        });
        new sample_file_1.SampleFile(project, "next-env.d.ts", {
            contents: [
                '/// <reference types="next" />',
                '/// <reference types="next/types/global" />',
                '/// <reference types="next/image-types/global" />',
                "// NOTE: This file should not be edited",
                "// see https://nextjs.org/docs/basic-features/typescript for more information.",
                "",
            ].join("\n"),
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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